/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

// be included itself

//============================================================
//= property names
//============================================================
#define PROPERTY_URL "URL"
#define PROPERTY_INFO "Info"
#define PROPERTY_SETTINGS "Settings"
#define PROPERTY_ISPASSWORDREQUIRED "IsPasswordRequired"
#define PROPERTY_TABLEFILTER "TableFilter"
#define PROPERTY_TABLETYPEFILTER "TableTypeFilter"
#define PROPERTY_NAME "Name"
#define PROPERTY_SCHEMANAME "SchemaName"
#define PROPERTY_CATALOGNAME "CatalogName"
#define PROPERTY_PRIVILEGES "Privileges"
#define PROPERTY_ESCAPE_PROCESSING "EscapeProcessing"
#define PROPERTY_COMMAND "Command"
#define PROPERTY_TYPE "Type"
#define PROPERTY_TYPENAME "TypeName"
#define PROPERTY_PRECISION "Precision"
#define PROPERTY_SCALE "Scale"
#define PROPERTY_ISNULLABLE "IsNullable"
#define PROPERTY_ISAUTOINCREMENT "IsAutoIncrement"
#define PROPERTY_ISROWVERSION "IsRowVersion"
#define PROPERTY_DESCRIPTION "Description"
#define PROPERTY_DEFAULTVALUE "DefaultValue"
#define PROPERTY_NUMBERFORMAT "FormatKey"
#define PROPERTY_QUERYTIMEOUT "QueryTimeOut"
#define PROPERTY_MAXFIELDSIZE "MaxFieldSize"
#define PROPERTY_MAXROWS "MaxRows"
#define PROPERTY_CURSORNAME "CursorName"
#define PROPERTY_RESULTSETCONCURRENCY "ResultSetConcurrency"
#define PROPERTY_RESULTSETTYPE "ResultSetType"
#define PROPERTY_FETCHDIRECTION "FetchDirection"
#define PROPERTY_FETCHSIZE "FetchSize"
#define PROPERTY_USEBOOKMARKS "UseBookmarks"
#define PROPERTY_ISSEARCHABLE "IsSearchable"
#define PROPERTY_ISCURRENCY "IsCurrency"
#define PROPERTY_ISSIGNED "IsSigned"
#define PROPERTY_DISPLAYSIZE "DisplaySize"
#define PROPERTY_LABEL "Label"
#define PROPERTY_ISREADONLY "IsReadOnly"
#define PROPERTY_ISWRITABLE "IsWritable"
#define PROPERTY_ISDEFINITELYWRITABLE "IsDefinitelyWritable"
#define PROPERTY_VALUE "Value"
#define PROPERTY_TABLENAME "TableName"
#define PROPERTY_ISCASESENSITIVE "IsCaseSensitive"
#define PROPERTY_SERVICENAME "ServiceName"
#define PROPERTY_ISBOOKMARKABLE "IsBookmarkable"
#define PROPERTY_CANUPDATEINSERTEDROWS "CanUpdateInsertedRows"
#define PROPERTY_ISSET "IsSet"
#define PROPERTY_ISOUTPARAMETER "IsOutParameter"
#define PROPERTY_NUMBERFORMATSSUPPLIER "NumberFormatsSupplier"
#define PROPERTY_ISCALCULATED "IsCalculated"
#define PROPERTY_DATASOURCENAME "DataSourceName"
#define PROPERTY_DATABASE_LOCATION "DatabaseLocation"
#define PROPERTY_CONNECTION_RESOURCE "ConnectionResource"
#define PROPERTY_CONNECTION_INFO "ConnectionInfo"
#define PROPERTY_RESULT_SET "ResultSet"
#define PROPERTY_SELECTION "Selection"
#define PROPERTY_BOOKMARK_SELECTION "BookmarkSelection"
#define PROPERTY_COLUMN_NAME "ColumnName"
#define PROPERTY_COLUMN "Column"
#define PROPERTY_DATASOURCE "DataSource"
#define PROPERTY_TRANSACTIONISOLATION "TransactionIsolation"
#define PROPERTY_TYPEMAP "TypeMap"
#define PROPERTY_USER "User"
#define PROPERTY_PASSWORD "Password"
#define PROPERTY_COMMAND_TYPE "CommandType"
#define PROPERTY_ACTIVECOMMAND "ActiveCommand"
#define PROPERTY_ACTIVE_CONNECTION "ActiveConnection"
#define PROPERTY_FILTER "Filter"
#define PROPERTY_APPLYFILTER "ApplyFilter"
#define PROPERTY_ORDER "Order"
#define PROPERTY_APPLYORDER "ApplyOrder" 
#define PROPERTY_ISMODIFIED "IsModified"
#define PROPERTY_ISNEW "IsNew"
#define PROPERTY_ROWCOUNT "RowCount"
#define PROPERTY_ISROWCOUNTFINAL "IsRowCountFinal"
#define PROPERTY_HELPFILENAME "HelpFileName"
#define PROPERTY_WIDTH "Width"
#define PROPERTY_ROW_HEIGHT "RowHeight"
#define PROPERTY_FORMATKEY "FormatKey"
#define PROPERTY_ALIGN "Align"
#define PROPERTY_FONT "FontDescriptor"
#define PROPERTY_TEXTCOLOR "TextColor"
#define PROPERTY_BOUNDFIELD "BoundField"
#define PROPERTY_CONTROLSOURCE "DataField"
#define PROPERTY_REALNAME "RealName"
#define PROPERTY_ISHIDDEN "IsHidden"
#define PROPERTY_UPDATE_TABLENAME "UpdateTableName"
#define PROPERTY_UPDATE_SCHEMANAME "UpdateSchemaName"
#define PROPERTY_UPDATE_CATALOGNAME "UpdateCatalogName"
#define PROPERTY_RELATIVEPOSITION "RelativePosition"
#define PROPERTY_CONTROLMODEL "ControlModel"
#define PROPERTY_ISASCENDING "IsAscending"
#define PROPERTY_RELATEDCOLUMN "RelatedColumn"
#define PROPERTY_ISUNIQUE "IsUnique"
#define PROPERTY_ISPRIMARYKEYINDEX "IsPrimaryKeyIndex"
#define PROPERTY_IGNORERESULT "IgnoreResult"
#define PROPERTY_UPDATERULE "UpdateRule"
#define PROPERTY_DELETERULE "DeleteRule"
#define PROPERTY_REFERENCEDTABLE "ReferencedTable"
#define PROPERTY_REFERENCEDCOLUMN "ReferencedColumn"
#define PROPERTY_PARENTWINDOW "ParentWindow"
#define PROPERTY_SQLEXCEPTION "SQLException"
#define PROPERTY_BORDER "Border"
#define PROPERTY_THREADSAFE "ThreadSafe"
#define PROPERTY_HELPTEXT	 "HelpText"
#define PROPERTY_CONTROLDEFAULT	 "ControlDefault"
#define PROPERTY_HIDDEN	 "Hidden"
#define PROPERTY_DEFAULTSTATE	 "DefaultState"
#define PROPERTY_SUPPRESSVERSIONCL "SuppressVersionColumns"
#define PROPERTY_SHOW_BROWSER "ShowBrowser"
#define PROPERTY_ENABLE_BROWSER "EnableBrowser"
#define PROPERTY_SHOWMENU "ShowMenu"
#define PROPERTY_LAYOUTINFORMATION "LayoutInformation"
#define PROPERTY_CURRENTTABLE "CurrentTable"
#define PROPERTY_DATABASENAME "DatabaseName"
#define PROPERTY_CONTROLUSER "ControlUser"
#define PROPERTY_CONTROLPASSWORD "ControlPassword"
#define PROPERTY_CACHESIZE "CacheSize"
#define PROPERTY_TEXTLINECOLOR "TextLineColor"
#define PROPERTY_TEXTEMPHASIS "FontEmphasisMark"
#define PROPERTY_TEXTRELIEF "FontRelief"
#define PROPERTY_DEFAULTTEXT "DefaultText"
#define PROPERTY_EFFECTIVEDEFAULT "EffectiveDefault"
#define PROPERTY_AUTOINCREMENTCREATION "AutoIncrementCreation"
#define PROPERTY_BOOLEANCOMPARISONMODE "BooleanComparisonMode"
#define PROPERTY_ENABLESQL92CHECK "EnableSQL92Check"
#define PROPERTY_FONTCHARWIDTH "FontCharWidth"
#define PROPERTY_FONTCHARSET "FontCharset"
#define PROPERTY_FONTFAMILY "FontFamily"
#define PROPERTY_FONTHEIGHT "FontHeight"
#define PROPERTY_FONTKERNING "FontKerning"
#define PROPERTY_FONTNAME 	"FontName"
#define PROPERTY_FONTORIENTATION "FontOrientation"
#define PROPERTY_FONTPITCH "FontPitch"
#define PROPERTY_FONTSLANT "FontSlant"
#define PROPERTY_FONTSTRIKEOUT "FontStrikeout"
#define PROPERTY_FONTSTYLENAME "FontStyleName"
#define PROPERTY_FONTUNDERLINE "FontUnderline"
#define PROPERTY_FONTWEIGHT "FontWeight"
#define PROPERTY_FONTWIDTH "FontWidth"
#define PROPERTY_FONTWORDLINEMODE "FontWordLineMode"
#define PROPERTY_FONTTYPE "FontType" 
#define PROPERTY_PERSISTENT_NAME "PersistentName" 
#define PROPERTY_EMBEDDEDOBJECT "EmbeddedObject" 
#define PROPERTY_ORIGINAL "Original"
#define PROPERTY_USECATALOGINSELECT "UseCatalogInSelect"
#define PROPERTY_USESCHEMAINSELECT "UseSchemaInSelect"
#define PROPERTY_OUTERJOINESCAPE "EnableOuterJoinEscape"
#define PROPERTY_AS_TEMPLATE "AsTemplate"
#define PROPERTY_HAVING_CLAUSE "HavingClause"
#define PROPERTY_GROUP_BY 	"GroupBy"
#define PROPERTY_EDIT_WIDTH "EditWidth"
#define PROPERTY_SINGLESELECTQUERYCOMPOSER "SingleSelectQueryComposer"
#define PROPERTY_CHANGE_NOTIFICATION_ENABLED "PropertyChangeNotificationEnabled"

//============================================================
//= service names
//============================================================
#define SERVICE_SDBC_RESULTSET "com.sun.star.sdbc.ResultSet"
#define SERVICE_SDBC_ROWSET "com.sun.star.sdbc.RowSet"
#define SERVICE_SDBC_STATEMENT "com.sun.star.sdbc.Statement"
#define SERVICE_SDBC_PREPAREDSTATEMENT "com.sun.star.sdbc.PreparedStatement"
#define SERVICE_SDBC_CALLABLESTATEMENT "com.sun.star.sdbc.CallableStatement"
#define SERVICE_SDBC_CONNECTION "com.sun.star.sdbc.Connection"
#define SERVICE_SDBCX_CONTAINER "com.sun.star.sdbcx.Container"
#define SERVICE_SDBCX_TABLE "com.sun.star.sdbcx.Table"
#define SERVICE_SDBCX_RESULTSET "com.sun.star.sdbcx.ResultSet"
#define SERVICE_SDB_CONNECTION "com.sun.star.sdb.Connection"
#define SERVICE_SDBCX_COLUMN "com.sun.star.sdbcx.Column"
#define SERVICE_SDBCX_COLUMNDESCRIPTOR "com.sun.star.sdbcx.ColumnDescriptor"
#define SERVICE_SDB_COLUMNSETTINGS "com.sun.star.sdb.ColumnSettings"
#define SERVICE_SDB_RESULTCOLUMN "com.sun.star.sdb.ResultColumn"
#define SERVICE_SDB_DATACOLUMN "com.sun.star.sdb.DataColumn"
#define SERVICE_SDB_DATASOURCE "com.sun.star.sdb.DataSource"
#define SERVICE_SDB_RESULTSET "com.sun.star.sdb.ResultSet"
#define SERVICE_SDB_ROWSET "com.sun.star.sdb.RowSet"
#define SERVICE_SDB_PREPAREDSTATMENT "com.sun.star.sdb.PreparedStatement"
#define SERVICE_SDB_CALLABLESTATEMENT "com.sun.star.sdbc.CallableStatement"
#define SERVICE_SDB_SQLQUERYCOMPOSER "com.sun.star.sdb.SQLQueryComposer"
#define SERVICE_SDB_DATASETTINGS "com.sun.star.sdb.DefinitionSettings"
#define SERVICE_SDB_QUERYDESCRIPTOR "com.sun.star.sdb.QueryDescriptor"
#define SERVICE_SDB_QUERY "com.sun.star.sdb.Query"
#define SERVICE_SDBCX_COLUMNS "com.sun.star.sdbcx.Columns"
#define SERVICE_SDBCX_TABLES "com.sun.star.sdbcx.Tables"
#define SERVICE_SDB_QUERIES "com.sun.star.sdb.Queries"
#define SERVICE_SDBCX_INDEXCOLUMN "com.sun.star.sdbcx.IndexColumn"
#define SERVICE_SDBCX_KEYCOLUMN "com.sun.star.sdbcx.KeyColumn"
#define SERVICE_SDB_DOCUMENTDEFINITION "com.sun.star.sdb.DocumentDefinition"
#define SERVICE_NAME_FORM 	"com.sun.star.sdb.Form"
#define SERVICE_NAME_FORM_COLLECTION "com.sun.star.sdb.Forms"
#define SERVICE_NAME_REPORT "com.sun.star.sdb.Report"
#define SERVICE_NAME_REPORT_COLLECTION "com.sun.star.sdb.Reports"
#define SERVICE_NAME_QUERY_COLLECTION "com.sun.star.sdb.Queries"
#define SERVICE_NAME_TABLE_COLLECTION "com.sun.star.sdb.Tables"
#define SERVICE_NAME_SINGLESELECTQUERYCOMPOSER "com.sun.star.sdb.SingleSelectQueryComposer"
#define SERVICE_SDB_APPLICATIONCONTROLLER "org.openoffice.comp.dbu.OApplicationController"

// info properties
#define INFO_JDBCDRIVERCLASS "JavaDriverClass"
#define INFO_TEXTFILEEXTENSION "Extension"
#define INFO_CHARSET "CharSet"
#define INFO_TEXTFILEHEADER "HeaderLine"
#define INFO_FIELDDELIMITER "FieldDelimiter"
#define INFO_TEXTDELIMITER "StringDelimiter"
#define INFO_DECIMALDELIMITER "DecimalDelimiter"
#define INFO_THOUSANDSDELIMITER "ThousandDelimiter"
#define INFO_SHOWDELETEDROWS "ShowDeleted"
#define INFO_ALLOWLONGTABLENAMES "NoNameLengthLimit"
#define INFO_ADDITIONALOPTIONS "SystemDriverSettings"
#define INFO_AUTORETRIEVEVALUE "AutoRetrievingStatement"
#define INFO_AUTORETRIEVEENABLED "IsAutoRetrievingEnabled"
#define INFO_APPEND_TABLE_ALIAS "AppendTableAliasName"
#define INFO_AS_BEFORE_CORRELATION_NAME "GenerateASBeforeCorrelationName" 
#define INFO_FORMS_CHECK_REQUIRED_FIELDS "FormsCheckRequiredFields" 
#define INFO_PARAMETERNAMESUBST "ParameterNameSubstitution"
#define INFO_IGNOREDRIVER_PRIV "IgnoreDriverPrivileges"
#define INFO_USECATALOG "UseCatalog"
#define INFO_CONN_LDAP_BASEDN "BaseDN"
#define INFO_CONN_LDAP_ROWCOUNT "MaxRowCount"
#define INFO_PREVIEW "Preview"
#define INFO_MEDIATYPE "MediaType"
#define INFO_ESCAPE_DATETIME "EscapeDateTime"

// other
#define INFO_POOLURL "PoolURL"
#define URL_INTERACTIVE "Interactive"
