# -*- Mode: makefile-gmake; tab-width: 4; indent-tabs-mode: t -*-
#
# This file is part of the LibreOffice project.
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.
#

# AutoInstall class

define gb_AutoInstall__make_define
echo "#define auto_$*_ALL \ " >> $@
$(foreach binary,$(filter-out $(lastword $(1)),$(1)),echo "    $(subst -,_,$(binary)), \ " >> $@;)
echo "    $(lastword $(1))" >> $@;
echo "" >> $@
endef

$(dir $(call gb_AutoInstall_get_target,%)).dir :
	$(if $(wildcard $(dir $@)),,mkdir -p $(dir $@))

$(call gb_AutoInstall_get_target,%) : $(SRCDIR)/Repository.mk $(GBUILDDIR)/AutoInstall.mk
	$(call gb_Output_announce,$*,$(true),AIN,3)
	echo "/* autogenerated installs for group $* */" > $@
	$(call gb_AutoInstall__make_define,\
		$(foreach lib,$(gb_Library_MODULE_$*),auto_$*_lib_$(lib)) \
		$(foreach lib,$(gb_SdkLinkLibrary_MODULE_$*),auto_$*_link_$(lib)) \
		$(foreach exe,$(gb_Executable_MODULE_$*),auto_$*_exe_$(exe)))
	$(foreach lib,$(gb_Library_MODULE_$*),\
		echo '$(SCP2LIBTEMPLATE)(auto_$*_lib_$(lib),$(call gb_Library_get_runtime_filename,$(lib))$(if $(SCP2COMPONENTCONDITION),$(COMMA)$(SCP2COMPONENTCONDITION)))' >> $@;)
	$(foreach lib,$(gb_SdkLinkLibrary_MODULE_$*),\
		echo 'SDK_LIBRARY_LINK(auto_$*_link_$(lib),$(notdir $(call gb_Library_get_sdk_link_lib,$(lib))),../../ure-link/lib/$(call gb_Library_get_runtime_filename,$(lib)))' >> $@;)
	$(foreach exe,$(gb_Executable_MODULE_$*),\
		echo "$(SCP2EXETEMPLATE)(auto_$*_exe_$(subst -,_,$(exe)),$(call gb_Executable_get_filename,$(exe)))" >> $@;)


$(call gb_AutoInstall_get_clean_target,%) :
	$(call gb_Output_announce,$*,$(false),AIL,3)
	rm -f $(call gb_AutoInstall_get_target,$*)

define gb_AutoInstall_AutoInstall
$(call gb_AutoInstall_get_target,all) :| $(dir $(call gb_AutoInstall_get_target,all)).dir

$$(eval $$(call gb_Module_register_target,$(call gb_AutoInstall_get_target,all),$(call gb_AutoInstall_get_clean_target,all)))
$(call gb_Helper_make_userfriendly_targets,all,AutoInstall)

endef

# gb_AutoInstall_add_module module lib_template optional:exe_template
define gb_AutoInstall_add_module
$(call gb_AutoInstall_get_target,all) : $(call gb_AutoInstall_get_target,$(1))
$(call gb_AutoInstall_get_clean_target,all) : $(call gb_AutoInstall_get_clean_target,$(1))
$(call gb_Helper_make_userfriendly_targets,$(1),AutoInstall)

$(call gb_AutoInstall_get_target,$(1)) : $(gb_Module_CURRENTMAKEFILE)
$(call gb_AutoInstall_get_target,$(1)) :| $(dir $(call gb_AutoInstall_get_target,$(1))).dir
$(call gb_AutoInstall_get_target,$(1)) : SCP2LIBTEMPLATE := $(2)
$(call gb_AutoInstall_get_target,$(1)) : SCP2EXETEMPLATE := $(3)
$(call gb_AutoInstall_get_target,$(1)) : SCP2COMPONENTCONDITION := $(4)

endef

# vim: set shiftwidth=4 tabstop=4 noexpandtab:
