/*
 * Copyright (c) 1997, 2015, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * (C) Copyright Taligent, Inc. 1996, 1997 - All Rights Reserved
 * (C) Copyright IBM Corp. 1996 - 1998 - All Rights Reserved
 *
 * The original version of this source code and documentation
 * is copyrighted and owned by Taligent, Inc., a wholly-owned
 * subsidiary of IBM. These materials are provided under terms
 * of a License Agreement between Taligent and Sun. This technology
 * is protected by multiple US and International patents.
 *
 * This notice and attribution to Taligent may not be removed.
 * Taligent is a registered trademark of Taligent, Inc.
 *
 */

package sun.util.resources;

public final class TimeZoneNames_ko extends TimeZoneNamesBundle {

    protected final Object[][] getContents() {
        String ACT[] = new String[] {"\uc5d0\uc774\ucee4 \uc2dc\uac04", "ACT",
                                     "\uc5d0\uc774\ucee4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "ACST"};
        String ADELAIDE[] = new String[] {"\uC911\uBD80 \uD45C\uC900\uC2DC(\uB0A8\uBD80 \uC624\uC2A4\uD2B8\uB808\uC77C\uB9AC\uC544)", "ACST",
                                          "\uC911\uBD80 \uC77C\uAD11 \uC808\uC57D \uC2DC\uAC04(\uB0A8\uBD80 \uC624\uC2A4\uD2B8\uB808\uC77C\uB9AC\uC544)", "ACDT"};
        String AGT[] = new String[] {"\uc544\ub974\ud5e8\ud2f0\ub098 \uc2dc\uac04", "ART",
                                     "\uc544\ub974\ud5e8\ud2f0\ub098 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "ARST"};
        String AKST[] = new String[] {"\uc54c\ub798\uc2a4\uce74 \ud45c\uc900\uc2dc", "AKST",
                                      "\uc54c\ub798\uc2a4\uce74 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "AKDT"};
        String AMT[] = new String[] {"\uc544\ub9c8\uc874 \uc2dc\uac04", "AMT",
                                     "\uc544\ub9c8\uc874 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "AMST"};
        String ARAST[] = new String[] {"\uc544\ub78d \ud45c\uc900\uc2dc", "AST",
                                       "\uc544\ub78d \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "ADT"};
        String ARMT[] = new String[] {"\uc544\ub974\uba54\ub2c8\uc544 \uc2dc\uac04", "AMT",
                                      "\uc544\ub974\uba54\ub2c8\uc544 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "AMST"};
        String AST[] = new String[] {"\ub300\uc11c\uc591 \ud45c\uc900\uc2dc", "AST",
                                     "\ub300\uc11c\uc591 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "ADT"};
        String BDT[] = new String[] {"\ubc29\uae00\ub77c\ub370\uc2dc \uc2dc\uac04", "BDT",
                                     "\ubc29\uae00\ub77c\ub370\uc2dc \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "BDST"};
        String BRISBANE[] = new String[] {"\uB3D9\uBD80 \uD45C\uC900\uC2DC(\uD038\uC990\uB79C\uB4DC)", "AEST",
                                          "\uB3D9\uBD80 \uC77C\uAD11 \uC808\uC57D \uC2DC\uAC04(\uD038\uC990\uB79C\uB4DC)", "AEDT"};
        String BROKEN_HILL[] = new String[] {"\uC911\uBD80 \uD45C\uC900\uC2DC(\uB0A8\uBD80 \uC624\uC2A4\uD2B8\uB808\uC77C\uB9AC\uC544/\uB274\uC0AC\uC6B0\uC2A4\uC6E8\uC77C\uC988)", "ACST",
                                             "\uC911\uBD80 \uC77C\uAD11 \uC808\uC57D \uC2DC\uAC04(\uB0A8\uBD80 \uC624\uC2A4\uD2B8\uB808\uC77C\uB9AC\uC544/\uB274\uC0AC\uC6B0\uC2A4\uC6E8\uC77C\uC988)", "ACDT"};
        String BRT[] = new String[] {"\ube0c\ub77c\uc9c8\ub9ac\uc544 \uc2dc\uac04", "BRT",
                                     "\ube0c\ub77c\uc9c8\ub9ac\uc544 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "BRST"};
        String BTT[] = new String[] {"\ubd80\ud0c4 \uc2dc\uac04", "BTT",
                                     "\ubd80\ud0c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "BTST"};
        String CAT[] = new String[] {"\uc911\uc559 \uc544\ud504\ub9ac\uce74 \uc2dc\uac04", "CAT",
                                     "\uc911\uc559 \uc544\ud504\ub9ac\uce74 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "CAST"};
        String CET[] = new String[] {"\uc911\uc559 \uc720\ub7fd \uc2dc\uac04", "CET",
                                     "\uc911\uc559 \uc720\ub7fd \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "CEST"};
        String CHAST[] = new String[] {"Chatham \ud45c\uc900\uc2dc", "CHAST",
                                       "Chatham \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "CHADT"};
        String ChST[] = new String[] {"\ucc28\ubaa8\ub85c \ud45c\uc900\uc2dc", "ChST",
                                      "\ucc28\ubaa8\ub85c \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "ChDT"};
        String CHUT[] = new String[] {"\uCD94\uD06C \uD45C\uC900\uC2DC", "CHUT",
                                      "\uCD94\uD06C \uC77C\uAD11 \uC808\uC57D \uC2DC\uAC04", "CHUST"};
        String CIT[] = new String[] {"\uc911\uc559 \uc778\ub3c4\ub124\uc2dc\uc544 \uc2dc\uac04", "WITA",
                                     "\uc911\uc559 \uc778\ub3c4\ub124\uc2dc\uc544 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "CIST"};
        String CLT[] = new String[] {"\uce60\ub808 \uc2dc\uac04", "CLT",
                                     "\uce60\ub808 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "CLST"};
        String CST[] = new String[] {"\uc911\ubd80 \ud45c\uc900\uc2dc", "CST",
                                     "\uc911\ubd80 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "CDT"};
        String CTT[] = new String[] {"\uc911\uad6d \ud45c\uc900\uc2dc", "CST",
                                     "\uc911\uad6d \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "CDT"};
        String CUBA[] = new String[] {"\ucfe0\ubc14 \ud45c\uc900\uc2dc", "CST",
                                      "\ucfe0\ubc14 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "CDT"};
        String DARWIN[] = new String[] {"\uC911\uBD80 \uD45C\uC900\uC2DC(\uBD81\uBD80 \uC9C0\uC5ED)", "ACST",
                                        "\uC911\uBD80 \uC77C\uAD11 \uC808\uC57D \uC2DC\uAC04(\uBD81\uBD80 \uC9C0\uC5ED)", "ACDT"};
        String DUBLIN[] = new String[] {"\uadf8\ub9ac\ub2c8\uce58 \ud45c\uc900\uc2dc", "GMT",
                                        "\uc544\uc77c\ub79c\ub4dc \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "IST"};
        String EAT[] = new String[] {"\ub3d9\ubd80 \uc544\ud504\ub9ac\uce74 \uc2dc\uac04", "EAT",
                                     "\ub3d9\ubd80 \uc544\ud504\ub9ac\uce74 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "EAST"};
        String EASTER[] = new String[] {"Easter Is. \uc2dc\uac04", "EAST",
                                        "Easter Is. \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "EASST"};
        String EET[] = new String[] {"\ub3d9\uc720\ub7fd \uc2dc\uac04", "EET",
                                     "\ub3d9\uc720\ub7fd \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "EEST"};
        String EGT[] = new String[] {"\ub3d9\ubd80 \uadf8\ub9b0\ub79c\ub4dc \uc2dc\uac04", "EGT",
                                     "\ub3d9\ubd80 \uadf8\ub9b0\ub79c\ub4dc \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "EGST"};
        String EST[] = new String[] {"\ub3d9\ubd80 \ud45c\uc900\uc2dc", "EST",
                                     "\ub3d9\ubd80 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "EDT"};
        String EST_NSW[] = new String[] {"\uB3D9\uBD80 \uD45C\uC900\uC2DC(\uB274\uC0AC\uC6B0\uC2A4\uC6E8\uC77C\uC988)", "AEST",
                                         "\uB3D9\uBD80 \uC77C\uAD11 \uC808\uC57D \uC2DC\uAC04(\uB274\uC0AC\uC6B0\uC2A4\uC6E8\uC77C\uC988)", "AEDT"};
        String FET[] = new String[] {"\uADF9\uB3D9 \uC720\uB7FD \uD45C\uC900\uC2DC", "FET",
                                     "\uADF9\uB3D9 \uC720\uB7FD \uC77C\uAD11 \uC808\uC57D \uC2DC\uAC04", "FEST"};
        String GHMT[] = new String[] {"\uac00\ub098 \ud45c\uc900\uc2dc", "GMT",
                                     "\uac00\ub098 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "GHST"};
        String GAMBIER[] =  new String[] {"\uac10\ube44\uc544 \uc2dc\uac04", "GAMT",
                                          "\uac10\ube44\uc544 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "GAMST"};
        String GMT[] = new String[] {"\uadf8\ub9ac\ub2c8\uce58 \ud45c\uc900\uc2dc", "GMT",
                                     "\uadf8\ub9ac\ub2c8\uce58 \ud45c\uc900\uc2dc", "GMT"};
        String GMTBST[] = new String[] {"\uadf8\ub9ac\ub2c8\uce58 \ud45c\uc900\uc2dc", "GMT",
                                        "\uc601\uad6d \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "BST"};
        String GST[] = new String[] {"\uac78\ud504\ub9cc \ud45c\uc900\uc2dc", "GST",
                                     "\uac78\ud504\ub9cc \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "GDT"};
        String HKT[] =  new String[] {"\ud64d\ucf69 \uc2dc\uac04", "HKT",
                                      "\ud64d\ucf69 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "HKST"};
        String HST[] = new String[] {"\ud558\uc640\uc774 \ud45c\uc900\uc2dc", "HST",
                                     "\ud558\uc640\uc774 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "HDT"};
        String ICT[] = new String[] {"\uc778\ub3c4\ucc28\uc774\ub098 \ubc18\ub3c4 \uc2dc\uac04", "ICT",
                                     "\uc778\ub3c4\ucc28\uc774\ub098 \ubc18\ub3c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "ICST"};
        String IRT[] = new String[] {"\uc774\ub780 \ud45c\uc900\uc2dc", "IRST",
                                     "\uc774\ub780 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "IRDT"};
        String ISRAEL[] = new String[] {"\uc774\uc2a4\ub77c\uc5d8 \ud45c\uc900\uc2dc", "IST",
                                        "\uc774\uc2a4\ub77c\uc5d8 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "IDT"};
        String IST[] = new String[] {"\uc778\ub3c4 \ud45c\uc900\uc2dc", "IST",
                                     "\uc778\ub3c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "IDT"};
        String JST[] = new String[] {"\uc77c\ubcf8 \ud45c\uc900\uc2dc", "JST",
                                     "\uc77c\ubcf8 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "JDT"};
        String KRAT[] = new String[] {"\ud06c\ub77c\uc2a4\ub178\uc57c\ub974\uc2a4\ud06c \uc2dc\uac04", "KRAT",
                                      "\ud06c\ub77c\uc2a4\ub178\uc57c\ub974\uc2a4\ud06c \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "KRAST"};
        String KST[] = new String[] {"\ud55c\uad6d \ud45c\uc900\uc2dc", "KST",
                                     "\ud55c\uad6d \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "KDT"};
        String LORD_HOWE[] = new String[] {"\ub85c\ub4dc \ud558\uc6b0 \ud45c\uc900\uc2dc", "LHST",
                                           "\ub85c\ub4dc \ud558\uc6b0 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "LHDT"};
        String MHT[] = new String[] {"\ub9c8\uc15c\uc81c\ub3c4 \uc2dc\uac04", "MHT",
                                     "\ub9c8\uc15c\uc81c\ub3c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "MHST"};
        String MSK[] = new String[] {"\ubaa8\uc2a4\ud06c\ubc14 \ud45c\uc900\uc2dc", "MSK",
                                     "\ubaa8\uc2a4\ud06c\ubc14 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "MSD"};
        String MST[] = new String[] {"\uc0b0\uc9c0 \ud45c\uc900\uc2dc", "MST",
                                     "\uc0b0\uc9c0 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "MDT"};
        String MYT[] = new String[] {"\ub9d0\ub808\uc774\uc2dc\uc544 \uc2dc\uac04", "MYT",
                                     "\ub9d0\ub808\uc774\uc2dc\uc544 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "MYST"};
        String NORONHA[] = new String[] {"Fernando de Noronha \uc2dc\uac04", "FNT",
                                         "Fernando de Noronha \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "FNST"};
        String NOVT[] = new String[] {"\ub178\ube0c\uc2dc\ube4c\uc2a4\ud06c \uc2dc\uac04", "NOVT",
                                      "\ub178\ube0c\uc2dc\ube4c\uc2a4\ud06c \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "NOVST"};
        String NPT[] = new String[] {"\ub124\ud314 \uc2dc\uac04", "NPT",
                                      "\ub124\ud314 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "NPST"};
        String NST[] = new String[] {"\ub274\ud380\ub4e4\ub79c\ub4dc \ud45c\uc900\uc2dc", "NST",
                                     "\ub274\ud380\ub4e4\ub79c\ub4dc \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "NDT"};
        String NZST[] = new String[] {"\ub274\uc9c8\ub79c\ub4dc \ud45c\uc900\uc2dc", "NZST",
                                      "\ub274\uc9c8\ub79c\ub4dc \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "NZDT"};
        String PITCAIRN[] = new String[] {"Pitcairn \ud45c\uc900\uc2dc", "PST",
                                          "Pitcairn \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "PDT"};
        String PKT[] = new String[] {"\ud30c\ud0a4\uc2a4\ud0c4 \uc2dc\uac04", "PKT",
                                     "\ud30c\ud0a4\uc2a4\ud0c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "PKST"};
        String PONT[] = new String[] {"\uD3F0\uD398\uC774 \uD45C\uC900\uC2DC", "PONT",
                                      "\uD3F0\uD398\uC774 \uC77C\uAD11 \uC808\uC57D \uC2DC\uAC04", "PONST"};
        String PST[] = new String[] {"\ud0dc\ud3c9\uc591 \ud45c\uc900\uc2dc", "PST",
                                     "\ud0dc\ud3c9\uc591 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "PDT"};
        String SAMOA[] = new String[] {"\uc0ac\ubaa8\uc544 \ud45c\uc900\uc2dc", "SST",
                                       "\uc0ac\ubaa8\uc544 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "SDT"};
        String IRKT[] =  new String[] {"\uc774\ub974\ucfe0\uce20\ud06c \uc2dc\uac04", "IRKT",
                                       "\uc774\ub974\ucfe0\uce20\ud06c \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "IRKST"};
        String SAST[] = new String[] {"\ub0a8\uc544\ud504\ub9ac\uce74 \ud45c\uc900\uc2dc", "SAST",
                                      "\ub0a8\uc544\ud504\ub9ac\uce74 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "SAST"};
        String SBT[] = new String[] {"\uc194\ub85c\ubaac \uad70\ub3c4 \uc2dc\uac04", "SBT",
                                     "\uc194\ub85c\ubaac \uad70\ub3c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "SBST"};
        String SGT[] = new String[] {"\uc2f1\uac00\ud3ec\ub974 \uc2dc\uac04", "SGT",
                                     "\uc2f1\uac00\ud3ec\ub974 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "SGST"};
        String TASMANIA[] = new String[] {"\uB3D9\uBD80 \uD45C\uC900\uC2DC(\uD0DC\uC988\uBA54\uC774\uB2C8\uC544)", "AEST",
                                          "\uB3D9\uBD80 \uC77C\uAD11 \uC808\uC57D \uC2DC\uAC04(\uD0DC\uC988\uBA54\uC774\uB2C8\uC544)", "AEDT"};
        String TMT[] = new String[] {"\ud22c\ub974\ud06c\uba54\ub2c8\uc2a4\ud0c4 \uc2dc\uac04", "TMT",
                                     "\ud22c\ub974\ud06c\uba54\ub2c8\uc2a4\ud0c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "TMST"};
        String ULAT[]= new String[] {"\uc6b8\ub780\ubc14\ud0c0\ub974 \uc2dc\uac04", "ULAT",
                                     "\uc6b8\ub780\ubc14\ud0c0\ub974 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "ULAST"};
        String UTC[] = new String[] {"\uc138\uacc4 \ud45c\uc900\uc2dc", "UTC",
                                     "\uc138\uacc4 \ud45c\uc900\uc2dc", "UTC"};
        String UZT[] = new String[] {"\uc6b0\uc988\ubca0\ud0a4\uc2a4\ud0c4 \uc2dc\uac04", "UZT",
                                     "\uc6b0\uc988\ubca0\ud0a4\uc2a4\ud0c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "UZST"};
        String VICTORIA[] = new String[] {"\uB3D9\uBD80 \uD45C\uC900\uC2DC(\uBE45\uD1A0\uB9AC\uC544)", "AEST",
                                          "\uB3D9\uBD80 \uC77C\uAD11 \uC808\uC57D \uC2DC\uAC04(\uBE45\uD1A0\uB9AC\uC544)", "AEDT"};
        String VLAT[] = new String[] {"\ube14\ub77c\ub514\ubcf4\uc2a4\ud1a1 \uc2dc\uac04", "VLAT",
                                      "\ube14\ub77c\ub514\ubcf4\uc2a4\ud1a1 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "VLAST"};
        String WAT[] = new String[] {"\uc11c\ubd80 \uc544\ud504\ub9ac\uce74 \uc2dc\uac04", "WAT",
                                     "\uc11c\ubd80 \uc544\ud504\ub9ac\uce74 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "WAST"};
        String WET[] = new String[] {"\uc11c\uc720\ub7fd \uc2dc\uac04", "WET",
                                     "\uc11c\uc720\ub7fd \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "WEST"};
        String WIT[] = new String[] {"\uc11c\uc778\ub3c4\ub124\uc2dc\uc544 \uc2dc\uac04", "WIB",
                                     "\uc11c\uc778\ub3c4\ub124\uc2dc\uc544 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "WIST"};
        String WST_AUS[] = new String[] {"\uC11C\uBD80 \uD45C\uC900\uC2DC(\uC624\uC2A4\uD2B8\uB808\uC77C\uB9AC\uC544)", "AWST",
                                         "\uC11C\uBD80 \uC77C\uAD11 \uC808\uC57D \uC2DC\uAC04(\uC624\uC2A4\uD2B8\uB808\uC77C\uB9AC\uC544)", "AWDT"};
        String WST_SAMOA[] = new String[] {"\uc11c\uc0ac\ubaa8\uc544 \uc2dc\uac04", "WSST",
                                           "\uc11c\uc0ac\ubaa8\uc544 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "WSDT"};
        String XJT[] = new String[] {"\uc911\uad6d \ud45c\uc900\uc2dc", "XJT",
                                     "\uc911\uad6d \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "XJDT"};
        String YAKT[] = new String[] {"\uc57c\uce20\ud06c \uc2dc\uac04", "YAKT",
                                      "\uc57c\uce20\ud06c \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "YAKST"};

        return new Object[][] {
            {"America/Los_Angeles", PST},
            {"PST", PST},
            {"America/Denver", MST},
            {"MST", MST},
            {"America/Phoenix", MST},
            {"PNT", MST},
            {"America/Chicago", CST},
            {"CST", CST},
            {"America/New_York", EST},
            {"EST", EST},
            {"America/Indianapolis", EST},
            {"IET", EST},
            {"Pacific/Honolulu", HST},
            {"HST", HST},
            {"America/Anchorage", AKST},
            {"AST", AKST},
            {"America/Halifax", AST},
            {"America/Sitka", AKST},
            {"America/St_Johns", NST},
            {"CNT", NST},
            {"Europe/Paris", CET},
            {"ECT", CET},
            {"GMT", GMT},
            {"Africa/Casablanca", WET},
            {"Asia/Jerusalem", ISRAEL},
            {"Asia/Tokyo", JST},
            {"JST", JST},
            {"Europe/Bucharest", EET},
            {"Asia/Shanghai", CTT},
            {"CTT", CTT},
            /* Don't change the order of the above zones
             * to keep compatibility with the previous version.
             */

            {"ACT", DARWIN},
            {"AET", EST_NSW},
            {"AGT", AGT},
            {"ART", EET},
            {"Africa/Abidjan", GMT},
            {"Africa/Accra", GHMT},
            {"Africa/Addis_Ababa", EAT},
            {"Africa/Algiers", CET},
            {"Africa/Asmara", EAT},
            {"Africa/Asmera", EAT},
            {"Africa/Bamako", GMT},
            {"Africa/Bangui", WAT},
            {"Africa/Banjul", GMT},
            {"Africa/Bissau", GMT},
            {"Africa/Blantyre", CAT},
            {"Africa/Brazzaville", WAT},
            {"Africa/Bujumbura", CAT},
            {"Africa/Cairo", EET},
            {"Africa/Ceuta", CET},
            {"Africa/Conakry", GMT},
            {"Africa/Dakar", GMT},
            {"Africa/Dar_es_Salaam", EAT},
            {"Africa/Djibouti", EAT},
            {"Africa/Douala", WAT},
            {"Africa/El_Aaiun", WET},
            {"Africa/Freetown", GMT},
            {"Africa/Gaborone", CAT},
            {"Africa/Harare", CAT},
            {"Africa/Johannesburg", SAST},
            {"Africa/Juba", EAT},
            {"Africa/Kampala", EAT},
            {"Africa/Khartoum", EAT},
            {"Africa/Kigali", CAT},
            {"Africa/Kinshasa", WAT},
            {"Africa/Lagos", WAT},
            {"Africa/Libreville", WAT},
            {"Africa/Lome", GMT},
            {"Africa/Luanda", WAT},
            {"Africa/Lubumbashi", CAT},
            {"Africa/Lusaka", CAT},
            {"Africa/Malabo", WAT},
            {"Africa/Maputo", CAT},
            {"Africa/Maseru", SAST},
            {"Africa/Mbabane", SAST},
            {"Africa/Mogadishu", EAT},
            {"Africa/Monrovia", GMT},
            {"Africa/Nairobi", EAT},
            {"Africa/Ndjamena", WAT},
            {"Africa/Niamey", WAT},
            {"Africa/Nouakchott", GMT},
            {"Africa/Ouagadougou", GMT},
            {"Africa/Porto-Novo", WAT},
            {"Africa/Sao_Tome", GMT},
            {"Africa/Timbuktu", GMT},
            {"Africa/Tripoli", EET},
            {"Africa/Tunis", CET},
            {"Africa/Windhoek", WAT},
            {"America/Adak", HST},
            {"America/Anguilla", AST},
            {"America/Antigua", AST},
            {"America/Araguaina", BRT},
            {"America/Argentina/Buenos_Aires", AGT},
            {"America/Argentina/Catamarca", AGT},
            {"America/Argentina/ComodRivadavia", AGT},
            {"America/Argentina/Cordoba", AGT},
            {"America/Argentina/Jujuy", AGT},
            {"America/Argentina/La_Rioja", AGT},
            {"America/Argentina/Mendoza", AGT},
            {"America/Argentina/Rio_Gallegos", AGT},
            {"America/Argentina/Salta", AGT},
            {"America/Argentina/San_Juan", AGT},
            {"America/Argentina/San_Luis", AGT},
            {"America/Argentina/Tucuman", AGT},
            {"America/Argentina/Ushuaia", AGT},
            {"America/Aruba", AST},
            {"America/Asuncion", new String[] {"\ud30c\ub77c\uacfc\uc774 \uc2dc\uac04", "PYT",
                                               "\ud30c\ub77c\uacfc\uc774 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "PYST"}},
            {"America/Atikokan", EST},
            {"America/Atka", HST},
            {"America/Bahia", BRT},
            {"America/Bahia_Banderas", CST},
            {"America/Barbados", AST},
            {"America/Belem", BRT},
            {"America/Belize", CST},
            {"America/Blanc-Sablon", AST},
            {"America/Boa_Vista", AMT},
            {"America/Bogota", new String[] {"\ucf5c\ub86c\ube44\uc544 \uc2dc\uac04", "COT",
                                              "\ucf5c\ub86c\ube44\uc544 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "COST"}},
            {"America/Boise", MST},
            {"America/Buenos_Aires", AGT},
            {"America/Cambridge_Bay", MST},
            {"America/Campo_Grande", AMT},
            {"America/Cancun", EST},
            {"America/Caracas", new String[] {"\ubca0\ub124\uc218\uc5d8\ub77c \uc2dc\uac04", "VET",
                                              "\ubca0\ub124\uc218\uc5d8\ub77c \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "VEST"}},
            {"America/Catamarca", AGT},
            {"America/Cayenne", new String[] {"\ud504\ub791\uc2a4\ub839 \uae30\uc544\ub098 \uc2dc\uac04", "GFT",
                                              "\ud504\ub791\uc2a4\ub839 \uae30\uc544\ub098 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "GFST"}},
            {"America/Cayman", EST},
            {"America/Chihuahua", MST},
            {"America/Creston", MST},
            {"America/Coral_Harbour", EST},
            {"America/Cordoba", AGT},
            {"America/Costa_Rica", CST},
            {"America/Cuiaba", AMT},
            {"America/Curacao", AST},
            {"America/Danmarkshavn", GMT},
            {"America/Dawson", PST},
            {"America/Dawson_Creek", MST},
            {"America/Detroit", EST},
            {"America/Dominica", AST},
            {"America/Edmonton", MST},
            {"America/Eirunepe", ACT},
            {"America/El_Salvador", CST},
            {"America/Ensenada", PST},
            {"America/Fort_Nelson", MST},
            {"America/Fort_Wayne", EST},
            {"America/Fortaleza", BRT},
            {"America/Glace_Bay", AST},
            {"America/Godthab", new String[] {"\uc11c\ubd80 \uadf8\ub9b0\ub79c\ub4dc \uc2dc\uac04", "WGT",
                                              "\uc11c\ubd80 \uadf8\ub9b0\ub79c\ub4dc \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "WGST"}},
            {"America/Goose_Bay", AST},
            {"America/Grand_Turk", AST},
            {"America/Grenada", AST},
            {"America/Guadeloupe", AST},
            {"America/Guatemala", CST},
            {"America/Guayaquil", new String[] {"\uc5d0\ucfe0\uc544\ub3c4\ub974 \uc2dc\uac04", "ECT",
                                                "\uc5d0\ucfe0\uc544\ub3c4\ub974 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "ECST"}},
            {"America/Guyana", new String[] {"\uac00\uc774\uc544\ub098 \uc2dc\uac04", "GYT",
                                             "\uac00\uc774\uc544\ub098 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "GYST"}},
            {"America/Havana", CUBA},
            {"America/Hermosillo", MST},
            {"America/Indiana/Indianapolis", EST},
            {"America/Indiana/Knox", CST},
            {"America/Indiana/Marengo", EST},
            {"America/Indiana/Petersburg", EST},
            {"America/Indiana/Tell_City", CST},
            {"America/Indiana/Vevay", EST},
            {"America/Indiana/Vincennes", EST},
            {"America/Indiana/Winamac", EST},
            {"America/Inuvik", MST},
            {"America/Iqaluit", EST},
            {"America/Jamaica", EST},
            {"America/Jujuy", AGT},
            {"America/Juneau", AKST},
            {"America/Kentucky/Louisville", EST},
            {"America/Kentucky/Monticello", EST},
            {"America/Knox_IN", CST},
            {"America/Kralendijk", AST},
            {"America/La_Paz", new String[] {"\ubcfc\ub9ac\ube44\uc544 \uc2dc\uac04", "BOT",
                                            "\ubcfc\ub9ac\ube44\uc544 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "BOST"}},
            {"America/Lima", new String[] {"\ud398\ub8e8 \uc2dc\uac04", "PET",
                                            "\ud398\ub8e8 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "PEST"}},
            {"America/Louisville", EST},
            {"America/Lower_Princes", AST},
            {"America/Maceio", BRT},
            {"America/Managua", CST},
            {"America/Manaus", AMT},
            {"America/Marigot", AST},
            {"America/Martinique", AST},
            {"America/Matamoros", CST},
            {"America/Mazatlan", MST},
            {"America/Mendoza", AGT},
            {"America/Menominee", CST},
            {"America/Merida", CST},
            {"America/Metlakatla", AKST},
            {"America/Mexico_City", CST},
            {"America/Miquelon", new String[] {"\ud53c\uc5d0\ub974 \ubbf8\ud06c\ub860 \ud45c\uc900\uc2dc", "PMST",
                                               "\ud53c\uc5d0\ub974 \ubbf8\ud06c\ub860 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "PMDT"}},
            {"America/Moncton", AST},
            {"America/Montevideo", new String[] {"\uc6b0\ub8e8\uacfc\uc774 \uc2dc\uac04", "UYT",
                                                 "\uc6b0\ub8e8\uacfc\uc774 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "UYST"}},
            {"America/Monterrey", CST},
            {"America/Montreal", EST},
            {"America/Montserrat", AST},
            {"America/Nassau", EST},
            {"America/Nipigon", EST},
            {"America/Nome", AKST},
            {"America/Noronha", NORONHA},
            {"America/North_Dakota/Beulah", CST},
            {"America/North_Dakota/Center", CST},
            {"America/North_Dakota/New_Salem", CST},
            {"America/Ojinaga", MST},
            {"America/Panama", EST},
            {"America/Pangnirtung", EST},
            {"America/Paramaribo", new String[] {"\uc218\ub9ac\ub0a8 \uc2dc\uac04", "SRT",
                                                 "\uc218\ub9ac\ub0a8 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "SRST"}},
            {"America/Port-au-Prince", EST},
            {"America/Port_of_Spain", AST},
            {"America/Porto_Acre", ACT},
            {"America/Porto_Velho", AMT},
            {"America/Puerto_Rico", AST},
            {"America/Rainy_River", CST},
            {"America/Rankin_Inlet", CST},
            {"America/Recife", BRT},
            {"America/Regina", CST},
            {"America/Resolute", CST},
            {"America/Rio_Branco", ACT},
            {"America/Rosario", AGT},
            {"America/Santa_Isabel", PST},
            {"America/Santarem", BRT},
            {"America/Santiago", CLT},
            {"America/Santo_Domingo", AST},
            {"America/Sao_Paulo", BRT},
            {"America/Scoresbysund", EGT},
            {"America/Shiprock", MST},
            {"America/St_Barthelemy", AST},
            {"America/St_Kitts", AST},
            {"America/St_Lucia", AST},
            {"America/St_Thomas", AST},
            {"America/St_Vincent", AST},
            {"America/Swift_Current", CST},
            {"America/Tegucigalpa", CST},
            {"America/Thule", AST},
            {"America/Thunder_Bay", EST},
            {"America/Tijuana", PST},
            {"America/Toronto", EST},
            {"America/Tortola", AST},
            {"America/Vancouver", PST},
            {"America/Virgin", AST},
            {"America/Whitehorse", PST},
            {"America/Winnipeg", CST},
            {"America/Yakutat", AKST},
            {"America/Yellowknife", MST},
            {"Antarctica/Casey", WST_AUS},
            {"Antarctica/Davis", new String[] {"Davis \uc2dc\uac04", "DAVT",
                                               "Davis \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "DAVST"}},
            {"Antarctica/DumontDUrville", new String[] {"\ub4a4\ubabd \ub4a4\ub974\ube4c \uc2dc\uac04", "DDUT",
                                                        "\ub4a4\ubabd \ub4a4\ub974\ube4c \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "DDUST"}},
            {"Antarctica/Macquarie", new String[] {"\uB9E4\uCF70\uB9AC \uC12C \uD45C\uC900\uC2DC", "MIST",
                                                   "\uB9E4\uCF70\uB9AC \uC12C \uC77C\uAD11 \uC808\uC57D \uC2DC\uAC04", "MIDT"}},
            {"Antarctica/Mawson", new String[] {"\ubaa8\uc2a8 \uc2dc\uac04", "MAWT",
                                                "\ubaa8\uc2a8 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "MAWST"}},
            {"Antarctica/McMurdo", NZST},
            {"Antarctica/Palmer", CLT},
            {"Antarctica/Rothera", new String[] {"\ub85c\uc81c\ub77c \ud45c\uc900\uc2dc", "ROTT",
                                                 "\ub85c\uc81c\ub77c \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "ROTST"}},
            {"Antarctica/South_Pole", NZST},
            {"Antarctica/Syowa", new String[] {"Syowa \uc2dc\uac04", "SYOT",
                                               "Syowa \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "SYOST"}},
            {"Antarctica/Troll", new String[] {"\uc138\uacc4 \ud45c\uc900\uc2dc", "UTC",
                                               "\uc911\uc559 \uc720\ub7fd \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "CEST"}},
            {"Antarctica/Vostok", new String[] {"Vostok \uc2dc\uac04", "VOST",
                                                "Vostok \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "VOSST"}},
            {"Arctic/Longyearbyen", CET},
            {"Asia/Aden", ARAST},
            {"Asia/Almaty", new String[] {"\uc54c\ub9c8\uc544\ud0c0 \uc2dc\uac04", "ALMT",
                                          "\uc54c\ub9c8\uc544\ud0c0 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "ALMST"}},
            {"Asia/Amman", EET},
            {"Asia/Anadyr", new String[] {"\uc544\ub098\ub514\ub974 \uc2dc\uac04", "ANAT",
                                          "\uc544\ub098\ub514\ub974 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "ANAST"}},
            {"Asia/Aqtau", new String[] {"\uc545\ud0c0\uc6b0 \uc2dc\uac04", "AQTT",
                                         "\uc545\ud0c0\uc6b0 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "AQTST"}},
            {"Asia/Aqtobe", new String[] {"\uc545\ud1a0\ube0c \uc2dc\uac04", "AQTT",
                                          "\uc545\ud1a0\ube0c \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "AQTST"}},
            {"Asia/Ashgabat", TMT},
            {"Asia/Ashkhabad", TMT},
            {"Asia/Baghdad", ARAST},
            {"Asia/Bahrain", ARAST},
            {"Asia/Baku", new String[] {"\uc544\uc81c\ub974\ubc14\uc774\uc794 \uc2dc\uac04", "AZT",
                                        "\uc544\uc81c\ub974\ubc14\uc774\uc794 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "AZST"}},
            {"Asia/Bangkok", ICT},
            {"Asia/Beirut", EET},
            {"Asia/Bishkek", new String[] {"\ud0a4\ub974\ud0a4\uc988\uc2a4\ud0c4 \uc2dc\uac04", "KGT",
                                           "\ud0a4\ub974\uae30\uc988\uc2a4\ud0c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "KGST"}},
            {"Asia/Brunei", new String[] {"\ube0c\ub8e8\ub098\uc774 \uc2dc\uac04", "BNT",
                                          "\ube0c\ub8e8\ub098\uc774 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "BNST"}},
            {"Asia/Calcutta", IST},
            {"Asia/Chita", YAKT},
            {"Asia/Choibalsan", new String[] {"Choibalsan \uc2dc\uac04", "CHOT",
                                              "Choibalsan \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "CHOST"}},
            {"Asia/Chongqing", CTT},
            {"Asia/Chungking", CTT},
            {"Asia/Colombo", IST},
            {"Asia/Dacca", BDT},
            {"Asia/Dhaka", BDT},
            {"Asia/Dili", new String[] {"\ud2f0\ubaa8\ub974-\ub808\uc2a4\ud14c \uc2dc\uac04", "TLT",
                                        "\ud2f0\ubaa8\ub974-\ub808\uc2a4\ud14c \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "TLST"}},
            {"Asia/Damascus", EET},
            {"Asia/Dubai", GST},
            {"Asia/Dushanbe", new String[] {"\ud0c0\uc9c0\ud0a4\uc2a4\ud0c4 \uc2dc\uac04", "TJT",
                                            "\ud0c0\uc9c0\ud0a4\uc2a4\ud0c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "TJST"}},
            {"Asia/Gaza", EET},
            {"Asia/Harbin", CTT},
            {"Asia/Hebron", EET},
            {"Asia/Ho_Chi_Minh", ICT},
            {"Asia/Hong_Kong", HKT},
            {"Asia/Hovd", new String[] {"Hovd \uc2dc\uac04", "HOVT",
                                        "Hovd \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "HOVST"}},
            {"Asia/Irkutsk", IRKT},
            {"Asia/Istanbul", EET},
            {"Asia/Jakarta", WIT},
            {"Asia/Jayapura", new String[] {"\ub3d9\ubd80 \uc778\ub3c4\ub124\uc2dc\uc544 \uc2dc\uac04", "WIT",
                                            "\ub3d9\ubd80 \uc778\ub3c4\ub124\uc2dc\uc544 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "EIST"}},
            {"Asia/Kabul", new String[] {"\uc544\ud504\uac00\ub2c8\uc2a4\ud0c4 \uc2dc\uac04", "AFT",
                                         "\uc544\ud504\uac00\ub2c8\uc2a4\ud0c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "AFST"}},
            {"Asia/Kamchatka", new String[] {"\ud398\ud2b8\ub85c\ud30c\ube14\ub85c\ud504\uc2a4\ud06c-\uce84\ucc28\uce20\ud0a4 \uc2dc\uac04", "PETT",
                                            "\ud398\ud2b8\ub85c\ud30c\ube14\ub85c\ud504\uc2a4\ud06c-\uce84\ucc28\uce20\ud0a4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "PETST"}},
            {"Asia/Karachi", PKT},
            {"Asia/Kashgar", XJT},
            {"Asia/Kathmandu", NPT},
            {"Asia/Katmandu", NPT},
            {"Asia/Khandyga", YAKT},
            {"Asia/Kolkata", IST},
            {"Asia/Krasnoyarsk", KRAT},
            {"Asia/Kuala_Lumpur", MYT},
            {"Asia/Kuching", MYT},
            {"Asia/Kuwait", ARAST},
            {"Asia/Macao", CTT},
            {"Asia/Macau", CTT},
            {"Asia/Magadan", new String[] {"\ub9c8\uac00\ub2e8 \uc2dc\uac04", "MAGT",
                                           "\ub9c8\uac00\ub2e8 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "MAGST"}},
            {"Asia/Makassar", CIT},
            {"Asia/Manila", new String[] {"\ud544\ub9ac\ud540 \uc2dc\uac04", "PHT",
                                          "\ud544\ub9ac\ud540 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "PHST"}},
            {"Asia/Muscat", GST},
            {"Asia/Nicosia", EET},
            {"Asia/Novokuznetsk", KRAT},
            {"Asia/Novosibirsk", NOVT},
            {"Asia/Oral", new String[] {"Oral \ud45c\uc900\uc2dc", "ORAT",
                                        "Oral \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "ORAST"}},
            {"Asia/Omsk", new String[] {"Omsk \uc2dc\uac04", "OMST",
                                        "Omsk \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "OMSST"}},
            {"Asia/Phnom_Penh", ICT},
            {"Asia/Pontianak", WIT},
            {"Asia/Pyongyang", KST},
            {"Asia/Qatar", ARAST},
            {"Asia/Qyzylorda", new String[] {"Qyzylorda \ud45c\uc900\uc2dc", "QYZT",
                                             "Qyzylorda \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "QYZST"}},
            {"Asia/Rangoon", new String[] {"\ubbf8\uc580\ub9c8 \uc2dc\uac04", "MMT",
                                           "\ubbf8\uc580\ub9c8 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "MMST"}},
            {"Asia/Riyadh", ARAST},
            {"Asia/Saigon", ICT},
            {"Asia/Sakhalin", new String[] {"\uc0ac\ud560\ub9b0 \uc2dc\uac04", "SAKT",
                                            "\uc0ac\ud560\ub9b0 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "SAKST"}},
            {"Asia/Samarkand", UZT},
            {"Asia/Seoul", KST},
            {"Asia/Singapore", SGT},
            {"Asia/Srednekolymsk", new String[] {"Srednekolymsk Time", "SRET",
                                                 "Srednekolymsk Daylight Time", "SREDT"}},
            {"Asia/Taipei", CTT},
            {"Asia/Tel_Aviv", ISRAEL},
            {"Asia/Tashkent", UZT},
            {"Asia/Tbilisi", new String[] {"\uadf8\ub8e8\uc9c0\uc57c \uc2dc\uac04", "GET",
                                          "\uadf8\ub8e8\uc9c0\uc57c \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "GEST"}},
            {"Asia/Tehran", IRT},
            {"Asia/Thimbu", BTT},
            {"Asia/Thimphu", BTT},
            {"Asia/Ujung_Pandang", CIT},
            {"Asia/Ulaanbaatar", ULAT},
            {"Asia/Ulan_Bator", ULAT},
            {"Asia/Urumqi", XJT},
            {"Asia/Ust-Nera", new String[] {"\uC6B0\uC2A4\uD2F0\uB124\uB77C \uD45C\uC900\uC2DC", "VLAT",
                                            "\uC6B0\uC2A4\uD2F0\uB124\uB77C \uC77C\uAD11 \uC808\uC57D \uC2DC\uAC04", "VLAST"}},
            {"Asia/Vientiane", ICT},
            {"Asia/Vladivostok", VLAT},
            {"Asia/Yakutsk", YAKT},
            {"Asia/Yekaterinburg", new String[] {"\uc608\uce74\ud14c\ub9b0\ubc84\uadf8 \uc2dc\uac04", "YEKT",
                                                 "\uc608\uce74\ud14c\ub9b0\ubc84\uadf8 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "YEKST"}},
            {"Asia/Yerevan", ARMT},
            {"Atlantic/Azores", new String[] {"\uc544\uc870\ub808\uc2a4 \uc2dc\uac04", "AZOT",
                                              "\uc544\uc870\ub808\uc2a4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "AZOST"}},
            {"Atlantic/Bermuda", AST},
            {"Atlantic/Canary", WET},
            {"Atlantic/Cape_Verde", new String[] {"\uae4c\ubf40\ubca0\ub974\ub370 \uc2dc\uac04", "CVT",
                                                  "\uae4c\ubf40\ubca0\ub974\ub370 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "CVST"}},
            {"Atlantic/Faeroe", WET},
            {"Atlantic/Faroe", WET},
            {"Atlantic/Jan_Mayen", CET},
            {"Atlantic/Madeira", WET},
            {"Atlantic/Reykjavik", GMT},
            {"Atlantic/South_Georgia", new String[] {"\uc0ac\uc6b0\uc2a4 \uc870\uc9c0\uc544 \ud45c\uc900\uc2dc", "GST",
                                                     "\uc0ac\uc6b0\uc2a4 \uc870\uc9c0\uc544 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "GDT"}},
            {"Atlantic/St_Helena", GMT},
            {"Atlantic/Stanley", new String[] {"\ud3ec\ud074\ub79c\ub4dc \uad70\ub3c4 \uc2dc\uac04", "FKT",
                                               "\ud3ec\ud074\ub79c\ub4dc \uad70\ub3c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "FKST"}},
            {"Australia/ACT", EST_NSW},
            {"Australia/Adelaide", ADELAIDE},
            {"Australia/Brisbane", BRISBANE},
            {"Australia/Broken_Hill", BROKEN_HILL},
            {"Australia/Canberra", EST_NSW},
            {"Australia/Currie", EST_NSW},
            {"Australia/Darwin", DARWIN},
            {"Australia/Eucla", new String[] {"\uC911\uC559 \uC11C\uBD80 \uD45C\uC900\uC2DC(\uC624\uC2A4\uD2B8\uB808\uC77C\uB9AC\uC544)", "ACWST",
                                              "\uC911\uC559 \uC11C\uBD80 \uC77C\uAD11 \uC808\uC57D \uC2DC\uAC04(\uC624\uC2A4\uD2B8\uB808\uC77C\uB9AC\uC544)", "ACWDT"}},
            {"Australia/Hobart", TASMANIA},
            {"Australia/LHI", LORD_HOWE},
            {"Australia/Lindeman", BRISBANE},
            {"Australia/Lord_Howe", LORD_HOWE},
            {"Australia/Melbourne", VICTORIA},
            {"Australia/North", DARWIN},
            {"Australia/NSW", EST_NSW},
            {"Australia/Perth", WST_AUS},
            {"Australia/Queensland", BRISBANE},
            {"Australia/South", ADELAIDE},
            {"Australia/Sydney", EST_NSW},
            {"Australia/Tasmania", TASMANIA},
            {"Australia/Victoria", VICTORIA},
            {"Australia/West", WST_AUS},
            {"Australia/Yancowinna", BROKEN_HILL},
            {"BET", BRT},
            {"BST", BDT},
            {"Brazil/Acre", ACT},
            {"Brazil/DeNoronha", NORONHA},
            {"Brazil/East", BRT},
            {"Brazil/West", AMT},
            {"Canada/Atlantic", AST},
            {"Canada/Central", CST},
            {"Canada/East-Saskatchewan", CST},
            {"Canada/Eastern", EST},
            {"Canada/Mountain", MST},
            {"Canada/Newfoundland", NST},
            {"Canada/Pacific", PST},
            {"Canada/Yukon", PST},
            {"Canada/Saskatchewan", CST},
            {"CAT", CAT},
            {"CET", CET},
            {"Chile/Continental", CLT},
            {"Chile/EasterIsland", EASTER},
            {"CST6CDT", CST},
            {"Cuba", CUBA},
            {"EAT", EAT},
            {"EET", EET},
            {"Egypt", EET},
            {"Eire", DUBLIN},
            {"EST5EDT", EST},
            {"Etc/Greenwich", GMT},
            {"Etc/UCT", UTC},
            {"Etc/Universal", UTC},
            {"Etc/UTC", UTC},
            {"Etc/Zulu", UTC},
            {"Europe/Amsterdam", CET},
            {"Europe/Andorra", CET},
            {"Europe/Athens", EET},
            {"Europe/Belfast", GMTBST},
            {"Europe/Belgrade", CET},
            {"Europe/Berlin", CET},
            {"Europe/Bratislava", CET},
            {"Europe/Brussels", CET},
            {"Europe/Budapest", CET},
            {"Europe/Busingen", CET},
            {"Europe/Chisinau", EET},
            {"Europe/Copenhagen", CET},
            {"Europe/Dublin", DUBLIN},
            {"Europe/Gibraltar", CET},
            {"Europe/Guernsey", GMTBST},
            {"Europe/Helsinki", EET},
            {"Europe/Isle_of_Man", GMTBST},
            {"Europe/Istanbul", EET},
            {"Europe/Jersey", GMTBST},
            {"Europe/Kaliningrad", EET},
            {"Europe/Kiev", EET},
            {"Europe/Lisbon", WET},
            {"Europe/Ljubljana", CET},
            {"Europe/London", GMTBST},
            {"Europe/Luxembourg", CET},
            {"Europe/Madrid", CET},
            {"Europe/Malta", CET},
            {"Europe/Mariehamn", EET},
            {"Europe/Minsk", MSK},
            {"Europe/Monaco", CET},
            {"Europe/Moscow", MSK},
            {"Europe/Nicosia", EET},
            {"Europe/Oslo", CET},
            {"Europe/Podgorica", CET},
            {"Europe/Prague", CET},
            {"Europe/Riga", EET},
            {"Europe/Rome", CET},
            {"Europe/Samara", new String[] {"\uc0ac\ub9c8\ub77c \uc2dc\uac04", "SAMT",
                                            "\uc0ac\ub9c8\ub77c \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "SAMST"}},
            {"Europe/San_Marino", CET},
            {"Europe/Sarajevo", CET},
            {"Europe/Simferopol", MSK},
            {"Europe/Skopje", CET},
            {"Europe/Sofia", EET},
            {"Europe/Stockholm", CET},
            {"Europe/Tallinn", EET},
            {"Europe/Tirane", CET},
            {"Europe/Tiraspol", EET},
            {"Europe/Uzhgorod", EET},
            {"Europe/Vaduz", CET},
            {"Europe/Vatican", CET},
            {"Europe/Vienna", CET},
            {"Europe/Vilnius", EET},
            {"Europe/Volgograd", MSK},
            {"Europe/Warsaw", CET},
            {"Europe/Zagreb", CET},
            {"Europe/Zaporozhye", EET},
            {"Europe/Zurich", CET},
            {"GB", GMTBST},
            {"GB-Eire", GMTBST},
            {"Greenwich", GMT},
            {"Hongkong", HKT},
            {"Iceland", GMT},
            {"Iran", IRT},
            {"IST", IST},
            {"Indian/Antananarivo", EAT},
            {"Indian/Chagos", new String[] {"\uc601\uc778\ub3c4 \uc81c\ub3c4 \uc2dc\uac04", "IOT",
                                            "\uc601\uc778\ub3c4 \uc81c\ub3c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "IOST"}},
            {"Indian/Christmas", new String[] {"\ud06c\ub9ac\uc2a4\ub9c8\uc2a4\uc12c \uc2dc\uac04", "CXT",
                                               "\ud06c\ub9ac\uc2a4\ub9c8\uc2a4\uc12c \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "CXST"}},
            {"Indian/Cocos", new String[] {"\ucf54\ucf54\uc2a4 \uad70\ub3c4 \uc2dc\uac04", "CCT",
                                           "\ucf54\ucf54\uc2a4 \uad70\ub3c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "CCST"}},
            {"Indian/Comoro", EAT},
            {"Indian/Kerguelen", new String[] {"\ud504\ub791\uc2a4 \ub0a8\ubd80 \uc9c0\ubc29 \ubc0f \ub0a8\uadf9 \uc9c0\uc5ed \uc2dc\uac04", "TFT",
                                               "\ud504\ub791\uc2a4 \ub0a8\ubd80 \uc9c0\ubc29 \ubc0f \ub0a8\uadf9 \uc9c0\uc5ed \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "TFST"}},
            {"Indian/Mahe", new String[] {"\uc138\uc774\uc140 \uc2dc\uac04", "SCT",
                                          "\uc138\uc774\uc258 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "SCST"}},
            {"Indian/Maldives", new String[] {"\ubab0\ub514\ube0c \uc2dc\uac04", "MVT",
                                              "\ubab0\ub514\ube0c \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "MVST"}},
            {"Indian/Mauritius", new String[] {"\ubaa8\ub9ac\uc154\uc2a4 \uc2dc\uac04", "MUT",
                                               "\ubaa8\ub9ac\uc154\uc2a4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "MUST"}},
            {"Indian/Mayotte", EAT},
            {"Indian/Reunion", new String[] {"\ub9ac\uc720\ub2c8\uc5b8 \uc2dc\uac04", "RET",
                                             "\ub9ac\uc720\ub2c8\uc5b8 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "REST"}},
            {"Israel", ISRAEL},
            {"Jamaica", EST},
            {"Japan", JST},
            {"Kwajalein", MHT},
            {"Libya", EET},
            {"MET", new String[] {"\uc911\ubd80 \uc720\ub7fd \uc2dc\uac04", "MET",
                                  "\uc911\ubd80 \uc720\ub7fd \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "MEST"}},
            {"Mexico/BajaNorte", PST},
            {"Mexico/BajaSur", MST},
            {"Mexico/General", CST},
            {"MIT", WST_SAMOA},
            {"MST7MDT", MST},
            {"Navajo", MST},
            {"NET", ARMT},
            {"NST", NZST},
            {"NZ", NZST},
            {"NZ-CHAT", CHAST},
            {"PLT", PKT},
            {"Portugal", WET},
            {"PRT", AST},
            {"Pacific/Apia", WST_SAMOA},
            {"Pacific/Auckland", NZST},
            {"Pacific/Bougainville", new String[] {"Bougainville Standard Time", "BST",
                                                   "Bougainville Daylight Time", "BST"}},
            {"Pacific/Chatham", CHAST},
            {"Pacific/Chuuk", CHUT},
            {"Pacific/Easter", EASTER},
            {"Pacific/Efate", new String[] {"\ube44\ub204\uc544\ud22c \uc2dc\uac04", "VUT",
                                            "\ubc14\ub204\uc544\ud22c \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "VUST"}},
            {"Pacific/Enderbury", new String[] {"\ud53c\ub2c9\uc2a4 \uad70\ub3c4 \uc2dc\uac04", "PHOT",
                                                "\ud53c\ub2c9\uc2a4 \uad70\ub3c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "PHOST"}},
            {"Pacific/Fakaofo", new String[] {"\ud1a0\ucf08\ub77c\uc6b0 \uc2dc\uac04", "TKT",
                                              "\ud1a0\ucf08\ub77c\uc6b0 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "TKST"}},
            {"Pacific/Fiji", new String[] {"\ud53c\uc9c0 \uc2dc\uac04", "FJT",
                                          "\ud53c\uc9c0 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "FJST"}},
            {"Pacific/Funafuti", new String[] {"\ud22c\ubc1c\ub8e8 \uc2dc\uac04", "TVT",
                                             "\ud22c\ubc1c\ub8e8 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "TVST"}},
            {"Pacific/Galapagos", new String[] {"\uac08\ub77c\ud30c\uace0\uc2a4 \uc2dc\uac04", "GALT",
                                                "\uac08\ub77c\ud30c\uace0\uc2a4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "GALST"}},
            {"Pacific/Gambier", GAMBIER},
            {"Pacific/Guadalcanal", SBT},
            {"Pacific/Guam", ChST},
            {"Pacific/Johnston", HST},
            {"Pacific/Kiritimati", new String[] {"\ub77c\uc778 \uad70\ub3c4 \uc2dc\uac04", "LINT",
                                                 "\ub77c\uc778 \uad70\ub3c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "LINST"}},
            {"Pacific/Kosrae", new String[] {"\ucf54\uc2a4\ub798 \uc2dc\uac04", "KOST",
                                             "\ucf54\uc2a4\ub798 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "KOSST"}},
            {"Pacific/Kwajalein", MHT},
            {"Pacific/Majuro", MHT},
            {"Pacific/Marquesas", new String[] {"\ub9c8\ub974\ucf00\uc0ac\uc2a4 \uc2dc\uac04", "MART",
                                                "\ub9c8\ub974\ucf00\uc0ac\uc2a4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "MARST"}},
            {"Pacific/Midway", SAMOA},
            {"Pacific/Nauru", new String[] {"\ub098\uc6b0\ub8e8 \uc2dc\uac04", "NRT",
                                           "\ub098\uc6b0\ub8e8 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "NRST"}},
            {"Pacific/Niue", new String[] {"\ub2c8\uc6b0\uc5d0 \uc2dc\uac04", "NUT",
                                           "\ub2c8\uc6b0\uc5d0 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "NUST"}},
            {"Pacific/Norfolk", new String[] {"\ub178\ud37d \uc2dc\uac04", "NFT",
                                              "\ub178\ud37d \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "NFST"}},
            {"Pacific/Noumea", new String[] {"\ub274 \uce7c\ub808\ub3c4\ub2c8\uc544 \uc2dc\uac04", "NCT",
                                             "\ub274 \uce7c\ub808\ub3c4\ub2c8\uc544 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "NCST"}},
            {"Pacific/Pago_Pago", SAMOA},
            {"Pacific/Palau", new String[] {"\ud314\ub77c\uc6b0 \uc2dc\uac04", "PWT",
                                            "\ud314\ub77c\uc6b0 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "PWST"}},
            {"Pacific/Pitcairn", PITCAIRN},
            {"Pacific/Pohnpei", PONT},
            {"Pacific/Ponape", PONT},
            {"Pacific/Port_Moresby", new String[] {"\ud30c\ud478\uc544\ub274\uae30\ub2c8 \uc2dc\uac04", "PGT",
                                                  "\ud30c\ud478\uc544\ub274\uae30\ub2c8 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "PGST"}},
            {"Pacific/Rarotonga", new String[] {"\ucfe0\ud06c \uad70\ub3c4 \uc2dc\uac04", "CKT",
                                                "\ucfe0\ud06c \uad70\ub3c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "CKHST"}},
            {"Pacific/Saipan", ChST},
            {"Pacific/Samoa", SAMOA},
            {"Pacific/Tahiti", new String[] {"\ud0c0\ud788\ud2f0 \uc2dc\uac04", "TAHT",
                                             "\ud0c0\ud788\ud2f0 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "TAHST"}},
            {"Pacific/Tarawa", new String[] {"\uae38\ubc84\ud2b8 \uad70\ub3c4 \uc2dc\uac04", "GILT",
                                             "\uae38\ubc84\ud2b8 \uad70\ub3c4 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "GILST"}},
            {"Pacific/Tongatapu", new String[] {"\ud1b5\uac00 \uc2dc\uac04", "TOT",
                                                "\ud1b5\uac00 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "TOST"}},
            {"Pacific/Truk", CHUT},
            {"Pacific/Wake", new String[] {"\uc6e8\uc774\ud06c \uc2dc\uac04", "WAKT",
                                           "\uc6e8\uc774\ud06c \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "WAKST"}},
            {"Pacific/Wallis", new String[] {"\uc6d4\ub9ac\uc2a4 \ud6c4\ud22c\ub098 \uc2dc\uac04", "WFT",
                                             "\uc6d4\ub9ac\uc2a4 \ud6c4\ud2b8\ub098 \uc77c\uad11\uc808\uc57d\uc2dc\uac04", "WFST"}},
            {"Pacific/Yap", CHUT},
            {"Poland", CET},
            {"PRC", CTT},
            {"PST8PDT", PST},
            {"ROK", KST},
            {"Singapore", SGT},
            {"SST", SBT},
            {"SystemV/AST4", AST},
            {"SystemV/AST4ADT", AST},
            {"SystemV/CST6", CST},
            {"SystemV/CST6CDT", CST},
            {"SystemV/EST5", EST},
            {"SystemV/EST5EDT", EST},
            {"SystemV/HST10", HST},
            {"SystemV/MST7", MST},
            {"SystemV/MST7MDT", MST},
            {"SystemV/PST8", PST},
            {"SystemV/PST8PDT", PST},
            {"SystemV/YST9", AKST},
            {"SystemV/YST9YDT", AKST},
            {"Turkey", EET},
            {"UCT", UTC},
            {"Universal", UTC},
            {"US/Alaska", AKST},
            {"US/Aleutian", HST},
            {"US/Arizona", MST},
            {"US/Central", CST},
            {"US/Eastern", EST},
            {"US/Hawaii", HST},
            {"US/Indiana-Starke", CST},
            {"US/East-Indiana", EST},
            {"US/Michigan", EST},
            {"US/Mountain", MST},
            {"US/Pacific", PST},
            {"US/Pacific-New", PST},
            {"US/Samoa", SAMOA},
            {"UTC", UTC},
            {"VST", ICT},
            {"W-SU", MSK},
            {"WET", WET},
            {"Zulu", UTC},
        };
    }
}
