/* rygel-lms-all-music.c generated by valac 0.44.9, the Vala compiler
 * generated from rygel-lms-all-music.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Jussi Kukkonen <jussi.kukkonen@intel.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <rygel-server.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <rygel-db.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#define RYGEL_LMS_TYPE_CATEGORY_CONTAINER (rygel_lms_category_container_get_type ())
#define RYGEL_LMS_CATEGORY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_LMS_TYPE_CATEGORY_CONTAINER, RygelLMSCategoryContainer))
#define RYGEL_LMS_CATEGORY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_LMS_TYPE_CATEGORY_CONTAINER, RygelLMSCategoryContainerClass))
#define RYGEL_LMS_IS_CATEGORY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_LMS_TYPE_CATEGORY_CONTAINER))
#define RYGEL_LMS_IS_CATEGORY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_LMS_TYPE_CATEGORY_CONTAINER))
#define RYGEL_LMS_CATEGORY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_LMS_TYPE_CATEGORY_CONTAINER, RygelLMSCategoryContainerClass))

typedef struct _RygelLMSCategoryContainer RygelLMSCategoryContainer;
typedef struct _RygelLMSCategoryContainerClass RygelLMSCategoryContainerClass;
typedef struct _RygelLMSCategoryContainerPrivate RygelLMSCategoryContainerPrivate;

#define RYGEL_LMS_TYPE_ALL_MUSIC (rygel_lms_all_music_get_type ())
#define RYGEL_LMS_ALL_MUSIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_LMS_TYPE_ALL_MUSIC, RygelLMSAllMusic))
#define RYGEL_LMS_ALL_MUSIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_LMS_TYPE_ALL_MUSIC, RygelLMSAllMusicClass))
#define RYGEL_LMS_IS_ALL_MUSIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_LMS_TYPE_ALL_MUSIC))
#define RYGEL_LMS_IS_ALL_MUSIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_LMS_TYPE_ALL_MUSIC))
#define RYGEL_LMS_ALL_MUSIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_LMS_TYPE_ALL_MUSIC, RygelLMSAllMusicClass))

typedef struct _RygelLMSAllMusic RygelLMSAllMusic;
typedef struct _RygelLMSAllMusicClass RygelLMSAllMusicClass;
typedef struct _RygelLMSAllMusicPrivate RygelLMSAllMusicPrivate;
enum  {
	RYGEL_LMS_ALL_MUSIC_0_PROPERTY,
	RYGEL_LMS_ALL_MUSIC_NUM_PROPERTIES
};
static GParamSpec* rygel_lms_all_music_properties[RYGEL_LMS_ALL_MUSIC_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_LMS_TYPE_DATABASE (rygel_lms_database_get_type ())
#define RYGEL_LMS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_LMS_TYPE_DATABASE, RygelLMSDatabase))
#define RYGEL_LMS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_LMS_TYPE_DATABASE, RygelLMSDatabaseClass))
#define RYGEL_LMS_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_LMS_TYPE_DATABASE))
#define RYGEL_LMS_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_LMS_TYPE_DATABASE))
#define RYGEL_LMS_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_LMS_TYPE_DATABASE, RygelLMSDatabaseClass))

typedef struct _RygelLMSDatabase RygelLMSDatabase;
typedef struct _RygelLMSDatabaseClass RygelLMSDatabaseClass;

struct _RygelLMSCategoryContainer {
	RygelMediaContainer parent_instance;
	RygelLMSCategoryContainerPrivate * priv;
	RygelDatabaseCursor* cursor_all;
	RygelDatabaseCursor* cursor_find_object;
	RygelDatabaseCursor* cursor_added;
	RygelDatabaseCursor* cursor_removed;
	gchar* child_prefix;
	gchar* ref_prefix;
};

struct _RygelLMSCategoryContainerClass {
	RygelMediaContainerClass parent_class;
	RygelMediaObject* (*object_from_statement) (RygelLMSCategoryContainer* self, sqlite3_stmt* statement);
	gchar* (*get_sql_all_with_filter) (RygelLMSCategoryContainer* self, const gchar* filter);
	gchar* (*get_sql_count_with_filter) (RygelLMSCategoryContainer* self, const gchar* filter);
	guint (*get_child_count_with_filter) (RygelLMSCategoryContainer* self, const gchar* where_filter, GValueArray* args);
	RygelMediaObjects* (*get_children_with_filter) (RygelLMSCategoryContainer* self, const gchar* where_filter, GValueArray* args, const gchar* sort_criteria, guint offset, guint max_count);
};

struct _RygelLMSAllMusic {
	RygelLMSCategoryContainer parent_instance;
	RygelLMSAllMusicPrivate * priv;
};

struct _RygelLMSAllMusicClass {
	RygelLMSCategoryContainerClass parent_class;
};

static gpointer rygel_lms_all_music_parent_class = NULL;

GType rygel_lms_category_container_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelLMSCategoryContainer, g_object_unref)
GType rygel_lms_all_music_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelLMSAllMusic, g_object_unref)
#define RYGEL_LMS_ALL_MUSIC_SQL_ALL_TEMPLATE "SELECT files.id, files.path, files.size, " "audios.title as title, audios.trackno, audios.length, " "audios.channels, audios.sampling_rate, audios.bitrate, " "audios.dlna_profile, audios.dlna_mime, " "audio_artists.name as artist, " "audio_albums.name, " "files.mtime, " "audio_genres.name " "FROM audios, files " "LEFT JOIN audio_artists " "ON audios.artist_id = audio_artists.id " "LEFT JOIN audio_albums " "ON audios.album_id = audio_albums.id " "LEFT JOIN audio_genres " "ON audios.genre_id = audio_genres.id " "WHERE dtime = 0 AND audios.id = files.id %s " "LIMIT ? OFFSET ?;"
#define RYGEL_LMS_ALL_MUSIC_SQL_COUNT "SELECT COUNT(audios.id) " "FROM audios, files " "WHERE dtime = 0 AND audios.id = files.id;"
#define RYGEL_LMS_ALL_MUSIC_SQL_COUNT_WITH_FILTER_TEMPLATE "SELECT COUNT(audios.id), audios.title as title, " "audio_artists.name as artist " "FROM audios, files " "LEFT JOIN audio_artists " "ON audios.artist_id = audio_artists.id " "WHERE dtime = 0 AND audios.id = files.id %s;"
#define RYGEL_LMS_ALL_MUSIC_SQL_FIND_OBJECT "SELECT files.id, files.path, files.size, " "audios.title, audios.trackno, audios.length, " "audios.channels, audios.sampling_rate, audios.bitrate, " "audios.dlna_profile, audios.dlna_mime, " "audio_artists.name, " "audio_albums.name, " "files.mtime, " "audio_genres.name " "FROM audios, files " "LEFT JOIN audio_artists " "ON audios.artist_id = audio_artists.id " "LEFT JOIN audio_albums " "ON audios.album_id = audio_albums.id " "LEFT JOIN audio_genres " "ON audios.genre_id = audio_genres.id " "WHERE dtime = 0 AND files.id = ? AND audios.id = files.id;"
#define RYGEL_LMS_ALL_MUSIC_SQL_ADDED "SELECT files.id, files.path, files.size, " "audios.title as title, audios.trackno, audios.length, " "audios.channels, audios.sampling_rate, audios.bitrate, " "audios.dlna_profile, audios.dlna_mime, " "audio_artists.name as artist, " "audio_albums.name, " "files.mtime, " "audio_genres.name " "FROM audios, files " "LEFT JOIN audio_artists " "ON audios.artist_id = audio_artists.id " "LEFT JOIN audio_albums " "ON audios.album_id = audio_albums.id " "LEFT JOIN audio_genres " "ON audios.genre_id = audio_genres.id " "WHERE dtime = 0 AND audios.id = files.id " "AND update_id > ? AND update_id <= ?;"
#define RYGEL_LMS_ALL_MUSIC_SQL_REMOVED "SELECT files.id, files.path, files.size, " "audios.title as title, audios.trackno, audios.length, " "audios.channels, audios.sampling_rate, audios.bitrate, " "audios.dlna_profile, audios.dlna_mime, " "audio_artists.name as artist, " "audio_albums.name, " "files.mtime, " "audio_genres.name " "FROM audios, files " "LEFT JOIN audio_artists " "ON audios.artist_id = audio_artists.id " "LEFT JOIN audio_albums " "ON audios.album_id = audio_albums.id " "LEFT JOIN audio_genres " "ON audios.genre_id = audio_genres.id " "WHERE dtime <> 0 AND audios.id = files.id " "AND update_id > ? AND update_id <= ?;"
static gchar* rygel_lms_all_music_real_get_sql_all_with_filter (RygelLMSCategoryContainer* base,
                                                         const gchar* filter);
const gchar* rygel_lms_category_container_get_sql_all (RygelLMSCategoryContainer* self);
static gchar* rygel_lms_all_music_real_get_sql_count_with_filter (RygelLMSCategoryContainer* base,
                                                           const gchar* filter);
const gchar* rygel_lms_category_container_get_sql_count (RygelLMSCategoryContainer* self);
static RygelMediaObject* rygel_lms_all_music_real_object_from_statement (RygelLMSCategoryContainer* base,
                                                                  sqlite3_stmt* statement);
gchar* rygel_lms_category_container_build_child_id (RygelLMSCategoryContainer* self,
                                                    gint db_id);
GType rygel_lms_database_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelLMSDatabase, g_object_unref)
RygelLMSAllMusic* rygel_lms_all_music_new (RygelMediaContainer* parent,
                                           RygelLMSDatabase* lms_db);
RygelLMSAllMusic* rygel_lms_all_music_construct (GType object_type,
                                                 RygelMediaContainer* parent,
                                                 RygelLMSDatabase* lms_db);
RygelLMSCategoryContainer* rygel_lms_category_container_construct (GType object_type,
                                                                   const gchar* db_id,
                                                                   RygelMediaContainer* parent,
                                                                   const gchar* title,
                                                                   RygelLMSDatabase* lms_db,
                                                                   const gchar* sql_all,
                                                                   const gchar* sql_find_object,
                                                                   const gchar* sql_count,
                                                                   const gchar* sql_added,
                                                                   const gchar* sql_removed);

static gchar*
rygel_lms_all_music_real_get_sql_all_with_filter (RygelLMSCategoryContainer* base,
                                                  const gchar* filter)
{
	RygelLMSAllMusic * self;
	gint _tmp0_;
	gint _tmp1_;
	gchar* filter_str = NULL;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result = NULL;
	self = (RygelLMSAllMusic*) base;
	g_return_val_if_fail (filter != NULL, NULL);
	_tmp0_ = strlen (filter);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = rygel_lms_category_container_get_sql_all ((RygelLMSCategoryContainer*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup (_tmp3_);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = g_strdup_printf ("AND %s", filter);
	filter_str = _tmp5_;
	_tmp6_ = filter_str;
	_tmp7_ = g_strdup_printf (RYGEL_LMS_ALL_MUSIC_SQL_ALL_TEMPLATE, _tmp6_);
	result = _tmp7_;
	_g_free0 (filter_str);
	return result;
}

static gchar*
rygel_lms_all_music_real_get_sql_count_with_filter (RygelLMSCategoryContainer* base,
                                                    const gchar* filter)
{
	RygelLMSAllMusic * self;
	gint _tmp0_;
	gint _tmp1_;
	gchar* filter_str = NULL;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result = NULL;
	self = (RygelLMSAllMusic*) base;
	g_return_val_if_fail (filter != NULL, NULL);
	_tmp0_ = strlen (filter);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = rygel_lms_category_container_get_sql_count ((RygelLMSCategoryContainer*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup (_tmp3_);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = g_strdup_printf ("AND %s", filter);
	filter_str = _tmp5_;
	_tmp6_ = filter_str;
	_tmp7_ = g_strdup_printf (RYGEL_LMS_ALL_MUSIC_SQL_COUNT_WITH_FILTER_TEMPLATE, _tmp6_);
	result = _tmp7_;
	_g_free0 (filter_str);
	return result;
}

static RygelMediaObject*
rygel_lms_all_music_real_object_from_statement (RygelLMSCategoryContainer* base,
                                                sqlite3_stmt* statement)
{
	RygelLMSAllMusic * self;
	gint id = 0;
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* mime_type = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gchar* title = NULL;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* song_id = NULL;
	gchar* _tmp12_;
	RygelMusicItem* song = NULL;
	RygelMusicItem* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	GTimeVal tv = {0};
	GTimeVal _tmp18_ = {0};
	gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	GFile* file = NULL;
	const gchar* _tmp22_;
	GFile* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	RygelMediaObject* result = NULL;
	self = (RygelLMSAllMusic*) base;
	g_return_val_if_fail (statement != NULL, NULL);
	id = sqlite3_column_int (statement, 0);
	_tmp0_ = (const gchar*) sqlite3_column_text (statement, 1);
	_tmp1_ = g_strdup (_tmp0_);
	path = _tmp1_;
	_tmp2_ = (const gchar*) sqlite3_column_text (statement, 10);
	_tmp3_ = g_strdup (_tmp2_);
	mime_type = _tmp3_;
	_tmp5_ = mime_type;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = mime_type;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_ == 0;
	}
	if (_tmp4_) {
		const gchar* _tmp9_;
		_tmp9_ = path;
		g_debug ("rygel-lms-all-music.vala:143: Music item %d (%s) has no MIME type", id, _tmp9_);
	}
	_tmp10_ = (const gchar*) sqlite3_column_text (statement, 3);
	_tmp11_ = g_strdup (_tmp10_);
	title = _tmp11_;
	_tmp12_ = rygel_lms_category_container_build_child_id ((RygelLMSCategoryContainer*) self, id);
	song_id = _tmp12_;
	_tmp13_ = rygel_music_item_new (song_id, (RygelMediaContainer*) self, title, RYGEL_MUSIC_ITEM_UPNP_CLASS);
	song = _tmp13_;
	rygel_media_file_item_set_size ((RygelMediaFileItem*) song, (gint64) sqlite3_column_int (statement, 2));
	rygel_music_item_set_track_number (song, sqlite3_column_int (statement, 4));
	rygel_audio_item_set_duration ((RygelAudioItem*) song, (glong) sqlite3_column_int (statement, 5));
	rygel_audio_item_set_channels ((RygelAudioItem*) song, sqlite3_column_int (statement, 6));
	rygel_audio_item_set_sample_freq ((RygelAudioItem*) song, sqlite3_column_int (statement, 7));
	rygel_audio_item_set_bitrate ((RygelAudioItem*) song, sqlite3_column_int (statement, 8));
	_tmp14_ = (const gchar*) sqlite3_column_text (statement, 9);
	rygel_media_file_item_set_dlna_profile ((RygelMediaFileItem*) song, _tmp14_);
	_tmp15_ = mime_type;
	rygel_media_file_item_set_mime_type ((RygelMediaFileItem*) song, _tmp15_);
	_tmp16_ = (const gchar*) sqlite3_column_text (statement, 11);
	rygel_media_object_set_artist ((RygelMediaObject*) song, _tmp16_);
	_tmp17_ = (const gchar*) sqlite3_column_text (statement, 12);
	rygel_audio_item_set_album ((RygelAudioItem*) song, _tmp17_);
	_tmp18_.tv_sec = (glong) sqlite3_column_int (statement, 13);
	_tmp18_.tv_usec = (glong) 0;
	tv = _tmp18_;
	_tmp19_ = g_time_val_to_iso8601 (&tv);
	_tmp20_ = _tmp19_;
	rygel_media_object_set_date ((RygelMediaObject*) song, _tmp20_);
	_g_free0 (_tmp20_);
	_tmp21_ = (const gchar*) sqlite3_column_text (statement, 14);
	rygel_media_object_set_genre ((RygelMediaObject*) song, _tmp21_);
	_tmp22_ = path;
	_tmp23_ = g_file_new_for_path (_tmp22_);
	file = _tmp23_;
	_tmp24_ = g_file_get_uri (file);
	_tmp25_ = _tmp24_;
	rygel_media_object_add_uri ((RygelMediaObject*) song, _tmp25_);
	_g_free0 (_tmp25_);
	result = (RygelMediaObject*) song;
	_g_object_unref0 (file);
	_g_free0 (song_id);
	_g_free0 (title);
	_g_free0 (mime_type);
	_g_free0 (path);
	return result;
}

RygelLMSAllMusic*
rygel_lms_all_music_construct (GType object_type,
                               RygelMediaContainer* parent,
                               RygelLMSDatabase* lms_db)
{
	RygelLMSAllMusic * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (lms_db != NULL, NULL);
	_tmp0_ = g_strdup_printf (RYGEL_LMS_ALL_MUSIC_SQL_ALL_TEMPLATE, "");
	_tmp1_ = _tmp0_;
	self = (RygelLMSAllMusic*) rygel_lms_category_container_construct (object_type, "all", parent, _ ("All"), lms_db, _tmp1_, RYGEL_LMS_ALL_MUSIC_SQL_FIND_OBJECT, RYGEL_LMS_ALL_MUSIC_SQL_COUNT, RYGEL_LMS_ALL_MUSIC_SQL_ADDED, RYGEL_LMS_ALL_MUSIC_SQL_REMOVED);
	_g_free0 (_tmp1_);
	return self;
}

RygelLMSAllMusic*
rygel_lms_all_music_new (RygelMediaContainer* parent,
                         RygelLMSDatabase* lms_db)
{
	return rygel_lms_all_music_construct (RYGEL_LMS_TYPE_ALL_MUSIC, parent, lms_db);
}

static void
rygel_lms_all_music_class_init (RygelLMSAllMusicClass * klass,
                                gpointer klass_data)
{
	rygel_lms_all_music_parent_class = g_type_class_peek_parent (klass);
	((RygelLMSCategoryContainerClass *) klass)->get_sql_all_with_filter = (gchar* (*) (RygelLMSCategoryContainer*, const gchar*)) rygel_lms_all_music_real_get_sql_all_with_filter;
	((RygelLMSCategoryContainerClass *) klass)->get_sql_count_with_filter = (gchar* (*) (RygelLMSCategoryContainer*, const gchar*)) rygel_lms_all_music_real_get_sql_count_with_filter;
	((RygelLMSCategoryContainerClass *) klass)->object_from_statement = (RygelMediaObject* (*) (RygelLMSCategoryContainer*, sqlite3_stmt*)) rygel_lms_all_music_real_object_from_statement;
}

static void
rygel_lms_all_music_instance_init (RygelLMSAllMusic * self,
                                   gpointer klass)
{
}

GType
rygel_lms_all_music_get_type (void)
{
	static volatile gsize rygel_lms_all_music_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_lms_all_music_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelLMSAllMusicClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_lms_all_music_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelLMSAllMusic), 0, (GInstanceInitFunc) rygel_lms_all_music_instance_init, NULL };
		GType rygel_lms_all_music_type_id;
		rygel_lms_all_music_type_id = g_type_register_static (RYGEL_LMS_TYPE_CATEGORY_CONTAINER, "RygelLMSAllMusic", &g_define_type_info, 0);
		g_once_init_leave (&rygel_lms_all_music_type_id__volatile, rygel_lms_all_music_type_id);
	}
	return rygel_lms_all_music_type_id__volatile;
}

