/* HierarchicalTagUtilities.c generated by valac 0.40.4, the Vala compiler
 * generated from HierarchicalTagUtilities.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define TYPE_HIERARCHICAL_TAG_UTILITIES (hierarchical_tag_utilities_get_type ())
#define HIERARCHICAL_TAG_UTILITIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HIERARCHICAL_TAG_UTILITIES, HierarchicalTagUtilities))
#define HIERARCHICAL_TAG_UTILITIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HIERARCHICAL_TAG_UTILITIES, HierarchicalTagUtilitiesClass))
#define IS_HIERARCHICAL_TAG_UTILITIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HIERARCHICAL_TAG_UTILITIES))
#define IS_HIERARCHICAL_TAG_UTILITIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HIERARCHICAL_TAG_UTILITIES))
#define HIERARCHICAL_TAG_UTILITIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HIERARCHICAL_TAG_UTILITIES, HierarchicalTagUtilitiesClass))

typedef struct _HierarchicalTagUtilities HierarchicalTagUtilities;
typedef struct _HierarchicalTagUtilitiesClass HierarchicalTagUtilitiesClass;
typedef struct _HierarchicalTagUtilitiesPrivate HierarchicalTagUtilitiesPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_HIERARCHICAL_TAG_INDEX (hierarchical_tag_index_get_type ())
#define HIERARCHICAL_TAG_INDEX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndex))
#define HIERARCHICAL_TAG_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndexClass))
#define IS_HIERARCHICAL_TAG_INDEX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HIERARCHICAL_TAG_INDEX))
#define IS_HIERARCHICAL_TAG_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HIERARCHICAL_TAG_INDEX))
#define HIERARCHICAL_TAG_INDEX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndexClass))

typedef struct _HierarchicalTagIndex HierarchicalTagIndex;
typedef struct _HierarchicalTagIndexClass HierarchicalTagIndexClass;
#define _hierarchical_tag_index_unref0(var) ((var == NULL) ? NULL : (var = (hierarchical_tag_index_unref (var), NULL)))

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_CONTAINER_SOURCE_COLLECTION (container_source_collection_get_type ())
#define CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection))
#define CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))
#define IS_CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE_COLLECTION))
#define IS_CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTAINER_SOURCE_COLLECTION))
#define CONTAINER_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))

typedef struct _ContainerSourceCollection ContainerSourceCollection;
typedef struct _ContainerSourceCollectionClass ContainerSourceCollectionClass;

#define TYPE_TAG_SOURCE_COLLECTION (tag_source_collection_get_type ())
#define TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollection))
#define TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))
#define IS_TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG_SOURCE_COLLECTION))
#define IS_TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG_SOURCE_COLLECTION))
#define TAG_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))

typedef struct _TagSourceCollection TagSourceCollection;
typedef struct _TagSourceCollectionClass TagSourceCollectionClass;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;
typedef struct _ParamSpecHierarchicalTagUtilities ParamSpecHierarchicalTagUtilities;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _HierarchicalTagUtilities {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HierarchicalTagUtilitiesPrivate * priv;
};

struct _HierarchicalTagUtilitiesClass {
	GTypeClass parent_class;
	void (*finalize) (HierarchicalTagUtilities *self);
};

struct _ParamSpecHierarchicalTagUtilities {
	GParamSpec parent_instance;
};


static gpointer hierarchical_tag_utilities_parent_class = NULL;
extern TagSourceCollection* tag_global;

gpointer hierarchical_tag_utilities_ref (gpointer instance);
void hierarchical_tag_utilities_unref (gpointer instance);
GParamSpec* param_spec_hierarchical_tag_utilities (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags);
void value_set_hierarchical_tag_utilities (GValue* value,
                                           gpointer v_object);
void value_take_hierarchical_tag_utilities (GValue* value,
                                            gpointer v_object);
gpointer value_get_hierarchical_tag_utilities (const GValue* value);
GType hierarchical_tag_utilities_get_type (void) G_GNUC_CONST;
gchar* hierarchical_tag_utilities_flat_to_hierarchical (const gchar* name);
#define TAG_PATH_SEPARATOR_STRING "/"
gchar* hierarchical_tag_utilities_hierarchical_to_flat (const gchar* path);
GeeList* hierarchical_tag_utilities_enumerate_path_components (const gchar* in_path);
GeeList* hierarchical_tag_utilities_enumerate_parent_paths (const gchar* in_path);
gchar* hierarchical_tag_utilities_join_path_components (gchar** path_components,
                                                        int path_components_length1);
gchar* hierarchical_tag_utilities_get_basename (const gchar* in_path);
gchar* hierarchical_tag_utilities_canonicalize (const gchar* in_tag,
                                                const gchar* foreign_separator);
gchar* hierarchical_tag_utilities_make_flat_tag_safe (const gchar* in_tag);
gpointer hierarchical_tag_index_ref (gpointer instance);
void hierarchical_tag_index_unref (gpointer instance);
GParamSpec* param_spec_hierarchical_tag_index (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
void value_set_hierarchical_tag_index (GValue* value,
                                       gpointer v_object);
void value_take_hierarchical_tag_index (GValue* value,
                                        gpointer v_object);
gpointer value_get_hierarchical_tag_index (const GValue* value);
GType hierarchical_tag_index_get_type (void) G_GNUC_CONST;
HierarchicalTagIndex* hierarchical_tag_utilities_process_hierarchical_import_keywords (GeeCollection* h_keywords);
HierarchicalTagIndex* hierarchical_tag_index_new (void);
HierarchicalTagIndex* hierarchical_tag_index_construct (GType object_type);
gboolean hierarchical_tag_index_is_path_known (HierarchicalTagIndex* self,
                                               const gchar* path);
void hierarchical_tag_index_add_path (HierarchicalTagIndex* self,
                                      const gchar* tag,
                                      const gchar* path);
gchar* hierarchical_tag_utilities_get_root_path_form (const gchar* client_path);
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void value_set_data_collection (GValue* value,
                                gpointer v_object);
void value_take_data_collection (GValue* value,
                                 gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType source_collection_get_type (void) G_GNUC_CONST;
GType database_source_collection_get_type (void) G_GNUC_CONST;
GType container_source_collection_get_type (void) G_GNUC_CONST;
GType tag_source_collection_get_type (void) G_GNUC_CONST;
gboolean tag_source_collection_exists (TagSourceCollection* self,
                                       const gchar* name,
                                       gboolean treat_htags_as_root);
void hierarchical_tag_utilities_cleanup_root_path (const gchar* path);
GType data_object_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType tag_get_type (void) G_GNUC_CONST;
Tag* tag_for_path (const gchar* name);
GeeList* tag_get_hierarchical_children (Tag* self);
void tag_flatten (Tag* self);
HierarchicalTagUtilities* hierarchical_tag_utilities_new (void);
HierarchicalTagUtilities* hierarchical_tag_utilities_construct (GType object_type);
static void hierarchical_tag_utilities_finalize (HierarchicalTagUtilities * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/** 
     * converts a flat tag name 'name' (e.g., "Animals") to a tag path compatible with the
     * hierarchical tag data model (e.g., "/Animals"). if 'name' is already a path compatible with
     * the hierarchical data model, 'name' is returned untouched
     */
gchar*
hierarchical_tag_utilities_flat_to_hierarchical (const gchar* name)
{
	gchar* result = NULL;
#line 14 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 15 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (!g_str_has_prefix (name, TAG_PATH_SEPARATOR_STRING)) {
#line 248 "HierarchicalTagUtilities.c"
		gchar* _tmp0_;
#line 16 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp0_ = g_strconcat (TAG_PATH_SEPARATOR_STRING, name, NULL);
#line 16 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		result = _tmp0_;
#line 16 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		return result;
#line 256 "HierarchicalTagUtilities.c"
	} else {
		gchar* _tmp1_;
#line 18 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp1_ = g_strdup (name);
#line 18 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		result = _tmp1_;
#line 18 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		return result;
#line 265 "HierarchicalTagUtilities.c"
	}
}


/**
     * converts a hierarchical tag path 'path' (e.g., "/Animals") to a flat tag name
     * (e.g., "Animals"); if 'path' is already a flat tag name, 'path' is returned untouched; note
     * that 'path' must be a top-level path (i.e., "/Animals" not "/Animals/Mammals/…") with
     * only one path component; invoking this method with a 'path' argument other than a top-level
     * path will cause an assertion failure.
     */
static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 1336 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1336 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	end = _tmp0_;
#line 1337 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = end;
#line 1337 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1338 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = maxlen;
#line 1338 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 297 "HierarchicalTagUtilities.c"
	} else {
		gchar* _tmp2_;
#line 1340 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = end;
#line 1340 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1340 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 306 "HierarchicalTagUtilities.c"
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
#line 1347 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 327 "HierarchicalTagUtilities.c"
	} else {
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 331 "HierarchicalTagUtilities.c"
	}
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 1351 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 337 "HierarchicalTagUtilities.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1353 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1353 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1353 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 347 "HierarchicalTagUtilities.c"
	}
#line 1356 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 351 "HierarchicalTagUtilities.c"
		glong _tmp3_;
#line 1357 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1357 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		offset = _tmp3_ + offset;
#line 1358 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 359 "HierarchicalTagUtilities.c"
	} else {
		glong _tmp4_;
#line 1360 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp4_ = string_length;
#line 1360 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_return_val_if_fail (offset <= _tmp4_, NULL);
#line 366 "HierarchicalTagUtilities.c"
	}
#line 1362 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 370 "HierarchicalTagUtilities.c"
		glong _tmp5_;
#line 1363 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp5_ = string_length;
#line 1363 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		len = _tmp5_ - offset;
#line 376 "HierarchicalTagUtilities.c"
	}
#line 1365 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp6_ = string_length;
#line 1365 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
#line 1366 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1366 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp7_;
#line 1366 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 388 "HierarchicalTagUtilities.c"
}


gchar*
hierarchical_tag_utilities_hierarchical_to_flat (const gchar* path)
{
	gchar* result = NULL;
#line 28 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 29 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (g_str_has_prefix (path, TAG_PATH_SEPARATOR_STRING)) {
#line 400 "HierarchicalTagUtilities.c"
		GeeList* _tmp0_;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gchar* _tmp4_;
#line 30 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp0_ = hierarchical_tag_utilities_enumerate_path_components (path);
#line 30 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp1_ = _tmp0_;
#line 30 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
#line 30 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp3_ = _tmp2_;
#line 30 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_vala_assert (_tmp3_ == 1, "enumerate_path_components(path).size == 1");
#line 30 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_g_object_unref0 (_tmp1_);
#line 32 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp4_ = string_substring (path, (glong) 1, (glong) -1);
#line 32 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		result = _tmp4_;
#line 32 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		return result;
#line 424 "HierarchicalTagUtilities.c"
	} else {
		gchar* _tmp5_;
#line 34 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp5_ = g_strdup (path);
#line 34 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		result = _tmp5_;
#line 34 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		return result;
#line 433 "HierarchicalTagUtilities.c"
	}
}


/**
     * given a path 'path', generate all parent paths of 'path' and return them in sorted order,
     * from most basic to most derived. For example, if 'path' == "/Animals/Mammals/Elephant",
     * the list { "/Animals", "/Animals/Mammals" } is returned
     */
GeeList*
hierarchical_tag_utilities_enumerate_parent_paths (const gchar* in_path)
{
	GeeList* result = NULL;
	gchar* path = NULL;
	gchar* _tmp0_;
	GeeList* _result_ = NULL;
	GeeArrayList* _tmp1_;
	gchar* accumulator = NULL;
	gchar* _tmp2_;
#line 43 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	g_return_val_if_fail (in_path != NULL, NULL);
#line 44 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp0_ = hierarchical_tag_utilities_flat_to_hierarchical (in_path);
#line 44 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	path = _tmp0_;
#line 46 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 46 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_result_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_LIST, GeeList);
#line 48 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp2_ = g_strdup ("");
#line 48 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	accumulator = _tmp2_;
#line 467 "HierarchicalTagUtilities.c"
	{
		GeeList* _component_list = NULL;
		const gchar* _tmp3_;
		GeeList* _tmp4_;
		gint _component_size = 0;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _component_index = 0;
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp3_ = path;
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp4_ = hierarchical_tag_utilities_enumerate_path_components (_tmp3_);
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_component_list = _tmp4_;
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp5_ = _component_list;
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp6_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp7_ = _tmp6_;
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_component_size = _tmp7_;
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_component_index = -1;
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		while (TRUE) {
#line 495 "HierarchicalTagUtilities.c"
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			gchar* component = NULL;
			GeeList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp8_ = _component_index;
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_component_index = _tmp8_ + 1;
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp9_ = _component_index;
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp10_ = _component_size;
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			if (!(_tmp9_ < _tmp10_)) {
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				break;
#line 522 "HierarchicalTagUtilities.c"
			}
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp11_ = _component_list;
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp12_ = _component_index;
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp13_ = gee_list_get (_tmp11_, _tmp12_);
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			component = (gchar*) _tmp13_;
#line 50 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp14_ = accumulator;
#line 50 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp15_ = component;
#line 50 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp16_ = g_strconcat (TAG_PATH_SEPARATOR_STRING, _tmp15_, NULL);
#line 50 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp17_ = _tmp16_;
#line 50 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp18_ = g_strconcat (_tmp14_, _tmp17_, NULL);
#line 50 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_g_free0 (accumulator);
#line 50 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			accumulator = _tmp18_;
#line 50 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_g_free0 (_tmp17_);
#line 51 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp19_ = accumulator;
#line 51 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp20_ = path;
#line 51 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			if (g_strcmp0 (_tmp19_, _tmp20_) != 0) {
#line 554 "HierarchicalTagUtilities.c"
				GeeList* _tmp21_;
				const gchar* _tmp22_;
#line 52 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				_tmp21_ = _result_;
#line 52 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				_tmp22_ = accumulator;
#line 52 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_COLLECTION, GeeCollection), _tmp22_);
#line 563 "HierarchicalTagUtilities.c"
			}
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_g_free0 (component);
#line 567 "HierarchicalTagUtilities.c"
		}
#line 49 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_g_object_unref0 (_component_list);
#line 571 "HierarchicalTagUtilities.c"
	}
#line 55 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	result = _result_;
#line 55 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_g_free0 (accumulator);
#line 55 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_g_free0 (path);
#line 55 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	return result;
#line 581 "HierarchicalTagUtilities.c"
}


/**
     * given a path 'path', enumerate all of the components of 'path' and return them in
     * order, excluding the path component separator. For example if
     * 'path' == "/Animals/Mammals/Elephant" the list { "Animals",  "Mammals", "Elephant" } will
     * be returned
     */
GeeList*
hierarchical_tag_utilities_enumerate_path_components (const gchar* in_path)
{
	GeeList* result = NULL;
	gchar* path = NULL;
	gchar* _tmp0_;
	GeeArrayList* components = NULL;
	GeeArrayList* _tmp1_;
	gchar** raw_components = NULL;
	const gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint raw_components_length1;
	gint _raw_components_size_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	GeeArrayList* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
#line 64 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	g_return_val_if_fail (in_path != NULL, NULL);
#line 65 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp0_ = hierarchical_tag_utilities_flat_to_hierarchical (in_path);
#line 65 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	path = _tmp0_;
#line 67 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 67 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	components = _tmp1_;
#line 69 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp2_ = path;
#line 69 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, TAG_PATH_SEPARATOR_STRING, 0);
#line 69 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	raw_components = _tmp4_;
#line 69 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	raw_components_length1 = _vala_array_length (_tmp3_);
#line 69 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_raw_components_size_ = raw_components_length1;
#line 71 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp5_ = raw_components;
#line 71 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp5__length1 = raw_components_length1;
#line 634 "HierarchicalTagUtilities.c"
	{
		gchar** component_collection = NULL;
		gint component_collection_length1 = 0;
		gint _component_collection_size_ = 0;
		gint component_it = 0;
#line 71 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		component_collection = _tmp5_;
#line 71 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		component_collection_length1 = _tmp5__length1;
#line 71 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		for (component_it = 0; component_it < _tmp5__length1; component_it = component_it + 1) {
#line 646 "HierarchicalTagUtilities.c"
			gchar* _tmp6_;
			gchar* component = NULL;
#line 71 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp6_ = g_strdup (component_collection[component_it]);
#line 71 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			component = _tmp6_;
#line 653 "HierarchicalTagUtilities.c"
			{
				const gchar* _tmp7_;
#line 72 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				_tmp7_ = component;
#line 72 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				if (g_strcmp0 (_tmp7_, "") != 0) {
#line 660 "HierarchicalTagUtilities.c"
					GeeArrayList* _tmp8_;
					const gchar* _tmp9_;
#line 73 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
					_tmp8_ = components;
#line 73 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
					_tmp9_ = component;
#line 73 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp9_);
#line 669 "HierarchicalTagUtilities.c"
				}
#line 71 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				_g_free0 (component);
#line 673 "HierarchicalTagUtilities.c"
			}
		}
	}
#line 76 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp10_ = components;
#line 76 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp11_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 76 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp12_ = _tmp11_;
#line 76 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_vala_assert (_tmp12_ > 0, "components.size > 0");
#line 78 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (components, GEE_TYPE_LIST, GeeList);
#line 78 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	raw_components = (_vala_array_free (raw_components, raw_components_length1, (GDestroyNotify) g_free), NULL);
#line 78 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_g_free0 (path);
#line 78 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	return result;
#line 693 "HierarchicalTagUtilities.c"
}


/**
     * given a list of path elements, create a fully qualified path string.
     * For example if 'path_elements' is the list { "Animals",  "Mammals", "Elephant" }
     * the path "/Animals/Mammals/Elephant" will be returned
     */
static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  int str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
#line 1092 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (separator == NULL) {
#line 1093 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		separator = "";
#line 713 "HierarchicalTagUtilities.c"
	}
#line 1095 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (str_array != NULL) {
#line 717 "HierarchicalTagUtilities.c"
		gboolean _tmp1_ = FALSE;
#line 1095 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		if (str_array_length1 > 0) {
#line 1095 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			_tmp1_ = TRUE;
#line 723 "HierarchicalTagUtilities.c"
		} else {
			gboolean _tmp2_ = FALSE;
#line 1095 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			if (str_array_length1 == -1) {
#line 728 "HierarchicalTagUtilities.c"
				const gchar* _tmp3_;
#line 1095 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
				_tmp3_ = str_array[0];
#line 1095 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
				_tmp2_ = _tmp3_ != NULL;
#line 734 "HierarchicalTagUtilities.c"
			} else {
#line 1095 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
				_tmp2_ = FALSE;
#line 738 "HierarchicalTagUtilities.c"
			}
#line 1095 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			_tmp1_ = _tmp2_;
#line 742 "HierarchicalTagUtilities.c"
		}
#line 1095 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp1_;
#line 746 "HierarchicalTagUtilities.c"
	} else {
#line 1095 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 750 "HierarchicalTagUtilities.c"
	}
#line 1095 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 754 "HierarchicalTagUtilities.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp20_;
		gint _tmp22_;
		gint _tmp23_;
		gsize _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		const gchar* res = NULL;
		gsize _tmp28_;
		void* _tmp29_;
		void* ptr = NULL;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		void* _tmp32_;
		const gchar* _tmp45_;
#line 1097 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		len = (gsize) 1;
#line 774 "HierarchicalTagUtilities.c"
		{
			gboolean _tmp4_ = FALSE;
#line 1098 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			i = 0;
#line 1098 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			_tmp4_ = TRUE;
#line 1098 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 783 "HierarchicalTagUtilities.c"
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp12_ = 0;
				gint _tmp13_;
				const gchar* _tmp14_;
				gsize _tmp19_;
#line 1098 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
				if (!_tmp4_) {
#line 792 "HierarchicalTagUtilities.c"
					gint _tmp5_;
#line 1098 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp5_ = i;
#line 1098 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
					i = _tmp5_ + 1;
#line 798 "HierarchicalTagUtilities.c"
				}
#line 1098 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
				_tmp4_ = FALSE;
#line 1098 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
				if (str_array_length1 != -1) {
#line 804 "HierarchicalTagUtilities.c"
					gint _tmp8_;
#line 1098 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp8_ = i;
#line 1098 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp7_ = _tmp8_ < str_array_length1;
#line 810 "HierarchicalTagUtilities.c"
				} else {
#line 1098 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp7_ = FALSE;
#line 814 "HierarchicalTagUtilities.c"
				}
#line 1098 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
				if (_tmp7_) {
#line 1098 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp6_ = TRUE;
#line 820 "HierarchicalTagUtilities.c"
				} else {
					gboolean _tmp9_ = FALSE;
#line 1098 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
					if (str_array_length1 == -1) {
#line 825 "HierarchicalTagUtilities.c"
						gint _tmp10_;
						const gchar* _tmp11_;
#line 1098 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
						_tmp10_ = i;
#line 1098 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
						_tmp11_ = str_array[_tmp10_];
#line 1098 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
						_tmp9_ = _tmp11_ != NULL;
#line 834 "HierarchicalTagUtilities.c"
					} else {
#line 1098 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
						_tmp9_ = FALSE;
#line 838 "HierarchicalTagUtilities.c"
					}
#line 1098 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp6_ = _tmp9_;
#line 842 "HierarchicalTagUtilities.c"
				}
#line 1098 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
				if (!_tmp6_) {
#line 1098 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
					break;
#line 848 "HierarchicalTagUtilities.c"
				}
#line 1099 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
				_tmp13_ = i;
#line 1099 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
				_tmp14_ = str_array[_tmp13_];
#line 1099 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
				if (_tmp14_ != NULL) {
#line 856 "HierarchicalTagUtilities.c"
					gint _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
#line 1099 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp15_ = i;
#line 1099 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp16_ = str_array[_tmp15_];
#line 1099 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp17_ = strlen ((const gchar*) _tmp16_);
#line 1099 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp18_ = _tmp17_;
#line 1099 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp12_ = _tmp18_;
#line 871 "HierarchicalTagUtilities.c"
				} else {
#line 1099 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp12_ = 0;
#line 875 "HierarchicalTagUtilities.c"
				}
#line 1099 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
				_tmp19_ = len;
#line 1099 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
				len = _tmp19_ + _tmp12_;
#line 881 "HierarchicalTagUtilities.c"
			}
		}
#line 1101 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp20_ = i;
#line 1101 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		if (_tmp20_ == 0) {
#line 888 "HierarchicalTagUtilities.c"
			gchar* _tmp21_;
#line 1102 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			_tmp21_ = g_strdup ("");
#line 1102 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			result = _tmp21_;
#line 1102 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			return result;
#line 896 "HierarchicalTagUtilities.c"
		}
#line 1104 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp22_ = i;
#line 1104 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		str_array_length1 = _tmp22_;
#line 1104 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp23_ = str_array_length1;
#line 1105 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp24_ = len;
#line 1105 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp25_ = strlen ((const gchar*) separator);
#line 1105 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp26_ = _tmp25_;
#line 1105 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp27_ = i;
#line 1105 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		len = _tmp24_ + (_tmp26_ * (_tmp27_ - 1));
#line 1107 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp28_ = len;
#line 1107 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp29_ = g_malloc (_tmp28_);
#line 1107 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		res = _tmp29_;
#line 1108 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp30_ = res;
#line 1108 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp31_ = str_array[0];
#line 1108 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp32_ = g_stpcpy ((void*) _tmp30_, (const gchar*) _tmp31_);
#line 1108 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		ptr = _tmp32_;
#line 928 "HierarchicalTagUtilities.c"
		{
			gboolean _tmp33_ = FALSE;
#line 1109 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			i = 1;
#line 1109 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			_tmp33_ = TRUE;
#line 1109 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 937 "HierarchicalTagUtilities.c"
				gint _tmp35_;
				void* _tmp36_;
				void* _tmp37_;
				const gchar* _tmp38_ = NULL;
				gint _tmp39_;
				const gchar* _tmp40_;
				void* _tmp43_;
				void* _tmp44_;
#line 1109 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
				if (!_tmp33_) {
#line 948 "HierarchicalTagUtilities.c"
					gint _tmp34_;
#line 1109 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp34_ = i;
#line 1109 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
					i = _tmp34_ + 1;
#line 954 "HierarchicalTagUtilities.c"
				}
#line 1109 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
				_tmp33_ = FALSE;
#line 1109 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
				_tmp35_ = i;
#line 1109 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
				if (!(_tmp35_ < str_array_length1)) {
#line 1109 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
					break;
#line 964 "HierarchicalTagUtilities.c"
				}
#line 1110 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
				_tmp36_ = ptr;
#line 1110 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
				_tmp37_ = g_stpcpy (_tmp36_, (const gchar*) separator);
#line 1110 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
				ptr = _tmp37_;
#line 1111 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
				_tmp39_ = i;
#line 1111 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
				_tmp40_ = str_array[_tmp39_];
#line 1111 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
				if (_tmp40_ != NULL) {
#line 978 "HierarchicalTagUtilities.c"
					gint _tmp41_;
					const gchar* _tmp42_;
#line 1111 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp41_ = i;
#line 1111 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp42_ = str_array[_tmp41_];
#line 1111 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp38_ = (const gchar*) _tmp42_;
#line 987 "HierarchicalTagUtilities.c"
				} else {
#line 1111 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
					_tmp38_ = "";
#line 991 "HierarchicalTagUtilities.c"
				}
#line 1111 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
				_tmp43_ = ptr;
#line 1111 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
				_tmp44_ = g_stpcpy (_tmp43_, _tmp38_);
#line 1111 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
				ptr = _tmp44_;
#line 999 "HierarchicalTagUtilities.c"
			}
		}
#line 1114 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp45_ = res;
#line 1114 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		res = NULL;
#line 1114 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = (gchar*) _tmp45_;
#line 1114 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 1010 "HierarchicalTagUtilities.c"
	} else {
		gchar* _tmp46_;
#line 1116 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp46_ = g_strdup ("");
#line 1116 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = _tmp46_;
#line 1116 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 1019 "HierarchicalTagUtilities.c"
	}
}


gchar*
hierarchical_tag_utilities_join_path_components (gchar** path_components,
                                                 int path_components_length1)
{
	gchar* result = NULL;
	gchar* tmp = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar* _tmp6_;
	gchar* _tmp7_;
#line 87 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (path_components_length1 <= 0) {
#line 88 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		result = NULL;
#line 88 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		return result;
#line 1045 "HierarchicalTagUtilities.c"
	}
#line 89 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp0_ = _vala_g_strjoinv (TAG_PATH_SEPARATOR_STRING, path_components, path_components_length1);
#line 89 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	tmp = _tmp0_;
#line 90 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp1_ = g_strdup ("");
#line 90 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp2_ = tmp;
#line 90 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 90 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp4_ = g_new0 (gchar*, 2 + 1);
#line 90 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp4_[0] = _tmp1_;
#line 90 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp4_[1] = _tmp3_;
#line 90 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp5_ = _tmp4_;
#line 90 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp5__length1 = 2;
#line 90 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp6_ = _vala_g_strjoinv (TAG_PATH_SEPARATOR_STRING, _tmp5_, 2);
#line 90 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp7_ = _tmp6_;
#line 90 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
#line 90 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	result = _tmp7_;
#line 90 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_g_free0 (tmp);
#line 90 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	return result;
#line 1079 "HierarchicalTagUtilities.c"
}


gchar*
hierarchical_tag_utilities_get_basename (const gchar* in_path)
{
	gchar* result = NULL;
	gchar* path = NULL;
	gchar* _tmp0_;
	GeeList* components = NULL;
	GeeList* _tmp1_;
	gchar* basename = NULL;
	gint _tmp2_;
	gint _tmp3_;
	gpointer _tmp4_;
#line 93 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	g_return_val_if_fail (in_path != NULL, NULL);
#line 94 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp0_ = hierarchical_tag_utilities_flat_to_hierarchical (in_path);
#line 94 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	path = _tmp0_;
#line 96 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp1_ = hierarchical_tag_utilities_enumerate_path_components (path);
#line 96 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	components = _tmp1_;
#line 98 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (components, GEE_TYPE_COLLECTION, GeeCollection));
#line 98 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp3_ = _tmp2_;
#line 98 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp4_ = gee_list_get (components, _tmp3_ - 1);
#line 98 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	basename = (gchar*) _tmp4_;
#line 100 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	result = basename;
#line 100 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_g_object_unref0 (components);
#line 100 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_g_free0 (path);
#line 100 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	return result;
#line 1121 "HierarchicalTagUtilities.c"
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
#line 1421 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1421 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1421 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 1144 "HierarchicalTagUtilities.c"
	} else {
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 1148 "HierarchicalTagUtilities.c"
	}
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp1_) {
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 1154 "HierarchicalTagUtilities.c"
	} else {
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 1158 "HierarchicalTagUtilities.c"
	}
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 1162 "HierarchicalTagUtilities.c"
		gchar* _tmp2_;
#line 1423 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1423 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = _tmp2_;
#line 1423 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 1170 "HierarchicalTagUtilities.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		regex = _tmp6_;
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1198 "HierarchicalTagUtilities.c"
				goto __catch63_g_regex_error;
			}
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			return NULL;
#line 1207 "HierarchicalTagUtilities.c"
		}
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp8_ = regex;
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1221 "HierarchicalTagUtilities.c"
				goto __catch63_g_regex_error;
			}
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			return NULL;
#line 1232 "HierarchicalTagUtilities.c"
		}
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = _tmp10_;
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 1246 "HierarchicalTagUtilities.c"
	}
	goto __finally63;
	__catch63_g_regex_error:
	{
		GError* e = NULL;
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1429 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 1260 "HierarchicalTagUtilities.c"
	}
	__finally63:
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return NULL;
#line 1271 "HierarchicalTagUtilities.c"
	}
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
#line 1124 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1125 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1125 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp0_;
#line 1125 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 1290 "HierarchicalTagUtilities.c"
}


gchar*
hierarchical_tag_utilities_canonicalize (const gchar* in_tag,
                                         const gchar* foreign_separator)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean is_valid = FALSE;
	const gchar* _tmp12_ = NULL;
	gboolean _tmp13_;
	gchar* _tmp15_;
#line 103 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	g_return_val_if_fail (in_tag != NULL, NULL);
#line 103 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	g_return_val_if_fail (foreign_separator != NULL, NULL);
#line 104 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp0_ = string_replace (in_tag, foreign_separator, TAG_PATH_SEPARATOR_STRING);
#line 104 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_result_ = _tmp0_;
#line 106 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp1_ = _result_;
#line 106 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (!g_str_has_prefix (_tmp1_, TAG_PATH_SEPARATOR_STRING)) {
#line 1318 "HierarchicalTagUtilities.c"
		const gchar* _tmp2_;
		gchar* _tmp3_;
#line 107 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp2_ = _result_;
#line 107 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp3_ = g_strconcat (TAG_PATH_SEPARATOR_STRING, _tmp2_, NULL);
#line 107 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_g_free0 (_result_);
#line 107 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_result_ = _tmp3_;
#line 1329 "HierarchicalTagUtilities.c"
	}
#line 110 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	is_valid = FALSE;
#line 1333 "HierarchicalTagUtilities.c"
	{
		gint i = 0;
#line 111 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		i = 0;
#line 1338 "HierarchicalTagUtilities.c"
		{
			gboolean _tmp4_ = FALSE;
#line 111 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp4_ = TRUE;
#line 111 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			while (TRUE) {
#line 1345 "HierarchicalTagUtilities.c"
				gint _tmp6_;
				const gchar* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				const gchar* _tmp10_;
				gint _tmp11_;
#line 111 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				if (!_tmp4_) {
#line 1354 "HierarchicalTagUtilities.c"
					gint _tmp5_;
#line 111 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
					_tmp5_ = i;
#line 111 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
					i = _tmp5_ + 1;
#line 1360 "HierarchicalTagUtilities.c"
				}
#line 111 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				_tmp4_ = FALSE;
#line 111 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				_tmp6_ = i;
#line 111 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				_tmp7_ = _result_;
#line 111 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				_tmp8_ = strlen (_tmp7_);
#line 111 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				_tmp9_ = _tmp8_;
#line 111 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				if (!(_tmp6_ < _tmp9_)) {
#line 111 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
					break;
#line 1376 "HierarchicalTagUtilities.c"
				}
#line 112 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				_tmp10_ = _result_;
#line 112 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				_tmp11_ = i;
#line 112 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				if (string_get (_tmp10_, (glong) _tmp11_) != string_get (TAG_PATH_SEPARATOR_STRING, (glong) 0)) {
#line 113 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
					is_valid = TRUE;
#line 114 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
					break;
#line 1388 "HierarchicalTagUtilities.c"
				}
			}
		}
	}
#line 118 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp13_ = is_valid;
#line 118 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (_tmp13_) {
#line 1397 "HierarchicalTagUtilities.c"
		const gchar* _tmp14_;
#line 118 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp14_ = _result_;
#line 118 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp12_ = _tmp14_;
#line 1403 "HierarchicalTagUtilities.c"
	} else {
#line 118 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp12_ = NULL;
#line 1407 "HierarchicalTagUtilities.c"
	}
#line 118 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp15_ = g_strdup (_tmp12_);
#line 118 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	result = _tmp15_;
#line 118 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_g_free0 (_result_);
#line 118 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	return result;
#line 1417 "HierarchicalTagUtilities.c"
}


gchar*
hierarchical_tag_utilities_make_flat_tag_safe (const gchar* in_tag)
{
	gchar* result = NULL;
	gchar* _tmp0_;
#line 121 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	g_return_val_if_fail (in_tag != NULL, NULL);
#line 122 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp0_ = string_replace (in_tag, TAG_PATH_SEPARATOR_STRING, "-");
#line 122 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	result = _tmp0_;
#line 122 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	return result;
#line 1434 "HierarchicalTagUtilities.c"
}


HierarchicalTagIndex*
hierarchical_tag_utilities_process_hierarchical_import_keywords (GeeCollection* h_keywords)
{
	HierarchicalTagIndex* result = NULL;
	HierarchicalTagIndex* index = NULL;
	HierarchicalTagIndex* _tmp0_;
#line 125 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (h_keywords), NULL);
#line 126 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp0_ = hierarchical_tag_index_new ();
#line 126 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	index = _tmp0_;
#line 1450 "HierarchicalTagUtilities.c"
	{
		GeeIterator* _keyword_it = NULL;
		GeeIterator* _tmp1_;
#line 128 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (h_keywords, GEE_TYPE_ITERABLE, GeeIterable));
#line 128 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_keyword_it = _tmp1_;
#line 128 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		while (TRUE) {
#line 1460 "HierarchicalTagUtilities.c"
			GeeIterator* _tmp2_;
			gchar* keyword = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			GeeList* parent_paths = NULL;
			const gchar* _tmp5_;
			GeeList* _tmp6_;
			GeeList* path_components = NULL;
			const gchar* _tmp7_;
			GeeList* _tmp8_;
			GeeList* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			GeeList* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			HierarchicalTagIndex* _tmp36_;
			const gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			const gchar* _tmp40_;
#line 128 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp2_ = _keyword_it;
#line 128 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			if (!gee_iterator_next (_tmp2_)) {
#line 128 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				break;
#line 1488 "HierarchicalTagUtilities.c"
			}
#line 128 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp3_ = _keyword_it;
#line 128 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp4_ = gee_iterator_get (_tmp3_);
#line 128 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			keyword = (gchar*) _tmp4_;
#line 129 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp5_ = keyword;
#line 129 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp6_ = hierarchical_tag_utilities_enumerate_parent_paths (_tmp5_);
#line 129 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			parent_paths = _tmp6_;
#line 131 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp7_ = keyword;
#line 131 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp8_ = hierarchical_tag_utilities_enumerate_path_components (_tmp7_);
#line 131 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			path_components = _tmp8_;
#line 134 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp9_ = parent_paths;
#line 134 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp10_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_COLLECTION, GeeCollection));
#line 134 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp11_ = _tmp10_;
#line 134 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp12_ = path_components;
#line 134 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp13_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_COLLECTION, GeeCollection));
#line 134 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp14_ = _tmp13_;
#line 134 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_vala_assert (_tmp11_ <= _tmp14_, "parent_paths.size <= path_components.size");
#line 1522 "HierarchicalTagUtilities.c"
			{
				gint i = 0;
#line 136 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
				i = 0;
#line 1527 "HierarchicalTagUtilities.c"
				{
					gboolean _tmp15_ = FALSE;
#line 136 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
					_tmp15_ = TRUE;
#line 136 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
					while (TRUE) {
#line 1534 "HierarchicalTagUtilities.c"
						gint _tmp17_;
						GeeList* _tmp18_;
						gint _tmp19_;
						gint _tmp20_;
						HierarchicalTagIndex* _tmp21_;
						GeeList* _tmp22_;
						gint _tmp23_;
						gpointer _tmp24_;
						gchar* _tmp25_;
						gboolean _tmp26_;
#line 136 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
						if (!_tmp15_) {
#line 1547 "HierarchicalTagUtilities.c"
							gint _tmp16_;
#line 136 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
							_tmp16_ = i;
#line 136 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
							i = _tmp16_ + 1;
#line 1553 "HierarchicalTagUtilities.c"
						}
#line 136 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
						_tmp15_ = FALSE;
#line 136 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
						_tmp17_ = i;
#line 136 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
						_tmp18_ = parent_paths;
#line 136 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
						_tmp19_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_COLLECTION, GeeCollection));
#line 136 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
						_tmp20_ = _tmp19_;
#line 136 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
						if (!(_tmp17_ < _tmp20_)) {
#line 136 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
							break;
#line 1569 "HierarchicalTagUtilities.c"
						}
#line 137 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
						_tmp21_ = index;
#line 137 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
						_tmp22_ = path_components;
#line 137 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
						_tmp23_ = i;
#line 137 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
						_tmp24_ = gee_list_get (_tmp22_, _tmp23_);
#line 137 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
						_tmp25_ = (gchar*) _tmp24_;
#line 137 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
						_tmp26_ = !hierarchical_tag_index_is_path_known (_tmp21_, _tmp25_);
#line 137 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
						_g_free0 (_tmp25_);
#line 137 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
						if (_tmp26_) {
#line 1587 "HierarchicalTagUtilities.c"
							HierarchicalTagIndex* _tmp27_;
							GeeList* _tmp28_;
							gint _tmp29_;
							gpointer _tmp30_;
							gchar* _tmp31_;
							GeeList* _tmp32_;
							gint _tmp33_;
							gpointer _tmp34_;
							gchar* _tmp35_;
#line 138 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
							_tmp27_ = index;
#line 138 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
							_tmp28_ = path_components;
#line 138 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
							_tmp29_ = i;
#line 138 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
							_tmp30_ = gee_list_get (_tmp28_, _tmp29_);
#line 138 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
							_tmp31_ = (gchar*) _tmp30_;
#line 138 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
							_tmp32_ = parent_paths;
#line 138 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
							_tmp33_ = i;
#line 138 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
							_tmp34_ = gee_list_get (_tmp32_, _tmp33_);
#line 138 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
							_tmp35_ = (gchar*) _tmp34_;
#line 138 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
							hierarchical_tag_index_add_path (_tmp27_, _tmp31_, _tmp35_);
#line 138 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
							_g_free0 (_tmp35_);
#line 138 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
							_g_free0 (_tmp31_);
#line 1621 "HierarchicalTagUtilities.c"
						}
					}
				}
			}
#line 141 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp36_ = index;
#line 141 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp37_ = keyword;
#line 141 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp38_ = hierarchical_tag_utilities_get_basename (_tmp37_);
#line 141 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp39_ = _tmp38_;
#line 141 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp40_ = keyword;
#line 141 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			hierarchical_tag_index_add_path (_tmp36_, _tmp39_, _tmp40_);
#line 141 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_g_free0 (_tmp39_);
#line 128 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_g_object_unref0 (path_components);
#line 128 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_g_object_unref0 (parent_paths);
#line 128 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_g_free0 (keyword);
#line 1646 "HierarchicalTagUtilities.c"
		}
#line 128 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_g_object_unref0 (_keyword_it);
#line 1650 "HierarchicalTagUtilities.c"
	}
#line 144 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	result = index;
#line 144 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	return result;
#line 1656 "HierarchicalTagUtilities.c"
}


gchar*
hierarchical_tag_utilities_get_root_path_form (const gchar* client_path)
{
	gchar* result = NULL;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean _tmp4_;
	gchar* path = NULL;
	gchar* _tmp6_;
	TagSourceCollection* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp14_ = NULL;
	TagSourceCollection* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp18_;
#line 148 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (client_path == NULL) {
#line 149 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		result = NULL;
#line 149 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		return result;
#line 1683 "HierarchicalTagUtilities.c"
	}
#line 151 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp0_ = hierarchical_tag_utilities_enumerate_parent_paths (client_path);
#line 151 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp1_ = _tmp0_;
#line 151 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
#line 151 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp3_ = _tmp2_;
#line 151 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp4_ = _tmp3_ != 0;
#line 151 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_g_object_unref0 (_tmp1_);
#line 151 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (_tmp4_) {
#line 1699 "HierarchicalTagUtilities.c"
		gchar* _tmp5_;
#line 152 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp5_ = g_strdup (client_path);
#line 152 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		result = _tmp5_;
#line 152 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		return result;
#line 1707 "HierarchicalTagUtilities.c"
	}
#line 154 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp6_ = g_strdup (client_path);
#line 154 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	path = _tmp6_;
#line 156 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp7_ = tag_global;
#line 156 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp8_ = path;
#line 156 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (!tag_source_collection_exists (_tmp7_, _tmp8_, FALSE)) {
#line 1719 "HierarchicalTagUtilities.c"
		const gchar* _tmp9_;
#line 157 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp9_ = path;
#line 157 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		if (g_str_has_prefix (_tmp9_, TAG_PATH_SEPARATOR_STRING)) {
#line 1725 "HierarchicalTagUtilities.c"
			const gchar* _tmp10_;
			gchar* _tmp11_;
#line 158 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp10_ = path;
#line 158 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp11_ = hierarchical_tag_utilities_hierarchical_to_flat (_tmp10_);
#line 158 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_g_free0 (path);
#line 158 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			path = _tmp11_;
#line 1736 "HierarchicalTagUtilities.c"
		} else {
			const gchar* _tmp12_;
			gchar* _tmp13_;
#line 160 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp12_ = path;
#line 160 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp13_ = hierarchical_tag_utilities_flat_to_hierarchical (_tmp12_);
#line 160 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_g_free0 (path);
#line 160 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			path = _tmp13_;
#line 1748 "HierarchicalTagUtilities.c"
		}
	}
#line 163 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp15_ = tag_global;
#line 163 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp16_ = path;
#line 163 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (tag_source_collection_exists (_tmp15_, _tmp16_, FALSE)) {
#line 1757 "HierarchicalTagUtilities.c"
		const gchar* _tmp17_;
#line 163 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp17_ = path;
#line 163 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp14_ = _tmp17_;
#line 1763 "HierarchicalTagUtilities.c"
	} else {
#line 163 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp14_ = NULL;
#line 1767 "HierarchicalTagUtilities.c"
	}
#line 163 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp18_ = g_strdup (_tmp14_);
#line 163 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	result = _tmp18_;
#line 163 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_g_free0 (path);
#line 163 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	return result;
#line 1777 "HierarchicalTagUtilities.c"
}


void
hierarchical_tag_utilities_cleanup_root_path (const gchar* path)
{
	GeeList* paths = NULL;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
#line 166 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	g_return_if_fail (path != NULL);
#line 167 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp0_ = hierarchical_tag_utilities_enumerate_parent_paths (path);
#line 167 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	paths = _tmp0_;
#line 169 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp1_ = paths;
#line 169 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
#line 169 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_tmp3_ = _tmp2_;
#line 169 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (_tmp3_ == 0) {
#line 1803 "HierarchicalTagUtilities.c"
		gchar* actual_path = NULL;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		Tag* t = NULL;
		TagSourceCollection* _tmp6_;
		const gchar* _tmp7_;
		gboolean _tmp10_ = FALSE;
		Tag* _tmp11_;
#line 170 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp4_ = hierarchical_tag_utilities_get_root_path_form (path);
#line 170 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		actual_path = _tmp4_;
#line 172 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp5_ = actual_path;
#line 172 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		if (_tmp5_ == NULL) {
#line 173 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_g_free0 (actual_path);
#line 173 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_g_object_unref0 (paths);
#line 173 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			return;
#line 1826 "HierarchicalTagUtilities.c"
		}
#line 175 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		t = NULL;
#line 176 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp6_ = tag_global;
#line 176 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp7_ = actual_path;
#line 176 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		if (tag_source_collection_exists (_tmp6_, _tmp7_, FALSE)) {
#line 1836 "HierarchicalTagUtilities.c"
			const gchar* _tmp8_;
			Tag* _tmp9_;
#line 177 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp8_ = actual_path;
#line 177 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp9_ = tag_for_path (_tmp8_);
#line 177 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_g_object_unref0 (t);
#line 177 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			t = _tmp9_;
#line 1847 "HierarchicalTagUtilities.c"
		}
#line 179 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_tmp11_ = t;
#line 179 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		if (_tmp11_ != NULL) {
#line 1853 "HierarchicalTagUtilities.c"
			Tag* _tmp12_;
			GeeList* _tmp13_;
			GeeList* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
#line 179 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp12_ = t;
#line 179 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp13_ = tag_get_hierarchical_children (_tmp12_);
#line 179 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp14_ = _tmp13_;
#line 179 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp15_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_COLLECTION, GeeCollection));
#line 179 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp16_ = _tmp15_;
#line 179 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp10_ = _tmp16_ == 0;
#line 179 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_g_object_unref0 (_tmp14_);
#line 1873 "HierarchicalTagUtilities.c"
		} else {
#line 179 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp10_ = FALSE;
#line 1877 "HierarchicalTagUtilities.c"
		}
#line 179 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		if (_tmp10_) {
#line 1881 "HierarchicalTagUtilities.c"
			Tag* _tmp17_;
#line 180 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			_tmp17_ = t;
#line 180 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			tag_flatten (_tmp17_);
#line 1887 "HierarchicalTagUtilities.c"
		}
#line 169 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_g_object_unref0 (t);
#line 169 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		_g_free0 (actual_path);
#line 1893 "HierarchicalTagUtilities.c"
	}
#line 166 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	_g_object_unref0 (paths);
#line 1897 "HierarchicalTagUtilities.c"
}


HierarchicalTagUtilities*
hierarchical_tag_utilities_construct (GType object_type)
{
	HierarchicalTagUtilities* self = NULL;
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	self = (HierarchicalTagUtilities*) g_type_create_instance (object_type);
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	return self;
#line 1909 "HierarchicalTagUtilities.c"
}


HierarchicalTagUtilities*
hierarchical_tag_utilities_new (void)
{
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	return hierarchical_tag_utilities_construct (TYPE_HIERARCHICAL_TAG_UTILITIES);
#line 1918 "HierarchicalTagUtilities.c"
}


static void
value_hierarchical_tag_utilities_init (GValue* value)
{
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	value->data[0].v_pointer = NULL;
#line 1927 "HierarchicalTagUtilities.c"
}


static void
value_hierarchical_tag_utilities_free_value (GValue* value)
{
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		hierarchical_tag_utilities_unref (value->data[0].v_pointer);
#line 1938 "HierarchicalTagUtilities.c"
	}
}


static void
value_hierarchical_tag_utilities_copy_value (const GValue* src_value,
                                             GValue* dest_value)
{
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (src_value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		dest_value->data[0].v_pointer = hierarchical_tag_utilities_ref (src_value->data[0].v_pointer);
#line 1951 "HierarchicalTagUtilities.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1955 "HierarchicalTagUtilities.c"
	}
}


static gpointer
value_hierarchical_tag_utilities_peek_pointer (const GValue* value)
{
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	return value->data[0].v_pointer;
#line 1965 "HierarchicalTagUtilities.c"
}


static gchar*
value_hierarchical_tag_utilities_collect_value (GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (collect_values[0].v_pointer) {
#line 1977 "HierarchicalTagUtilities.c"
		HierarchicalTagUtilities * object;
		object = collect_values[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		if (object->parent_instance.g_class == NULL) {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1984 "HierarchicalTagUtilities.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1988 "HierarchicalTagUtilities.c"
		}
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		value->data[0].v_pointer = hierarchical_tag_utilities_ref (object);
#line 1992 "HierarchicalTagUtilities.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		value->data[0].v_pointer = NULL;
#line 1996 "HierarchicalTagUtilities.c"
	}
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	return NULL;
#line 2000 "HierarchicalTagUtilities.c"
}


static gchar*
value_hierarchical_tag_utilities_lcopy_value (const GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	HierarchicalTagUtilities ** object_p;
	object_p = collect_values[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (!object_p) {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2016 "HierarchicalTagUtilities.c"
	}
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (!value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		*object_p = NULL;
#line 2022 "HierarchicalTagUtilities.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		*object_p = value->data[0].v_pointer;
#line 2026 "HierarchicalTagUtilities.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		*object_p = hierarchical_tag_utilities_ref (value->data[0].v_pointer);
#line 2030 "HierarchicalTagUtilities.c"
	}
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	return NULL;
#line 2034 "HierarchicalTagUtilities.c"
}


GParamSpec*
param_spec_hierarchical_tag_utilities (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags)
{
	ParamSpecHierarchicalTagUtilities* spec;
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_HIERARCHICAL_TAG_UTILITIES), NULL);
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	return G_PARAM_SPEC (spec);
#line 2054 "HierarchicalTagUtilities.c"
}


gpointer
value_get_hierarchical_tag_utilities (const GValue* value)
{
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HIERARCHICAL_TAG_UTILITIES), NULL);
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	return value->data[0].v_pointer;
#line 2065 "HierarchicalTagUtilities.c"
}


void
value_set_hierarchical_tag_utilities (GValue* value,
                                      gpointer v_object)
{
	HierarchicalTagUtilities * old;
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HIERARCHICAL_TAG_UTILITIES));
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	old = value->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (v_object) {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HIERARCHICAL_TAG_UTILITIES));
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		value->data[0].v_pointer = v_object;
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		hierarchical_tag_utilities_ref (value->data[0].v_pointer);
#line 2088 "HierarchicalTagUtilities.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		value->data[0].v_pointer = NULL;
#line 2092 "HierarchicalTagUtilities.c"
	}
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (old) {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		hierarchical_tag_utilities_unref (old);
#line 2098 "HierarchicalTagUtilities.c"
	}
}


void
value_take_hierarchical_tag_utilities (GValue* value,
                                       gpointer v_object)
{
	HierarchicalTagUtilities * old;
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HIERARCHICAL_TAG_UTILITIES));
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	old = value->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (v_object) {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HIERARCHICAL_TAG_UTILITIES));
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		value->data[0].v_pointer = v_object;
#line 2120 "HierarchicalTagUtilities.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		value->data[0].v_pointer = NULL;
#line 2124 "HierarchicalTagUtilities.c"
	}
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (old) {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		hierarchical_tag_utilities_unref (old);
#line 2130 "HierarchicalTagUtilities.c"
	}
}


static void
hierarchical_tag_utilities_class_init (HierarchicalTagUtilitiesClass * klass)
{
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	hierarchical_tag_utilities_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	((HierarchicalTagUtilitiesClass *) klass)->finalize = hierarchical_tag_utilities_finalize;
#line 2142 "HierarchicalTagUtilities.c"
}


static void
hierarchical_tag_utilities_instance_init (HierarchicalTagUtilities * self)
{
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	self->ref_count = 1;
#line 2151 "HierarchicalTagUtilities.c"
}


static void
hierarchical_tag_utilities_finalize (HierarchicalTagUtilities * obj)
{
	HierarchicalTagUtilities * self;
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HIERARCHICAL_TAG_UTILITIES, HierarchicalTagUtilities);
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	g_signal_handlers_destroy (self);
#line 2163 "HierarchicalTagUtilities.c"
}


GType
hierarchical_tag_utilities_get_type (void)
{
	static volatile gsize hierarchical_tag_utilities_type_id__volatile = 0;
	if (g_once_init_enter (&hierarchical_tag_utilities_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_hierarchical_tag_utilities_init, value_hierarchical_tag_utilities_free_value, value_hierarchical_tag_utilities_copy_value, value_hierarchical_tag_utilities_peek_pointer, "p", value_hierarchical_tag_utilities_collect_value, "p", value_hierarchical_tag_utilities_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (HierarchicalTagUtilitiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) hierarchical_tag_utilities_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HierarchicalTagUtilities), 0, (GInstanceInitFunc) hierarchical_tag_utilities_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType hierarchical_tag_utilities_type_id;
		hierarchical_tag_utilities_type_id = g_type_register_fundamental (g_type_fundamental_next (), "HierarchicalTagUtilities", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&hierarchical_tag_utilities_type_id__volatile, hierarchical_tag_utilities_type_id);
	}
	return hierarchical_tag_utilities_type_id__volatile;
}


gpointer
hierarchical_tag_utilities_ref (gpointer instance)
{
	HierarchicalTagUtilities * self;
	self = instance;
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	g_atomic_int_inc (&self->ref_count);
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	return instance;
#line 2192 "HierarchicalTagUtilities.c"
}


void
hierarchical_tag_utilities_unref (gpointer instance)
{
	HierarchicalTagUtilities * self;
	self = instance;
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		HIERARCHICAL_TAG_UTILITIES_GET_CLASS (self)->finalize (self);
#line 7 "/home/jens/Source/shotwell/src/tags/HierarchicalTagUtilities.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2207 "HierarchicalTagUtilities.c"
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



