/*
 * Copyright (C) 2004, 2005 Nikolas Zimmermann <zimmermann@kde.org>
 * Copyright (C) 2004, 2005, 2006 Rob Buis <buis@kde.org>
 * Copyright (C) 2005 Oliver Hunt <oliver@nerget.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef SVGFELightElement_h
#define SVGFELightElement_h

#include "LightSource.h"
#include "SVGAnimatedNumber.h"
#include "SVGElement.h"

namespace WebCore {

class SVGFELightElement : public SVGElement {
public:
    virtual Ref<LightSource> lightSource() const = 0;
    static SVGFELightElement* findLightElement(const SVGElement*);
    static RefPtr<LightSource> findLightSource(const SVGElement*);

protected:
    SVGFELightElement(const QualifiedName&, Document&);

    virtual bool rendererIsNeeded(const RenderStyle&) override { return false; }

private:
    virtual void parseAttribute(const QualifiedName&, const AtomicString&) override;
    virtual void svgAttributeChanged(const QualifiedName&) override;
    virtual void childrenChanged(const ChildChange&) override;

    BEGIN_DECLARE_ANIMATED_PROPERTIES(SVGFELightElement)
        DECLARE_ANIMATED_NUMBER(Azimuth, azimuth)
        DECLARE_ANIMATED_NUMBER(Elevation, elevation)
        DECLARE_ANIMATED_NUMBER(X, x)
        DECLARE_ANIMATED_NUMBER(Y, y)
        DECLARE_ANIMATED_NUMBER(Z, z)
        DECLARE_ANIMATED_NUMBER(PointsAtX, pointsAtX)
        DECLARE_ANIMATED_NUMBER(PointsAtY, pointsAtY)
        DECLARE_ANIMATED_NUMBER(PointsAtZ, pointsAtZ)
        DECLARE_ANIMATED_NUMBER(SpecularExponent, specularExponent)
        DECLARE_ANIMATED_NUMBER(LimitingConeAngle, limitingConeAngle)
    END_DECLARE_ANIMATED_PROPERTIES
};

} // namespace WebCore

#endif
