/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LittleEndianInputStream
extends FilterInputStream {
    byte[] buffer = new byte[8];

    public LittleEndianInputStream(InputStream in) {
        super(in);
    }

    public byte readByte() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    public short readShort() throws IOException {
        int byte1 = this.in.read();
        int byte2 = this.in.read();
        if (byte2 < 0) {
            throw new EOFException();
        }
        return (short)((byte2 << 24 >>> 16) + (byte1 << 24 >>> 24));
    }

    public int readInt() throws IOException {
        int byte1 = this.in.read();
        int byte2 = this.in.read();
        int byte3 = this.in.read();
        int byte4 = this.in.read();
        if (byte4 < 0) {
            throw new EOFException();
        }
        return (byte4 << 24) + (byte3 << 24 >>> 8) + (byte2 << 24 >>> 16) + (byte1 << 24 >>> 24);
    }

    public long readLong() throws IOException {
        this.readFully(this.buffer);
        long byte1 = this.buffer[0];
        long byte2 = this.buffer[1];
        long byte3 = this.buffer[2];
        long byte4 = this.buffer[3];
        long byte5 = this.buffer[4];
        long byte6 = this.buffer[5];
        long byte7 = this.buffer[6];
        long byte8 = this.buffer[7];
        return (byte8 << 56) + (byte7 << 56 >>> 8) + (byte6 << 56 >>> 16) + (byte5 << 56 >>> 24) + (byte4 << 56 >>> 32) + (byte3 << 56 >>> 40) + (byte2 << 56 >>> 48) + (byte1 << 56 >>> 56);
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public String readString() throws IOException {
        byte b;
        ByteArrayOutputStream bis = new ByteArrayOutputStream(100);
        while ((b = (byte)this.in.read()) != 0) {
            if (b < 0) {
                throw new EOFException();
            }
            bis.write(b);
        }
        return new String(bis.toByteArray());
    }

    private void readFully(byte[] b) throws IOException {
        int count;
        int len = b.length;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = this.read(b, n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }
}

