/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTagUtil;
import htsjdk.samtools.TagValueAndUnsignedArrayFlag;
import htsjdk.samtools.util.StringUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;

public class ReadTag
implements Comparable<ReadTag> {
    private static final long MAX_INT = Integer.MAX_VALUE;
    private static final long MAX_UINT = 0xFFFFFFFFL;
    private static final long MAX_SHORT = 32767L;
    private static final long MAX_USHORT = 65535L;
    private static final long MAX_BYTE = 127L;
    private static final long MAX_UBYTE = 255L;
    private String key;
    private String keyAndType;
    public String keyType3Bytes;
    public int keyType3BytesAsInt;
    private char type;
    private Object value;
    private short code;
    private byte index;
    private static final ThreadLocal<ByteBuffer> bufferLocal = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            ByteBuffer buf = ByteBuffer.allocateDirect(0xA00000);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            return buf;
        }
    };
    private static final Charset charset = Charset.forName("US-ASCII");

    public ReadTag(int id, byte[] dataAsByteArray) {
        this.type = (char)(0xFF & id);
        this.key = new String(new char[]{(char)(id >> 16 & 0xFF), (char)(id >> 8 & 0xFF)});
        this.value = ReadTag.restoreValueFromByteArray(this.type, dataAsByteArray);
        this.keyType3Bytes = this.key + this.type;
        this.keyType3BytesAsInt = id;
        this.code = SAMTagUtil.getSingleton().makeBinaryTag(this.key);
    }

    private ReadTag(String key, char type, Object value) {
        if (key == null) {
            throw new NullPointerException("Tag key cannot be null.");
        }
        if (value == null) {
            throw new NullPointerException("Tag value cannot be null.");
        }
        this.value = value;
        if (key.length() == 2) {
            this.key = key;
            this.type = type;
            this.keyAndType = key + ":" + this.getType();
        } else if (key.length() == 4) {
            this.key = key.substring(0, 2);
            this.type = key.charAt(3);
        }
        this.keyType3Bytes = this.key + this.type;
        this.keyType3BytesAsInt = ReadTag.nameType3BytesToInt(this.key, this.type);
        this.code = SAMTagUtil.getSingleton().makeBinaryTag(this.key);
    }

    public static int name3BytesToInt(byte[] name) {
        int value = 0xFF & name[0];
        value <<= 8;
        value |= 0xFF & name[1];
        value <<= 8;
        return value |= 0xFF & name[2];
    }

    public static int nameType3BytesToInt(String name, char type) {
        int value = 0xFF & name.charAt(0);
        value <<= 8;
        value |= 0xFF & name.charAt(1);
        value <<= 8;
        return value |= 0xFF & type;
    }

    public static String intToNameType3Bytes(int value) {
        byte b3 = (byte)(0xFF & value);
        byte b2 = (byte)(0xFF & value >> 8);
        byte b1 = (byte)(0xFF & value >> 16);
        return new String(new byte[]{b1, b2, b3});
    }

    public static String intToNameType4Bytes(int value) {
        byte b3 = (byte)(0xFF & value);
        byte b2 = (byte)(0xFF & value >> 8);
        byte b1 = (byte)(0xFF & value >> 16);
        return new String(new byte[]{b1, b2, 58, b3});
    }

    public SAMRecord.SAMTagAndValue createSAMTag() {
        return new SAMRecord.SAMTagAndValue(this.key, this.value);
    }

    public static ReadTag deriveTypeFromKeyAndType(String keyAndType, Object value) {
        if (keyAndType.length() != 4) {
            throw new RuntimeException("Tag key and type must be 4 char long: " + keyAndType);
        }
        return new ReadTag(keyAndType.substring(0, 2), keyAndType.charAt(3), value);
    }

    public static ReadTag deriveTypeFromValue(String key, Object value) {
        if (key.length() != 2) {
            throw new RuntimeException("Tag key must be 2 char long: " + key);
        }
        return new ReadTag(key, ReadTag.getTagValueType(value), value);
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public int compareTo(ReadTag o) {
        return this.key.compareTo(o.key);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ReadTag)) {
            return false;
        }
        ReadTag foe = (ReadTag)obj;
        return this.key.equals(foe.key) && (this.value == null && foe.value == null || this.value != null && this.value.equals(foe.value));
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public Object getValue() {
        return this.value;
    }

    char getType() {
        return this.type;
    }

    public String getKeyAndType() {
        return this.keyAndType;
    }

    public byte[] getValueAsByteArray() {
        return ReadTag.writeSingleValue((byte)this.type, this.value, false);
    }

    private static Object restoreValueFromByteArray(char type, byte[] array) {
        ByteBuffer buffer = ByteBuffer.wrap(array);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return ReadTag.readSingleValue((byte)type, buffer);
    }

    private static char getTagValueType(Object value) {
        if (value instanceof String) {
            return 'Z';
        }
        if (value instanceof Character) {
            return 'A';
        }
        if (value instanceof Float) {
            return 'f';
        }
        if (value instanceof Number) {
            if (!(value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long)) {
                throw new IllegalArgumentException("Unrecognized tag type " + value.getClass().getName());
            }
            return ReadTag.getIntegerType(((Number)value).longValue());
        }
        if (value instanceof byte[] || value instanceof short[] || value instanceof int[] || value instanceof float[]) {
            return 'B';
        }
        throw new IllegalArgumentException("When writing BAM, unrecognized tag type " + value.getClass().getName());
    }

    private static char getIntegerType(long val) {
        if (val > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Integer attribute value too large to be encoded in BAM");
        }
        if (val > Integer.MAX_VALUE) {
            return 'I';
        }
        if (val > 65535L) {
            return 'i';
        }
        if (val > 32767L) {
            return 'S';
        }
        if (val > 255L) {
            return 's';
        }
        if (val > 127L) {
            return 'C';
        }
        if (val >= -128L) {
            return 'c';
        }
        if (val >= -32768L) {
            return 's';
        }
        if (val >= Integer.MIN_VALUE) {
            return 'i';
        }
        throw new IllegalArgumentException("Integer attribute value too negative to be encoded in BAM");
    }

    public void setIndex(byte i) {
        this.index = i;
    }

    public byte getIndex() {
        return this.index;
    }

    public static byte[] writeSingleValue(byte tagType, Object value, boolean isUnsignedArray) {
        ByteBuffer buffer = bufferLocal.get();
        buffer.clear();
        switch (tagType) {
            case 90: {
                String s = (String)value;
                buffer.put(s.getBytes(charset));
                buffer.put((byte)0);
                break;
            }
            case 65: {
                buffer.put((byte)((Character)value).charValue());
                break;
            }
            case 73: {
                buffer.putLong((Long)value);
                buffer.position(buffer.position() - 4);
                break;
            }
            case 105: {
                buffer.putInt((Integer)value);
                break;
            }
            case 115: {
                buffer.putShort(((Number)value).shortValue());
                break;
            }
            case 83: {
                buffer.putInt(((Number)value).intValue());
                buffer.position(buffer.position() - 2);
                break;
            }
            case 99: {
                buffer.put(((Number)value).byteValue());
                break;
            }
            case 67: {
                buffer.putShort(((Integer)value).shortValue());
                buffer.position(buffer.position() - 1);
                break;
            }
            case 102: {
                buffer.putFloat(((Float)value).floatValue());
                break;
            }
            case 72: {
                String s = StringUtil.bytesToHexString((byte[])value);
                buffer.put(s.getBytes(charset));
                buffer.put((byte)0);
                break;
            }
            case 66: {
                ReadTag.writeArray(value, isUnsignedArray, buffer);
                break;
            }
            default: {
                throw new SAMFormatException("Unrecognized tag type: " + (char)tagType);
            }
        }
        buffer.flip();
        byte[] bytes = new byte[buffer.limit()];
        buffer.get(bytes);
        return bytes;
    }

    private static void writeArray(Object value, boolean isUnsignedArray, ByteBuffer buffer) {
        if (value instanceof byte[]) {
            buffer.put((byte)(isUnsignedArray ? 67 : 99));
            byte[] array = (byte[])value;
            buffer.putInt(array.length);
            for (byte element : array) {
                buffer.put(element);
            }
        } else if (value instanceof short[]) {
            buffer.put((byte)(isUnsignedArray ? 83 : 115));
            short[] array = (short[])value;
            buffer.putInt(array.length);
            for (short element : array) {
                buffer.putShort(element);
            }
        } else if (value instanceof int[]) {
            buffer.put((byte)(isUnsignedArray ? 73 : 105));
            int[] array = (int[])value;
            buffer.putInt(array.length);
            for (int element : array) {
                buffer.putInt(element);
            }
        } else if (value instanceof float[]) {
            buffer.put((byte)102);
            float[] array = (float[])value;
            buffer.putInt(array.length);
            for (float element : array) {
                buffer.putFloat(element);
            }
        } else {
            throw new SAMException("Unrecognized array value type: " + value.getClass());
        }
    }

    public static Object readSingleValue(byte tagType, ByteBuffer byteBuffer) {
        switch (tagType) {
            case 90: {
                return ReadTag.readNullTerminatedString(byteBuffer);
            }
            case 65: {
                return Character.valueOf((char)byteBuffer.get());
            }
            case 73: {
                long val = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
                if (val <= Integer.MAX_VALUE) {
                    return (int)val;
                }
                throw new RuntimeException("Tag value is too large to store as signed integer.");
            }
            case 105: {
                return byteBuffer.getInt();
            }
            case 115: {
                return (int)byteBuffer.getShort();
            }
            case 83: {
                return byteBuffer.getShort() & 0xFFFF;
            }
            case 99: {
                return (int)byteBuffer.get();
            }
            case 67: {
                return byteBuffer.get() & 0xFF;
            }
            case 102: {
                return Float.valueOf(byteBuffer.getFloat());
            }
            case 72: {
                String hexRep = ReadTag.readNullTerminatedString(byteBuffer);
                return StringUtil.hexStringToBytes(hexRep);
            }
            case 66: {
                TagValueAndUnsignedArrayFlag valueAndFlag = ReadTag.readArray(byteBuffer);
                return valueAndFlag.value;
            }
        }
        throw new SAMFormatException("Unrecognized tag type: " + (char)tagType);
    }

    private static TagValueAndUnsignedArrayFlag readArray(ByteBuffer byteBuffer) {
        Object[] value;
        byte arrayType = byteBuffer.get();
        boolean isUnsigned = Character.isUpperCase(arrayType);
        int length = byteBuffer.getInt();
        switch (Character.toLowerCase(arrayType)) {
            case 99: {
                byte[] array;
                value = array = new byte[length];
                byteBuffer.get(array);
                break;
            }
            case 115: {
                short[] array = new short[length];
                value = array;
                for (int i = 0; i < length; ++i) {
                    array[i] = byteBuffer.getShort();
                }
                break;
            }
            case 105: {
                int[] array = new int[length];
                value = array;
                for (int i = 0; i < length; ++i) {
                    array[i] = byteBuffer.getInt();
                }
                break;
            }
            case 102: {
                float[] array = new float[length];
                value = array;
                for (int i = 0; i < length; ++i) {
                    array[i] = byteBuffer.getFloat();
                }
                break;
            }
            default: {
                throw new SAMFormatException("Unrecognized tag array type: " + (char)arrayType);
            }
        }
        return new TagValueAndUnsignedArrayFlag(value, isUnsigned);
    }

    private static String readNullTerminatedString(ByteBuffer byteBuffer) {
        byteBuffer.mark();
        int startPosition = byteBuffer.position();
        while (byteBuffer.get() != 0) {
        }
        int endPosition = byteBuffer.position();
        byte[] buf = new byte[endPosition - startPosition - 1];
        byteBuffer.reset();
        byteBuffer.get(buf);
        byteBuffer.get();
        return StringUtil.bytesToString(buf);
    }
}

