/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.example;

import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.BinaryFeatureCodec;
import htsjdk.tribble.CloseableTribbleIterator;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.FeatureCodecHeader;
import htsjdk.tribble.FeatureReader;
import htsjdk.tribble.SimpleFeature;
import htsjdk.tribble.readers.AsciiLineReader;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.tribble.readers.PositionalBufferedStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class ExampleBinaryCodec
extends BinaryFeatureCodec<Feature> {
    public static final String HEADER_LINE = "# BinaryTestFeature";

    @Override
    public Feature decodeLoc(PositionalBufferedStream stream) throws IOException {
        return this.decode(stream);
    }

    @Override
    public Feature decode(PositionalBufferedStream stream) throws IOException {
        DataInputStream dis = new DataInputStream(stream);
        String contig = dis.readUTF();
        int start = dis.readInt();
        int stop = dis.readInt();
        return new SimpleFeature(contig, start, stop);
    }

    @Override
    public FeatureCodecHeader readHeader(PositionalBufferedStream stream) throws IOException {
        AsciiLineReader nonReadAheadLineReader = new AsciiLineReader(stream);
        ArrayList<String> headerLines = new ArrayList<String>();
        long headerLengthInBytes = 0L;
        while (stream.peek() == 35) {
            headerLines.add(nonReadAheadLineReader.readLine());
            headerLengthInBytes = stream.getPosition();
        }
        return new FeatureCodecHeader(headerLines, headerLengthInBytes);
    }

    @Override
    public Class<Feature> getFeatureType() {
        return Feature.class;
    }

    @Override
    public boolean canDecode(String path) {
        return false;
    }

    public static <FEATURE_TYPE extends Feature> void convertToBinaryTest(File source, File dest, FeatureCodec<FEATURE_TYPE, LineIterator> codec) throws IOException {
        AbstractFeatureReader<FEATURE_TYPE, LineIterator> reader = AbstractFeatureReader.getFeatureReader(source.getAbsolutePath(), codec, false);
        FileOutputStream output = new FileOutputStream(dest);
        ExampleBinaryCodec.convertToBinaryTest(reader, output);
    }

    public static <FEATURE_TYPE extends Feature> void convertToBinaryTest(FeatureReader<FEATURE_TYPE> reader, OutputStream out) throws IOException {
        DataOutputStream dos = new DataOutputStream(out);
        dos.writeBytes("# BinaryTestFeature\n");
        CloseableTribbleIterator<FEATURE_TYPE> it = reader.iterator();
        while (it.hasNext()) {
            Feature f = (Feature)it.next();
            dos.writeUTF(f.getChr());
            dos.writeInt(f.getStart());
            dos.writeInt(f.getEnd());
        }
        dos.close();
        reader.close();
    }
}

