/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import java.awt.Container;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Collection;
import javax.swing.JLabel;
import org.fest.assertions.Assertions;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.BasicComponentPrinter;
import org.fest.swing.core.ComponentFinder;
import org.fest.swing.core.ComponentMatcher;
import org.fest.swing.core.ComponentPrinter;
import org.fest.swing.core.FinderDelegate;
import org.fest.swing.core.GenericTypeMatcher;
import org.fest.swing.core.LabelMatcher;
import org.fest.swing.core.NameMatcher;
import org.fest.swing.core.Settings;
import org.fest.swing.core.TypeMatcher;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.exception.ComponentLookupException;
import org.fest.swing.format.Formatting;
import org.fest.swing.hierarchy.ComponentHierarchy;
import org.fest.swing.hierarchy.ExistingHierarchy;
import org.fest.swing.hierarchy.NewHierarchy;
import org.fest.swing.hierarchy.SingleComponentHierarchy;
import org.fest.util.Strings;
import org.fest.util.Systems;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BasicComponentFinder
implements ComponentFinder {
    private final ComponentHierarchy hierarchy;
    private final ComponentPrinter printer;
    private final Settings settings;
    private final FinderDelegate finderDelegate = new FinderDelegate();
    private boolean includeHierarchyInComponentLookupException;

    public static ComponentFinder finderWithNewAwtHierarchy() {
        return new BasicComponentFinder(NewHierarchy.ignoreExistingComponents());
    }

    public static ComponentFinder finderWithCurrentAwtHierarchy() {
        return new BasicComponentFinder(new ExistingHierarchy());
    }

    protected BasicComponentFinder(ComponentHierarchy hierarchy) {
        this(hierarchy, null);
    }

    protected BasicComponentFinder(ComponentHierarchy hierarchy, Settings settings) {
        this.hierarchy = hierarchy;
        this.settings = settings;
        this.printer = new BasicComponentPrinter(hierarchy);
        this.includeHierarchyIfComponentNotFound(true);
    }

    @Override
    public ComponentPrinter printer() {
        return this.printer;
    }

    @Override
    public <T extends Component> T findByType(Class<T> type) {
        return this.findByType(type, this.requireShowing());
    }

    @Override
    @RunsInEDT
    public <T extends Component> T findByType(Class<T> type, boolean showing) {
        return (T)((Component)type.cast(this.find(new TypeMatcher(type, showing))));
    }

    @Override
    @RunsInEDT
    public <T extends Component> T findByType(Container root, Class<T> type) {
        return this.findByType(root, type, this.requireShowing());
    }

    @Override
    @RunsInEDT
    public <T extends Component> T findByType(Container root, Class<T> type, boolean showing) {
        return (T)((Component)type.cast(this.find(root, (ComponentMatcher)new TypeMatcher(type, showing))));
    }

    @Override
    @RunsInEDT
    public <T extends Component> T findByName(String name, Class<T> type) {
        return this.findByName(name, type, this.requireShowing());
    }

    @Override
    @RunsInEDT
    public <T extends Component> T findByName(String name, Class<T> type, boolean showing) {
        Component found = this.find(new NameMatcher(name, type, showing));
        return (T)((Component)type.cast(found));
    }

    @Override
    @RunsInEDT
    public Component findByName(String name) {
        return this.findByName(name, this.requireShowing());
    }

    @Override
    @RunsInEDT
    public Component findByName(String name, boolean showing) {
        return this.find(new NameMatcher(name, showing));
    }

    @Override
    @RunsInEDT
    public <T extends Component> T findByLabel(String label, Class<T> type) {
        return this.findByLabel(label, type, this.requireShowing());
    }

    @Override
    @RunsInEDT
    public <T extends Component> T findByLabel(String label, Class<T> type, boolean showing) {
        Component found = this.find(new LabelMatcher(label, type, showing));
        return (T)((Component)this.labelFor(found, type));
    }

    @Override
    @RunsInEDT
    public Component findByLabel(String label) {
        return this.findByLabel(label, this.requireShowing());
    }

    @Override
    @RunsInEDT
    public Component findByLabel(String label, boolean showing) {
        Component found = this.find(new LabelMatcher(label, showing));
        return this.labelFor(found, Component.class);
    }

    @Override
    @RunsInEDT
    public <T extends Component> T find(GenericTypeMatcher<T> m) {
        Component found = this.find((ComponentMatcher)m);
        return (T)((Component)m.supportedType().cast(found));
    }

    @Override
    @RunsInEDT
    public Component find(ComponentMatcher m) {
        return this.find(this.hierarchy, m);
    }

    @Override
    @RunsInEDT
    public <T extends Component> T findByName(Container root, String name, Class<T> type) {
        return this.findByName(root, name, type, this.requireShowing());
    }

    @Override
    @RunsInEDT
    public <T extends Component> T findByName(Container root, String name, Class<T> type, boolean showing) {
        Component found = this.find(root, (ComponentMatcher)new NameMatcher(name, type, showing));
        return (T)((Component)type.cast(found));
    }

    @Override
    @RunsInEDT
    public Component findByName(Container root, String name) {
        return this.findByName(root, name, this.requireShowing());
    }

    @Override
    @RunsInEDT
    public Component findByName(Container root, String name, boolean showing) {
        return this.find(root, (ComponentMatcher)new NameMatcher(name, showing));
    }

    @Override
    @RunsInEDT
    public <T extends Component> T findByLabel(Container root, String label, Class<T> type) {
        return this.findByLabel(root, label, type, this.requireShowing());
    }

    @Override
    @RunsInEDT
    public <T extends Component> T findByLabel(Container root, String label, Class<T> type, boolean showing) {
        Component found = this.find(root, (ComponentMatcher)new LabelMatcher(label, type, showing));
        return (T)((Component)this.labelFor(found, type));
    }

    @Override
    @RunsInEDT
    public Component findByLabel(Container root, String label) {
        return this.findByLabel(root, label, this.requireShowing());
    }

    private boolean requireShowing() {
        return this.requireShowingFromSettingsOr(false);
    }

    @Override
    @RunsInEDT
    public Component findByLabel(Container root, String label, boolean showing) {
        Component found = this.find(root, (ComponentMatcher)new LabelMatcher(label, showing));
        return this.labelFor(found, Component.class);
    }

    private <T> T labelFor(Component label, Class<T> type) {
        Assertions.assertThat((Object)label).isInstanceOf(JLabel.class);
        Component target = ((JLabel)label).getLabelFor();
        Assertions.assertThat((Object)target).isInstanceOf(type);
        return type.cast(target);
    }

    @Override
    @RunsInEDT
    public <T extends Component> T find(Container root, GenericTypeMatcher<T> m) {
        Component found = this.find(root, (ComponentMatcher)m);
        return (T)((Component)m.supportedType().cast(found));
    }

    @Override
    @RunsInEDT
    public Component find(Container root, ComponentMatcher m) {
        return this.find(this.hierarchy(root), m);
    }

    @RunsInEDT
    private Component find(ComponentHierarchy h, ComponentMatcher m) {
        Collection<Component> found = this.finderDelegate.find(h, m);
        if (found.isEmpty()) {
            throw this.componentNotFound(h, m);
        }
        if (found.size() > 1) {
            throw BasicComponentFinder.multipleComponentsFound(found, m);
        }
        return found.iterator().next();
    }

    @RunsInEDT
    private ComponentLookupException componentNotFound(ComponentHierarchy h, ComponentMatcher m) {
        String message = Strings.concat((Object[])new Object[]{"Unable to find component using matcher ", m, "."});
        if (this.includeHierarchyIfComponentNotFound()) {
            message = Strings.concat((Object[])new Object[]{message, Systems.LINE_SEPARATOR, Systems.LINE_SEPARATOR, "Component hierarchy:", Systems.LINE_SEPARATOR, this.formattedHierarchy(BasicComponentFinder.root(h))});
        }
        throw new ComponentLookupException(message);
    }

    private static Container root(ComponentHierarchy h) {
        if (h instanceof SingleComponentHierarchy) {
            return ((SingleComponentHierarchy)h).root();
        }
        return null;
    }

    @RunsInEDT
    private String formattedHierarchy(Container root) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(out, true);
        this.printer.printComponents(printStream, root);
        printStream.flush();
        return new String(out.toByteArray());
    }

    @RunsInEDT
    private static ComponentLookupException multipleComponentsFound(Collection<Component> found, ComponentMatcher m) {
        StringBuilder message = new StringBuilder();
        message.append("Found more than one component using matcher ").append(m).append(".").append(Systems.LINE_SEPARATOR).append(Systems.LINE_SEPARATOR).append("Found:");
        BasicComponentFinder.appendComponents(message, found);
        if (!found.isEmpty()) {
            message.append(Systems.LINE_SEPARATOR);
        }
        throw new ComponentLookupException(message.toString(), found);
    }

    @RunsInEDT
    private static void appendComponents(final StringBuilder message, final Collection<Component> found) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                for (Component c : found) {
                    message.append(Systems.LINE_SEPARATOR).append(Formatting.format(c));
                }
            }
        });
    }

    @Override
    public boolean includeHierarchyIfComponentNotFound() {
        return this.includeHierarchyInComponentLookupException;
    }

    @Override
    public void includeHierarchyIfComponentNotFound(boolean newValue) {
        this.includeHierarchyInComponentLookupException = newValue;
    }

    @Override
    public Collection<Component> findAll(ComponentMatcher m) {
        return this.finderDelegate.find(this.hierarchy, m);
    }

    @Override
    public Collection<Component> findAll(Container root, ComponentMatcher m) {
        return this.finderDelegate.find(this.hierarchy(root), m);
    }

    @Override
    public <T extends Component> Collection<T> findAll(GenericTypeMatcher<T> m) {
        return this.finderDelegate.find(this.hierarchy, m);
    }

    @Override
    public <T extends Component> Collection<T> findAll(Container root, GenericTypeMatcher<T> m) {
        return this.finderDelegate.find(this.hierarchy(root), m);
    }

    protected final boolean requireShowingFromSettingsOr(boolean defaultValue) {
        if (this.settings == null) {
            return defaultValue;
        }
        return this.settings.componentLookupScope().requireShowing();
    }

    private ComponentHierarchy hierarchy(Container root) {
        if (root == null) {
            return this.hierarchy;
        }
        return new SingleComponentHierarchy(root, this.hierarchy);
    }
}

