/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.JTabbedPane;
import org.fest.assertions.Assertions;
import org.fest.assertions.Description;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.data.Index;
import org.fest.swing.driver.ComponentStateValidator;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JTabbedPaneLocation;
import org.fest.swing.driver.JTabbedPaneSelectTabTask;
import org.fest.swing.driver.JTabbedPaneTabTitlesQuery;
import org.fest.swing.driver.TextAssert;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.exception.LocationUnavailableException;
import org.fest.swing.util.Pair;
import org.fest.swing.util.PatternTextMatcher;
import org.fest.swing.util.StringTextMatcher;
import org.fest.swing.util.TextMatcher;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTabbedPaneDriver
extends JComponentDriver {
    private final JTabbedPaneLocation location;

    public JTabbedPaneDriver(Robot robot) {
        this(robot, new JTabbedPaneLocation());
    }

    @VisibleForTesting
    JTabbedPaneDriver(Robot robot, JTabbedPaneLocation location) {
        super(robot);
        this.location = location;
    }

    @RunsInEDT
    public String[] tabTitles(JTabbedPane tabbedPane) {
        return JTabbedPaneTabTitlesQuery.tabTitlesOf(tabbedPane);
    }

    @RunsInEDT
    public void selectTab(JTabbedPane tabbedPane, String title) {
        this.selectTab(tabbedPane, new StringTextMatcher(title));
    }

    @RunsInEDT
    public void selectTab(JTabbedPane tabbedPane, Pattern pattern) {
        this.selectTab(tabbedPane, new PatternTextMatcher(pattern));
    }

    @RunsInEDT
    private void selectTab(JTabbedPane tabbedPane, TextMatcher matcher) {
        Pair<Integer, Point> tabToSelectInfo = JTabbedPaneDriver.tabToSelectInfo(this.location, tabbedPane, matcher);
        Point target = (Point)tabToSelectInfo.ii;
        if (target != null) {
            this.click((Component)tabbedPane, target);
            return;
        }
        this.setTabDirectly(tabbedPane, (Integer)tabToSelectInfo.i);
    }

    @RunsInEDT
    private static Pair<Integer, Point> tabToSelectInfo(final JTabbedPaneLocation location, final JTabbedPane tabbedPane, final TextMatcher matcher) {
        return GuiActionRunner.execute(new GuiQuery<Pair<Integer, Point>>(){

            @Override
            protected Pair<Integer, Point> executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(tabbedPane);
                int index = location.indexOf(tabbedPane, matcher);
                location.validateIndex(tabbedPane, index);
                Point point = null;
                try {
                    point = location.pointAt(tabbedPane, index);
                }
                catch (LocationUnavailableException locationUnavailableException) {
                    // empty catch block
                }
                return new Pair<Integer, Point>(index, point);
            }
        });
    }

    public void selectTab(JTabbedPane tabbedPane, int index) {
        try {
            Point p = JTabbedPaneDriver.validateAndGetPoint(this.location, tabbedPane, index);
            this.click((Component)tabbedPane, p);
        }
        catch (LocationUnavailableException e) {
            this.setTabDirectly(tabbedPane, index);
        }
        catch (ActionFailedException e) {
            this.setTabDirectly(tabbedPane, index);
        }
    }

    @RunsInEDT
    private static Point validateAndGetPoint(final JTabbedPaneLocation location, final JTabbedPane tabbedPane, final int index) {
        return GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                location.validateIndex(tabbedPane, index);
                ComponentStateValidator.validateIsEnabledAndShowing(tabbedPane);
                return location.pointAt(tabbedPane, index);
            }
        });
    }

    @VisibleForTesting
    @RunsInEDT
    void setTabDirectly(JTabbedPane tabbedPane, int index) {
        JTabbedPaneSelectTabTask.setSelectedTab(tabbedPane, index);
        this.robot.waitForIdle();
        this.moveMouseToTab(tabbedPane, index);
    }

    private void moveMouseToTab(JTabbedPane tabbedPane, int index) {
        try {
            Point p = JTabbedPaneDriver.pointAtTab(this.location, tabbedPane, index);
            this.robot.moveMouse(tabbedPane, p);
            this.robot.waitForIdle();
        }
        catch (LocationUnavailableException locationUnavailableException) {
            // empty catch block
        }
    }

    @RunsInEDT
    private static Point pointAtTab(final JTabbedPaneLocation location, final JTabbedPane tabbedPane, final int index) {
        return GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                return location.pointAt(tabbedPane, index);
            }
        });
    }

    @RunsInEDT
    public Component selectedComponentOf(JTabbedPane tabbedPane) {
        return JTabbedPaneDriver.selectedComponent(tabbedPane);
    }

    @RunsInEDT
    private static Component selectedComponent(final JTabbedPane tabbedPane) {
        return GuiActionRunner.execute(new GuiQuery<Component>(){

            @Override
            protected Component executeInEDT() {
                return tabbedPane.getSelectedComponent();
            }
        });
    }

    @RunsInEDT
    public void requireTabTitle(JTabbedPane tabbedPane, String title, Index index) {
        String actualTitle = JTabbedPaneDriver.titleAt(tabbedPane, index);
        TextAssert.verifyThat(actualTitle).as(this.titleAtProperty(tabbedPane)).isEqualOrMatches(title);
    }

    @RunsInEDT
    public void requireTabTitle(JTabbedPane tabbedPane, Pattern pattern, Index index) {
        String actualTitle = JTabbedPaneDriver.titleAt(tabbedPane, index);
        TextAssert.verifyThat(actualTitle).as(this.titleAtProperty(tabbedPane)).matches(pattern);
    }

    @RunsInEDT
    private Description titleAtProperty(JTabbedPane tabbedPane) {
        return JTabbedPaneDriver.propertyName(tabbedPane, "titleAt");
    }

    @RunsInEDT
    private static String titleAt(final JTabbedPane tabbedPane, final Index index) {
        return GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            protected String executeInEDT() {
                return tabbedPane.getTitleAt(index.value);
            }
        });
    }

    @RunsInEDT
    public void requireTabTitles(JTabbedPane tabbedPane, String[] titles) {
        Object[] actualTitles = JTabbedPaneDriver.allTabTitlesIn(tabbedPane);
        Assertions.assertThat((Object[])actualTitles).as(JTabbedPaneDriver.propertyName(tabbedPane, "tabTitles")).isEqualTo((Object[])titles);
    }

    @RunsInEDT
    private static String[] allTabTitlesIn(final JTabbedPane tabbedPane) {
        return GuiActionRunner.execute(new GuiQuery<String[]>(){

            @Override
            protected String[] executeInEDT() {
                ArrayList<String> allTitles = new ArrayList<String>();
                int tabCount = tabbedPane.getTabCount();
                for (int i = 0; i < tabCount; ++i) {
                    allTitles.add(tabbedPane.getTitleAt(i));
                }
                return allTitles.toArray(new String[allTitles.size()]);
            }
        });
    }
}

