/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.Chunk;

public class GATKChunk
extends Chunk {
    private static final double AVERAGE_BAM_COMPRESSION_RATIO = 0.39;

    public GATKChunk(long start, long stop) {
        super(start, stop);
    }

    public GATKChunk(long blockStart, int blockOffsetStart, long blockEnd, int blockOffsetEnd) {
        super(blockStart << 16 | (long)blockOffsetStart, blockEnd << 16 | (long)blockOffsetEnd);
    }

    public GATKChunk(Chunk chunk) {
        super(chunk.getChunkStart(), chunk.getChunkEnd());
    }

    public GATKChunk clone() {
        return new GATKChunk(this.getChunkStart(), this.getChunkEnd());
    }

    public long getChunkStart() {
        return super.getChunkStart();
    }

    public void setChunkStart(long value) {
        super.setChunkStart(value);
    }

    public long getChunkEnd() {
        return super.getChunkEnd();
    }

    public void setChunkEnd(long value) {
        super.setChunkEnd(value);
    }

    public long getBlockStart() {
        return this.getChunkStart() >>> 16;
    }

    public int getBlockOffsetStart() {
        return (int)(this.getChunkStart() & 0xFFFFL);
    }

    public long getBlockEnd() {
        return this.getChunkEnd() >>> 16;
    }

    public int getBlockOffsetEnd() {
        return (int)this.getChunkEnd() & 0xFFFF;
    }

    public long size() {
        long chunkSpan = Math.round((double)((this.getChunkEnd() >> 16) - (this.getChunkStart() >> 16)) / 0.39);
        int offsetSpan = (int)((this.getChunkEnd() & 0xFFFFL) - (this.getChunkStart() & 0xFFFFL));
        return chunkSpan + (long)offsetSpan;
    }

    public GATKChunk merge(GATKChunk other) {
        return new GATKChunk(Math.min(this.getChunkStart(), other.getChunkStart()), Math.max(this.getChunkEnd(), other.getChunkEnd()));
    }
}

