/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBDecoderFactory;
import com.mongodb.DBEncoderFactory;
import com.mongodb.DefaultDBDecoder;
import com.mongodb.DefaultDBEncoder;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import javax.net.SocketFactory;
import org.bson.util.annotations.Immutable;

@Immutable
public class MongoClientOptions {
    private final String description;
    private final int connectionsPerHost;
    private final int threadsAllowedToBlockForConnectionMultiplier;
    private final int maxWaitTime;
    private final int connectTimeout;
    private final int socketTimeout;
    private final boolean socketKeepAlive;
    private final boolean autoConnectRetry;
    private final long maxAutoConnectRetryTime;
    private final ReadPreference readPreference;
    private final DBDecoderFactory dbDecoderFactory;
    private final DBEncoderFactory dbEncoderFactory;
    private final WriteConcern writeConcern;
    private final SocketFactory socketFactory;
    private final boolean cursorFinalizerEnabled;
    private final boolean alwaysUseMBeans;

    public static Builder builder() {
        return new Builder();
    }

    public String getDescription() {
        return this.description;
    }

    public int getConnectionsPerHost() {
        return this.connectionsPerHost;
    }

    public int getThreadsAllowedToBlockForConnectionMultiplier() {
        return this.threadsAllowedToBlockForConnectionMultiplier;
    }

    public int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public boolean isSocketKeepAlive() {
        return this.socketKeepAlive;
    }

    public boolean isAutoConnectRetry() {
        return this.autoConnectRetry;
    }

    public long getMaxAutoConnectRetryTime() {
        return this.maxAutoConnectRetryTime;
    }

    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    public DBDecoderFactory getDbDecoderFactory() {
        return this.dbDecoderFactory;
    }

    public DBEncoderFactory getDbEncoderFactory() {
        return this.dbEncoderFactory;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public boolean isCursorFinalizerEnabled() {
        return this.cursorFinalizerEnabled;
    }

    public boolean isAlwaysUseMBeans() {
        return this.alwaysUseMBeans;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoClientOptions that = (MongoClientOptions)o;
        if (this.alwaysUseMBeans != that.alwaysUseMBeans) {
            return false;
        }
        if (this.autoConnectRetry != that.autoConnectRetry) {
            return false;
        }
        if (this.connectTimeout != that.connectTimeout) {
            return false;
        }
        if (this.connectionsPerHost != that.connectionsPerHost) {
            return false;
        }
        if (this.cursorFinalizerEnabled != that.cursorFinalizerEnabled) {
            return false;
        }
        if (this.maxAutoConnectRetryTime != that.maxAutoConnectRetryTime) {
            return false;
        }
        if (this.maxWaitTime != that.maxWaitTime) {
            return false;
        }
        if (this.socketKeepAlive != that.socketKeepAlive) {
            return false;
        }
        if (this.socketTimeout != that.socketTimeout) {
            return false;
        }
        if (this.threadsAllowedToBlockForConnectionMultiplier != that.threadsAllowedToBlockForConnectionMultiplier) {
            return false;
        }
        if (!this.dbDecoderFactory.equals(that.dbDecoderFactory)) {
            return false;
        }
        if (!this.dbEncoderFactory.equals(that.dbEncoderFactory)) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (!this.readPreference.equals(that.readPreference)) {
            return false;
        }
        if (!this.socketFactory.getClass().equals(that.socketFactory.getClass())) {
            return false;
        }
        return this.writeConcern.equals(that.writeConcern);
    }

    public int hashCode() {
        int result = this.description != null ? this.description.hashCode() : 0;
        result = 31 * result + this.connectionsPerHost;
        result = 31 * result + this.threadsAllowedToBlockForConnectionMultiplier;
        result = 31 * result + this.maxWaitTime;
        result = 31 * result + this.connectTimeout;
        result = 31 * result + this.socketTimeout;
        result = 31 * result + (this.socketKeepAlive ? 1 : 0);
        result = 31 * result + (this.autoConnectRetry ? 1 : 0);
        result = 31 * result + (int)(this.maxAutoConnectRetryTime ^ this.maxAutoConnectRetryTime >>> 32);
        result = 31 * result + this.readPreference.hashCode();
        result = 31 * result + this.dbDecoderFactory.hashCode();
        result = 31 * result + this.dbEncoderFactory.hashCode();
        result = 31 * result + this.writeConcern.hashCode();
        result = 31 * result + this.socketFactory.hashCode();
        result = 31 * result + (this.cursorFinalizerEnabled ? 1 : 0);
        result = 31 * result + (this.alwaysUseMBeans ? 1 : 0);
        return result;
    }

    private MongoClientOptions(Builder builder) {
        this.description = builder.description;
        this.connectionsPerHost = builder.connectionsPerHost;
        this.threadsAllowedToBlockForConnectionMultiplier = builder.threadsAllowedToBlockForConnectionMultiplier;
        this.maxWaitTime = builder.maxWaitTime;
        this.connectTimeout = builder.connectTimeout;
        this.socketTimeout = builder.socketTimeout;
        this.autoConnectRetry = builder.autoConnectRetry;
        this.socketKeepAlive = builder.socketKeepAlive;
        this.maxAutoConnectRetryTime = builder.maxAutoConnectRetryTime;
        this.readPreference = builder.readPreference;
        this.dbDecoderFactory = builder.dbDecoderFactory;
        this.dbEncoderFactory = builder.dbEncoderFactory;
        this.writeConcern = builder.writeConcern;
        this.socketFactory = builder.socketFactory;
        this.cursorFinalizerEnabled = builder.cursorFinalizerEnabled;
        this.alwaysUseMBeans = builder.alwaysUseMBeans;
    }

    public static class Builder {
        private String description;
        private int connectionsPerHost = 100;
        private int threadsAllowedToBlockForConnectionMultiplier = 5;
        private int maxWaitTime = 120000;
        private int connectTimeout = 10000;
        private int socketTimeout = 0;
        private boolean socketKeepAlive = false;
        private boolean autoConnectRetry = false;
        private long maxAutoConnectRetryTime = 0L;
        private ReadPreference readPreference = ReadPreference.primary();
        private DBDecoderFactory dbDecoderFactory = DefaultDBDecoder.FACTORY;
        private DBEncoderFactory dbEncoderFactory = DefaultDBEncoder.FACTORY;
        private WriteConcern writeConcern = WriteConcern.ACKNOWLEDGED;
        private SocketFactory socketFactory = SocketFactory.getDefault();
        private boolean cursorFinalizerEnabled = true;
        private boolean alwaysUseMBeans = false;

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder connectionsPerHost(int connectionsPerHost) {
            if (connectionsPerHost < 1) {
                throw new IllegalArgumentException("Minimum value is 1");
            }
            this.connectionsPerHost = connectionsPerHost;
            return this;
        }

        public Builder threadsAllowedToBlockForConnectionMultiplier(int threadsAllowedToBlockForConnectionMultiplier) {
            if (threadsAllowedToBlockForConnectionMultiplier < 1) {
                throw new IllegalArgumentException("Minimum value is 1");
            }
            this.threadsAllowedToBlockForConnectionMultiplier = threadsAllowedToBlockForConnectionMultiplier;
            return this;
        }

        public Builder maxWaitTime(int maxWaitTime) {
            if (maxWaitTime < 0) {
                throw new IllegalArgumentException("Minimum value is 0");
            }
            this.maxWaitTime = maxWaitTime;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            if (connectTimeout < 0) {
                throw new IllegalArgumentException("Minimum value is 0");
            }
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder socketTimeout(int socketTimeout) {
            if (socketTimeout < 0) {
                throw new IllegalArgumentException("Minimum value is 0");
            }
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder socketKeepAlive(boolean socketKeepAlive) {
            this.socketKeepAlive = socketKeepAlive;
            return this;
        }

        public Builder autoConnectRetry(boolean autoConnectRetry) {
            this.autoConnectRetry = autoConnectRetry;
            return this;
        }

        public Builder maxAutoConnectRetryTime(long maxAutoConnectRetryTime) {
            if (maxAutoConnectRetryTime < 0L) {
                throw new IllegalArgumentException("Minimum value is 0");
            }
            this.maxAutoConnectRetryTime = maxAutoConnectRetryTime;
            return this;
        }

        public Builder readPreference(ReadPreference readPreference) {
            if (readPreference == null) {
                throw new IllegalArgumentException("null is not a legal value");
            }
            this.readPreference = readPreference;
            return this;
        }

        public Builder dbDecoderFactory(DBDecoderFactory dbDecoderFactory) {
            if (dbDecoderFactory == null) {
                throw new IllegalArgumentException("null is not a legal value");
            }
            this.dbDecoderFactory = dbDecoderFactory;
            return this;
        }

        public Builder dbEncoderFactory(DBEncoderFactory dbEncoderFactory) {
            if (dbEncoderFactory == null) {
                throw new IllegalArgumentException("null is not a legal value");
            }
            this.dbEncoderFactory = dbEncoderFactory;
            return this;
        }

        public Builder writeConcern(WriteConcern writeConcern) {
            if (writeConcern == null) {
                throw new IllegalArgumentException("null is not a legal value");
            }
            this.writeConcern = writeConcern;
            return this;
        }

        public Builder socketFactory(SocketFactory socketFactory) {
            if (socketFactory == null) {
                throw new IllegalArgumentException("null is not a legal value");
            }
            this.socketFactory = socketFactory;
            return this;
        }

        public Builder cursorFinalizerEnabled(boolean cursorFinalizerEnabled) {
            this.cursorFinalizerEnabled = cursorFinalizerEnabled;
            return this;
        }

        public Builder alwaysUseMBeans(boolean alwaysUseMBeans) {
            this.alwaysUseMBeans = alwaysUseMBeans;
            return this;
        }

        public Builder legacyDefaults() {
            this.connectionsPerHost = 10;
            this.writeConcern = WriteConcern.NORMAL;
            return this;
        }

        public MongoClientOptions build() {
            return new MongoClientOptions(this);
        }
    }
}

