/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.PeekIterator;

public class SecondaryAlignmentSkippingIterator {
    private final PeekIterator<SAMRecord> it;

    public SecondaryAlignmentSkippingIterator(CloseableIterator<SAMRecord> underlyingIt) {
        this.it = new PeekIterator<SAMRecord>(underlyingIt);
        this.skipAnySecondary();
    }

    public boolean hasCurrent() {
        return this.it.hasNext();
    }

    public SAMRecord getCurrent() {
        assert (this.hasCurrent());
        return this.it.peek();
    }

    public boolean advance() {
        this.it.next();
        this.skipAnySecondary();
        return this.hasCurrent();
    }

    private void skipAnySecondary() {
        while (this.it.hasNext() && this.it.peek().isSecondaryAlignment()) {
            this.it.next();
        }
    }
}

