/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf.filter;

import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.ListMap;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFileReader;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.testng.Assert;
import org.testng.annotations.Test;
import picard.PicardException;
import picard.vcf.filter.FilterVcf;

public class TestFilterVcf {
    private final File INPUT = new File("testdata/picard/vcf/filter/testFiltering.vcf");

    @Test
    public void testNoFiltering() throws Exception {
        File out = this.testFiltering(this.INPUT, 0.0, 0, 0, Double.MAX_VALUE);
        VCFFileReader in = new VCFFileReader(out, false);
        for (VariantContext ctx : in) {
            if (ctx.filtersWereApplied() && !ctx.isFiltered()) continue;
            Assert.fail((String)("Context should not have been filtered: " + ctx.toString()));
        }
    }

    @Test
    public void testAbFiltering() throws Exception {
        Set fails = CollectionUtil.makeSet((Object[])new String[]{"tf2", "rs28566954", "rs28548431"});
        File out = this.testFiltering(this.INPUT, 0.4, 0, 0, Double.MAX_VALUE);
        ListMap<String, String> filters = this.slurpFilters(out);
        Assert.assertEquals((Collection)filters.keySet(), (Collection)fails, (String)"Failed sites did not match expected set of failed sites.");
    }

    @Test
    public void testDpFiltering() throws Exception {
        Set fails = CollectionUtil.makeSet((Object[])new String[]{"rs71509448", "rs71628926", "rs13302979", "rs2710876"});
        File out = this.testFiltering(this.INPUT, 0.0, 18, 0, Double.MAX_VALUE);
        ListMap<String, String> filters = this.slurpFilters(out);
        Assert.assertEquals((Collection)filters.keySet(), (Collection)fails, (String)"Failed sites did not match expected set of failed sites.");
    }

    @Test
    public void testGqFiltering() throws Exception {
        Set fails = CollectionUtil.makeSet((Object[])new String[]{"rs71509448"});
        File out = this.testFiltering(this.INPUT, 0.0, 0, 20, Double.MAX_VALUE);
        ListMap<String, String> filters = this.slurpFilters(out);
        Assert.assertEquals((int)filters.size(), (int)0, (String)("Should not have filtered sites: " + filters));
        out = this.testFiltering(this.INPUT, 0.0, 0, 21, Double.MAX_VALUE);
        filters = this.slurpFilters(out);
        Assert.assertEquals((int)filters.size(), (int)0, (String)("Should not have filtered sites: " + filters));
        out = this.testFiltering(this.INPUT, 0.0, 0, 22, Double.MAX_VALUE);
        filters = this.slurpFilters(out);
        Assert.assertEquals((Collection)filters.keySet(), (Collection)fails, (String)"Failed sites did not match expected set of failed sites.");
    }

    @Test
    public void testFsFiltering() throws Exception {
        Set fails = CollectionUtil.makeSet((Object[])new String[]{"rs13303033", "rs28548431", "rs2799066"});
        File out = this.testFiltering(this.INPUT, 0.0, 0, 0, 5.0);
        ListMap<String, String> filters = this.slurpFilters(out);
        Assert.assertEquals((Collection)filters.keySet(), (Collection)fails, (String)"Failed sites did not match expected set of failed sites.");
    }

    @Test
    public void testCombinedFiltering() throws Exception {
        TreeSet fails = new TreeSet(CollectionUtil.makeSet((Object[])new String[]{"rs13302979", "rs13303033", "rs2710876", "rs2799066", "rs28548431", "rs28566954", "rs71509448", "rs71628926", "tf2"}));
        File out = this.testFiltering(this.INPUT, 0.4, 18, 22, 5.0);
        ListMap<String, String> filters = this.slurpFilters(out);
        Assert.assertEquals(new TreeSet(filters.keySet()), fails, (String)"Failed sites did not match expected set of failed sites.");
    }

    File testFiltering(File vcf, double minAb, int minDp, int minGq, double maxFs) throws Exception {
        File out = File.createTempFile("filterVcfTest.", ".vcf.gz");
        out.deleteOnExit();
        FilterVcf filterer = new FilterVcf();
        filterer.CREATE_INDEX = true;
        filterer.INPUT = vcf;
        filterer.OUTPUT = out;
        filterer.MIN_AB = minAb;
        filterer.MIN_DP = minDp;
        filterer.MIN_GQ = minGq;
        filterer.MAX_FS = maxFs;
        int retval = filterer.doWork();
        if (retval != 0) {
            throw new PicardException("Return value non-zero: " + retval);
        }
        return out;
    }

    ListMap<String, String> slurpFilters(File vcf) {
        ListMap map = new ListMap();
        VCFFileReader in = new VCFFileReader(vcf, false);
        for (VariantContext ctx : in) {
            if (ctx.isNotFiltered()) continue;
            for (String filter : ctx.getFilters()) {
                map.add((Object)ctx.getID(), (Object)filter);
            }
        }
        in.close();
        return map;
    }
}

