#/bin/bash
#
# Get release and create RC-File
#
function DEBUG()
{
    [ "$_DEBUG" == "on" ] &&  $@
}
function pause()
{
    read -p "Weiter mit Eingabe" $a
}
FILE="resource.rc"
RELEASE=`grep -m1 "define RELEASE"  ../version.c  | cut -f2 | tr -d '"'`
DEBUG echo $RELEASE
VERSION=${RELEASE//./,},0
DEBUG echo $VERSION
FILEVERSION=\""$RELEASE ${CODENAME//\"/}"\"
DEBUG echo $FILEVERSION
CHANGE_YEAR=`grep -m1 "define CHANGE_YEAR"  ../version.c  | cut -f2 | tr -d '"'`
DEBUG echo $CHANGE_YEAR

cat << EndOfFile > $FILE
// Iconfile (64/32/16)
ID ICON "Logo.ico"

// Infos for windows
1 VERSIONINFO
FILEVERSION     $VERSION
PRODUCTVERSION  $VERSION
FILEFLAGSMASK   0x3fL
FILEFLAGS       0x0L
FILEOS          0x40004L
FILETYPE        0x2L
FILESUBTYPE     0x0L
BEGIN
  BLOCK "StringFileInfo"
  BEGIN
    BLOCK "040904E4"
    BEGIN
      VALUE "CompanyName", "Smrbrd Software"
      VALUE "FileDescription", "ToAcme Converter"
      VALUE "FileVersion", $FILEVERSION
      VALUE "InternalName", "ToACME Converter"
      VALUE "LegalCopyright", "Copyright  $CHANGE_YEAR Marco Baye"
      VALUE "OriginalFilename", "toacme.exe"
      VALUE "ProductName", "ToACME Converter"
      VALUE "ProductVersion", $FILEVERSION
      VALUE "PorductLicence","GNU General Public License"
      VALUE "WindowsPort","Dirk Hpfner hoeppie@gmx.de"
    END
  END
  BLOCK "VarFileInfo"
  BEGIN
    VALUE "Translation", 0x409, 1252
  END
END
EndOfFile
