#!/usr/bin/perl

use strict;
use warnings;

use POSIX ":sys_wait_h";
use File::Temp;

for (my $count = 5; $count; $count--) {
    defined(my $pid = fork) || die "Fork failed: $!";
    if ($pid) {
	sleep(rand 60);
	next;
    }
    else {
	my $dir = File::Temp::tempdir(CLEANUP => 1);
	print "$$: Running new debootstrap\n";
	exec("fakechroot /usr/sbin/debootstrap --download-only --variant=fakechroot stable $dir http://localhost:3142/titan:9999/debian > /dev/null");
	die "exec() failed: $!";
    }
}


sleep(10) while waitpid(-1, WNOHANG) > 0;

print "Done!\n"
