/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.ParameterSet;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.WithParam;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.value.Value;

public class ApplyTemplates
extends Instruction {
    private Expression select;
    private WithParam[] actualParams = null;
    private WithParam[] tunnelParams = null;
    private boolean useCurrentMode = false;
    private boolean useTailRecursion = false;
    private Mode mode;

    public ApplyTemplates(Expression expression, WithParam[] withParamArray, WithParam[] withParamArray2, boolean bl, boolean bl2, Mode mode) {
        this.select = expression;
        this.actualParams = withParamArray;
        this.tunnelParams = withParamArray2;
        this.useCurrentMode = bl;
        this.useTailRecursion = bl2;
        this.mode = mode;
    }

    public void setInstructionDetails(Controller controller, NamePool namePool, InstructionDetails instructionDetails) {
        instructionDetails.setInstructionName("apply-templates");
        instructionDetails.setProperty("mode", this.mode);
    }

    public InstructionDetails getInstructionDetails(Controller controller) {
        InstructionDetails instructionDetails = super.getInstructionDetails(controller);
        instructionDetails.setProperty("mode", this.mode.getModeName());
        return instructionDetails;
    }

    public void process(XPathContext xPathContext) throws TransformerException {
        this.apply(xPathContext, false);
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        return this.apply(xPathContext, this.useTailRecursion);
    }

    private TailCall apply(XPathContext xPathContext, boolean bl) throws TransformerException {
        Mode mode = this.mode;
        Controller controller = xPathContext.getController();
        if (this.useCurrentMode) {
            mode = controller.getCurrentMode();
        }
        ParameterSet parameterSet = this.assembleParams(xPathContext, this.actualParams);
        ParameterSet parameterSet2 = this.assembleTunnelParams(xPathContext, this.tunnelParams);
        if (bl) {
            return new ApplyTemplatesPackage(ExpressionTool.lazyEvaluate(this.select, xPathContext), mode, parameterSet, parameterSet2, controller.saveContext());
        }
        SequenceIterator sequenceIterator = this.select.iterate(xPathContext);
        if (sequenceIterator instanceof EmptyIterator) {
            return null;
        }
        TailCall tailCall = controller.applyTemplates(sequenceIterator, mode, parameterSet, parameterSet2);
        while (tailCall != null) {
            tailCall = tailCall.processLeavingTail(controller.newXPathContext());
        }
        return null;
    }

    private static class ApplyTemplatesPackage
    implements TailCall {
        private Value selectedNodes;
        private Mode mode;
        private ParameterSet params;
        private ParameterSet tunnelParams;
        private Object[] executionContext;

        public ApplyTemplatesPackage(Value value, Mode mode, ParameterSet parameterSet, ParameterSet parameterSet2, Object[] objectArray) {
            this.selectedNodes = value;
            this.mode = mode;
            this.params = parameterSet;
            this.tunnelParams = parameterSet2;
            this.executionContext = objectArray;
        }

        public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
            Controller controller = xPathContext.getController();
            Object[] objectArray = controller.saveContext();
            controller.restoreContext(this.executionContext);
            TailCall tailCall = controller.applyTemplates(this.selectedNodes.iterate(xPathContext), this.mode, this.params, this.tunnelParams);
            controller.restoreContext(objectArray);
            return tailCall;
        }
    }
}

