/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.NodeImpl;

abstract class TreeEnumeration
implements AxisIterator {
    protected NodeImpl start;
    protected NodeImpl next;
    protected NodeTest nodeTest;
    protected NodeImpl current = null;
    protected int position = 0;

    public TreeEnumeration(NodeImpl nodeImpl, NodeTest nodeTest) {
        this.next = nodeImpl;
        this.start = nodeImpl;
        this.nodeTest = nodeTest;
    }

    protected boolean conforms(NodeImpl nodeImpl) {
        if (nodeImpl == null || this.nodeTest == null) {
            return true;
        }
        return this.nodeTest.matches(nodeImpl.getNodeKind(), nodeImpl.getFingerprint(), nodeImpl.getTypeAnnotation());
    }

    protected final void advance() {
        do {
            this.step();
        } while (!this.conforms(this.next));
    }

    protected abstract void step();

    public final Item next() {
        if (this.next == null) {
            return null;
        }
        this.current = this.next;
        ++this.position;
        this.advance();
        return this.current;
    }

    public final Item current() {
        return this.current;
    }

    public final int position() {
        return this.position;
    }
}

