/*  BaitFisher (version 1.2.7) a program for designing DNA target enrichment baits
 *  Copyright 2013-2016 by Christoph Mayer
 *
 *  This source file is part of the BaitFisher-package.
 * 
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with BaitFisher.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 *  For any enquiries send an Email to Christoph Mayer
 *  c.mayer.zfmk@uni-bonn.de
 *
 *  When publishing work that is based on the results please cite:
 *  Mayer et al. 2016: BaitFisher: A software package for multi-species target DNA enrichment probe design
 *  
 */
#ifndef PRIMEFACTORS_H
#define PRIMEFACTORS_H

static int primeFactors[10001][6] =
  {
    {  0,  0,  0,  0,  0,  0},   // 0
    {  0,  0,  0,  0,  0,  0},   // 1
    {  0,  0,  0,  0,  0,  0},   // 2
    {  0,  0,  0,  0,  0,  0},   // 3
    {  2,  0,  0,  0,  0,  0},   // 4
    {  0,  0,  0,  0,  0,  0},   // 5
    {  2,  3,  0,  0,  0,  0},   // 6
    {  0,  0,  0,  0,  0,  0},   // 7
    {  2,  0,  0,  0,  0,  0},   // 8
    {  3,  0,  0,  0,  0,  0},   // 9
    {  2,  5,  0,  0,  0,  0},   // 10
    {  0,  0,  0,  0,  0,  0},   // 11
    {  2,  3,  0,  0,  0,  0},   // 12
    {  0,  0,  0,  0,  0,  0},   // 13
    {  2,  7,  0,  0,  0,  0},   // 14
    {  3,  5,  0,  0,  0,  0},   // 15
    {  2,  0,  0,  0,  0,  0},   // 16
    {  0,  0,  0,  0,  0,  0},   // 17
    {  2,  3,  0,  0,  0,  0},   // 18
    {  0,  0,  0,  0,  0,  0},   // 19
    {  2,  5,  0,  0,  0,  0},   // 20
    {  3,  7,  0,  0,  0,  0},   // 21
    {  2, 11,  0,  0,  0,  0},   // 22
    {  0,  0,  0,  0,  0,  0},   // 23
    {  2,  3,  0,  0,  0,  0},   // 24
    {  5,  0,  0,  0,  0,  0},   // 25
    {  2, 13,  0,  0,  0,  0},   // 26
    {  3,  0,  0,  0,  0,  0},   // 27
    {  2,  7,  0,  0,  0,  0},   // 28
    {  0,  0,  0,  0,  0,  0},   // 29
    {  2,  3,  5,  0,  0,  0},   // 30
    {  0,  0,  0,  0,  0,  0},   // 31
    {  2,  0,  0,  0,  0,  0},   // 32
    {  3, 11,  0,  0,  0,  0},   // 33
    {  2, 17,  0,  0,  0,  0},   // 34
    {  5,  7,  0,  0,  0,  0},   // 35
    {  2,  3,  0,  0,  0,  0},   // 36
    {  0,  0,  0,  0,  0,  0},   // 37
    {  2, 19,  0,  0,  0,  0},   // 38
    {  3, 13,  0,  0,  0,  0},   // 39
    {  2,  5,  0,  0,  0,  0},   // 40
    {  0,  0,  0,  0,  0,  0},   // 41
    {  2,  3,  7,  0,  0,  0},   // 42
    {  0,  0,  0,  0,  0,  0},   // 43
    {  2, 11,  0,  0,  0,  0},   // 44
    {  3,  5,  0,  0,  0,  0},   // 45
    {  2, 23,  0,  0,  0,  0},   // 46
    {  0,  0,  0,  0,  0,  0},   // 47
    {  2,  3,  0,  0,  0,  0},   // 48
    {  7,  0,  0,  0,  0,  0},   // 49
    {  2,  5,  0,  0,  0,  0},   // 50
    {  3, 17,  0,  0,  0,  0},   // 51
    {  2, 13,  0,  0,  0,  0},   // 52
    {  0,  0,  0,  0,  0,  0},   // 53
    {  2,  3,  0,  0,  0,  0},   // 54
    {  5, 11,  0,  0,  0,  0},   // 55
    {  2,  7,  0,  0,  0,  0},   // 56
    {  3, 19,  0,  0,  0,  0},   // 57
    {  2, 29,  0,  0,  0,  0},   // 58
    {  0,  0,  0,  0,  0,  0},   // 59
    {  2,  3,  5,  0,  0,  0},   // 60
    {  0,  0,  0,  0,  0,  0},   // 61
    {  2, 31,  0,  0,  0,  0},   // 62
    {  3,  7,  0,  0,  0,  0},   // 63
    {  2,  0,  0,  0,  0,  0},   // 64
    {  5, 13,  0,  0,  0,  0},   // 65
    {  2,  3, 11,  0,  0,  0},   // 66
    {  0,  0,  0,  0,  0,  0},   // 67
    {  2, 17,  0,  0,  0,  0},   // 68
    {  3, 23,  0,  0,  0,  0},   // 69
    {  2,  5,  7,  0,  0,  0},   // 70
    {  0,  0,  0,  0,  0,  0},   // 71
    {  2,  3,  0,  0,  0,  0},   // 72
    {  0,  0,  0,  0,  0,  0},   // 73
    {  2, 37,  0,  0,  0,  0},   // 74
    {  3,  5,  0,  0,  0,  0},   // 75
    {  2, 19,  0,  0,  0,  0},   // 76
    {  7, 11,  0,  0,  0,  0},   // 77
    {  2,  3, 13,  0,  0,  0},   // 78
    {  0,  0,  0,  0,  0,  0},   // 79
    {  2,  5,  0,  0,  0,  0},   // 80
    {  3,  0,  0,  0,  0,  0},   // 81
    {  2, 41,  0,  0,  0,  0},   // 82
    {  0,  0,  0,  0,  0,  0},   // 83
    {  2,  3,  7,  0,  0,  0},   // 84
    {  5, 17,  0,  0,  0,  0},   // 85
    {  2, 43,  0,  0,  0,  0},   // 86
    {  3, 29,  0,  0,  0,  0},   // 87
    {  2, 11,  0,  0,  0,  0},   // 88
    {  0,  0,  0,  0,  0,  0},   // 89
    {  2,  3,  5,  0,  0,  0},   // 90
    {  7, 13,  0,  0,  0,  0},   // 91
    {  2, 23,  0,  0,  0,  0},   // 92
    {  3, 31,  0,  0,  0,  0},   // 93
    {  2, 47,  0,  0,  0,  0},   // 94
    {  5, 19,  0,  0,  0,  0},   // 95
    {  2,  3,  0,  0,  0,  0},   // 96
    {  0,  0,  0,  0,  0,  0},   // 97
    {  2,  7,  0,  0,  0,  0},   // 98
    {  3, 11,  0,  0,  0,  0},   // 99
    {  2,  5,  0,  0,  0,  0},   // 100
    {  0,  0,  0,  0,  0,  0},   // 101
    {  2,  3, 17,  0,  0,  0},   // 102
    {  0,  0,  0,  0,  0,  0},   // 103
    {  2, 13,  0,  0,  0,  0},   // 104
    {  3,  5,  7,  0,  0,  0},   // 105
    {  2, 53,  0,  0,  0,  0},   // 106
    {  0,  0,  0,  0,  0,  0},   // 107
    {  2,  3,  0,  0,  0,  0},   // 108
    {  0,  0,  0,  0,  0,  0},   // 109
    {  2,  5, 11,  0,  0,  0},   // 110
    {  3, 37,  0,  0,  0,  0},   // 111
    {  2,  7,  0,  0,  0,  0},   // 112
    {  0,  0,  0,  0,  0,  0},   // 113
    {  2,  3, 19,  0,  0,  0},   // 114
    {  5, 23,  0,  0,  0,  0},   // 115
    {  2, 29,  0,  0,  0,  0},   // 116
    {  3, 13,  0,  0,  0,  0},   // 117
    {  2, 59,  0,  0,  0,  0},   // 118
    {  7, 17,  0,  0,  0,  0},   // 119
    {  2,  3,  5,  0,  0,  0},   // 120
    { 11,  0,  0,  0,  0,  0},   // 121
    {  2, 61,  0,  0,  0,  0},   // 122
    {  3, 41,  0,  0,  0,  0},   // 123
    {  2, 31,  0,  0,  0,  0},   // 124
    {  5,  0,  0,  0,  0,  0},   // 125
    {  2,  3,  7,  0,  0,  0},   // 126
    {  0,  0,  0,  0,  0,  0},   // 127
    {  2,  0,  0,  0,  0,  0},   // 128
    {  3, 43,  0,  0,  0,  0},   // 129
    {  2,  5, 13,  0,  0,  0},   // 130
    {  0,  0,  0,  0,  0,  0},   // 131
    {  2,  3, 11,  0,  0,  0},   // 132
    {  7, 19,  0,  0,  0,  0},   // 133
    {  2, 67,  0,  0,  0,  0},   // 134
    {  3,  5,  0,  0,  0,  0},   // 135
    {  2, 17,  0,  0,  0,  0},   // 136
    {  0,  0,  0,  0,  0,  0},   // 137
    {  2,  3, 23,  0,  0,  0},   // 138
    {  0,  0,  0,  0,  0,  0},   // 139
    {  2,  5,  7,  0,  0,  0},   // 140
    {  3, 47,  0,  0,  0,  0},   // 141
    {  2, 71,  0,  0,  0,  0},   // 142
    { 11, 13,  0,  0,  0,  0},   // 143
    {  2,  3,  0,  0,  0,  0},   // 144
    {  5, 29,  0,  0,  0,  0},   // 145
    {  2, 73,  0,  0,  0,  0},   // 146
    {  3,  7,  0,  0,  0,  0},   // 147
    {  2, 37,  0,  0,  0,  0},   // 148
    {  0,  0,  0,  0,  0,  0},   // 149
    {  2,  3,  5,  0,  0,  0},   // 150
    {  0,  0,  0,  0,  0,  0},   // 151
    {  2, 19,  0,  0,  0,  0},   // 152
    {  3, 17,  0,  0,  0,  0},   // 153
    {  2,  7, 11,  0,  0,  0},   // 154
    {  5, 31,  0,  0,  0,  0},   // 155
    {  2,  3, 13,  0,  0,  0},   // 156
    {  0,  0,  0,  0,  0,  0},   // 157
    {  2, 79,  0,  0,  0,  0},   // 158
    {  3, 53,  0,  0,  0,  0},   // 159
    {  2,  5,  0,  0,  0,  0},   // 160
    {  7, 23,  0,  0,  0,  0},   // 161
    {  2,  3,  0,  0,  0,  0},   // 162
    {  0,  0,  0,  0,  0,  0},   // 163
    {  2, 41,  0,  0,  0,  0},   // 164
    {  3,  5, 11,  0,  0,  0},   // 165
    {  2, 83,  0,  0,  0,  0},   // 166
    {  0,  0,  0,  0,  0,  0},   // 167
    {  2,  3,  7,  0,  0,  0},   // 168
    { 13,  0,  0,  0,  0,  0},   // 169
    {  2,  5, 17,  0,  0,  0},   // 170
    {  3, 19,  0,  0,  0,  0},   // 171
    {  2, 43,  0,  0,  0,  0},   // 172
    {  0,  0,  0,  0,  0,  0},   // 173
    {  2,  3, 29,  0,  0,  0},   // 174
    {  5,  7,  0,  0,  0,  0},   // 175
    {  2, 11,  0,  0,  0,  0},   // 176
    {  3, 59,  0,  0,  0,  0},   // 177
    {  2, 89,  0,  0,  0,  0},   // 178
    {  0,  0,  0,  0,  0,  0},   // 179
    {  2,  3,  5,  0,  0,  0},   // 180
    {  0,  0,  0,  0,  0,  0},   // 181
    {  2,  7, 13,  0,  0,  0},   // 182
    {  3, 61,  0,  0,  0,  0},   // 183
    {  2, 23,  0,  0,  0,  0},   // 184
    {  5, 37,  0,  0,  0,  0},   // 185
    {  2,  3, 31,  0,  0,  0},   // 186
    { 11, 17,  0,  0,  0,  0},   // 187
    {  2, 47,  0,  0,  0,  0},   // 188
    {  3,  7,  0,  0,  0,  0},   // 189
    {  2,  5, 19,  0,  0,  0},   // 190
    {  0,  0,  0,  0,  0,  0},   // 191
    {  2,  3,  0,  0,  0,  0},   // 192
    {  0,  0,  0,  0,  0,  0},   // 193
    {  2, 97,  0,  0,  0,  0},   // 194
    {  3,  5, 13,  0,  0,  0},   // 195
    {  2,  7,  0,  0,  0,  0},   // 196
    {  0,  0,  0,  0,  0,  0},   // 197
    {  2,  3, 11,  0,  0,  0},   // 198
    {  0,  0,  0,  0,  0,  0},   // 199
    {  2,  5,  0,  0,  0,  0},   // 200
    {  3, 67,  0,  0,  0,  0},   // 201
    {  2,101,  0,  0,  0,  0},   // 202
    {  7, 29,  0,  0,  0,  0},   // 203
    {  2,  3, 17,  0,  0,  0},   // 204
    {  5, 41,  0,  0,  0,  0},   // 205
    {  2,103,  0,  0,  0,  0},   // 206
    {  3, 23,  0,  0,  0,  0},   // 207
    {  2, 13,  0,  0,  0,  0},   // 208
    { 11, 19,  0,  0,  0,  0},   // 209
    {  2,  3,  5,  7,  0,  0},   // 210
    {  0,  0,  0,  0,  0,  0},   // 211
    {  2, 53,  0,  0,  0,  0},   // 212
    {  3, 71,  0,  0,  0,  0},   // 213
    {  2,107,  0,  0,  0,  0},   // 214
    {  5, 43,  0,  0,  0,  0},   // 215
    {  2,  3,  0,  0,  0,  0},   // 216
    {  7, 31,  0,  0,  0,  0},   // 217
    {  2,109,  0,  0,  0,  0},   // 218
    {  3, 73,  0,  0,  0,  0},   // 219
    {  2,  5, 11,  0,  0,  0},   // 220
    { 13, 17,  0,  0,  0,  0},   // 221
    {  2,  3, 37,  0,  0,  0},   // 222
    {  0,  0,  0,  0,  0,  0},   // 223
    {  2,  7,  0,  0,  0,  0},   // 224
    {  3,  5,  0,  0,  0,  0},   // 225
    {  2,113,  0,  0,  0,  0},   // 226
    {  0,  0,  0,  0,  0,  0},   // 227
    {  2,  3, 19,  0,  0,  0},   // 228
    {  0,  0,  0,  0,  0,  0},   // 229
    {  2,  5, 23,  0,  0,  0},   // 230
    {  3,  7, 11,  0,  0,  0},   // 231
    {  2, 29,  0,  0,  0,  0},   // 232
    {  0,  0,  0,  0,  0,  0},   // 233
    {  2,  3, 13,  0,  0,  0},   // 234
    {  5, 47,  0,  0,  0,  0},   // 235
    {  2, 59,  0,  0,  0,  0},   // 236
    {  3, 79,  0,  0,  0,  0},   // 237
    {  2,  7, 17,  0,  0,  0},   // 238
    {  0,  0,  0,  0,  0,  0},   // 239
    {  2,  3,  5,  0,  0,  0},   // 240
    {  0,  0,  0,  0,  0,  0},   // 241
    {  2, 11,  0,  0,  0,  0},   // 242
    {  3,  0,  0,  0,  0,  0},   // 243
    {  2, 61,  0,  0,  0,  0},   // 244
    {  5,  7,  0,  0,  0,  0},   // 245
    {  2,  3, 41,  0,  0,  0},   // 246
    { 13, 19,  0,  0,  0,  0},   // 247
    {  2, 31,  0,  0,  0,  0},   // 248
    {  3, 83,  0,  0,  0,  0},   // 249
    {  2,  5,  0,  0,  0,  0},   // 250
    {  0,  0,  0,  0,  0,  0},   // 251
    {  2,  3,  7,  0,  0,  0},   // 252
    { 11, 23,  0,  0,  0,  0},   // 253
    {  2,127,  0,  0,  0,  0},   // 254
    {  3,  5, 17,  0,  0,  0},   // 255
    {  2,  0,  0,  0,  0,  0},   // 256
    {  0,  0,  0,  0,  0,  0},   // 257
    {  2,  3, 43,  0,  0,  0},   // 258
    {  7, 37,  0,  0,  0,  0},   // 259
    {  2,  5, 13,  0,  0,  0},   // 260
    {  3, 29,  0,  0,  0,  0},   // 261
    {  2,131,  0,  0,  0,  0},   // 262
    {  0,  0,  0,  0,  0,  0},   // 263
    {  2,  3, 11,  0,  0,  0},   // 264
    {  5, 53,  0,  0,  0,  0},   // 265
    {  2,  7, 19,  0,  0,  0},   // 266
    {  3, 89,  0,  0,  0,  0},   // 267
    {  2, 67,  0,  0,  0,  0},   // 268
    {  0,  0,  0,  0,  0,  0},   // 269
    {  2,  3,  5,  0,  0,  0},   // 270
    {  0,  0,  0,  0,  0,  0},   // 271
    {  2, 17,  0,  0,  0,  0},   // 272
    {  3,  7, 13,  0,  0,  0},   // 273
    {  2,137,  0,  0,  0,  0},   // 274
    {  5, 11,  0,  0,  0,  0},   // 275
    {  2,  3, 23,  0,  0,  0},   // 276
    {  0,  0,  0,  0,  0,  0},   // 277
    {  2,139,  0,  0,  0,  0},   // 278
    {  3, 31,  0,  0,  0,  0},   // 279
    {  2,  5,  7,  0,  0,  0},   // 280
    {  0,  0,  0,  0,  0,  0},   // 281
    {  2,  3, 47,  0,  0,  0},   // 282
    {  0,  0,  0,  0,  0,  0},   // 283
    {  2, 71,  0,  0,  0,  0},   // 284
    {  3,  5, 19,  0,  0,  0},   // 285
    {  2, 11, 13,  0,  0,  0},   // 286
    {  7, 41,  0,  0,  0,  0},   // 287
    {  2,  3,  0,  0,  0,  0},   // 288
    { 17,  0,  0,  0,  0,  0},   // 289
    {  2,  5, 29,  0,  0,  0},   // 290
    {  3, 97,  0,  0,  0,  0},   // 291
    {  2, 73,  0,  0,  0,  0},   // 292
    {  0,  0,  0,  0,  0,  0},   // 293
    {  2,  3,  7,  0,  0,  0},   // 294
    {  5, 59,  0,  0,  0,  0},   // 295
    {  2, 37,  0,  0,  0,  0},   // 296
    {  3, 11,  0,  0,  0,  0},   // 297
    {  2,149,  0,  0,  0,  0},   // 298
    { 13, 23,  0,  0,  0,  0},   // 299
    {  2,  3,  5,  0,  0,  0},   // 300
    {  7, 43,  0,  0,  0,  0},   // 301
    {  2,151,  0,  0,  0,  0},   // 302
    {  3,101,  0,  0,  0,  0},   // 303
    {  2, 19,  0,  0,  0,  0},   // 304
    {  5, 61,  0,  0,  0,  0},   // 305
    {  2,  3, 17,  0,  0,  0},   // 306
    {  0,  0,  0,  0,  0,  0},   // 307
    {  2,  7, 11,  0,  0,  0},   // 308
    {  3,103,  0,  0,  0,  0},   // 309
    {  2,  5, 31,  0,  0,  0},   // 310
    {  0,  0,  0,  0,  0,  0},   // 311
    {  2,  3, 13,  0,  0,  0},   // 312
    {  0,  0,  0,  0,  0,  0},   // 313
    {  2,157,  0,  0,  0,  0},   // 314
    {  3,  5,  7,  0,  0,  0},   // 315
    {  2, 79,  0,  0,  0,  0},   // 316
    {  0,  0,  0,  0,  0,  0},   // 317
    {  2,  3, 53,  0,  0,  0},   // 318
    { 11, 29,  0,  0,  0,  0},   // 319
    {  2,  5,  0,  0,  0,  0},   // 320
    {  3,107,  0,  0,  0,  0},   // 321
    {  2,  7, 23,  0,  0,  0},   // 322
    { 17, 19,  0,  0,  0,  0},   // 323
    {  2,  3,  0,  0,  0,  0},   // 324
    {  5, 13,  0,  0,  0,  0},   // 325
    {  2,163,  0,  0,  0,  0},   // 326
    {  3,109,  0,  0,  0,  0},   // 327
    {  2, 41,  0,  0,  0,  0},   // 328
    {  7, 47,  0,  0,  0,  0},   // 329
    {  2,  3,  5, 11,  0,  0},   // 330
    {  0,  0,  0,  0,  0,  0},   // 331
    {  2, 83,  0,  0,  0,  0},   // 332
    {  3, 37,  0,  0,  0,  0},   // 333
    {  2,167,  0,  0,  0,  0},   // 334
    {  5, 67,  0,  0,  0,  0},   // 335
    {  2,  3,  7,  0,  0,  0},   // 336
    {  0,  0,  0,  0,  0,  0},   // 337
    {  2, 13,  0,  0,  0,  0},   // 338
    {  3,113,  0,  0,  0,  0},   // 339
    {  2,  5, 17,  0,  0,  0},   // 340
    { 11, 31,  0,  0,  0,  0},   // 341
    {  2,  3, 19,  0,  0,  0},   // 342
    {  7,  0,  0,  0,  0,  0},   // 343
    {  2, 43,  0,  0,  0,  0},   // 344
    {  3,  5, 23,  0,  0,  0},   // 345
    {  2,173,  0,  0,  0,  0},   // 346
    {  0,  0,  0,  0,  0,  0},   // 347
    {  2,  3, 29,  0,  0,  0},   // 348
    {  0,  0,  0,  0,  0,  0},   // 349
    {  2,  5,  7,  0,  0,  0},   // 350
    {  3, 13,  0,  0,  0,  0},   // 351
    {  2, 11,  0,  0,  0,  0},   // 352
    {  0,  0,  0,  0,  0,  0},   // 353
    {  2,  3, 59,  0,  0,  0},   // 354
    {  5, 71,  0,  0,  0,  0},   // 355
    {  2, 89,  0,  0,  0,  0},   // 356
    {  3,  7, 17,  0,  0,  0},   // 357
    {  2,179,  0,  0,  0,  0},   // 358
    {  0,  0,  0,  0,  0,  0},   // 359
    {  2,  3,  5,  0,  0,  0},   // 360
    { 19,  0,  0,  0,  0,  0},   // 361
    {  2,181,  0,  0,  0,  0},   // 362
    {  3, 11,  0,  0,  0,  0},   // 363
    {  2,  7, 13,  0,  0,  0},   // 364
    {  5, 73,  0,  0,  0,  0},   // 365
    {  2,  3, 61,  0,  0,  0},   // 366
    {  0,  0,  0,  0,  0,  0},   // 367
    {  2, 23,  0,  0,  0,  0},   // 368
    {  3, 41,  0,  0,  0,  0},   // 369
    {  2,  5, 37,  0,  0,  0},   // 370
    {  7, 53,  0,  0,  0,  0},   // 371
    {  2,  3, 31,  0,  0,  0},   // 372
    {  0,  0,  0,  0,  0,  0},   // 373
    {  2, 11, 17,  0,  0,  0},   // 374
    {  3,  5,  0,  0,  0,  0},   // 375
    {  2, 47,  0,  0,  0,  0},   // 376
    { 13, 29,  0,  0,  0,  0},   // 377
    {  2,  3,  7,  0,  0,  0},   // 378
    {  0,  0,  0,  0,  0,  0},   // 379
    {  2,  5, 19,  0,  0,  0},   // 380
    {  3,127,  0,  0,  0,  0},   // 381
    {  2,191,  0,  0,  0,  0},   // 382
    {  0,  0,  0,  0,  0,  0},   // 383
    {  2,  3,  0,  0,  0,  0},   // 384
    {  5,  7, 11,  0,  0,  0},   // 385
    {  2,193,  0,  0,  0,  0},   // 386
    {  3, 43,  0,  0,  0,  0},   // 387
    {  2, 97,  0,  0,  0,  0},   // 388
    {  0,  0,  0,  0,  0,  0},   // 389
    {  2,  3,  5, 13,  0,  0},   // 390
    { 17, 23,  0,  0,  0,  0},   // 391
    {  2,  7,  0,  0,  0,  0},   // 392
    {  3,131,  0,  0,  0,  0},   // 393
    {  2,197,  0,  0,  0,  0},   // 394
    {  5, 79,  0,  0,  0,  0},   // 395
    {  2,  3, 11,  0,  0,  0},   // 396
    {  0,  0,  0,  0,  0,  0},   // 397
    {  2,199,  0,  0,  0,  0},   // 398
    {  3,  7, 19,  0,  0,  0},   // 399
    {  2,  5,  0,  0,  0,  0},   // 400
    {  0,  0,  0,  0,  0,  0},   // 401
    {  2,  3, 67,  0,  0,  0},   // 402
    { 13, 31,  0,  0,  0,  0},   // 403
    {  2,101,  0,  0,  0,  0},   // 404
    {  3,  5,  0,  0,  0,  0},   // 405
    {  2,  7, 29,  0,  0,  0},   // 406
    { 11, 37,  0,  0,  0,  0},   // 407
    {  2,  3, 17,  0,  0,  0},   // 408
    {  0,  0,  0,  0,  0,  0},   // 409
    {  2,  5, 41,  0,  0,  0},   // 410
    {  3,137,  0,  0,  0,  0},   // 411
    {  2,103,  0,  0,  0,  0},   // 412
    {  7, 59,  0,  0,  0,  0},   // 413
    {  2,  3, 23,  0,  0,  0},   // 414
    {  5, 83,  0,  0,  0,  0},   // 415
    {  2, 13,  0,  0,  0,  0},   // 416
    {  3,139,  0,  0,  0,  0},   // 417
    {  2, 11, 19,  0,  0,  0},   // 418
    {  0,  0,  0,  0,  0,  0},   // 419
    {  2,  3,  5,  7,  0,  0},   // 420
    {  0,  0,  0,  0,  0,  0},   // 421
    {  2,211,  0,  0,  0,  0},   // 422
    {  3, 47,  0,  0,  0,  0},   // 423
    {  2, 53,  0,  0,  0,  0},   // 424
    {  5, 17,  0,  0,  0,  0},   // 425
    {  2,  3, 71,  0,  0,  0},   // 426
    {  7, 61,  0,  0,  0,  0},   // 427
    {  2,107,  0,  0,  0,  0},   // 428
    {  3, 11, 13,  0,  0,  0},   // 429
    {  2,  5, 43,  0,  0,  0},   // 430
    {  0,  0,  0,  0,  0,  0},   // 431
    {  2,  3,  0,  0,  0,  0},   // 432
    {  0,  0,  0,  0,  0,  0},   // 433
    {  2,  7, 31,  0,  0,  0},   // 434
    {  3,  5, 29,  0,  0,  0},   // 435
    {  2,109,  0,  0,  0,  0},   // 436
    { 19, 23,  0,  0,  0,  0},   // 437
    {  2,  3, 73,  0,  0,  0},   // 438
    {  0,  0,  0,  0,  0,  0},   // 439
    {  2,  5, 11,  0,  0,  0},   // 440
    {  3,  7,  0,  0,  0,  0},   // 441
    {  2, 13, 17,  0,  0,  0},   // 442
    {  0,  0,  0,  0,  0,  0},   // 443
    {  2,  3, 37,  0,  0,  0},   // 444
    {  5, 89,  0,  0,  0,  0},   // 445
    {  2,223,  0,  0,  0,  0},   // 446
    {  3,149,  0,  0,  0,  0},   // 447
    {  2,  7,  0,  0,  0,  0},   // 448
    {  0,  0,  0,  0,  0,  0},   // 449
    {  2,  3,  5,  0,  0,  0},   // 450
    { 11, 41,  0,  0,  0,  0},   // 451
    {  2,113,  0,  0,  0,  0},   // 452
    {  3,151,  0,  0,  0,  0},   // 453
    {  2,227,  0,  0,  0,  0},   // 454
    {  5,  7, 13,  0,  0,  0},   // 455
    {  2,  3, 19,  0,  0,  0},   // 456
    {  0,  0,  0,  0,  0,  0},   // 457
    {  2,229,  0,  0,  0,  0},   // 458
    {  3, 17,  0,  0,  0,  0},   // 459
    {  2,  5, 23,  0,  0,  0},   // 460
    {  0,  0,  0,  0,  0,  0},   // 461
    {  2,  3,  7, 11,  0,  0},   // 462
    {  0,  0,  0,  0,  0,  0},   // 463
    {  2, 29,  0,  0,  0,  0},   // 464
    {  3,  5, 31,  0,  0,  0},   // 465
    {  2,233,  0,  0,  0,  0},   // 466
    {  0,  0,  0,  0,  0,  0},   // 467
    {  2,  3, 13,  0,  0,  0},   // 468
    {  7, 67,  0,  0,  0,  0},   // 469
    {  2,  5, 47,  0,  0,  0},   // 470
    {  3,157,  0,  0,  0,  0},   // 471
    {  2, 59,  0,  0,  0,  0},   // 472
    { 11, 43,  0,  0,  0,  0},   // 473
    {  2,  3, 79,  0,  0,  0},   // 474
    {  5, 19,  0,  0,  0,  0},   // 475
    {  2,  7, 17,  0,  0,  0},   // 476
    {  3, 53,  0,  0,  0,  0},   // 477
    {  2,239,  0,  0,  0,  0},   // 478
    {  0,  0,  0,  0,  0,  0},   // 479
    {  2,  3,  5,  0,  0,  0},   // 480
    { 13, 37,  0,  0,  0,  0},   // 481
    {  2,241,  0,  0,  0,  0},   // 482
    {  3,  7, 23,  0,  0,  0},   // 483
    {  2, 11,  0,  0,  0,  0},   // 484
    {  5, 97,  0,  0,  0,  0},   // 485
    {  2,  3,  0,  0,  0,  0},   // 486
    {  0,  0,  0,  0,  0,  0},   // 487
    {  2, 61,  0,  0,  0,  0},   // 488
    {  3,163,  0,  0,  0,  0},   // 489
    {  2,  5,  7,  0,  0,  0},   // 490
    {  0,  0,  0,  0,  0,  0},   // 491
    {  2,  3, 41,  0,  0,  0},   // 492
    { 17, 29,  0,  0,  0,  0},   // 493
    {  2, 13, 19,  0,  0,  0},   // 494
    {  3,  5, 11,  0,  0,  0},   // 495
    {  2, 31,  0,  0,  0,  0},   // 496
    {  7, 71,  0,  0,  0,  0},   // 497
    {  2,  3, 83,  0,  0,  0},   // 498
    {  0,  0,  0,  0,  0,  0},   // 499
    {  2,  5,  0,  0,  0,  0},   // 500
    {  3,167,  0,  0,  0,  0},   // 501
    {  2,251,  0,  0,  0,  0},   // 502
    {  0,  0,  0,  0,  0,  0},   // 503
    {  2,  3,  7,  0,  0,  0},   // 504
    {  5,101,  0,  0,  0,  0},   // 505
    {  2, 11, 23,  0,  0,  0},   // 506
    {  3, 13,  0,  0,  0,  0},   // 507
    {  2,127,  0,  0,  0,  0},   // 508
    {  0,  0,  0,  0,  0,  0},   // 509
    {  2,  3,  5, 17,  0,  0},   // 510
    {  7, 73,  0,  0,  0,  0},   // 511
    {  2,  0,  0,  0,  0,  0},   // 512
    {  3, 19,  0,  0,  0,  0},   // 513
    {  2,257,  0,  0,  0,  0},   // 514
    {  5,103,  0,  0,  0,  0},   // 515
    {  2,  3, 43,  0,  0,  0},   // 516
    { 11, 47,  0,  0,  0,  0},   // 517
    {  2,  7, 37,  0,  0,  0},   // 518
    {  3,173,  0,  0,  0,  0},   // 519
    {  2,  5, 13,  0,  0,  0},   // 520
    {  0,  0,  0,  0,  0,  0},   // 521
    {  2,  3, 29,  0,  0,  0},   // 522
    {  0,  0,  0,  0,  0,  0},   // 523
    {  2,131,  0,  0,  0,  0},   // 524
    {  3,  5,  7,  0,  0,  0},   // 525
    {  2,263,  0,  0,  0,  0},   // 526
    { 17, 31,  0,  0,  0,  0},   // 527
    {  2,  3, 11,  0,  0,  0},   // 528
    { 23,  0,  0,  0,  0,  0},   // 529
    {  2,  5, 53,  0,  0,  0},   // 530
    {  3, 59,  0,  0,  0,  0},   // 531
    {  2,  7, 19,  0,  0,  0},   // 532
    { 13, 41,  0,  0,  0,  0},   // 533
    {  2,  3, 89,  0,  0,  0},   // 534
    {  5,107,  0,  0,  0,  0},   // 535
    {  2, 67,  0,  0,  0,  0},   // 536
    {  3,179,  0,  0,  0,  0},   // 537
    {  2,269,  0,  0,  0,  0},   // 538
    {  7, 11,  0,  0,  0,  0},   // 539
    {  2,  3,  5,  0,  0,  0},   // 540
    {  0,  0,  0,  0,  0,  0},   // 541
    {  2,271,  0,  0,  0,  0},   // 542
    {  3,181,  0,  0,  0,  0},   // 543
    {  2, 17,  0,  0,  0,  0},   // 544
    {  5,109,  0,  0,  0,  0},   // 545
    {  2,  3,  7, 13,  0,  0},   // 546
    {  0,  0,  0,  0,  0,  0},   // 547
    {  2,137,  0,  0,  0,  0},   // 548
    {  3, 61,  0,  0,  0,  0},   // 549
    {  2,  5, 11,  0,  0,  0},   // 550
    { 19, 29,  0,  0,  0,  0},   // 551
    {  2,  3, 23,  0,  0,  0},   // 552
    {  7, 79,  0,  0,  0,  0},   // 553
    {  2,277,  0,  0,  0,  0},   // 554
    {  3,  5, 37,  0,  0,  0},   // 555
    {  2,139,  0,  0,  0,  0},   // 556
    {  0,  0,  0,  0,  0,  0},   // 557
    {  2,  3, 31,  0,  0,  0},   // 558
    { 13, 43,  0,  0,  0,  0},   // 559
    {  2,  5,  7,  0,  0,  0},   // 560
    {  3, 11, 17,  0,  0,  0},   // 561
    {  2,281,  0,  0,  0,  0},   // 562
    {  0,  0,  0,  0,  0,  0},   // 563
    {  2,  3, 47,  0,  0,  0},   // 564
    {  5,113,  0,  0,  0,  0},   // 565
    {  2,283,  0,  0,  0,  0},   // 566
    {  3,  7,  0,  0,  0,  0},   // 567
    {  2, 71,  0,  0,  0,  0},   // 568
    {  0,  0,  0,  0,  0,  0},   // 569
    {  2,  3,  5, 19,  0,  0},   // 570
    {  0,  0,  0,  0,  0,  0},   // 571
    {  2, 11, 13,  0,  0,  0},   // 572
    {  3,191,  0,  0,  0,  0},   // 573
    {  2,  7, 41,  0,  0,  0},   // 574
    {  5, 23,  0,  0,  0,  0},   // 575
    {  2,  3,  0,  0,  0,  0},   // 576
    {  0,  0,  0,  0,  0,  0},   // 577
    {  2, 17,  0,  0,  0,  0},   // 578
    {  3,193,  0,  0,  0,  0},   // 579
    {  2,  5, 29,  0,  0,  0},   // 580
    {  7, 83,  0,  0,  0,  0},   // 581
    {  2,  3, 97,  0,  0,  0},   // 582
    { 11, 53,  0,  0,  0,  0},   // 583
    {  2, 73,  0,  0,  0,  0},   // 584
    {  3,  5, 13,  0,  0,  0},   // 585
    {  2,293,  0,  0,  0,  0},   // 586
    {  0,  0,  0,  0,  0,  0},   // 587
    {  2,  3,  7,  0,  0,  0},   // 588
    { 19, 31,  0,  0,  0,  0},   // 589
    {  2,  5, 59,  0,  0,  0},   // 590
    {  3,197,  0,  0,  0,  0},   // 591
    {  2, 37,  0,  0,  0,  0},   // 592
    {  0,  0,  0,  0,  0,  0},   // 593
    {  2,  3, 11,  0,  0,  0},   // 594
    {  5,  7, 17,  0,  0,  0},   // 595
    {  2,149,  0,  0,  0,  0},   // 596
    {  3,199,  0,  0,  0,  0},   // 597
    {  2, 13, 23,  0,  0,  0},   // 598
    {  0,  0,  0,  0,  0,  0},   // 599
    {  2,  3,  5,  0,  0,  0},   // 600
    {  0,  0,  0,  0,  0,  0},   // 601
    {  2,  7, 43,  0,  0,  0},   // 602
    {  3, 67,  0,  0,  0,  0},   // 603
    {  2,151,  0,  0,  0,  0},   // 604
    {  5, 11,  0,  0,  0,  0},   // 605
    {  2,  3,101,  0,  0,  0},   // 606
    {  0,  0,  0,  0,  0,  0},   // 607
    {  2, 19,  0,  0,  0,  0},   // 608
    {  3,  7, 29,  0,  0,  0},   // 609
    {  2,  5, 61,  0,  0,  0},   // 610
    { 13, 47,  0,  0,  0,  0},   // 611
    {  2,  3, 17,  0,  0,  0},   // 612
    {  0,  0,  0,  0,  0,  0},   // 613
    {  2,307,  0,  0,  0,  0},   // 614
    {  3,  5, 41,  0,  0,  0},   // 615
    {  2,  7, 11,  0,  0,  0},   // 616
    {  0,  0,  0,  0,  0,  0},   // 617
    {  2,  3,103,  0,  0,  0},   // 618
    {  0,  0,  0,  0,  0,  0},   // 619
    {  2,  5, 31,  0,  0,  0},   // 620
    {  3, 23,  0,  0,  0,  0},   // 621
    {  2,311,  0,  0,  0,  0},   // 622
    {  7, 89,  0,  0,  0,  0},   // 623
    {  2,  3, 13,  0,  0,  0},   // 624
    {  5,  0,  0,  0,  0,  0},   // 625
    {  2,313,  0,  0,  0,  0},   // 626
    {  3, 11, 19,  0,  0,  0},   // 627
    {  2,157,  0,  0,  0,  0},   // 628
    { 17, 37,  0,  0,  0,  0},   // 629
    {  2,  3,  5,  7,  0,  0},   // 630
    {  0,  0,  0,  0,  0,  0},   // 631
    {  2, 79,  0,  0,  0,  0},   // 632
    {  3,211,  0,  0,  0,  0},   // 633
    {  2,317,  0,  0,  0,  0},   // 634
    {  5,127,  0,  0,  0,  0},   // 635
    {  2,  3, 53,  0,  0,  0},   // 636
    {  7, 13,  0,  0,  0,  0},   // 637
    {  2, 11, 29,  0,  0,  0},   // 638
    {  3, 71,  0,  0,  0,  0},   // 639
    {  2,  5,  0,  0,  0,  0},   // 640
    {  0,  0,  0,  0,  0,  0},   // 641
    {  2,  3,107,  0,  0,  0},   // 642
    {  0,  0,  0,  0,  0,  0},   // 643
    {  2,  7, 23,  0,  0,  0},   // 644
    {  3,  5, 43,  0,  0,  0},   // 645
    {  2, 17, 19,  0,  0,  0},   // 646
    {  0,  0,  0,  0,  0,  0},   // 647
    {  2,  3,  0,  0,  0,  0},   // 648
    { 11, 59,  0,  0,  0,  0},   // 649
    {  2,  5, 13,  0,  0,  0},   // 650
    {  3,  7, 31,  0,  0,  0},   // 651
    {  2,163,  0,  0,  0,  0},   // 652
    {  0,  0,  0,  0,  0,  0},   // 653
    {  2,  3,109,  0,  0,  0},   // 654
    {  5,131,  0,  0,  0,  0},   // 655
    {  2, 41,  0,  0,  0,  0},   // 656
    {  3, 73,  0,  0,  0,  0},   // 657
    {  2,  7, 47,  0,  0,  0},   // 658
    {  0,  0,  0,  0,  0,  0},   // 659
    {  2,  3,  5, 11,  0,  0},   // 660
    {  0,  0,  0,  0,  0,  0},   // 661
    {  2,331,  0,  0,  0,  0},   // 662
    {  3, 13, 17,  0,  0,  0},   // 663
    {  2, 83,  0,  0,  0,  0},   // 664
    {  5,  7, 19,  0,  0,  0},   // 665
    {  2,  3, 37,  0,  0,  0},   // 666
    { 23, 29,  0,  0,  0,  0},   // 667
    {  2,167,  0,  0,  0,  0},   // 668
    {  3,223,  0,  0,  0,  0},   // 669
    {  2,  5, 67,  0,  0,  0},   // 670
    { 11, 61,  0,  0,  0,  0},   // 671
    {  2,  3,  7,  0,  0,  0},   // 672
    {  0,  0,  0,  0,  0,  0},   // 673
    {  2,337,  0,  0,  0,  0},   // 674
    {  3,  5,  0,  0,  0,  0},   // 675
    {  2, 13,  0,  0,  0,  0},   // 676
    {  0,  0,  0,  0,  0,  0},   // 677
    {  2,  3,113,  0,  0,  0},   // 678
    {  7, 97,  0,  0,  0,  0},   // 679
    {  2,  5, 17,  0,  0,  0},   // 680
    {  3,227,  0,  0,  0,  0},   // 681
    {  2, 11, 31,  0,  0,  0},   // 682
    {  0,  0,  0,  0,  0,  0},   // 683
    {  2,  3, 19,  0,  0,  0},   // 684
    {  5,137,  0,  0,  0,  0},   // 685
    {  2,  7,  0,  0,  0,  0},   // 686
    {  3,229,  0,  0,  0,  0},   // 687
    {  2, 43,  0,  0,  0,  0},   // 688
    { 13, 53,  0,  0,  0,  0},   // 689
    {  2,  3,  5, 23,  0,  0},   // 690
    {  0,  0,  0,  0,  0,  0},   // 691
    {  2,173,  0,  0,  0,  0},   // 692
    {  3,  7, 11,  0,  0,  0},   // 693
    {  2,347,  0,  0,  0,  0},   // 694
    {  5,139,  0,  0,  0,  0},   // 695
    {  2,  3, 29,  0,  0,  0},   // 696
    { 17, 41,  0,  0,  0,  0},   // 697
    {  2,349,  0,  0,  0,  0},   // 698
    {  3,233,  0,  0,  0,  0},   // 699
    {  2,  5,  7,  0,  0,  0},   // 700
    {  0,  0,  0,  0,  0,  0},   // 701
    {  2,  3, 13,  0,  0,  0},   // 702
    { 19, 37,  0,  0,  0,  0},   // 703
    {  2, 11,  0,  0,  0,  0},   // 704
    {  3,  5, 47,  0,  0,  0},   // 705
    {  2,353,  0,  0,  0,  0},   // 706
    {  7,101,  0,  0,  0,  0},   // 707
    {  2,  3, 59,  0,  0,  0},   // 708
    {  0,  0,  0,  0,  0,  0},   // 709
    {  2,  5, 71,  0,  0,  0},   // 710
    {  3, 79,  0,  0,  0,  0},   // 711
    {  2, 89,  0,  0,  0,  0},   // 712
    { 23, 31,  0,  0,  0,  0},   // 713
    {  2,  3,  7, 17,  0,  0},   // 714
    {  5, 11, 13,  0,  0,  0},   // 715
    {  2,179,  0,  0,  0,  0},   // 716
    {  3,239,  0,  0,  0,  0},   // 717
    {  2,359,  0,  0,  0,  0},   // 718
    {  0,  0,  0,  0,  0,  0},   // 719
    {  2,  3,  5,  0,  0,  0},   // 720
    {  7,103,  0,  0,  0,  0},   // 721
    {  2, 19,  0,  0,  0,  0},   // 722
    {  3,241,  0,  0,  0,  0},   // 723
    {  2,181,  0,  0,  0,  0},   // 724
    {  5, 29,  0,  0,  0,  0},   // 725
    {  2,  3, 11,  0,  0,  0},   // 726
    {  0,  0,  0,  0,  0,  0},   // 727
    {  2,  7, 13,  0,  0,  0},   // 728
    {  3,  0,  0,  0,  0,  0},   // 729
    {  2,  5, 73,  0,  0,  0},   // 730
    { 17, 43,  0,  0,  0,  0},   // 731
    {  2,  3, 61,  0,  0,  0},   // 732
    {  0,  0,  0,  0,  0,  0},   // 733
    {  2,367,  0,  0,  0,  0},   // 734
    {  3,  5,  7,  0,  0,  0},   // 735
    {  2, 23,  0,  0,  0,  0},   // 736
    { 11, 67,  0,  0,  0,  0},   // 737
    {  2,  3, 41,  0,  0,  0},   // 738
    {  0,  0,  0,  0,  0,  0},   // 739
    {  2,  5, 37,  0,  0,  0},   // 740
    {  3, 13, 19,  0,  0,  0},   // 741
    {  2,  7, 53,  0,  0,  0},   // 742
    {  0,  0,  0,  0,  0,  0},   // 743
    {  2,  3, 31,  0,  0,  0},   // 744
    {  5,149,  0,  0,  0,  0},   // 745
    {  2,373,  0,  0,  0,  0},   // 746
    {  3, 83,  0,  0,  0,  0},   // 747
    {  2, 11, 17,  0,  0,  0},   // 748
    {  7,107,  0,  0,  0,  0},   // 749
    {  2,  3,  5,  0,  0,  0},   // 750
    {  0,  0,  0,  0,  0,  0},   // 751
    {  2, 47,  0,  0,  0,  0},   // 752
    {  3,251,  0,  0,  0,  0},   // 753
    {  2, 13, 29,  0,  0,  0},   // 754
    {  5,151,  0,  0,  0,  0},   // 755
    {  2,  3,  7,  0,  0,  0},   // 756
    {  0,  0,  0,  0,  0,  0},   // 757
    {  2,379,  0,  0,  0,  0},   // 758
    {  3, 11, 23,  0,  0,  0},   // 759
    {  2,  5, 19,  0,  0,  0},   // 760
    {  0,  0,  0,  0,  0,  0},   // 761
    {  2,  3,127,  0,  0,  0},   // 762
    {  7,109,  0,  0,  0,  0},   // 763
    {  2,191,  0,  0,  0,  0},   // 764
    {  3,  5, 17,  0,  0,  0},   // 765
    {  2,383,  0,  0,  0,  0},   // 766
    { 13, 59,  0,  0,  0,  0},   // 767
    {  2,  3,  0,  0,  0,  0},   // 768
    {  0,  0,  0,  0,  0,  0},   // 769
    {  2,  5,  7, 11,  0,  0},   // 770
    {  3,257,  0,  0,  0,  0},   // 771
    {  2,193,  0,  0,  0,  0},   // 772
    {  0,  0,  0,  0,  0,  0},   // 773
    {  2,  3, 43,  0,  0,  0},   // 774
    {  5, 31,  0,  0,  0,  0},   // 775
    {  2, 97,  0,  0,  0,  0},   // 776
    {  3,  7, 37,  0,  0,  0},   // 777
    {  2,389,  0,  0,  0,  0},   // 778
    { 19, 41,  0,  0,  0,  0},   // 779
    {  2,  3,  5, 13,  0,  0},   // 780
    { 11, 71,  0,  0,  0,  0},   // 781
    {  2, 17, 23,  0,  0,  0},   // 782
    {  3, 29,  0,  0,  0,  0},   // 783
    {  2,  7,  0,  0,  0,  0},   // 784
    {  5,157,  0,  0,  0,  0},   // 785
    {  2,  3,131,  0,  0,  0},   // 786
    {  0,  0,  0,  0,  0,  0},   // 787
    {  2,197,  0,  0,  0,  0},   // 788
    {  3,263,  0,  0,  0,  0},   // 789
    {  2,  5, 79,  0,  0,  0},   // 790
    {  7,113,  0,  0,  0,  0},   // 791
    {  2,  3, 11,  0,  0,  0},   // 792
    { 13, 61,  0,  0,  0,  0},   // 793
    {  2,397,  0,  0,  0,  0},   // 794
    {  3,  5, 53,  0,  0,  0},   // 795
    {  2,199,  0,  0,  0,  0},   // 796
    {  0,  0,  0,  0,  0,  0},   // 797
    {  2,  3,  7, 19,  0,  0},   // 798
    { 17, 47,  0,  0,  0,  0},   // 799
    {  2,  5,  0,  0,  0,  0},   // 800
    {  3, 89,  0,  0,  0,  0},   // 801
    {  2,401,  0,  0,  0,  0},   // 802
    { 11, 73,  0,  0,  0,  0},   // 803
    {  2,  3, 67,  0,  0,  0},   // 804
    {  5,  7, 23,  0,  0,  0},   // 805
    {  2, 13, 31,  0,  0,  0},   // 806
    {  3,269,  0,  0,  0,  0},   // 807
    {  2,101,  0,  0,  0,  0},   // 808
    {  0,  0,  0,  0,  0,  0},   // 809
    {  2,  3,  5,  0,  0,  0},   // 810
    {  0,  0,  0,  0,  0,  0},   // 811
    {  2,  7, 29,  0,  0,  0},   // 812
    {  3,271,  0,  0,  0,  0},   // 813
    {  2, 11, 37,  0,  0,  0},   // 814
    {  5,163,  0,  0,  0,  0},   // 815
    {  2,  3, 17,  0,  0,  0},   // 816
    { 19, 43,  0,  0,  0,  0},   // 817
    {  2,409,  0,  0,  0,  0},   // 818
    {  3,  7, 13,  0,  0,  0},   // 819
    {  2,  5, 41,  0,  0,  0},   // 820
    {  0,  0,  0,  0,  0,  0},   // 821
    {  2,  3,137,  0,  0,  0},   // 822
    {  0,  0,  0,  0,  0,  0},   // 823
    {  2,103,  0,  0,  0,  0},   // 824
    {  3,  5, 11,  0,  0,  0},   // 825
    {  2,  7, 59,  0,  0,  0},   // 826
    {  0,  0,  0,  0,  0,  0},   // 827
    {  2,  3, 23,  0,  0,  0},   // 828
    {  0,  0,  0,  0,  0,  0},   // 829
    {  2,  5, 83,  0,  0,  0},   // 830
    {  3,277,  0,  0,  0,  0},   // 831
    {  2, 13,  0,  0,  0,  0},   // 832
    {  7, 17,  0,  0,  0,  0},   // 833
    {  2,  3,139,  0,  0,  0},   // 834
    {  5,167,  0,  0,  0,  0},   // 835
    {  2, 11, 19,  0,  0,  0},   // 836
    {  3, 31,  0,  0,  0,  0},   // 837
    {  2,419,  0,  0,  0,  0},   // 838
    {  0,  0,  0,  0,  0,  0},   // 839
    {  2,  3,  5,  7,  0,  0},   // 840
    { 29,  0,  0,  0,  0,  0},   // 841
    {  2,421,  0,  0,  0,  0},   // 842
    {  3,281,  0,  0,  0,  0},   // 843
    {  2,211,  0,  0,  0,  0},   // 844
    {  5, 13,  0,  0,  0,  0},   // 845
    {  2,  3, 47,  0,  0,  0},   // 846
    {  7, 11,  0,  0,  0,  0},   // 847
    {  2, 53,  0,  0,  0,  0},   // 848
    {  3,283,  0,  0,  0,  0},   // 849
    {  2,  5, 17,  0,  0,  0},   // 850
    { 23, 37,  0,  0,  0,  0},   // 851
    {  2,  3, 71,  0,  0,  0},   // 852
    {  0,  0,  0,  0,  0,  0},   // 853
    {  2,  7, 61,  0,  0,  0},   // 854
    {  3,  5, 19,  0,  0,  0},   // 855
    {  2,107,  0,  0,  0,  0},   // 856
    {  0,  0,  0,  0,  0,  0},   // 857
    {  2,  3, 11, 13,  0,  0},   // 858
    {  0,  0,  0,  0,  0,  0},   // 859
    {  2,  5, 43,  0,  0,  0},   // 860
    {  3,  7, 41,  0,  0,  0},   // 861
    {  2,431,  0,  0,  0,  0},   // 862
    {  0,  0,  0,  0,  0,  0},   // 863
    {  2,  3,  0,  0,  0,  0},   // 864
    {  5,173,  0,  0,  0,  0},   // 865
    {  2,433,  0,  0,  0,  0},   // 866
    {  3, 17,  0,  0,  0,  0},   // 867
    {  2,  7, 31,  0,  0,  0},   // 868
    { 11, 79,  0,  0,  0,  0},   // 869
    {  2,  3,  5, 29,  0,  0},   // 870
    { 13, 67,  0,  0,  0,  0},   // 871
    {  2,109,  0,  0,  0,  0},   // 872
    {  3, 97,  0,  0,  0,  0},   // 873
    {  2, 19, 23,  0,  0,  0},   // 874
    {  5,  7,  0,  0,  0,  0},   // 875
    {  2,  3, 73,  0,  0,  0},   // 876
    {  0,  0,  0,  0,  0,  0},   // 877
    {  2,439,  0,  0,  0,  0},   // 878
    {  3,293,  0,  0,  0,  0},   // 879
    {  2,  5, 11,  0,  0,  0},   // 880
    {  0,  0,  0,  0,  0,  0},   // 881
    {  2,  3,  7,  0,  0,  0},   // 882
    {  0,  0,  0,  0,  0,  0},   // 883
    {  2, 13, 17,  0,  0,  0},   // 884
    {  3,  5, 59,  0,  0,  0},   // 885
    {  2,443,  0,  0,  0,  0},   // 886
    {  0,  0,  0,  0,  0,  0},   // 887
    {  2,  3, 37,  0,  0,  0},   // 888
    {  7,127,  0,  0,  0,  0},   // 889
    {  2,  5, 89,  0,  0,  0},   // 890
    {  3, 11,  0,  0,  0,  0},   // 891
    {  2,223,  0,  0,  0,  0},   // 892
    { 19, 47,  0,  0,  0,  0},   // 893
    {  2,  3,149,  0,  0,  0},   // 894
    {  5,179,  0,  0,  0,  0},   // 895
    {  2,  7,  0,  0,  0,  0},   // 896
    {  3, 13, 23,  0,  0,  0},   // 897
    {  2,449,  0,  0,  0,  0},   // 898
    { 29, 31,  0,  0,  0,  0},   // 899
    {  2,  3,  5,  0,  0,  0},   // 900
    { 17, 53,  0,  0,  0,  0},   // 901
    {  2, 11, 41,  0,  0,  0},   // 902
    {  3,  7, 43,  0,  0,  0},   // 903
    {  2,113,  0,  0,  0,  0},   // 904
    {  5,181,  0,  0,  0,  0},   // 905
    {  2,  3,151,  0,  0,  0},   // 906
    {  0,  0,  0,  0,  0,  0},   // 907
    {  2,227,  0,  0,  0,  0},   // 908
    {  3,101,  0,  0,  0,  0},   // 909
    {  2,  5,  7, 13,  0,  0},   // 910
    {  0,  0,  0,  0,  0,  0},   // 911
    {  2,  3, 19,  0,  0,  0},   // 912
    { 11, 83,  0,  0,  0,  0},   // 913
    {  2,457,  0,  0,  0,  0},   // 914
    {  3,  5, 61,  0,  0,  0},   // 915
    {  2,229,  0,  0,  0,  0},   // 916
    {  7,131,  0,  0,  0,  0},   // 917
    {  2,  3, 17,  0,  0,  0},   // 918
    {  0,  0,  0,  0,  0,  0},   // 919
    {  2,  5, 23,  0,  0,  0},   // 920
    {  3,307,  0,  0,  0,  0},   // 921
    {  2,461,  0,  0,  0,  0},   // 922
    { 13, 71,  0,  0,  0,  0},   // 923
    {  2,  3,  7, 11,  0,  0},   // 924
    {  5, 37,  0,  0,  0,  0},   // 925
    {  2,463,  0,  0,  0,  0},   // 926
    {  3,103,  0,  0,  0,  0},   // 927
    {  2, 29,  0,  0,  0,  0},   // 928
    {  0,  0,  0,  0,  0,  0},   // 929
    {  2,  3,  5, 31,  0,  0},   // 930
    {  7, 19,  0,  0,  0,  0},   // 931
    {  2,233,  0,  0,  0,  0},   // 932
    {  3,311,  0,  0,  0,  0},   // 933
    {  2,467,  0,  0,  0,  0},   // 934
    {  5, 11, 17,  0,  0,  0},   // 935
    {  2,  3, 13,  0,  0,  0},   // 936
    {  0,  0,  0,  0,  0,  0},   // 937
    {  2,  7, 67,  0,  0,  0},   // 938
    {  3,313,  0,  0,  0,  0},   // 939
    {  2,  5, 47,  0,  0,  0},   // 940
    {  0,  0,  0,  0,  0,  0},   // 941
    {  2,  3,157,  0,  0,  0},   // 942
    { 23, 41,  0,  0,  0,  0},   // 943
    {  2, 59,  0,  0,  0,  0},   // 944
    {  3,  5,  7,  0,  0,  0},   // 945
    {  2, 11, 43,  0,  0,  0},   // 946
    {  0,  0,  0,  0,  0,  0},   // 947
    {  2,  3, 79,  0,  0,  0},   // 948
    { 13, 73,  0,  0,  0,  0},   // 949
    {  2,  5, 19,  0,  0,  0},   // 950
    {  3,317,  0,  0,  0,  0},   // 951
    {  2,  7, 17,  0,  0,  0},   // 952
    {  0,  0,  0,  0,  0,  0},   // 953
    {  2,  3, 53,  0,  0,  0},   // 954
    {  5,191,  0,  0,  0,  0},   // 955
    {  2,239,  0,  0,  0,  0},   // 956
    {  3, 11, 29,  0,  0,  0},   // 957
    {  2,479,  0,  0,  0,  0},   // 958
    {  7,137,  0,  0,  0,  0},   // 959
    {  2,  3,  5,  0,  0,  0},   // 960
    { 31,  0,  0,  0,  0,  0},   // 961
    {  2, 13, 37,  0,  0,  0},   // 962
    {  3,107,  0,  0,  0,  0},   // 963
    {  2,241,  0,  0,  0,  0},   // 964
    {  5,193,  0,  0,  0,  0},   // 965
    {  2,  3,  7, 23,  0,  0},   // 966
    {  0,  0,  0,  0,  0,  0},   // 967
    {  2, 11,  0,  0,  0,  0},   // 968
    {  3, 17, 19,  0,  0,  0},   // 969
    {  2,  5, 97,  0,  0,  0},   // 970
    {  0,  0,  0,  0,  0,  0},   // 971
    {  2,  3,  0,  0,  0,  0},   // 972
    {  7,139,  0,  0,  0,  0},   // 973
    {  2,487,  0,  0,  0,  0},   // 974
    {  3,  5, 13,  0,  0,  0},   // 975
    {  2, 61,  0,  0,  0,  0},   // 976
    {  0,  0,  0,  0,  0,  0},   // 977
    {  2,  3,163,  0,  0,  0},   // 978
    { 11, 89,  0,  0,  0,  0},   // 979
    {  2,  5,  7,  0,  0,  0},   // 980
    {  3,109,  0,  0,  0,  0},   // 981
    {  2,491,  0,  0,  0,  0},   // 982
    {  0,  0,  0,  0,  0,  0},   // 983
    {  2,  3, 41,  0,  0,  0},   // 984
    {  5,197,  0,  0,  0,  0},   // 985
    {  2, 17, 29,  0,  0,  0},   // 986
    {  3,  7, 47,  0,  0,  0},   // 987
    {  2, 13, 19,  0,  0,  0},   // 988
    { 23, 43,  0,  0,  0,  0},   // 989
    {  2,  3,  5, 11,  0,  0},   // 990
    {  0,  0,  0,  0,  0,  0},   // 991
    {  2, 31,  0,  0,  0,  0},   // 992
    {  3,331,  0,  0,  0,  0},   // 993
    {  2,  7, 71,  0,  0,  0},   // 994
    {  5,199,  0,  0,  0,  0},   // 995
    {  2,  3, 83,  0,  0,  0},   // 996
    {  0,  0,  0,  0,  0,  0},   // 997
    {  2,499,  0,  0,  0,  0},   // 998
    {  3, 37,  0,  0,  0,  0},   // 999
    {  2,  5,  0,  0,  0,  0},   // 1000
    {  7, 11, 13,  0,  0,  0},   // 1001
    {  2,  3,167,  0,  0,  0},   // 1002
    { 17, 59,  0,  0,  0,  0},   // 1003
    {  2,251,  0,  0,  0,  0},   // 1004
    {  3,  5, 67,  0,  0,  0},   // 1005
    {  2,503,  0,  0,  0,  0},   // 1006
    { 19, 53,  0,  0,  0,  0},   // 1007
    {  2,  3,  7,  0,  0,  0},   // 1008
    {  0,  0,  0,  0,  0,  0},   // 1009
    {  2,  5,101,  0,  0,  0},   // 1010
    {  3,337,  0,  0,  0,  0},   // 1011
    {  2, 11, 23,  0,  0,  0},   // 1012
    {  0,  0,  0,  0,  0,  0},   // 1013
    {  2,  3, 13,  0,  0,  0},   // 1014
    {  5,  7, 29,  0,  0,  0},   // 1015
    {  2,127,  0,  0,  0,  0},   // 1016
    {  3,113,  0,  0,  0,  0},   // 1017
    {  2,509,  0,  0,  0,  0},   // 1018
    {  0,  0,  0,  0,  0,  0},   // 1019
    {  2,  3,  5, 17,  0,  0},   // 1020
    {  0,  0,  0,  0,  0,  0},   // 1021
    {  2,  7, 73,  0,  0,  0},   // 1022
    {  3, 11, 31,  0,  0,  0},   // 1023
    {  2,  0,  0,  0,  0,  0},   // 1024
    {  5, 41,  0,  0,  0,  0},   // 1025
    {  2,  3, 19,  0,  0,  0},   // 1026
    { 13, 79,  0,  0,  0,  0},   // 1027
    {  2,257,  0,  0,  0,  0},   // 1028
    {  3,  7,  0,  0,  0,  0},   // 1029
    {  2,  5,103,  0,  0,  0},   // 1030
    {  0,  0,  0,  0,  0,  0},   // 1031
    {  2,  3, 43,  0,  0,  0},   // 1032
    {  0,  0,  0,  0,  0,  0},   // 1033
    {  2, 11, 47,  0,  0,  0},   // 1034
    {  3,  5, 23,  0,  0,  0},   // 1035
    {  2,  7, 37,  0,  0,  0},   // 1036
    { 17, 61,  0,  0,  0,  0},   // 1037
    {  2,  3,173,  0,  0,  0},   // 1038
    {  0,  0,  0,  0,  0,  0},   // 1039
    {  2,  5, 13,  0,  0,  0},   // 1040
    {  3,347,  0,  0,  0,  0},   // 1041
    {  2,521,  0,  0,  0,  0},   // 1042
    {  7,149,  0,  0,  0,  0},   // 1043
    {  2,  3, 29,  0,  0,  0},   // 1044
    {  5, 11, 19,  0,  0,  0},   // 1045
    {  2,523,  0,  0,  0,  0},   // 1046
    {  3,349,  0,  0,  0,  0},   // 1047
    {  2,131,  0,  0,  0,  0},   // 1048
    {  0,  0,  0,  0,  0,  0},   // 1049
    {  2,  3,  5,  7,  0,  0},   // 1050
    {  0,  0,  0,  0,  0,  0},   // 1051
    {  2,263,  0,  0,  0,  0},   // 1052
    {  3, 13,  0,  0,  0,  0},   // 1053
    {  2, 17, 31,  0,  0,  0},   // 1054
    {  5,211,  0,  0,  0,  0},   // 1055
    {  2,  3, 11,  0,  0,  0},   // 1056
    {  7,151,  0,  0,  0,  0},   // 1057
    {  2, 23,  0,  0,  0,  0},   // 1058
    {  3,353,  0,  0,  0,  0},   // 1059
    {  2,  5, 53,  0,  0,  0},   // 1060
    {  0,  0,  0,  0,  0,  0},   // 1061
    {  2,  3, 59,  0,  0,  0},   // 1062
    {  0,  0,  0,  0,  0,  0},   // 1063
    {  2,  7, 19,  0,  0,  0},   // 1064
    {  3,  5, 71,  0,  0,  0},   // 1065
    {  2, 13, 41,  0,  0,  0},   // 1066
    { 11, 97,  0,  0,  0,  0},   // 1067
    {  2,  3, 89,  0,  0,  0},   // 1068
    {  0,  0,  0,  0,  0,  0},   // 1069
    {  2,  5,107,  0,  0,  0},   // 1070
    {  3,  7, 17,  0,  0,  0},   // 1071
    {  2, 67,  0,  0,  0,  0},   // 1072
    { 29, 37,  0,  0,  0,  0},   // 1073
    {  2,  3,179,  0,  0,  0},   // 1074
    {  5, 43,  0,  0,  0,  0},   // 1075
    {  2,269,  0,  0,  0,  0},   // 1076
    {  3,359,  0,  0,  0,  0},   // 1077
    {  2,  7, 11,  0,  0,  0},   // 1078
    { 13, 83,  0,  0,  0,  0},   // 1079
    {  2,  3,  5,  0,  0,  0},   // 1080
    { 23, 47,  0,  0,  0,  0},   // 1081
    {  2,541,  0,  0,  0,  0},   // 1082
    {  3, 19,  0,  0,  0,  0},   // 1083
    {  2,271,  0,  0,  0,  0},   // 1084
    {  5,  7, 31,  0,  0,  0},   // 1085
    {  2,  3,181,  0,  0,  0},   // 1086
    {  0,  0,  0,  0,  0,  0},   // 1087
    {  2, 17,  0,  0,  0,  0},   // 1088
    {  3, 11,  0,  0,  0,  0},   // 1089
    {  2,  5,109,  0,  0,  0},   // 1090
    {  0,  0,  0,  0,  0,  0},   // 1091
    {  2,  3,  7, 13,  0,  0},   // 1092
    {  0,  0,  0,  0,  0,  0},   // 1093
    {  2,547,  0,  0,  0,  0},   // 1094
    {  3,  5, 73,  0,  0,  0},   // 1095
    {  2,137,  0,  0,  0,  0},   // 1096
    {  0,  0,  0,  0,  0,  0},   // 1097
    {  2,  3, 61,  0,  0,  0},   // 1098
    {  7,157,  0,  0,  0,  0},   // 1099
    {  2,  5, 11,  0,  0,  0},   // 1100
    {  3,367,  0,  0,  0,  0},   // 1101
    {  2, 19, 29,  0,  0,  0},   // 1102
    {  0,  0,  0,  0,  0,  0},   // 1103
    {  2,  3, 23,  0,  0,  0},   // 1104
    {  5, 13, 17,  0,  0,  0},   // 1105
    {  2,  7, 79,  0,  0,  0},   // 1106
    {  3, 41,  0,  0,  0,  0},   // 1107
    {  2,277,  0,  0,  0,  0},   // 1108
    {  0,  0,  0,  0,  0,  0},   // 1109
    {  2,  3,  5, 37,  0,  0},   // 1110
    { 11,101,  0,  0,  0,  0},   // 1111
    {  2,139,  0,  0,  0,  0},   // 1112
    {  3,  7, 53,  0,  0,  0},   // 1113
    {  2,557,  0,  0,  0,  0},   // 1114
    {  5,223,  0,  0,  0,  0},   // 1115
    {  2,  3, 31,  0,  0,  0},   // 1116
    {  0,  0,  0,  0,  0,  0},   // 1117
    {  2, 13, 43,  0,  0,  0},   // 1118
    {  3,373,  0,  0,  0,  0},   // 1119
    {  2,  5,  7,  0,  0,  0},   // 1120
    { 19, 59,  0,  0,  0,  0},   // 1121
    {  2,  3, 11, 17,  0,  0},   // 1122
    {  0,  0,  0,  0,  0,  0},   // 1123
    {  2,281,  0,  0,  0,  0},   // 1124
    {  3,  5,  0,  0,  0,  0},   // 1125
    {  2,563,  0,  0,  0,  0},   // 1126
    {  7, 23,  0,  0,  0,  0},   // 1127
    {  2,  3, 47,  0,  0,  0},   // 1128
    {  0,  0,  0,  0,  0,  0},   // 1129
    {  2,  5,113,  0,  0,  0},   // 1130
    {  3, 13, 29,  0,  0,  0},   // 1131
    {  2,283,  0,  0,  0,  0},   // 1132
    { 11,103,  0,  0,  0,  0},   // 1133
    {  2,  3,  7,  0,  0,  0},   // 1134
    {  5,227,  0,  0,  0,  0},   // 1135
    {  2, 71,  0,  0,  0,  0},   // 1136
    {  3,379,  0,  0,  0,  0},   // 1137
    {  2,569,  0,  0,  0,  0},   // 1138
    { 17, 67,  0,  0,  0,  0},   // 1139
    {  2,  3,  5, 19,  0,  0},   // 1140
    {  7,163,  0,  0,  0,  0},   // 1141
    {  2,571,  0,  0,  0,  0},   // 1142
    {  3,127,  0,  0,  0,  0},   // 1143
    {  2, 11, 13,  0,  0,  0},   // 1144
    {  5,229,  0,  0,  0,  0},   // 1145
    {  2,  3,191,  0,  0,  0},   // 1146
    { 31, 37,  0,  0,  0,  0},   // 1147
    {  2,  7, 41,  0,  0,  0},   // 1148
    {  3,383,  0,  0,  0,  0},   // 1149
    {  2,  5, 23,  0,  0,  0},   // 1150
    {  0,  0,  0,  0,  0,  0},   // 1151
    {  2,  3,  0,  0,  0,  0},   // 1152
    {  0,  0,  0,  0,  0,  0},   // 1153
    {  2,577,  0,  0,  0,  0},   // 1154
    {  3,  5,  7, 11,  0,  0},   // 1155
    {  2, 17,  0,  0,  0,  0},   // 1156
    { 13, 89,  0,  0,  0,  0},   // 1157
    {  2,  3,193,  0,  0,  0},   // 1158
    { 19, 61,  0,  0,  0,  0},   // 1159
    {  2,  5, 29,  0,  0,  0},   // 1160
    {  3, 43,  0,  0,  0,  0},   // 1161
    {  2,  7, 83,  0,  0,  0},   // 1162
    {  0,  0,  0,  0,  0,  0},   // 1163
    {  2,  3, 97,  0,  0,  0},   // 1164
    {  5,233,  0,  0,  0,  0},   // 1165
    {  2, 11, 53,  0,  0,  0},   // 1166
    {  3,389,  0,  0,  0,  0},   // 1167
    {  2, 73,  0,  0,  0,  0},   // 1168
    {  7,167,  0,  0,  0,  0},   // 1169
    {  2,  3,  5, 13,  0,  0},   // 1170
    {  0,  0,  0,  0,  0,  0},   // 1171
    {  2,293,  0,  0,  0,  0},   // 1172
    {  3, 17, 23,  0,  0,  0},   // 1173
    {  2,587,  0,  0,  0,  0},   // 1174
    {  5, 47,  0,  0,  0,  0},   // 1175
    {  2,  3,  7,  0,  0,  0},   // 1176
    { 11,107,  0,  0,  0,  0},   // 1177
    {  2, 19, 31,  0,  0,  0},   // 1178
    {  3,131,  0,  0,  0,  0},   // 1179
    {  2,  5, 59,  0,  0,  0},   // 1180
    {  0,  0,  0,  0,  0,  0},   // 1181
    {  2,  3,197,  0,  0,  0},   // 1182
    {  7, 13,  0,  0,  0,  0},   // 1183
    {  2, 37,  0,  0,  0,  0},   // 1184
    {  3,  5, 79,  0,  0,  0},   // 1185
    {  2,593,  0,  0,  0,  0},   // 1186
    {  0,  0,  0,  0,  0,  0},   // 1187
    {  2,  3, 11,  0,  0,  0},   // 1188
    { 29, 41,  0,  0,  0,  0},   // 1189
    {  2,  5,  7, 17,  0,  0},   // 1190
    {  3,397,  0,  0,  0,  0},   // 1191
    {  2,149,  0,  0,  0,  0},   // 1192
    {  0,  0,  0,  0,  0,  0},   // 1193
    {  2,  3,199,  0,  0,  0},   // 1194
    {  5,239,  0,  0,  0,  0},   // 1195
    {  2, 13, 23,  0,  0,  0},   // 1196
    {  3,  7, 19,  0,  0,  0},   // 1197
    {  2,599,  0,  0,  0,  0},   // 1198
    { 11,109,  0,  0,  0,  0},   // 1199
    {  2,  3,  5,  0,  0,  0},   // 1200
    {  0,  0,  0,  0,  0,  0},   // 1201
    {  2,601,  0,  0,  0,  0},   // 1202
    {  3,401,  0,  0,  0,  0},   // 1203
    {  2,  7, 43,  0,  0,  0},   // 1204
    {  5,241,  0,  0,  0,  0},   // 1205
    {  2,  3, 67,  0,  0,  0},   // 1206
    { 17, 71,  0,  0,  0,  0},   // 1207
    {  2,151,  0,  0,  0,  0},   // 1208
    {  3, 13, 31,  0,  0,  0},   // 1209
    {  2,  5, 11,  0,  0,  0},   // 1210
    {  7,173,  0,  0,  0,  0},   // 1211
    {  2,  3,101,  0,  0,  0},   // 1212
    {  0,  0,  0,  0,  0,  0},   // 1213
    {  2,607,  0,  0,  0,  0},   // 1214
    {  3,  5,  0,  0,  0,  0},   // 1215
    {  2, 19,  0,  0,  0,  0},   // 1216
    {  0,  0,  0,  0,  0,  0},   // 1217
    {  2,  3,  7, 29,  0,  0},   // 1218
    { 23, 53,  0,  0,  0,  0},   // 1219
    {  2,  5, 61,  0,  0,  0},   // 1220
    {  3, 11, 37,  0,  0,  0},   // 1221
    {  2, 13, 47,  0,  0,  0},   // 1222
    {  0,  0,  0,  0,  0,  0},   // 1223
    {  2,  3, 17,  0,  0,  0},   // 1224
    {  5,  7,  0,  0,  0,  0},   // 1225
    {  2,613,  0,  0,  0,  0},   // 1226
    {  3,409,  0,  0,  0,  0},   // 1227
    {  2,307,  0,  0,  0,  0},   // 1228
    {  0,  0,  0,  0,  0,  0},   // 1229
    {  2,  3,  5, 41,  0,  0},   // 1230
    {  0,  0,  0,  0,  0,  0},   // 1231
    {  2,  7, 11,  0,  0,  0},   // 1232
    {  3,137,  0,  0,  0,  0},   // 1233
    {  2,617,  0,  0,  0,  0},   // 1234
    {  5, 13, 19,  0,  0,  0},   // 1235
    {  2,  3,103,  0,  0,  0},   // 1236
    {  0,  0,  0,  0,  0,  0},   // 1237
    {  2,619,  0,  0,  0,  0},   // 1238
    {  3,  7, 59,  0,  0,  0},   // 1239
    {  2,  5, 31,  0,  0,  0},   // 1240
    { 17, 73,  0,  0,  0,  0},   // 1241
    {  2,  3, 23,  0,  0,  0},   // 1242
    { 11,113,  0,  0,  0,  0},   // 1243
    {  2,311,  0,  0,  0,  0},   // 1244
    {  3,  5, 83,  0,  0,  0},   // 1245
    {  2,  7, 89,  0,  0,  0},   // 1246
    { 29, 43,  0,  0,  0,  0},   // 1247
    {  2,  3, 13,  0,  0,  0},   // 1248
    {  0,  0,  0,  0,  0,  0},   // 1249
    {  2,  5,  0,  0,  0,  0},   // 1250
    {  3,139,  0,  0,  0,  0},   // 1251
    {  2,313,  0,  0,  0,  0},   // 1252
    {  7,179,  0,  0,  0,  0},   // 1253
    {  2,  3, 11, 19,  0,  0},   // 1254
    {  5,251,  0,  0,  0,  0},   // 1255
    {  2,157,  0,  0,  0,  0},   // 1256
    {  3,419,  0,  0,  0,  0},   // 1257
    {  2, 17, 37,  0,  0,  0},   // 1258
    {  0,  0,  0,  0,  0,  0},   // 1259
    {  2,  3,  5,  7,  0,  0},   // 1260
    { 13, 97,  0,  0,  0,  0},   // 1261
    {  2,631,  0,  0,  0,  0},   // 1262
    {  3,421,  0,  0,  0,  0},   // 1263
    {  2, 79,  0,  0,  0,  0},   // 1264
    {  5, 11, 23,  0,  0,  0},   // 1265
    {  2,  3,211,  0,  0,  0},   // 1266
    {  7,181,  0,  0,  0,  0},   // 1267
    {  2,317,  0,  0,  0,  0},   // 1268
    {  3, 47,  0,  0,  0,  0},   // 1269
    {  2,  5,127,  0,  0,  0},   // 1270
    { 31, 41,  0,  0,  0,  0},   // 1271
    {  2,  3, 53,  0,  0,  0},   // 1272
    { 19, 67,  0,  0,  0,  0},   // 1273
    {  2,  7, 13,  0,  0,  0},   // 1274
    {  3,  5, 17,  0,  0,  0},   // 1275
    {  2, 11, 29,  0,  0,  0},   // 1276
    {  0,  0,  0,  0,  0,  0},   // 1277
    {  2,  3, 71,  0,  0,  0},   // 1278
    {  0,  0,  0,  0,  0,  0},   // 1279
    {  2,  5,  0,  0,  0,  0},   // 1280
    {  3,  7, 61,  0,  0,  0},   // 1281
    {  2,641,  0,  0,  0,  0},   // 1282
    {  0,  0,  0,  0,  0,  0},   // 1283
    {  2,  3,107,  0,  0,  0},   // 1284
    {  5,257,  0,  0,  0,  0},   // 1285
    {  2,643,  0,  0,  0,  0},   // 1286
    {  3, 11, 13,  0,  0,  0},   // 1287
    {  2,  7, 23,  0,  0,  0},   // 1288
    {  0,  0,  0,  0,  0,  0},   // 1289
    {  2,  3,  5, 43,  0,  0},   // 1290
    {  0,  0,  0,  0,  0,  0},   // 1291
    {  2, 17, 19,  0,  0,  0},   // 1292
    {  3,431,  0,  0,  0,  0},   // 1293
    {  2,647,  0,  0,  0,  0},   // 1294
    {  5,  7, 37,  0,  0,  0},   // 1295
    {  2,  3,  0,  0,  0,  0},   // 1296
    {  0,  0,  0,  0,  0,  0},   // 1297
    {  2, 11, 59,  0,  0,  0},   // 1298
    {  3,433,  0,  0,  0,  0},   // 1299
    {  2,  5, 13,  0,  0,  0},   // 1300
    {  0,  0,  0,  0,  0,  0},   // 1301
    {  2,  3,  7, 31,  0,  0},   // 1302
    {  0,  0,  0,  0,  0,  0},   // 1303
    {  2,163,  0,  0,  0,  0},   // 1304
    {  3,  5, 29,  0,  0,  0},   // 1305
    {  2,653,  0,  0,  0,  0},   // 1306
    {  0,  0,  0,  0,  0,  0},   // 1307
    {  2,  3,109,  0,  0,  0},   // 1308
    {  7, 11, 17,  0,  0,  0},   // 1309
    {  2,  5,131,  0,  0,  0},   // 1310
    {  3, 19, 23,  0,  0,  0},   // 1311
    {  2, 41,  0,  0,  0,  0},   // 1312
    { 13,101,  0,  0,  0,  0},   // 1313
    {  2,  3, 73,  0,  0,  0},   // 1314
    {  5,263,  0,  0,  0,  0},   // 1315
    {  2,  7, 47,  0,  0,  0},   // 1316
    {  3,439,  0,  0,  0,  0},   // 1317
    {  2,659,  0,  0,  0,  0},   // 1318
    {  0,  0,  0,  0,  0,  0},   // 1319
    {  2,  3,  5, 11,  0,  0},   // 1320
    {  0,  0,  0,  0,  0,  0},   // 1321
    {  2,661,  0,  0,  0,  0},   // 1322
    {  3,  7,  0,  0,  0,  0},   // 1323
    {  2,331,  0,  0,  0,  0},   // 1324
    {  5, 53,  0,  0,  0,  0},   // 1325
    {  2,  3, 13, 17,  0,  0},   // 1326
    {  0,  0,  0,  0,  0,  0},   // 1327
    {  2, 83,  0,  0,  0,  0},   // 1328
    {  3,443,  0,  0,  0,  0},   // 1329
    {  2,  5,  7, 19,  0,  0},   // 1330
    { 11,  0,  0,  0,  0,  0},   // 1331
    {  2,  3, 37,  0,  0,  0},   // 1332
    { 31, 43,  0,  0,  0,  0},   // 1333
    {  2, 23, 29,  0,  0,  0},   // 1334
    {  3,  5, 89,  0,  0,  0},   // 1335
    {  2,167,  0,  0,  0,  0},   // 1336
    {  7,191,  0,  0,  0,  0},   // 1337
    {  2,  3,223,  0,  0,  0},   // 1338
    { 13,103,  0,  0,  0,  0},   // 1339
    {  2,  5, 67,  0,  0,  0},   // 1340
    {  3,149,  0,  0,  0,  0},   // 1341
    {  2, 11, 61,  0,  0,  0},   // 1342
    { 17, 79,  0,  0,  0,  0},   // 1343
    {  2,  3,  7,  0,  0,  0},   // 1344
    {  5,269,  0,  0,  0,  0},   // 1345
    {  2,673,  0,  0,  0,  0},   // 1346
    {  3,449,  0,  0,  0,  0},   // 1347
    {  2,337,  0,  0,  0,  0},   // 1348
    { 19, 71,  0,  0,  0,  0},   // 1349
    {  2,  3,  5,  0,  0,  0},   // 1350
    {  7,193,  0,  0,  0,  0},   // 1351
    {  2, 13,  0,  0,  0,  0},   // 1352
    {  3, 11, 41,  0,  0,  0},   // 1353
    {  2,677,  0,  0,  0,  0},   // 1354
    {  5,271,  0,  0,  0,  0},   // 1355
    {  2,  3,113,  0,  0,  0},   // 1356
    { 23, 59,  0,  0,  0,  0},   // 1357
    {  2,  7, 97,  0,  0,  0},   // 1358
    {  3,151,  0,  0,  0,  0},   // 1359
    {  2,  5, 17,  0,  0,  0},   // 1360
    {  0,  0,  0,  0,  0,  0},   // 1361
    {  2,  3,227,  0,  0,  0},   // 1362
    { 29, 47,  0,  0,  0,  0},   // 1363
    {  2, 11, 31,  0,  0,  0},   // 1364
    {  3,  5,  7, 13,  0,  0},   // 1365
    {  2,683,  0,  0,  0,  0},   // 1366
    {  0,  0,  0,  0,  0,  0},   // 1367
    {  2,  3, 19,  0,  0,  0},   // 1368
    { 37,  0,  0,  0,  0,  0},   // 1369
    {  2,  5,137,  0,  0,  0},   // 1370
    {  3,457,  0,  0,  0,  0},   // 1371
    {  2,  7,  0,  0,  0,  0},   // 1372
    {  0,  0,  0,  0,  0,  0},   // 1373
    {  2,  3,229,  0,  0,  0},   // 1374
    {  5, 11,  0,  0,  0,  0},   // 1375
    {  2, 43,  0,  0,  0,  0},   // 1376
    {  3, 17,  0,  0,  0,  0},   // 1377
    {  2, 13, 53,  0,  0,  0},   // 1378
    {  7,197,  0,  0,  0,  0},   // 1379
    {  2,  3,  5, 23,  0,  0},   // 1380
    {  0,  0,  0,  0,  0,  0},   // 1381
    {  2,691,  0,  0,  0,  0},   // 1382
    {  3,461,  0,  0,  0,  0},   // 1383
    {  2,173,  0,  0,  0,  0},   // 1384
    {  5,277,  0,  0,  0,  0},   // 1385
    {  2,  3,  7, 11,  0,  0},   // 1386
    { 19, 73,  0,  0,  0,  0},   // 1387
    {  2,347,  0,  0,  0,  0},   // 1388
    {  3,463,  0,  0,  0,  0},   // 1389
    {  2,  5,139,  0,  0,  0},   // 1390
    { 13,107,  0,  0,  0,  0},   // 1391
    {  2,  3, 29,  0,  0,  0},   // 1392
    {  7,199,  0,  0,  0,  0},   // 1393
    {  2, 17, 41,  0,  0,  0},   // 1394
    {  3,  5, 31,  0,  0,  0},   // 1395
    {  2,349,  0,  0,  0,  0},   // 1396
    { 11,127,  0,  0,  0,  0},   // 1397
    {  2,  3,233,  0,  0,  0},   // 1398
    {  0,  0,  0,  0,  0,  0},   // 1399
    {  2,  5,  7,  0,  0,  0},   // 1400
    {  3,467,  0,  0,  0,  0},   // 1401
    {  2,701,  0,  0,  0,  0},   // 1402
    { 23, 61,  0,  0,  0,  0},   // 1403
    {  2,  3, 13,  0,  0,  0},   // 1404
    {  5,281,  0,  0,  0,  0},   // 1405
    {  2, 19, 37,  0,  0,  0},   // 1406
    {  3,  7, 67,  0,  0,  0},   // 1407
    {  2, 11,  0,  0,  0,  0},   // 1408
    {  0,  0,  0,  0,  0,  0},   // 1409
    {  2,  3,  5, 47,  0,  0},   // 1410
    { 17, 83,  0,  0,  0,  0},   // 1411
    {  2,353,  0,  0,  0,  0},   // 1412
    {  3,157,  0,  0,  0,  0},   // 1413
    {  2,  7,101,  0,  0,  0},   // 1414
    {  5,283,  0,  0,  0,  0},   // 1415
    {  2,  3, 59,  0,  0,  0},   // 1416
    { 13,109,  0,  0,  0,  0},   // 1417
    {  2,709,  0,  0,  0,  0},   // 1418
    {  3, 11, 43,  0,  0,  0},   // 1419
    {  2,  5, 71,  0,  0,  0},   // 1420
    {  7, 29,  0,  0,  0,  0},   // 1421
    {  2,  3, 79,  0,  0,  0},   // 1422
    {  0,  0,  0,  0,  0,  0},   // 1423
    {  2, 89,  0,  0,  0,  0},   // 1424
    {  3,  5, 19,  0,  0,  0},   // 1425
    {  2, 23, 31,  0,  0,  0},   // 1426
    {  0,  0,  0,  0,  0,  0},   // 1427
    {  2,  3,  7, 17,  0,  0},   // 1428
    {  0,  0,  0,  0,  0,  0},   // 1429
    {  2,  5, 11, 13,  0,  0},   // 1430
    {  3, 53,  0,  0,  0,  0},   // 1431
    {  2,179,  0,  0,  0,  0},   // 1432
    {  0,  0,  0,  0,  0,  0},   // 1433
    {  2,  3,239,  0,  0,  0},   // 1434
    {  5,  7, 41,  0,  0,  0},   // 1435
    {  2,359,  0,  0,  0,  0},   // 1436
    {  3,479,  0,  0,  0,  0},   // 1437
    {  2,719,  0,  0,  0,  0},   // 1438
    {  0,  0,  0,  0,  0,  0},   // 1439
    {  2,  3,  5,  0,  0,  0},   // 1440
    { 11,131,  0,  0,  0,  0},   // 1441
    {  2,  7,103,  0,  0,  0},   // 1442
    {  3, 13, 37,  0,  0,  0},   // 1443
    {  2, 19,  0,  0,  0,  0},   // 1444
    {  5, 17,  0,  0,  0,  0},   // 1445
    {  2,  3,241,  0,  0,  0},   // 1446
    {  0,  0,  0,  0,  0,  0},   // 1447
    {  2,181,  0,  0,  0,  0},   // 1448
    {  3,  7, 23,  0,  0,  0},   // 1449
    {  2,  5, 29,  0,  0,  0},   // 1450
    {  0,  0,  0,  0,  0,  0},   // 1451
    {  2,  3, 11,  0,  0,  0},   // 1452
    {  0,  0,  0,  0,  0,  0},   // 1453
    {  2,727,  0,  0,  0,  0},   // 1454
    {  3,  5, 97,  0,  0,  0},   // 1455
    {  2,  7, 13,  0,  0,  0},   // 1456
    { 31, 47,  0,  0,  0,  0},   // 1457
    {  2,  3,  0,  0,  0,  0},   // 1458
    {  0,  0,  0,  0,  0,  0},   // 1459
    {  2,  5, 73,  0,  0,  0},   // 1460
    {  3,487,  0,  0,  0,  0},   // 1461
    {  2, 17, 43,  0,  0,  0},   // 1462
    {  7, 11, 19,  0,  0,  0},   // 1463
    {  2,  3, 61,  0,  0,  0},   // 1464
    {  5,293,  0,  0,  0,  0},   // 1465
    {  2,733,  0,  0,  0,  0},   // 1466
    {  3,163,  0,  0,  0,  0},   // 1467
    {  2,367,  0,  0,  0,  0},   // 1468
    { 13,113,  0,  0,  0,  0},   // 1469
    {  2,  3,  5,  7,  0,  0},   // 1470
    {  0,  0,  0,  0,  0,  0},   // 1471
    {  2, 23,  0,  0,  0,  0},   // 1472
    {  3,491,  0,  0,  0,  0},   // 1473
    {  2, 11, 67,  0,  0,  0},   // 1474
    {  5, 59,  0,  0,  0,  0},   // 1475
    {  2,  3, 41,  0,  0,  0},   // 1476
    {  7,211,  0,  0,  0,  0},   // 1477
    {  2,739,  0,  0,  0,  0},   // 1478
    {  3, 17, 29,  0,  0,  0},   // 1479
    {  2,  5, 37,  0,  0,  0},   // 1480
    {  0,  0,  0,  0,  0,  0},   // 1481
    {  2,  3, 13, 19,  0,  0},   // 1482
    {  0,  0,  0,  0,  0,  0},   // 1483
    {  2,  7, 53,  0,  0,  0},   // 1484
    {  3,  5, 11,  0,  0,  0},   // 1485
    {  2,743,  0,  0,  0,  0},   // 1486
    {  0,  0,  0,  0,  0,  0},   // 1487
    {  2,  3, 31,  0,  0,  0},   // 1488
    {  0,  0,  0,  0,  0,  0},   // 1489
    {  2,  5,149,  0,  0,  0},   // 1490
    {  3,  7, 71,  0,  0,  0},   // 1491
    {  2,373,  0,  0,  0,  0},   // 1492
    {  0,  0,  0,  0,  0,  0},   // 1493
    {  2,  3, 83,  0,  0,  0},   // 1494
    {  5, 13, 23,  0,  0,  0},   // 1495
    {  2, 11, 17,  0,  0,  0},   // 1496
    {  3,499,  0,  0,  0,  0},   // 1497
    {  2,  7,107,  0,  0,  0},   // 1498
    {  0,  0,  0,  0,  0,  0},   // 1499
    {  2,  3,  5,  0,  0,  0},   // 1500
    { 19, 79,  0,  0,  0,  0},   // 1501
    {  2,751,  0,  0,  0,  0},   // 1502
    {  3,167,  0,  0,  0,  0},   // 1503
    {  2, 47,  0,  0,  0,  0},   // 1504
    {  5,  7, 43,  0,  0,  0},   // 1505
    {  2,  3,251,  0,  0,  0},   // 1506
    { 11,137,  0,  0,  0,  0},   // 1507
    {  2, 13, 29,  0,  0,  0},   // 1508
    {  3,503,  0,  0,  0,  0},   // 1509
    {  2,  5,151,  0,  0,  0},   // 1510
    {  0,  0,  0,  0,  0,  0},   // 1511
    {  2,  3,  7,  0,  0,  0},   // 1512
    { 17, 89,  0,  0,  0,  0},   // 1513
    {  2,757,  0,  0,  0,  0},   // 1514
    {  3,  5,101,  0,  0,  0},   // 1515
    {  2,379,  0,  0,  0,  0},   // 1516
    { 37, 41,  0,  0,  0,  0},   // 1517
    {  2,  3, 11, 23,  0,  0},   // 1518
    {  7, 31,  0,  0,  0,  0},   // 1519
    {  2,  5, 19,  0,  0,  0},   // 1520
    {  3, 13,  0,  0,  0,  0},   // 1521
    {  2,761,  0,  0,  0,  0},   // 1522
    {  0,  0,  0,  0,  0,  0},   // 1523
    {  2,  3,127,  0,  0,  0},   // 1524
    {  5, 61,  0,  0,  0,  0},   // 1525
    {  2,  7,109,  0,  0,  0},   // 1526
    {  3,509,  0,  0,  0,  0},   // 1527
    {  2,191,  0,  0,  0,  0},   // 1528
    { 11,139,  0,  0,  0,  0},   // 1529
    {  2,  3,  5, 17,  0,  0},   // 1530
    {  0,  0,  0,  0,  0,  0},   // 1531
    {  2,383,  0,  0,  0,  0},   // 1532
    {  3,  7, 73,  0,  0,  0},   // 1533
    {  2, 13, 59,  0,  0,  0},   // 1534
    {  5,307,  0,  0,  0,  0},   // 1535
    {  2,  3,  0,  0,  0,  0},   // 1536
    { 29, 53,  0,  0,  0,  0},   // 1537
    {  2,769,  0,  0,  0,  0},   // 1538
    {  3, 19,  0,  0,  0,  0},   // 1539
    {  2,  5,  7, 11,  0,  0},   // 1540
    { 23, 67,  0,  0,  0,  0},   // 1541
    {  2,  3,257,  0,  0,  0},   // 1542
    {  0,  0,  0,  0,  0,  0},   // 1543
    {  2,193,  0,  0,  0,  0},   // 1544
    {  3,  5,103,  0,  0,  0},   // 1545
    {  2,773,  0,  0,  0,  0},   // 1546
    {  7, 13, 17,  0,  0,  0},   // 1547
    {  2,  3, 43,  0,  0,  0},   // 1548
    {  0,  0,  0,  0,  0,  0},   // 1549
    {  2,  5, 31,  0,  0,  0},   // 1550
    {  3, 11, 47,  0,  0,  0},   // 1551
    {  2, 97,  0,  0,  0,  0},   // 1552
    {  0,  0,  0,  0,  0,  0},   // 1553
    {  2,  3,  7, 37,  0,  0},   // 1554
    {  5,311,  0,  0,  0,  0},   // 1555
    {  2,389,  0,  0,  0,  0},   // 1556
    {  3,173,  0,  0,  0,  0},   // 1557
    {  2, 19, 41,  0,  0,  0},   // 1558
    {  0,  0,  0,  0,  0,  0},   // 1559
    {  2,  3,  5, 13,  0,  0},   // 1560
    {  7,223,  0,  0,  0,  0},   // 1561
    {  2, 11, 71,  0,  0,  0},   // 1562
    {  3,521,  0,  0,  0,  0},   // 1563
    {  2, 17, 23,  0,  0,  0},   // 1564
    {  5,313,  0,  0,  0,  0},   // 1565
    {  2,  3, 29,  0,  0,  0},   // 1566
    {  0,  0,  0,  0,  0,  0},   // 1567
    {  2,  7,  0,  0,  0,  0},   // 1568
    {  3,523,  0,  0,  0,  0},   // 1569
    {  2,  5,157,  0,  0,  0},   // 1570
    {  0,  0,  0,  0,  0,  0},   // 1571
    {  2,  3,131,  0,  0,  0},   // 1572
    { 11, 13,  0,  0,  0,  0},   // 1573
    {  2,787,  0,  0,  0,  0},   // 1574
    {  3,  5,  7,  0,  0,  0},   // 1575
    {  2,197,  0,  0,  0,  0},   // 1576
    { 19, 83,  0,  0,  0,  0},   // 1577
    {  2,  3,263,  0,  0,  0},   // 1578
    {  0,  0,  0,  0,  0,  0},   // 1579
    {  2,  5, 79,  0,  0,  0},   // 1580
    {  3, 17, 31,  0,  0,  0},   // 1581
    {  2,  7,113,  0,  0,  0},   // 1582
    {  0,  0,  0,  0,  0,  0},   // 1583
    {  2,  3, 11,  0,  0,  0},   // 1584
    {  5,317,  0,  0,  0,  0},   // 1585
    {  2, 13, 61,  0,  0,  0},   // 1586
    {  3, 23,  0,  0,  0,  0},   // 1587
    {  2,397,  0,  0,  0,  0},   // 1588
    {  7,227,  0,  0,  0,  0},   // 1589
    {  2,  3,  5, 53,  0,  0},   // 1590
    { 37, 43,  0,  0,  0,  0},   // 1591
    {  2,199,  0,  0,  0,  0},   // 1592
    {  3, 59,  0,  0,  0,  0},   // 1593
    {  2,797,  0,  0,  0,  0},   // 1594
    {  5, 11, 29,  0,  0,  0},   // 1595
    {  2,  3,  7, 19,  0,  0},   // 1596
    {  0,  0,  0,  0,  0,  0},   // 1597
    {  2, 17, 47,  0,  0,  0},   // 1598
    {  3, 13, 41,  0,  0,  0},   // 1599
    {  2,  5,  0,  0,  0,  0},   // 1600
    {  0,  0,  0,  0,  0,  0},   // 1601
    {  2,  3, 89,  0,  0,  0},   // 1602
    {  7,229,  0,  0,  0,  0},   // 1603
    {  2,401,  0,  0,  0,  0},   // 1604
    {  3,  5,107,  0,  0,  0},   // 1605
    {  2, 11, 73,  0,  0,  0},   // 1606
    {  0,  0,  0,  0,  0,  0},   // 1607
    {  2,  3, 67,  0,  0,  0},   // 1608
    {  0,  0,  0,  0,  0,  0},   // 1609
    {  2,  5,  7, 23,  0,  0},   // 1610
    {  3,179,  0,  0,  0,  0},   // 1611
    {  2, 13, 31,  0,  0,  0},   // 1612
    {  0,  0,  0,  0,  0,  0},   // 1613
    {  2,  3,269,  0,  0,  0},   // 1614
    {  5, 17, 19,  0,  0,  0},   // 1615
    {  2,101,  0,  0,  0,  0},   // 1616
    {  3,  7, 11,  0,  0,  0},   // 1617
    {  2,809,  0,  0,  0,  0},   // 1618
    {  0,  0,  0,  0,  0,  0},   // 1619
    {  2,  3,  5,  0,  0,  0},   // 1620
    {  0,  0,  0,  0,  0,  0},   // 1621
    {  2,811,  0,  0,  0,  0},   // 1622
    {  3,541,  0,  0,  0,  0},   // 1623
    {  2,  7, 29,  0,  0,  0},   // 1624
    {  5, 13,  0,  0,  0,  0},   // 1625
    {  2,  3,271,  0,  0,  0},   // 1626
    {  0,  0,  0,  0,  0,  0},   // 1627
    {  2, 11, 37,  0,  0,  0},   // 1628
    {  3,181,  0,  0,  0,  0},   // 1629
    {  2,  5,163,  0,  0,  0},   // 1630
    {  7,233,  0,  0,  0,  0},   // 1631
    {  2,  3, 17,  0,  0,  0},   // 1632
    { 23, 71,  0,  0,  0,  0},   // 1633
    {  2, 19, 43,  0,  0,  0},   // 1634
    {  3,  5,109,  0,  0,  0},   // 1635
    {  2,409,  0,  0,  0,  0},   // 1636
    {  0,  0,  0,  0,  0,  0},   // 1637
    {  2,  3,  7, 13,  0,  0},   // 1638
    { 11,149,  0,  0,  0,  0},   // 1639
    {  2,  5, 41,  0,  0,  0},   // 1640
    {  3,547,  0,  0,  0,  0},   // 1641
    {  2,821,  0,  0,  0,  0},   // 1642
    { 31, 53,  0,  0,  0,  0},   // 1643
    {  2,  3,137,  0,  0,  0},   // 1644
    {  5,  7, 47,  0,  0,  0},   // 1645
    {  2,823,  0,  0,  0,  0},   // 1646
    {  3, 61,  0,  0,  0,  0},   // 1647
    {  2,103,  0,  0,  0,  0},   // 1648
    { 17, 97,  0,  0,  0,  0},   // 1649
    {  2,  3,  5, 11,  0,  0},   // 1650
    { 13,127,  0,  0,  0,  0},   // 1651
    {  2,  7, 59,  0,  0,  0},   // 1652
    {  3, 19, 29,  0,  0,  0},   // 1653
    {  2,827,  0,  0,  0,  0},   // 1654
    {  5,331,  0,  0,  0,  0},   // 1655
    {  2,  3, 23,  0,  0,  0},   // 1656
    {  0,  0,  0,  0,  0,  0},   // 1657
    {  2,829,  0,  0,  0,  0},   // 1658
    {  3,  7, 79,  0,  0,  0},   // 1659
    {  2,  5, 83,  0,  0,  0},   // 1660
    { 11,151,  0,  0,  0,  0},   // 1661
    {  2,  3,277,  0,  0,  0},   // 1662
    {  0,  0,  0,  0,  0,  0},   // 1663
    {  2, 13,  0,  0,  0,  0},   // 1664
    {  3,  5, 37,  0,  0,  0},   // 1665
    {  2,  7, 17,  0,  0,  0},   // 1666
    {  0,  0,  0,  0,  0,  0},   // 1667
    {  2,  3,139,  0,  0,  0},   // 1668
    {  0,  0,  0,  0,  0,  0},   // 1669
    {  2,  5,167,  0,  0,  0},   // 1670
    {  3,557,  0,  0,  0,  0},   // 1671
    {  2, 11, 19,  0,  0,  0},   // 1672
    {  7,239,  0,  0,  0,  0},   // 1673
    {  2,  3, 31,  0,  0,  0},   // 1674
    {  5, 67,  0,  0,  0,  0},   // 1675
    {  2,419,  0,  0,  0,  0},   // 1676
    {  3, 13, 43,  0,  0,  0},   // 1677
    {  2,839,  0,  0,  0,  0},   // 1678
    { 23, 73,  0,  0,  0,  0},   // 1679
    {  2,  3,  5,  7,  0,  0},   // 1680
    { 41,  0,  0,  0,  0,  0},   // 1681
    {  2, 29,  0,  0,  0,  0},   // 1682
    {  3, 11, 17,  0,  0,  0},   // 1683
    {  2,421,  0,  0,  0,  0},   // 1684
    {  5,337,  0,  0,  0,  0},   // 1685
    {  2,  3,281,  0,  0,  0},   // 1686
    {  7,241,  0,  0,  0,  0},   // 1687
    {  2,211,  0,  0,  0,  0},   // 1688
    {  3,563,  0,  0,  0,  0},   // 1689
    {  2,  5, 13,  0,  0,  0},   // 1690
    { 19, 89,  0,  0,  0,  0},   // 1691
    {  2,  3, 47,  0,  0,  0},   // 1692
    {  0,  0,  0,  0,  0,  0},   // 1693
    {  2,  7, 11,  0,  0,  0},   // 1694
    {  3,  5,113,  0,  0,  0},   // 1695
    {  2, 53,  0,  0,  0,  0},   // 1696
    {  0,  0,  0,  0,  0,  0},   // 1697
    {  2,  3,283,  0,  0,  0},   // 1698
    {  0,  0,  0,  0,  0,  0},   // 1699
    {  2,  5, 17,  0,  0,  0},   // 1700
    {  3,  7,  0,  0,  0,  0},   // 1701
    {  2, 23, 37,  0,  0,  0},   // 1702
    { 13,131,  0,  0,  0,  0},   // 1703
    {  2,  3, 71,  0,  0,  0},   // 1704
    {  5, 11, 31,  0,  0,  0},   // 1705
    {  2,853,  0,  0,  0,  0},   // 1706
    {  3,569,  0,  0,  0,  0},   // 1707
    {  2,  7, 61,  0,  0,  0},   // 1708
    {  0,  0,  0,  0,  0,  0},   // 1709
    {  2,  3,  5, 19,  0,  0},   // 1710
    { 29, 59,  0,  0,  0,  0},   // 1711
    {  2,107,  0,  0,  0,  0},   // 1712
    {  3,571,  0,  0,  0,  0},   // 1713
    {  2,857,  0,  0,  0,  0},   // 1714
    {  5,  7,  0,  0,  0,  0},   // 1715
    {  2,  3, 11, 13,  0,  0},   // 1716
    { 17,101,  0,  0,  0,  0},   // 1717
    {  2,859,  0,  0,  0,  0},   // 1718
    {  3,191,  0,  0,  0,  0},   // 1719
    {  2,  5, 43,  0,  0,  0},   // 1720
    {  0,  0,  0,  0,  0,  0},   // 1721
    {  2,  3,  7, 41,  0,  0},   // 1722
    {  0,  0,  0,  0,  0,  0},   // 1723
    {  2,431,  0,  0,  0,  0},   // 1724
    {  3,  5, 23,  0,  0,  0},   // 1725
    {  2,863,  0,  0,  0,  0},   // 1726
    { 11,157,  0,  0,  0,  0},   // 1727
    {  2,  3,  0,  0,  0,  0},   // 1728
    {  7, 13, 19,  0,  0,  0},   // 1729
    {  2,  5,173,  0,  0,  0},   // 1730
    {  3,577,  0,  0,  0,  0},   // 1731
    {  2,433,  0,  0,  0,  0},   // 1732
    {  0,  0,  0,  0,  0,  0},   // 1733
    {  2,  3, 17,  0,  0,  0},   // 1734
    {  5,347,  0,  0,  0,  0},   // 1735
    {  2,  7, 31,  0,  0,  0},   // 1736
    {  3,193,  0,  0,  0,  0},   // 1737
    {  2, 11, 79,  0,  0,  0},   // 1738
    { 37, 47,  0,  0,  0,  0},   // 1739
    {  2,  3,  5, 29,  0,  0},   // 1740
    {  0,  0,  0,  0,  0,  0},   // 1741
    {  2, 13, 67,  0,  0,  0},   // 1742
    {  3,  7, 83,  0,  0,  0},   // 1743
    {  2,109,  0,  0,  0,  0},   // 1744
    {  5,349,  0,  0,  0,  0},   // 1745
    {  2,  3, 97,  0,  0,  0},   // 1746
    {  0,  0,  0,  0,  0,  0},   // 1747
    {  2, 19, 23,  0,  0,  0},   // 1748
    {  3, 11, 53,  0,  0,  0},   // 1749
    {  2,  5,  7,  0,  0,  0},   // 1750
    { 17,103,  0,  0,  0,  0},   // 1751
    {  2,  3, 73,  0,  0,  0},   // 1752
    {  0,  0,  0,  0,  0,  0},   // 1753
    {  2,877,  0,  0,  0,  0},   // 1754
    {  3,  5, 13,  0,  0,  0},   // 1755
    {  2,439,  0,  0,  0,  0},   // 1756
    {  7,251,  0,  0,  0,  0},   // 1757
    {  2,  3,293,  0,  0,  0},   // 1758
    {  0,  0,  0,  0,  0,  0},   // 1759
    {  2,  5, 11,  0,  0,  0},   // 1760
    {  3,587,  0,  0,  0,  0},   // 1761
    {  2,881,  0,  0,  0,  0},   // 1762
    { 41, 43,  0,  0,  0,  0},   // 1763
    {  2,  3,  7,  0,  0,  0},   // 1764
    {  5,353,  0,  0,  0,  0},   // 1765
    {  2,883,  0,  0,  0,  0},   // 1766
    {  3, 19, 31,  0,  0,  0},   // 1767
    {  2, 13, 17,  0,  0,  0},   // 1768
    { 29, 61,  0,  0,  0,  0},   // 1769
    {  2,  3,  5, 59,  0,  0},   // 1770
    {  7, 11, 23,  0,  0,  0},   // 1771
    {  2,443,  0,  0,  0,  0},   // 1772
    {  3,197,  0,  0,  0,  0},   // 1773
    {  2,887,  0,  0,  0,  0},   // 1774
    {  5, 71,  0,  0,  0,  0},   // 1775
    {  2,  3, 37,  0,  0,  0},   // 1776
    {  0,  0,  0,  0,  0,  0},   // 1777
    {  2,  7,127,  0,  0,  0},   // 1778
    {  3,593,  0,  0,  0,  0},   // 1779
    {  2,  5, 89,  0,  0,  0},   // 1780
    { 13,137,  0,  0,  0,  0},   // 1781
    {  2,  3, 11,  0,  0,  0},   // 1782
    {  0,  0,  0,  0,  0,  0},   // 1783
    {  2,223,  0,  0,  0,  0},   // 1784
    {  3,  5,  7, 17,  0,  0},   // 1785
    {  2, 19, 47,  0,  0,  0},   // 1786
    {  0,  0,  0,  0,  0,  0},   // 1787
    {  2,  3,149,  0,  0,  0},   // 1788
    {  0,  0,  0,  0,  0,  0},   // 1789
    {  2,  5,179,  0,  0,  0},   // 1790
    {  3,199,  0,  0,  0,  0},   // 1791
    {  2,  7,  0,  0,  0,  0},   // 1792
    { 11,163,  0,  0,  0,  0},   // 1793
    {  2,  3, 13, 23,  0,  0},   // 1794
    {  5,359,  0,  0,  0,  0},   // 1795
    {  2,449,  0,  0,  0,  0},   // 1796
    {  3,599,  0,  0,  0,  0},   // 1797
    {  2, 29, 31,  0,  0,  0},   // 1798
    {  7,257,  0,  0,  0,  0},   // 1799
    {  2,  3,  5,  0,  0,  0},   // 1800
    {  0,  0,  0,  0,  0,  0},   // 1801
    {  2, 17, 53,  0,  0,  0},   // 1802
    {  3,601,  0,  0,  0,  0},   // 1803
    {  2, 11, 41,  0,  0,  0},   // 1804
    {  5, 19,  0,  0,  0,  0},   // 1805
    {  2,  3,  7, 43,  0,  0},   // 1806
    { 13,139,  0,  0,  0,  0},   // 1807
    {  2,113,  0,  0,  0,  0},   // 1808
    {  3, 67,  0,  0,  0,  0},   // 1809
    {  2,  5,181,  0,  0,  0},   // 1810
    {  0,  0,  0,  0,  0,  0},   // 1811
    {  2,  3,151,  0,  0,  0},   // 1812
    {  7, 37,  0,  0,  0,  0},   // 1813
    {  2,907,  0,  0,  0,  0},   // 1814
    {  3,  5, 11,  0,  0,  0},   // 1815
    {  2,227,  0,  0,  0,  0},   // 1816
    { 23, 79,  0,  0,  0,  0},   // 1817
    {  2,  3,101,  0,  0,  0},   // 1818
    { 17,107,  0,  0,  0,  0},   // 1819
    {  2,  5,  7, 13,  0,  0},   // 1820
    {  3,607,  0,  0,  0,  0},   // 1821
    {  2,911,  0,  0,  0,  0},   // 1822
    {  0,  0,  0,  0,  0,  0},   // 1823
    {  2,  3, 19,  0,  0,  0},   // 1824
    {  5, 73,  0,  0,  0,  0},   // 1825
    {  2, 11, 83,  0,  0,  0},   // 1826
    {  3,  7, 29,  0,  0,  0},   // 1827
    {  2,457,  0,  0,  0,  0},   // 1828
    { 31, 59,  0,  0,  0,  0},   // 1829
    {  2,  3,  5, 61,  0,  0},   // 1830
    {  0,  0,  0,  0,  0,  0},   // 1831
    {  2,229,  0,  0,  0,  0},   // 1832
    {  3, 13, 47,  0,  0,  0},   // 1833
    {  2,  7,131,  0,  0,  0},   // 1834
    {  5,367,  0,  0,  0,  0},   // 1835
    {  2,  3, 17,  0,  0,  0},   // 1836
    { 11,167,  0,  0,  0,  0},   // 1837
    {  2,919,  0,  0,  0,  0},   // 1838
    {  3,613,  0,  0,  0,  0},   // 1839
    {  2,  5, 23,  0,  0,  0},   // 1840
    {  7,263,  0,  0,  0,  0},   // 1841
    {  2,  3,307,  0,  0,  0},   // 1842
    { 19, 97,  0,  0,  0,  0},   // 1843
    {  2,461,  0,  0,  0,  0},   // 1844
    {  3,  5, 41,  0,  0,  0},   // 1845
    {  2, 13, 71,  0,  0,  0},   // 1846
    {  0,  0,  0,  0,  0,  0},   // 1847
    {  2,  3,  7, 11,  0,  0},   // 1848
    { 43,  0,  0,  0,  0,  0},   // 1849
    {  2,  5, 37,  0,  0,  0},   // 1850
    {  3,617,  0,  0,  0,  0},   // 1851
    {  2,463,  0,  0,  0,  0},   // 1852
    { 17,109,  0,  0,  0,  0},   // 1853
    {  2,  3,103,  0,  0,  0},   // 1854
    {  5,  7, 53,  0,  0,  0},   // 1855
    {  2, 29,  0,  0,  0,  0},   // 1856
    {  3,619,  0,  0,  0,  0},   // 1857
    {  2,929,  0,  0,  0,  0},   // 1858
    { 11, 13,  0,  0,  0,  0},   // 1859
    {  2,  3,  5, 31,  0,  0},   // 1860
    {  0,  0,  0,  0,  0,  0},   // 1861
    {  2,  7, 19,  0,  0,  0},   // 1862
    {  3, 23,  0,  0,  0,  0},   // 1863
    {  2,233,  0,  0,  0,  0},   // 1864
    {  5,373,  0,  0,  0,  0},   // 1865
    {  2,  3,311,  0,  0,  0},   // 1866
    {  0,  0,  0,  0,  0,  0},   // 1867
    {  2,467,  0,  0,  0,  0},   // 1868
    {  3,  7, 89,  0,  0,  0},   // 1869
    {  2,  5, 11, 17,  0,  0},   // 1870
    {  0,  0,  0,  0,  0,  0},   // 1871
    {  2,  3, 13,  0,  0,  0},   // 1872
    {  0,  0,  0,  0,  0,  0},   // 1873
    {  2,937,  0,  0,  0,  0},   // 1874
    {  3,  5,  0,  0,  0,  0},   // 1875
    {  2,  7, 67,  0,  0,  0},   // 1876
    {  0,  0,  0,  0,  0,  0},   // 1877
    {  2,  3,313,  0,  0,  0},   // 1878
    {  0,  0,  0,  0,  0,  0},   // 1879
    {  2,  5, 47,  0,  0,  0},   // 1880
    {  3, 11, 19,  0,  0,  0},   // 1881
    {  2,941,  0,  0,  0,  0},   // 1882
    {  7,269,  0,  0,  0,  0},   // 1883
    {  2,  3,157,  0,  0,  0},   // 1884
    {  5, 13, 29,  0,  0,  0},   // 1885
    {  2, 23, 41,  0,  0,  0},   // 1886
    {  3, 17, 37,  0,  0,  0},   // 1887
    {  2, 59,  0,  0,  0,  0},   // 1888
    {  0,  0,  0,  0,  0,  0},   // 1889
    {  2,  3,  5,  7,  0,  0},   // 1890
    { 31, 61,  0,  0,  0,  0},   // 1891
    {  2, 11, 43,  0,  0,  0},   // 1892
    {  3,631,  0,  0,  0,  0},   // 1893
    {  2,947,  0,  0,  0,  0},   // 1894
    {  5,379,  0,  0,  0,  0},   // 1895
    {  2,  3, 79,  0,  0,  0},   // 1896
    {  7,271,  0,  0,  0,  0},   // 1897
    {  2, 13, 73,  0,  0,  0},   // 1898
    {  3,211,  0,  0,  0,  0},   // 1899
    {  2,  5, 19,  0,  0,  0},   // 1900
    {  0,  0,  0,  0,  0,  0},   // 1901
    {  2,  3,317,  0,  0,  0},   // 1902
    { 11,173,  0,  0,  0,  0},   // 1903
    {  2,  7, 17,  0,  0,  0},   // 1904
    {  3,  5,127,  0,  0,  0},   // 1905
    {  2,953,  0,  0,  0,  0},   // 1906
    {  0,  0,  0,  0,  0,  0},   // 1907
    {  2,  3, 53,  0,  0,  0},   // 1908
    { 23, 83,  0,  0,  0,  0},   // 1909
    {  2,  5,191,  0,  0,  0},   // 1910
    {  3,  7, 13,  0,  0,  0},   // 1911
    {  2,239,  0,  0,  0,  0},   // 1912
    {  0,  0,  0,  0,  0,  0},   // 1913
    {  2,  3, 11, 29,  0,  0},   // 1914
    {  5,383,  0,  0,  0,  0},   // 1915
    {  2,479,  0,  0,  0,  0},   // 1916
    {  3, 71,  0,  0,  0,  0},   // 1917
    {  2,  7,137,  0,  0,  0},   // 1918
    { 19,101,  0,  0,  0,  0},   // 1919
    {  2,  3,  5,  0,  0,  0},   // 1920
    { 17,113,  0,  0,  0,  0},   // 1921
    {  2, 31,  0,  0,  0,  0},   // 1922
    {  3,641,  0,  0,  0,  0},   // 1923
    {  2, 13, 37,  0,  0,  0},   // 1924
    {  5,  7, 11,  0,  0,  0},   // 1925
    {  2,  3,107,  0,  0,  0},   // 1926
    { 41, 47,  0,  0,  0,  0},   // 1927
    {  2,241,  0,  0,  0,  0},   // 1928
    {  3,643,  0,  0,  0,  0},   // 1929
    {  2,  5,193,  0,  0,  0},   // 1930
    {  0,  0,  0,  0,  0,  0},   // 1931
    {  2,  3,  7, 23,  0,  0},   // 1932
    {  0,  0,  0,  0,  0,  0},   // 1933
    {  2,967,  0,  0,  0,  0},   // 1934
    {  3,  5, 43,  0,  0,  0},   // 1935
    {  2, 11,  0,  0,  0,  0},   // 1936
    { 13,149,  0,  0,  0,  0},   // 1937
    {  2,  3, 17, 19,  0,  0},   // 1938
    {  7,277,  0,  0,  0,  0},   // 1939
    {  2,  5, 97,  0,  0,  0},   // 1940
    {  3,647,  0,  0,  0,  0},   // 1941
    {  2,971,  0,  0,  0,  0},   // 1942
    { 29, 67,  0,  0,  0,  0},   // 1943
    {  2,  3,  0,  0,  0,  0},   // 1944
    {  5,389,  0,  0,  0,  0},   // 1945
    {  2,  7,139,  0,  0,  0},   // 1946
    {  3, 11, 59,  0,  0,  0},   // 1947
    {  2,487,  0,  0,  0,  0},   // 1948
    {  0,  0,  0,  0,  0,  0},   // 1949
    {  2,  3,  5, 13,  0,  0},   // 1950
    {  0,  0,  0,  0,  0,  0},   // 1951
    {  2, 61,  0,  0,  0,  0},   // 1952
    {  3,  7, 31,  0,  0,  0},   // 1953
    {  2,977,  0,  0,  0,  0},   // 1954
    {  5, 17, 23,  0,  0,  0},   // 1955
    {  2,  3,163,  0,  0,  0},   // 1956
    { 19,103,  0,  0,  0,  0},   // 1957
    {  2, 11, 89,  0,  0,  0},   // 1958
    {  3,653,  0,  0,  0,  0},   // 1959
    {  2,  5,  7,  0,  0,  0},   // 1960
    { 37, 53,  0,  0,  0,  0},   // 1961
    {  2,  3,109,  0,  0,  0},   // 1962
    { 13,151,  0,  0,  0,  0},   // 1963
    {  2,491,  0,  0,  0,  0},   // 1964
    {  3,  5,131,  0,  0,  0},   // 1965
    {  2,983,  0,  0,  0,  0},   // 1966
    {  7,281,  0,  0,  0,  0},   // 1967
    {  2,  3, 41,  0,  0,  0},   // 1968
    { 11,179,  0,  0,  0,  0},   // 1969
    {  2,  5,197,  0,  0,  0},   // 1970
    {  3, 73,  0,  0,  0,  0},   // 1971
    {  2, 17, 29,  0,  0,  0},   // 1972
    {  0,  0,  0,  0,  0,  0},   // 1973
    {  2,  3,  7, 47,  0,  0},   // 1974
    {  5, 79,  0,  0,  0,  0},   // 1975
    {  2, 13, 19,  0,  0,  0},   // 1976
    {  3,659,  0,  0,  0,  0},   // 1977
    {  2, 23, 43,  0,  0,  0},   // 1978
    {  0,  0,  0,  0,  0,  0},   // 1979
    {  2,  3,  5, 11,  0,  0},   // 1980
    {  7,283,  0,  0,  0,  0},   // 1981
    {  2,991,  0,  0,  0,  0},   // 1982
    {  3,661,  0,  0,  0,  0},   // 1983
    {  2, 31,  0,  0,  0,  0},   // 1984
    {  5,397,  0,  0,  0,  0},   // 1985
    {  2,  3,331,  0,  0,  0},   // 1986
    {  0,  0,  0,  0,  0,  0},   // 1987
    {  2,  7, 71,  0,  0,  0},   // 1988
    {  3, 13, 17,  0,  0,  0},   // 1989
    {  2,  5,199,  0,  0,  0},   // 1990
    { 11,181,  0,  0,  0,  0},   // 1991
    {  2,  3, 83,  0,  0,  0},   // 1992
    {  0,  0,  0,  0,  0,  0},   // 1993
    {  2,997,  0,  0,  0,  0},   // 1994
    {  3,  5,  7, 19,  0,  0},   // 1995
    {  2,499,  0,  0,  0,  0},   // 1996
    {  0,  0,  0,  0,  0,  0},   // 1997
    {  2,  3, 37,  0,  0,  0},   // 1998
    {  0,  0,  0,  0,  0,  0},   // 1999
    {  2,  5,  0,  0,  0,  0},   // 2000
    {  3, 23, 29,  0,  0,  0},   // 2001
    {  2,  7, 11, 13,  0,  0},   // 2002
    {  0,  0,  0,  0,  0,  0},   // 2003
    {  2,  3,167,  0,  0,  0},   // 2004
    {  5,401,  0,  0,  0,  0},   // 2005
    {  2, 17, 59,  0,  0,  0},   // 2006
    {  3,223,  0,  0,  0,  0},   // 2007
    {  2,251,  0,  0,  0,  0},   // 2008
    {  7, 41,  0,  0,  0,  0},   // 2009
    {  2,  3,  5, 67,  0,  0},   // 2010
    {  0,  0,  0,  0,  0,  0},   // 2011
    {  2,503,  0,  0,  0,  0},   // 2012
    {  3, 11, 61,  0,  0,  0},   // 2013
    {  2, 19, 53,  0,  0,  0},   // 2014
    {  5, 13, 31,  0,  0,  0},   // 2015
    {  2,  3,  7,  0,  0,  0},   // 2016
    {  0,  0,  0,  0,  0,  0},   // 2017
    {  2,1009,  0,  0,  0,  0},   // 2018
    {  3,673,  0,  0,  0,  0},   // 2019
    {  2,  5,101,  0,  0,  0},   // 2020
    { 43, 47,  0,  0,  0,  0},   // 2021
    {  2,  3,337,  0,  0,  0},   // 2022
    {  7, 17,  0,  0,  0,  0},   // 2023
    {  2, 11, 23,  0,  0,  0},   // 2024
    {  3,  5,  0,  0,  0,  0},   // 2025
    {  2,1013,  0,  0,  0,  0},   // 2026
    {  0,  0,  0,  0,  0,  0},   // 2027
    {  2,  3, 13,  0,  0,  0},   // 2028
    {  0,  0,  0,  0,  0,  0},   // 2029
    {  2,  5,  7, 29,  0,  0},   // 2030
    {  3,677,  0,  0,  0,  0},   // 2031
    {  2,127,  0,  0,  0,  0},   // 2032
    { 19,107,  0,  0,  0,  0},   // 2033
    {  2,  3,113,  0,  0,  0},   // 2034
    {  5, 11, 37,  0,  0,  0},   // 2035
    {  2,509,  0,  0,  0,  0},   // 2036
    {  3,  7, 97,  0,  0,  0},   // 2037
    {  2,1019,  0,  0,  0,  0},   // 2038
    {  0,  0,  0,  0,  0,  0},   // 2039
    {  2,  3,  5, 17,  0,  0},   // 2040
    { 13,157,  0,  0,  0,  0},   // 2041
    {  2,1021,  0,  0,  0,  0},   // 2042
    {  3,227,  0,  0,  0,  0},   // 2043
    {  2,  7, 73,  0,  0,  0},   // 2044
    {  5,409,  0,  0,  0,  0},   // 2045
    {  2,  3, 11, 31,  0,  0},   // 2046
    { 23, 89,  0,  0,  0,  0},   // 2047
    {  2,  0,  0,  0,  0,  0},   // 2048
    {  3,683,  0,  0,  0,  0},   // 2049
    {  2,  5, 41,  0,  0,  0},   // 2050
    {  7,293,  0,  0,  0,  0},   // 2051
    {  2,  3, 19,  0,  0,  0},   // 2052
    {  0,  0,  0,  0,  0,  0},   // 2053
    {  2, 13, 79,  0,  0,  0},   // 2054
    {  3,  5,137,  0,  0,  0},   // 2055
    {  2,257,  0,  0,  0,  0},   // 2056
    { 11, 17,  0,  0,  0,  0},   // 2057
    {  2,  3,  7,  0,  0,  0},   // 2058
    { 29, 71,  0,  0,  0,  0},   // 2059
    {  2,  5,103,  0,  0,  0},   // 2060
    {  3,229,  0,  0,  0,  0},   // 2061
    {  2,1031,  0,  0,  0,  0},   // 2062
    {  0,  0,  0,  0,  0,  0},   // 2063
    {  2,  3, 43,  0,  0,  0},   // 2064
    {  5,  7, 59,  0,  0,  0},   // 2065
    {  2,1033,  0,  0,  0,  0},   // 2066
    {  3, 13, 53,  0,  0,  0},   // 2067
    {  2, 11, 47,  0,  0,  0},   // 2068
    {  0,  0,  0,  0,  0,  0},   // 2069
    {  2,  3,  5, 23,  0,  0},   // 2070
    { 19,109,  0,  0,  0,  0},   // 2071
    {  2,  7, 37,  0,  0,  0},   // 2072
    {  3,691,  0,  0,  0,  0},   // 2073
    {  2, 17, 61,  0,  0,  0},   // 2074
    {  5, 83,  0,  0,  0,  0},   // 2075
    {  2,  3,173,  0,  0,  0},   // 2076
    { 31, 67,  0,  0,  0,  0},   // 2077
    {  2,1039,  0,  0,  0,  0},   // 2078
    {  3,  7, 11,  0,  0,  0},   // 2079
    {  2,  5, 13,  0,  0,  0},   // 2080
    {  0,  0,  0,  0,  0,  0},   // 2081
    {  2,  3,347,  0,  0,  0},   // 2082
    {  0,  0,  0,  0,  0,  0},   // 2083
    {  2,521,  0,  0,  0,  0},   // 2084
    {  3,  5,139,  0,  0,  0},   // 2085
    {  2,  7,149,  0,  0,  0},   // 2086
    {  0,  0,  0,  0,  0,  0},   // 2087
    {  2,  3, 29,  0,  0,  0},   // 2088
    {  0,  0,  0,  0,  0,  0},   // 2089
    {  2,  5, 11, 19,  0,  0},   // 2090
    {  3, 17, 41,  0,  0,  0},   // 2091
    {  2,523,  0,  0,  0,  0},   // 2092
    {  7, 13, 23,  0,  0,  0},   // 2093
    {  2,  3,349,  0,  0,  0},   // 2094
    {  5,419,  0,  0,  0,  0},   // 2095
    {  2,131,  0,  0,  0,  0},   // 2096
    {  3,233,  0,  0,  0,  0},   // 2097
    {  2,1049,  0,  0,  0,  0},   // 2098
    {  0,  0,  0,  0,  0,  0},   // 2099
    {  2,  3,  5,  7,  0,  0},   // 2100
    { 11,191,  0,  0,  0,  0},   // 2101
    {  2,1051,  0,  0,  0,  0},   // 2102
    {  3,701,  0,  0,  0,  0},   // 2103
    {  2,263,  0,  0,  0,  0},   // 2104
    {  5,421,  0,  0,  0,  0},   // 2105
    {  2,  3, 13,  0,  0,  0},   // 2106
    {  7, 43,  0,  0,  0,  0},   // 2107
    {  2, 17, 31,  0,  0,  0},   // 2108
    {  3, 19, 37,  0,  0,  0},   // 2109
    {  2,  5,211,  0,  0,  0},   // 2110
    {  0,  0,  0,  0,  0,  0},   // 2111
    {  2,  3, 11,  0,  0,  0},   // 2112
    {  0,  0,  0,  0,  0,  0},   // 2113
    {  2,  7,151,  0,  0,  0},   // 2114
    {  3,  5, 47,  0,  0,  0},   // 2115
    {  2, 23,  0,  0,  0,  0},   // 2116
    { 29, 73,  0,  0,  0,  0},   // 2117
    {  2,  3,353,  0,  0,  0},   // 2118
    { 13,163,  0,  0,  0,  0},   // 2119
    {  2,  5, 53,  0,  0,  0},   // 2120
    {  3,  7,101,  0,  0,  0},   // 2121
    {  2,1061,  0,  0,  0,  0},   // 2122
    { 11,193,  0,  0,  0,  0},   // 2123
    {  2,  3, 59,  0,  0,  0},   // 2124
    {  5, 17,  0,  0,  0,  0},   // 2125
    {  2,1063,  0,  0,  0,  0},   // 2126
    {  3,709,  0,  0,  0,  0},   // 2127
    {  2,  7, 19,  0,  0,  0},   // 2128
    {  0,  0,  0,  0,  0,  0},   // 2129
    {  2,  3,  5, 71,  0,  0},   // 2130
    {  0,  0,  0,  0,  0,  0},   // 2131
    {  2, 13, 41,  0,  0,  0},   // 2132
    {  3, 79,  0,  0,  0,  0},   // 2133
    {  2, 11, 97,  0,  0,  0},   // 2134
    {  5,  7, 61,  0,  0,  0},   // 2135
    {  2,  3, 89,  0,  0,  0},   // 2136
    {  0,  0,  0,  0,  0,  0},   // 2137
    {  2,1069,  0,  0,  0,  0},   // 2138
    {  3, 23, 31,  0,  0,  0},   // 2139
    {  2,  5,107,  0,  0,  0},   // 2140
    {  0,  0,  0,  0,  0,  0},   // 2141
    {  2,  3,  7, 17,  0,  0},   // 2142
    {  0,  0,  0,  0,  0,  0},   // 2143
    {  2, 67,  0,  0,  0,  0},   // 2144
    {  3,  5, 11, 13,  0,  0},   // 2145
    {  2, 29, 37,  0,  0,  0},   // 2146
    { 19,113,  0,  0,  0,  0},   // 2147
    {  2,  3,179,  0,  0,  0},   // 2148
    {  7,307,  0,  0,  0,  0},   // 2149
    {  2,  5, 43,  0,  0,  0},   // 2150
    {  3,239,  0,  0,  0,  0},   // 2151
    {  2,269,  0,  0,  0,  0},   // 2152
    {  0,  0,  0,  0,  0,  0},   // 2153
    {  2,  3,359,  0,  0,  0},   // 2154
    {  5,431,  0,  0,  0,  0},   // 2155
    {  2,  7, 11,  0,  0,  0},   // 2156
    {  3,719,  0,  0,  0,  0},   // 2157
    {  2, 13, 83,  0,  0,  0},   // 2158
    { 17,127,  0,  0,  0,  0},   // 2159
    {  2,  3,  5,  0,  0,  0},   // 2160
    {  0,  0,  0,  0,  0,  0},   // 2161
    {  2, 23, 47,  0,  0,  0},   // 2162
    {  3,  7,103,  0,  0,  0},   // 2163
    {  2,541,  0,  0,  0,  0},   // 2164
    {  5,433,  0,  0,  0,  0},   // 2165
    {  2,  3, 19,  0,  0,  0},   // 2166
    { 11,197,  0,  0,  0,  0},   // 2167
    {  2,271,  0,  0,  0,  0},   // 2168
    {  3,241,  0,  0,  0,  0},   // 2169
    {  2,  5,  7, 31,  0,  0},   // 2170
    { 13,167,  0,  0,  0,  0},   // 2171
    {  2,  3,181,  0,  0,  0},   // 2172
    { 41, 53,  0,  0,  0,  0},   // 2173
    {  2,1087,  0,  0,  0,  0},   // 2174
    {  3,  5, 29,  0,  0,  0},   // 2175
    {  2, 17,  0,  0,  0,  0},   // 2176
    {  7,311,  0,  0,  0,  0},   // 2177
    {  2,  3, 11,  0,  0,  0},   // 2178
    {  0,  0,  0,  0,  0,  0},   // 2179
    {  2,  5,109,  0,  0,  0},   // 2180
    {  3,727,  0,  0,  0,  0},   // 2181
    {  2,1091,  0,  0,  0,  0},   // 2182
    { 37, 59,  0,  0,  0,  0},   // 2183
    {  2,  3,  7, 13,  0,  0},   // 2184
    {  5, 19, 23,  0,  0,  0},   // 2185
    {  2,1093,  0,  0,  0,  0},   // 2186
    {  3,  0,  0,  0,  0,  0},   // 2187
    {  2,547,  0,  0,  0,  0},   // 2188
    { 11,199,  0,  0,  0,  0},   // 2189
    {  2,  3,  5, 73,  0,  0},   // 2190
    {  7,313,  0,  0,  0,  0},   // 2191
    {  2,137,  0,  0,  0,  0},   // 2192
    {  3, 17, 43,  0,  0,  0},   // 2193
    {  2,1097,  0,  0,  0,  0},   // 2194
    {  5,439,  0,  0,  0,  0},   // 2195
    {  2,  3, 61,  0,  0,  0},   // 2196
    { 13,  0,  0,  0,  0,  0},   // 2197
    {  2,  7,157,  0,  0,  0},   // 2198
    {  3,733,  0,  0,  0,  0},   // 2199
    {  2,  5, 11,  0,  0,  0},   // 2200
    { 31, 71,  0,  0,  0,  0},   // 2201
    {  2,  3,367,  0,  0,  0},   // 2202
    {  0,  0,  0,  0,  0,  0},   // 2203
    {  2, 19, 29,  0,  0,  0},   // 2204
    {  3,  5,  7,  0,  0,  0},   // 2205
    {  2,1103,  0,  0,  0,  0},   // 2206
    {  0,  0,  0,  0,  0,  0},   // 2207
    {  2,  3, 23,  0,  0,  0},   // 2208
    { 47,  0,  0,  0,  0,  0},   // 2209
    {  2,  5, 13, 17,  0,  0},   // 2210
    {  3, 11, 67,  0,  0,  0},   // 2211
    {  2,  7, 79,  0,  0,  0},   // 2212
    {  0,  0,  0,  0,  0,  0},   // 2213
    {  2,  3, 41,  0,  0,  0},   // 2214
    {  5,443,  0,  0,  0,  0},   // 2215
    {  2,277,  0,  0,  0,  0},   // 2216
    {  3,739,  0,  0,  0,  0},   // 2217
    {  2,1109,  0,  0,  0,  0},   // 2218
    {  7,317,  0,  0,  0,  0},   // 2219
    {  2,  3,  5, 37,  0,  0},   // 2220
    {  0,  0,  0,  0,  0,  0},   // 2221
    {  2, 11,101,  0,  0,  0},   // 2222
    {  3, 13, 19,  0,  0,  0},   // 2223
    {  2,139,  0,  0,  0,  0},   // 2224
    {  5, 89,  0,  0,  0,  0},   // 2225
    {  2,  3,  7, 53,  0,  0},   // 2226
    { 17,131,  0,  0,  0,  0},   // 2227
    {  2,557,  0,  0,  0,  0},   // 2228
    {  3,743,  0,  0,  0,  0},   // 2229
    {  2,  5,223,  0,  0,  0},   // 2230
    { 23, 97,  0,  0,  0,  0},   // 2231
    {  2,  3, 31,  0,  0,  0},   // 2232
    {  7, 11, 29,  0,  0,  0},   // 2233
    {  2,1117,  0,  0,  0,  0},   // 2234
    {  3,  5,149,  0,  0,  0},   // 2235
    {  2, 13, 43,  0,  0,  0},   // 2236
    {  0,  0,  0,  0,  0,  0},   // 2237
    {  2,  3,373,  0,  0,  0},   // 2238
    {  0,  0,  0,  0,  0,  0},   // 2239
    {  2,  5,  7,  0,  0,  0},   // 2240
    {  3, 83,  0,  0,  0,  0},   // 2241
    {  2, 19, 59,  0,  0,  0},   // 2242
    {  0,  0,  0,  0,  0,  0},   // 2243
    {  2,  3, 11, 17,  0,  0},   // 2244
    {  5,449,  0,  0,  0,  0},   // 2245
    {  2,1123,  0,  0,  0,  0},   // 2246
    {  3,  7,107,  0,  0,  0},   // 2247
    {  2,281,  0,  0,  0,  0},   // 2248
    { 13,173,  0,  0,  0,  0},   // 2249
    {  2,  3,  5,  0,  0,  0},   // 2250
    {  0,  0,  0,  0,  0,  0},   // 2251
    {  2,563,  0,  0,  0,  0},   // 2252
    {  3,751,  0,  0,  0,  0},   // 2253
    {  2,  7, 23,  0,  0,  0},   // 2254
    {  5, 11, 41,  0,  0,  0},   // 2255
    {  2,  3, 47,  0,  0,  0},   // 2256
    { 37, 61,  0,  0,  0,  0},   // 2257
    {  2,1129,  0,  0,  0,  0},   // 2258
    {  3,251,  0,  0,  0,  0},   // 2259
    {  2,  5,113,  0,  0,  0},   // 2260
    {  7, 17, 19,  0,  0,  0},   // 2261
    {  2,  3, 13, 29,  0,  0},   // 2262
    { 31, 73,  0,  0,  0,  0},   // 2263
    {  2,283,  0,  0,  0,  0},   // 2264
    {  3,  5,151,  0,  0,  0},   // 2265
    {  2, 11,103,  0,  0,  0},   // 2266
    {  0,  0,  0,  0,  0,  0},   // 2267
    {  2,  3,  7,  0,  0,  0},   // 2268
    {  0,  0,  0,  0,  0,  0},   // 2269
    {  2,  5,227,  0,  0,  0},   // 2270
    {  3,757,  0,  0,  0,  0},   // 2271
    {  2, 71,  0,  0,  0,  0},   // 2272
    {  0,  0,  0,  0,  0,  0},   // 2273
    {  2,  3,379,  0,  0,  0},   // 2274
    {  5,  7, 13,  0,  0,  0},   // 2275
    {  2,569,  0,  0,  0,  0},   // 2276
    {  3, 11, 23,  0,  0,  0},   // 2277
    {  2, 17, 67,  0,  0,  0},   // 2278
    { 43, 53,  0,  0,  0,  0},   // 2279
    {  2,  3,  5, 19,  0,  0},   // 2280
    {  0,  0,  0,  0,  0,  0},   // 2281
    {  2,  7,163,  0,  0,  0},   // 2282
    {  3,761,  0,  0,  0,  0},   // 2283
    {  2,571,  0,  0,  0,  0},   // 2284
    {  5,457,  0,  0,  0,  0},   // 2285
    {  2,  3,127,  0,  0,  0},   // 2286
    {  0,  0,  0,  0,  0,  0},   // 2287
    {  2, 11, 13,  0,  0,  0},   // 2288
    {  3,  7,109,  0,  0,  0},   // 2289
    {  2,  5,229,  0,  0,  0},   // 2290
    { 29, 79,  0,  0,  0,  0},   // 2291
    {  2,  3,191,  0,  0,  0},   // 2292
    {  0,  0,  0,  0,  0,  0},   // 2293
    {  2, 31, 37,  0,  0,  0},   // 2294
    {  3,  5, 17,  0,  0,  0},   // 2295
    {  2,  7, 41,  0,  0,  0},   // 2296
    {  0,  0,  0,  0,  0,  0},   // 2297
    {  2,  3,383,  0,  0,  0},   // 2298
    { 11, 19,  0,  0,  0,  0},   // 2299
    {  2,  5, 23,  0,  0,  0},   // 2300
    {  3, 13, 59,  0,  0,  0},   // 2301
    {  2,1151,  0,  0,  0,  0},   // 2302
    {  7, 47,  0,  0,  0,  0},   // 2303
    {  2,  3,  0,  0,  0,  0},   // 2304
    {  5,461,  0,  0,  0,  0},   // 2305
    {  2,1153,  0,  0,  0,  0},   // 2306
    {  3,769,  0,  0,  0,  0},   // 2307
    {  2,577,  0,  0,  0,  0},   // 2308
    {  0,  0,  0,  0,  0,  0},   // 2309
    {  2,  3,  5,  7, 11,  0},   // 2310
    {  0,  0,  0,  0,  0,  0},   // 2311
    {  2, 17,  0,  0,  0,  0},   // 2312
    {  3,257,  0,  0,  0,  0},   // 2313
    {  2, 13, 89,  0,  0,  0},   // 2314
    {  5,463,  0,  0,  0,  0},   // 2315
    {  2,  3,193,  0,  0,  0},   // 2316
    {  7,331,  0,  0,  0,  0},   // 2317
    {  2, 19, 61,  0,  0,  0},   // 2318
    {  3,773,  0,  0,  0,  0},   // 2319
    {  2,  5, 29,  0,  0,  0},   // 2320
    { 11,211,  0,  0,  0,  0},   // 2321
    {  2,  3, 43,  0,  0,  0},   // 2322
    { 23,101,  0,  0,  0,  0},   // 2323
    {  2,  7, 83,  0,  0,  0},   // 2324
    {  3,  5, 31,  0,  0,  0},   // 2325
    {  2,1163,  0,  0,  0,  0},   // 2326
    { 13,179,  0,  0,  0,  0},   // 2327
    {  2,  3, 97,  0,  0,  0},   // 2328
    { 17,137,  0,  0,  0,  0},   // 2329
    {  2,  5,233,  0,  0,  0},   // 2330
    {  3,  7, 37,  0,  0,  0},   // 2331
    {  2, 11, 53,  0,  0,  0},   // 2332
    {  0,  0,  0,  0,  0,  0},   // 2333
    {  2,  3,389,  0,  0,  0},   // 2334
    {  5,467,  0,  0,  0,  0},   // 2335
    {  2, 73,  0,  0,  0,  0},   // 2336
    {  3, 19, 41,  0,  0,  0},   // 2337
    {  2,  7,167,  0,  0,  0},   // 2338
    {  0,  0,  0,  0,  0,  0},   // 2339
    {  2,  3,  5, 13,  0,  0},   // 2340
    {  0,  0,  0,  0,  0,  0},   // 2341
    {  2,1171,  0,  0,  0,  0},   // 2342
    {  3, 11, 71,  0,  0,  0},   // 2343
    {  2,293,  0,  0,  0,  0},   // 2344
    {  5,  7, 67,  0,  0,  0},   // 2345
    {  2,  3, 17, 23,  0,  0},   // 2346
    {  0,  0,  0,  0,  0,  0},   // 2347
    {  2,587,  0,  0,  0,  0},   // 2348
    {  3, 29,  0,  0,  0,  0},   // 2349
    {  2,  5, 47,  0,  0,  0},   // 2350
    {  0,  0,  0,  0,  0,  0},   // 2351
    {  2,  3,  7,  0,  0,  0},   // 2352
    { 13,181,  0,  0,  0,  0},   // 2353
    {  2, 11,107,  0,  0,  0},   // 2354
    {  3,  5,157,  0,  0,  0},   // 2355
    {  2, 19, 31,  0,  0,  0},   // 2356
    {  0,  0,  0,  0,  0,  0},   // 2357
    {  2,  3,131,  0,  0,  0},   // 2358
    {  7,337,  0,  0,  0,  0},   // 2359
    {  2,  5, 59,  0,  0,  0},   // 2360
    {  3,787,  0,  0,  0,  0},   // 2361
    {  2,1181,  0,  0,  0,  0},   // 2362
    { 17,139,  0,  0,  0,  0},   // 2363
    {  2,  3,197,  0,  0,  0},   // 2364
    {  5, 11, 43,  0,  0,  0},   // 2365
    {  2,  7, 13,  0,  0,  0},   // 2366
    {  3,263,  0,  0,  0,  0},   // 2367
    {  2, 37,  0,  0,  0,  0},   // 2368
    { 23,103,  0,  0,  0,  0},   // 2369
    {  2,  3,  5, 79,  0,  0},   // 2370
    {  0,  0,  0,  0,  0,  0},   // 2371
    {  2,593,  0,  0,  0,  0},   // 2372
    {  3,  7,113,  0,  0,  0},   // 2373
    {  2,1187,  0,  0,  0,  0},   // 2374
    {  5, 19,  0,  0,  0,  0},   // 2375
    {  2,  3, 11,  0,  0,  0},   // 2376
    {  0,  0,  0,  0,  0,  0},   // 2377
    {  2, 29, 41,  0,  0,  0},   // 2378
    {  3, 13, 61,  0,  0,  0},   // 2379
    {  2,  5,  7, 17,  0,  0},   // 2380
    {  0,  0,  0,  0,  0,  0},   // 2381
    {  2,  3,397,  0,  0,  0},   // 2382
    {  0,  0,  0,  0,  0,  0},   // 2383
    {  2,149,  0,  0,  0,  0},   // 2384
    {  3,  5, 53,  0,  0,  0},   // 2385
    {  2,1193,  0,  0,  0,  0},   // 2386
    {  7, 11, 31,  0,  0,  0},   // 2387
    {  2,  3,199,  0,  0,  0},   // 2388
    {  0,  0,  0,  0,  0,  0},   // 2389
    {  2,  5,239,  0,  0,  0},   // 2390
    {  3,797,  0,  0,  0,  0},   // 2391
    {  2, 13, 23,  0,  0,  0},   // 2392
    {  0,  0,  0,  0,  0,  0},   // 2393
    {  2,  3,  7, 19,  0,  0},   // 2394
    {  5,479,  0,  0,  0,  0},   // 2395
    {  2,599,  0,  0,  0,  0},   // 2396
    {  3, 17, 47,  0,  0,  0},   // 2397
    {  2, 11,109,  0,  0,  0},   // 2398
    {  0,  0,  0,  0,  0,  0},   // 2399
    {  2,  3,  5,  0,  0,  0},   // 2400
    {  7,  0,  0,  0,  0,  0},   // 2401
    {  2,1201,  0,  0,  0,  0},   // 2402
    {  3, 89,  0,  0,  0,  0},   // 2403
    {  2,601,  0,  0,  0,  0},   // 2404
    {  5, 13, 37,  0,  0,  0},   // 2405
    {  2,  3,401,  0,  0,  0},   // 2406
    { 29, 83,  0,  0,  0,  0},   // 2407
    {  2,  7, 43,  0,  0,  0},   // 2408
    {  3, 11, 73,  0,  0,  0},   // 2409
    {  2,  5,241,  0,  0,  0},   // 2410
    {  0,  0,  0,  0,  0,  0},   // 2411
    {  2,  3, 67,  0,  0,  0},   // 2412
    { 19,127,  0,  0,  0,  0},   // 2413
    {  2, 17, 71,  0,  0,  0},   // 2414
    {  3,  5,  7, 23,  0,  0},   // 2415
    {  2,151,  0,  0,  0,  0},   // 2416
    {  0,  0,  0,  0,  0,  0},   // 2417
    {  2,  3, 13, 31,  0,  0},   // 2418
    { 41, 59,  0,  0,  0,  0},   // 2419
    {  2,  5, 11,  0,  0,  0},   // 2420
    {  3,269,  0,  0,  0,  0},   // 2421
    {  2,  7,173,  0,  0,  0},   // 2422
    {  0,  0,  0,  0,  0,  0},   // 2423
    {  2,  3,101,  0,  0,  0},   // 2424
    {  5, 97,  0,  0,  0,  0},   // 2425
    {  2,1213,  0,  0,  0,  0},   // 2426
    {  3,809,  0,  0,  0,  0},   // 2427
    {  2,607,  0,  0,  0,  0},   // 2428
    {  7,347,  0,  0,  0,  0},   // 2429
    {  2,  3,  5,  0,  0,  0},   // 2430
    { 11, 13, 17,  0,  0,  0},   // 2431
    {  2, 19,  0,  0,  0,  0},   // 2432
    {  3,811,  0,  0,  0,  0},   // 2433
    {  2,1217,  0,  0,  0,  0},   // 2434
    {  5,487,  0,  0,  0,  0},   // 2435
    {  2,  3,  7, 29,  0,  0},   // 2436
    {  0,  0,  0,  0,  0,  0},   // 2437
    {  2, 23, 53,  0,  0,  0},   // 2438
    {  3,271,  0,  0,  0,  0},   // 2439
    {  2,  5, 61,  0,  0,  0},   // 2440
    {  0,  0,  0,  0,  0,  0},   // 2441
    {  2,  3, 11, 37,  0,  0},   // 2442
    {  7,349,  0,  0,  0,  0},   // 2443
    {  2, 13, 47,  0,  0,  0},   // 2444
    {  3,  5,163,  0,  0,  0},   // 2445
    {  2,1223,  0,  0,  0,  0},   // 2446
    {  0,  0,  0,  0,  0,  0},   // 2447
    {  2,  3, 17,  0,  0,  0},   // 2448
    { 31, 79,  0,  0,  0,  0},   // 2449
    {  2,  5,  7,  0,  0,  0},   // 2450
    {  3, 19, 43,  0,  0,  0},   // 2451
    {  2,613,  0,  0,  0,  0},   // 2452
    { 11,223,  0,  0,  0,  0},   // 2453
    {  2,  3,409,  0,  0,  0},   // 2454
    {  5,491,  0,  0,  0,  0},   // 2455
    {  2,307,  0,  0,  0,  0},   // 2456
    {  3,  7, 13,  0,  0,  0},   // 2457
    {  2,1229,  0,  0,  0,  0},   // 2458
    {  0,  0,  0,  0,  0,  0},   // 2459
    {  2,  3,  5, 41,  0,  0},   // 2460
    { 23,107,  0,  0,  0,  0},   // 2461
    {  2,1231,  0,  0,  0,  0},   // 2462
    {  3,821,  0,  0,  0,  0},   // 2463
    {  2,  7, 11,  0,  0,  0},   // 2464
    {  5, 17, 29,  0,  0,  0},   // 2465
    {  2,  3,137,  0,  0,  0},   // 2466
    {  0,  0,  0,  0,  0,  0},   // 2467
    {  2,617,  0,  0,  0,  0},   // 2468
    {  3,823,  0,  0,  0,  0},   // 2469
    {  2,  5, 13, 19,  0,  0},   // 2470
    {  7,353,  0,  0,  0,  0},   // 2471
    {  2,  3,103,  0,  0,  0},   // 2472
    {  0,  0,  0,  0,  0,  0},   // 2473
    {  2,1237,  0,  0,  0,  0},   // 2474
    {  3,  5, 11,  0,  0,  0},   // 2475
    {  2,619,  0,  0,  0,  0},   // 2476
    {  0,  0,  0,  0,  0,  0},   // 2477
    {  2,  3,  7, 59,  0,  0},   // 2478
    { 37, 67,  0,  0,  0,  0},   // 2479
    {  2,  5, 31,  0,  0,  0},   // 2480
    {  3,827,  0,  0,  0,  0},   // 2481
    {  2, 17, 73,  0,  0,  0},   // 2482
    { 13,191,  0,  0,  0,  0},   // 2483
    {  2,  3, 23,  0,  0,  0},   // 2484
    {  5,  7, 71,  0,  0,  0},   // 2485
    {  2, 11,113,  0,  0,  0},   // 2486
    {  3,829,  0,  0,  0,  0},   // 2487
    {  2,311,  0,  0,  0,  0},   // 2488
    { 19,131,  0,  0,  0,  0},   // 2489
    {  2,  3,  5, 83,  0,  0},   // 2490
    { 47, 53,  0,  0,  0,  0},   // 2491
    {  2,  7, 89,  0,  0,  0},   // 2492
    {  3,277,  0,  0,  0,  0},   // 2493
    {  2, 29, 43,  0,  0,  0},   // 2494
    {  5,499,  0,  0,  0,  0},   // 2495
    {  2,  3, 13,  0,  0,  0},   // 2496
    { 11,227,  0,  0,  0,  0},   // 2497
    {  2,1249,  0,  0,  0,  0},   // 2498
    {  3,  7, 17,  0,  0,  0},   // 2499
    {  2,  5,  0,  0,  0,  0},   // 2500
    { 41, 61,  0,  0,  0,  0},   // 2501
    {  2,  3,139,  0,  0,  0},   // 2502
    {  0,  0,  0,  0,  0,  0},   // 2503
    {  2,313,  0,  0,  0,  0},   // 2504
    {  3,  5,167,  0,  0,  0},   // 2505
    {  2,  7,179,  0,  0,  0},   // 2506
    { 23,109,  0,  0,  0,  0},   // 2507
    {  2,  3, 11, 19,  0,  0},   // 2508
    { 13,193,  0,  0,  0,  0},   // 2509
    {  2,  5,251,  0,  0,  0},   // 2510
    {  3, 31,  0,  0,  0,  0},   // 2511
    {  2,157,  0,  0,  0,  0},   // 2512
    {  7,359,  0,  0,  0,  0},   // 2513
    {  2,  3,419,  0,  0,  0},   // 2514
    {  5,503,  0,  0,  0,  0},   // 2515
    {  2, 17, 37,  0,  0,  0},   // 2516
    {  3,839,  0,  0,  0,  0},   // 2517
    {  2,1259,  0,  0,  0,  0},   // 2518
    { 11,229,  0,  0,  0,  0},   // 2519
    {  2,  3,  5,  7,  0,  0},   // 2520
    {  0,  0,  0,  0,  0,  0},   // 2521
    {  2, 13, 97,  0,  0,  0},   // 2522
    {  3, 29,  0,  0,  0,  0},   // 2523
    {  2,631,  0,  0,  0,  0},   // 2524
    {  5,101,  0,  0,  0,  0},   // 2525
    {  2,  3,421,  0,  0,  0},   // 2526
    {  7, 19,  0,  0,  0,  0},   // 2527
    {  2, 79,  0,  0,  0,  0},   // 2528
    {  3,281,  0,  0,  0,  0},   // 2529
    {  2,  5, 11, 23,  0,  0},   // 2530
    {  0,  0,  0,  0,  0,  0},   // 2531
    {  2,  3,211,  0,  0,  0},   // 2532
    { 17,149,  0,  0,  0,  0},   // 2533
    {  2,  7,181,  0,  0,  0},   // 2534
    {  3,  5, 13,  0,  0,  0},   // 2535
    {  2,317,  0,  0,  0,  0},   // 2536
    { 43, 59,  0,  0,  0,  0},   // 2537
    {  2,  3, 47,  0,  0,  0},   // 2538
    {  0,  0,  0,  0,  0,  0},   // 2539
    {  2,  5,127,  0,  0,  0},   // 2540
    {  3,  7, 11,  0,  0,  0},   // 2541
    {  2, 31, 41,  0,  0,  0},   // 2542
    {  0,  0,  0,  0,  0,  0},   // 2543
    {  2,  3, 53,  0,  0,  0},   // 2544
    {  5,509,  0,  0,  0,  0},   // 2545
    {  2, 19, 67,  0,  0,  0},   // 2546
    {  3,283,  0,  0,  0,  0},   // 2547
    {  2,  7, 13,  0,  0,  0},   // 2548
    {  0,  0,  0,  0,  0,  0},   // 2549
    {  2,  3,  5, 17,  0,  0},   // 2550
    {  0,  0,  0,  0,  0,  0},   // 2551
    {  2, 11, 29,  0,  0,  0},   // 2552
    {  3, 23, 37,  0,  0,  0},   // 2553
    {  2,1277,  0,  0,  0,  0},   // 2554
    {  5,  7, 73,  0,  0,  0},   // 2555
    {  2,  3, 71,  0,  0,  0},   // 2556
    {  0,  0,  0,  0,  0,  0},   // 2557
    {  2,1279,  0,  0,  0,  0},   // 2558
    {  3,853,  0,  0,  0,  0},   // 2559
    {  2,  5,  0,  0,  0,  0},   // 2560
    { 13,197,  0,  0,  0,  0},   // 2561
    {  2,  3,  7, 61,  0,  0},   // 2562
    { 11,233,  0,  0,  0,  0},   // 2563
    {  2,641,  0,  0,  0,  0},   // 2564
    {  3,  5, 19,  0,  0,  0},   // 2565
    {  2,1283,  0,  0,  0,  0},   // 2566
    { 17,151,  0,  0,  0,  0},   // 2567
    {  2,  3,107,  0,  0,  0},   // 2568
    {  7,367,  0,  0,  0,  0},   // 2569
    {  2,  5,257,  0,  0,  0},   // 2570
    {  3,857,  0,  0,  0,  0},   // 2571
    {  2,643,  0,  0,  0,  0},   // 2572
    { 31, 83,  0,  0,  0,  0},   // 2573
    {  2,  3, 11, 13,  0,  0},   // 2574
    {  5,103,  0,  0,  0,  0},   // 2575
    {  2,  7, 23,  0,  0,  0},   // 2576
    {  3,859,  0,  0,  0,  0},   // 2577
    {  2,1289,  0,  0,  0,  0},   // 2578
    {  0,  0,  0,  0,  0,  0},   // 2579
    {  2,  3,  5, 43,  0,  0},   // 2580
    { 29, 89,  0,  0,  0,  0},   // 2581
    {  2,1291,  0,  0,  0,  0},   // 2582
    {  3,  7, 41,  0,  0,  0},   // 2583
    {  2, 17, 19,  0,  0,  0},   // 2584
    {  5, 11, 47,  0,  0,  0},   // 2585
    {  2,  3,431,  0,  0,  0},   // 2586
    { 13,199,  0,  0,  0,  0},   // 2587
    {  2,647,  0,  0,  0,  0},   // 2588
    {  3,863,  0,  0,  0,  0},   // 2589
    {  2,  5,  7, 37,  0,  0},   // 2590
    {  0,  0,  0,  0,  0,  0},   // 2591
    {  2,  3,  0,  0,  0,  0},   // 2592
    {  0,  0,  0,  0,  0,  0},   // 2593
    {  2,1297,  0,  0,  0,  0},   // 2594
    {  3,  5,173,  0,  0,  0},   // 2595
    {  2, 11, 59,  0,  0,  0},   // 2596
    {  7, 53,  0,  0,  0,  0},   // 2597
    {  2,  3,433,  0,  0,  0},   // 2598
    { 23,113,  0,  0,  0,  0},   // 2599
    {  2,  5, 13,  0,  0,  0},   // 2600
    {  3, 17,  0,  0,  0,  0},   // 2601
    {  2,1301,  0,  0,  0,  0},   // 2602
    { 19,137,  0,  0,  0,  0},   // 2603
    {  2,  3,  7, 31,  0,  0},   // 2604
    {  5,521,  0,  0,  0,  0},   // 2605
    {  2,1303,  0,  0,  0,  0},   // 2606
    {  3, 11, 79,  0,  0,  0},   // 2607
    {  2,163,  0,  0,  0,  0},   // 2608
    {  0,  0,  0,  0,  0,  0},   // 2609
    {  2,  3,  5, 29,  0,  0},   // 2610
    {  7,373,  0,  0,  0,  0},   // 2611
    {  2,653,  0,  0,  0,  0},   // 2612
    {  3, 13, 67,  0,  0,  0},   // 2613
    {  2,1307,  0,  0,  0,  0},   // 2614
    {  5,523,  0,  0,  0,  0},   // 2615
    {  2,  3,109,  0,  0,  0},   // 2616
    {  0,  0,  0,  0,  0,  0},   // 2617
    {  2,  7, 11, 17,  0,  0},   // 2618
    {  3, 97,  0,  0,  0,  0},   // 2619
    {  2,  5,131,  0,  0,  0},   // 2620
    {  0,  0,  0,  0,  0,  0},   // 2621
    {  2,  3, 19, 23,  0,  0},   // 2622
    { 43, 61,  0,  0,  0,  0},   // 2623
    {  2, 41,  0,  0,  0,  0},   // 2624
    {  3,  5,  7,  0,  0,  0},   // 2625
    {  2, 13,101,  0,  0,  0},   // 2626
    { 37, 71,  0,  0,  0,  0},   // 2627
    {  2,  3, 73,  0,  0,  0},   // 2628
    { 11,239,  0,  0,  0,  0},   // 2629
    {  2,  5,263,  0,  0,  0},   // 2630
    {  3,877,  0,  0,  0,  0},   // 2631
    {  2,  7, 47,  0,  0,  0},   // 2632
    {  0,  0,  0,  0,  0,  0},   // 2633
    {  2,  3,439,  0,  0,  0},   // 2634
    {  5, 17, 31,  0,  0,  0},   // 2635
    {  2,659,  0,  0,  0,  0},   // 2636
    {  3,293,  0,  0,  0,  0},   // 2637
    {  2,1319,  0,  0,  0,  0},   // 2638
    {  7, 13, 29,  0,  0,  0},   // 2639
    {  2,  3,  5, 11,  0,  0},   // 2640
    { 19,139,  0,  0,  0,  0},   // 2641
    {  2,1321,  0,  0,  0,  0},   // 2642
    {  3,881,  0,  0,  0,  0},   // 2643
    {  2,661,  0,  0,  0,  0},   // 2644
    {  5, 23,  0,  0,  0,  0},   // 2645
    {  2,  3,  7,  0,  0,  0},   // 2646
    {  0,  0,  0,  0,  0,  0},   // 2647
    {  2,331,  0,  0,  0,  0},   // 2648
    {  3,883,  0,  0,  0,  0},   // 2649
    {  2,  5, 53,  0,  0,  0},   // 2650
    { 11,241,  0,  0,  0,  0},   // 2651
    {  2,  3, 13, 17,  0,  0},   // 2652
    {  7,379,  0,  0,  0,  0},   // 2653
    {  2,1327,  0,  0,  0,  0},   // 2654
    {  3,  5, 59,  0,  0,  0},   // 2655
    {  2, 83,  0,  0,  0,  0},   // 2656
    {  0,  0,  0,  0,  0,  0},   // 2657
    {  2,  3,443,  0,  0,  0},   // 2658
    {  0,  0,  0,  0,  0,  0},   // 2659
    {  2,  5,  7, 19,  0,  0},   // 2660
    {  3,887,  0,  0,  0,  0},   // 2661
    {  2, 11,  0,  0,  0,  0},   // 2662
    {  0,  0,  0,  0,  0,  0},   // 2663
    {  2,  3, 37,  0,  0,  0},   // 2664
    {  5, 13, 41,  0,  0,  0},   // 2665
    {  2, 31, 43,  0,  0,  0},   // 2666
    {  3,  7,127,  0,  0,  0},   // 2667
    {  2, 23, 29,  0,  0,  0},   // 2668
    { 17,157,  0,  0,  0,  0},   // 2669
    {  2,  3,  5, 89,  0,  0},   // 2670
    {  0,  0,  0,  0,  0,  0},   // 2671
    {  2,167,  0,  0,  0,  0},   // 2672
    {  3, 11,  0,  0,  0,  0},   // 2673
    {  2,  7,191,  0,  0,  0},   // 2674
    {  5,107,  0,  0,  0,  0},   // 2675
    {  2,  3,223,  0,  0,  0},   // 2676
    {  0,  0,  0,  0,  0,  0},   // 2677
    {  2, 13,103,  0,  0,  0},   // 2678
    {  3, 19, 47,  0,  0,  0},   // 2679
    {  2,  5, 67,  0,  0,  0},   // 2680
    {  7,383,  0,  0,  0,  0},   // 2681
    {  2,  3,149,  0,  0,  0},   // 2682
    {  0,  0,  0,  0,  0,  0},   // 2683
    {  2, 11, 61,  0,  0,  0},   // 2684
    {  3,  5,179,  0,  0,  0},   // 2685
    {  2, 17, 79,  0,  0,  0},   // 2686
    {  0,  0,  0,  0,  0,  0},   // 2687
    {  2,  3,  7,  0,  0,  0},   // 2688
    {  0,  0,  0,  0,  0,  0},   // 2689
    {  2,  5,269,  0,  0,  0},   // 2690
    {  3, 13, 23,  0,  0,  0},   // 2691
    {  2,673,  0,  0,  0,  0},   // 2692
    {  0,  0,  0,  0,  0,  0},   // 2693
    {  2,  3,449,  0,  0,  0},   // 2694
    {  5,  7, 11,  0,  0,  0},   // 2695
    {  2,337,  0,  0,  0,  0},   // 2696
    {  3, 29, 31,  0,  0,  0},   // 2697
    {  2, 19, 71,  0,  0,  0},   // 2698
    {  0,  0,  0,  0,  0,  0},   // 2699
    {  2,  3,  5,  0,  0,  0},   // 2700
    { 37, 73,  0,  0,  0,  0},   // 2701
    {  2,  7,193,  0,  0,  0},   // 2702
    {  3, 17, 53,  0,  0,  0},   // 2703
    {  2, 13,  0,  0,  0,  0},   // 2704
    {  5,541,  0,  0,  0,  0},   // 2705
    {  2,  3, 11, 41,  0,  0},   // 2706
    {  0,  0,  0,  0,  0,  0},   // 2707
    {  2,677,  0,  0,  0,  0},   // 2708
    {  3,  7, 43,  0,  0,  0},   // 2709
    {  2,  5,271,  0,  0,  0},   // 2710
    {  0,  0,  0,  0,  0,  0},   // 2711
    {  2,  3,113,  0,  0,  0},   // 2712
    {  0,  0,  0,  0,  0,  0},   // 2713
    {  2, 23, 59,  0,  0,  0},   // 2714
    {  3,  5,181,  0,  0,  0},   // 2715
    {  2,  7, 97,  0,  0,  0},   // 2716
    { 11, 13, 19,  0,  0,  0},   // 2717
    {  2,  3,151,  0,  0,  0},   // 2718
    {  0,  0,  0,  0,  0,  0},   // 2719
    {  2,  5, 17,  0,  0,  0},   // 2720
    {  3,907,  0,  0,  0,  0},   // 2721
    {  2,1361,  0,  0,  0,  0},   // 2722
    {  7,389,  0,  0,  0,  0},   // 2723
    {  2,  3,227,  0,  0,  0},   // 2724
    {  5,109,  0,  0,  0,  0},   // 2725
    {  2, 29, 47,  0,  0,  0},   // 2726
    {  3,101,  0,  0,  0,  0},   // 2727
    {  2, 11, 31,  0,  0,  0},   // 2728
    {  0,  0,  0,  0,  0,  0},   // 2729
    {  2,  3,  5,  7, 13,  0},   // 2730
    {  0,  0,  0,  0,  0,  0},   // 2731
    {  2,683,  0,  0,  0,  0},   // 2732
    {  3,911,  0,  0,  0,  0},   // 2733
    {  2,1367,  0,  0,  0,  0},   // 2734
    {  5,547,  0,  0,  0,  0},   // 2735
    {  2,  3, 19,  0,  0,  0},   // 2736
    {  7, 17, 23,  0,  0,  0},   // 2737
    {  2, 37,  0,  0,  0,  0},   // 2738
    {  3, 11, 83,  0,  0,  0},   // 2739
    {  2,  5,137,  0,  0,  0},   // 2740
    {  0,  0,  0,  0,  0,  0},   // 2741
    {  2,  3,457,  0,  0,  0},   // 2742
    { 13,211,  0,  0,  0,  0},   // 2743
    {  2,  7,  0,  0,  0,  0},   // 2744
    {  3,  5, 61,  0,  0,  0},   // 2745
    {  2,1373,  0,  0,  0,  0},   // 2746
    { 41, 67,  0,  0,  0,  0},   // 2747
    {  2,  3,229,  0,  0,  0},   // 2748
    {  0,  0,  0,  0,  0,  0},   // 2749
    {  2,  5, 11,  0,  0,  0},   // 2750
    {  3,  7,131,  0,  0,  0},   // 2751
    {  2, 43,  0,  0,  0,  0},   // 2752
    {  0,  0,  0,  0,  0,  0},   // 2753
    {  2,  3, 17,  0,  0,  0},   // 2754
    {  5, 19, 29,  0,  0,  0},   // 2755
    {  2, 13, 53,  0,  0,  0},   // 2756
    {  3,919,  0,  0,  0,  0},   // 2757
    {  2,  7,197,  0,  0,  0},   // 2758
    { 31, 89,  0,  0,  0,  0},   // 2759
    {  2,  3,  5, 23,  0,  0},   // 2760
    { 11,251,  0,  0,  0,  0},   // 2761
    {  2,1381,  0,  0,  0,  0},   // 2762
    {  3,307,  0,  0,  0,  0},   // 2763
    {  2,691,  0,  0,  0,  0},   // 2764
    {  5,  7, 79,  0,  0,  0},   // 2765
    {  2,  3,461,  0,  0,  0},   // 2766
    {  0,  0,  0,  0,  0,  0},   // 2767
    {  2,173,  0,  0,  0,  0},   // 2768
    {  3, 13, 71,  0,  0,  0},   // 2769
    {  2,  5,277,  0,  0,  0},   // 2770
    { 17,163,  0,  0,  0,  0},   // 2771
    {  2,  3,  7, 11,  0,  0},   // 2772
    { 47, 59,  0,  0,  0,  0},   // 2773
    {  2, 19, 73,  0,  0,  0},   // 2774
    {  3,  5, 37,  0,  0,  0},   // 2775
    {  2,347,  0,  0,  0,  0},   // 2776
    {  0,  0,  0,  0,  0,  0},   // 2777
    {  2,  3,463,  0,  0,  0},   // 2778
    {  7,397,  0,  0,  0,  0},   // 2779
    {  2,  5,139,  0,  0,  0},   // 2780
    {  3,103,  0,  0,  0,  0},   // 2781
    {  2, 13,107,  0,  0,  0},   // 2782
    { 11, 23,  0,  0,  0,  0},   // 2783
    {  2,  3, 29,  0,  0,  0},   // 2784
    {  5,557,  0,  0,  0,  0},   // 2785
    {  2,  7,199,  0,  0,  0},   // 2786
    {  3,929,  0,  0,  0,  0},   // 2787
    {  2, 17, 41,  0,  0,  0},   // 2788
    {  0,  0,  0,  0,  0,  0},   // 2789
    {  2,  3,  5, 31,  0,  0},   // 2790
    {  0,  0,  0,  0,  0,  0},   // 2791
    {  2,349,  0,  0,  0,  0},   // 2792
    {  3,  7, 19,  0,  0,  0},   // 2793
    {  2, 11,127,  0,  0,  0},   // 2794
    {  5, 13, 43,  0,  0,  0},   // 2795
    {  2,  3,233,  0,  0,  0},   // 2796
    {  0,  0,  0,  0,  0,  0},   // 2797
    {  2,1399,  0,  0,  0,  0},   // 2798
    {  3,311,  0,  0,  0,  0},   // 2799
    {  2,  5,  7,  0,  0,  0},   // 2800
    {  0,  0,  0,  0,  0,  0},   // 2801
    {  2,  3,467,  0,  0,  0},   // 2802
    {  0,  0,  0,  0,  0,  0},   // 2803
    {  2,701,  0,  0,  0,  0},   // 2804
    {  3,  5, 11, 17,  0,  0},   // 2805
    {  2, 23, 61,  0,  0,  0},   // 2806
    {  7,401,  0,  0,  0,  0},   // 2807
    {  2,  3, 13,  0,  0,  0},   // 2808
    { 53,  0,  0,  0,  0,  0},   // 2809
    {  2,  5,281,  0,  0,  0},   // 2810
    {  3,937,  0,  0,  0,  0},   // 2811
    {  2, 19, 37,  0,  0,  0},   // 2812
    { 29, 97,  0,  0,  0,  0},   // 2813
    {  2,  3,  7, 67,  0,  0},   // 2814
    {  5,563,  0,  0,  0,  0},   // 2815
    {  2, 11,  0,  0,  0,  0},   // 2816
    {  3,313,  0,  0,  0,  0},   // 2817
    {  2,1409,  0,  0,  0,  0},   // 2818
    {  0,  0,  0,  0,  0,  0},   // 2819
    {  2,  3,  5, 47,  0,  0},   // 2820
    {  7, 13, 31,  0,  0,  0},   // 2821
    {  2, 17, 83,  0,  0,  0},   // 2822
    {  3,941,  0,  0,  0,  0},   // 2823
    {  2,353,  0,  0,  0,  0},   // 2824
    {  5,113,  0,  0,  0,  0},   // 2825
    {  2,  3,157,  0,  0,  0},   // 2826
    { 11,257,  0,  0,  0,  0},   // 2827
    {  2,  7,101,  0,  0,  0},   // 2828
    {  3, 23, 41,  0,  0,  0},   // 2829
    {  2,  5,283,  0,  0,  0},   // 2830
    { 19,149,  0,  0,  0,  0},   // 2831
    {  2,  3, 59,  0,  0,  0},   // 2832
    {  0,  0,  0,  0,  0,  0},   // 2833
    {  2, 13,109,  0,  0,  0},   // 2834
    {  3,  5,  7,  0,  0,  0},   // 2835
    {  2,709,  0,  0,  0,  0},   // 2836
    {  0,  0,  0,  0,  0,  0},   // 2837
    {  2,  3, 11, 43,  0,  0},   // 2838
    { 17,167,  0,  0,  0,  0},   // 2839
    {  2,  5, 71,  0,  0,  0},   // 2840
    {  3,947,  0,  0,  0,  0},   // 2841
    {  2,  7, 29,  0,  0,  0},   // 2842
    {  0,  0,  0,  0,  0,  0},   // 2843
    {  2,  3, 79,  0,  0,  0},   // 2844
    {  5,569,  0,  0,  0,  0},   // 2845
    {  2,1423,  0,  0,  0,  0},   // 2846
    {  3, 13, 73,  0,  0,  0},   // 2847
    {  2, 89,  0,  0,  0,  0},   // 2848
    {  7, 11, 37,  0,  0,  0},   // 2849
    {  2,  3,  5, 19,  0,  0},   // 2850
    {  0,  0,  0,  0,  0,  0},   // 2851
    {  2, 23, 31,  0,  0,  0},   // 2852
    {  3,317,  0,  0,  0,  0},   // 2853
    {  2,1427,  0,  0,  0,  0},   // 2854
    {  5,571,  0,  0,  0,  0},   // 2855
    {  2,  3,  7, 17,  0,  0},   // 2856
    {  0,  0,  0,  0,  0,  0},   // 2857
    {  2,1429,  0,  0,  0,  0},   // 2858
    {  3,953,  0,  0,  0,  0},   // 2859
    {  2,  5, 11, 13,  0,  0},   // 2860
    {  0,  0,  0,  0,  0,  0},   // 2861
    {  2,  3, 53,  0,  0,  0},   // 2862
    {  7,409,  0,  0,  0,  0},   // 2863
    {  2,179,  0,  0,  0,  0},   // 2864
    {  3,  5,191,  0,  0,  0},   // 2865
    {  2,1433,  0,  0,  0,  0},   // 2866
    { 47, 61,  0,  0,  0,  0},   // 2867
    {  2,  3,239,  0,  0,  0},   // 2868
    { 19,151,  0,  0,  0,  0},   // 2869
    {  2,  5,  7, 41,  0,  0},   // 2870
    {  3, 11, 29,  0,  0,  0},   // 2871
    {  2,359,  0,  0,  0,  0},   // 2872
    { 13, 17,  0,  0,  0,  0},   // 2873
    {  2,  3,479,  0,  0,  0},   // 2874
    {  5, 23,  0,  0,  0,  0},   // 2875
    {  2,719,  0,  0,  0,  0},   // 2876
    {  3,  7,137,  0,  0,  0},   // 2877
    {  2,1439,  0,  0,  0,  0},   // 2878
    {  0,  0,  0,  0,  0,  0},   // 2879
    {  2,  3,  5,  0,  0,  0},   // 2880
    { 43, 67,  0,  0,  0,  0},   // 2881
    {  2, 11,131,  0,  0,  0},   // 2882
    {  3, 31,  0,  0,  0,  0},   // 2883
    {  2,  7,103,  0,  0,  0},   // 2884
    {  5,577,  0,  0,  0,  0},   // 2885
    {  2,  3, 13, 37,  0,  0},   // 2886
    {  0,  0,  0,  0,  0,  0},   // 2887
    {  2, 19,  0,  0,  0,  0},   // 2888
    {  3,107,  0,  0,  0,  0},   // 2889
    {  2,  5, 17,  0,  0,  0},   // 2890
    {  7, 59,  0,  0,  0,  0},   // 2891
    {  2,  3,241,  0,  0,  0},   // 2892
    { 11,263,  0,  0,  0,  0},   // 2893
    {  2,1447,  0,  0,  0,  0},   // 2894
    {  3,  5,193,  0,  0,  0},   // 2895
    {  2,181,  0,  0,  0,  0},   // 2896
    {  0,  0,  0,  0,  0,  0},   // 2897
    {  2,  3,  7, 23,  0,  0},   // 2898
    { 13,223,  0,  0,  0,  0},   // 2899
    {  2,  5, 29,  0,  0,  0},   // 2900
    {  3,967,  0,  0,  0,  0},   // 2901
    {  2,1451,  0,  0,  0,  0},   // 2902
    {  0,  0,  0,  0,  0,  0},   // 2903
    {  2,  3, 11,  0,  0,  0},   // 2904
    {  5,  7, 83,  0,  0,  0},   // 2905
    {  2,1453,  0,  0,  0,  0},   // 2906
    {  3, 17, 19,  0,  0,  0},   // 2907
    {  2,727,  0,  0,  0,  0},   // 2908
    {  0,  0,  0,  0,  0,  0},   // 2909
    {  2,  3,  5, 97,  0,  0},   // 2910
    { 41, 71,  0,  0,  0,  0},   // 2911
    {  2,  7, 13,  0,  0,  0},   // 2912
    {  3,971,  0,  0,  0,  0},   // 2913
    {  2, 31, 47,  0,  0,  0},   // 2914
    {  5, 11, 53,  0,  0,  0},   // 2915
    {  2,  3,  0,  0,  0,  0},   // 2916
    {  0,  0,  0,  0,  0,  0},   // 2917
    {  2,1459,  0,  0,  0,  0},   // 2918
    {  3,  7,139,  0,  0,  0},   // 2919
    {  2,  5, 73,  0,  0,  0},   // 2920
    { 23,127,  0,  0,  0,  0},   // 2921
    {  2,  3,487,  0,  0,  0},   // 2922
    { 37, 79,  0,  0,  0,  0},   // 2923
    {  2, 17, 43,  0,  0,  0},   // 2924
    {  3,  5, 13,  0,  0,  0},   // 2925
    {  2,  7, 11, 19,  0,  0},   // 2926
    {  0,  0,  0,  0,  0,  0},   // 2927
    {  2,  3, 61,  0,  0,  0},   // 2928
    { 29,101,  0,  0,  0,  0},   // 2929
    {  2,  5,293,  0,  0,  0},   // 2930
    {  3,977,  0,  0,  0,  0},   // 2931
    {  2,733,  0,  0,  0,  0},   // 2932
    {  7,419,  0,  0,  0,  0},   // 2933
    {  2,  3,163,  0,  0,  0},   // 2934
    {  5,587,  0,  0,  0,  0},   // 2935
    {  2,367,  0,  0,  0,  0},   // 2936
    {  3, 11, 89,  0,  0,  0},   // 2937
    {  2, 13,113,  0,  0,  0},   // 2938
    {  0,  0,  0,  0,  0,  0},   // 2939
    {  2,  3,  5,  7,  0,  0},   // 2940
    { 17,173,  0,  0,  0,  0},   // 2941
    {  2,1471,  0,  0,  0,  0},   // 2942
    {  3,109,  0,  0,  0,  0},   // 2943
    {  2, 23,  0,  0,  0,  0},   // 2944
    {  5, 19, 31,  0,  0,  0},   // 2945
    {  2,  3,491,  0,  0,  0},   // 2946
    {  7,421,  0,  0,  0,  0},   // 2947
    {  2, 11, 67,  0,  0,  0},   // 2948
    {  3,983,  0,  0,  0,  0},   // 2949
    {  2,  5, 59,  0,  0,  0},   // 2950
    { 13,227,  0,  0,  0,  0},   // 2951
    {  2,  3, 41,  0,  0,  0},   // 2952
    {  0,  0,  0,  0,  0,  0},   // 2953
    {  2,  7,211,  0,  0,  0},   // 2954
    {  3,  5,197,  0,  0,  0},   // 2955
    {  2,739,  0,  0,  0,  0},   // 2956
    {  0,  0,  0,  0,  0,  0},   // 2957
    {  2,  3, 17, 29,  0,  0},   // 2958
    { 11,269,  0,  0,  0,  0},   // 2959
    {  2,  5, 37,  0,  0,  0},   // 2960
    {  3,  7, 47,  0,  0,  0},   // 2961
    {  2,1481,  0,  0,  0,  0},   // 2962
    {  0,  0,  0,  0,  0,  0},   // 2963
    {  2,  3, 13, 19,  0,  0},   // 2964
    {  5,593,  0,  0,  0,  0},   // 2965
    {  2,1483,  0,  0,  0,  0},   // 2966
    {  3, 23, 43,  0,  0,  0},   // 2967
    {  2,  7, 53,  0,  0,  0},   // 2968
    {  0,  0,  0,  0,  0,  0},   // 2969
    {  2,  3,  5, 11,  0,  0},   // 2970
    {  0,  0,  0,  0,  0,  0},   // 2971
    {  2,743,  0,  0,  0,  0},   // 2972
    {  3,991,  0,  0,  0,  0},   // 2973
    {  2,1487,  0,  0,  0,  0},   // 2974
    {  5,  7, 17,  0,  0,  0},   // 2975
    {  2,  3, 31,  0,  0,  0},   // 2976
    { 13,229,  0,  0,  0,  0},   // 2977
    {  2,1489,  0,  0,  0,  0},   // 2978
    {  3,331,  0,  0,  0,  0},   // 2979
    {  2,  5,149,  0,  0,  0},   // 2980
    { 11,271,  0,  0,  0,  0},   // 2981
    {  2,  3,  7, 71,  0,  0},   // 2982
    { 19,157,  0,  0,  0,  0},   // 2983
    {  2,373,  0,  0,  0,  0},   // 2984
    {  3,  5,199,  0,  0,  0},   // 2985
    {  2,1493,  0,  0,  0,  0},   // 2986
    { 29,103,  0,  0,  0,  0},   // 2987
    {  2,  3, 83,  0,  0,  0},   // 2988
    {  7, 61,  0,  0,  0,  0},   // 2989
    {  2,  5, 13, 23,  0,  0},   // 2990
    {  3,997,  0,  0,  0,  0},   // 2991
    {  2, 11, 17,  0,  0,  0},   // 2992
    { 41, 73,  0,  0,  0,  0},   // 2993
    {  2,  3,499,  0,  0,  0},   // 2994
    {  5,599,  0,  0,  0,  0},   // 2995
    {  2,  7,107,  0,  0,  0},   // 2996
    {  3, 37,  0,  0,  0,  0},   // 2997
    {  2,1499,  0,  0,  0,  0},   // 2998
    {  0,  0,  0,  0,  0,  0},   // 2999
    {  2,  3,  5,  0,  0,  0},   // 3000
    {  0,  0,  0,  0,  0,  0},   // 3001
    {  2, 19, 79,  0,  0,  0},   // 3002
    {  3,  7, 11, 13,  0,  0},   // 3003
    {  2,751,  0,  0,  0,  0},   // 3004
    {  5,601,  0,  0,  0,  0},   // 3005
    {  2,  3,167,  0,  0,  0},   // 3006
    { 31, 97,  0,  0,  0,  0},   // 3007
    {  2, 47,  0,  0,  0,  0},   // 3008
    {  3, 17, 59,  0,  0,  0},   // 3009
    {  2,  5,  7, 43,  0,  0},   // 3010
    {  0,  0,  0,  0,  0,  0},   // 3011
    {  2,  3,251,  0,  0,  0},   // 3012
    { 23,131,  0,  0,  0,  0},   // 3013
    {  2, 11,137,  0,  0,  0},   // 3014
    {  3,  5, 67,  0,  0,  0},   // 3015
    {  2, 13, 29,  0,  0,  0},   // 3016
    {  7,431,  0,  0,  0,  0},   // 3017
    {  2,  3,503,  0,  0,  0},   // 3018
    {  0,  0,  0,  0,  0,  0},   // 3019
    {  2,  5,151,  0,  0,  0},   // 3020
    {  3, 19, 53,  0,  0,  0},   // 3021
    {  2,1511,  0,  0,  0,  0},   // 3022
    {  0,  0,  0,  0,  0,  0},   // 3023
    {  2,  3,  7,  0,  0,  0},   // 3024
    {  5, 11,  0,  0,  0,  0},   // 3025
    {  2, 17, 89,  0,  0,  0},   // 3026
    {  3,1009,  0,  0,  0,  0},   // 3027
    {  2,757,  0,  0,  0,  0},   // 3028
    { 13,233,  0,  0,  0,  0},   // 3029
    {  2,  3,  5,101,  0,  0},   // 3030
    {  7,433,  0,  0,  0,  0},   // 3031
    {  2,379,  0,  0,  0,  0},   // 3032
    {  3,337,  0,  0,  0,  0},   // 3033
    {  2, 37, 41,  0,  0,  0},   // 3034
    {  5,607,  0,  0,  0,  0},   // 3035
    {  2,  3, 11, 23,  0,  0},   // 3036
    {  0,  0,  0,  0,  0,  0},   // 3037
    {  2,  7, 31,  0,  0,  0},   // 3038
    {  3,1013,  0,  0,  0,  0},   // 3039
    {  2,  5, 19,  0,  0,  0},   // 3040
    {  0,  0,  0,  0,  0,  0},   // 3041
    {  2,  3, 13,  0,  0,  0},   // 3042
    { 17,179,  0,  0,  0,  0},   // 3043
    {  2,761,  0,  0,  0,  0},   // 3044
    {  3,  5,  7, 29,  0,  0},   // 3045
    {  2,1523,  0,  0,  0,  0},   // 3046
    { 11,277,  0,  0,  0,  0},   // 3047
    {  2,  3,127,  0,  0,  0},   // 3048
    {  0,  0,  0,  0,  0,  0},   // 3049
    {  2,  5, 61,  0,  0,  0},   // 3050
    {  3,113,  0,  0,  0,  0},   // 3051
    {  2,  7,109,  0,  0,  0},   // 3052
    { 43, 71,  0,  0,  0,  0},   // 3053
    {  2,  3,509,  0,  0,  0},   // 3054
    {  5, 13, 47,  0,  0,  0},   // 3055
    {  2,191,  0,  0,  0,  0},   // 3056
    {  3,1019,  0,  0,  0,  0},   // 3057
    {  2, 11,139,  0,  0,  0},   // 3058
    {  7, 19, 23,  0,  0,  0},   // 3059
    {  2,  3,  5, 17,  0,  0},   // 3060
    {  0,  0,  0,  0,  0,  0},   // 3061
    {  2,1531,  0,  0,  0,  0},   // 3062
    {  3,1021,  0,  0,  0,  0},   // 3063
    {  2,383,  0,  0,  0,  0},   // 3064
    {  5,613,  0,  0,  0,  0},   // 3065
    {  2,  3,  7, 73,  0,  0},   // 3066
    {  0,  0,  0,  0,  0,  0},   // 3067
    {  2, 13, 59,  0,  0,  0},   // 3068
    {  3, 11, 31,  0,  0,  0},   // 3069
    {  2,  5,307,  0,  0,  0},   // 3070
    { 37, 83,  0,  0,  0,  0},   // 3071
    {  2,  3,  0,  0,  0,  0},   // 3072
    {  7,439,  0,  0,  0,  0},   // 3073
    {  2, 29, 53,  0,  0,  0},   // 3074
    {  3,  5, 41,  0,  0,  0},   // 3075
    {  2,769,  0,  0,  0,  0},   // 3076
    { 17,181,  0,  0,  0,  0},   // 3077
    {  2,  3, 19,  0,  0,  0},   // 3078
    {  0,  0,  0,  0,  0,  0},   // 3079
    {  2,  5,  7, 11,  0,  0},   // 3080
    {  3, 13, 79,  0,  0,  0},   // 3081
    {  2, 23, 67,  0,  0,  0},   // 3082
    {  0,  0,  0,  0,  0,  0},   // 3083
    {  2,  3,257,  0,  0,  0},   // 3084
    {  5,617,  0,  0,  0,  0},   // 3085
    {  2,1543,  0,  0,  0,  0},   // 3086
    {  3,  7,  0,  0,  0,  0},   // 3087
    {  2,193,  0,  0,  0,  0},   // 3088
    {  0,  0,  0,  0,  0,  0},   // 3089
    {  2,  3,  5,103,  0,  0},   // 3090
    { 11,281,  0,  0,  0,  0},   // 3091
    {  2,773,  0,  0,  0,  0},   // 3092
    {  3,1031,  0,  0,  0,  0},   // 3093
    {  2,  7, 13, 17,  0,  0},   // 3094
    {  5,619,  0,  0,  0,  0},   // 3095
    {  2,  3, 43,  0,  0,  0},   // 3096
    { 19,163,  0,  0,  0,  0},   // 3097
    {  2,1549,  0,  0,  0,  0},   // 3098
    {  3,1033,  0,  0,  0,  0},   // 3099
    {  2,  5, 31,  0,  0,  0},   // 3100
    {  7,443,  0,  0,  0,  0},   // 3101
    {  2,  3, 11, 47,  0,  0},   // 3102
    { 29,107,  0,  0,  0,  0},   // 3103
    {  2, 97,  0,  0,  0,  0},   // 3104
    {  3,  5, 23,  0,  0,  0},   // 3105
    {  2,1553,  0,  0,  0,  0},   // 3106
    { 13,239,  0,  0,  0,  0},   // 3107
    {  2,  3,  7, 37,  0,  0},   // 3108
    {  0,  0,  0,  0,  0,  0},   // 3109
    {  2,  5,311,  0,  0,  0},   // 3110
    {  3, 17, 61,  0,  0,  0},   // 3111
    {  2,389,  0,  0,  0,  0},   // 3112
    { 11,283,  0,  0,  0,  0},   // 3113
    {  2,  3,173,  0,  0,  0},   // 3114
    {  5,  7, 89,  0,  0,  0},   // 3115
    {  2, 19, 41,  0,  0,  0},   // 3116
    {  3,1039,  0,  0,  0,  0},   // 3117
    {  2,1559,  0,  0,  0,  0},   // 3118
    {  0,  0,  0,  0,  0,  0},   // 3119
    {  2,  3,  5, 13,  0,  0},   // 3120
    {  0,  0,  0,  0,  0,  0},   // 3121
    {  2,  7,223,  0,  0,  0},   // 3122
    {  3,347,  0,  0,  0,  0},   // 3123
    {  2, 11, 71,  0,  0,  0},   // 3124
    {  5,  0,  0,  0,  0,  0},   // 3125
    {  2,  3,521,  0,  0,  0},   // 3126
    { 53, 59,  0,  0,  0,  0},   // 3127
    {  2, 17, 23,  0,  0,  0},   // 3128
    {  3,  7,149,  0,  0,  0},   // 3129
    {  2,  5,313,  0,  0,  0},   // 3130
    { 31,101,  0,  0,  0,  0},   // 3131
    {  2,  3, 29,  0,  0,  0},   // 3132
    { 13,241,  0,  0,  0,  0},   // 3133
    {  2,1567,  0,  0,  0,  0},   // 3134
    {  3,  5, 11, 19,  0,  0},   // 3135
    {  2,  7,  0,  0,  0,  0},   // 3136
    {  0,  0,  0,  0,  0,  0},   // 3137
    {  2,  3,523,  0,  0,  0},   // 3138
    { 43, 73,  0,  0,  0,  0},   // 3139
    {  2,  5,157,  0,  0,  0},   // 3140
    {  3,349,  0,  0,  0,  0},   // 3141
    {  2,1571,  0,  0,  0,  0},   // 3142
    {  7,449,  0,  0,  0,  0},   // 3143
    {  2,  3,131,  0,  0,  0},   // 3144
    {  5, 17, 37,  0,  0,  0},   // 3145
    {  2, 11, 13,  0,  0,  0},   // 3146
    {  3,1049,  0,  0,  0,  0},   // 3147
    {  2,787,  0,  0,  0,  0},   // 3148
    { 47, 67,  0,  0,  0,  0},   // 3149
    {  2,  3,  5,  7,  0,  0},   // 3150
    { 23,137,  0,  0,  0,  0},   // 3151
    {  2,197,  0,  0,  0,  0},   // 3152
    {  3,1051,  0,  0,  0,  0},   // 3153
    {  2, 19, 83,  0,  0,  0},   // 3154
    {  5,631,  0,  0,  0,  0},   // 3155
    {  2,  3,263,  0,  0,  0},   // 3156
    {  7, 11, 41,  0,  0,  0},   // 3157
    {  2,1579,  0,  0,  0,  0},   // 3158
    {  3, 13,  0,  0,  0,  0},   // 3159
    {  2,  5, 79,  0,  0,  0},   // 3160
    { 29,109,  0,  0,  0,  0},   // 3161
    {  2,  3, 17, 31,  0,  0},   // 3162
    {  0,  0,  0,  0,  0,  0},   // 3163
    {  2,  7,113,  0,  0,  0},   // 3164
    {  3,  5,211,  0,  0,  0},   // 3165
    {  2,1583,  0,  0,  0,  0},   // 3166
    {  0,  0,  0,  0,  0,  0},   // 3167
    {  2,  3, 11,  0,  0,  0},   // 3168
    {  0,  0,  0,  0,  0,  0},   // 3169
    {  2,  5,317,  0,  0,  0},   // 3170
    {  3,  7,151,  0,  0,  0},   // 3171
    {  2, 13, 61,  0,  0,  0},   // 3172
    { 19,167,  0,  0,  0,  0},   // 3173
    {  2,  3, 23,  0,  0,  0},   // 3174
    {  5,127,  0,  0,  0,  0},   // 3175
    {  2,397,  0,  0,  0,  0},   // 3176
    {  3,353,  0,  0,  0,  0},   // 3177
    {  2,  7,227,  0,  0,  0},   // 3178
    { 11, 17,  0,  0,  0,  0},   // 3179
    {  2,  3,  5, 53,  0,  0},   // 3180
    {  0,  0,  0,  0,  0,  0},   // 3181
    {  2, 37, 43,  0,  0,  0},   // 3182
    {  3,1061,  0,  0,  0,  0},   // 3183
    {  2,199,  0,  0,  0,  0},   // 3184
    {  5,  7, 13,  0,  0,  0},   // 3185
    {  2,  3, 59,  0,  0,  0},   // 3186
    {  0,  0,  0,  0,  0,  0},   // 3187
    {  2,797,  0,  0,  0,  0},   // 3188
    {  3,1063,  0,  0,  0,  0},   // 3189
    {  2,  5, 11, 29,  0,  0},   // 3190
    {  0,  0,  0,  0,  0,  0},   // 3191
    {  2,  3,  7, 19,  0,  0},   // 3192
    { 31,103,  0,  0,  0,  0},   // 3193
    {  2,1597,  0,  0,  0,  0},   // 3194
    {  3,  5, 71,  0,  0,  0},   // 3195
    {  2, 17, 47,  0,  0,  0},   // 3196
    { 23,139,  0,  0,  0,  0},   // 3197
    {  2,  3, 13, 41,  0,  0},   // 3198
    {  7,457,  0,  0,  0,  0},   // 3199
    {  2,  5,  0,  0,  0,  0},   // 3200
    {  3, 11, 97,  0,  0,  0},   // 3201
    {  2,1601,  0,  0,  0,  0},   // 3202
    {  0,  0,  0,  0,  0,  0},   // 3203
    {  2,  3, 89,  0,  0,  0},   // 3204
    {  5,641,  0,  0,  0,  0},   // 3205
    {  2,  7,229,  0,  0,  0},   // 3206
    {  3,1069,  0,  0,  0,  0},   // 3207
    {  2,401,  0,  0,  0,  0},   // 3208
    {  0,  0,  0,  0,  0,  0},   // 3209
    {  2,  3,  5,107,  0,  0},   // 3210
    { 13, 19,  0,  0,  0,  0},   // 3211
    {  2, 11, 73,  0,  0,  0},   // 3212
    {  3,  7, 17,  0,  0,  0},   // 3213
    {  2,1607,  0,  0,  0,  0},   // 3214
    {  5,643,  0,  0,  0,  0},   // 3215
    {  2,  3, 67,  0,  0,  0},   // 3216
    {  0,  0,  0,  0,  0,  0},   // 3217
    {  2,1609,  0,  0,  0,  0},   // 3218
    {  3, 29, 37,  0,  0,  0},   // 3219
    {  2,  5,  7, 23,  0,  0},   // 3220
    {  0,  0,  0,  0,  0,  0},   // 3221
    {  2,  3,179,  0,  0,  0},   // 3222
    { 11,293,  0,  0,  0,  0},   // 3223
    {  2, 13, 31,  0,  0,  0},   // 3224
    {  3,  5, 43,  0,  0,  0},   // 3225
    {  2,1613,  0,  0,  0,  0},   // 3226
    {  7,461,  0,  0,  0,  0},   // 3227
    {  2,  3,269,  0,  0,  0},   // 3228
    {  0,  0,  0,  0,  0,  0},   // 3229
    {  2,  5, 17, 19,  0,  0},   // 3230
    {  3,359,  0,  0,  0,  0},   // 3231
    {  2,101,  0,  0,  0,  0},   // 3232
    { 53, 61,  0,  0,  0,  0},   // 3233
    {  2,  3,  7, 11,  0,  0},   // 3234
    {  5,647,  0,  0,  0,  0},   // 3235
    {  2,809,  0,  0,  0,  0},   // 3236
    {  3, 13, 83,  0,  0,  0},   // 3237
    {  2,1619,  0,  0,  0,  0},   // 3238
    { 41, 79,  0,  0,  0,  0},   // 3239
    {  2,  3,  5,  0,  0,  0},   // 3240
    {  7,463,  0,  0,  0,  0},   // 3241
    {  2,1621,  0,  0,  0,  0},   // 3242
    {  3, 23, 47,  0,  0,  0},   // 3243
    {  2,811,  0,  0,  0,  0},   // 3244
    {  5, 11, 59,  0,  0,  0},   // 3245
    {  2,  3,541,  0,  0,  0},   // 3246
    { 17,191,  0,  0,  0,  0},   // 3247
    {  2,  7, 29,  0,  0,  0},   // 3248
    {  3, 19,  0,  0,  0,  0},   // 3249
    {  2,  5, 13,  0,  0,  0},   // 3250
    {  0,  0,  0,  0,  0,  0},   // 3251
    {  2,  3,271,  0,  0,  0},   // 3252
    {  0,  0,  0,  0,  0,  0},   // 3253
    {  2,1627,  0,  0,  0,  0},   // 3254
    {  3,  5,  7, 31,  0,  0},   // 3255
    {  2, 11, 37,  0,  0,  0},   // 3256
    {  0,  0,  0,  0,  0,  0},   // 3257
    {  2,  3,181,  0,  0,  0},   // 3258
    {  0,  0,  0,  0,  0,  0},   // 3259
    {  2,  5,163,  0,  0,  0},   // 3260
    {  3,1087,  0,  0,  0,  0},   // 3261
    {  2,  7,233,  0,  0,  0},   // 3262
    { 13,251,  0,  0,  0,  0},   // 3263
    {  2,  3, 17,  0,  0,  0},   // 3264
    {  5,653,  0,  0,  0,  0},   // 3265
    {  2, 23, 71,  0,  0,  0},   // 3266
    {  3, 11,  0,  0,  0,  0},   // 3267
    {  2, 19, 43,  0,  0,  0},   // 3268
    {  7,467,  0,  0,  0,  0},   // 3269
    {  2,  3,  5,109,  0,  0},   // 3270
    {  0,  0,  0,  0,  0,  0},   // 3271
    {  2,409,  0,  0,  0,  0},   // 3272
    {  3,1091,  0,  0,  0,  0},   // 3273
    {  2,1637,  0,  0,  0,  0},   // 3274
    {  5,131,  0,  0,  0,  0},   // 3275
    {  2,  3,  7, 13,  0,  0},   // 3276
    { 29,113,  0,  0,  0,  0},   // 3277
    {  2, 11,149,  0,  0,  0},   // 3278
    {  3,1093,  0,  0,  0,  0},   // 3279
    {  2,  5, 41,  0,  0,  0},   // 3280
    { 17,193,  0,  0,  0,  0},   // 3281
    {  2,  3,547,  0,  0,  0},   // 3282
    {  7, 67,  0,  0,  0,  0},   // 3283
    {  2,821,  0,  0,  0,  0},   // 3284
    {  3,  5, 73,  0,  0,  0},   // 3285
    {  2, 31, 53,  0,  0,  0},   // 3286
    { 19,173,  0,  0,  0,  0},   // 3287
    {  2,  3,137,  0,  0,  0},   // 3288
    { 11, 13, 23,  0,  0,  0},   // 3289
    {  2,  5,  7, 47,  0,  0},   // 3290
    {  3,1097,  0,  0,  0,  0},   // 3291
    {  2,823,  0,  0,  0,  0},   // 3292
    { 37, 89,  0,  0,  0,  0},   // 3293
    {  2,  3, 61,  0,  0,  0},   // 3294
    {  5,659,  0,  0,  0,  0},   // 3295
    {  2,103,  0,  0,  0,  0},   // 3296
    {  3,  7,157,  0,  0,  0},   // 3297
    {  2, 17, 97,  0,  0,  0},   // 3298
    {  0,  0,  0,  0,  0,  0},   // 3299
    {  2,  3,  5, 11,  0,  0},   // 3300
    {  0,  0,  0,  0,  0,  0},   // 3301
    {  2, 13,127,  0,  0,  0},   // 3302
    {  3,367,  0,  0,  0,  0},   // 3303
    {  2,  7, 59,  0,  0,  0},   // 3304
    {  5,661,  0,  0,  0,  0},   // 3305
    {  2,  3, 19, 29,  0,  0},   // 3306
    {  0,  0,  0,  0,  0,  0},   // 3307
    {  2,827,  0,  0,  0,  0},   // 3308
    {  3,1103,  0,  0,  0,  0},   // 3309
    {  2,  5,331,  0,  0,  0},   // 3310
    {  7, 11, 43,  0,  0,  0},   // 3311
    {  2,  3, 23,  0,  0,  0},   // 3312
    {  0,  0,  0,  0,  0,  0},   // 3313
    {  2,1657,  0,  0,  0,  0},   // 3314
    {  3,  5, 13, 17,  0,  0},   // 3315
    {  2,829,  0,  0,  0,  0},   // 3316
    { 31,107,  0,  0,  0,  0},   // 3317
    {  2,  3,  7, 79,  0,  0},   // 3318
    {  0,  0,  0,  0,  0,  0},   // 3319
    {  2,  5, 83,  0,  0,  0},   // 3320
    {  3, 41,  0,  0,  0,  0},   // 3321
    {  2, 11,151,  0,  0,  0},   // 3322
    {  0,  0,  0,  0,  0,  0},   // 3323
    {  2,  3,277,  0,  0,  0},   // 3324
    {  5,  7, 19,  0,  0,  0},   // 3325
    {  2,1663,  0,  0,  0,  0},   // 3326
    {  3,1109,  0,  0,  0,  0},   // 3327
    {  2, 13,  0,  0,  0,  0},   // 3328
    {  0,  0,  0,  0,  0,  0},   // 3329
    {  2,  3,  5, 37,  0,  0},   // 3330
    {  0,  0,  0,  0,  0,  0},   // 3331
    {  2,  7, 17,  0,  0,  0},   // 3332
    {  3, 11,101,  0,  0,  0},   // 3333
    {  2,1667,  0,  0,  0,  0},   // 3334
    {  5, 23, 29,  0,  0,  0},   // 3335
    {  2,  3,139,  0,  0,  0},   // 3336
    { 47, 71,  0,  0,  0,  0},   // 3337
    {  2,1669,  0,  0,  0,  0},   // 3338
    {  3,  7, 53,  0,  0,  0},   // 3339
    {  2,  5,167,  0,  0,  0},   // 3340
    { 13,257,  0,  0,  0,  0},   // 3341
    {  2,  3,557,  0,  0,  0},   // 3342
    {  0,  0,  0,  0,  0,  0},   // 3343
    {  2, 11, 19,  0,  0,  0},   // 3344
    {  3,  5,223,  0,  0,  0},   // 3345
    {  2,  7,239,  0,  0,  0},   // 3346
    {  0,  0,  0,  0,  0,  0},   // 3347
    {  2,  3, 31,  0,  0,  0},   // 3348
    { 17,197,  0,  0,  0,  0},   // 3349
    {  2,  5, 67,  0,  0,  0},   // 3350
    {  3,1117,  0,  0,  0,  0},   // 3351
    {  2,419,  0,  0,  0,  0},   // 3352
    {  7,479,  0,  0,  0,  0},   // 3353
    {  2,  3, 13, 43,  0,  0},   // 3354
    {  5, 11, 61,  0,  0,  0},   // 3355
    {  2,839,  0,  0,  0,  0},   // 3356
    {  3,373,  0,  0,  0,  0},   // 3357
    {  2, 23, 73,  0,  0,  0},   // 3358
    {  0,  0,  0,  0,  0,  0},   // 3359
    {  2,  3,  5,  7,  0,  0},   // 3360
    {  0,  0,  0,  0,  0,  0},   // 3361
    {  2, 41,  0,  0,  0,  0},   // 3362
    {  3, 19, 59,  0,  0,  0},   // 3363
    {  2, 29,  0,  0,  0,  0},   // 3364
    {  5,673,  0,  0,  0,  0},   // 3365
    {  2,  3, 11, 17,  0,  0},   // 3366
    {  7, 13, 37,  0,  0,  0},   // 3367
    {  2,421,  0,  0,  0,  0},   // 3368
    {  3,1123,  0,  0,  0,  0},   // 3369
    {  2,  5,337,  0,  0,  0},   // 3370
    {  0,  0,  0,  0,  0,  0},   // 3371
    {  2,  3,281,  0,  0,  0},   // 3372
    {  0,  0,  0,  0,  0,  0},   // 3373
    {  2,  7,241,  0,  0,  0},   // 3374
    {  3,  5,  0,  0,  0,  0},   // 3375
    {  2,211,  0,  0,  0,  0},   // 3376
    { 11,307,  0,  0,  0,  0},   // 3377
    {  2,  3,563,  0,  0,  0},   // 3378
    { 31,109,  0,  0,  0,  0},   // 3379
    {  2,  5, 13,  0,  0,  0},   // 3380
    {  3,  7, 23,  0,  0,  0},   // 3381
    {  2, 19, 89,  0,  0,  0},   // 3382
    { 17,199,  0,  0,  0,  0},   // 3383
    {  2,  3, 47,  0,  0,  0},   // 3384
    {  5,677,  0,  0,  0,  0},   // 3385
    {  2,1693,  0,  0,  0,  0},   // 3386
    {  3,1129,  0,  0,  0,  0},   // 3387
    {  2,  7, 11,  0,  0,  0},   // 3388
    {  0,  0,  0,  0,  0,  0},   // 3389
    {  2,  3,  5,113,  0,  0},   // 3390
    {  0,  0,  0,  0,  0,  0},   // 3391
    {  2, 53,  0,  0,  0,  0},   // 3392
    {  3, 13, 29,  0,  0,  0},   // 3393
    {  2,1697,  0,  0,  0,  0},   // 3394
    {  5,  7, 97,  0,  0,  0},   // 3395
    {  2,  3,283,  0,  0,  0},   // 3396
    { 43, 79,  0,  0,  0,  0},   // 3397
    {  2,1699,  0,  0,  0,  0},   // 3398
    {  3, 11,103,  0,  0,  0},   // 3399
    {  2,  5, 17,  0,  0,  0},   // 3400
    { 19,179,  0,  0,  0,  0},   // 3401
    {  2,  3,  7,  0,  0,  0},   // 3402
    { 41, 83,  0,  0,  0,  0},   // 3403
    {  2, 23, 37,  0,  0,  0},   // 3404
    {  3,  5,227,  0,  0,  0},   // 3405
    {  2, 13,131,  0,  0,  0},   // 3406
    {  0,  0,  0,  0,  0,  0},   // 3407
    {  2,  3, 71,  0,  0,  0},   // 3408
    {  7,487,  0,  0,  0,  0},   // 3409
    {  2,  5, 11, 31,  0,  0},   // 3410
    {  3,379,  0,  0,  0,  0},   // 3411
    {  2,853,  0,  0,  0,  0},   // 3412
    {  0,  0,  0,  0,  0,  0},   // 3413
    {  2,  3,569,  0,  0,  0},   // 3414
    {  5,683,  0,  0,  0,  0},   // 3415
    {  2,  7, 61,  0,  0,  0},   // 3416
    {  3, 17, 67,  0,  0,  0},   // 3417
    {  2,1709,  0,  0,  0,  0},   // 3418
    { 13,263,  0,  0,  0,  0},   // 3419
    {  2,  3,  5, 19,  0,  0},   // 3420
    { 11,311,  0,  0,  0,  0},   // 3421
    {  2, 29, 59,  0,  0,  0},   // 3422
    {  3,  7,163,  0,  0,  0},   // 3423
    {  2,107,  0,  0,  0,  0},   // 3424
    {  5,137,  0,  0,  0,  0},   // 3425
    {  2,  3,571,  0,  0,  0},   // 3426
    { 23,149,  0,  0,  0,  0},   // 3427
    {  2,857,  0,  0,  0,  0},   // 3428
    {  3,127,  0,  0,  0,  0},   // 3429
    {  2,  5,  7,  0,  0,  0},   // 3430
    { 47, 73,  0,  0,  0,  0},   // 3431
    {  2,  3, 11, 13,  0,  0},   // 3432
    {  0,  0,  0,  0,  0,  0},   // 3433
    {  2, 17,101,  0,  0,  0},   // 3434
    {  3,  5,229,  0,  0,  0},   // 3435
    {  2,859,  0,  0,  0,  0},   // 3436
    {  7,491,  0,  0,  0,  0},   // 3437
    {  2,  3,191,  0,  0,  0},   // 3438
    { 19,181,  0,  0,  0,  0},   // 3439
    {  2,  5, 43,  0,  0,  0},   // 3440
    {  3, 31, 37,  0,  0,  0},   // 3441
    {  2,1721,  0,  0,  0,  0},   // 3442
    { 11,313,  0,  0,  0,  0},   // 3443
    {  2,  3,  7, 41,  0,  0},   // 3444
    {  5, 13, 53,  0,  0,  0},   // 3445
    {  2,1723,  0,  0,  0,  0},   // 3446
    {  3,383,  0,  0,  0,  0},   // 3447
    {  2,431,  0,  0,  0,  0},   // 3448
    {  0,  0,  0,  0,  0,  0},   // 3449
    {  2,  3,  5, 23,  0,  0},   // 3450
    {  7, 17, 29,  0,  0,  0},   // 3451
    {  2,863,  0,  0,  0,  0},   // 3452
    {  3,1151,  0,  0,  0,  0},   // 3453
    {  2, 11,157,  0,  0,  0},   // 3454
    {  5,691,  0,  0,  0,  0},   // 3455
    {  2,  3,  0,  0,  0,  0},   // 3456
    {  0,  0,  0,  0,  0,  0},   // 3457
    {  2,  7, 13, 19,  0,  0},   // 3458
    {  3,1153,  0,  0,  0,  0},   // 3459
    {  2,  5,173,  0,  0,  0},   // 3460
    {  0,  0,  0,  0,  0,  0},   // 3461
    {  2,  3,577,  0,  0,  0},   // 3462
    {  0,  0,  0,  0,  0,  0},   // 3463
    {  2,433,  0,  0,  0,  0},   // 3464
    {  3,  5,  7, 11,  0,  0},   // 3465
    {  2,1733,  0,  0,  0,  0},   // 3466
    {  0,  0,  0,  0,  0,  0},   // 3467
    {  2,  3, 17,  0,  0,  0},   // 3468
    {  0,  0,  0,  0,  0,  0},   // 3469
    {  2,  5,347,  0,  0,  0},   // 3470
    {  3, 13, 89,  0,  0,  0},   // 3471
    {  2,  7, 31,  0,  0,  0},   // 3472
    { 23,151,  0,  0,  0,  0},   // 3473
    {  2,  3,193,  0,  0,  0},   // 3474
    {  5,139,  0,  0,  0,  0},   // 3475
    {  2, 11, 79,  0,  0,  0},   // 3476
    {  3, 19, 61,  0,  0,  0},   // 3477
    {  2, 37, 47,  0,  0,  0},   // 3478
    {  7, 71,  0,  0,  0,  0},   // 3479
    {  2,  3,  5, 29,  0,  0},   // 3480
    { 59,  0,  0,  0,  0,  0},   // 3481
    {  2,1741,  0,  0,  0,  0},   // 3482
    {  3, 43,  0,  0,  0,  0},   // 3483
    {  2, 13, 67,  0,  0,  0},   // 3484
    {  5, 17, 41,  0,  0,  0},   // 3485
    {  2,  3,  7, 83,  0,  0},   // 3486
    { 11,317,  0,  0,  0,  0},   // 3487
    {  2,109,  0,  0,  0,  0},   // 3488
    {  3,1163,  0,  0,  0,  0},   // 3489
    {  2,  5,349,  0,  0,  0},   // 3490
    {  0,  0,  0,  0,  0,  0},   // 3491
    {  2,  3, 97,  0,  0,  0},   // 3492
    {  7,499,  0,  0,  0,  0},   // 3493
    {  2,1747,  0,  0,  0,  0},   // 3494
    {  3,  5,233,  0,  0,  0},   // 3495
    {  2, 19, 23,  0,  0,  0},   // 3496
    { 13,269,  0,  0,  0,  0},   // 3497
    {  2,  3, 11, 53,  0,  0},   // 3498
    {  0,  0,  0,  0,  0,  0},   // 3499
    {  2,  5,  7,  0,  0,  0},   // 3500
    {  3,389,  0,  0,  0,  0},   // 3501
    {  2, 17,103,  0,  0,  0},   // 3502
    { 31,113,  0,  0,  0,  0},   // 3503
    {  2,  3, 73,  0,  0,  0},   // 3504
    {  5,701,  0,  0,  0,  0},   // 3505
    {  2,1753,  0,  0,  0,  0},   // 3506
    {  3,  7,167,  0,  0,  0},   // 3507
    {  2,877,  0,  0,  0,  0},   // 3508
    { 11, 29,  0,  0,  0,  0},   // 3509
    {  2,  3,  5, 13,  0,  0},   // 3510
    {  0,  0,  0,  0,  0,  0},   // 3511
    {  2,439,  0,  0,  0,  0},   // 3512
    {  3,1171,  0,  0,  0,  0},   // 3513
    {  2,  7,251,  0,  0,  0},   // 3514
    {  5, 19, 37,  0,  0,  0},   // 3515
    {  2,  3,293,  0,  0,  0},   // 3516
    {  0,  0,  0,  0,  0,  0},   // 3517
    {  2,1759,  0,  0,  0,  0},   // 3518
    {  3, 17, 23,  0,  0,  0},   // 3519
    {  2,  5, 11,  0,  0,  0},   // 3520
    {  7,503,  0,  0,  0,  0},   // 3521
    {  2,  3,587,  0,  0,  0},   // 3522
    { 13,271,  0,  0,  0,  0},   // 3523
    {  2,881,  0,  0,  0,  0},   // 3524
    {  3,  5, 47,  0,  0,  0},   // 3525
    {  2, 41, 43,  0,  0,  0},   // 3526
    {  0,  0,  0,  0,  0,  0},   // 3527
    {  2,  3,  7,  0,  0,  0},   // 3528
    {  0,  0,  0,  0,  0,  0},   // 3529
    {  2,  5,353,  0,  0,  0},   // 3530
    {  3, 11,107,  0,  0,  0},   // 3531
    {  2,883,  0,  0,  0,  0},   // 3532
    {  0,  0,  0,  0,  0,  0},   // 3533
    {  2,  3, 19, 31,  0,  0},   // 3534
    {  5,  7,101,  0,  0,  0},   // 3535
    {  2, 13, 17,  0,  0,  0},   // 3536
    {  3,131,  0,  0,  0,  0},   // 3537
    {  2, 29, 61,  0,  0,  0},   // 3538
    {  0,  0,  0,  0,  0,  0},   // 3539
    {  2,  3,  5, 59,  0,  0},   // 3540
    {  0,  0,  0,  0,  0,  0},   // 3541
    {  2,  7, 11, 23,  0,  0},   // 3542
    {  3,1181,  0,  0,  0,  0},   // 3543
    {  2,443,  0,  0,  0,  0},   // 3544
    {  5,709,  0,  0,  0,  0},   // 3545
    {  2,  3,197,  0,  0,  0},   // 3546
    {  0,  0,  0,  0,  0,  0},   // 3547
    {  2,887,  0,  0,  0,  0},   // 3548
    {  3,  7, 13,  0,  0,  0},   // 3549
    {  2,  5, 71,  0,  0,  0},   // 3550
    { 53, 67,  0,  0,  0,  0},   // 3551
    {  2,  3, 37,  0,  0,  0},   // 3552
    { 11, 17, 19,  0,  0,  0},   // 3553
    {  2,1777,  0,  0,  0,  0},   // 3554
    {  3,  5, 79,  0,  0,  0},   // 3555
    {  2,  7,127,  0,  0,  0},   // 3556
    {  0,  0,  0,  0,  0,  0},   // 3557
    {  2,  3,593,  0,  0,  0},   // 3558
    {  0,  0,  0,  0,  0,  0},   // 3559
    {  2,  5, 89,  0,  0,  0},   // 3560
    {  3,1187,  0,  0,  0,  0},   // 3561
    {  2, 13,137,  0,  0,  0},   // 3562
    {  7,509,  0,  0,  0,  0},   // 3563
    {  2,  3, 11,  0,  0,  0},   // 3564
    {  5, 23, 31,  0,  0,  0},   // 3565
    {  2,1783,  0,  0,  0,  0},   // 3566
    {  3, 29, 41,  0,  0,  0},   // 3567
    {  2,223,  0,  0,  0,  0},   // 3568
    { 43, 83,  0,  0,  0,  0},   // 3569
    {  2,  3,  5,  7, 17,  0},   // 3570
    {  0,  0,  0,  0,  0,  0},   // 3571
    {  2, 19, 47,  0,  0,  0},   // 3572
    {  3,397,  0,  0,  0,  0},   // 3573
    {  2,1787,  0,  0,  0,  0},   // 3574
    {  5, 11, 13,  0,  0,  0},   // 3575
    {  2,  3,149,  0,  0,  0},   // 3576
    {  7, 73,  0,  0,  0,  0},   // 3577
    {  2,1789,  0,  0,  0,  0},   // 3578
    {  3,1193,  0,  0,  0,  0},   // 3579
    {  2,  5,179,  0,  0,  0},   // 3580
    {  0,  0,  0,  0,  0,  0},   // 3581
    {  2,  3,199,  0,  0,  0},   // 3582
    {  0,  0,  0,  0,  0,  0},   // 3583
    {  2,  7,  0,  0,  0,  0},   // 3584
    {  3,  5,239,  0,  0,  0},   // 3585
    {  2, 11,163,  0,  0,  0},   // 3586
    { 17,211,  0,  0,  0,  0},   // 3587
    {  2,  3, 13, 23,  0,  0},   // 3588
    { 37, 97,  0,  0,  0,  0},   // 3589
    {  2,  5,359,  0,  0,  0},   // 3590
    {  3,  7, 19,  0,  0,  0},   // 3591
    {  2,449,  0,  0,  0,  0},   // 3592
    {  0,  0,  0,  0,  0,  0},   // 3593
    {  2,  3,599,  0,  0,  0},   // 3594
    {  5,719,  0,  0,  0,  0},   // 3595
    {  2, 29, 31,  0,  0,  0},   // 3596
    {  3, 11,109,  0,  0,  0},   // 3597
    {  2,  7,257,  0,  0,  0},   // 3598
    { 59, 61,  0,  0,  0,  0},   // 3599
    {  2,  3,  5,  0,  0,  0},   // 3600
    { 13,277,  0,  0,  0,  0},   // 3601
    {  2,1801,  0,  0,  0,  0},   // 3602
    {  3,1201,  0,  0,  0,  0},   // 3603
    {  2, 17, 53,  0,  0,  0},   // 3604
    {  5,  7,103,  0,  0,  0},   // 3605
    {  2,  3,601,  0,  0,  0},   // 3606
    {  0,  0,  0,  0,  0,  0},   // 3607
    {  2, 11, 41,  0,  0,  0},   // 3608
    {  3,401,  0,  0,  0,  0},   // 3609
    {  2,  5, 19,  0,  0,  0},   // 3610
    { 23,157,  0,  0,  0,  0},   // 3611
    {  2,  3,  7, 43,  0,  0},   // 3612
    {  0,  0,  0,  0,  0,  0},   // 3613
    {  2, 13,139,  0,  0,  0},   // 3614
    {  3,  5,241,  0,  0,  0},   // 3615
    {  2,113,  0,  0,  0,  0},   // 3616
    {  0,  0,  0,  0,  0,  0},   // 3617
    {  2,  3, 67,  0,  0,  0},   // 3618
    {  7, 11, 47,  0,  0,  0},   // 3619
    {  2,  5,181,  0,  0,  0},   // 3620
    {  3, 17, 71,  0,  0,  0},   // 3621
    {  2,1811,  0,  0,  0,  0},   // 3622
    {  0,  0,  0,  0,  0,  0},   // 3623
    {  2,  3,151,  0,  0,  0},   // 3624
    {  5, 29,  0,  0,  0,  0},   // 3625
    {  2,  7, 37,  0,  0,  0},   // 3626
    {  3, 13, 31,  0,  0,  0},   // 3627
    {  2,907,  0,  0,  0,  0},   // 3628
    { 19,191,  0,  0,  0,  0},   // 3629
    {  2,  3,  5, 11,  0,  0},   // 3630
    {  0,  0,  0,  0,  0,  0},   // 3631
    {  2,227,  0,  0,  0,  0},   // 3632
    {  3,  7,173,  0,  0,  0},   // 3633
    {  2, 23, 79,  0,  0,  0},   // 3634
    {  5,727,  0,  0,  0,  0},   // 3635
    {  2,  3,101,  0,  0,  0},   // 3636
    {  0,  0,  0,  0,  0,  0},   // 3637
    {  2, 17,107,  0,  0,  0},   // 3638
    {  3,1213,  0,  0,  0,  0},   // 3639
    {  2,  5,  7, 13,  0,  0},   // 3640
    { 11,331,  0,  0,  0,  0},   // 3641
    {  2,  3,607,  0,  0,  0},   // 3642
    {  0,  0,  0,  0,  0,  0},   // 3643
    {  2,911,  0,  0,  0,  0},   // 3644
    {  3,  5,  0,  0,  0,  0},   // 3645
    {  2,1823,  0,  0,  0,  0},   // 3646
    {  7,521,  0,  0,  0,  0},   // 3647
    {  2,  3, 19,  0,  0,  0},   // 3648
    { 41, 89,  0,  0,  0,  0},   // 3649
    {  2,  5, 73,  0,  0,  0},   // 3650
    {  3,1217,  0,  0,  0,  0},   // 3651
    {  2, 11, 83,  0,  0,  0},   // 3652
    { 13,281,  0,  0,  0,  0},   // 3653
    {  2,  3,  7, 29,  0,  0},   // 3654
    {  5, 17, 43,  0,  0,  0},   // 3655
    {  2,457,  0,  0,  0,  0},   // 3656
    {  3, 23, 53,  0,  0,  0},   // 3657
    {  2, 31, 59,  0,  0,  0},   // 3658
    {  0,  0,  0,  0,  0,  0},   // 3659
    {  2,  3,  5, 61,  0,  0},   // 3660
    {  7,523,  0,  0,  0,  0},   // 3661
    {  2,1831,  0,  0,  0,  0},   // 3662
    {  3, 11, 37,  0,  0,  0},   // 3663
    {  2,229,  0,  0,  0,  0},   // 3664
    {  5,733,  0,  0,  0,  0},   // 3665
    {  2,  3, 13, 47,  0,  0},   // 3666
    { 19,193,  0,  0,  0,  0},   // 3667
    {  2,  7,131,  0,  0,  0},   // 3668
    {  3,1223,  0,  0,  0,  0},   // 3669
    {  2,  5,367,  0,  0,  0},   // 3670
    {  0,  0,  0,  0,  0,  0},   // 3671
    {  2,  3, 17,  0,  0,  0},   // 3672
    {  0,  0,  0,  0,  0,  0},   // 3673
    {  2, 11,167,  0,  0,  0},   // 3674
    {  3,  5,  7,  0,  0,  0},   // 3675
    {  2,919,  0,  0,  0,  0},   // 3676
    {  0,  0,  0,  0,  0,  0},   // 3677
    {  2,  3,613,  0,  0,  0},   // 3678
    { 13,283,  0,  0,  0,  0},   // 3679
    {  2,  5, 23,  0,  0,  0},   // 3680
    {  3,409,  0,  0,  0,  0},   // 3681
    {  2,  7,263,  0,  0,  0},   // 3682
    { 29,127,  0,  0,  0,  0},   // 3683
    {  2,  3,307,  0,  0,  0},   // 3684
    {  5, 11, 67,  0,  0,  0},   // 3685
    {  2, 19, 97,  0,  0,  0},   // 3686
    {  3,1229,  0,  0,  0,  0},   // 3687
    {  2,461,  0,  0,  0,  0},   // 3688
    {  7, 17, 31,  0,  0,  0},   // 3689
    {  2,  3,  5, 41,  0,  0},   // 3690
    {  0,  0,  0,  0,  0,  0},   // 3691
    {  2, 13, 71,  0,  0,  0},   // 3692
    {  3,1231,  0,  0,  0,  0},   // 3693
    {  2,1847,  0,  0,  0,  0},   // 3694
    {  5,739,  0,  0,  0,  0},   // 3695
    {  2,  3,  7, 11,  0,  0},   // 3696
    {  0,  0,  0,  0,  0,  0},   // 3697
    {  2, 43,  0,  0,  0,  0},   // 3698
    {  3,137,  0,  0,  0,  0},   // 3699
    {  2,  5, 37,  0,  0,  0},   // 3700
    {  0,  0,  0,  0,  0,  0},   // 3701
    {  2,  3,617,  0,  0,  0},   // 3702
    {  7, 23,  0,  0,  0,  0},   // 3703
    {  2,463,  0,  0,  0,  0},   // 3704
    {  3,  5, 13, 19,  0,  0},   // 3705
    {  2, 17,109,  0,  0,  0},   // 3706
    { 11,337,  0,  0,  0,  0},   // 3707
    {  2,  3,103,  0,  0,  0},   // 3708
    {  0,  0,  0,  0,  0,  0},   // 3709
    {  2,  5,  7, 53,  0,  0},   // 3710
    {  3,1237,  0,  0,  0,  0},   // 3711
    {  2, 29,  0,  0,  0,  0},   // 3712
    { 47, 79,  0,  0,  0,  0},   // 3713
    {  2,  3,619,  0,  0,  0},   // 3714
    {  5,743,  0,  0,  0,  0},   // 3715
    {  2,929,  0,  0,  0,  0},   // 3716
    {  3,  7, 59,  0,  0,  0},   // 3717
    {  2, 11, 13,  0,  0,  0},   // 3718
    {  0,  0,  0,  0,  0,  0},   // 3719
    {  2,  3,  5, 31,  0,  0},   // 3720
    { 61,  0,  0,  0,  0,  0},   // 3721
    {  2,1861,  0,  0,  0,  0},   // 3722
    {  3, 17, 73,  0,  0,  0},   // 3723
    {  2,  7, 19,  0,  0,  0},   // 3724
    {  5,149,  0,  0,  0,  0},   // 3725
    {  2,  3, 23,  0,  0,  0},   // 3726
    {  0,  0,  0,  0,  0,  0},   // 3727
    {  2,233,  0,  0,  0,  0},   // 3728
    {  3, 11,113,  0,  0,  0},   // 3729
    {  2,  5,373,  0,  0,  0},   // 3730
    {  7, 13, 41,  0,  0,  0},   // 3731
    {  2,  3,311,  0,  0,  0},   // 3732
    {  0,  0,  0,  0,  0,  0},   // 3733
    {  2,1867,  0,  0,  0,  0},   // 3734
    {  3,  5, 83,  0,  0,  0},   // 3735
    {  2,467,  0,  0,  0,  0},   // 3736
    { 37,101,  0,  0,  0,  0},   // 3737
    {  2,  3,  7, 89,  0,  0},   // 3738
    {  0,  0,  0,  0,  0,  0},   // 3739
    {  2,  5, 11, 17,  0,  0},   // 3740
    {  3, 29, 43,  0,  0,  0},   // 3741
    {  2,1871,  0,  0,  0,  0},   // 3742
    { 19,197,  0,  0,  0,  0},   // 3743
    {  2,  3, 13,  0,  0,  0},   // 3744
    {  5,  7,107,  0,  0,  0},   // 3745
    {  2,1873,  0,  0,  0,  0},   // 3746
    {  3,1249,  0,  0,  0,  0},   // 3747
    {  2,937,  0,  0,  0,  0},   // 3748
    { 23,163,  0,  0,  0,  0},   // 3749
    {  2,  3,  5,  0,  0,  0},   // 3750
    { 11, 31,  0,  0,  0,  0},   // 3751
    {  2,  7, 67,  0,  0,  0},   // 3752
    {  3,139,  0,  0,  0,  0},   // 3753
    {  2,1877,  0,  0,  0,  0},   // 3754
    {  5,751,  0,  0,  0,  0},   // 3755
    {  2,  3,313,  0,  0,  0},   // 3756
    { 13, 17,  0,  0,  0,  0},   // 3757
    {  2,1879,  0,  0,  0,  0},   // 3758
    {  3,  7,179,  0,  0,  0},   // 3759
    {  2,  5, 47,  0,  0,  0},   // 3760
    {  0,  0,  0,  0,  0,  0},   // 3761
    {  2,  3, 11, 19,  0,  0},   // 3762
    { 53, 71,  0,  0,  0,  0},   // 3763
    {  2,941,  0,  0,  0,  0},   // 3764
    {  3,  5,251,  0,  0,  0},   // 3765
    {  2,  7,269,  0,  0,  0},   // 3766
    {  0,  0,  0,  0,  0,  0},   // 3767
    {  2,  3,157,  0,  0,  0},   // 3768
    {  0,  0,  0,  0,  0,  0},   // 3769
    {  2,  5, 13, 29,  0,  0},   // 3770
    {  3,419,  0,  0,  0,  0},   // 3771
    {  2, 23, 41,  0,  0,  0},   // 3772
    {  7, 11,  0,  0,  0,  0},   // 3773
    {  2,  3, 17, 37,  0,  0},   // 3774
    {  5,151,  0,  0,  0,  0},   // 3775
    {  2, 59,  0,  0,  0,  0},   // 3776
    {  3,1259,  0,  0,  0,  0},   // 3777
    {  2,1889,  0,  0,  0,  0},   // 3778
    {  0,  0,  0,  0,  0,  0},   // 3779
    {  2,  3,  5,  7,  0,  0},   // 3780
    { 19,199,  0,  0,  0,  0},   // 3781
    {  2, 31, 61,  0,  0,  0},   // 3782
    {  3, 13, 97,  0,  0,  0},   // 3783
    {  2, 11, 43,  0,  0,  0},   // 3784
    {  5,757,  0,  0,  0,  0},   // 3785
    {  2,  3,631,  0,  0,  0},   // 3786
    {  7,541,  0,  0,  0,  0},   // 3787
    {  2,947,  0,  0,  0,  0},   // 3788
    {  3,421,  0,  0,  0,  0},   // 3789
    {  2,  5,379,  0,  0,  0},   // 3790
    { 17,223,  0,  0,  0,  0},   // 3791
    {  2,  3, 79,  0,  0,  0},   // 3792
    {  0,  0,  0,  0,  0,  0},   // 3793
    {  2,  7,271,  0,  0,  0},   // 3794
    {  3,  5, 11, 23,  0,  0},   // 3795
    {  2, 13, 73,  0,  0,  0},   // 3796
    {  0,  0,  0,  0,  0,  0},   // 3797
    {  2,  3,211,  0,  0,  0},   // 3798
    { 29,131,  0,  0,  0,  0},   // 3799
    {  2,  5, 19,  0,  0,  0},   // 3800
    {  3,  7,181,  0,  0,  0},   // 3801
    {  2,1901,  0,  0,  0,  0},   // 3802
    {  0,  0,  0,  0,  0,  0},   // 3803
    {  2,  3,317,  0,  0,  0},   // 3804
    {  5,761,  0,  0,  0,  0},   // 3805
    {  2, 11,173,  0,  0,  0},   // 3806
    {  3, 47,  0,  0,  0,  0},   // 3807
    {  2,  7, 17,  0,  0,  0},   // 3808
    { 13,293,  0,  0,  0,  0},   // 3809
    {  2,  3,  5,127,  0,  0},   // 3810
    { 37,103,  0,  0,  0,  0},   // 3811
    {  2,953,  0,  0,  0,  0},   // 3812
    {  3, 31, 41,  0,  0,  0},   // 3813
    {  2,1907,  0,  0,  0,  0},   // 3814
    {  5,  7,109,  0,  0,  0},   // 3815
    {  2,  3, 53,  0,  0,  0},   // 3816
    { 11,347,  0,  0,  0,  0},   // 3817
    {  2, 23, 83,  0,  0,  0},   // 3818
    {  3, 19, 67,  0,  0,  0},   // 3819
    {  2,  5,191,  0,  0,  0},   // 3820
    {  0,  0,  0,  0,  0,  0},   // 3821
    {  2,  3,  7, 13,  0,  0},   // 3822
    {  0,  0,  0,  0,  0,  0},   // 3823
    {  2,239,  0,  0,  0,  0},   // 3824
    {  3,  5, 17,  0,  0,  0},   // 3825
    {  2,1913,  0,  0,  0,  0},   // 3826
    { 43, 89,  0,  0,  0,  0},   // 3827
    {  2,  3, 11, 29,  0,  0},   // 3828
    {  7,547,  0,  0,  0,  0},   // 3829
    {  2,  5,383,  0,  0,  0},   // 3830
    {  3,1277,  0,  0,  0,  0},   // 3831
    {  2,479,  0,  0,  0,  0},   // 3832
    {  0,  0,  0,  0,  0,  0},   // 3833
    {  2,  3, 71,  0,  0,  0},   // 3834
    {  5, 13, 59,  0,  0,  0},   // 3835
    {  2,  7,137,  0,  0,  0},   // 3836
    {  3,1279,  0,  0,  0,  0},   // 3837
    {  2, 19,101,  0,  0,  0},   // 3838
    { 11,349,  0,  0,  0,  0},   // 3839
    {  2,  3,  5,  0,  0,  0},   // 3840
    { 23,167,  0,  0,  0,  0},   // 3841
    {  2, 17,113,  0,  0,  0},   // 3842
    {  3,  7, 61,  0,  0,  0},   // 3843
    {  2, 31,  0,  0,  0,  0},   // 3844
    {  5,769,  0,  0,  0,  0},   // 3845
    {  2,  3,641,  0,  0,  0},   // 3846
    {  0,  0,  0,  0,  0,  0},   // 3847
    {  2, 13, 37,  0,  0,  0},   // 3848
    {  3,1283,  0,  0,  0,  0},   // 3849
    {  2,  5,  7, 11,  0,  0},   // 3850
    {  0,  0,  0,  0,  0,  0},   // 3851
    {  2,  3,107,  0,  0,  0},   // 3852
    {  0,  0,  0,  0,  0,  0},   // 3853
    {  2, 41, 47,  0,  0,  0},   // 3854
    {  3,  5,257,  0,  0,  0},   // 3855
    {  2,241,  0,  0,  0,  0},   // 3856
    {  7, 19, 29,  0,  0,  0},   // 3857
    {  2,  3,643,  0,  0,  0},   // 3858
    { 17,227,  0,  0,  0,  0},   // 3859
    {  2,  5,193,  0,  0,  0},   // 3860
    {  3, 11, 13,  0,  0,  0},   // 3861
    {  2,1931,  0,  0,  0,  0},   // 3862
    {  0,  0,  0,  0,  0,  0},   // 3863
    {  2,  3,  7, 23,  0,  0},   // 3864
    {  5,773,  0,  0,  0,  0},   // 3865
    {  2,1933,  0,  0,  0,  0},   // 3866
    {  3,1289,  0,  0,  0,  0},   // 3867
    {  2,967,  0,  0,  0,  0},   // 3868
    { 53, 73,  0,  0,  0,  0},   // 3869
    {  2,  3,  5, 43,  0,  0},   // 3870
    {  7, 79,  0,  0,  0,  0},   // 3871
    {  2, 11,  0,  0,  0,  0},   // 3872
    {  3,1291,  0,  0,  0,  0},   // 3873
    {  2, 13,149,  0,  0,  0},   // 3874
    {  5, 31,  0,  0,  0,  0},   // 3875
    {  2,  3, 17, 19,  0,  0},   // 3876
    {  0,  0,  0,  0,  0,  0},   // 3877
    {  2,  7,277,  0,  0,  0},   // 3878
    {  3,431,  0,  0,  0,  0},   // 3879
    {  2,  5, 97,  0,  0,  0},   // 3880
    {  0,  0,  0,  0,  0,  0},   // 3881
    {  2,  3,647,  0,  0,  0},   // 3882
    { 11,353,  0,  0,  0,  0},   // 3883
    {  2,971,  0,  0,  0,  0},   // 3884
    {  3,  5,  7, 37,  0,  0},   // 3885
    {  2, 29, 67,  0,  0,  0},   // 3886
    { 13, 23,  0,  0,  0,  0},   // 3887
    {  2,  3,  0,  0,  0,  0},   // 3888
    {  0,  0,  0,  0,  0,  0},   // 3889
    {  2,  5,389,  0,  0,  0},   // 3890
    {  3,1297,  0,  0,  0,  0},   // 3891
    {  2,  7,139,  0,  0,  0},   // 3892
    { 17,229,  0,  0,  0,  0},   // 3893
    {  2,  3, 11, 59,  0,  0},   // 3894
    {  5, 19, 41,  0,  0,  0},   // 3895
    {  2,487,  0,  0,  0,  0},   // 3896
    {  3,433,  0,  0,  0,  0},   // 3897
    {  2,1949,  0,  0,  0,  0},   // 3898
    {  7,557,  0,  0,  0,  0},   // 3899
    {  2,  3,  5, 13,  0,  0},   // 3900
    { 47, 83,  0,  0,  0,  0},   // 3901
    {  2,1951,  0,  0,  0,  0},   // 3902
    {  3,1301,  0,  0,  0,  0},   // 3903
    {  2, 61,  0,  0,  0,  0},   // 3904
    {  5, 11, 71,  0,  0,  0},   // 3905
    {  2,  3,  7, 31,  0,  0},   // 3906
    {  0,  0,  0,  0,  0,  0},   // 3907
    {  2,977,  0,  0,  0,  0},   // 3908
    {  3,1303,  0,  0,  0,  0},   // 3909
    {  2,  5, 17, 23,  0,  0},   // 3910
    {  0,  0,  0,  0,  0,  0},   // 3911
    {  2,  3,163,  0,  0,  0},   // 3912
    {  7, 13, 43,  0,  0,  0},   // 3913
    {  2, 19,103,  0,  0,  0},   // 3914
    {  3,  5, 29,  0,  0,  0},   // 3915
    {  2, 11, 89,  0,  0,  0},   // 3916
    {  0,  0,  0,  0,  0,  0},   // 3917
    {  2,  3,653,  0,  0,  0},   // 3918
    {  0,  0,  0,  0,  0,  0},   // 3919
    {  2,  5,  7,  0,  0,  0},   // 3920
    {  3,1307,  0,  0,  0,  0},   // 3921
    {  2, 37, 53,  0,  0,  0},   // 3922
    {  0,  0,  0,  0,  0,  0},   // 3923
    {  2,  3,109,  0,  0,  0},   // 3924
    {  5,157,  0,  0,  0,  0},   // 3925
    {  2, 13,151,  0,  0,  0},   // 3926
    {  3,  7, 11, 17,  0,  0},   // 3927
    {  2,491,  0,  0,  0,  0},   // 3928
    {  0,  0,  0,  0,  0,  0},   // 3929
    {  2,  3,  5,131,  0,  0},   // 3930
    {  0,  0,  0,  0,  0,  0},   // 3931
    {  2,983,  0,  0,  0,  0},   // 3932
    {  3, 19, 23,  0,  0,  0},   // 3933
    {  2,  7,281,  0,  0,  0},   // 3934
    {  5,787,  0,  0,  0,  0},   // 3935
    {  2,  3, 41,  0,  0,  0},   // 3936
    { 31,127,  0,  0,  0,  0},   // 3937
    {  2, 11,179,  0,  0,  0},   // 3938
    {  3, 13,101,  0,  0,  0},   // 3939
    {  2,  5,197,  0,  0,  0},   // 3940
    {  7,563,  0,  0,  0,  0},   // 3941
    {  2,  3, 73,  0,  0,  0},   // 3942
    {  0,  0,  0,  0,  0,  0},   // 3943
    {  2, 17, 29,  0,  0,  0},   // 3944
    {  3,  5,263,  0,  0,  0},   // 3945
    {  2,1973,  0,  0,  0,  0},   // 3946
    {  0,  0,  0,  0,  0,  0},   // 3947
    {  2,  3,  7, 47,  0,  0},   // 3948
    { 11,359,  0,  0,  0,  0},   // 3949
    {  2,  5, 79,  0,  0,  0},   // 3950
    {  3,439,  0,  0,  0,  0},   // 3951
    {  2, 13, 19,  0,  0,  0},   // 3952
    { 59, 67,  0,  0,  0,  0},   // 3953
    {  2,  3,659,  0,  0,  0},   // 3954
    {  5,  7,113,  0,  0,  0},   // 3955
    {  2, 23, 43,  0,  0,  0},   // 3956
    {  3,1319,  0,  0,  0,  0},   // 3957
    {  2,1979,  0,  0,  0,  0},   // 3958
    { 37,107,  0,  0,  0,  0},   // 3959
    {  2,  3,  5, 11,  0,  0},   // 3960
    { 17,233,  0,  0,  0,  0},   // 3961
    {  2,  7,283,  0,  0,  0},   // 3962
    {  3,1321,  0,  0,  0,  0},   // 3963
    {  2,991,  0,  0,  0,  0},   // 3964
    {  5, 13, 61,  0,  0,  0},   // 3965
    {  2,  3,661,  0,  0,  0},   // 3966
    {  0,  0,  0,  0,  0,  0},   // 3967
    {  2, 31,  0,  0,  0,  0},   // 3968
    {  3,  7,  0,  0,  0,  0},   // 3969
    {  2,  5,397,  0,  0,  0},   // 3970
    { 11, 19,  0,  0,  0,  0},   // 3971
    {  2,  3,331,  0,  0,  0},   // 3972
    { 29,137,  0,  0,  0,  0},   // 3973
    {  2,1987,  0,  0,  0,  0},   // 3974
    {  3,  5, 53,  0,  0,  0},   // 3975
    {  2,  7, 71,  0,  0,  0},   // 3976
    { 41, 97,  0,  0,  0,  0},   // 3977
    {  2,  3, 13, 17,  0,  0},   // 3978
    { 23,173,  0,  0,  0,  0},   // 3979
    {  2,  5,199,  0,  0,  0},   // 3980
    {  3,1327,  0,  0,  0,  0},   // 3981
    {  2, 11,181,  0,  0,  0},   // 3982
    {  7,569,  0,  0,  0,  0},   // 3983
    {  2,  3, 83,  0,  0,  0},   // 3984
    {  5,797,  0,  0,  0,  0},   // 3985
    {  2,1993,  0,  0,  0,  0},   // 3986
    {  3,443,  0,  0,  0,  0},   // 3987
    {  2,997,  0,  0,  0,  0},   // 3988
    {  0,  0,  0,  0,  0,  0},   // 3989
    {  2,  3,  5,  7, 19,  0},   // 3990
    { 13,307,  0,  0,  0,  0},   // 3991
    {  2,499,  0,  0,  0,  0},   // 3992
    {  3, 11,  0,  0,  0,  0},   // 3993
    {  2,1997,  0,  0,  0,  0},   // 3994
    {  5, 17, 47,  0,  0,  0},   // 3995
    {  2,  3, 37,  0,  0,  0},   // 3996
    {  7,571,  0,  0,  0,  0},   // 3997
    {  2,1999,  0,  0,  0,  0},   // 3998
    {  3, 31, 43,  0,  0,  0},   // 3999
    {  2,  5,  0,  0,  0,  0},   // 4000
    {  0,  0,  0,  0,  0,  0},   // 4001
    {  2,  3, 23, 29,  0,  0},   // 4002
    {  0,  0,  0,  0,  0,  0},   // 4003
    {  2,  7, 11, 13,  0,  0},   // 4004
    {  3,  5, 89,  0,  0,  0},   // 4005
    {  2,2003,  0,  0,  0,  0},   // 4006
    {  0,  0,  0,  0,  0,  0},   // 4007
    {  2,  3,167,  0,  0,  0},   // 4008
    { 19,211,  0,  0,  0,  0},   // 4009
    {  2,  5,401,  0,  0,  0},   // 4010
    {  3,  7,191,  0,  0,  0},   // 4011
    {  2, 17, 59,  0,  0,  0},   // 4012
    {  0,  0,  0,  0,  0,  0},   // 4013
    {  2,  3,223,  0,  0,  0},   // 4014
    {  5, 11, 73,  0,  0,  0},   // 4015
    {  2,251,  0,  0,  0,  0},   // 4016
    {  3, 13,103,  0,  0,  0},   // 4017
    {  2,  7, 41,  0,  0,  0},   // 4018
    {  0,  0,  0,  0,  0,  0},   // 4019
    {  2,  3,  5, 67,  0,  0},   // 4020
    {  0,  0,  0,  0,  0,  0},   // 4021
    {  2,2011,  0,  0,  0,  0},   // 4022
    {  3,149,  0,  0,  0,  0},   // 4023
    {  2,503,  0,  0,  0,  0},   // 4024
    {  5,  7, 23,  0,  0,  0},   // 4025
    {  2,  3, 11, 61,  0,  0},   // 4026
    {  0,  0,  0,  0,  0,  0},   // 4027
    {  2, 19, 53,  0,  0,  0},   // 4028
    {  3, 17, 79,  0,  0,  0},   // 4029
    {  2,  5, 13, 31,  0,  0},   // 4030
    { 29,139,  0,  0,  0,  0},   // 4031
    {  2,  3,  7,  0,  0,  0},   // 4032
    { 37,109,  0,  0,  0,  0},   // 4033
    {  2,2017,  0,  0,  0,  0},   // 4034
    {  3,  5,269,  0,  0,  0},   // 4035
    {  2,1009,  0,  0,  0,  0},   // 4036
    { 11,367,  0,  0,  0,  0},   // 4037
    {  2,  3,673,  0,  0,  0},   // 4038
    {  7,577,  0,  0,  0,  0},   // 4039
    {  2,  5,101,  0,  0,  0},   // 4040
    {  3,449,  0,  0,  0,  0},   // 4041
    {  2, 43, 47,  0,  0,  0},   // 4042
    { 13,311,  0,  0,  0,  0},   // 4043
    {  2,  3,337,  0,  0,  0},   // 4044
    {  5,809,  0,  0,  0,  0},   // 4045
    {  2,  7, 17,  0,  0,  0},   // 4046
    {  3, 19, 71,  0,  0,  0},   // 4047
    {  2, 11, 23,  0,  0,  0},   // 4048
    {  0,  0,  0,  0,  0,  0},   // 4049
    {  2,  3,  5,  0,  0,  0},   // 4050
    {  0,  0,  0,  0,  0,  0},   // 4051
    {  2,1013,  0,  0,  0,  0},   // 4052
    {  3,  7,193,  0,  0,  0},   // 4053
    {  2,2027,  0,  0,  0,  0},   // 4054
    {  5,811,  0,  0,  0,  0},   // 4055
    {  2,  3, 13,  0,  0,  0},   // 4056
    {  0,  0,  0,  0,  0,  0},   // 4057
    {  2,2029,  0,  0,  0,  0},   // 4058
    {  3, 11, 41,  0,  0,  0},   // 4059
    {  2,  5,  7, 29,  0,  0},   // 4060
    { 31,131,  0,  0,  0,  0},   // 4061
    {  2,  3,677,  0,  0,  0},   // 4062
    { 17,239,  0,  0,  0,  0},   // 4063
    {  2,127,  0,  0,  0,  0},   // 4064
    {  3,  5,271,  0,  0,  0},   // 4065
    {  2, 19,107,  0,  0,  0},   // 4066
    {  7, 83,  0,  0,  0,  0},   // 4067
    {  2,  3,113,  0,  0,  0},   // 4068
    { 13,313,  0,  0,  0,  0},   // 4069
    {  2,  5, 11, 37,  0,  0},   // 4070
    {  3, 23, 59,  0,  0,  0},   // 4071
    {  2,509,  0,  0,  0,  0},   // 4072
    {  0,  0,  0,  0,  0,  0},   // 4073
    {  2,  3,  7, 97,  0,  0},   // 4074
    {  5,163,  0,  0,  0,  0},   // 4075
    {  2,1019,  0,  0,  0,  0},   // 4076
    {  3,151,  0,  0,  0,  0},   // 4077
    {  2,2039,  0,  0,  0,  0},   // 4078
    {  0,  0,  0,  0,  0,  0},   // 4079
    {  2,  3,  5, 17,  0,  0},   // 4080
    {  7, 11, 53,  0,  0,  0},   // 4081
    {  2, 13,157,  0,  0,  0},   // 4082
    {  3,1361,  0,  0,  0,  0},   // 4083
    {  2,1021,  0,  0,  0,  0},   // 4084
    {  5, 19, 43,  0,  0,  0},   // 4085
    {  2,  3,227,  0,  0,  0},   // 4086
    { 61, 67,  0,  0,  0,  0},   // 4087
    {  2,  7, 73,  0,  0,  0},   // 4088
    {  3, 29, 47,  0,  0,  0},   // 4089
    {  2,  5,409,  0,  0,  0},   // 4090
    {  0,  0,  0,  0,  0,  0},   // 4091
    {  2,  3, 11, 31,  0,  0},   // 4092
    {  0,  0,  0,  0,  0,  0},   // 4093
    {  2, 23, 89,  0,  0,  0},   // 4094
    {  3,  5,  7, 13,  0,  0},   // 4095
    {  2,  0,  0,  0,  0,  0},   // 4096
    { 17,241,  0,  0,  0,  0},   // 4097
    {  2,  3,683,  0,  0,  0},   // 4098
    {  0,  0,  0,  0,  0,  0},   // 4099
    {  2,  5, 41,  0,  0,  0},   // 4100
    {  3,1367,  0,  0,  0,  0},   // 4101
    {  2,  7,293,  0,  0,  0},   // 4102
    { 11,373,  0,  0,  0,  0},   // 4103
    {  2,  3, 19,  0,  0,  0},   // 4104
    {  5,821,  0,  0,  0,  0},   // 4105
    {  2,2053,  0,  0,  0,  0},   // 4106
    {  3, 37,  0,  0,  0,  0},   // 4107
    {  2, 13, 79,  0,  0,  0},   // 4108
    {  7,587,  0,  0,  0,  0},   // 4109
    {  2,  3,  5,137,  0,  0},   // 4110
    {  0,  0,  0,  0,  0,  0},   // 4111
    {  2,257,  0,  0,  0,  0},   // 4112
    {  3,457,  0,  0,  0,  0},   // 4113
    {  2, 11, 17,  0,  0,  0},   // 4114
    {  5,823,  0,  0,  0,  0},   // 4115
    {  2,  3,  7,  0,  0,  0},   // 4116
    { 23,179,  0,  0,  0,  0},   // 4117
    {  2, 29, 71,  0,  0,  0},   // 4118
    {  3,1373,  0,  0,  0,  0},   // 4119
    {  2,  5,103,  0,  0,  0},   // 4120
    { 13,317,  0,  0,  0,  0},   // 4121
    {  2,  3,229,  0,  0,  0},   // 4122
    {  7, 19, 31,  0,  0,  0},   // 4123
    {  2,1031,  0,  0,  0,  0},   // 4124
    {  3,  5, 11,  0,  0,  0},   // 4125
    {  2,2063,  0,  0,  0,  0},   // 4126
    {  0,  0,  0,  0,  0,  0},   // 4127
    {  2,  3, 43,  0,  0,  0},   // 4128
    {  0,  0,  0,  0,  0,  0},   // 4129
    {  2,  5,  7, 59,  0,  0},   // 4130
    {  3, 17,  0,  0,  0,  0},   // 4131
    {  2,1033,  0,  0,  0,  0},   // 4132
    {  0,  0,  0,  0,  0,  0},   // 4133
    {  2,  3, 13, 53,  0,  0},   // 4134
    {  5,827,  0,  0,  0,  0},   // 4135
    {  2, 11, 47,  0,  0,  0},   // 4136
    {  3,  7,197,  0,  0,  0},   // 4137
    {  2,2069,  0,  0,  0,  0},   // 4138
    {  0,  0,  0,  0,  0,  0},   // 4139
    {  2,  3,  5, 23,  0,  0},   // 4140
    { 41,101,  0,  0,  0,  0},   // 4141
    {  2, 19,109,  0,  0,  0},   // 4142
    {  3,1381,  0,  0,  0,  0},   // 4143
    {  2,  7, 37,  0,  0,  0},   // 4144
    {  5,829,  0,  0,  0,  0},   // 4145
    {  2,  3,691,  0,  0,  0},   // 4146
    { 11, 13, 29,  0,  0,  0},   // 4147
    {  2, 17, 61,  0,  0,  0},   // 4148
    {  3,461,  0,  0,  0,  0},   // 4149
    {  2,  5, 83,  0,  0,  0},   // 4150
    {  7,593,  0,  0,  0,  0},   // 4151
    {  2,  3,173,  0,  0,  0},   // 4152
    {  0,  0,  0,  0,  0,  0},   // 4153
    {  2, 31, 67,  0,  0,  0},   // 4154
    {  3,  5,277,  0,  0,  0},   // 4155
    {  2,1039,  0,  0,  0,  0},   // 4156
    {  0,  0,  0,  0,  0,  0},   // 4157
    {  2,  3,  7, 11,  0,  0},   // 4158
    {  0,  0,  0,  0,  0,  0},   // 4159
    {  2,  5, 13,  0,  0,  0},   // 4160
    {  3, 19, 73,  0,  0,  0},   // 4161
    {  2,2081,  0,  0,  0,  0},   // 4162
    { 23,181,  0,  0,  0,  0},   // 4163
    {  2,  3,347,  0,  0,  0},   // 4164
    {  5,  7, 17,  0,  0,  0},   // 4165
    {  2,2083,  0,  0,  0,  0},   // 4166
    {  3,463,  0,  0,  0,  0},   // 4167
    {  2,521,  0,  0,  0,  0},   // 4168
    { 11,379,  0,  0,  0,  0},   // 4169
    {  2,  3,  5,139,  0,  0},   // 4170
    { 43, 97,  0,  0,  0,  0},   // 4171
    {  2,  7,149,  0,  0,  0},   // 4172
    {  3, 13,107,  0,  0,  0},   // 4173
    {  2,2087,  0,  0,  0,  0},   // 4174
    {  5,167,  0,  0,  0,  0},   // 4175
    {  2,  3, 29,  0,  0,  0},   // 4176
    {  0,  0,  0,  0,  0,  0},   // 4177
    {  2,2089,  0,  0,  0,  0},   // 4178
    {  3,  7,199,  0,  0,  0},   // 4179
    {  2,  5, 11, 19,  0,  0},   // 4180
    { 37,113,  0,  0,  0,  0},   // 4181
    {  2,  3, 17, 41,  0,  0},   // 4182
    { 47, 89,  0,  0,  0,  0},   // 4183
    {  2,523,  0,  0,  0,  0},   // 4184
    {  3,  5, 31,  0,  0,  0},   // 4185
    {  2,  7, 13, 23,  0,  0},   // 4186
    { 53, 79,  0,  0,  0,  0},   // 4187
    {  2,  3,349,  0,  0,  0},   // 4188
    { 59, 71,  0,  0,  0,  0},   // 4189
    {  2,  5,419,  0,  0,  0},   // 4190
    {  3, 11,127,  0,  0,  0},   // 4191
    {  2,131,  0,  0,  0,  0},   // 4192
    {  7,599,  0,  0,  0,  0},   // 4193
    {  2,  3,233,  0,  0,  0},   // 4194
    {  5,839,  0,  0,  0,  0},   // 4195
    {  2,1049,  0,  0,  0,  0},   // 4196
    {  3,1399,  0,  0,  0,  0},   // 4197
    {  2,2099,  0,  0,  0,  0},   // 4198
    { 13, 17, 19,  0,  0,  0},   // 4199
    {  2,  3,  5,  7,  0,  0},   // 4200
    {  0,  0,  0,  0,  0,  0},   // 4201
    {  2, 11,191,  0,  0,  0},   // 4202
    {  3,467,  0,  0,  0,  0},   // 4203
    {  2,1051,  0,  0,  0,  0},   // 4204
    {  5, 29,  0,  0,  0,  0},   // 4205
    {  2,  3,701,  0,  0,  0},   // 4206
    {  7,601,  0,  0,  0,  0},   // 4207
    {  2,263,  0,  0,  0,  0},   // 4208
    {  3, 23, 61,  0,  0,  0},   // 4209
    {  2,  5,421,  0,  0,  0},   // 4210
    {  0,  0,  0,  0,  0,  0},   // 4211
    {  2,  3, 13,  0,  0,  0},   // 4212
    { 11,383,  0,  0,  0,  0},   // 4213
    {  2,  7, 43,  0,  0,  0},   // 4214
    {  3,  5,281,  0,  0,  0},   // 4215
    {  2, 17, 31,  0,  0,  0},   // 4216
    {  0,  0,  0,  0,  0,  0},   // 4217
    {  2,  3, 19, 37,  0,  0},   // 4218
    {  0,  0,  0,  0,  0,  0},   // 4219
    {  2,  5,211,  0,  0,  0},   // 4220
    {  3,  7, 67,  0,  0,  0},   // 4221
    {  2,2111,  0,  0,  0,  0},   // 4222
    { 41,103,  0,  0,  0,  0},   // 4223
    {  2,  3, 11,  0,  0,  0},   // 4224
    {  5, 13,  0,  0,  0,  0},   // 4225
    {  2,2113,  0,  0,  0,  0},   // 4226
    {  3,1409,  0,  0,  0,  0},   // 4227
    {  2,  7,151,  0,  0,  0},   // 4228
    {  0,  0,  0,  0,  0,  0},   // 4229
    {  2,  3,  5, 47,  0,  0},   // 4230
    {  0,  0,  0,  0,  0,  0},   // 4231
    {  2, 23,  0,  0,  0,  0},   // 4232
    {  3, 17, 83,  0,  0,  0},   // 4233
    {  2, 29, 73,  0,  0,  0},   // 4234
    {  5,  7, 11,  0,  0,  0},   // 4235
    {  2,  3,353,  0,  0,  0},   // 4236
    { 19,223,  0,  0,  0,  0},   // 4237
    {  2, 13,163,  0,  0,  0},   // 4238
    {  3,157,  0,  0,  0,  0},   // 4239
    {  2,  5, 53,  0,  0,  0},   // 4240
    {  0,  0,  0,  0,  0,  0},   // 4241
    {  2,  3,  7,101,  0,  0},   // 4242
    {  0,  0,  0,  0,  0,  0},   // 4243
    {  2,1061,  0,  0,  0,  0},   // 4244
    {  3,  5,283,  0,  0,  0},   // 4245
    {  2, 11,193,  0,  0,  0},   // 4246
    { 31,137,  0,  0,  0,  0},   // 4247
    {  2,  3, 59,  0,  0,  0},   // 4248
    {  7,607,  0,  0,  0,  0},   // 4249
    {  2,  5, 17,  0,  0,  0},   // 4250
    {  3, 13,109,  0,  0,  0},   // 4251
    {  2,1063,  0,  0,  0,  0},   // 4252
    {  0,  0,  0,  0,  0,  0},   // 4253
    {  2,  3,709,  0,  0,  0},   // 4254
    {  5, 23, 37,  0,  0,  0},   // 4255
    {  2,  7, 19,  0,  0,  0},   // 4256
    {  3, 11, 43,  0,  0,  0},   // 4257
    {  2,2129,  0,  0,  0,  0},   // 4258
    {  0,  0,  0,  0,  0,  0},   // 4259
    {  2,  3,  5, 71,  0,  0},   // 4260
    {  0,  0,  0,  0,  0,  0},   // 4261
    {  2,2131,  0,  0,  0,  0},   // 4262
    {  3,  7, 29,  0,  0,  0},   // 4263
    {  2, 13, 41,  0,  0,  0},   // 4264
    {  5,853,  0,  0,  0,  0},   // 4265
    {  2,  3, 79,  0,  0,  0},   // 4266
    { 17,251,  0,  0,  0,  0},   // 4267
    {  2, 11, 97,  0,  0,  0},   // 4268
    {  3,1423,  0,  0,  0,  0},   // 4269
    {  2,  5,  7, 61,  0,  0},   // 4270
    {  0,  0,  0,  0,  0,  0},   // 4271
    {  2,  3, 89,  0,  0,  0},   // 4272
    {  0,  0,  0,  0,  0,  0},   // 4273
    {  2,2137,  0,  0,  0,  0},   // 4274
    {  3,  5, 19,  0,  0,  0},   // 4275
    {  2,1069,  0,  0,  0,  0},   // 4276
    {  7, 13, 47,  0,  0,  0},   // 4277
    {  2,  3, 23, 31,  0,  0},   // 4278
    { 11,389,  0,  0,  0,  0},   // 4279
    {  2,  5,107,  0,  0,  0},   // 4280
    {  3,1427,  0,  0,  0,  0},   // 4281
    {  2,2141,  0,  0,  0,  0},   // 4282
    {  0,  0,  0,  0,  0,  0},   // 4283
    {  2,  3,  7, 17,  0,  0},   // 4284
    {  5,857,  0,  0,  0,  0},   // 4285
    {  2,2143,  0,  0,  0,  0},   // 4286
    {  3,1429,  0,  0,  0,  0},   // 4287
    {  2, 67,  0,  0,  0,  0},   // 4288
    {  0,  0,  0,  0,  0,  0},   // 4289
    {  2,  3,  5, 11, 13,  0},   // 4290
    {  7,613,  0,  0,  0,  0},   // 4291
    {  2, 29, 37,  0,  0,  0},   // 4292
    {  3, 53,  0,  0,  0,  0},   // 4293
    {  2, 19,113,  0,  0,  0},   // 4294
    {  5,859,  0,  0,  0,  0},   // 4295
    {  2,  3,179,  0,  0,  0},   // 4296
    {  0,  0,  0,  0,  0,  0},   // 4297
    {  2,  7,307,  0,  0,  0},   // 4298
    {  3,1433,  0,  0,  0,  0},   // 4299
    {  2,  5, 43,  0,  0,  0},   // 4300
    { 11, 17, 23,  0,  0,  0},   // 4301
    {  2,  3,239,  0,  0,  0},   // 4302
    { 13,331,  0,  0,  0,  0},   // 4303
    {  2,269,  0,  0,  0,  0},   // 4304
    {  3,  5,  7, 41,  0,  0},   // 4305
    {  2,2153,  0,  0,  0,  0},   // 4306
    { 59, 73,  0,  0,  0,  0},   // 4307
    {  2,  3,359,  0,  0,  0},   // 4308
    { 31,139,  0,  0,  0,  0},   // 4309
    {  2,  5,431,  0,  0,  0},   // 4310
    {  3,479,  0,  0,  0,  0},   // 4311
    {  2,  7, 11,  0,  0,  0},   // 4312
    { 19,227,  0,  0,  0,  0},   // 4313
    {  2,  3,719,  0,  0,  0},   // 4314
    {  5,863,  0,  0,  0,  0},   // 4315
    {  2, 13, 83,  0,  0,  0},   // 4316
    {  3,1439,  0,  0,  0,  0},   // 4317
    {  2, 17,127,  0,  0,  0},   // 4318
    {  7,617,  0,  0,  0,  0},   // 4319
    {  2,  3,  5,  0,  0,  0},   // 4320
    { 29,149,  0,  0,  0,  0},   // 4321
    {  2,2161,  0,  0,  0,  0},   // 4322
    {  3, 11,131,  0,  0,  0},   // 4323
    {  2, 23, 47,  0,  0,  0},   // 4324
    {  5,173,  0,  0,  0,  0},   // 4325
    {  2,  3,  7,103,  0,  0},   // 4326
    {  0,  0,  0,  0,  0,  0},   // 4327
    {  2,541,  0,  0,  0,  0},   // 4328
    {  3, 13, 37,  0,  0,  0},   // 4329
    {  2,  5,433,  0,  0,  0},   // 4330
    { 61, 71,  0,  0,  0,  0},   // 4331
    {  2,  3, 19,  0,  0,  0},   // 4332
    {  7,619,  0,  0,  0,  0},   // 4333
    {  2, 11,197,  0,  0,  0},   // 4334
    {  3,  5, 17,  0,  0,  0},   // 4335
    {  2,271,  0,  0,  0,  0},   // 4336
    {  0,  0,  0,  0,  0,  0},   // 4337
    {  2,  3,241,  0,  0,  0},   // 4338
    {  0,  0,  0,  0,  0,  0},   // 4339
    {  2,  5,  7, 31,  0,  0},   // 4340
    {  3,1447,  0,  0,  0,  0},   // 4341
    {  2, 13,167,  0,  0,  0},   // 4342
    { 43,101,  0,  0,  0,  0},   // 4343
    {  2,  3,181,  0,  0,  0},   // 4344
    {  5, 11, 79,  0,  0,  0},   // 4345
    {  2, 41, 53,  0,  0,  0},   // 4346
    {  3,  7, 23,  0,  0,  0},   // 4347
    {  2,1087,  0,  0,  0,  0},   // 4348
    {  0,  0,  0,  0,  0,  0},   // 4349
    {  2,  3,  5, 29,  0,  0},   // 4350
    { 19,229,  0,  0,  0,  0},   // 4351
    {  2, 17,  0,  0,  0,  0},   // 4352
    {  3,1451,  0,  0,  0,  0},   // 4353
    {  2,  7,311,  0,  0,  0},   // 4354
    {  5, 13, 67,  0,  0,  0},   // 4355
    {  2,  3, 11,  0,  0,  0},   // 4356
    {  0,  0,  0,  0,  0,  0},   // 4357
    {  2,2179,  0,  0,  0,  0},   // 4358
    {  3,1453,  0,  0,  0,  0},   // 4359
    {  2,  5,109,  0,  0,  0},   // 4360
    {  7, 89,  0,  0,  0,  0},   // 4361
    {  2,  3,727,  0,  0,  0},   // 4362
    {  0,  0,  0,  0,  0,  0},   // 4363
    {  2,1091,  0,  0,  0,  0},   // 4364
    {  3,  5, 97,  0,  0,  0},   // 4365
    {  2, 37, 59,  0,  0,  0},   // 4366
    { 11,397,  0,  0,  0,  0},   // 4367
    {  2,  3,  7, 13,  0,  0},   // 4368
    { 17,257,  0,  0,  0,  0},   // 4369
    {  2,  5, 19, 23,  0,  0},   // 4370
    {  3, 31, 47,  0,  0,  0},   // 4371
    {  2,1093,  0,  0,  0,  0},   // 4372
    {  0,  0,  0,  0,  0,  0},   // 4373
    {  2,  3,  0,  0,  0,  0},   // 4374
    {  5,  7,  0,  0,  0,  0},   // 4375
    {  2,547,  0,  0,  0,  0},   // 4376
    {  3,1459,  0,  0,  0,  0},   // 4377
    {  2, 11,199,  0,  0,  0},   // 4378
    { 29,151,  0,  0,  0,  0},   // 4379
    {  2,  3,  5, 73,  0,  0},   // 4380
    { 13,337,  0,  0,  0,  0},   // 4381
    {  2,  7,313,  0,  0,  0},   // 4382
    {  3,487,  0,  0,  0,  0},   // 4383
    {  2,137,  0,  0,  0,  0},   // 4384
    {  5,877,  0,  0,  0,  0},   // 4385
    {  2,  3, 17, 43,  0,  0},   // 4386
    { 41,107,  0,  0,  0,  0},   // 4387
    {  2,1097,  0,  0,  0,  0},   // 4388
    {  3,  7, 11, 19,  0,  0},   // 4389
    {  2,  5,439,  0,  0,  0},   // 4390
    {  0,  0,  0,  0,  0,  0},   // 4391
    {  2,  3, 61,  0,  0,  0},   // 4392
    { 23,191,  0,  0,  0,  0},   // 4393
    {  2, 13,  0,  0,  0,  0},   // 4394
    {  3,  5,293,  0,  0,  0},   // 4395
    {  2,  7,157,  0,  0,  0},   // 4396
    {  0,  0,  0,  0,  0,  0},   // 4397
    {  2,  3,733,  0,  0,  0},   // 4398
    { 53, 83,  0,  0,  0,  0},   // 4399
    {  2,  5, 11,  0,  0,  0},   // 4400
    {  3,163,  0,  0,  0,  0},   // 4401
    {  2, 31, 71,  0,  0,  0},   // 4402
    {  7, 17, 37,  0,  0,  0},   // 4403
    {  2,  3,367,  0,  0,  0},   // 4404
    {  5,881,  0,  0,  0,  0},   // 4405
    {  2,2203,  0,  0,  0,  0},   // 4406
    {  3, 13,113,  0,  0,  0},   // 4407
    {  2, 19, 29,  0,  0,  0},   // 4408
    {  0,  0,  0,  0,  0,  0},   // 4409
    {  2,  3,  5,  7,  0,  0},   // 4410
    { 11,401,  0,  0,  0,  0},   // 4411
    {  2,1103,  0,  0,  0,  0},   // 4412
    {  3,1471,  0,  0,  0,  0},   // 4413
    {  2,2207,  0,  0,  0,  0},   // 4414
    {  5,883,  0,  0,  0,  0},   // 4415
    {  2,  3, 23,  0,  0,  0},   // 4416
    {  7,631,  0,  0,  0,  0},   // 4417
    {  2, 47,  0,  0,  0,  0},   // 4418
    {  3,491,  0,  0,  0,  0},   // 4419
    {  2,  5, 13, 17,  0,  0},   // 4420
    {  0,  0,  0,  0,  0,  0},   // 4421
    {  2,  3, 11, 67,  0,  0},   // 4422
    {  0,  0,  0,  0,  0,  0},   // 4423
    {  2,  7, 79,  0,  0,  0},   // 4424
    {  3,  5, 59,  0,  0,  0},   // 4425
    {  2,2213,  0,  0,  0,  0},   // 4426
    { 19,233,  0,  0,  0,  0},   // 4427
    {  2,  3, 41,  0,  0,  0},   // 4428
    { 43,103,  0,  0,  0,  0},   // 4429
    {  2,  5,443,  0,  0,  0},   // 4430
    {  3,  7,211,  0,  0,  0},   // 4431
    {  2,277,  0,  0,  0,  0},   // 4432
    { 11, 13, 31,  0,  0,  0},   // 4433
    {  2,  3,739,  0,  0,  0},   // 4434
    {  5,887,  0,  0,  0,  0},   // 4435
    {  2,1109,  0,  0,  0,  0},   // 4436
    {  3, 17, 29,  0,  0,  0},   // 4437
    {  2,  7,317,  0,  0,  0},   // 4438
    { 23,193,  0,  0,  0,  0},   // 4439
    {  2,  3,  5, 37,  0,  0},   // 4440
    {  0,  0,  0,  0,  0,  0},   // 4441
    {  2,2221,  0,  0,  0,  0},   // 4442
    {  3,1481,  0,  0,  0,  0},   // 4443
    {  2, 11,101,  0,  0,  0},   // 4444
    {  5,  7,127,  0,  0,  0},   // 4445
    {  2,  3, 13, 19,  0,  0},   // 4446
    {  0,  0,  0,  0,  0,  0},   // 4447
    {  2,139,  0,  0,  0,  0},   // 4448
    {  3,1483,  0,  0,  0,  0},   // 4449
    {  2,  5, 89,  0,  0,  0},   // 4450
    {  0,  0,  0,  0,  0,  0},   // 4451
    {  2,  3,  7, 53,  0,  0},   // 4452
    { 61, 73,  0,  0,  0,  0},   // 4453
    {  2, 17,131,  0,  0,  0},   // 4454
    {  3,  5, 11,  0,  0,  0},   // 4455
    {  2,557,  0,  0,  0,  0},   // 4456
    {  0,  0,  0,  0,  0,  0},   // 4457
    {  2,  3,743,  0,  0,  0},   // 4458
    {  7, 13,  0,  0,  0,  0},   // 4459
    {  2,  5,223,  0,  0,  0},   // 4460
    {  3,1487,  0,  0,  0,  0},   // 4461
    {  2, 23, 97,  0,  0,  0},   // 4462
    {  0,  0,  0,  0,  0,  0},   // 4463
    {  2,  3, 31,  0,  0,  0},   // 4464
    {  5, 19, 47,  0,  0,  0},   // 4465
    {  2,  7, 11, 29,  0,  0},   // 4466
    {  3,1489,  0,  0,  0,  0},   // 4467
    {  2,1117,  0,  0,  0,  0},   // 4468
    { 41,109,  0,  0,  0,  0},   // 4469
    {  2,  3,  5,149,  0,  0},   // 4470
    { 17,263,  0,  0,  0,  0},   // 4471
    {  2, 13, 43,  0,  0,  0},   // 4472
    {  3,  7, 71,  0,  0,  0},   // 4473
    {  2,2237,  0,  0,  0,  0},   // 4474
    {  5,179,  0,  0,  0,  0},   // 4475
    {  2,  3,373,  0,  0,  0},   // 4476
    { 11, 37,  0,  0,  0,  0},   // 4477
    {  2,2239,  0,  0,  0,  0},   // 4478
    {  3,1493,  0,  0,  0,  0},   // 4479
    {  2,  5,  7,  0,  0,  0},   // 4480
    {  0,  0,  0,  0,  0,  0},   // 4481
    {  2,  3, 83,  0,  0,  0},   // 4482
    {  0,  0,  0,  0,  0,  0},   // 4483
    {  2, 19, 59,  0,  0,  0},   // 4484
    {  3,  5, 13, 23,  0,  0},   // 4485
    {  2,2243,  0,  0,  0,  0},   // 4486
    {  7,641,  0,  0,  0,  0},   // 4487
    {  2,  3, 11, 17,  0,  0},   // 4488
    { 67,  0,  0,  0,  0,  0},   // 4489
    {  2,  5,449,  0,  0,  0},   // 4490
    {  3,499,  0,  0,  0,  0},   // 4491
    {  2,1123,  0,  0,  0,  0},   // 4492
    {  0,  0,  0,  0,  0,  0},   // 4493
    {  2,  3,  7,107,  0,  0},   // 4494
    {  5, 29, 31,  0,  0,  0},   // 4495
    {  2,281,  0,  0,  0,  0},   // 4496
    {  3,1499,  0,  0,  0,  0},   // 4497
    {  2, 13,173,  0,  0,  0},   // 4498
    { 11,409,  0,  0,  0,  0},   // 4499
    {  2,  3,  5,  0,  0,  0},   // 4500
    {  7,643,  0,  0,  0,  0},   // 4501
    {  2,2251,  0,  0,  0,  0},   // 4502
    {  3, 19, 79,  0,  0,  0},   // 4503
    {  2,563,  0,  0,  0,  0},   // 4504
    {  5, 17, 53,  0,  0,  0},   // 4505
    {  2,  3,751,  0,  0,  0},   // 4506
    {  0,  0,  0,  0,  0,  0},   // 4507
    {  2,  7, 23,  0,  0,  0},   // 4508
    {  3,167,  0,  0,  0,  0},   // 4509
    {  2,  5, 11, 41,  0,  0},   // 4510
    { 13,347,  0,  0,  0,  0},   // 4511
    {  2,  3, 47,  0,  0,  0},   // 4512
    {  0,  0,  0,  0,  0,  0},   // 4513
    {  2, 37, 61,  0,  0,  0},   // 4514
    {  3,  5,  7, 43,  0,  0},   // 4515
    {  2,1129,  0,  0,  0,  0},   // 4516
    {  0,  0,  0,  0,  0,  0},   // 4517
    {  2,  3,251,  0,  0,  0},   // 4518
    {  0,  0,  0,  0,  0,  0},   // 4519
    {  2,  5,113,  0,  0,  0},   // 4520
    {  3, 11,137,  0,  0,  0},   // 4521
    {  2,  7, 17, 19,  0,  0},   // 4522
    {  0,  0,  0,  0,  0,  0},   // 4523
    {  2,  3, 13, 29,  0,  0},   // 4524
    {  5,181,  0,  0,  0,  0},   // 4525
    {  2, 31, 73,  0,  0,  0},   // 4526
    {  3,503,  0,  0,  0,  0},   // 4527
    {  2,283,  0,  0,  0,  0},   // 4528
    {  7,647,  0,  0,  0,  0},   // 4529
    {  2,  3,  5,151,  0,  0},   // 4530
    { 23,197,  0,  0,  0,  0},   // 4531
    {  2, 11,103,  0,  0,  0},   // 4532
    {  3,1511,  0,  0,  0,  0},   // 4533
    {  2,2267,  0,  0,  0,  0},   // 4534
    {  5,907,  0,  0,  0,  0},   // 4535
    {  2,  3,  7,  0,  0,  0},   // 4536
    { 13,349,  0,  0,  0,  0},   // 4537
    {  2,2269,  0,  0,  0,  0},   // 4538
    {  3, 17, 89,  0,  0,  0},   // 4539
    {  2,  5,227,  0,  0,  0},   // 4540
    { 19,239,  0,  0,  0,  0},   // 4541
    {  2,  3,757,  0,  0,  0},   // 4542
    {  7, 11, 59,  0,  0,  0},   // 4543
    {  2, 71,  0,  0,  0,  0},   // 4544
    {  3,  5,101,  0,  0,  0},   // 4545
    {  2,2273,  0,  0,  0,  0},   // 4546
    {  0,  0,  0,  0,  0,  0},   // 4547
    {  2,  3,379,  0,  0,  0},   // 4548
    {  0,  0,  0,  0,  0,  0},   // 4549
    {  2,  5,  7, 13,  0,  0},   // 4550
    {  3, 37, 41,  0,  0,  0},   // 4551
    {  2,569,  0,  0,  0,  0},   // 4552
    { 29,157,  0,  0,  0,  0},   // 4553
    {  2,  3, 11, 23,  0,  0},   // 4554
    {  5,911,  0,  0,  0,  0},   // 4555
    {  2, 17, 67,  0,  0,  0},   // 4556
    {  3,  7, 31,  0,  0,  0},   // 4557
    {  2, 43, 53,  0,  0,  0},   // 4558
    { 47, 97,  0,  0,  0,  0},   // 4559
    {  2,  3,  5, 19,  0,  0},   // 4560
    {  0,  0,  0,  0,  0,  0},   // 4561
    {  2,2281,  0,  0,  0,  0},   // 4562
    {  3, 13,  0,  0,  0,  0},   // 4563
    {  2,  7,163,  0,  0,  0},   // 4564
    {  5, 11, 83,  0,  0,  0},   // 4565
    {  2,  3,761,  0,  0,  0},   // 4566
    {  0,  0,  0,  0,  0,  0},   // 4567
    {  2,571,  0,  0,  0,  0},   // 4568
    {  3,1523,  0,  0,  0,  0},   // 4569
    {  2,  5,457,  0,  0,  0},   // 4570
    {  7,653,  0,  0,  0,  0},   // 4571
    {  2,  3,127,  0,  0,  0},   // 4572
    { 17,269,  0,  0,  0,  0},   // 4573
    {  2,2287,  0,  0,  0,  0},   // 4574
    {  3,  5, 61,  0,  0,  0},   // 4575
    {  2, 11, 13,  0,  0,  0},   // 4576
    { 23,199,  0,  0,  0,  0},   // 4577
    {  2,  3,  7,109,  0,  0},   // 4578
    { 19,241,  0,  0,  0,  0},   // 4579
    {  2,  5,229,  0,  0,  0},   // 4580
    {  3,509,  0,  0,  0,  0},   // 4581
    {  2, 29, 79,  0,  0,  0},   // 4582
    {  0,  0,  0,  0,  0,  0},   // 4583
    {  2,  3,191,  0,  0,  0},   // 4584
    {  5,  7,131,  0,  0,  0},   // 4585
    {  2,2293,  0,  0,  0,  0},   // 4586
    {  3, 11,139,  0,  0,  0},   // 4587
    {  2, 31, 37,  0,  0,  0},   // 4588
    { 13,353,  0,  0,  0,  0},   // 4589
    {  2,  3,  5, 17,  0,  0},   // 4590
    {  0,  0,  0,  0,  0,  0},   // 4591
    {  2,  7, 41,  0,  0,  0},   // 4592
    {  3,1531,  0,  0,  0,  0},   // 4593
    {  2,2297,  0,  0,  0,  0},   // 4594
    {  5,919,  0,  0,  0,  0},   // 4595
    {  2,  3,383,  0,  0,  0},   // 4596
    {  0,  0,  0,  0,  0,  0},   // 4597
    {  2, 11, 19,  0,  0,  0},   // 4598
    {  3,  7, 73,  0,  0,  0},   // 4599
    {  2,  5, 23,  0,  0,  0},   // 4600
    { 43,107,  0,  0,  0,  0},   // 4601
    {  2,  3, 13, 59,  0,  0},   // 4602
    {  0,  0,  0,  0,  0,  0},   // 4603
    {  2,1151,  0,  0,  0,  0},   // 4604
    {  3,  5,307,  0,  0,  0},   // 4605
    {  2,  7, 47,  0,  0,  0},   // 4606
    { 17,271,  0,  0,  0,  0},   // 4607
    {  2,  3,  0,  0,  0,  0},   // 4608
    { 11,419,  0,  0,  0,  0},   // 4609
    {  2,  5,461,  0,  0,  0},   // 4610
    {  3, 29, 53,  0,  0,  0},   // 4611
    {  2,1153,  0,  0,  0,  0},   // 4612
    {  7,659,  0,  0,  0,  0},   // 4613
    {  2,  3,769,  0,  0,  0},   // 4614
    {  5, 13, 71,  0,  0,  0},   // 4615
    {  2,577,  0,  0,  0,  0},   // 4616
    {  3, 19,  0,  0,  0,  0},   // 4617
    {  2,2309,  0,  0,  0,  0},   // 4618
    { 31,149,  0,  0,  0,  0},   // 4619
    {  2,  3,  5,  7, 11,  0},   // 4620
    {  0,  0,  0,  0,  0,  0},   // 4621
    {  2,2311,  0,  0,  0,  0},   // 4622
    {  3, 23, 67,  0,  0,  0},   // 4623
    {  2, 17,  0,  0,  0,  0},   // 4624
    {  5, 37,  0,  0,  0,  0},   // 4625
    {  2,  3,257,  0,  0,  0},   // 4626
    {  7,661,  0,  0,  0,  0},   // 4627
    {  2, 13, 89,  0,  0,  0},   // 4628
    {  3,1543,  0,  0,  0,  0},   // 4629
    {  2,  5,463,  0,  0,  0},   // 4630
    { 11,421,  0,  0,  0,  0},   // 4631
    {  2,  3,193,  0,  0,  0},   // 4632
    { 41,113,  0,  0,  0,  0},   // 4633
    {  2,  7,331,  0,  0,  0},   // 4634
    {  3,  5,103,  0,  0,  0},   // 4635
    {  2, 19, 61,  0,  0,  0},   // 4636
    {  0,  0,  0,  0,  0,  0},   // 4637
    {  2,  3,773,  0,  0,  0},   // 4638
    {  0,  0,  0,  0,  0,  0},   // 4639
    {  2,  5, 29,  0,  0,  0},   // 4640
    {  3,  7, 13, 17,  0,  0},   // 4641
    {  2, 11,211,  0,  0,  0},   // 4642
    {  0,  0,  0,  0,  0,  0},   // 4643
    {  2,  3, 43,  0,  0,  0},   // 4644
    {  5,929,  0,  0,  0,  0},   // 4645
    {  2, 23,101,  0,  0,  0},   // 4646
    {  3,1549,  0,  0,  0,  0},   // 4647
    {  2,  7, 83,  0,  0,  0},   // 4648
    {  0,  0,  0,  0,  0,  0},   // 4649
    {  2,  3,  5, 31,  0,  0},   // 4650
    {  0,  0,  0,  0,  0,  0},   // 4651
    {  2,1163,  0,  0,  0,  0},   // 4652
    {  3, 11, 47,  0,  0,  0},   // 4653
    {  2, 13,179,  0,  0,  0},   // 4654
    {  5,  7, 19,  0,  0,  0},   // 4655
    {  2,  3, 97,  0,  0,  0},   // 4656
    {  0,  0,  0,  0,  0,  0},   // 4657
    {  2, 17,137,  0,  0,  0},   // 4658
    {  3,1553,  0,  0,  0,  0},   // 4659
    {  2,  5,233,  0,  0,  0},   // 4660
    { 59, 79,  0,  0,  0,  0},   // 4661
    {  2,  3,  7, 37,  0,  0},   // 4662
    {  0,  0,  0,  0,  0,  0},   // 4663
    {  2, 11, 53,  0,  0,  0},   // 4664
    {  3,  5,311,  0,  0,  0},   // 4665
    {  2,2333,  0,  0,  0,  0},   // 4666
    { 13,359,  0,  0,  0,  0},   // 4667
    {  2,  3,389,  0,  0,  0},   // 4668
    {  7, 23, 29,  0,  0,  0},   // 4669
    {  2,  5,467,  0,  0,  0},   // 4670
    {  3,173,  0,  0,  0,  0},   // 4671
    {  2, 73,  0,  0,  0,  0},   // 4672
    {  0,  0,  0,  0,  0,  0},   // 4673
    {  2,  3, 19, 41,  0,  0},   // 4674
    {  5, 11, 17,  0,  0,  0},   // 4675
    {  2,  7,167,  0,  0,  0},   // 4676
    {  3,1559,  0,  0,  0,  0},   // 4677
    {  2,2339,  0,  0,  0,  0},   // 4678
    {  0,  0,  0,  0,  0,  0},   // 4679
    {  2,  3,  5, 13,  0,  0},   // 4680
    { 31,151,  0,  0,  0,  0},   // 4681
    {  2,2341,  0,  0,  0,  0},   // 4682
    {  3,  7,223,  0,  0,  0},   // 4683
    {  2,1171,  0,  0,  0,  0},   // 4684
    {  5,937,  0,  0,  0,  0},   // 4685
    {  2,  3, 11, 71,  0,  0},   // 4686
    { 43,109,  0,  0,  0,  0},   // 4687
    {  2,293,  0,  0,  0,  0},   // 4688
    {  3,521,  0,  0,  0,  0},   // 4689
    {  2,  5,  7, 67,  0,  0},   // 4690
    {  0,  0,  0,  0,  0,  0},   // 4691
    {  2,  3, 17, 23,  0,  0},   // 4692
    { 13, 19,  0,  0,  0,  0},   // 4693
    {  2,2347,  0,  0,  0,  0},   // 4694
    {  3,  5,313,  0,  0,  0},   // 4695
    {  2,587,  0,  0,  0,  0},   // 4696
    {  7, 11, 61,  0,  0,  0},   // 4697
    {  2,  3, 29,  0,  0,  0},   // 4698
    { 37,127,  0,  0,  0,  0},   // 4699
    {  2,  5, 47,  0,  0,  0},   // 4700
    {  3,1567,  0,  0,  0,  0},   // 4701
    {  2,2351,  0,  0,  0,  0},   // 4702
    {  0,  0,  0,  0,  0,  0},   // 4703
    {  2,  3,  7,  0,  0,  0},   // 4704
    {  5,941,  0,  0,  0,  0},   // 4705
    {  2, 13,181,  0,  0,  0},   // 4706
    {  3,523,  0,  0,  0,  0},   // 4707
    {  2, 11,107,  0,  0,  0},   // 4708
    { 17,277,  0,  0,  0,  0},   // 4709
    {  2,  3,  5,157,  0,  0},   // 4710
    {  7,673,  0,  0,  0,  0},   // 4711
    {  2, 19, 31,  0,  0,  0},   // 4712
    {  3,1571,  0,  0,  0,  0},   // 4713
    {  2,2357,  0,  0,  0,  0},   // 4714
    {  5, 23, 41,  0,  0,  0},   // 4715
    {  2,  3,131,  0,  0,  0},   // 4716
    { 53, 89,  0,  0,  0,  0},   // 4717
    {  2,  7,337,  0,  0,  0},   // 4718
    {  3, 11, 13,  0,  0,  0},   // 4719
    {  2,  5, 59,  0,  0,  0},   // 4720
    {  0,  0,  0,  0,  0,  0},   // 4721
    {  2,  3,787,  0,  0,  0},   // 4722
    {  0,  0,  0,  0,  0,  0},   // 4723
    {  2,1181,  0,  0,  0,  0},   // 4724
    {  3,  5,  7,  0,  0,  0},   // 4725
    {  2, 17,139,  0,  0,  0},   // 4726
    { 29,163,  0,  0,  0,  0},   // 4727
    {  2,  3,197,  0,  0,  0},   // 4728
    {  0,  0,  0,  0,  0,  0},   // 4729
    {  2,  5, 11, 43,  0,  0},   // 4730
    {  3, 19, 83,  0,  0,  0},   // 4731
    {  2,  7, 13,  0,  0,  0},   // 4732
    {  0,  0,  0,  0,  0,  0},   // 4733
    {  2,  3,263,  0,  0,  0},   // 4734
    {  5,947,  0,  0,  0,  0},   // 4735
    {  2, 37,  0,  0,  0,  0},   // 4736
    {  3,1579,  0,  0,  0,  0},   // 4737
    {  2, 23,103,  0,  0,  0},   // 4738
    {  7,677,  0,  0,  0,  0},   // 4739
    {  2,  3,  5, 79,  0,  0},   // 4740
    { 11,431,  0,  0,  0,  0},   // 4741
    {  2,2371,  0,  0,  0,  0},   // 4742
    {  3, 17, 31,  0,  0,  0},   // 4743
    {  2,593,  0,  0,  0,  0},   // 4744
    {  5, 13, 73,  0,  0,  0},   // 4745
    {  2,  3,  7,113,  0,  0},   // 4746
    { 47,101,  0,  0,  0,  0},   // 4747
    {  2,1187,  0,  0,  0,  0},   // 4748
    {  3,1583,  0,  0,  0,  0},   // 4749
    {  2,  5, 19,  0,  0,  0},   // 4750
    {  0,  0,  0,  0,  0,  0},   // 4751
    {  2,  3, 11,  0,  0,  0},   // 4752
    {  7, 97,  0,  0,  0,  0},   // 4753
    {  2,2377,  0,  0,  0,  0},   // 4754
    {  3,  5,317,  0,  0,  0},   // 4755
    {  2, 29, 41,  0,  0,  0},   // 4756
    { 67, 71,  0,  0,  0,  0},   // 4757
    {  2,  3, 13, 61,  0,  0},   // 4758
    {  0,  0,  0,  0,  0,  0},   // 4759
    {  2,  5,  7, 17,  0,  0},   // 4760
    {  3, 23,  0,  0,  0,  0},   // 4761
    {  2,2381,  0,  0,  0,  0},   // 4762
    { 11,433,  0,  0,  0,  0},   // 4763
    {  2,  3,397,  0,  0,  0},   // 4764
    {  5,953,  0,  0,  0,  0},   // 4765
    {  2,2383,  0,  0,  0,  0},   // 4766
    {  3,  7,227,  0,  0,  0},   // 4767
    {  2,149,  0,  0,  0,  0},   // 4768
    { 19,251,  0,  0,  0,  0},   // 4769
    {  2,  3,  5, 53,  0,  0},   // 4770
    { 13,367,  0,  0,  0,  0},   // 4771
    {  2,1193,  0,  0,  0,  0},   // 4772
    {  3, 37, 43,  0,  0,  0},   // 4773
    {  2,  7, 11, 31,  0,  0},   // 4774
    {  5,191,  0,  0,  0,  0},   // 4775
    {  2,  3,199,  0,  0,  0},   // 4776
    { 17,281,  0,  0,  0,  0},   // 4777
    {  2,2389,  0,  0,  0,  0},   // 4778
    {  3, 59,  0,  0,  0,  0},   // 4779
    {  2,  5,239,  0,  0,  0},   // 4780
    {  7,683,  0,  0,  0,  0},   // 4781
    {  2,  3,797,  0,  0,  0},   // 4782
    {  0,  0,  0,  0,  0,  0},   // 4783
    {  2, 13, 23,  0,  0,  0},   // 4784
    {  3,  5, 11, 29,  0,  0},   // 4785
    {  2,2393,  0,  0,  0,  0},   // 4786
    {  0,  0,  0,  0,  0,  0},   // 4787
    {  2,  3,  7, 19,  0,  0},   // 4788
    {  0,  0,  0,  0,  0,  0},   // 4789
    {  2,  5,479,  0,  0,  0},   // 4790
    {  3,1597,  0,  0,  0,  0},   // 4791
    {  2,599,  0,  0,  0,  0},   // 4792
    {  0,  0,  0,  0,  0,  0},   // 4793
    {  2,  3, 17, 47,  0,  0},   // 4794
    {  5,  7,137,  0,  0,  0},   // 4795
    {  2, 11,109,  0,  0,  0},   // 4796
    {  3, 13, 41,  0,  0,  0},   // 4797
    {  2,2399,  0,  0,  0,  0},   // 4798
    {  0,  0,  0,  0,  0,  0},   // 4799
    {  2,  3,  5,  0,  0,  0},   // 4800
    {  0,  0,  0,  0,  0,  0},   // 4801
    {  2,  7,  0,  0,  0,  0},   // 4802
    {  3,1601,  0,  0,  0,  0},   // 4803
    {  2,1201,  0,  0,  0,  0},   // 4804
    {  5, 31,  0,  0,  0,  0},   // 4805
    {  2,  3, 89,  0,  0,  0},   // 4806
    { 11, 19, 23,  0,  0,  0},   // 4807
    {  2,601,  0,  0,  0,  0},   // 4808
    {  3,  7,229,  0,  0,  0},   // 4809
    {  2,  5, 13, 37,  0,  0},   // 4810
    { 17,283,  0,  0,  0,  0},   // 4811
    {  2,  3,401,  0,  0,  0},   // 4812
    {  0,  0,  0,  0,  0,  0},   // 4813
    {  2, 29, 83,  0,  0,  0},   // 4814
    {  3,  5,107,  0,  0,  0},   // 4815
    {  2,  7, 43,  0,  0,  0},   // 4816
    {  0,  0,  0,  0,  0,  0},   // 4817
    {  2,  3, 11, 73,  0,  0},   // 4818
    { 61, 79,  0,  0,  0,  0},   // 4819
    {  2,  5,241,  0,  0,  0},   // 4820
    {  3,1607,  0,  0,  0,  0},   // 4821
    {  2,2411,  0,  0,  0,  0},   // 4822
    {  7, 13, 53,  0,  0,  0},   // 4823
    {  2,  3, 67,  0,  0,  0},   // 4824
    {  5,193,  0,  0,  0,  0},   // 4825
    {  2, 19,127,  0,  0,  0},   // 4826
    {  3,1609,  0,  0,  0,  0},   // 4827
    {  2, 17, 71,  0,  0,  0},   // 4828
    { 11,439,  0,  0,  0,  0},   // 4829
    {  2,  3,  5,  7, 23,  0},   // 4830
    {  0,  0,  0,  0,  0,  0},   // 4831
    {  2,151,  0,  0,  0,  0},   // 4832
    {  3,179,  0,  0,  0,  0},   // 4833
    {  2,2417,  0,  0,  0,  0},   // 4834
    {  5,967,  0,  0,  0,  0},   // 4835
    {  2,  3, 13, 31,  0,  0},   // 4836
    {  7,691,  0,  0,  0,  0},   // 4837
    {  2, 41, 59,  0,  0,  0},   // 4838
    {  3,1613,  0,  0,  0,  0},   // 4839
    {  2,  5, 11,  0,  0,  0},   // 4840
    { 47,103,  0,  0,  0,  0},   // 4841
    {  2,  3,269,  0,  0,  0},   // 4842
    { 29,167,  0,  0,  0,  0},   // 4843
    {  2,  7,173,  0,  0,  0},   // 4844
    {  3,  5, 17, 19,  0,  0},   // 4845
    {  2,2423,  0,  0,  0,  0},   // 4846
    { 37,131,  0,  0,  0,  0},   // 4847
    {  2,  3,101,  0,  0,  0},   // 4848
    { 13,373,  0,  0,  0,  0},   // 4849
    {  2,  5, 97,  0,  0,  0},   // 4850
    {  3,  7, 11,  0,  0,  0},   // 4851
    {  2,1213,  0,  0,  0,  0},   // 4852
    { 23,211,  0,  0,  0,  0},   // 4853
    {  2,  3,809,  0,  0,  0},   // 4854
    {  5,971,  0,  0,  0,  0},   // 4855
    {  2,607,  0,  0,  0,  0},   // 4856
    {  3,1619,  0,  0,  0,  0},   // 4857
    {  2,  7,347,  0,  0,  0},   // 4858
    { 43,113,  0,  0,  0,  0},   // 4859
    {  2,  3,  5,  0,  0,  0},   // 4860
    {  0,  0,  0,  0,  0,  0},   // 4861
    {  2, 11, 13, 17,  0,  0},   // 4862
    {  3,1621,  0,  0,  0,  0},   // 4863
    {  2, 19,  0,  0,  0,  0},   // 4864
    {  5,  7,139,  0,  0,  0},   // 4865
    {  2,  3,811,  0,  0,  0},   // 4866
    { 31,157,  0,  0,  0,  0},   // 4867
    {  2,1217,  0,  0,  0,  0},   // 4868
    {  3,541,  0,  0,  0,  0},   // 4869
    {  2,  5,487,  0,  0,  0},   // 4870
    {  0,  0,  0,  0,  0,  0},   // 4871
    {  2,  3,  7, 29,  0,  0},   // 4872
    { 11,443,  0,  0,  0,  0},   // 4873
    {  2,2437,  0,  0,  0,  0},   // 4874
    {  3,  5, 13,  0,  0,  0},   // 4875
    {  2, 23, 53,  0,  0,  0},   // 4876
    {  0,  0,  0,  0,  0,  0},   // 4877
    {  2,  3,271,  0,  0,  0},   // 4878
    {  7, 17, 41,  0,  0,  0},   // 4879
    {  2,  5, 61,  0,  0,  0},   // 4880
    {  3,1627,  0,  0,  0,  0},   // 4881
    {  2,2441,  0,  0,  0,  0},   // 4882
    { 19,257,  0,  0,  0,  0},   // 4883
    {  2,  3, 11, 37,  0,  0},   // 4884
    {  5,977,  0,  0,  0,  0},   // 4885
    {  2,  7,349,  0,  0,  0},   // 4886
    {  3,181,  0,  0,  0,  0},   // 4887
    {  2, 13, 47,  0,  0,  0},   // 4888
    {  0,  0,  0,  0,  0,  0},   // 4889
    {  2,  3,  5,163,  0,  0},   // 4890
    { 67, 73,  0,  0,  0,  0},   // 4891
    {  2,1223,  0,  0,  0,  0},   // 4892
    {  3,  7,233,  0,  0,  0},   // 4893
    {  2,2447,  0,  0,  0,  0},   // 4894
    {  5, 11, 89,  0,  0,  0},   // 4895
    {  2,  3, 17,  0,  0,  0},   // 4896
    { 59, 83,  0,  0,  0,  0},   // 4897
    {  2, 31, 79,  0,  0,  0},   // 4898
    {  3, 23, 71,  0,  0,  0},   // 4899
    {  2,  5,  7,  0,  0,  0},   // 4900
    { 13, 29,  0,  0,  0,  0},   // 4901
    {  2,  3, 19, 43,  0,  0},   // 4902
    {  0,  0,  0,  0,  0,  0},   // 4903
    {  2,613,  0,  0,  0,  0},   // 4904
    {  3,  5,109,  0,  0,  0},   // 4905
    {  2, 11,223,  0,  0,  0},   // 4906
    {  7,701,  0,  0,  0,  0},   // 4907
    {  2,  3,409,  0,  0,  0},   // 4908
    {  0,  0,  0,  0,  0,  0},   // 4909
    {  2,  5,491,  0,  0,  0},   // 4910
    {  3,1637,  0,  0,  0,  0},   // 4911
    {  2,307,  0,  0,  0,  0},   // 4912
    { 17,  0,  0,  0,  0,  0},   // 4913
    {  2,  3,  7, 13,  0,  0},   // 4914
    {  5,983,  0,  0,  0,  0},   // 4915
    {  2,1229,  0,  0,  0,  0},   // 4916
    {  3, 11,149,  0,  0,  0},   // 4917
    {  2,2459,  0,  0,  0,  0},   // 4918
    {  0,  0,  0,  0,  0,  0},   // 4919
    {  2,  3,  5, 41,  0,  0},   // 4920
    {  7, 19, 37,  0,  0,  0},   // 4921
    {  2, 23,107,  0,  0,  0},   // 4922
    {  3,547,  0,  0,  0,  0},   // 4923
    {  2,1231,  0,  0,  0,  0},   // 4924
    {  5,197,  0,  0,  0,  0},   // 4925
    {  2,  3,821,  0,  0,  0},   // 4926
    { 13,379,  0,  0,  0,  0},   // 4927
    {  2,  7, 11,  0,  0,  0},   // 4928
    {  3, 31, 53,  0,  0,  0},   // 4929
    {  2,  5, 17, 29,  0,  0},   // 4930
    {  0,  0,  0,  0,  0,  0},   // 4931
    {  2,  3,137,  0,  0,  0},   // 4932
    {  0,  0,  0,  0,  0,  0},   // 4933
    {  2,2467,  0,  0,  0,  0},   // 4934
    {  3,  5,  7, 47,  0,  0},   // 4935
    {  2,617,  0,  0,  0,  0},   // 4936
    {  0,  0,  0,  0,  0,  0},   // 4937
    {  2,  3,823,  0,  0,  0},   // 4938
    { 11,449,  0,  0,  0,  0},   // 4939
    {  2,  5, 13, 19,  0,  0},   // 4940
    {  3, 61,  0,  0,  0,  0},   // 4941
    {  2,  7,353,  0,  0,  0},   // 4942
    {  0,  0,  0,  0,  0,  0},   // 4943
    {  2,  3,103,  0,  0,  0},   // 4944
    {  5, 23, 43,  0,  0,  0},   // 4945
    {  2,2473,  0,  0,  0,  0},   // 4946
    {  3, 17, 97,  0,  0,  0},   // 4947
    {  2,1237,  0,  0,  0,  0},   // 4948
    {  7,101,  0,  0,  0,  0},   // 4949
    {  2,  3,  5, 11,  0,  0},   // 4950
    {  0,  0,  0,  0,  0,  0},   // 4951
    {  2,619,  0,  0,  0,  0},   // 4952
    {  3, 13,127,  0,  0,  0},   // 4953
    {  2,2477,  0,  0,  0,  0},   // 4954
    {  5,991,  0,  0,  0,  0},   // 4955
    {  2,  3,  7, 59,  0,  0},   // 4956
    {  0,  0,  0,  0,  0,  0},   // 4957
    {  2, 37, 67,  0,  0,  0},   // 4958
    {  3, 19, 29,  0,  0,  0},   // 4959
    {  2,  5, 31,  0,  0,  0},   // 4960
    { 11, 41,  0,  0,  0,  0},   // 4961
    {  2,  3,827,  0,  0,  0},   // 4962
    {  7,709,  0,  0,  0,  0},   // 4963
    {  2, 17, 73,  0,  0,  0},   // 4964
    {  3,  5,331,  0,  0,  0},   // 4965
    {  2, 13,191,  0,  0,  0},   // 4966
    {  0,  0,  0,  0,  0,  0},   // 4967
    {  2,  3, 23,  0,  0,  0},   // 4968
    {  0,  0,  0,  0,  0,  0},   // 4969
    {  2,  5,  7, 71,  0,  0},   // 4970
    {  3,1657,  0,  0,  0,  0},   // 4971
    {  2, 11,113,  0,  0,  0},   // 4972
    {  0,  0,  0,  0,  0,  0},   // 4973
    {  2,  3,829,  0,  0,  0},   // 4974
    {  5,199,  0,  0,  0,  0},   // 4975
    {  2,311,  0,  0,  0,  0},   // 4976
    {  3,  7, 79,  0,  0,  0},   // 4977
    {  2, 19,131,  0,  0,  0},   // 4978
    { 13,383,  0,  0,  0,  0},   // 4979
    {  2,  3,  5, 83,  0,  0},   // 4980
    { 17,293,  0,  0,  0,  0},   // 4981
    {  2, 47, 53,  0,  0,  0},   // 4982
    {  3, 11,151,  0,  0,  0},   // 4983
    {  2,  7, 89,  0,  0,  0},   // 4984
    {  5,997,  0,  0,  0,  0},   // 4985
    {  2,  3,277,  0,  0,  0},   // 4986
    {  0,  0,  0,  0,  0,  0},   // 4987
    {  2, 29, 43,  0,  0,  0},   // 4988
    {  3,1663,  0,  0,  0,  0},   // 4989
    {  2,  5,499,  0,  0,  0},   // 4990
    {  7, 23, 31,  0,  0,  0},   // 4991
    {  2,  3, 13,  0,  0,  0},   // 4992
    {  0,  0,  0,  0,  0,  0},   // 4993
    {  2, 11,227,  0,  0,  0},   // 4994
    {  3,  5, 37,  0,  0,  0},   // 4995
    {  2,1249,  0,  0,  0,  0},   // 4996
    { 19,263,  0,  0,  0,  0},   // 4997
    {  2,  3,  7, 17,  0,  0},   // 4998
    {  0,  0,  0,  0,  0,  0},   // 4999
    {  2,  5,  0,  0,  0,  0},   // 5000
    {  3,1667,  0,  0,  0,  0},   // 5001
    {  2, 41, 61,  0,  0,  0},   // 5002
    {  0,  0,  0,  0,  0,  0},   // 5003
    {  2,  3,139,  0,  0,  0},   // 5004
    {  5,  7, 11, 13,  0,  0},   // 5005
    {  2,2503,  0,  0,  0,  0},   // 5006
    {  3,1669,  0,  0,  0,  0},   // 5007
    {  2,313,  0,  0,  0,  0},   // 5008
    {  0,  0,  0,  0,  0,  0},   // 5009
    {  2,  3,  5,167,  0,  0},   // 5010
    {  0,  0,  0,  0,  0,  0},   // 5011
    {  2,  7,179,  0,  0,  0},   // 5012
    {  3,557,  0,  0,  0,  0},   // 5013
    {  2, 23,109,  0,  0,  0},   // 5014
    {  5, 17, 59,  0,  0,  0},   // 5015
    {  2,  3, 11, 19,  0,  0},   // 5016
    { 29,173,  0,  0,  0,  0},   // 5017
    {  2, 13,193,  0,  0,  0},   // 5018
    {  3,  7,239,  0,  0,  0},   // 5019
    {  2,  5,251,  0,  0,  0},   // 5020
    {  0,  0,  0,  0,  0,  0},   // 5021
    {  2,  3, 31,  0,  0,  0},   // 5022
    {  0,  0,  0,  0,  0,  0},   // 5023
    {  2,157,  0,  0,  0,  0},   // 5024
    {  3,  5, 67,  0,  0,  0},   // 5025
    {  2,  7,359,  0,  0,  0},   // 5026
    { 11,457,  0,  0,  0,  0},   // 5027
    {  2,  3,419,  0,  0,  0},   // 5028
    { 47,107,  0,  0,  0,  0},   // 5029
    {  2,  5,503,  0,  0,  0},   // 5030
    {  3, 13, 43,  0,  0,  0},   // 5031
    {  2, 17, 37,  0,  0,  0},   // 5032
    {  7,719,  0,  0,  0,  0},   // 5033
    {  2,  3,839,  0,  0,  0},   // 5034
    {  5, 19, 53,  0,  0,  0},   // 5035
    {  2,1259,  0,  0,  0,  0},   // 5036
    {  3, 23, 73,  0,  0,  0},   // 5037
    {  2, 11,229,  0,  0,  0},   // 5038
    {  0,  0,  0,  0,  0,  0},   // 5039
    {  2,  3,  5,  7,  0,  0},   // 5040
    { 71,  0,  0,  0,  0,  0},   // 5041
    {  2,2521,  0,  0,  0,  0},   // 5042
    {  3, 41,  0,  0,  0,  0},   // 5043
    {  2, 13, 97,  0,  0,  0},   // 5044
    {  5,1009,  0,  0,  0,  0},   // 5045
    {  2,  3, 29,  0,  0,  0},   // 5046
    {  7,103,  0,  0,  0,  0},   // 5047
    {  2,631,  0,  0,  0,  0},   // 5048
    {  3, 11, 17,  0,  0,  0},   // 5049
    {  2,  5,101,  0,  0,  0},   // 5050
    {  0,  0,  0,  0,  0,  0},   // 5051
    {  2,  3,421,  0,  0,  0},   // 5052
    { 31,163,  0,  0,  0,  0},   // 5053
    {  2,  7, 19,  0,  0,  0},   // 5054
    {  3,  5,337,  0,  0,  0},   // 5055
    {  2, 79,  0,  0,  0,  0},   // 5056
    { 13,389,  0,  0,  0,  0},   // 5057
    {  2,  3,281,  0,  0,  0},   // 5058
    {  0,  0,  0,  0,  0,  0},   // 5059
    {  2,  5, 11, 23,  0,  0},   // 5060
    {  3,  7,241,  0,  0,  0},   // 5061
    {  2,2531,  0,  0,  0,  0},   // 5062
    { 61, 83,  0,  0,  0,  0},   // 5063
    {  2,  3,211,  0,  0,  0},   // 5064
    {  5,1013,  0,  0,  0,  0},   // 5065
    {  2, 17,149,  0,  0,  0},   // 5066
    {  3,563,  0,  0,  0,  0},   // 5067
    {  2,  7,181,  0,  0,  0},   // 5068
    { 37,137,  0,  0,  0,  0},   // 5069
    {  2,  3,  5, 13,  0,  0},   // 5070
    { 11,461,  0,  0,  0,  0},   // 5071
    {  2,317,  0,  0,  0,  0},   // 5072
    {  3, 19, 89,  0,  0,  0},   // 5073
    {  2, 43, 59,  0,  0,  0},   // 5074
    {  5,  7, 29,  0,  0,  0},   // 5075
    {  2,  3, 47,  0,  0,  0},   // 5076
    {  0,  0,  0,  0,  0,  0},   // 5077
    {  2,2539,  0,  0,  0,  0},   // 5078
    {  3,1693,  0,  0,  0,  0},   // 5079
    {  2,  5,127,  0,  0,  0},   // 5080
    {  0,  0,  0,  0,  0,  0},   // 5081
    {  2,  3,  7, 11,  0,  0},   // 5082
    { 13, 17, 23,  0,  0,  0},   // 5083
    {  2, 31, 41,  0,  0,  0},   // 5084
    {  3,  5,113,  0,  0,  0},   // 5085
    {  2,2543,  0,  0,  0,  0},   // 5086
    {  0,  0,  0,  0,  0,  0},   // 5087
    {  2,  3, 53,  0,  0,  0},   // 5088
    {  7,727,  0,  0,  0,  0},   // 5089
    {  2,  5,509,  0,  0,  0},   // 5090
    {  3,1697,  0,  0,  0,  0},   // 5091
    {  2, 19, 67,  0,  0,  0},   // 5092
    { 11,463,  0,  0,  0,  0},   // 5093
    {  2,  3,283,  0,  0,  0},   // 5094
    {  5,1019,  0,  0,  0,  0},   // 5095
    {  2,  7, 13,  0,  0,  0},   // 5096
    {  3,1699,  0,  0,  0,  0},   // 5097
    {  2,2549,  0,  0,  0,  0},   // 5098
    {  0,  0,  0,  0,  0,  0},   // 5099
    {  2,  3,  5, 17,  0,  0},   // 5100
    {  0,  0,  0,  0,  0,  0},   // 5101
    {  2,2551,  0,  0,  0,  0},   // 5102
    {  3,  7,  0,  0,  0,  0},   // 5103
    {  2, 11, 29,  0,  0,  0},   // 5104
    {  5,1021,  0,  0,  0,  0},   // 5105
    {  2,  3, 23, 37,  0,  0},   // 5106
    {  0,  0,  0,  0,  0,  0},   // 5107
    {  2,1277,  0,  0,  0,  0},   // 5108
    {  3, 13,131,  0,  0,  0},   // 5109
    {  2,  5,  7, 73,  0,  0},   // 5110
    { 19,269,  0,  0,  0,  0},   // 5111
    {  2,  3, 71,  0,  0,  0},   // 5112
    {  0,  0,  0,  0,  0,  0},   // 5113
    {  2,2557,  0,  0,  0,  0},   // 5114
    {  3,  5, 11, 31,  0,  0},   // 5115
    {  2,1279,  0,  0,  0,  0},   // 5116
    {  7, 17, 43,  0,  0,  0},   // 5117
    {  2,  3,853,  0,  0,  0},   // 5118
    {  0,  0,  0,  0,  0,  0},   // 5119
    {  2,  5,  0,  0,  0,  0},   // 5120
    {  3,569,  0,  0,  0,  0},   // 5121
    {  2, 13,197,  0,  0,  0},   // 5122
    { 47,109,  0,  0,  0,  0},   // 5123
    {  2,  3,  7, 61,  0,  0},   // 5124
    {  5, 41,  0,  0,  0,  0},   // 5125
    {  2, 11,233,  0,  0,  0},   // 5126
    {  3,1709,  0,  0,  0,  0},   // 5127
    {  2,641,  0,  0,  0,  0},   // 5128
    { 23,223,  0,  0,  0,  0},   // 5129
    {  2,  3,  5, 19,  0,  0},   // 5130
    {  7,733,  0,  0,  0,  0},   // 5131
    {  2,1283,  0,  0,  0,  0},   // 5132
    {  3, 29, 59,  0,  0,  0},   // 5133
    {  2, 17,151,  0,  0,  0},   // 5134
    {  5, 13, 79,  0,  0,  0},   // 5135
    {  2,  3,107,  0,  0,  0},   // 5136
    { 11,467,  0,  0,  0,  0},   // 5137
    {  2,  7,367,  0,  0,  0},   // 5138
    {  3,571,  0,  0,  0,  0},   // 5139
    {  2,  5,257,  0,  0,  0},   // 5140
    { 53, 97,  0,  0,  0,  0},   // 5141
    {  2,  3,857,  0,  0,  0},   // 5142
    { 37,139,  0,  0,  0,  0},   // 5143
    {  2,643,  0,  0,  0,  0},   // 5144
    {  3,  5,  7,  0,  0,  0},   // 5145
    {  2, 31, 83,  0,  0,  0},   // 5146
    {  0,  0,  0,  0,  0,  0},   // 5147
    {  2,  3, 11, 13,  0,  0},   // 5148
    { 19,271,  0,  0,  0,  0},   // 5149
    {  2,  5,103,  0,  0,  0},   // 5150
    {  3, 17,101,  0,  0,  0},   // 5151
    {  2,  7, 23,  0,  0,  0},   // 5152
    {  0,  0,  0,  0,  0,  0},   // 5153
    {  2,  3,859,  0,  0,  0},   // 5154
    {  5,1031,  0,  0,  0,  0},   // 5155
    {  2,1289,  0,  0,  0,  0},   // 5156
    {  3,191,  0,  0,  0,  0},   // 5157
    {  2,2579,  0,  0,  0,  0},   // 5158
    {  7, 11, 67,  0,  0,  0},   // 5159
    {  2,  3,  5, 43,  0,  0},   // 5160
    { 13,397,  0,  0,  0,  0},   // 5161
    {  2, 29, 89,  0,  0,  0},   // 5162
    {  3,1721,  0,  0,  0,  0},   // 5163
    {  2,1291,  0,  0,  0,  0},   // 5164
    {  5,1033,  0,  0,  0,  0},   // 5165
    {  2,  3,  7, 41,  0,  0},   // 5166
    {  0,  0,  0,  0,  0,  0},   // 5167
    {  2, 17, 19,  0,  0,  0},   // 5168
    {  3,1723,  0,  0,  0,  0},   // 5169
    {  2,  5, 11, 47,  0,  0},   // 5170
    {  0,  0,  0,  0,  0,  0},   // 5171
    {  2,  3,431,  0,  0,  0},   // 5172
    {  7,739,  0,  0,  0,  0},   // 5173
    {  2, 13,199,  0,  0,  0},   // 5174
    {  3,  5, 23,  0,  0,  0},   // 5175
    {  2,647,  0,  0,  0,  0},   // 5176
    { 31,167,  0,  0,  0,  0},   // 5177
    {  2,  3,863,  0,  0,  0},   // 5178
    {  0,  0,  0,  0,  0,  0},   // 5179
    {  2,  5,  7, 37,  0,  0},   // 5180
    {  3, 11,157,  0,  0,  0},   // 5181
    {  2,2591,  0,  0,  0,  0},   // 5182
    { 71, 73,  0,  0,  0,  0},   // 5183
    {  2,  3,  0,  0,  0,  0},   // 5184
    {  5, 17, 61,  0,  0,  0},   // 5185
    {  2,2593,  0,  0,  0,  0},   // 5186
    {  3,  7, 13, 19,  0,  0},   // 5187
    {  2,1297,  0,  0,  0,  0},   // 5188
    {  0,  0,  0,  0,  0,  0},   // 5189
    {  2,  3,  5,173,  0,  0},   // 5190
    { 29,179,  0,  0,  0,  0},   // 5191
    {  2, 11, 59,  0,  0,  0},   // 5192
    {  3,577,  0,  0,  0,  0},   // 5193
    {  2,  7, 53,  0,  0,  0},   // 5194
    {  5,1039,  0,  0,  0,  0},   // 5195
    {  2,  3,433,  0,  0,  0},   // 5196
    {  0,  0,  0,  0,  0,  0},   // 5197
    {  2, 23,113,  0,  0,  0},   // 5198
    {  3,1733,  0,  0,  0,  0},   // 5199
    {  2,  5, 13,  0,  0,  0},   // 5200
    {  7,743,  0,  0,  0,  0},   // 5201
    {  2,  3, 17,  0,  0,  0},   // 5202
    { 11, 43,  0,  0,  0,  0},   // 5203
    {  2,1301,  0,  0,  0,  0},   // 5204
    {  3,  5,347,  0,  0,  0},   // 5205
    {  2, 19,137,  0,  0,  0},   // 5206
    { 41,127,  0,  0,  0,  0},   // 5207
    {  2,  3,  7, 31,  0,  0},   // 5208
    {  0,  0,  0,  0,  0,  0},   // 5209
    {  2,  5,521,  0,  0,  0},   // 5210
    {  3,193,  0,  0,  0,  0},   // 5211
    {  2,1303,  0,  0,  0,  0},   // 5212
    { 13,401,  0,  0,  0,  0},   // 5213
    {  2,  3, 11, 79,  0,  0},   // 5214
    {  5,  7,149,  0,  0,  0},   // 5215
    {  2,163,  0,  0,  0,  0},   // 5216
    {  3, 37, 47,  0,  0,  0},   // 5217
    {  2,2609,  0,  0,  0,  0},   // 5218
    { 17,307,  0,  0,  0,  0},   // 5219
    {  2,  3,  5, 29,  0,  0},   // 5220
    { 23,227,  0,  0,  0,  0},   // 5221
    {  2,  7,373,  0,  0,  0},   // 5222
    {  3,1741,  0,  0,  0,  0},   // 5223
    {  2,653,  0,  0,  0,  0},   // 5224
    {  5, 11, 19,  0,  0,  0},   // 5225
    {  2,  3, 13, 67,  0,  0},   // 5226
    {  0,  0,  0,  0,  0,  0},   // 5227
    {  2,1307,  0,  0,  0,  0},   // 5228
    {  3,  7, 83,  0,  0,  0},   // 5229
    {  2,  5,523,  0,  0,  0},   // 5230
    {  0,  0,  0,  0,  0,  0},   // 5231
    {  2,  3,109,  0,  0,  0},   // 5232
    {  0,  0,  0,  0,  0,  0},   // 5233
    {  2,2617,  0,  0,  0,  0},   // 5234
    {  3,  5,349,  0,  0,  0},   // 5235
    {  2,  7, 11, 17,  0,  0},   // 5236
    {  0,  0,  0,  0,  0,  0},   // 5237
    {  2,  3, 97,  0,  0,  0},   // 5238
    { 13, 31,  0,  0,  0,  0},   // 5239
    {  2,  5,131,  0,  0,  0},   // 5240
    {  3,1747,  0,  0,  0,  0},   // 5241
    {  2,2621,  0,  0,  0,  0},   // 5242
    {  7,107,  0,  0,  0,  0},   // 5243
    {  2,  3, 19, 23,  0,  0},   // 5244
    {  5,1049,  0,  0,  0,  0},   // 5245
    {  2, 43, 61,  0,  0,  0},   // 5246
    {  3, 11, 53,  0,  0,  0},   // 5247
    {  2, 41,  0,  0,  0,  0},   // 5248
    { 29,181,  0,  0,  0,  0},   // 5249
    {  2,  3,  5,  7,  0,  0},   // 5250
    { 59, 89,  0,  0,  0,  0},   // 5251
    {  2, 13,101,  0,  0,  0},   // 5252
    {  3, 17,103,  0,  0,  0},   // 5253
    {  2, 37, 71,  0,  0,  0},   // 5254
    {  5,1051,  0,  0,  0,  0},   // 5255
    {  2,  3, 73,  0,  0,  0},   // 5256
    {  7,751,  0,  0,  0,  0},   // 5257
    {  2, 11,239,  0,  0,  0},   // 5258
    {  3,1753,  0,  0,  0,  0},   // 5259
    {  2,  5,263,  0,  0,  0},   // 5260
    {  0,  0,  0,  0,  0,  0},   // 5261
    {  2,  3,877,  0,  0,  0},   // 5262
    { 19,277,  0,  0,  0,  0},   // 5263
    {  2,  7, 47,  0,  0,  0},   // 5264
    {  3,  5, 13,  0,  0,  0},   // 5265
    {  2,2633,  0,  0,  0,  0},   // 5266
    { 23,229,  0,  0,  0,  0},   // 5267
    {  2,  3,439,  0,  0,  0},   // 5268
    { 11,479,  0,  0,  0,  0},   // 5269
    {  2,  5, 17, 31,  0,  0},   // 5270
    {  3,  7,251,  0,  0,  0},   // 5271
    {  2,659,  0,  0,  0,  0},   // 5272
    {  0,  0,  0,  0,  0,  0},   // 5273
    {  2,  3,293,  0,  0,  0},   // 5274
    {  5,211,  0,  0,  0,  0},   // 5275
    {  2,1319,  0,  0,  0,  0},   // 5276
    {  3,1759,  0,  0,  0,  0},   // 5277
    {  2,  7, 13, 29,  0,  0},   // 5278
    {  0,  0,  0,  0,  0,  0},   // 5279
    {  2,  3,  5, 11,  0,  0},   // 5280
    {  0,  0,  0,  0,  0,  0},   // 5281
    {  2, 19,139,  0,  0,  0},   // 5282
    {  3,587,  0,  0,  0,  0},   // 5283
    {  2,1321,  0,  0,  0,  0},   // 5284
    {  5,  7,151,  0,  0,  0},   // 5285
    {  2,  3,881,  0,  0,  0},   // 5286
    { 17,311,  0,  0,  0,  0},   // 5287
    {  2,661,  0,  0,  0,  0},   // 5288
    {  3, 41, 43,  0,  0,  0},   // 5289
    {  2,  5, 23,  0,  0,  0},   // 5290
    { 11, 13, 37,  0,  0,  0},   // 5291
    {  2,  3,  7,  0,  0,  0},   // 5292
    { 67, 79,  0,  0,  0,  0},   // 5293
    {  2,2647,  0,  0,  0,  0},   // 5294
    {  3,  5,353,  0,  0,  0},   // 5295
    {  2,331,  0,  0,  0,  0},   // 5296
    {  0,  0,  0,  0,  0,  0},   // 5297
    {  2,  3,883,  0,  0,  0},   // 5298
    {  7,757,  0,  0,  0,  0},   // 5299
    {  2,  5, 53,  0,  0,  0},   // 5300
    {  3, 19, 31,  0,  0,  0},   // 5301
    {  2, 11,241,  0,  0,  0},   // 5302
    {  0,  0,  0,  0,  0,  0},   // 5303
    {  2,  3, 13, 17,  0,  0},   // 5304
    {  5,1061,  0,  0,  0,  0},   // 5305
    {  2,  7,379,  0,  0,  0},   // 5306
    {  3, 29, 61,  0,  0,  0},   // 5307
    {  2,1327,  0,  0,  0,  0},   // 5308
    {  0,  0,  0,  0,  0,  0},   // 5309
    {  2,  3,  5, 59,  0,  0},   // 5310
    { 47,113,  0,  0,  0,  0},   // 5311
    {  2, 83,  0,  0,  0,  0},   // 5312
    {  3,  7, 11, 23,  0,  0},   // 5313
    {  2,2657,  0,  0,  0,  0},   // 5314
    {  5,1063,  0,  0,  0,  0},   // 5315
    {  2,  3,443,  0,  0,  0},   // 5316
    { 13,409,  0,  0,  0,  0},   // 5317
    {  2,2659,  0,  0,  0,  0},   // 5318
    {  3,197,  0,  0,  0,  0},   // 5319
    {  2,  5,  7, 19,  0,  0},   // 5320
    { 17,313,  0,  0,  0,  0},   // 5321
    {  2,  3,887,  0,  0,  0},   // 5322
    {  0,  0,  0,  0,  0,  0},   // 5323
    {  2, 11,  0,  0,  0,  0},   // 5324
    {  3,  5, 71,  0,  0,  0},   // 5325
    {  2,2663,  0,  0,  0,  0},   // 5326
    {  7,761,  0,  0,  0,  0},   // 5327
    {  2,  3, 37,  0,  0,  0},   // 5328
    { 73,  0,  0,  0,  0,  0},   // 5329
    {  2,  5, 13, 41,  0,  0},   // 5330
    {  3,1777,  0,  0,  0,  0},   // 5331
    {  2, 31, 43,  0,  0,  0},   // 5332
    {  0,  0,  0,  0,  0,  0},   // 5333
    {  2,  3,  7,127,  0,  0},   // 5334
    {  5, 11, 97,  0,  0,  0},   // 5335
    {  2, 23, 29,  0,  0,  0},   // 5336
    {  3,593,  0,  0,  0,  0},   // 5337
    {  2, 17,157,  0,  0,  0},   // 5338
    { 19,281,  0,  0,  0,  0},   // 5339
    {  2,  3,  5, 89,  0,  0},   // 5340
    {  7,109,  0,  0,  0,  0},   // 5341
    {  2,2671,  0,  0,  0,  0},   // 5342
    {  3, 13,137,  0,  0,  0},   // 5343
    {  2,167,  0,  0,  0,  0},   // 5344
    {  5,1069,  0,  0,  0,  0},   // 5345
    {  2,  3, 11,  0,  0,  0},   // 5346
    {  0,  0,  0,  0,  0,  0},   // 5347
    {  2,  7,191,  0,  0,  0},   // 5348
    {  3,1783,  0,  0,  0,  0},   // 5349
    {  2,  5,107,  0,  0,  0},   // 5350
    {  0,  0,  0,  0,  0,  0},   // 5351
    {  2,  3,223,  0,  0,  0},   // 5352
    { 53,101,  0,  0,  0,  0},   // 5353
    {  2,2677,  0,  0,  0,  0},   // 5354
    {  3,  5,  7, 17,  0,  0},   // 5355
    {  2, 13,103,  0,  0,  0},   // 5356
    { 11,487,  0,  0,  0,  0},   // 5357
    {  2,  3, 19, 47,  0,  0},   // 5358
    { 23,233,  0,  0,  0,  0},   // 5359
    {  2,  5, 67,  0,  0,  0},   // 5360
    {  3,1787,  0,  0,  0,  0},   // 5361
    {  2,  7,383,  0,  0,  0},   // 5362
    { 31,173,  0,  0,  0,  0},   // 5363
    {  2,  3,149,  0,  0,  0},   // 5364
    {  5, 29, 37,  0,  0,  0},   // 5365
    {  2,2683,  0,  0,  0,  0},   // 5366
    {  3,1789,  0,  0,  0,  0},   // 5367
    {  2, 11, 61,  0,  0,  0},   // 5368
    {  7, 13, 59,  0,  0,  0},   // 5369
    {  2,  3,  5,179,  0,  0},   // 5370
    { 41,131,  0,  0,  0,  0},   // 5371
    {  2, 17, 79,  0,  0,  0},   // 5372
    {  3,199,  0,  0,  0,  0},   // 5373
    {  2,2687,  0,  0,  0,  0},   // 5374
    {  5, 43,  0,  0,  0,  0},   // 5375
    {  2,  3,  7,  0,  0,  0},   // 5376
    { 19,283,  0,  0,  0,  0},   // 5377
    {  2,2689,  0,  0,  0,  0},   // 5378
    {  3, 11,163,  0,  0,  0},   // 5379
    {  2,  5,269,  0,  0,  0},   // 5380
    {  0,  0,  0,  0,  0,  0},   // 5381
    {  2,  3, 13, 23,  0,  0},   // 5382
    {  7,769,  0,  0,  0,  0},   // 5383
    {  2,673,  0,  0,  0,  0},   // 5384
    {  3,  5,359,  0,  0,  0},   // 5385
    {  2,2693,  0,  0,  0,  0},   // 5386
    {  0,  0,  0,  0,  0,  0},   // 5387
    {  2,  3,449,  0,  0,  0},   // 5388
    { 17,317,  0,  0,  0,  0},   // 5389
    {  2,  5,  7, 11,  0,  0},   // 5390
    {  3,599,  0,  0,  0,  0},   // 5391
    {  2,337,  0,  0,  0,  0},   // 5392
    {  0,  0,  0,  0,  0,  0},   // 5393
    {  2,  3, 29, 31,  0,  0},   // 5394
    {  5, 13, 83,  0,  0,  0},   // 5395
    {  2, 19, 71,  0,  0,  0},   // 5396
    {  3,  7,257,  0,  0,  0},   // 5397
    {  2,2699,  0,  0,  0,  0},   // 5398
    {  0,  0,  0,  0,  0,  0},   // 5399
    {  2,  3,  5,  0,  0,  0},   // 5400
    { 11,491,  0,  0,  0,  0},   // 5401
    {  2, 37, 73,  0,  0,  0},   // 5402
    {  3,1801,  0,  0,  0,  0},   // 5403
    {  2,  7,193,  0,  0,  0},   // 5404
    {  5, 23, 47,  0,  0,  0},   // 5405
    {  2,  3, 17, 53,  0,  0},   // 5406
    {  0,  0,  0,  0,  0,  0},   // 5407
    {  2, 13,  0,  0,  0,  0},   // 5408
    {  3,601,  0,  0,  0,  0},   // 5409
    {  2,  5,541,  0,  0,  0},   // 5410
    {  7,773,  0,  0,  0,  0},   // 5411
    {  2,  3, 11, 41,  0,  0},   // 5412
    {  0,  0,  0,  0,  0,  0},   // 5413
    {  2,2707,  0,  0,  0,  0},   // 5414
    {  3,  5, 19,  0,  0,  0},   // 5415
    {  2,677,  0,  0,  0,  0},   // 5416
    {  0,  0,  0,  0,  0,  0},   // 5417
    {  2,  3,  7, 43,  0,  0},   // 5418
    {  0,  0,  0,  0,  0,  0},   // 5419
    {  2,  5,271,  0,  0,  0},   // 5420
    {  3, 13,139,  0,  0,  0},   // 5421
    {  2,2711,  0,  0,  0,  0},   // 5422
    { 11, 17, 29,  0,  0,  0},   // 5423
    {  2,  3,113,  0,  0,  0},   // 5424
    {  5,  7, 31,  0,  0,  0},   // 5425
    {  2,2713,  0,  0,  0,  0},   // 5426
    {  3, 67,  0,  0,  0,  0},   // 5427
    {  2, 23, 59,  0,  0,  0},   // 5428
    { 61, 89,  0,  0,  0,  0},   // 5429
    {  2,  3,  5,181,  0,  0},   // 5430
    {  0,  0,  0,  0,  0,  0},   // 5431
    {  2,  7, 97,  0,  0,  0},   // 5432
    {  3,1811,  0,  0,  0,  0},   // 5433
    {  2, 11, 13, 19,  0,  0},   // 5434
    {  5,1087,  0,  0,  0,  0},   // 5435
    {  2,  3,151,  0,  0,  0},   // 5436
    {  0,  0,  0,  0,  0,  0},   // 5437
    {  2,2719,  0,  0,  0,  0},   // 5438
    {  3,  7, 37,  0,  0,  0},   // 5439
    {  2,  5, 17,  0,  0,  0},   // 5440
    {  0,  0,  0,  0,  0,  0},   // 5441
    {  2,  3,907,  0,  0,  0},   // 5442
    {  0,  0,  0,  0,  0,  0},   // 5443
    {  2,1361,  0,  0,  0,  0},   // 5444
    {  3,  5, 11,  0,  0,  0},   // 5445
    {  2,  7,389,  0,  0,  0},   // 5446
    { 13,419,  0,  0,  0,  0},   // 5447
    {  2,  3,227,  0,  0,  0},   // 5448
    {  0,  0,  0,  0,  0,  0},   // 5449
    {  2,  5,109,  0,  0,  0},   // 5450
    {  3, 23, 79,  0,  0,  0},   // 5451
    {  2, 29, 47,  0,  0,  0},   // 5452
    {  7, 19, 41,  0,  0,  0},   // 5453
    {  2,  3,101,  0,  0,  0},   // 5454
    {  5,1091,  0,  0,  0,  0},   // 5455
    {  2, 11, 31,  0,  0,  0},   // 5456
    {  3, 17,107,  0,  0,  0},   // 5457
    {  2,2729,  0,  0,  0,  0},   // 5458
    { 53,103,  0,  0,  0,  0},   // 5459
    {  2,  3,  5,  7, 13,  0},   // 5460
    { 43,127,  0,  0,  0,  0},   // 5461
    {  2,2731,  0,  0,  0,  0},   // 5462
    {  3,607,  0,  0,  0,  0},   // 5463
    {  2,683,  0,  0,  0,  0},   // 5464
    {  5,1093,  0,  0,  0,  0},   // 5465
    {  2,  3,911,  0,  0,  0},   // 5466
    {  7, 11, 71,  0,  0,  0},   // 5467
    {  2,1367,  0,  0,  0,  0},   // 5468
    {  3,1823,  0,  0,  0,  0},   // 5469
    {  2,  5,547,  0,  0,  0},   // 5470
    {  0,  0,  0,  0,  0,  0},   // 5471
    {  2,  3, 19,  0,  0,  0},   // 5472
    { 13,421,  0,  0,  0,  0},   // 5473
    {  2,  7, 17, 23,  0,  0},   // 5474
    {  3,  5, 73,  0,  0,  0},   // 5475
    {  2, 37,  0,  0,  0,  0},   // 5476
    {  0,  0,  0,  0,  0,  0},   // 5477
    {  2,  3, 11, 83,  0,  0},   // 5478
    {  0,  0,  0,  0,  0,  0},   // 5479
    {  2,  5,137,  0,  0,  0},   // 5480
    {  3,  7, 29,  0,  0,  0},   // 5481
    {  2,2741,  0,  0,  0,  0},   // 5482
    {  0,  0,  0,  0,  0,  0},   // 5483
    {  2,  3,457,  0,  0,  0},   // 5484
    {  5,1097,  0,  0,  0,  0},   // 5485
    {  2, 13,211,  0,  0,  0},   // 5486
    {  3, 31, 59,  0,  0,  0},   // 5487
    {  2,  7,  0,  0,  0,  0},   // 5488
    { 11,499,  0,  0,  0,  0},   // 5489
    {  2,  3,  5, 61,  0,  0},   // 5490
    { 17, 19,  0,  0,  0,  0},   // 5491
    {  2,1373,  0,  0,  0,  0},   // 5492
    {  3,1831,  0,  0,  0,  0},   // 5493
    {  2, 41, 67,  0,  0,  0},   // 5494
    {  5,  7,157,  0,  0,  0},   // 5495
    {  2,  3,229,  0,  0,  0},   // 5496
    { 23,239,  0,  0,  0,  0},   // 5497
    {  2,2749,  0,  0,  0,  0},   // 5498
    {  3, 13, 47,  0,  0,  0},   // 5499
    {  2,  5, 11,  0,  0,  0},   // 5500
    {  0,  0,  0,  0,  0,  0},   // 5501
    {  2,  3,  7,131,  0,  0},   // 5502
    {  0,  0,  0,  0,  0,  0},   // 5503
    {  2, 43,  0,  0,  0,  0},   // 5504
    {  3,  5,367,  0,  0,  0},   // 5505
    {  2,2753,  0,  0,  0,  0},   // 5506
    {  0,  0,  0,  0,  0,  0},   // 5507
    {  2,  3, 17,  0,  0,  0},   // 5508
    {  7,787,  0,  0,  0,  0},   // 5509
    {  2,  5, 19, 29,  0,  0},   // 5510
    {  3, 11,167,  0,  0,  0},   // 5511
    {  2, 13, 53,  0,  0,  0},   // 5512
    { 37,149,  0,  0,  0,  0},   // 5513
    {  2,  3,919,  0,  0,  0},   // 5514
    {  5,1103,  0,  0,  0,  0},   // 5515
    {  2,  7,197,  0,  0,  0},   // 5516
    {  3,613,  0,  0,  0,  0},   // 5517
    {  2, 31, 89,  0,  0,  0},   // 5518
    {  0,  0,  0,  0,  0,  0},   // 5519
    {  2,  3,  5, 23,  0,  0},   // 5520
    {  0,  0,  0,  0,  0,  0},   // 5521
    {  2, 11,251,  0,  0,  0},   // 5522
    {  3,  7,263,  0,  0,  0},   // 5523
    {  2,1381,  0,  0,  0,  0},   // 5524
    {  5, 13, 17,  0,  0,  0},   // 5525
    {  2,  3,307,  0,  0,  0},   // 5526
    {  0,  0,  0,  0,  0,  0},   // 5527
    {  2,691,  0,  0,  0,  0},   // 5528
    {  3, 19, 97,  0,  0,  0},   // 5529
    {  2,  5,  7, 79,  0,  0},   // 5530
    {  0,  0,  0,  0,  0,  0},   // 5531
    {  2,  3,461,  0,  0,  0},   // 5532
    { 11,503,  0,  0,  0,  0},   // 5533
    {  2,2767,  0,  0,  0,  0},   // 5534
    {  3,  5, 41,  0,  0,  0},   // 5535
    {  2,173,  0,  0,  0,  0},   // 5536
    {  7,113,  0,  0,  0,  0},   // 5537
    {  2,  3, 13, 71,  0,  0},   // 5538
    { 29,191,  0,  0,  0,  0},   // 5539
    {  2,  5,277,  0,  0,  0},   // 5540
    {  3,1847,  0,  0,  0,  0},   // 5541
    {  2, 17,163,  0,  0,  0},   // 5542
    { 23,241,  0,  0,  0,  0},   // 5543
    {  2,  3,  7, 11,  0,  0},   // 5544
    {  5,1109,  0,  0,  0,  0},   // 5545
    {  2, 47, 59,  0,  0,  0},   // 5546
    {  3, 43,  0,  0,  0,  0},   // 5547
    {  2, 19, 73,  0,  0,  0},   // 5548
    { 31,179,  0,  0,  0,  0},   // 5549
    {  2,  3,  5, 37,  0,  0},   // 5550
    {  7, 13, 61,  0,  0,  0},   // 5551
    {  2,347,  0,  0,  0,  0},   // 5552
    {  3,617,  0,  0,  0,  0},   // 5553
    {  2,2777,  0,  0,  0,  0},   // 5554
    {  5, 11,101,  0,  0,  0},   // 5555
    {  2,  3,463,  0,  0,  0},   // 5556
    {  0,  0,  0,  0,  0,  0},   // 5557
    {  2,  7,397,  0,  0,  0},   // 5558
    {  3, 17,109,  0,  0,  0},   // 5559
    {  2,  5,139,  0,  0,  0},   // 5560
    { 67, 83,  0,  0,  0,  0},   // 5561
    {  2,  3,103,  0,  0,  0},   // 5562
    {  0,  0,  0,  0,  0,  0},   // 5563
    {  2, 13,107,  0,  0,  0},   // 5564
    {  3,  5,  7, 53,  0,  0},   // 5565
    {  2, 11, 23,  0,  0,  0},   // 5566
    { 19,293,  0,  0,  0,  0},   // 5567
    {  2,  3, 29,  0,  0,  0},   // 5568
    {  0,  0,  0,  0,  0,  0},   // 5569
    {  2,  5,557,  0,  0,  0},   // 5570
    {  3,619,  0,  0,  0,  0},   // 5571
    {  2,  7,199,  0,  0,  0},   // 5572
    {  0,  0,  0,  0,  0,  0},   // 5573
    {  2,  3,929,  0,  0,  0},   // 5574
    {  5,223,  0,  0,  0,  0},   // 5575
    {  2, 17, 41,  0,  0,  0},   // 5576
    {  3, 11, 13,  0,  0,  0},   // 5577
    {  2,2789,  0,  0,  0,  0},   // 5578
    {  7,797,  0,  0,  0,  0},   // 5579
    {  2,  3,  5, 31,  0,  0},   // 5580
    {  0,  0,  0,  0,  0,  0},   // 5581
    {  2,2791,  0,  0,  0,  0},   // 5582
    {  3,1861,  0,  0,  0,  0},   // 5583
    {  2,349,  0,  0,  0,  0},   // 5584
    {  5,1117,  0,  0,  0,  0},   // 5585
    {  2,  3,  7, 19,  0,  0},   // 5586
    { 37,151,  0,  0,  0,  0},   // 5587
    {  2, 11,127,  0,  0,  0},   // 5588
    {  3, 23,  0,  0,  0,  0},   // 5589
    {  2,  5, 13, 43,  0,  0},   // 5590
    {  0,  0,  0,  0,  0,  0},   // 5591
    {  2,  3,233,  0,  0,  0},   // 5592
    {  7, 17, 47,  0,  0,  0},   // 5593
    {  2,2797,  0,  0,  0,  0},   // 5594
    {  3,  5,373,  0,  0,  0},   // 5595
    {  2,1399,  0,  0,  0,  0},   // 5596
    { 29,193,  0,  0,  0,  0},   // 5597
    {  2,  3,311,  0,  0,  0},   // 5598
    { 11,509,  0,  0,  0,  0},   // 5599
    {  2,  5,  7,  0,  0,  0},   // 5600
    {  3,1867,  0,  0,  0,  0},   // 5601
    {  2,2801,  0,  0,  0,  0},   // 5602
    { 13,431,  0,  0,  0,  0},   // 5603
    {  2,  3,467,  0,  0,  0},   // 5604
    {  5, 19, 59,  0,  0,  0},   // 5605
    {  2,2803,  0,  0,  0,  0},   // 5606
    {  3,  7, 89,  0,  0,  0},   // 5607
    {  2,701,  0,  0,  0,  0},   // 5608
    { 71, 79,  0,  0,  0,  0},   // 5609
    {  2,  3,  5, 11, 17,  0},   // 5610
    { 31,181,  0,  0,  0,  0},   // 5611
    {  2, 23, 61,  0,  0,  0},   // 5612
    {  3,1871,  0,  0,  0,  0},   // 5613
    {  2,  7,401,  0,  0,  0},   // 5614
    {  5,1123,  0,  0,  0,  0},   // 5615
    {  2,  3, 13,  0,  0,  0},   // 5616
    { 41,137,  0,  0,  0,  0},   // 5617
    {  2, 53,  0,  0,  0,  0},   // 5618
    {  3,1873,  0,  0,  0,  0},   // 5619
    {  2,  5,281,  0,  0,  0},   // 5620
    {  7, 11, 73,  0,  0,  0},   // 5621
    {  2,  3,937,  0,  0,  0},   // 5622
    {  0,  0,  0,  0,  0,  0},   // 5623
    {  2, 19, 37,  0,  0,  0},   // 5624
    {  3,  5,  0,  0,  0,  0},   // 5625
    {  2, 29, 97,  0,  0,  0},   // 5626
    { 17,331,  0,  0,  0,  0},   // 5627
    {  2,  3,  7, 67,  0,  0},   // 5628
    { 13,433,  0,  0,  0,  0},   // 5629
    {  2,  5,563,  0,  0,  0},   // 5630
    {  3,1877,  0,  0,  0,  0},   // 5631
    {  2, 11,  0,  0,  0,  0},   // 5632
    { 43,131,  0,  0,  0,  0},   // 5633
    {  2,  3,313,  0,  0,  0},   // 5634
    {  5,  7, 23,  0,  0,  0},   // 5635
    {  2,1409,  0,  0,  0,  0},   // 5636
    {  3,1879,  0,  0,  0,  0},   // 5637
    {  2,2819,  0,  0,  0,  0},   // 5638
    {  0,  0,  0,  0,  0,  0},   // 5639
    {  2,  3,  5, 47,  0,  0},   // 5640
    {  0,  0,  0,  0,  0,  0},   // 5641
    {  2,  7, 13, 31,  0,  0},   // 5642
    {  3, 11, 19,  0,  0,  0},   // 5643
    {  2, 17, 83,  0,  0,  0},   // 5644
    {  5,1129,  0,  0,  0,  0},   // 5645
    {  2,  3,941,  0,  0,  0},   // 5646
    {  0,  0,  0,  0,  0,  0},   // 5647
    {  2,353,  0,  0,  0,  0},   // 5648
    {  3,  7,269,  0,  0,  0},   // 5649
    {  2,  5,113,  0,  0,  0},   // 5650
    {  0,  0,  0,  0,  0,  0},   // 5651
    {  2,  3,157,  0,  0,  0},   // 5652
    {  0,  0,  0,  0,  0,  0},   // 5653
    {  2, 11,257,  0,  0,  0},   // 5654
    {  3,  5, 13, 29,  0,  0},   // 5655
    {  2,  7,101,  0,  0,  0},   // 5656
    {  0,  0,  0,  0,  0,  0},   // 5657
    {  2,  3, 23, 41,  0,  0},   // 5658
    {  0,  0,  0,  0,  0,  0},   // 5659
    {  2,  5,283,  0,  0,  0},   // 5660
    {  3, 17, 37,  0,  0,  0},   // 5661
    {  2, 19,149,  0,  0,  0},   // 5662
    {  7,809,  0,  0,  0,  0},   // 5663
    {  2,  3, 59,  0,  0,  0},   // 5664
    {  5, 11,103,  0,  0,  0},   // 5665
    {  2,2833,  0,  0,  0,  0},   // 5666
    {  3,1889,  0,  0,  0,  0},   // 5667
    {  2, 13,109,  0,  0,  0},   // 5668
    {  0,  0,  0,  0,  0,  0},   // 5669
    {  2,  3,  5,  7,  0,  0},   // 5670
    { 53,107,  0,  0,  0,  0},   // 5671
    {  2,709,  0,  0,  0,  0},   // 5672
    {  3, 31, 61,  0,  0,  0},   // 5673
    {  2,2837,  0,  0,  0,  0},   // 5674
    {  5,227,  0,  0,  0,  0},   // 5675
    {  2,  3, 11, 43,  0,  0},   // 5676
    {  7,811,  0,  0,  0,  0},   // 5677
    {  2, 17,167,  0,  0,  0},   // 5678
    {  3,631,  0,  0,  0,  0},   // 5679
    {  2,  5, 71,  0,  0,  0},   // 5680
    { 13, 19, 23,  0,  0,  0},   // 5681
    {  2,  3,947,  0,  0,  0},   // 5682
    {  0,  0,  0,  0,  0,  0},   // 5683
    {  2,  7, 29,  0,  0,  0},   // 5684
    {  3,  5,379,  0,  0,  0},   // 5685
    {  2,2843,  0,  0,  0,  0},   // 5686
    { 11, 47,  0,  0,  0,  0},   // 5687
    {  2,  3, 79,  0,  0,  0},   // 5688
    {  0,  0,  0,  0,  0,  0},   // 5689
    {  2,  5,569,  0,  0,  0},   // 5690
    {  3,  7,271,  0,  0,  0},   // 5691
    {  2,1423,  0,  0,  0,  0},   // 5692
    {  0,  0,  0,  0,  0,  0},   // 5693
    {  2,  3, 13, 73,  0,  0},   // 5694
    {  5, 17, 67,  0,  0,  0},   // 5695
    {  2, 89,  0,  0,  0,  0},   // 5696
    {  3,211,  0,  0,  0,  0},   // 5697
    {  2,  7, 11, 37,  0,  0},   // 5698
    { 41,139,  0,  0,  0,  0},   // 5699
    {  2,  3,  5, 19,  0,  0},   // 5700
    {  0,  0,  0,  0,  0,  0},   // 5701
    {  2,2851,  0,  0,  0,  0},   // 5702
    {  3,1901,  0,  0,  0,  0},   // 5703
    {  2, 23, 31,  0,  0,  0},   // 5704
    {  5,  7,163,  0,  0,  0},   // 5705
    {  2,  3,317,  0,  0,  0},   // 5706
    { 13,439,  0,  0,  0,  0},   // 5707
    {  2,1427,  0,  0,  0,  0},   // 5708
    {  3, 11,173,  0,  0,  0},   // 5709
    {  2,  5,571,  0,  0,  0},   // 5710
    {  0,  0,  0,  0,  0,  0},   // 5711
    {  2,  3,  7, 17,  0,  0},   // 5712
    { 29,197,  0,  0,  0,  0},   // 5713
    {  2,2857,  0,  0,  0,  0},   // 5714
    {  3,  5,127,  0,  0,  0},   // 5715
    {  2,1429,  0,  0,  0,  0},   // 5716
    {  0,  0,  0,  0,  0,  0},   // 5717
    {  2,  3,953,  0,  0,  0},   // 5718
    {  7, 19, 43,  0,  0,  0},   // 5719
    {  2,  5, 11, 13,  0,  0},   // 5720
    {  3,1907,  0,  0,  0,  0},   // 5721
    {  2,2861,  0,  0,  0,  0},   // 5722
    { 59, 97,  0,  0,  0,  0},   // 5723
    {  2,  3, 53,  0,  0,  0},   // 5724
    {  5,229,  0,  0,  0,  0},   // 5725
    {  2,  7,409,  0,  0,  0},   // 5726
    {  3, 23, 83,  0,  0,  0},   // 5727
    {  2,179,  0,  0,  0,  0},   // 5728
    { 17,337,  0,  0,  0,  0},   // 5729
    {  2,  3,  5,191,  0,  0},   // 5730
    { 11,521,  0,  0,  0,  0},   // 5731
    {  2,1433,  0,  0,  0,  0},   // 5732
    {  3,  7, 13,  0,  0,  0},   // 5733
    {  2, 47, 61,  0,  0,  0},   // 5734
    {  5, 31, 37,  0,  0,  0},   // 5735
    {  2,  3,239,  0,  0,  0},   // 5736
    {  0,  0,  0,  0,  0,  0},   // 5737
    {  2, 19,151,  0,  0,  0},   // 5738
    {  3,1913,  0,  0,  0,  0},   // 5739
    {  2,  5,  7, 41,  0,  0},   // 5740
    {  0,  0,  0,  0,  0,  0},   // 5741
    {  2,  3, 11, 29,  0,  0},   // 5742
    {  0,  0,  0,  0,  0,  0},   // 5743
    {  2,359,  0,  0,  0,  0},   // 5744
    {  3,  5,383,  0,  0,  0},   // 5745
    {  2, 13, 17,  0,  0,  0},   // 5746
    {  7,821,  0,  0,  0,  0},   // 5747
    {  2,  3,479,  0,  0,  0},   // 5748
    {  0,  0,  0,  0,  0,  0},   // 5749
    {  2,  5, 23,  0,  0,  0},   // 5750
    {  3, 71,  0,  0,  0,  0},   // 5751
    {  2,719,  0,  0,  0,  0},   // 5752
    { 11,523,  0,  0,  0,  0},   // 5753
    {  2,  3,  7,137,  0,  0},   // 5754
    {  5,1151,  0,  0,  0,  0},   // 5755
    {  2,1439,  0,  0,  0,  0},   // 5756
    {  3, 19,101,  0,  0,  0},   // 5757
    {  2,2879,  0,  0,  0,  0},   // 5758
    { 13,443,  0,  0,  0,  0},   // 5759
    {  2,  3,  5,  0,  0,  0},   // 5760
    {  7,823,  0,  0,  0,  0},   // 5761
    {  2, 43, 67,  0,  0,  0},   // 5762
    {  3, 17,113,  0,  0,  0},   // 5763
    {  2, 11,131,  0,  0,  0},   // 5764
    {  5,1153,  0,  0,  0,  0},   // 5765
    {  2,  3, 31,  0,  0,  0},   // 5766
    { 73, 79,  0,  0,  0,  0},   // 5767
    {  2,  7,103,  0,  0,  0},   // 5768
    {  3,641,  0,  0,  0,  0},   // 5769
    {  2,  5,577,  0,  0,  0},   // 5770
    { 29,199,  0,  0,  0,  0},   // 5771
    {  2,  3, 13, 37,  0,  0},   // 5772
    { 23,251,  0,  0,  0,  0},   // 5773
    {  2,2887,  0,  0,  0,  0},   // 5774
    {  3,  5,  7, 11,  0,  0},   // 5775
    {  2, 19,  0,  0,  0,  0},   // 5776
    { 53,109,  0,  0,  0,  0},   // 5777
    {  2,  3,107,  0,  0,  0},   // 5778
    {  0,  0,  0,  0,  0,  0},   // 5779
    {  2,  5, 17,  0,  0,  0},   // 5780
    {  3, 41, 47,  0,  0,  0},   // 5781
    {  2,  7, 59,  0,  0,  0},   // 5782
    {  0,  0,  0,  0,  0,  0},   // 5783
    {  2,  3,241,  0,  0,  0},   // 5784
    {  5, 13, 89,  0,  0,  0},   // 5785
    {  2, 11,263,  0,  0,  0},   // 5786
    {  3,643,  0,  0,  0,  0},   // 5787
    {  2,1447,  0,  0,  0,  0},   // 5788
    {  7,827,  0,  0,  0,  0},   // 5789
    {  2,  3,  5,193,  0,  0},   // 5790
    {  0,  0,  0,  0,  0,  0},   // 5791
    {  2,181,  0,  0,  0,  0},   // 5792
    {  3,1931,  0,  0,  0,  0},   // 5793
    {  2,2897,  0,  0,  0,  0},   // 5794
    {  5, 19, 61,  0,  0,  0},   // 5795
    {  2,  3,  7, 23,  0,  0},   // 5796
    { 11, 17, 31,  0,  0,  0},   // 5797
    {  2, 13,223,  0,  0,  0},   // 5798
    {  3,1933,  0,  0,  0,  0},   // 5799
    {  2,  5, 29,  0,  0,  0},   // 5800
    {  0,  0,  0,  0,  0,  0},   // 5801
    {  2,  3,967,  0,  0,  0},   // 5802
    {  7,829,  0,  0,  0,  0},   // 5803
    {  2,1451,  0,  0,  0,  0},   // 5804
    {  3,  5, 43,  0,  0,  0},   // 5805
    {  2,2903,  0,  0,  0,  0},   // 5806
    {  0,  0,  0,  0,  0,  0},   // 5807
    {  2,  3, 11,  0,  0,  0},   // 5808
    { 37,157,  0,  0,  0,  0},   // 5809
    {  2,  5,  7, 83,  0,  0},   // 5810
    {  3, 13,149,  0,  0,  0},   // 5811
    {  2,1453,  0,  0,  0,  0},   // 5812
    {  0,  0,  0,  0,  0,  0},   // 5813
    {  2,  3, 17, 19,  0,  0},   // 5814
    {  5,1163,  0,  0,  0,  0},   // 5815
    {  2,727,  0,  0,  0,  0},   // 5816
    {  3,  7,277,  0,  0,  0},   // 5817
    {  2,2909,  0,  0,  0,  0},   // 5818
    { 11, 23,  0,  0,  0,  0},   // 5819
    {  2,  3,  5, 97,  0,  0},   // 5820
    {  0,  0,  0,  0,  0,  0},   // 5821
    {  2, 41, 71,  0,  0,  0},   // 5822
    {  3,647,  0,  0,  0,  0},   // 5823
    {  2,  7, 13,  0,  0,  0},   // 5824
    {  5,233,  0,  0,  0,  0},   // 5825
    {  2,  3,971,  0,  0,  0},   // 5826
    {  0,  0,  0,  0,  0,  0},   // 5827
    {  2, 31, 47,  0,  0,  0},   // 5828
    {  3, 29, 67,  0,  0,  0},   // 5829
    {  2,  5, 11, 53,  0,  0},   // 5830
    {  7, 17,  0,  0,  0,  0},   // 5831
    {  2,  3,  0,  0,  0,  0},   // 5832
    { 19,307,  0,  0,  0,  0},   // 5833
    {  2,2917,  0,  0,  0,  0},   // 5834
    {  3,  5,389,  0,  0,  0},   // 5835
    {  2,1459,  0,  0,  0,  0},   // 5836
    { 13,449,  0,  0,  0,  0},   // 5837
    {  2,  3,  7,139,  0,  0},   // 5838
    {  0,  0,  0,  0,  0,  0},   // 5839
    {  2,  5, 73,  0,  0,  0},   // 5840
    {  3, 11, 59,  0,  0,  0},   // 5841
    {  2, 23,127,  0,  0,  0},   // 5842
    {  0,  0,  0,  0,  0,  0},   // 5843
    {  2,  3,487,  0,  0,  0},   // 5844
    {  5,  7,167,  0,  0,  0},   // 5845
    {  2, 37, 79,  0,  0,  0},   // 5846
    {  3,1949,  0,  0,  0,  0},   // 5847
    {  2, 17, 43,  0,  0,  0},   // 5848
    {  0,  0,  0,  0,  0,  0},   // 5849
    {  2,  3,  5, 13,  0,  0},   // 5850
    {  0,  0,  0,  0,  0,  0},   // 5851
    {  2,  7, 11, 19,  0,  0},   // 5852
    {  3,1951,  0,  0,  0,  0},   // 5853
    {  2,2927,  0,  0,  0,  0},   // 5854
    {  5,1171,  0,  0,  0,  0},   // 5855
    {  2,  3, 61,  0,  0,  0},   // 5856
    {  0,  0,  0,  0,  0,  0},   // 5857
    {  2, 29,101,  0,  0,  0},   // 5858
    {  3,  7, 31,  0,  0,  0},   // 5859
    {  2,  5,293,  0,  0,  0},   // 5860
    {  0,  0,  0,  0,  0,  0},   // 5861
    {  2,  3,977,  0,  0,  0},   // 5862
    { 11, 13, 41,  0,  0,  0},   // 5863
    {  2,733,  0,  0,  0,  0},   // 5864
    {  3,  5, 17, 23,  0,  0},   // 5865
    {  2,  7,419,  0,  0,  0},   // 5866
    {  0,  0,  0,  0,  0,  0},   // 5867
    {  2,  3,163,  0,  0,  0},   // 5868
    {  0,  0,  0,  0,  0,  0},   // 5869
    {  2,  5,587,  0,  0,  0},   // 5870
    {  3, 19,103,  0,  0,  0},   // 5871
    {  2,367,  0,  0,  0,  0},   // 5872
    {  7,839,  0,  0,  0,  0},   // 5873
    {  2,  3, 11, 89,  0,  0},   // 5874
    {  5, 47,  0,  0,  0,  0},   // 5875
    {  2, 13,113,  0,  0,  0},   // 5876
    {  3,653,  0,  0,  0,  0},   // 5877
    {  2,2939,  0,  0,  0,  0},   // 5878
    {  0,  0,  0,  0,  0,  0},   // 5879
    {  2,  3,  5,  7,  0,  0},   // 5880
    {  0,  0,  0,  0,  0,  0},   // 5881
    {  2, 17,173,  0,  0,  0},   // 5882
    {  3, 37, 53,  0,  0,  0},   // 5883
    {  2,1471,  0,  0,  0,  0},   // 5884
    {  5, 11,107,  0,  0,  0},   // 5885
    {  2,  3,109,  0,  0,  0},   // 5886
    {  7, 29,  0,  0,  0,  0},   // 5887
    {  2, 23,  0,  0,  0,  0},   // 5888
    {  3, 13,151,  0,  0,  0},   // 5889
    {  2,  5, 19, 31,  0,  0},   // 5890
    { 43,137,  0,  0,  0,  0},   // 5891
    {  2,  3,491,  0,  0,  0},   // 5892
    { 71, 83,  0,  0,  0,  0},   // 5893
    {  2,  7,421,  0,  0,  0},   // 5894
    {  3,  5,131,  0,  0,  0},   // 5895
    {  2, 11, 67,  0,  0,  0},   // 5896
    {  0,  0,  0,  0,  0,  0},   // 5897
    {  2,  3,983,  0,  0,  0},   // 5898
    { 17,347,  0,  0,  0,  0},   // 5899
    {  2,  5, 59,  0,  0,  0},   // 5900
    {  3,  7,281,  0,  0,  0},   // 5901
    {  2, 13,227,  0,  0,  0},   // 5902
    {  0,  0,  0,  0,  0,  0},   // 5903
    {  2,  3, 41,  0,  0,  0},   // 5904
    {  5,1181,  0,  0,  0,  0},   // 5905
    {  2,2953,  0,  0,  0,  0},   // 5906
    {  3, 11,179,  0,  0,  0},   // 5907
    {  2,  7,211,  0,  0,  0},   // 5908
    { 19,311,  0,  0,  0,  0},   // 5909
    {  2,  3,  5,197,  0,  0},   // 5910
    { 23,257,  0,  0,  0,  0},   // 5911
    {  2,739,  0,  0,  0,  0},   // 5912
    {  3, 73,  0,  0,  0,  0},   // 5913
    {  2,2957,  0,  0,  0,  0},   // 5914
    {  5,  7, 13,  0,  0,  0},   // 5915
    {  2,  3, 17, 29,  0,  0},   // 5916
    { 61, 97,  0,  0,  0,  0},   // 5917
    {  2, 11,269,  0,  0,  0},   // 5918
    {  3,1973,  0,  0,  0,  0},   // 5919
    {  2,  5, 37,  0,  0,  0},   // 5920
    { 31,191,  0,  0,  0,  0},   // 5921
    {  2,  3,  7, 47,  0,  0},   // 5922
    {  0,  0,  0,  0,  0,  0},   // 5923
    {  2,1481,  0,  0,  0,  0},   // 5924
    {  3,  5, 79,  0,  0,  0},   // 5925
    {  2,2963,  0,  0,  0,  0},   // 5926
    {  0,  0,  0,  0,  0,  0},   // 5927
    {  2,  3, 13, 19,  0,  0},   // 5928
    {  7, 11,  0,  0,  0,  0},   // 5929
    {  2,  5,593,  0,  0,  0},   // 5930
    {  3,659,  0,  0,  0,  0},   // 5931
    {  2,1483,  0,  0,  0,  0},   // 5932
    { 17,349,  0,  0,  0,  0},   // 5933
    {  2,  3, 23, 43,  0,  0},   // 5934
    {  5,1187,  0,  0,  0,  0},   // 5935
    {  2,  7, 53,  0,  0,  0},   // 5936
    {  3,1979,  0,  0,  0,  0},   // 5937
    {  2,2969,  0,  0,  0,  0},   // 5938
    {  0,  0,  0,  0,  0,  0},   // 5939
    {  2,  3,  5, 11,  0,  0},   // 5940
    { 13,457,  0,  0,  0,  0},   // 5941
    {  2,2971,  0,  0,  0,  0},   // 5942
    {  3,  7,283,  0,  0,  0},   // 5943
    {  2,743,  0,  0,  0,  0},   // 5944
    {  5, 29, 41,  0,  0,  0},   // 5945
    {  2,  3,991,  0,  0,  0},   // 5946
    { 19,313,  0,  0,  0,  0},   // 5947
    {  2,1487,  0,  0,  0,  0},   // 5948
    {  3,661,  0,  0,  0,  0},   // 5949
    {  2,  5,  7, 17,  0,  0},   // 5950
    { 11,541,  0,  0,  0,  0},   // 5951
    {  2,  3, 31,  0,  0,  0},   // 5952
    {  0,  0,  0,  0,  0,  0},   // 5953
    {  2, 13,229,  0,  0,  0},   // 5954
    {  3,  5,397,  0,  0,  0},   // 5955
    {  2,1489,  0,  0,  0,  0},   // 5956
    {  7, 23, 37,  0,  0,  0},   // 5957
    {  2,  3,331,  0,  0,  0},   // 5958
    { 59,101,  0,  0,  0,  0},   // 5959
    {  2,  5,149,  0,  0,  0},   // 5960
    {  3,1987,  0,  0,  0,  0},   // 5961
    {  2, 11,271,  0,  0,  0},   // 5962
    { 67, 89,  0,  0,  0,  0},   // 5963
    {  2,  3,  7, 71,  0,  0},   // 5964
    {  5,1193,  0,  0,  0,  0},   // 5965
    {  2, 19,157,  0,  0,  0},   // 5966
    {  3, 13, 17,  0,  0,  0},   // 5967
    {  2,373,  0,  0,  0,  0},   // 5968
    { 47,127,  0,  0,  0,  0},   // 5969
    {  2,  3,  5,199,  0,  0},   // 5970
    {  7,853,  0,  0,  0,  0},   // 5971
    {  2,1493,  0,  0,  0,  0},   // 5972
    {  3, 11,181,  0,  0,  0},   // 5973
    {  2, 29,103,  0,  0,  0},   // 5974
    {  5,239,  0,  0,  0,  0},   // 5975
    {  2,  3, 83,  0,  0,  0},   // 5976
    { 43,139,  0,  0,  0,  0},   // 5977
    {  2,  7, 61,  0,  0,  0},   // 5978
    {  3,1993,  0,  0,  0,  0},   // 5979
    {  2,  5, 13, 23,  0,  0},   // 5980
    {  0,  0,  0,  0,  0,  0},   // 5981
    {  2,  3,997,  0,  0,  0},   // 5982
    { 31,193,  0,  0,  0,  0},   // 5983
    {  2, 11, 17,  0,  0,  0},   // 5984
    {  3,  5,  7, 19,  0,  0},   // 5985
    {  2, 41, 73,  0,  0,  0},   // 5986
    {  0,  0,  0,  0,  0,  0},   // 5987
    {  2,  3,499,  0,  0,  0},   // 5988
    { 53,113,  0,  0,  0,  0},   // 5989
    {  2,  5,599,  0,  0,  0},   // 5990
    {  3,1997,  0,  0,  0,  0},   // 5991
    {  2,  7,107,  0,  0,  0},   // 5992
    { 13,461,  0,  0,  0,  0},   // 5993
    {  2,  3, 37,  0,  0,  0},   // 5994
    {  5, 11,109,  0,  0,  0},   // 5995
    {  2,1499,  0,  0,  0,  0},   // 5996
    {  3,1999,  0,  0,  0,  0},   // 5997
    {  2,2999,  0,  0,  0,  0},   // 5998
    {  7,857,  0,  0,  0,  0},   // 5999
    {  2,  3,  5,  0,  0,  0},   // 6000
    { 17,353,  0,  0,  0,  0},   // 6001
    {  2,3001,  0,  0,  0,  0},   // 6002
    {  3, 23, 29,  0,  0,  0},   // 6003
    {  2, 19, 79,  0,  0,  0},   // 6004
    {  5,1201,  0,  0,  0,  0},   // 6005
    {  2,  3,  7, 11, 13,  0},   // 6006
    {  0,  0,  0,  0,  0,  0},   // 6007
    {  2,751,  0,  0,  0,  0},   // 6008
    {  3,2003,  0,  0,  0,  0},   // 6009
    {  2,  5,601,  0,  0,  0},   // 6010
    {  0,  0,  0,  0,  0,  0},   // 6011
    {  2,  3,167,  0,  0,  0},   // 6012
    {  7,859,  0,  0,  0,  0},   // 6013
    {  2, 31, 97,  0,  0,  0},   // 6014
    {  3,  5,401,  0,  0,  0},   // 6015
    {  2, 47,  0,  0,  0,  0},   // 6016
    { 11,547,  0,  0,  0,  0},   // 6017
    {  2,  3, 17, 59,  0,  0},   // 6018
    { 13,463,  0,  0,  0,  0},   // 6019
    {  2,  5,  7, 43,  0,  0},   // 6020
    {  3,223,  0,  0,  0,  0},   // 6021
    {  2,3011,  0,  0,  0,  0},   // 6022
    { 19,317,  0,  0,  0,  0},   // 6023
    {  2,  3,251,  0,  0,  0},   // 6024
    {  5,241,  0,  0,  0,  0},   // 6025
    {  2, 23,131,  0,  0,  0},   // 6026
    {  3,  7, 41,  0,  0,  0},   // 6027
    {  2, 11,137,  0,  0,  0},   // 6028
    {  0,  0,  0,  0,  0,  0},   // 6029
    {  2,  3,  5, 67,  0,  0},   // 6030
    { 37,163,  0,  0,  0,  0},   // 6031
    {  2, 13, 29,  0,  0,  0},   // 6032
    {  3,2011,  0,  0,  0,  0},   // 6033
    {  2,  7,431,  0,  0,  0},   // 6034
    {  5, 17, 71,  0,  0,  0},   // 6035
    {  2,  3,503,  0,  0,  0},   // 6036
    {  0,  0,  0,  0,  0,  0},   // 6037
    {  2,3019,  0,  0,  0,  0},   // 6038
    {  3, 11, 61,  0,  0,  0},   // 6039
    {  2,  5,151,  0,  0,  0},   // 6040
    {  7,863,  0,  0,  0,  0},   // 6041
    {  2,  3, 19, 53,  0,  0},   // 6042
    {  0,  0,  0,  0,  0,  0},   // 6043
    {  2,1511,  0,  0,  0,  0},   // 6044
    {  3,  5, 13, 31,  0,  0},   // 6045
    {  2,3023,  0,  0,  0,  0},   // 6046
    {  0,  0,  0,  0,  0,  0},   // 6047
    {  2,  3,  7,  0,  0,  0},   // 6048
    { 23,263,  0,  0,  0,  0},   // 6049
    {  2,  5, 11,  0,  0,  0},   // 6050
    {  3,2017,  0,  0,  0,  0},   // 6051
    {  2, 17, 89,  0,  0,  0},   // 6052
    {  0,  0,  0,  0,  0,  0},   // 6053
    {  2,  3,1009,  0,  0,  0},   // 6054
    {  5,  7,173,  0,  0,  0},   // 6055
    {  2,757,  0,  0,  0,  0},   // 6056
    {  3,673,  0,  0,  0,  0},   // 6057
    {  2, 13,233,  0,  0,  0},   // 6058
    { 73, 83,  0,  0,  0,  0},   // 6059
    {  2,  3,  5,101,  0,  0},   // 6060
    { 11, 19, 29,  0,  0,  0},   // 6061
    {  2,  7,433,  0,  0,  0},   // 6062
    {  3, 43, 47,  0,  0,  0},   // 6063
    {  2,379,  0,  0,  0,  0},   // 6064
    {  5,1213,  0,  0,  0,  0},   // 6065
    {  2,  3,337,  0,  0,  0},   // 6066
    {  0,  0,  0,  0,  0,  0},   // 6067
    {  2, 37, 41,  0,  0,  0},   // 6068
    {  3,  7, 17,  0,  0,  0},   // 6069
    {  2,  5,607,  0,  0,  0},   // 6070
    { 13,467,  0,  0,  0,  0},   // 6071
    {  2,  3, 11, 23,  0,  0},   // 6072
    {  0,  0,  0,  0,  0,  0},   // 6073
    {  2,3037,  0,  0,  0,  0},   // 6074
    {  3,  5,  0,  0,  0,  0},   // 6075
    {  2,  7, 31,  0,  0,  0},   // 6076
    { 59,103,  0,  0,  0,  0},   // 6077
    {  2,  3,1013,  0,  0,  0},   // 6078
    {  0,  0,  0,  0,  0,  0},   // 6079
    {  2,  5, 19,  0,  0,  0},   // 6080
    {  3,2027,  0,  0,  0,  0},   // 6081
    {  2,3041,  0,  0,  0,  0},   // 6082
    {  7, 11, 79,  0,  0,  0},   // 6083
    {  2,  3, 13,  0,  0,  0},   // 6084
    {  5,1217,  0,  0,  0,  0},   // 6085
    {  2, 17,179,  0,  0,  0},   // 6086
    {  3,2029,  0,  0,  0,  0},   // 6087
    {  2,761,  0,  0,  0,  0},   // 6088
    {  0,  0,  0,  0,  0,  0},   // 6089
    {  2,  3,  5,  7, 29,  0},   // 6090
    {  0,  0,  0,  0,  0,  0},   // 6091
    {  2,1523,  0,  0,  0,  0},   // 6092
    {  3,677,  0,  0,  0,  0},   // 6093
    {  2, 11,277,  0,  0,  0},   // 6094
    {  5, 23, 53,  0,  0,  0},   // 6095
    {  2,  3,127,  0,  0,  0},   // 6096
    {  7, 13, 67,  0,  0,  0},   // 6097
    {  2,3049,  0,  0,  0,  0},   // 6098
    {  3, 19,107,  0,  0,  0},   // 6099
    {  2,  5, 61,  0,  0,  0},   // 6100
    {  0,  0,  0,  0,  0,  0},   // 6101
    {  2,  3,113,  0,  0,  0},   // 6102
    { 17,359,  0,  0,  0,  0},   // 6103
    {  2,  7,109,  0,  0,  0},   // 6104
    {  3,  5, 11, 37,  0,  0},   // 6105
    {  2, 43, 71,  0,  0,  0},   // 6106
    { 31,197,  0,  0,  0,  0},   // 6107
    {  2,  3,509,  0,  0,  0},   // 6108
    { 41,149,  0,  0,  0,  0},   // 6109
    {  2,  5, 13, 47,  0,  0},   // 6110
    {  3,  7, 97,  0,  0,  0},   // 6111
    {  2,191,  0,  0,  0,  0},   // 6112
    {  0,  0,  0,  0,  0,  0},   // 6113
    {  2,  3,1019,  0,  0,  0},   // 6114
    {  5,1223,  0,  0,  0,  0},   // 6115
    {  2, 11,139,  0,  0,  0},   // 6116
    {  3,2039,  0,  0,  0,  0},   // 6117
    {  2,  7, 19, 23,  0,  0},   // 6118
    { 29,211,  0,  0,  0,  0},   // 6119
    {  2,  3,  5, 17,  0,  0},   // 6120
    {  0,  0,  0,  0,  0,  0},   // 6121
    {  2,3061,  0,  0,  0,  0},   // 6122
    {  3, 13,157,  0,  0,  0},   // 6123
    {  2,1531,  0,  0,  0,  0},   // 6124
    {  5,  7,  0,  0,  0,  0},   // 6125
    {  2,  3,1021,  0,  0,  0},   // 6126
    { 11,557,  0,  0,  0,  0},   // 6127
    {  2,383,  0,  0,  0,  0},   // 6128
    {  3,227,  0,  0,  0,  0},   // 6129
    {  2,  5,613,  0,  0,  0},   // 6130
    {  0,  0,  0,  0,  0,  0},   // 6131
    {  2,  3,  7, 73,  0,  0},   // 6132
    {  0,  0,  0,  0,  0,  0},   // 6133
    {  2,3067,  0,  0,  0,  0},   // 6134
    {  3,  5,409,  0,  0,  0},   // 6135
    {  2, 13, 59,  0,  0,  0},   // 6136
    { 17, 19,  0,  0,  0,  0},   // 6137
    {  2,  3, 11, 31,  0,  0},   // 6138
    {  7,877,  0,  0,  0,  0},   // 6139
    {  2,  5,307,  0,  0,  0},   // 6140
    {  3, 23, 89,  0,  0,  0},   // 6141
    {  2, 37, 83,  0,  0,  0},   // 6142
    {  0,  0,  0,  0,  0,  0},   // 6143
    {  2,  3,  0,  0,  0,  0},   // 6144
    {  5,1229,  0,  0,  0,  0},   // 6145
    {  2,  7,439,  0,  0,  0},   // 6146
    {  3,683,  0,  0,  0,  0},   // 6147
    {  2, 29, 53,  0,  0,  0},   // 6148
    { 11, 13, 43,  0,  0,  0},   // 6149
    {  2,  3,  5, 41,  0,  0},   // 6150
    {  0,  0,  0,  0,  0,  0},   // 6151
    {  2,769,  0,  0,  0,  0},   // 6152
    {  3,  7,293,  0,  0,  0},   // 6153
    {  2, 17,181,  0,  0,  0},   // 6154
    {  5,1231,  0,  0,  0,  0},   // 6155
    {  2,  3, 19,  0,  0,  0},   // 6156
    { 47,131,  0,  0,  0,  0},   // 6157
    {  2,3079,  0,  0,  0,  0},   // 6158
    {  3,2053,  0,  0,  0,  0},   // 6159
    {  2,  5,  7, 11,  0,  0},   // 6160
    { 61,101,  0,  0,  0,  0},   // 6161
    {  2,  3, 13, 79,  0,  0},   // 6162
    {  0,  0,  0,  0,  0,  0},   // 6163
    {  2, 23, 67,  0,  0,  0},   // 6164
    {  3,  5,137,  0,  0,  0},   // 6165
    {  2,3083,  0,  0,  0,  0},   // 6166
    {  7,881,  0,  0,  0,  0},   // 6167
    {  2,  3,257,  0,  0,  0},   // 6168
    { 31,199,  0,  0,  0,  0},   // 6169
    {  2,  5,617,  0,  0,  0},   // 6170
    {  3, 11, 17,  0,  0,  0},   // 6171
    {  2,1543,  0,  0,  0,  0},   // 6172
    {  0,  0,  0,  0,  0,  0},   // 6173
    {  2,  3,  7,  0,  0,  0},   // 6174
    {  5, 13, 19,  0,  0,  0},   // 6175
    {  2,193,  0,  0,  0,  0},   // 6176
    {  3, 29, 71,  0,  0,  0},   // 6177
    {  2,3089,  0,  0,  0,  0},   // 6178
    { 37,167,  0,  0,  0,  0},   // 6179
    {  2,  3,  5,103,  0,  0},   // 6180
    {  7,883,  0,  0,  0,  0},   // 6181
    {  2, 11,281,  0,  0,  0},   // 6182
    {  3,229,  0,  0,  0,  0},   // 6183
    {  2,773,  0,  0,  0,  0},   // 6184
    {  5,1237,  0,  0,  0,  0},   // 6185
    {  2,  3,1031,  0,  0,  0},   // 6186
    { 23,269,  0,  0,  0,  0},   // 6187
    {  2,  7, 13, 17,  0,  0},   // 6188
    {  3,2063,  0,  0,  0,  0},   // 6189
    {  2,  5,619,  0,  0,  0},   // 6190
    { 41,151,  0,  0,  0,  0},   // 6191
    {  2,  3, 43,  0,  0,  0},   // 6192
    { 11,563,  0,  0,  0,  0},   // 6193
    {  2, 19,163,  0,  0,  0},   // 6194
    {  3,  5,  7, 59,  0,  0},   // 6195
    {  2,1549,  0,  0,  0,  0},   // 6196
    {  0,  0,  0,  0,  0,  0},   // 6197
    {  2,  3,1033,  0,  0,  0},   // 6198
    {  0,  0,  0,  0,  0,  0},   // 6199
    {  2,  5, 31,  0,  0,  0},   // 6200
    {  3, 13, 53,  0,  0,  0},   // 6201
    {  2,  7,443,  0,  0,  0},   // 6202
    {  0,  0,  0,  0,  0,  0},   // 6203
    {  2,  3, 11, 47,  0,  0},   // 6204
    {  5, 17, 73,  0,  0,  0},   // 6205
    {  2, 29,107,  0,  0,  0},   // 6206
    {  3,2069,  0,  0,  0,  0},   // 6207
    {  2, 97,  0,  0,  0,  0},   // 6208
    {  7,887,  0,  0,  0,  0},   // 6209
    {  2,  3,  5, 23,  0,  0},   // 6210
    {  0,  0,  0,  0,  0,  0},   // 6211
    {  2,1553,  0,  0,  0,  0},   // 6212
    {  3, 19,109,  0,  0,  0},   // 6213
    {  2, 13,239,  0,  0,  0},   // 6214
    {  5, 11,113,  0,  0,  0},   // 6215
    {  2,  3,  7, 37,  0,  0},   // 6216
    {  0,  0,  0,  0,  0,  0},   // 6217
    {  2,3109,  0,  0,  0,  0},   // 6218
    {  3,691,  0,  0,  0,  0},   // 6219
    {  2,  5,311,  0,  0,  0},   // 6220
    {  0,  0,  0,  0,  0,  0},   // 6221
    {  2,  3, 17, 61,  0,  0},   // 6222
    {  7,127,  0,  0,  0,  0},   // 6223
    {  2,389,  0,  0,  0,  0},   // 6224
    {  3,  5, 83,  0,  0,  0},   // 6225
    {  2, 11,283,  0,  0,  0},   // 6226
    { 13,479,  0,  0,  0,  0},   // 6227
    {  2,  3,173,  0,  0,  0},   // 6228
    {  0,  0,  0,  0,  0,  0},   // 6229
    {  2,  5,  7, 89,  0,  0},   // 6230
    {  3, 31, 67,  0,  0,  0},   // 6231
    {  2, 19, 41,  0,  0,  0},   // 6232
    { 23,271,  0,  0,  0,  0},   // 6233
    {  2,  3,1039,  0,  0,  0},   // 6234
    {  5, 29, 43,  0,  0,  0},   // 6235
    {  2,1559,  0,  0,  0,  0},   // 6236
    {  3,  7, 11,  0,  0,  0},   // 6237
    {  2,3119,  0,  0,  0,  0},   // 6238
    { 17,367,  0,  0,  0,  0},   // 6239
    {  2,  3,  5, 13,  0,  0},   // 6240
    { 79,  0,  0,  0,  0,  0},   // 6241
    {  2,3121,  0,  0,  0,  0},   // 6242
    {  3,2081,  0,  0,  0,  0},   // 6243
    {  2,  7,223,  0,  0,  0},   // 6244
    {  5,1249,  0,  0,  0,  0},   // 6245
    {  2,  3,347,  0,  0,  0},   // 6246
    {  0,  0,  0,  0,  0,  0},   // 6247
    {  2, 11, 71,  0,  0,  0},   // 6248
    {  3,2083,  0,  0,  0,  0},   // 6249
    {  2,  5,  0,  0,  0,  0},   // 6250
    {  7, 19, 47,  0,  0,  0},   // 6251
    {  2,  3,521,  0,  0,  0},   // 6252
    { 13, 37,  0,  0,  0,  0},   // 6253
    {  2, 53, 59,  0,  0,  0},   // 6254
    {  3,  5,139,  0,  0,  0},   // 6255
    {  2, 17, 23,  0,  0,  0},   // 6256
    {  0,  0,  0,  0,  0,  0},   // 6257
    {  2,  3,  7,149,  0,  0},   // 6258
    { 11,569,  0,  0,  0,  0},   // 6259
    {  2,  5,313,  0,  0,  0},   // 6260
    {  3,2087,  0,  0,  0,  0},   // 6261
    {  2, 31,101,  0,  0,  0},   // 6262
    {  0,  0,  0,  0,  0,  0},   // 6263
    {  2,  3, 29,  0,  0,  0},   // 6264
    {  5,  7,179,  0,  0,  0},   // 6265
    {  2, 13,241,  0,  0,  0},   // 6266
    {  3,2089,  0,  0,  0,  0},   // 6267
    {  2,1567,  0,  0,  0,  0},   // 6268
    {  0,  0,  0,  0,  0,  0},   // 6269
    {  2,  3,  5, 11, 19,  0},   // 6270
    {  0,  0,  0,  0,  0,  0},   // 6271
    {  2,  7,  0,  0,  0,  0},   // 6272
    {  3, 17, 41,  0,  0,  0},   // 6273
    {  2,3137,  0,  0,  0,  0},   // 6274
    {  5,251,  0,  0,  0,  0},   // 6275
    {  2,  3,523,  0,  0,  0},   // 6276
    {  0,  0,  0,  0,  0,  0},   // 6277
    {  2, 43, 73,  0,  0,  0},   // 6278
    {  3,  7, 13, 23,  0,  0},   // 6279
    {  2,  5,157,  0,  0,  0},   // 6280
    { 11,571,  0,  0,  0,  0},   // 6281
    {  2,  3,349,  0,  0,  0},   // 6282
    { 61,103,  0,  0,  0,  0},   // 6283
    {  2,1571,  0,  0,  0,  0},   // 6284
    {  3,  5,419,  0,  0,  0},   // 6285
    {  2,  7,449,  0,  0,  0},   // 6286
    {  0,  0,  0,  0,  0,  0},   // 6287
    {  2,  3,131,  0,  0,  0},   // 6288
    { 19,331,  0,  0,  0,  0},   // 6289
    {  2,  5, 17, 37,  0,  0},   // 6290
    {  3,233,  0,  0,  0,  0},   // 6291
    {  2, 11, 13,  0,  0,  0},   // 6292
    {  7, 29, 31,  0,  0,  0},   // 6293
    {  2,  3,1049,  0,  0,  0},   // 6294
    {  5,1259,  0,  0,  0,  0},   // 6295
    {  2,787,  0,  0,  0,  0},   // 6296
    {  3,2099,  0,  0,  0,  0},   // 6297
    {  2, 47, 67,  0,  0,  0},   // 6298
    {  0,  0,  0,  0,  0,  0},   // 6299
    {  2,  3,  5,  7,  0,  0},   // 6300
    {  0,  0,  0,  0,  0,  0},   // 6301
    {  2, 23,137,  0,  0,  0},   // 6302
    {  3, 11,191,  0,  0,  0},   // 6303
    {  2,197,  0,  0,  0,  0},   // 6304
    {  5, 13, 97,  0,  0,  0},   // 6305
    {  2,  3,1051,  0,  0,  0},   // 6306
    {  7, 17, 53,  0,  0,  0},   // 6307
    {  2, 19, 83,  0,  0,  0},   // 6308
    {  3,701,  0,  0,  0,  0},   // 6309
    {  2,  5,631,  0,  0,  0},   // 6310
    {  0,  0,  0,  0,  0,  0},   // 6311
    {  2,  3,263,  0,  0,  0},   // 6312
    { 59,107,  0,  0,  0,  0},   // 6313
    {  2,  7, 11, 41,  0,  0},   // 6314
    {  3,  5,421,  0,  0,  0},   // 6315
    {  2,1579,  0,  0,  0,  0},   // 6316
    {  0,  0,  0,  0,  0,  0},   // 6317
    {  2,  3, 13,  0,  0,  0},   // 6318
    { 71, 89,  0,  0,  0,  0},   // 6319
    {  2,  5, 79,  0,  0,  0},   // 6320
    {  3,  7, 43,  0,  0,  0},   // 6321
    {  2, 29,109,  0,  0,  0},   // 6322
    {  0,  0,  0,  0,  0,  0},   // 6323
    {  2,  3, 17, 31,  0,  0},   // 6324
    {  5, 11, 23,  0,  0,  0},   // 6325
    {  2,3163,  0,  0,  0,  0},   // 6326
    {  3, 19, 37,  0,  0,  0},   // 6327
    {  2,  7,113,  0,  0,  0},   // 6328
    {  0,  0,  0,  0,  0,  0},   // 6329
    {  2,  3,  5,211,  0,  0},   // 6330
    { 13,487,  0,  0,  0,  0},   // 6331
    {  2,1583,  0,  0,  0,  0},   // 6332
    {  3,2111,  0,  0,  0,  0},   // 6333
    {  2,3167,  0,  0,  0,  0},   // 6334
    {  5,  7,181,  0,  0,  0},   // 6335
    {  2,  3, 11,  0,  0,  0},   // 6336
    {  0,  0,  0,  0,  0,  0},   // 6337
    {  2,3169,  0,  0,  0,  0},   // 6338
    {  3,2113,  0,  0,  0,  0},   // 6339
    {  2,  5,317,  0,  0,  0},   // 6340
    { 17,373,  0,  0,  0,  0},   // 6341
    {  2,  3,  7,151,  0,  0},   // 6342
    {  0,  0,  0,  0,  0,  0},   // 6343
    {  2, 13, 61,  0,  0,  0},   // 6344
    {  3,  5, 47,  0,  0,  0},   // 6345
    {  2, 19,167,  0,  0,  0},   // 6346
    { 11,577,  0,  0,  0,  0},   // 6347
    {  2,  3, 23,  0,  0,  0},   // 6348
    {  7,907,  0,  0,  0,  0},   // 6349
    {  2,  5,127,  0,  0,  0},   // 6350
    {  3, 29, 73,  0,  0,  0},   // 6351
    {  2,397,  0,  0,  0,  0},   // 6352
    {  0,  0,  0,  0,  0,  0},   // 6353
    {  2,  3,353,  0,  0,  0},   // 6354
    {  5, 31, 41,  0,  0,  0},   // 6355
    {  2,  7,227,  0,  0,  0},   // 6356
    {  3, 13,163,  0,  0,  0},   // 6357
    {  2, 11, 17,  0,  0,  0},   // 6358
    {  0,  0,  0,  0,  0,  0},   // 6359
    {  2,  3,  5, 53,  0,  0},   // 6360
    {  0,  0,  0,  0,  0,  0},   // 6361
    {  2,3181,  0,  0,  0,  0},   // 6362
    {  3,  7,101,  0,  0,  0},   // 6363
    {  2, 37, 43,  0,  0,  0},   // 6364
    {  5, 19, 67,  0,  0,  0},   // 6365
    {  2,  3,1061,  0,  0,  0},   // 6366
    {  0,  0,  0,  0,  0,  0},   // 6367
    {  2,199,  0,  0,  0,  0},   // 6368
    {  3, 11,193,  0,  0,  0},   // 6369
    {  2,  5,  7, 13,  0,  0},   // 6370
    { 23,277,  0,  0,  0,  0},   // 6371
    {  2,  3, 59,  0,  0,  0},   // 6372
    {  0,  0,  0,  0,  0,  0},   // 6373
    {  2,3187,  0,  0,  0,  0},   // 6374
    {  3,  5, 17,  0,  0,  0},   // 6375
    {  2,797,  0,  0,  0,  0},   // 6376
    {  7,911,  0,  0,  0,  0},   // 6377
    {  2,  3,1063,  0,  0,  0},   // 6378
    {  0,  0,  0,  0,  0,  0},   // 6379
    {  2,  5, 11, 29,  0,  0},   // 6380
    {  3,709,  0,  0,  0,  0},   // 6381
    {  2,3191,  0,  0,  0,  0},   // 6382
    { 13,491,  0,  0,  0,  0},   // 6383
    {  2,  3,  7, 19,  0,  0},   // 6384
    {  5,1277,  0,  0,  0,  0},   // 6385
    {  2, 31,103,  0,  0,  0},   // 6386
    {  3,2129,  0,  0,  0,  0},   // 6387
    {  2,1597,  0,  0,  0,  0},   // 6388
    {  0,  0,  0,  0,  0,  0},   // 6389
    {  2,  3,  5, 71,  0,  0},   // 6390
    {  7, 11, 83,  0,  0,  0},   // 6391
    {  2, 17, 47,  0,  0,  0},   // 6392
    {  3,2131,  0,  0,  0,  0},   // 6393
    {  2, 23,139,  0,  0,  0},   // 6394
    {  5,1279,  0,  0,  0,  0},   // 6395
    {  2,  3, 13, 41,  0,  0},   // 6396
    {  0,  0,  0,  0,  0,  0},   // 6397
    {  2,  7,457,  0,  0,  0},   // 6398
    {  3, 79,  0,  0,  0,  0},   // 6399
    {  2,  5,  0,  0,  0,  0},   // 6400
    { 37,173,  0,  0,  0,  0},   // 6401
    {  2,  3, 11, 97,  0,  0},   // 6402
    { 19,337,  0,  0,  0,  0},   // 6403
    {  2,1601,  0,  0,  0,  0},   // 6404
    {  3,  5,  7, 61,  0,  0},   // 6405
    {  2,3203,  0,  0,  0,  0},   // 6406
    { 43,149,  0,  0,  0,  0},   // 6407
    {  2,  3, 89,  0,  0,  0},   // 6408
    { 13, 17, 29,  0,  0,  0},   // 6409
    {  2,  5,641,  0,  0,  0},   // 6410
    {  3,2137,  0,  0,  0,  0},   // 6411
    {  2,  7,229,  0,  0,  0},   // 6412
    { 11, 53,  0,  0,  0,  0},   // 6413
    {  2,  3,1069,  0,  0,  0},   // 6414
    {  5,1283,  0,  0,  0,  0},   // 6415
    {  2,401,  0,  0,  0,  0},   // 6416
    {  3, 23, 31,  0,  0,  0},   // 6417
    {  2,3209,  0,  0,  0,  0},   // 6418
    {  7,131,  0,  0,  0,  0},   // 6419
    {  2,  3,  5,107,  0,  0},   // 6420
    {  0,  0,  0,  0,  0,  0},   // 6421
    {  2, 13, 19,  0,  0,  0},   // 6422
    {  3,2141,  0,  0,  0,  0},   // 6423
    {  2, 11, 73,  0,  0,  0},   // 6424
    {  5,257,  0,  0,  0,  0},   // 6425
    {  2,  3,  7, 17,  0,  0},   // 6426
    {  0,  0,  0,  0,  0,  0},   // 6427
    {  2,1607,  0,  0,  0,  0},   // 6428
    {  3,2143,  0,  0,  0,  0},   // 6429
    {  2,  5,643,  0,  0,  0},   // 6430
    { 59,109,  0,  0,  0,  0},   // 6431
    {  2,  3, 67,  0,  0,  0},   // 6432
    {  7,919,  0,  0,  0,  0},   // 6433
    {  2,3217,  0,  0,  0,  0},   // 6434
    {  3,  5, 11, 13,  0,  0},   // 6435
    {  2,1609,  0,  0,  0,  0},   // 6436
    { 41,157,  0,  0,  0,  0},   // 6437
    {  2,  3, 29, 37,  0,  0},   // 6438
    { 47,137,  0,  0,  0,  0},   // 6439
    {  2,  5,  7, 23,  0,  0},   // 6440
    {  3, 19,113,  0,  0,  0},   // 6441
    {  2,3221,  0,  0,  0,  0},   // 6442
    { 17,379,  0,  0,  0,  0},   // 6443
    {  2,  3,179,  0,  0,  0},   // 6444
    {  5,1289,  0,  0,  0,  0},   // 6445
    {  2, 11,293,  0,  0,  0},   // 6446
    {  3,  7,307,  0,  0,  0},   // 6447
    {  2, 13, 31,  0,  0,  0},   // 6448
    {  0,  0,  0,  0,  0,  0},   // 6449
    {  2,  3,  5, 43,  0,  0},   // 6450
    {  0,  0,  0,  0,  0,  0},   // 6451
    {  2,1613,  0,  0,  0,  0},   // 6452
    {  3,239,  0,  0,  0,  0},   // 6453
    {  2,  7,461,  0,  0,  0},   // 6454
    {  5,1291,  0,  0,  0,  0},   // 6455
    {  2,  3,269,  0,  0,  0},   // 6456
    { 11,587,  0,  0,  0,  0},   // 6457
    {  2,3229,  0,  0,  0,  0},   // 6458
    {  3,2153,  0,  0,  0,  0},   // 6459
    {  2,  5, 17, 19,  0,  0},   // 6460
    {  7, 13, 71,  0,  0,  0},   // 6461
    {  2,  3,359,  0,  0,  0},   // 6462
    { 23,281,  0,  0,  0,  0},   // 6463
    {  2,101,  0,  0,  0,  0},   // 6464
    {  3,  5,431,  0,  0,  0},   // 6465
    {  2, 53, 61,  0,  0,  0},   // 6466
    { 29,223,  0,  0,  0,  0},   // 6467
    {  2,  3,  7, 11,  0,  0},   // 6468
    {  0,  0,  0,  0,  0,  0},   // 6469
    {  2,  5,647,  0,  0,  0},   // 6470
    {  3,719,  0,  0,  0,  0},   // 6471
    {  2,809,  0,  0,  0,  0},   // 6472
    {  0,  0,  0,  0,  0,  0},   // 6473
    {  2,  3, 13, 83,  0,  0},   // 6474
    {  5,  7, 37,  0,  0,  0},   // 6475
    {  2,1619,  0,  0,  0,  0},   // 6476
    {  3, 17,127,  0,  0,  0},   // 6477
    {  2, 41, 79,  0,  0,  0},   // 6478
    { 11, 19, 31,  0,  0,  0},   // 6479
    {  2,  3,  5,  0,  0,  0},   // 6480
    {  0,  0,  0,  0,  0,  0},   // 6481
    {  2,  7,463,  0,  0,  0},   // 6482
    {  3,2161,  0,  0,  0,  0},   // 6483
    {  2,1621,  0,  0,  0,  0},   // 6484
    {  5,1297,  0,  0,  0,  0},   // 6485
    {  2,  3, 23, 47,  0,  0},   // 6486
    { 13,499,  0,  0,  0,  0},   // 6487
    {  2,811,  0,  0,  0,  0},   // 6488
    {  3,  7,103,  0,  0,  0},   // 6489
    {  2,  5, 11, 59,  0,  0},   // 6490
    {  0,  0,  0,  0,  0,  0},   // 6491
    {  2,  3,541,  0,  0,  0},   // 6492
    { 43,151,  0,  0,  0,  0},   // 6493
    {  2, 17,191,  0,  0,  0},   // 6494
    {  3,  5,433,  0,  0,  0},   // 6495
    {  2,  7, 29,  0,  0,  0},   // 6496
    { 73, 89,  0,  0,  0,  0},   // 6497
    {  2,  3, 19,  0,  0,  0},   // 6498
    { 67, 97,  0,  0,  0,  0},   // 6499
    {  2,  5, 13,  0,  0,  0},   // 6500
    {  3, 11,197,  0,  0,  0},   // 6501
    {  2,3251,  0,  0,  0,  0},   // 6502
    {  7,929,  0,  0,  0,  0},   // 6503
    {  2,  3,271,  0,  0,  0},   // 6504
    {  5,1301,  0,  0,  0,  0},   // 6505
    {  2,3253,  0,  0,  0,  0},   // 6506
    {  3,241,  0,  0,  0,  0},   // 6507
    {  2,1627,  0,  0,  0,  0},   // 6508
    { 23,283,  0,  0,  0,  0},   // 6509
    {  2,  3,  5,  7, 31,  0},   // 6510
    { 17,383,  0,  0,  0,  0},   // 6511
    {  2, 11, 37,  0,  0,  0},   // 6512
    {  3, 13,167,  0,  0,  0},   // 6513
    {  2,3257,  0,  0,  0,  0},   // 6514
    {  5,1303,  0,  0,  0,  0},   // 6515
    {  2,  3,181,  0,  0,  0},   // 6516
    {  7, 19,  0,  0,  0,  0},   // 6517
    {  2,3259,  0,  0,  0,  0},   // 6518
    {  3, 41, 53,  0,  0,  0},   // 6519
    {  2,  5,163,  0,  0,  0},   // 6520
    {  0,  0,  0,  0,  0,  0},   // 6521
    {  2,  3,1087,  0,  0,  0},   // 6522
    { 11,593,  0,  0,  0,  0},   // 6523
    {  2,  7,233,  0,  0,  0},   // 6524
    {  3,  5, 29,  0,  0,  0},   // 6525
    {  2, 13,251,  0,  0,  0},   // 6526
    { 61,107,  0,  0,  0,  0},   // 6527
    {  2,  3, 17,  0,  0,  0},   // 6528
    {  0,  0,  0,  0,  0,  0},   // 6529
    {  2,  5,653,  0,  0,  0},   // 6530
    {  3,  7,311,  0,  0,  0},   // 6531
    {  2, 23, 71,  0,  0,  0},   // 6532
    { 47,139,  0,  0,  0,  0},   // 6533
    {  2,  3, 11,  0,  0,  0},   // 6534
    {  5,1307,  0,  0,  0,  0},   // 6535
    {  2, 19, 43,  0,  0,  0},   // 6536
    {  3,2179,  0,  0,  0,  0},   // 6537
    {  2,  7,467,  0,  0,  0},   // 6538
    { 13,503,  0,  0,  0,  0},   // 6539
    {  2,  3,  5,109,  0,  0},   // 6540
    { 31,211,  0,  0,  0,  0},   // 6541
    {  2,3271,  0,  0,  0,  0},   // 6542
    {  3,727,  0,  0,  0,  0},   // 6543
    {  2,409,  0,  0,  0,  0},   // 6544
    {  5,  7, 11, 17,  0,  0},   // 6545
    {  2,  3,1091,  0,  0,  0},   // 6546
    {  0,  0,  0,  0,  0,  0},   // 6547
    {  2,1637,  0,  0,  0,  0},   // 6548
    {  3, 37, 59,  0,  0,  0},   // 6549
    {  2,  5,131,  0,  0,  0},   // 6550
    {  0,  0,  0,  0,  0,  0},   // 6551
    {  2,  3,  7, 13,  0,  0},   // 6552
    {  0,  0,  0,  0,  0,  0},   // 6553
    {  2, 29,113,  0,  0,  0},   // 6554
    {  3,  5, 19, 23,  0,  0},   // 6555
    {  2, 11,149,  0,  0,  0},   // 6556
    { 79, 83,  0,  0,  0,  0},   // 6557
    {  2,  3,1093,  0,  0,  0},   // 6558
    {  7,937,  0,  0,  0,  0},   // 6559
    {  2,  5, 41,  0,  0,  0},   // 6560
    {  3,  0,  0,  0,  0,  0},   // 6561
    {  2, 17,193,  0,  0,  0},   // 6562
    {  0,  0,  0,  0,  0,  0},   // 6563
    {  2,  3,547,  0,  0,  0},   // 6564
    {  5, 13,101,  0,  0,  0},   // 6565
    {  2,  7, 67,  0,  0,  0},   // 6566
    {  3, 11,199,  0,  0,  0},   // 6567
    {  2,821,  0,  0,  0,  0},   // 6568
    {  0,  0,  0,  0,  0,  0},   // 6569
    {  2,  3,  5, 73,  0,  0},   // 6570
    {  0,  0,  0,  0,  0,  0},   // 6571
    {  2, 31, 53,  0,  0,  0},   // 6572
    {  3,  7,313,  0,  0,  0},   // 6573
    {  2, 19,173,  0,  0,  0},   // 6574
    {  5,263,  0,  0,  0,  0},   // 6575
    {  2,  3,137,  0,  0,  0},   // 6576
    {  0,  0,  0,  0,  0,  0},   // 6577
    {  2, 11, 13, 23,  0,  0},   // 6578
    {  3, 17, 43,  0,  0,  0},   // 6579
    {  2,  5,  7, 47,  0,  0},   // 6580
    {  0,  0,  0,  0,  0,  0},   // 6581
    {  2,  3,1097,  0,  0,  0},   // 6582
    { 29,227,  0,  0,  0,  0},   // 6583
    {  2,823,  0,  0,  0,  0},   // 6584
    {  3,  5,439,  0,  0,  0},   // 6585
    {  2, 37, 89,  0,  0,  0},   // 6586
    {  7,941,  0,  0,  0,  0},   // 6587
    {  2,  3, 61,  0,  0,  0},   // 6588
    { 11,599,  0,  0,  0,  0},   // 6589
    {  2,  5,659,  0,  0,  0},   // 6590
    {  3, 13,  0,  0,  0,  0},   // 6591
    {  2,103,  0,  0,  0,  0},   // 6592
    { 19,347,  0,  0,  0,  0},   // 6593
    {  2,  3,  7,157,  0,  0},   // 6594
    {  5,1319,  0,  0,  0,  0},   // 6595
    {  2, 17, 97,  0,  0,  0},   // 6596
    {  3,733,  0,  0,  0,  0},   // 6597
    {  2,3299,  0,  0,  0,  0},   // 6598
    {  0,  0,  0,  0,  0,  0},   // 6599
    {  2,  3,  5, 11,  0,  0},   // 6600
    {  7, 23, 41,  0,  0,  0},   // 6601
    {  2,3301,  0,  0,  0,  0},   // 6602
    {  3, 31, 71,  0,  0,  0},   // 6603
    {  2, 13,127,  0,  0,  0},   // 6604
    {  5,1321,  0,  0,  0,  0},   // 6605
    {  2,  3,367,  0,  0,  0},   // 6606
    {  0,  0,  0,  0,  0,  0},   // 6607
    {  2,  7, 59,  0,  0,  0},   // 6608
    {  3,2203,  0,  0,  0,  0},   // 6609
    {  2,  5,661,  0,  0,  0},   // 6610
    { 11,601,  0,  0,  0,  0},   // 6611
    {  2,  3, 19, 29,  0,  0},   // 6612
    { 17,389,  0,  0,  0,  0},   // 6613
    {  2,3307,  0,  0,  0,  0},   // 6614
    {  3,  5,  7,  0,  0,  0},   // 6615
    {  2,827,  0,  0,  0,  0},   // 6616
    { 13,509,  0,  0,  0,  0},   // 6617
    {  2,  3,1103,  0,  0,  0},   // 6618
    {  0,  0,  0,  0,  0,  0},   // 6619
    {  2,  5,331,  0,  0,  0},   // 6620
    {  3,2207,  0,  0,  0,  0},   // 6621
    {  2,  7, 11, 43,  0,  0},   // 6622
    { 37,179,  0,  0,  0,  0},   // 6623
    {  2,  3, 23,  0,  0,  0},   // 6624
    {  5, 53,  0,  0,  0,  0},   // 6625
    {  2,3313,  0,  0,  0,  0},   // 6626
    {  3, 47,  0,  0,  0,  0},   // 6627
    {  2,1657,  0,  0,  0,  0},   // 6628
    {  7,947,  0,  0,  0,  0},   // 6629
    {  2,  3,  5, 13, 17,  0},   // 6630
    { 19,349,  0,  0,  0,  0},   // 6631
    {  2,829,  0,  0,  0,  0},   // 6632
    {  3, 11, 67,  0,  0,  0},   // 6633
    {  2, 31,107,  0,  0,  0},   // 6634
    {  5,1327,  0,  0,  0,  0},   // 6635
    {  2,  3,  7, 79,  0,  0},   // 6636
    {  0,  0,  0,  0,  0,  0},   // 6637
    {  2,3319,  0,  0,  0,  0},   // 6638
    {  3,2213,  0,  0,  0,  0},   // 6639
    {  2,  5, 83,  0,  0,  0},   // 6640
    { 29,229,  0,  0,  0,  0},   // 6641
    {  2,  3, 41,  0,  0,  0},   // 6642
    {  7, 13, 73,  0,  0,  0},   // 6643
    {  2, 11,151,  0,  0,  0},   // 6644
    {  3,  5,443,  0,  0,  0},   // 6645
    {  2,3323,  0,  0,  0,  0},   // 6646
    { 17, 23,  0,  0,  0,  0},   // 6647
    {  2,  3,277,  0,  0,  0},   // 6648
    { 61,109,  0,  0,  0,  0},   // 6649
    {  2,  5,  7, 19,  0,  0},   // 6650
    {  3,739,  0,  0,  0,  0},   // 6651
    {  2,1663,  0,  0,  0,  0},   // 6652
    {  0,  0,  0,  0,  0,  0},   // 6653
    {  2,  3,1109,  0,  0,  0},   // 6654
    {  5, 11,  0,  0,  0,  0},   // 6655
    {  2, 13,  0,  0,  0,  0},   // 6656
    {  3,  7,317,  0,  0,  0},   // 6657
    {  2,3329,  0,  0,  0,  0},   // 6658
    {  0,  0,  0,  0,  0,  0},   // 6659
    {  2,  3,  5, 37,  0,  0},   // 6660
    {  0,  0,  0,  0,  0,  0},   // 6661
    {  2,3331,  0,  0,  0,  0},   // 6662
    {  3,2221,  0,  0,  0,  0},   // 6663
    {  2,  7, 17,  0,  0,  0},   // 6664
    {  5, 31, 43,  0,  0,  0},   // 6665
    {  2,  3, 11,101,  0,  0},   // 6666
    { 59,113,  0,  0,  0,  0},   // 6667
    {  2,1667,  0,  0,  0,  0},   // 6668
    {  3, 13, 19,  0,  0,  0},   // 6669
    {  2,  5, 23, 29,  0,  0},   // 6670
    {  7,953,  0,  0,  0,  0},   // 6671
    {  2,  3,139,  0,  0,  0},   // 6672
    {  0,  0,  0,  0,  0,  0},   // 6673
    {  2, 47, 71,  0,  0,  0},   // 6674
    {  3,  5, 89,  0,  0,  0},   // 6675
    {  2,1669,  0,  0,  0,  0},   // 6676
    { 11,607,  0,  0,  0,  0},   // 6677
    {  2,  3,  7, 53,  0,  0},   // 6678
    {  0,  0,  0,  0,  0,  0},   // 6679
    {  2,  5,167,  0,  0,  0},   // 6680
    {  3, 17,131,  0,  0,  0},   // 6681
    {  2, 13,257,  0,  0,  0},   // 6682
    { 41,163,  0,  0,  0,  0},   // 6683
    {  2,  3,557,  0,  0,  0},   // 6684
    {  5,  7,191,  0,  0,  0},   // 6685
    {  2,3343,  0,  0,  0,  0},   // 6686
    {  3,743,  0,  0,  0,  0},   // 6687
    {  2, 11, 19,  0,  0,  0},   // 6688
    {  0,  0,  0,  0,  0,  0},   // 6689
    {  2,  3,  5,223,  0,  0},   // 6690
    {  0,  0,  0,  0,  0,  0},   // 6691
    {  2,  7,239,  0,  0,  0},   // 6692
    {  3, 23, 97,  0,  0,  0},   // 6693
    {  2,3347,  0,  0,  0,  0},   // 6694
    {  5, 13,103,  0,  0,  0},   // 6695
    {  2,  3, 31,  0,  0,  0},   // 6696
    { 37,181,  0,  0,  0,  0},   // 6697
    {  2, 17,197,  0,  0,  0},   // 6698
    {  3,  7, 11, 29,  0,  0},   // 6699
    {  2,  5, 67,  0,  0,  0},   // 6700
    {  0,  0,  0,  0,  0,  0},   // 6701
    {  2,  3,1117,  0,  0,  0},   // 6702
    {  0,  0,  0,  0,  0,  0},   // 6703
    {  2,419,  0,  0,  0,  0},   // 6704
    {  3,  5,149,  0,  0,  0},   // 6705
    {  2,  7,479,  0,  0,  0},   // 6706
    { 19,353,  0,  0,  0,  0},   // 6707
    {  2,  3, 13, 43,  0,  0},   // 6708
    {  0,  0,  0,  0,  0,  0},   // 6709
    {  2,  5, 11, 61,  0,  0},   // 6710
    {  3,2237,  0,  0,  0,  0},   // 6711
    {  2,839,  0,  0,  0,  0},   // 6712
    {  7,137,  0,  0,  0,  0},   // 6713
    {  2,  3,373,  0,  0,  0},   // 6714
    {  5, 17, 79,  0,  0,  0},   // 6715
    {  2, 23, 73,  0,  0,  0},   // 6716
    {  3,2239,  0,  0,  0,  0},   // 6717
    {  2,3359,  0,  0,  0,  0},   // 6718
    {  0,  0,  0,  0,  0,  0},   // 6719
    {  2,  3,  5,  7,  0,  0},   // 6720
    { 11, 13, 47,  0,  0,  0},   // 6721
    {  2,3361,  0,  0,  0,  0},   // 6722
    {  3, 83,  0,  0,  0,  0},   // 6723
    {  2, 41,  0,  0,  0,  0},   // 6724
    {  5,269,  0,  0,  0,  0},   // 6725
    {  2,  3, 19, 59,  0,  0},   // 6726
    {  7, 31,  0,  0,  0,  0},   // 6727
    {  2, 29,  0,  0,  0,  0},   // 6728
    {  3,2243,  0,  0,  0,  0},   // 6729
    {  2,  5,673,  0,  0,  0},   // 6730
    { 53,127,  0,  0,  0,  0},   // 6731
    {  2,  3, 11, 17,  0,  0},   // 6732
    {  0,  0,  0,  0,  0,  0},   // 6733
    {  2,  7, 13, 37,  0,  0},   // 6734
    {  3,  5,449,  0,  0,  0},   // 6735
    {  2,421,  0,  0,  0,  0},   // 6736
    {  0,  0,  0,  0,  0,  0},   // 6737
    {  2,  3,1123,  0,  0,  0},   // 6738
    { 23,293,  0,  0,  0,  0},   // 6739
    {  2,  5,337,  0,  0,  0},   // 6740
    {  3,  7,107,  0,  0,  0},   // 6741
    {  2,3371,  0,  0,  0,  0},   // 6742
    { 11,613,  0,  0,  0,  0},   // 6743
    {  2,  3,281,  0,  0,  0},   // 6744
    {  5, 19, 71,  0,  0,  0},   // 6745
    {  2,3373,  0,  0,  0,  0},   // 6746
    {  3, 13,173,  0,  0,  0},   // 6747
    {  2,  7,241,  0,  0,  0},   // 6748
    { 17,397,  0,  0,  0,  0},   // 6749
    {  2,  3,  5,  0,  0,  0},   // 6750
    { 43,157,  0,  0,  0,  0},   // 6751
    {  2,211,  0,  0,  0,  0},   // 6752
    {  3,2251,  0,  0,  0,  0},   // 6753
    {  2, 11,307,  0,  0,  0},   // 6754
    {  5,  7,193,  0,  0,  0},   // 6755
    {  2,  3,563,  0,  0,  0},   // 6756
    { 29,233,  0,  0,  0,  0},   // 6757
    {  2, 31,109,  0,  0,  0},   // 6758
    {  3,751,  0,  0,  0,  0},   // 6759
    {  2,  5, 13,  0,  0,  0},   // 6760
    {  0,  0,  0,  0,  0,  0},   // 6761
    {  2,  3,  7, 23,  0,  0},   // 6762
    {  0,  0,  0,  0,  0,  0},   // 6763
    {  2, 19, 89,  0,  0,  0},   // 6764
    {  3,  5, 11, 41,  0,  0},   // 6765
    {  2, 17,199,  0,  0,  0},   // 6766
    { 67,101,  0,  0,  0,  0},   // 6767
    {  2,  3, 47,  0,  0,  0},   // 6768
    {  7,967,  0,  0,  0,  0},   // 6769
    {  2,  5,677,  0,  0,  0},   // 6770
    {  3, 37, 61,  0,  0,  0},   // 6771
    {  2,1693,  0,  0,  0,  0},   // 6772
    { 13,521,  0,  0,  0,  0},   // 6773
    {  2,  3,1129,  0,  0,  0},   // 6774
    {  5,271,  0,  0,  0,  0},   // 6775
    {  2,  7, 11,  0,  0,  0},   // 6776
    {  3,251,  0,  0,  0,  0},   // 6777
    {  2,3389,  0,  0,  0,  0},   // 6778
    {  0,  0,  0,  0,  0,  0},   // 6779
    {  2,  3,  5,113,  0,  0},   // 6780
    {  0,  0,  0,  0,  0,  0},   // 6781
    {  2,3391,  0,  0,  0,  0},   // 6782
    {  3,  7, 17, 19,  0,  0},   // 6783
    {  2, 53,  0,  0,  0,  0},   // 6784
    {  5, 23, 59,  0,  0,  0},   // 6785
    {  2,  3, 13, 29,  0,  0},   // 6786
    { 11,617,  0,  0,  0,  0},   // 6787
    {  2,1697,  0,  0,  0,  0},   // 6788
    {  3, 31, 73,  0,  0,  0},   // 6789
    {  2,  5,  7, 97,  0,  0},   // 6790
    {  0,  0,  0,  0,  0,  0},   // 6791
    {  2,  3,283,  0,  0,  0},   // 6792
    {  0,  0,  0,  0,  0,  0},   // 6793
    {  2, 43, 79,  0,  0,  0},   // 6794
    {  3,  5,151,  0,  0,  0},   // 6795
    {  2,1699,  0,  0,  0,  0},   // 6796
    {  7,971,  0,  0,  0,  0},   // 6797
    {  2,  3, 11,103,  0,  0},   // 6798
    { 13,523,  0,  0,  0,  0},   // 6799
    {  2,  5, 17,  0,  0,  0},   // 6800
    {  3,2267,  0,  0,  0,  0},   // 6801
    {  2, 19,179,  0,  0,  0},   // 6802
    {  0,  0,  0,  0,  0,  0},   // 6803
    {  2,  3,  7,  0,  0,  0},   // 6804
    {  5,1361,  0,  0,  0,  0},   // 6805
    {  2, 41, 83,  0,  0,  0},   // 6806
    {  3,2269,  0,  0,  0,  0},   // 6807
    {  2, 23, 37,  0,  0,  0},   // 6808
    { 11,619,  0,  0,  0,  0},   // 6809
    {  2,  3,  5,227,  0,  0},   // 6810
    {  7,139,  0,  0,  0,  0},   // 6811
    {  2, 13,131,  0,  0,  0},   // 6812
    {  3,757,  0,  0,  0,  0},   // 6813
    {  2,3407,  0,  0,  0,  0},   // 6814
    {  5, 29, 47,  0,  0,  0},   // 6815
    {  2,  3, 71,  0,  0,  0},   // 6816
    { 17,401,  0,  0,  0,  0},   // 6817
    {  2,  7,487,  0,  0,  0},   // 6818
    {  3,2273,  0,  0,  0,  0},   // 6819
    {  2,  5, 11, 31,  0,  0},   // 6820
    { 19,359,  0,  0,  0,  0},   // 6821
    {  2,  3,379,  0,  0,  0},   // 6822
    {  0,  0,  0,  0,  0,  0},   // 6823
    {  2,853,  0,  0,  0,  0},   // 6824
    {  3,  5,  7, 13,  0,  0},   // 6825
    {  2,3413,  0,  0,  0,  0},   // 6826
    {  0,  0,  0,  0,  0,  0},   // 6827
    {  2,  3,569,  0,  0,  0},   // 6828
    {  0,  0,  0,  0,  0,  0},   // 6829
    {  2,  5,683,  0,  0,  0},   // 6830
    {  3, 11, 23,  0,  0,  0},   // 6831
    {  2,  7, 61,  0,  0,  0},   // 6832
    {  0,  0,  0,  0,  0,  0},   // 6833
    {  2,  3, 17, 67,  0,  0},   // 6834
    {  5,1367,  0,  0,  0,  0},   // 6835
    {  2,1709,  0,  0,  0,  0},   // 6836
    {  3, 43, 53,  0,  0,  0},   // 6837
    {  2, 13,263,  0,  0,  0},   // 6838
    {  7,977,  0,  0,  0,  0},   // 6839
    {  2,  3,  5, 19,  0,  0},   // 6840
    {  0,  0,  0,  0,  0,  0},   // 6841
    {  2, 11,311,  0,  0,  0},   // 6842
    {  3,2281,  0,  0,  0,  0},   // 6843
    {  2, 29, 59,  0,  0,  0},   // 6844
    {  5, 37,  0,  0,  0,  0},   // 6845
    {  2,  3,  7,163,  0,  0},   // 6846
    { 41,167,  0,  0,  0,  0},   // 6847
    {  2,107,  0,  0,  0,  0},   // 6848
    {  3,761,  0,  0,  0,  0},   // 6849
    {  2,  5,137,  0,  0,  0},   // 6850
    { 13, 17, 31,  0,  0,  0},   // 6851
    {  2,  3,571,  0,  0,  0},   // 6852
    {  7, 11, 89,  0,  0,  0},   // 6853
    {  2, 23,149,  0,  0,  0},   // 6854
    {  3,  5,457,  0,  0,  0},   // 6855
    {  2,857,  0,  0,  0,  0},   // 6856
    {  0,  0,  0,  0,  0,  0},   // 6857
    {  2,  3,127,  0,  0,  0},   // 6858
    { 19,  0,  0,  0,  0,  0},   // 6859
    {  2,  5,  7,  0,  0,  0},   // 6860
    {  3,2287,  0,  0,  0,  0},   // 6861
    {  2, 47, 73,  0,  0,  0},   // 6862
    {  0,  0,  0,  0,  0,  0},   // 6863
    {  2,  3, 11, 13,  0,  0},   // 6864
    {  5,1373,  0,  0,  0,  0},   // 6865
    {  2,3433,  0,  0,  0,  0},   // 6866
    {  3,  7,109,  0,  0,  0},   // 6867
    {  2, 17,101,  0,  0,  0},   // 6868
    {  0,  0,  0,  0,  0,  0},   // 6869
    {  2,  3,  5,229,  0,  0},   // 6870
    {  0,  0,  0,  0,  0,  0},   // 6871
    {  2,859,  0,  0,  0,  0},   // 6872
    {  3, 29, 79,  0,  0,  0},   // 6873
    {  2,  7,491,  0,  0,  0},   // 6874
    {  5, 11,  0,  0,  0,  0},   // 6875
    {  2,  3,191,  0,  0,  0},   // 6876
    { 13, 23,  0,  0,  0,  0},   // 6877
    {  2, 19,181,  0,  0,  0},   // 6878
    {  3,2293,  0,  0,  0,  0},   // 6879
    {  2,  5, 43,  0,  0,  0},   // 6880
    {  7,983,  0,  0,  0,  0},   // 6881
    {  2,  3, 31, 37,  0,  0},   // 6882
    {  0,  0,  0,  0,  0,  0},   // 6883
    {  2,1721,  0,  0,  0,  0},   // 6884
    {  3,  5, 17,  0,  0,  0},   // 6885
    {  2, 11,313,  0,  0,  0},   // 6886
    { 71, 97,  0,  0,  0,  0},   // 6887
    {  2,  3,  7, 41,  0,  0},   // 6888
    { 83,  0,  0,  0,  0,  0},   // 6889
    {  2,  5, 13, 53,  0,  0},   // 6890
    {  3,2297,  0,  0,  0,  0},   // 6891
    {  2,1723,  0,  0,  0,  0},   // 6892
    { 61,113,  0,  0,  0,  0},   // 6893
    {  2,  3,383,  0,  0,  0},   // 6894
    {  5,  7,197,  0,  0,  0},   // 6895
    {  2,431,  0,  0,  0,  0},   // 6896
    {  3, 11, 19,  0,  0,  0},   // 6897
    {  2,3449,  0,  0,  0,  0},   // 6898
    {  0,  0,  0,  0,  0,  0},   // 6899
    {  2,  3,  5, 23,  0,  0},   // 6900
    { 67,103,  0,  0,  0,  0},   // 6901
    {  2,  7, 17, 29,  0,  0},   // 6902
    {  3, 13, 59,  0,  0,  0},   // 6903
    {  2,863,  0,  0,  0,  0},   // 6904
    {  5,1381,  0,  0,  0,  0},   // 6905
    {  2,  3,1151,  0,  0,  0},   // 6906
    {  0,  0,  0,  0,  0,  0},   // 6907
    {  2, 11,157,  0,  0,  0},   // 6908
    {  3,  7, 47,  0,  0,  0},   // 6909
    {  2,  5,691,  0,  0,  0},   // 6910
    {  0,  0,  0,  0,  0,  0},   // 6911
    {  2,  3,  0,  0,  0,  0},   // 6912
    { 31,223,  0,  0,  0,  0},   // 6913
    {  2,3457,  0,  0,  0,  0},   // 6914
    {  3,  5,461,  0,  0,  0},   // 6915
    {  2,  7, 13, 19,  0,  0},   // 6916
    {  0,  0,  0,  0,  0,  0},   // 6917
    {  2,  3,1153,  0,  0,  0},   // 6918
    { 11, 17, 37,  0,  0,  0},   // 6919
    {  2,  5,173,  0,  0,  0},   // 6920
    {  3,769,  0,  0,  0,  0},   // 6921
    {  2,3461,  0,  0,  0,  0},   // 6922
    {  7, 23, 43,  0,  0,  0},   // 6923
    {  2,  3,577,  0,  0,  0},   // 6924
    {  5,277,  0,  0,  0,  0},   // 6925
    {  2,3463,  0,  0,  0,  0},   // 6926
    {  3,2309,  0,  0,  0,  0},   // 6927
    {  2,433,  0,  0,  0,  0},   // 6928
    { 13, 41,  0,  0,  0,  0},   // 6929
    {  2,  3,  5,  7, 11,  0},   // 6930
    { 29,239,  0,  0,  0,  0},   // 6931
    {  2,1733,  0,  0,  0,  0},   // 6932
    {  3,2311,  0,  0,  0,  0},   // 6933
    {  2,3467,  0,  0,  0,  0},   // 6934
    {  5, 19, 73,  0,  0,  0},   // 6935
    {  2,  3, 17,  0,  0,  0},   // 6936
    {  7,991,  0,  0,  0,  0},   // 6937
    {  2,3469,  0,  0,  0,  0},   // 6938
    {  3,257,  0,  0,  0,  0},   // 6939
    {  2,  5,347,  0,  0,  0},   // 6940
    { 11,631,  0,  0,  0,  0},   // 6941
    {  2,  3, 13, 89,  0,  0},   // 6942
    { 53,131,  0,  0,  0,  0},   // 6943
    {  2,  7, 31,  0,  0,  0},   // 6944
    {  3,  5,463,  0,  0,  0},   // 6945
    {  2, 23,151,  0,  0,  0},   // 6946
    {  0,  0,  0,  0,  0,  0},   // 6947
    {  2,  3,193,  0,  0,  0},   // 6948
    {  0,  0,  0,  0,  0,  0},   // 6949
    {  2,  5,139,  0,  0,  0},   // 6950
    {  3,  7,331,  0,  0,  0},   // 6951
    {  2, 11, 79,  0,  0,  0},   // 6952
    { 17,409,  0,  0,  0,  0},   // 6953
    {  2,  3, 19, 61,  0,  0},   // 6954
    {  5, 13,107,  0,  0,  0},   // 6955
    {  2, 37, 47,  0,  0,  0},   // 6956
    {  3,773,  0,  0,  0,  0},   // 6957
    {  2,  7, 71,  0,  0,  0},   // 6958
    {  0,  0,  0,  0,  0,  0},   // 6959
    {  2,  3,  5, 29,  0,  0},   // 6960
    {  0,  0,  0,  0,  0,  0},   // 6961
    {  2, 59,  0,  0,  0,  0},   // 6962
    {  3, 11,211,  0,  0,  0},   // 6963
    {  2,1741,  0,  0,  0,  0},   // 6964
    {  5,  7,199,  0,  0,  0},   // 6965
    {  2,  3, 43,  0,  0,  0},   // 6966
    {  0,  0,  0,  0,  0,  0},   // 6967
    {  2, 13, 67,  0,  0,  0},   // 6968
    {  3, 23,101,  0,  0,  0},   // 6969
    {  2,  5, 17, 41,  0,  0},   // 6970
    {  0,  0,  0,  0,  0,  0},   // 6971
    {  2,  3,  7, 83,  0,  0},   // 6972
    { 19,367,  0,  0,  0,  0},   // 6973
    {  2, 11,317,  0,  0,  0},   // 6974
    {  3,  5, 31,  0,  0,  0},   // 6975
    {  2,109,  0,  0,  0,  0},   // 6976
    {  0,  0,  0,  0,  0,  0},   // 6977
    {  2,  3,1163,  0,  0,  0},   // 6978
    {  7,997,  0,  0,  0,  0},   // 6979
    {  2,  5,349,  0,  0,  0},   // 6980
    {  3, 13,179,  0,  0,  0},   // 6981
    {  2,3491,  0,  0,  0,  0},   // 6982
    {  0,  0,  0,  0,  0,  0},   // 6983
    {  2,  3, 97,  0,  0,  0},   // 6984
    {  5, 11,127,  0,  0,  0},   // 6985
    {  2,  7,499,  0,  0,  0},   // 6986
    {  3, 17,137,  0,  0,  0},   // 6987
    {  2,1747,  0,  0,  0,  0},   // 6988
    { 29,241,  0,  0,  0,  0},   // 6989
    {  2,  3,  5,233,  0,  0},   // 6990
    {  0,  0,  0,  0,  0,  0},   // 6991
    {  2, 19, 23,  0,  0,  0},   // 6992
    {  3,  7, 37,  0,  0,  0},   // 6993
    {  2, 13,269,  0,  0,  0},   // 6994
    {  5,1399,  0,  0,  0,  0},   // 6995
    {  2,  3, 11, 53,  0,  0},   // 6996
    {  0,  0,  0,  0,  0,  0},   // 6997
    {  2,3499,  0,  0,  0,  0},   // 6998
    {  3,2333,  0,  0,  0,  0},   // 6999
    {  2,  5,  7,  0,  0,  0},   // 7000
    {  0,  0,  0,  0,  0,  0},   // 7001
    {  2,  3,389,  0,  0,  0},   // 7002
    { 47,149,  0,  0,  0,  0},   // 7003
    {  2, 17,103,  0,  0,  0},   // 7004
    {  3,  5,467,  0,  0,  0},   // 7005
    {  2, 31,113,  0,  0,  0},   // 7006
    {  7, 11, 13,  0,  0,  0},   // 7007
    {  2,  3, 73,  0,  0,  0},   // 7008
    { 43,163,  0,  0,  0,  0},   // 7009
    {  2,  5,701,  0,  0,  0},   // 7010
    {  3, 19, 41,  0,  0,  0},   // 7011
    {  2,1753,  0,  0,  0,  0},   // 7012
    {  0,  0,  0,  0,  0,  0},   // 7013
    {  2,  3,  7,167,  0,  0},   // 7014
    {  5, 23, 61,  0,  0,  0},   // 7015
    {  2,877,  0,  0,  0,  0},   // 7016
    {  3,2339,  0,  0,  0,  0},   // 7017
    {  2, 11, 29,  0,  0,  0},   // 7018
    {  0,  0,  0,  0,  0,  0},   // 7019
    {  2,  3,  5, 13,  0,  0},   // 7020
    {  7, 17, 59,  0,  0,  0},   // 7021
    {  2,3511,  0,  0,  0,  0},   // 7022
    {  3,2341,  0,  0,  0,  0},   // 7023
    {  2,439,  0,  0,  0,  0},   // 7024
    {  5,281,  0,  0,  0,  0},   // 7025
    {  2,  3,1171,  0,  0,  0},   // 7026
    {  0,  0,  0,  0,  0,  0},   // 7027
    {  2,  7,251,  0,  0,  0},   // 7028
    {  3, 11, 71,  0,  0,  0},   // 7029
    {  2,  5, 19, 37,  0,  0},   // 7030
    { 79, 89,  0,  0,  0,  0},   // 7031
    {  2,  3,293,  0,  0,  0},   // 7032
    { 13,541,  0,  0,  0,  0},   // 7033
    {  2,3517,  0,  0,  0,  0},   // 7034
    {  3,  5,  7, 67,  0,  0},   // 7035
    {  2,1759,  0,  0,  0,  0},   // 7036
    { 31,227,  0,  0,  0,  0},   // 7037
    {  2,  3, 17, 23,  0,  0},   // 7038
    {  0,  0,  0,  0,  0,  0},   // 7039
    {  2,  5, 11,  0,  0,  0},   // 7040
    {  3,2347,  0,  0,  0,  0},   // 7041
    {  2,  7,503,  0,  0,  0},   // 7042
    {  0,  0,  0,  0,  0,  0},   // 7043
    {  2,  3,587,  0,  0,  0},   // 7044
    {  5,1409,  0,  0,  0,  0},   // 7045
    {  2, 13,271,  0,  0,  0},   // 7046
    {  3, 29,  0,  0,  0,  0},   // 7047
    {  2,881,  0,  0,  0,  0},   // 7048
    {  7, 19, 53,  0,  0,  0},   // 7049
    {  2,  3,  5, 47,  0,  0},   // 7050
    { 11,641,  0,  0,  0,  0},   // 7051
    {  2, 41, 43,  0,  0,  0},   // 7052
    {  3,2351,  0,  0,  0,  0},   // 7053
    {  2,3527,  0,  0,  0,  0},   // 7054
    {  5, 17, 83,  0,  0,  0},   // 7055
    {  2,  3,  7,  0,  0,  0},   // 7056
    {  0,  0,  0,  0,  0,  0},   // 7057
    {  2,3529,  0,  0,  0,  0},   // 7058
    {  3, 13,181,  0,  0,  0},   // 7059
    {  2,  5,353,  0,  0,  0},   // 7060
    { 23,307,  0,  0,  0,  0},   // 7061
    {  2,  3, 11,107,  0,  0},   // 7062
    {  7,1009,  0,  0,  0,  0},   // 7063
    {  2,883,  0,  0,  0,  0},   // 7064
    {  3,  5,157,  0,  0,  0},   // 7065
    {  2,3533,  0,  0,  0,  0},   // 7066
    { 37,191,  0,  0,  0,  0},   // 7067
    {  2,  3, 19, 31,  0,  0},   // 7068
    {  0,  0,  0,  0,  0,  0},   // 7069
    {  2,  5,  7,101,  0,  0},   // 7070
    {  3,2357,  0,  0,  0,  0},   // 7071
    {  2, 13, 17,  0,  0,  0},   // 7072
    { 11,643,  0,  0,  0,  0},   // 7073
    {  2,  3,131,  0,  0,  0},   // 7074
    {  5,283,  0,  0,  0,  0},   // 7075
    {  2, 29, 61,  0,  0,  0},   // 7076
    {  3,  7,337,  0,  0,  0},   // 7077
    {  2,3539,  0,  0,  0,  0},   // 7078
    {  0,  0,  0,  0,  0,  0},   // 7079
    {  2,  3,  5, 59,  0,  0},   // 7080
    { 73, 97,  0,  0,  0,  0},   // 7081
    {  2,3541,  0,  0,  0,  0},   // 7082
    {  3,787,  0,  0,  0,  0},   // 7083
    {  2,  7, 11, 23,  0,  0},   // 7084
    {  5, 13,109,  0,  0,  0},   // 7085
    {  2,  3,1181,  0,  0,  0},   // 7086
    { 19,373,  0,  0,  0,  0},   // 7087
    {  2,443,  0,  0,  0,  0},   // 7088
    {  3, 17,139,  0,  0,  0},   // 7089
    {  2,  5,709,  0,  0,  0},   // 7090
    {  7,1013,  0,  0,  0,  0},   // 7091
    {  2,  3,197,  0,  0,  0},   // 7092
    { 41,173,  0,  0,  0,  0},   // 7093
    {  2,3547,  0,  0,  0,  0},   // 7094
    {  3,  5, 11, 43,  0,  0},   // 7095
    {  2,887,  0,  0,  0,  0},   // 7096
    { 47,151,  0,  0,  0,  0},   // 7097
    {  2,  3,  7, 13,  0,  0},   // 7098
    { 31,229,  0,  0,  0,  0},   // 7099
    {  2,  5, 71,  0,  0,  0},   // 7100
    {  3,263,  0,  0,  0,  0},   // 7101
    {  2, 53, 67,  0,  0,  0},   // 7102
    {  0,  0,  0,  0,  0,  0},   // 7103
    {  2,  3, 37,  0,  0,  0},   // 7104
    {  5,  7, 29,  0,  0,  0},   // 7105
    {  2, 11, 17, 19,  0,  0},   // 7106
    {  3, 23,103,  0,  0,  0},   // 7107
    {  2,1777,  0,  0,  0,  0},   // 7108
    {  0,  0,  0,  0,  0,  0},   // 7109
    {  2,  3,  5, 79,  0,  0},   // 7110
    { 13,547,  0,  0,  0,  0},   // 7111
    {  2,  7,127,  0,  0,  0},   // 7112
    {  3,2371,  0,  0,  0,  0},   // 7113
    {  2,3557,  0,  0,  0,  0},   // 7114
    {  5,1423,  0,  0,  0,  0},   // 7115
    {  2,  3,593,  0,  0,  0},   // 7116
    { 11,647,  0,  0,  0,  0},   // 7117
    {  2,3559,  0,  0,  0,  0},   // 7118
    {  3,  7,113,  0,  0,  0},   // 7119
    {  2,  5, 89,  0,  0,  0},   // 7120
    {  0,  0,  0,  0,  0,  0},   // 7121
    {  2,  3,1187,  0,  0,  0},   // 7122
    { 17,419,  0,  0,  0,  0},   // 7123
    {  2, 13,137,  0,  0,  0},   // 7124
    {  3,  5, 19,  0,  0,  0},   // 7125
    {  2,  7,509,  0,  0,  0},   // 7126
    {  0,  0,  0,  0,  0,  0},   // 7127
    {  2,  3, 11,  0,  0,  0},   // 7128
    {  0,  0,  0,  0,  0,  0},   // 7129
    {  2,  5, 23, 31,  0,  0},   // 7130
    {  3,2377,  0,  0,  0,  0},   // 7131
    {  2,1783,  0,  0,  0,  0},   // 7132
    {  7,1019,  0,  0,  0,  0},   // 7133
    {  2,  3, 29, 41,  0,  0},   // 7134
    {  5,1427,  0,  0,  0,  0},   // 7135
    {  2,223,  0,  0,  0,  0},   // 7136
    {  3, 13, 61,  0,  0,  0},   // 7137
    {  2, 43, 83,  0,  0,  0},   // 7138
    { 11, 59,  0,  0,  0,  0},   // 7139
    {  2,  3,  5,  7, 17,  0},   // 7140
    { 37,193,  0,  0,  0,  0},   // 7141
    {  2,3571,  0,  0,  0,  0},   // 7142
    {  3,2381,  0,  0,  0,  0},   // 7143
    {  2, 19, 47,  0,  0,  0},   // 7144
    {  5,1429,  0,  0,  0,  0},   // 7145
    {  2,  3,397,  0,  0,  0},   // 7146
    {  7,1021,  0,  0,  0,  0},   // 7147
    {  2,1787,  0,  0,  0,  0},   // 7148
    {  3,2383,  0,  0,  0,  0},   // 7149
    {  2,  5, 11, 13,  0,  0},   // 7150
    {  0,  0,  0,  0,  0,  0},   // 7151
    {  2,  3,149,  0,  0,  0},   // 7152
    { 23,311,  0,  0,  0,  0},   // 7153
    {  2,  7, 73,  0,  0,  0},   // 7154
    {  3,  5, 53,  0,  0,  0},   // 7155
    {  2,1789,  0,  0,  0,  0},   // 7156
    { 17,421,  0,  0,  0,  0},   // 7157
    {  2,  3,1193,  0,  0,  0},   // 7158
    {  0,  0,  0,  0,  0,  0},   // 7159
    {  2,  5,179,  0,  0,  0},   // 7160
    {  3,  7, 11, 31,  0,  0},   // 7161
    {  2,3581,  0,  0,  0,  0},   // 7162
    { 13, 19, 29,  0,  0,  0},   // 7163
    {  2,  3,199,  0,  0,  0},   // 7164
    {  5,1433,  0,  0,  0,  0},   // 7165
    {  2,3583,  0,  0,  0,  0},   // 7166
    {  3,2389,  0,  0,  0,  0},   // 7167
    {  2,  7,  0,  0,  0,  0},   // 7168
    { 67,107,  0,  0,  0,  0},   // 7169
    {  2,  3,  5,239,  0,  0},   // 7170
    { 71,101,  0,  0,  0,  0},   // 7171
    {  2, 11,163,  0,  0,  0},   // 7172
    {  3,797,  0,  0,  0,  0},   // 7173
    {  2, 17,211,  0,  0,  0},   // 7174
    {  5,  7, 41,  0,  0,  0},   // 7175
    {  2,  3, 13, 23,  0,  0},   // 7176
    {  0,  0,  0,  0,  0,  0},   // 7177
    {  2, 37, 97,  0,  0,  0},   // 7178
    {  3,2393,  0,  0,  0,  0},   // 7179
    {  2,  5,359,  0,  0,  0},   // 7180
    { 43,167,  0,  0,  0,  0},   // 7181
    {  2,  3,  7, 19,  0,  0},   // 7182
    { 11,653,  0,  0,  0,  0},   // 7183
    {  2,449,  0,  0,  0,  0},   // 7184
    {  3,  5,479,  0,  0,  0},   // 7185
    {  2,3593,  0,  0,  0,  0},   // 7186
    {  0,  0,  0,  0,  0,  0},   // 7187
    {  2,  3,599,  0,  0,  0},   // 7188
    {  7, 13, 79,  0,  0,  0},   // 7189
    {  2,  5,719,  0,  0,  0},   // 7190
    {  3, 17, 47,  0,  0,  0},   // 7191
    {  2, 29, 31,  0,  0,  0},   // 7192
    {  0,  0,  0,  0,  0,  0},   // 7193
    {  2,  3, 11,109,  0,  0},   // 7194
    {  5,1439,  0,  0,  0,  0},   // 7195
    {  2,  7,257,  0,  0,  0},   // 7196
    {  3,2399,  0,  0,  0,  0},   // 7197
    {  2, 59, 61,  0,  0,  0},   // 7198
    { 23,313,  0,  0,  0,  0},   // 7199
    {  2,  3,  5,  0,  0,  0},   // 7200
    { 19,379,  0,  0,  0,  0},   // 7201
    {  2, 13,277,  0,  0,  0},   // 7202
    {  3,  7,  0,  0,  0,  0},   // 7203
    {  2,1801,  0,  0,  0,  0},   // 7204
    {  5, 11,131,  0,  0,  0},   // 7205
    {  2,  3,1201,  0,  0,  0},   // 7206
    {  0,  0,  0,  0,  0,  0},   // 7207
    {  2, 17, 53,  0,  0,  0},   // 7208
    {  3, 89,  0,  0,  0,  0},   // 7209
    {  2,  5,  7,103,  0,  0},   // 7210
    {  0,  0,  0,  0,  0,  0},   // 7211
    {  2,  3,601,  0,  0,  0},   // 7212
    {  0,  0,  0,  0,  0,  0},   // 7213
    {  2,3607,  0,  0,  0,  0},   // 7214
    {  3,  5, 13, 37,  0,  0},   // 7215
    {  2, 11, 41,  0,  0,  0},   // 7216
    {  7,1031,  0,  0,  0,  0},   // 7217
    {  2,  3,401,  0,  0,  0},   // 7218
    {  0,  0,  0,  0,  0,  0},   // 7219
    {  2,  5, 19,  0,  0,  0},   // 7220
    {  3, 29, 83,  0,  0,  0},   // 7221
    {  2, 23,157,  0,  0,  0},   // 7222
    { 31,233,  0,  0,  0,  0},   // 7223
    {  2,  3,  7, 43,  0,  0},   // 7224
    {  5, 17,  0,  0,  0,  0},   // 7225
    {  2,3613,  0,  0,  0,  0},   // 7226
    {  3, 11, 73,  0,  0,  0},   // 7227
    {  2, 13,139,  0,  0,  0},   // 7228
    {  0,  0,  0,  0,  0,  0},   // 7229
    {  2,  3,  5,241,  0,  0},   // 7230
    {  7,1033,  0,  0,  0,  0},   // 7231
    {  2,113,  0,  0,  0,  0},   // 7232
    {  3,2411,  0,  0,  0,  0},   // 7233
    {  2,3617,  0,  0,  0,  0},   // 7234
    {  5,1447,  0,  0,  0,  0},   // 7235
    {  2,  3, 67,  0,  0,  0},   // 7236
    {  0,  0,  0,  0,  0,  0},   // 7237
    {  2,  7, 11, 47,  0,  0},   // 7238
    {  3, 19,127,  0,  0,  0},   // 7239
    {  2,  5,181,  0,  0,  0},   // 7240
    { 13,557,  0,  0,  0,  0},   // 7241
    {  2,  3, 17, 71,  0,  0},   // 7242
    {  0,  0,  0,  0,  0,  0},   // 7243
    {  2,1811,  0,  0,  0,  0},   // 7244
    {  3,  5,  7, 23,  0,  0},   // 7245
    {  2,3623,  0,  0,  0,  0},   // 7246
    {  0,  0,  0,  0,  0,  0},   // 7247
    {  2,  3,151,  0,  0,  0},   // 7248
    { 11,659,  0,  0,  0,  0},   // 7249
    {  2,  5, 29,  0,  0,  0},   // 7250
    {  3,2417,  0,  0,  0,  0},   // 7251
    {  2,  7, 37,  0,  0,  0},   // 7252
    {  0,  0,  0,  0,  0,  0},   // 7253
    {  2,  3, 13, 31,  0,  0},   // 7254
    {  5,1451,  0,  0,  0,  0},   // 7255
    {  2,907,  0,  0,  0,  0},   // 7256
    {  3, 41, 59,  0,  0,  0},   // 7257
    {  2, 19,191,  0,  0,  0},   // 7258
    {  7, 17, 61,  0,  0,  0},   // 7259
    {  2,  3,  5, 11,  0,  0},   // 7260
    { 53,137,  0,  0,  0,  0},   // 7261
    {  2,3631,  0,  0,  0,  0},   // 7262
    {  3,269,  0,  0,  0,  0},   // 7263
    {  2,227,  0,  0,  0,  0},   // 7264
    {  5,1453,  0,  0,  0,  0},   // 7265
    {  2,  3,  7,173,  0,  0},   // 7266
    { 13, 43,  0,  0,  0,  0},   // 7267
    {  2, 23, 79,  0,  0,  0},   // 7268
    {  3,2423,  0,  0,  0,  0},   // 7269
    {  2,  5,727,  0,  0,  0},   // 7270
    { 11,661,  0,  0,  0,  0},   // 7271
    {  2,  3,101,  0,  0,  0},   // 7272
    {  7,1039,  0,  0,  0,  0},   // 7273
    {  2,3637,  0,  0,  0,  0},   // 7274
    {  3,  5, 97,  0,  0,  0},   // 7275
    {  2, 17,107,  0,  0,  0},   // 7276
    { 19,383,  0,  0,  0,  0},   // 7277
    {  2,  3,1213,  0,  0,  0},   // 7278
    { 29,251,  0,  0,  0,  0},   // 7279
    {  2,  5,  7, 13,  0,  0},   // 7280
    {  3,809,  0,  0,  0,  0},   // 7281
    {  2, 11,331,  0,  0,  0},   // 7282
    {  0,  0,  0,  0,  0,  0},   // 7283
    {  2,  3,607,  0,  0,  0},   // 7284
    {  5, 31, 47,  0,  0,  0},   // 7285
    {  2,3643,  0,  0,  0,  0},   // 7286
    {  3,  7,347,  0,  0,  0},   // 7287
    {  2,911,  0,  0,  0,  0},   // 7288
    { 37,197,  0,  0,  0,  0},   // 7289
    {  2,  3,  5,  0,  0,  0},   // 7290
    { 23,317,  0,  0,  0,  0},   // 7291
    {  2,1823,  0,  0,  0,  0},   // 7292
    {  3, 11, 13, 17,  0,  0},   // 7293
    {  2,  7,521,  0,  0,  0},   // 7294
    {  5,1459,  0,  0,  0,  0},   // 7295
    {  2,  3, 19,  0,  0,  0},   // 7296
    {  0,  0,  0,  0,  0,  0},   // 7297
    {  2, 41, 89,  0,  0,  0},   // 7298
    {  3,811,  0,  0,  0,  0},   // 7299
    {  2,  5, 73,  0,  0,  0},   // 7300
    {  7,149,  0,  0,  0,  0},   // 7301
    {  2,  3,1217,  0,  0,  0},   // 7302
    { 67,109,  0,  0,  0,  0},   // 7303
    {  2, 11, 83,  0,  0,  0},   // 7304
    {  3,  5,487,  0,  0,  0},   // 7305
    {  2, 13,281,  0,  0,  0},   // 7306
    {  0,  0,  0,  0,  0,  0},   // 7307
    {  2,  3,  7, 29,  0,  0},   // 7308
    {  0,  0,  0,  0,  0,  0},   // 7309
    {  2,  5, 17, 43,  0,  0},   // 7310
    {  3,2437,  0,  0,  0,  0},   // 7311
    {  2,457,  0,  0,  0,  0},   // 7312
    { 71,103,  0,  0,  0,  0},   // 7313
    {  2,  3, 23, 53,  0,  0},   // 7314
    {  5,  7, 11, 19,  0,  0},   // 7315
    {  2, 31, 59,  0,  0,  0},   // 7316
    {  3,271,  0,  0,  0,  0},   // 7317
    {  2,3659,  0,  0,  0,  0},   // 7318
    { 13,563,  0,  0,  0,  0},   // 7319
    {  2,  3,  5, 61,  0,  0},   // 7320
    {  0,  0,  0,  0,  0,  0},   // 7321
    {  2,  7,523,  0,  0,  0},   // 7322
    {  3,2441,  0,  0,  0,  0},   // 7323
    {  2,1831,  0,  0,  0,  0},   // 7324
    {  5,293,  0,  0,  0,  0},   // 7325
    {  2,  3, 11, 37,  0,  0},   // 7326
    { 17,431,  0,  0,  0,  0},   // 7327
    {  2,229,  0,  0,  0,  0},   // 7328
    {  3,  7,349,  0,  0,  0},   // 7329
    {  2,  5,733,  0,  0,  0},   // 7330
    {  0,  0,  0,  0,  0,  0},   // 7331
    {  2,  3, 13, 47,  0,  0},   // 7332
    {  0,  0,  0,  0,  0,  0},   // 7333
    {  2, 19,193,  0,  0,  0},   // 7334
    {  3,  5,163,  0,  0,  0},   // 7335
    {  2,  7,131,  0,  0,  0},   // 7336
    { 11, 23, 29,  0,  0,  0},   // 7337
    {  2,  3,1223,  0,  0,  0},   // 7338
    { 41,179,  0,  0,  0,  0},   // 7339
    {  2,  5,367,  0,  0,  0},   // 7340
    {  3,2447,  0,  0,  0,  0},   // 7341
    {  2,3671,  0,  0,  0,  0},   // 7342
    {  7,1049,  0,  0,  0,  0},   // 7343
    {  2,  3, 17,  0,  0,  0},   // 7344
    {  5, 13,113,  0,  0,  0},   // 7345
    {  2,3673,  0,  0,  0,  0},   // 7346
    {  3, 31, 79,  0,  0,  0},   // 7347
    {  2, 11,167,  0,  0,  0},   // 7348
    {  0,  0,  0,  0,  0,  0},   // 7349
    {  2,  3,  5,  7,  0,  0},   // 7350
    {  0,  0,  0,  0,  0,  0},   // 7351
    {  2,919,  0,  0,  0,  0},   // 7352
    {  3, 19, 43,  0,  0,  0},   // 7353
    {  2,3677,  0,  0,  0,  0},   // 7354
    {  5,1471,  0,  0,  0,  0},   // 7355
    {  2,  3,613,  0,  0,  0},   // 7356
    {  7,1051,  0,  0,  0,  0},   // 7357
    {  2, 13,283,  0,  0,  0},   // 7358
    {  3, 11,223,  0,  0,  0},   // 7359
    {  2,  5, 23,  0,  0,  0},   // 7360
    { 17,433,  0,  0,  0,  0},   // 7361
    {  2,  3,409,  0,  0,  0},   // 7362
    { 37,199,  0,  0,  0,  0},   // 7363
    {  2,  7,263,  0,  0,  0},   // 7364
    {  3,  5,491,  0,  0,  0},   // 7365
    {  2, 29,127,  0,  0,  0},   // 7366
    { 53,139,  0,  0,  0,  0},   // 7367
    {  2,  3,307,  0,  0,  0},   // 7368
    {  0,  0,  0,  0,  0,  0},   // 7369
    {  2,  5, 11, 67,  0,  0},   // 7370
    {  3,  7, 13,  0,  0,  0},   // 7371
    {  2, 19, 97,  0,  0,  0},   // 7372
    { 73,101,  0,  0,  0,  0},   // 7373
    {  2,  3,1229,  0,  0,  0},   // 7374
    {  5, 59,  0,  0,  0,  0},   // 7375
    {  2,461,  0,  0,  0,  0},   // 7376
    {  3,2459,  0,  0,  0,  0},   // 7377
    {  2,  7, 17, 31,  0,  0},   // 7378
    { 47,157,  0,  0,  0,  0},   // 7379
    {  2,  3,  5, 41,  0,  0},   // 7380
    { 11, 61,  0,  0,  0,  0},   // 7381
    {  2,3691,  0,  0,  0,  0},   // 7382
    {  3, 23,107,  0,  0,  0},   // 7383
    {  2, 13, 71,  0,  0,  0},   // 7384
    {  5,  7,211,  0,  0,  0},   // 7385
    {  2,  3,1231,  0,  0,  0},   // 7386
    { 83, 89,  0,  0,  0,  0},   // 7387
    {  2,1847,  0,  0,  0,  0},   // 7388
    {  3,821,  0,  0,  0,  0},   // 7389
    {  2,  5,739,  0,  0,  0},   // 7390
    { 19,389,  0,  0,  0,  0},   // 7391
    {  2,  3,  7, 11,  0,  0},   // 7392
    {  0,  0,  0,  0,  0,  0},   // 7393
    {  2,3697,  0,  0,  0,  0},   // 7394
    {  3,  5, 17, 29,  0,  0},   // 7395
    {  2, 43,  0,  0,  0,  0},   // 7396
    { 13,569,  0,  0,  0,  0},   // 7397
    {  2,  3,137,  0,  0,  0},   // 7398
    {  7,151,  0,  0,  0,  0},   // 7399
    {  2,  5, 37,  0,  0,  0},   // 7400
    {  3,2467,  0,  0,  0,  0},   // 7401
    {  2,3701,  0,  0,  0,  0},   // 7402
    { 11,673,  0,  0,  0,  0},   // 7403
    {  2,  3,617,  0,  0,  0},   // 7404
    {  5,1481,  0,  0,  0,  0},   // 7405
    {  2,  7, 23,  0,  0,  0},   // 7406
    {  3,823,  0,  0,  0,  0},   // 7407
    {  2,463,  0,  0,  0,  0},   // 7408
    { 31,239,  0,  0,  0,  0},   // 7409
    {  2,  3,  5, 13, 19,  0},   // 7410
    {  0,  0,  0,  0,  0,  0},   // 7411
    {  2, 17,109,  0,  0,  0},   // 7412
    {  3,  7,353,  0,  0,  0},   // 7413
    {  2, 11,337,  0,  0,  0},   // 7414
    {  5,1483,  0,  0,  0,  0},   // 7415
    {  2,  3,103,  0,  0,  0},   // 7416
    {  0,  0,  0,  0,  0,  0},   // 7417
    {  2,3709,  0,  0,  0,  0},   // 7418
    {  3,2473,  0,  0,  0,  0},   // 7419
    {  2,  5,  7, 53,  0,  0},   // 7420
    { 41,181,  0,  0,  0,  0},   // 7421
    {  2,  3,1237,  0,  0,  0},   // 7422
    { 13,571,  0,  0,  0,  0},   // 7423
    {  2, 29,  0,  0,  0,  0},   // 7424
    {  3,  5, 11,  0,  0,  0},   // 7425
    {  2, 47, 79,  0,  0,  0},   // 7426
    {  7,1061,  0,  0,  0,  0},   // 7427
    {  2,  3,619,  0,  0,  0},   // 7428
    { 17, 19, 23,  0,  0,  0},   // 7429
    {  2,  5,743,  0,  0,  0},   // 7430
    {  3,2477,  0,  0,  0,  0},   // 7431
    {  2,929,  0,  0,  0,  0},   // 7432
    {  0,  0,  0,  0,  0,  0},   // 7433
    {  2,  3,  7, 59,  0,  0},   // 7434
    {  5,1487,  0,  0,  0,  0},   // 7435
    {  2, 11, 13,  0,  0,  0},   // 7436
    {  3, 37, 67,  0,  0,  0},   // 7437
    {  2,3719,  0,  0,  0,  0},   // 7438
    { 43,173,  0,  0,  0,  0},   // 7439
    {  2,  3,  5, 31,  0,  0},   // 7440
    {  7,1063,  0,  0,  0,  0},   // 7441
    {  2, 61,  0,  0,  0,  0},   // 7442
    {  3,827,  0,  0,  0,  0},   // 7443
    {  2,1861,  0,  0,  0,  0},   // 7444
    {  5,1489,  0,  0,  0,  0},   // 7445
    {  2,  3, 17, 73,  0,  0},   // 7446
    { 11,677,  0,  0,  0,  0},   // 7447
    {  2,  7, 19,  0,  0,  0},   // 7448
    {  3, 13,191,  0,  0,  0},   // 7449
    {  2,  5,149,  0,  0,  0},   // 7450
    {  0,  0,  0,  0,  0,  0},   // 7451
    {  2,  3, 23,  0,  0,  0},   // 7452
    { 29,257,  0,  0,  0,  0},   // 7453
    {  2,3727,  0,  0,  0,  0},   // 7454
    {  3,  5,  7, 71,  0,  0},   // 7455
    {  2,233,  0,  0,  0,  0},   // 7456
    {  0,  0,  0,  0,  0,  0},   // 7457
    {  2,  3, 11,113,  0,  0},   // 7458
    {  0,  0,  0,  0,  0,  0},   // 7459
    {  2,  5,373,  0,  0,  0},   // 7460
    {  3,829,  0,  0,  0,  0},   // 7461
    {  2,  7, 13, 41,  0,  0},   // 7462
    { 17,439,  0,  0,  0,  0},   // 7463
    {  2,  3,311,  0,  0,  0},   // 7464
    {  5,1493,  0,  0,  0,  0},   // 7465
    {  2,3733,  0,  0,  0,  0},   // 7466
    {  3, 19,131,  0,  0,  0},   // 7467
    {  2,1867,  0,  0,  0,  0},   // 7468
    {  7, 11, 97,  0,  0,  0},   // 7469
    {  2,  3,  5, 83,  0,  0},   // 7470
    { 31,241,  0,  0,  0,  0},   // 7471
    {  2,467,  0,  0,  0,  0},   // 7472
    {  3, 47, 53,  0,  0,  0},   // 7473
    {  2, 37,101,  0,  0,  0},   // 7474
    {  5, 13, 23,  0,  0,  0},   // 7475
    {  2,  3,  7, 89,  0,  0},   // 7476
    {  0,  0,  0,  0,  0,  0},   // 7477
    {  2,3739,  0,  0,  0,  0},   // 7478
    {  3,277,  0,  0,  0,  0},   // 7479
    {  2,  5, 11, 17,  0,  0},   // 7480
    {  0,  0,  0,  0,  0,  0},   // 7481
    {  2,  3, 29, 43,  0,  0},   // 7482
    {  7,1069,  0,  0,  0,  0},   // 7483
    {  2,1871,  0,  0,  0,  0},   // 7484
    {  3,  5,499,  0,  0,  0},   // 7485
    {  2, 19,197,  0,  0,  0},   // 7486
    {  0,  0,  0,  0,  0,  0},   // 7487
    {  2,  3, 13,  0,  0,  0},   // 7488
    {  0,  0,  0,  0,  0,  0},   // 7489
    {  2,  5,  7,107,  0,  0},   // 7490
    {  3, 11,227,  0,  0,  0},   // 7491
    {  2,1873,  0,  0,  0,  0},   // 7492
    { 59,127,  0,  0,  0,  0},   // 7493
    {  2,  3,1249,  0,  0,  0},   // 7494
    {  5,1499,  0,  0,  0,  0},   // 7495
    {  2,937,  0,  0,  0,  0},   // 7496
    {  3,  7, 17,  0,  0,  0},   // 7497
    {  2, 23,163,  0,  0,  0},   // 7498
    {  0,  0,  0,  0,  0,  0},   // 7499
    {  2,  3,  5,  0,  0,  0},   // 7500
    { 13,577,  0,  0,  0,  0},   // 7501
    {  2, 11, 31,  0,  0,  0},   // 7502
    {  3, 41, 61,  0,  0,  0},   // 7503
    {  2,  7, 67,  0,  0,  0},   // 7504
    {  5, 19, 79,  0,  0,  0},   // 7505
    {  2,  3,139,  0,  0,  0},   // 7506
    {  0,  0,  0,  0,  0,  0},   // 7507
    {  2,1877,  0,  0,  0,  0},   // 7508
    {  3,2503,  0,  0,  0,  0},   // 7509
    {  2,  5,751,  0,  0,  0},   // 7510
    {  7, 29, 37,  0,  0,  0},   // 7511
    {  2,  3,313,  0,  0,  0},   // 7512
    { 11,683,  0,  0,  0,  0},   // 7513
    {  2, 13, 17,  0,  0,  0},   // 7514
    {  3,  5,167,  0,  0,  0},   // 7515
    {  2,1879,  0,  0,  0,  0},   // 7516
    {  0,  0,  0,  0,  0,  0},   // 7517
    {  2,  3,  7,179,  0,  0},   // 7518
    { 73,103,  0,  0,  0,  0},   // 7519
    {  2,  5, 47,  0,  0,  0},   // 7520
    {  3, 23,109,  0,  0,  0},   // 7521
    {  2,3761,  0,  0,  0,  0},   // 7522
    {  0,  0,  0,  0,  0,  0},   // 7523
    {  2,  3, 11, 19,  0,  0},   // 7524
    {  5,  7, 43,  0,  0,  0},   // 7525
    {  2, 53, 71,  0,  0,  0},   // 7526
    {  3, 13,193,  0,  0,  0},   // 7527
    {  2,941,  0,  0,  0,  0},   // 7528
    {  0,  0,  0,  0,  0,  0},   // 7529
    {  2,  3,  5,251,  0,  0},   // 7530
    { 17,443,  0,  0,  0,  0},   // 7531
    {  2,  7,269,  0,  0,  0},   // 7532
    {  3, 31,  0,  0,  0,  0},   // 7533
    {  2,3767,  0,  0,  0,  0},   // 7534
    {  5, 11,137,  0,  0,  0},   // 7535
    {  2,  3,157,  0,  0,  0},   // 7536
    {  0,  0,  0,  0,  0,  0},   // 7537
    {  2,3769,  0,  0,  0,  0},   // 7538
    {  3,  7,359,  0,  0,  0},   // 7539
    {  2,  5, 13, 29,  0,  0},   // 7540
    {  0,  0,  0,  0,  0,  0},   // 7541
    {  2,  3,419,  0,  0,  0},   // 7542
    { 19,397,  0,  0,  0,  0},   // 7543
    {  2, 23, 41,  0,  0,  0},   // 7544
    {  3,  5,503,  0,  0,  0},   // 7545
    {  2,  7, 11,  0,  0,  0},   // 7546
    {  0,  0,  0,  0,  0,  0},   // 7547
    {  2,  3, 17, 37,  0,  0},   // 7548
    {  0,  0,  0,  0,  0,  0},   // 7549
    {  2,  5,151,  0,  0,  0},   // 7550
    {  3,839,  0,  0,  0,  0},   // 7551
    {  2, 59,  0,  0,  0,  0},   // 7552
    {  7, 13, 83,  0,  0,  0},   // 7553
    {  2,  3,1259,  0,  0,  0},   // 7554
    {  5,1511,  0,  0,  0,  0},   // 7555
    {  2,1889,  0,  0,  0,  0},   // 7556
    {  3, 11,229,  0,  0,  0},   // 7557
    {  2,3779,  0,  0,  0,  0},   // 7558
    {  0,  0,  0,  0,  0,  0},   // 7559
    {  2,  3,  5,  7,  0,  0},   // 7560
    {  0,  0,  0,  0,  0,  0},   // 7561
    {  2, 19,199,  0,  0,  0},   // 7562
    {  3,2521,  0,  0,  0,  0},   // 7563
    {  2, 31, 61,  0,  0,  0},   // 7564
    {  5, 17, 89,  0,  0,  0},   // 7565
    {  2,  3, 13, 97,  0,  0},   // 7566
    {  7, 23, 47,  0,  0,  0},   // 7567
    {  2, 11, 43,  0,  0,  0},   // 7568
    {  3, 29,  0,  0,  0,  0},   // 7569
    {  2,  5,757,  0,  0,  0},   // 7570
    { 67,113,  0,  0,  0,  0},   // 7571
    {  2,  3,631,  0,  0,  0},   // 7572
    {  0,  0,  0,  0,  0,  0},   // 7573
    {  2,  7,541,  0,  0,  0},   // 7574
    {  3,  5,101,  0,  0,  0},   // 7575
    {  2,947,  0,  0,  0,  0},   // 7576
    {  0,  0,  0,  0,  0,  0},   // 7577
    {  2,  3,421,  0,  0,  0},   // 7578
    { 11, 13, 53,  0,  0,  0},   // 7579
    {  2,  5,379,  0,  0,  0},   // 7580
    {  3,  7, 19,  0,  0,  0},   // 7581
    {  2, 17,223,  0,  0,  0},   // 7582
    {  0,  0,  0,  0,  0,  0},   // 7583
    {  2,  3, 79,  0,  0,  0},   // 7584
    {  5, 37, 41,  0,  0,  0},   // 7585
    {  2,3793,  0,  0,  0,  0},   // 7586
    {  3,281,  0,  0,  0,  0},   // 7587
    {  2,  7,271,  0,  0,  0},   // 7588
    {  0,  0,  0,  0,  0,  0},   // 7589
    {  2,  3,  5, 11, 23,  0},   // 7590
    {  0,  0,  0,  0,  0,  0},   // 7591
    {  2, 13, 73,  0,  0,  0},   // 7592
    {  3,2531,  0,  0,  0,  0},   // 7593
    {  2,3797,  0,  0,  0,  0},   // 7594
    {  5,  7, 31,  0,  0,  0},   // 7595
    {  2,  3,211,  0,  0,  0},   // 7596
    { 71,107,  0,  0,  0,  0},   // 7597
    {  2, 29,131,  0,  0,  0},   // 7598
    {  3, 17,149,  0,  0,  0},   // 7599
    {  2,  5, 19,  0,  0,  0},   // 7600
    { 11,691,  0,  0,  0,  0},   // 7601
    {  2,  3,  7,181,  0,  0},   // 7602
    {  0,  0,  0,  0,  0,  0},   // 7603
    {  2,1901,  0,  0,  0,  0},   // 7604
    {  3,  5, 13,  0,  0,  0},   // 7605
    {  2,3803,  0,  0,  0,  0},   // 7606
    {  0,  0,  0,  0,  0,  0},   // 7607
    {  2,  3,317,  0,  0,  0},   // 7608
    {  7,1087,  0,  0,  0,  0},   // 7609
    {  2,  5,761,  0,  0,  0},   // 7610
    {  3, 43, 59,  0,  0,  0},   // 7611
    {  2, 11,173,  0,  0,  0},   // 7612
    { 23,331,  0,  0,  0,  0},   // 7613
    {  2,  3, 47,  0,  0,  0},   // 7614
    {  5,1523,  0,  0,  0,  0},   // 7615
    {  2,  7, 17,  0,  0,  0},   // 7616
    {  3,2539,  0,  0,  0,  0},   // 7617
    {  2, 13,293,  0,  0,  0},   // 7618
    { 19,401,  0,  0,  0,  0},   // 7619
    {  2,  3,  5,127,  0,  0},   // 7620
    {  0,  0,  0,  0,  0,  0},   // 7621
    {  2, 37,103,  0,  0,  0},   // 7622
    {  3,  7, 11,  0,  0,  0},   // 7623
    {  2,953,  0,  0,  0,  0},   // 7624
    {  5, 61,  0,  0,  0,  0},   // 7625
    {  2,  3, 31, 41,  0,  0},   // 7626
    { 29,263,  0,  0,  0,  0},   // 7627
    {  2,1907,  0,  0,  0,  0},   // 7628
    {  3,2543,  0,  0,  0,  0},   // 7629
    {  2,  5,  7,109,  0,  0},   // 7630
    { 13,587,  0,  0,  0,  0},   // 7631
    {  2,  3, 53,  0,  0,  0},   // 7632
    { 17,449,  0,  0,  0,  0},   // 7633
    {  2, 11,347,  0,  0,  0},   // 7634
    {  3,  5,509,  0,  0,  0},   // 7635
    {  2, 23, 83,  0,  0,  0},   // 7636
    {  7,1091,  0,  0,  0,  0},   // 7637
    {  2,  3, 19, 67,  0,  0},   // 7638
    {  0,  0,  0,  0,  0,  0},   // 7639
    {  2,  5,191,  0,  0,  0},   // 7640
    {  3,283,  0,  0,  0,  0},   // 7641
    {  2,3821,  0,  0,  0,  0},   // 7642
    {  0,  0,  0,  0,  0,  0},   // 7643
    {  2,  3,  7, 13,  0,  0},   // 7644
    {  5, 11,139,  0,  0,  0},   // 7645
    {  2,3823,  0,  0,  0,  0},   // 7646
    {  3,2549,  0,  0,  0,  0},   // 7647
    {  2,239,  0,  0,  0,  0},   // 7648
    {  0,  0,  0,  0,  0,  0},   // 7649
    {  2,  3,  5, 17,  0,  0},   // 7650
    {  7,1093,  0,  0,  0,  0},   // 7651
    {  2,1913,  0,  0,  0,  0},   // 7652
    {  3,2551,  0,  0,  0,  0},   // 7653
    {  2, 43, 89,  0,  0,  0},   // 7654
    {  5,1531,  0,  0,  0,  0},   // 7655
    {  2,  3, 11, 29,  0,  0},   // 7656
    { 13, 19, 31,  0,  0,  0},   // 7657
    {  2,  7,547,  0,  0,  0},   // 7658
    {  3, 23, 37,  0,  0,  0},   // 7659
    {  2,  5,383,  0,  0,  0},   // 7660
    { 47,163,  0,  0,  0,  0},   // 7661
    {  2,  3,1277,  0,  0,  0},   // 7662
    { 79, 97,  0,  0,  0,  0},   // 7663
    {  2,479,  0,  0,  0,  0},   // 7664
    {  3,  5,  7, 73,  0,  0},   // 7665
    {  2,3833,  0,  0,  0,  0},   // 7666
    { 11, 17, 41,  0,  0,  0},   // 7667
    {  2,  3, 71,  0,  0,  0},   // 7668
    {  0,  0,  0,  0,  0,  0},   // 7669
    {  2,  5, 13, 59,  0,  0},   // 7670
    {  3,2557,  0,  0,  0,  0},   // 7671
    {  2,  7,137,  0,  0,  0},   // 7672
    {  0,  0,  0,  0,  0,  0},   // 7673
    {  2,  3,1279,  0,  0,  0},   // 7674
    {  5,307,  0,  0,  0,  0},   // 7675
    {  2, 19,101,  0,  0,  0},   // 7676
    {  3,853,  0,  0,  0,  0},   // 7677
    {  2, 11,349,  0,  0,  0},   // 7678
    {  7,1097,  0,  0,  0,  0},   // 7679
    {  2,  3,  5,  0,  0,  0},   // 7680
    {  0,  0,  0,  0,  0,  0},   // 7681
    {  2, 23,167,  0,  0,  0},   // 7682
    {  3, 13,197,  0,  0,  0},   // 7683
    {  2, 17,113,  0,  0,  0},   // 7684
    {  5, 29, 53,  0,  0,  0},   // 7685
    {  2,  3,  7, 61,  0,  0},   // 7686
    {  0,  0,  0,  0,  0,  0},   // 7687
    {  2, 31,  0,  0,  0,  0},   // 7688
    {  3, 11,233,  0,  0,  0},   // 7689
    {  2,  5,769,  0,  0,  0},   // 7690
    {  0,  0,  0,  0,  0,  0},   // 7691
    {  2,  3,641,  0,  0,  0},   // 7692
    {  7,157,  0,  0,  0,  0},   // 7693
    {  2,3847,  0,  0,  0,  0},   // 7694
    {  3,  5, 19,  0,  0,  0},   // 7695
    {  2, 13, 37,  0,  0,  0},   // 7696
    { 43,179,  0,  0,  0,  0},   // 7697
    {  2,  3,1283,  0,  0,  0},   // 7698
    {  0,  0,  0,  0,  0,  0},   // 7699
    {  2,  5,  7, 11,  0,  0},   // 7700
    {  3, 17,151,  0,  0,  0},   // 7701
    {  2,3851,  0,  0,  0,  0},   // 7702
    {  0,  0,  0,  0,  0,  0},   // 7703
    {  2,  3,107,  0,  0,  0},   // 7704
    {  5, 23, 67,  0,  0,  0},   // 7705
    {  2,3853,  0,  0,  0,  0},   // 7706
    {  3,  7,367,  0,  0,  0},   // 7707
    {  2, 41, 47,  0,  0,  0},   // 7708
    { 13,593,  0,  0,  0,  0},   // 7709
    {  2,  3,  5,257,  0,  0},   // 7710
    { 11,701,  0,  0,  0,  0},   // 7711
    {  2,241,  0,  0,  0,  0},   // 7712
    {  3,857,  0,  0,  0,  0},   // 7713
    {  2,  7, 19, 29,  0,  0},   // 7714
    {  5,1543,  0,  0,  0,  0},   // 7715
    {  2,  3,643,  0,  0,  0},   // 7716
    {  0,  0,  0,  0,  0,  0},   // 7717
    {  2, 17,227,  0,  0,  0},   // 7718
    {  3, 31, 83,  0,  0,  0},   // 7719
    {  2,  5,193,  0,  0,  0},   // 7720
    {  7,1103,  0,  0,  0,  0},   // 7721
    {  2,  3, 11, 13,  0,  0},   // 7722
    {  0,  0,  0,  0,  0,  0},   // 7723
    {  2,1931,  0,  0,  0,  0},   // 7724
    {  3,  5,103,  0,  0,  0},   // 7725
    {  2,3863,  0,  0,  0,  0},   // 7726
    {  0,  0,  0,  0,  0,  0},   // 7727
    {  2,  3,  7, 23,  0,  0},   // 7728
    { 59,131,  0,  0,  0,  0},   // 7729
    {  2,  5,773,  0,  0,  0},   // 7730
    {  3,859,  0,  0,  0,  0},   // 7731
    {  2,1933,  0,  0,  0,  0},   // 7732
    { 11, 19, 37,  0,  0,  0},   // 7733
    {  2,  3,1289,  0,  0,  0},   // 7734
    {  5,  7, 13, 17,  0,  0},   // 7735
    {  2,967,  0,  0,  0,  0},   // 7736
    {  3,2579,  0,  0,  0,  0},   // 7737
    {  2, 53, 73,  0,  0,  0},   // 7738
    { 71,109,  0,  0,  0,  0},   // 7739
    {  2,  3,  5, 43,  0,  0},   // 7740
    {  0,  0,  0,  0,  0,  0},   // 7741
    {  2,  7, 79,  0,  0,  0},   // 7742
    {  3, 29, 89,  0,  0,  0},   // 7743
    {  2, 11,  0,  0,  0,  0},   // 7744
    {  5,1549,  0,  0,  0,  0},   // 7745
    {  2,  3,1291,  0,  0,  0},   // 7746
    { 61,127,  0,  0,  0,  0},   // 7747
    {  2, 13,149,  0,  0,  0},   // 7748
    {  3,  7, 41,  0,  0,  0},   // 7749
    {  2,  5, 31,  0,  0,  0},   // 7750
    { 23,337,  0,  0,  0,  0},   // 7751
    {  2,  3, 17, 19,  0,  0},   // 7752
    {  0,  0,  0,  0,  0,  0},   // 7753
    {  2,3877,  0,  0,  0,  0},   // 7754
    {  3,  5, 11, 47,  0,  0},   // 7755
    {  2,  7,277,  0,  0,  0},   // 7756
    {  0,  0,  0,  0,  0,  0},   // 7757
    {  2,  3,431,  0,  0,  0},   // 7758
    {  0,  0,  0,  0,  0,  0},   // 7759
    {  2,  5, 97,  0,  0,  0},   // 7760
    {  3, 13,199,  0,  0,  0},   // 7761
    {  2,3881,  0,  0,  0,  0},   // 7762
    {  7,1109,  0,  0,  0,  0},   // 7763
    {  2,  3,647,  0,  0,  0},   // 7764
    {  5,1553,  0,  0,  0,  0},   // 7765
    {  2, 11,353,  0,  0,  0},   // 7766
    {  3,863,  0,  0,  0,  0},   // 7767
    {  2,971,  0,  0,  0,  0},   // 7768
    { 17,457,  0,  0,  0,  0},   // 7769
    {  2,  3,  5,  7, 37,  0},   // 7770
    { 19,409,  0,  0,  0,  0},   // 7771
    {  2, 29, 67,  0,  0,  0},   // 7772
    {  3,2591,  0,  0,  0,  0},   // 7773
    {  2, 13, 23,  0,  0,  0},   // 7774
    {  5,311,  0,  0,  0,  0},   // 7775
    {  2,  3,  0,  0,  0,  0},   // 7776
    {  7, 11,101,  0,  0,  0},   // 7777
    {  2,3889,  0,  0,  0,  0},   // 7778
    {  3,2593,  0,  0,  0,  0},   // 7779
    {  2,  5,389,  0,  0,  0},   // 7780
    { 31,251,  0,  0,  0,  0},   // 7781
    {  2,  3,1297,  0,  0,  0},   // 7782
    { 43,181,  0,  0,  0,  0},   // 7783
    {  2,  7,139,  0,  0,  0},   // 7784
    {  3,  5,173,  0,  0,  0},   // 7785
    {  2, 17,229,  0,  0,  0},   // 7786
    { 13,599,  0,  0,  0,  0},   // 7787
    {  2,  3, 11, 59,  0,  0},   // 7788
    {  0,  0,  0,  0,  0,  0},   // 7789
    {  2,  5, 19, 41,  0,  0},   // 7790
    {  3,  7, 53,  0,  0,  0},   // 7791
    {  2,487,  0,  0,  0,  0},   // 7792
    {  0,  0,  0,  0,  0,  0},   // 7793
    {  2,  3,433,  0,  0,  0},   // 7794
    {  5,1559,  0,  0,  0,  0},   // 7795
    {  2,1949,  0,  0,  0,  0},   // 7796
    {  3, 23,113,  0,  0,  0},   // 7797
    {  2,  7,557,  0,  0,  0},   // 7798
    { 11,709,  0,  0,  0,  0},   // 7799
    {  2,  3,  5, 13,  0,  0},   // 7800
    { 29,269,  0,  0,  0,  0},   // 7801
    {  2, 47, 83,  0,  0,  0},   // 7802
    {  3, 17,  0,  0,  0,  0},   // 7803
    {  2,1951,  0,  0,  0,  0},   // 7804
    {  5,  7,223,  0,  0,  0},   // 7805
    {  2,  3,1301,  0,  0,  0},   // 7806
    { 37,211,  0,  0,  0,  0},   // 7807
    {  2, 61,  0,  0,  0,  0},   // 7808
    {  3, 19,137,  0,  0,  0},   // 7809
    {  2,  5, 11, 71,  0,  0},   // 7810
    { 73,107,  0,  0,  0,  0},   // 7811
    {  2,  3,  7, 31,  0,  0},   // 7812
    { 13,601,  0,  0,  0,  0},   // 7813
    {  2,3907,  0,  0,  0,  0},   // 7814
    {  3,  5,521,  0,  0,  0},   // 7815
    {  2,977,  0,  0,  0,  0},   // 7816
    {  0,  0,  0,  0,  0,  0},   // 7817
    {  2,  3,1303,  0,  0,  0},   // 7818
    {  7,1117,  0,  0,  0,  0},   // 7819
    {  2,  5, 17, 23,  0,  0},   // 7820
    {  3, 11, 79,  0,  0,  0},   // 7821
    {  2,3911,  0,  0,  0,  0},   // 7822
    {  0,  0,  0,  0,  0,  0},   // 7823
    {  2,  3,163,  0,  0,  0},   // 7824
    {  5,313,  0,  0,  0,  0},   // 7825
    {  2,  7, 13, 43,  0,  0},   // 7826
    {  3,2609,  0,  0,  0,  0},   // 7827
    {  2, 19,103,  0,  0,  0},   // 7828
    {  0,  0,  0,  0,  0,  0},   // 7829
    {  2,  3,  5, 29,  0,  0},   // 7830
    { 41,191,  0,  0,  0,  0},   // 7831
    {  2, 11, 89,  0,  0,  0},   // 7832
    {  3,  7,373,  0,  0,  0},   // 7833
    {  2,3917,  0,  0,  0,  0},   // 7834
    {  5,1567,  0,  0,  0,  0},   // 7835
    {  2,  3,653,  0,  0,  0},   // 7836
    { 17,461,  0,  0,  0,  0},   // 7837
    {  2,3919,  0,  0,  0,  0},   // 7838
    {  3, 13, 67,  0,  0,  0},   // 7839
    {  2,  5,  7,  0,  0,  0},   // 7840
    {  0,  0,  0,  0,  0,  0},   // 7841
    {  2,  3,1307,  0,  0,  0},   // 7842
    { 11, 23, 31,  0,  0,  0},   // 7843
    {  2, 37, 53,  0,  0,  0},   // 7844
    {  3,  5,523,  0,  0,  0},   // 7845
    {  2,3923,  0,  0,  0,  0},   // 7846
    {  7, 19, 59,  0,  0,  0},   // 7847
    {  2,  3,109,  0,  0,  0},   // 7848
    { 47,167,  0,  0,  0,  0},   // 7849
    {  2,  5,157,  0,  0,  0},   // 7850
    {  3,2617,  0,  0,  0,  0},   // 7851
    {  2, 13,151,  0,  0,  0},   // 7852
    {  0,  0,  0,  0,  0,  0},   // 7853
    {  2,  3,  7, 11, 17,  0},   // 7854
    {  5,1571,  0,  0,  0,  0},   // 7855
    {  2,491,  0,  0,  0,  0},   // 7856
    {  3, 97,  0,  0,  0,  0},   // 7857
    {  2,3929,  0,  0,  0,  0},   // 7858
    { 29,271,  0,  0,  0,  0},   // 7859
    {  2,  3,  5,131,  0,  0},   // 7860
    {  7,1123,  0,  0,  0,  0},   // 7861
    {  2,3931,  0,  0,  0,  0},   // 7862
    {  3,2621,  0,  0,  0,  0},   // 7863
    {  2,983,  0,  0,  0,  0},   // 7864
    {  5, 11, 13,  0,  0,  0},   // 7865
    {  2,  3, 19, 23,  0,  0},   // 7866
    {  0,  0,  0,  0,  0,  0},   // 7867
    {  2,  7,281,  0,  0,  0},   // 7868
    {  3, 43, 61,  0,  0,  0},   // 7869
    {  2,  5,787,  0,  0,  0},   // 7870
    { 17,463,  0,  0,  0,  0},   // 7871
    {  2,  3, 41,  0,  0,  0},   // 7872
    {  0,  0,  0,  0,  0,  0},   // 7873
    {  2, 31,127,  0,  0,  0},   // 7874
    {  3,  5,  7,  0,  0,  0},   // 7875
    {  2, 11,179,  0,  0,  0},   // 7876
    {  0,  0,  0,  0,  0,  0},   // 7877
    {  2,  3, 13,101,  0,  0},   // 7878
    {  0,  0,  0,  0,  0,  0},   // 7879
    {  2,  5,197,  0,  0,  0},   // 7880
    {  3, 37, 71,  0,  0,  0},   // 7881
    {  2,  7,563,  0,  0,  0},   // 7882
    {  0,  0,  0,  0,  0,  0},   // 7883
    {  2,  3, 73,  0,  0,  0},   // 7884
    {  5, 19, 83,  0,  0,  0},   // 7885
    {  2,3943,  0,  0,  0,  0},   // 7886
    {  3, 11,239,  0,  0,  0},   // 7887
    {  2, 17, 29,  0,  0,  0},   // 7888
    {  7, 23,  0,  0,  0,  0},   // 7889
    {  2,  3,  5,263,  0,  0},   // 7890
    { 13,607,  0,  0,  0,  0},   // 7891
    {  2,1973,  0,  0,  0,  0},   // 7892
    {  3,877,  0,  0,  0,  0},   // 7893
    {  2,3947,  0,  0,  0,  0},   // 7894
    {  5,1579,  0,  0,  0,  0},   // 7895
    {  2,  3,  7, 47,  0,  0},   // 7896
    { 53,149,  0,  0,  0,  0},   // 7897
    {  2, 11,359,  0,  0,  0},   // 7898
    {  3,2633,  0,  0,  0,  0},   // 7899
    {  2,  5, 79,  0,  0,  0},   // 7900
    {  0,  0,  0,  0,  0,  0},   // 7901
    {  2,  3,439,  0,  0,  0},   // 7902
    {  7,1129,  0,  0,  0,  0},   // 7903
    {  2, 13, 19,  0,  0,  0},   // 7904
    {  3,  5, 17, 31,  0,  0},   // 7905
    {  2, 59, 67,  0,  0,  0},   // 7906
    {  0,  0,  0,  0,  0,  0},   // 7907
    {  2,  3,659,  0,  0,  0},   // 7908
    { 11,719,  0,  0,  0,  0},   // 7909
    {  2,  5,  7,113,  0,  0},   // 7910
    {  3,293,  0,  0,  0,  0},   // 7911
    {  2, 23, 43,  0,  0,  0},   // 7912
    { 41,193,  0,  0,  0,  0},   // 7913
    {  2,  3,1319,  0,  0,  0},   // 7914
    {  5,1583,  0,  0,  0,  0},   // 7915
    {  2,1979,  0,  0,  0,  0},   // 7916
    {  3,  7, 13, 29,  0,  0},   // 7917
    {  2, 37,107,  0,  0,  0},   // 7918
    {  0,  0,  0,  0,  0,  0},   // 7919
    {  2,  3,  5, 11,  0,  0},   // 7920
    { 89,  0,  0,  0,  0,  0},   // 7921
    {  2, 17,233,  0,  0,  0},   // 7922
    {  3, 19,139,  0,  0,  0},   // 7923
    {  2,  7,283,  0,  0,  0},   // 7924
    {  5,317,  0,  0,  0,  0},   // 7925
    {  2,  3,1321,  0,  0,  0},   // 7926
    {  0,  0,  0,  0,  0,  0},   // 7927
    {  2,991,  0,  0,  0,  0},   // 7928
    {  3,881,  0,  0,  0,  0},   // 7929
    {  2,  5, 13, 61,  0,  0},   // 7930
    {  7, 11,103,  0,  0,  0},   // 7931
    {  2,  3,661,  0,  0,  0},   // 7932
    {  0,  0,  0,  0,  0,  0},   // 7933
    {  2,3967,  0,  0,  0,  0},   // 7934
    {  3,  5, 23,  0,  0,  0},   // 7935
    {  2, 31,  0,  0,  0,  0},   // 7936
    {  0,  0,  0,  0,  0,  0},   // 7937
    {  2,  3,  7,  0,  0,  0},   // 7938
    { 17,467,  0,  0,  0,  0},   // 7939
    {  2,  5,397,  0,  0,  0},   // 7940
    {  3,2647,  0,  0,  0,  0},   // 7941
    {  2, 11, 19,  0,  0,  0},   // 7942
    { 13, 47,  0,  0,  0,  0},   // 7943
    {  2,  3,331,  0,  0,  0},   // 7944
    {  5,  7,227,  0,  0,  0},   // 7945
    {  2, 29,137,  0,  0,  0},   // 7946
    {  3,883,  0,  0,  0,  0},   // 7947
    {  2,1987,  0,  0,  0,  0},   // 7948
    {  0,  0,  0,  0,  0,  0},   // 7949
    {  2,  3,  5, 53,  0,  0},   // 7950
    {  0,  0,  0,  0,  0,  0},   // 7951
    {  2,  7, 71,  0,  0,  0},   // 7952
    {  3, 11,241,  0,  0,  0},   // 7953
    {  2, 41, 97,  0,  0,  0},   // 7954
    {  5, 37, 43,  0,  0,  0},   // 7955
    {  2,  3, 13, 17,  0,  0},   // 7956
    { 73,109,  0,  0,  0,  0},   // 7957
    {  2, 23,173,  0,  0,  0},   // 7958
    {  3,  7,379,  0,  0,  0},   // 7959
    {  2,  5,199,  0,  0,  0},   // 7960
    { 19,419,  0,  0,  0,  0},   // 7961
    {  2,  3,1327,  0,  0,  0},   // 7962
    {  0,  0,  0,  0,  0,  0},   // 7963
    {  2, 11,181,  0,  0,  0},   // 7964
    {  3,  5, 59,  0,  0,  0},   // 7965
    {  2,  7,569,  0,  0,  0},   // 7966
    { 31,257,  0,  0,  0,  0},   // 7967
    {  2,  3, 83,  0,  0,  0},   // 7968
    { 13,613,  0,  0,  0,  0},   // 7969
    {  2,  5,797,  0,  0,  0},   // 7970
    {  3,2657,  0,  0,  0,  0},   // 7971
    {  2,1993,  0,  0,  0,  0},   // 7972
    {  7, 17, 67,  0,  0,  0},   // 7973
    {  2,  3,443,  0,  0,  0},   // 7974
    {  5, 11, 29,  0,  0,  0},   // 7975
    {  2,997,  0,  0,  0,  0},   // 7976
    {  3,2659,  0,  0,  0,  0},   // 7977
    {  2,3989,  0,  0,  0,  0},   // 7978
    { 79,101,  0,  0,  0,  0},   // 7979
    {  2,  3,  5,  7, 19,  0},   // 7980
    { 23,347,  0,  0,  0,  0},   // 7981
    {  2, 13,307,  0,  0,  0},   // 7982
    {  3,887,  0,  0,  0,  0},   // 7983
    {  2,499,  0,  0,  0,  0},   // 7984
    {  5,1597,  0,  0,  0,  0},   // 7985
    {  2,  3, 11,  0,  0,  0},   // 7986
    {  7,163,  0,  0,  0,  0},   // 7987
    {  2,1997,  0,  0,  0,  0},   // 7988
    {  3,2663,  0,  0,  0,  0},   // 7989
    {  2,  5, 17, 47,  0,  0},   // 7990
    { 61,131,  0,  0,  0,  0},   // 7991
    {  2,  3, 37,  0,  0,  0},   // 7992
    {  0,  0,  0,  0,  0,  0},   // 7993
    {  2,  7,571,  0,  0,  0},   // 7994
    {  3,  5, 13, 41,  0,  0},   // 7995
    {  2,1999,  0,  0,  0,  0},   // 7996
    { 11,727,  0,  0,  0,  0},   // 7997
    {  2,  3, 31, 43,  0,  0},   // 7998
    { 19,421,  0,  0,  0,  0},   // 7999
    {  2,  5,  0,  0,  0,  0},   // 8000
    {  3,  7,127,  0,  0,  0},   // 8001
    {  2,4001,  0,  0,  0,  0},   // 8002
    { 53,151,  0,  0,  0,  0},   // 8003
    {  2,  3, 23, 29,  0,  0},   // 8004
    {  5,1601,  0,  0,  0,  0},   // 8005
    {  2,4003,  0,  0,  0,  0},   // 8006
    {  3, 17,157,  0,  0,  0},   // 8007
    {  2,  7, 11, 13,  0,  0},   // 8008
    {  0,  0,  0,  0,  0,  0},   // 8009
    {  2,  3,  5, 89,  0,  0},   // 8010
    {  0,  0,  0,  0,  0,  0},   // 8011
    {  2,2003,  0,  0,  0,  0},   // 8012
    {  3,2671,  0,  0,  0,  0},   // 8013
    {  2,4007,  0,  0,  0,  0},   // 8014
    {  5,  7,229,  0,  0,  0},   // 8015
    {  2,  3,167,  0,  0,  0},   // 8016
    {  0,  0,  0,  0,  0,  0},   // 8017
    {  2, 19,211,  0,  0,  0},   // 8018
    {  3, 11,  0,  0,  0,  0},   // 8019
    {  2,  5,401,  0,  0,  0},   // 8020
    { 13,617,  0,  0,  0,  0},   // 8021
    {  2,  3,  7,191,  0,  0},   // 8022
    { 71,113,  0,  0,  0,  0},   // 8023
    {  2, 17, 59,  0,  0,  0},   // 8024
    {  3,  5,107,  0,  0,  0},   // 8025
    {  2,4013,  0,  0,  0,  0},   // 8026
    { 23,349,  0,  0,  0,  0},   // 8027
    {  2,  3,223,  0,  0,  0},   // 8028
    {  7, 31, 37,  0,  0,  0},   // 8029
    {  2,  5, 11, 73,  0,  0},   // 8030
    {  3,2677,  0,  0,  0,  0},   // 8031
    {  2,251,  0,  0,  0,  0},   // 8032
    { 29,277,  0,  0,  0,  0},   // 8033
    {  2,  3, 13,103,  0,  0},   // 8034
    {  5,1607,  0,  0,  0,  0},   // 8035
    {  2,  7, 41,  0,  0,  0},   // 8036
    {  3, 19, 47,  0,  0,  0},   // 8037
    {  2,4019,  0,  0,  0,  0},   // 8038
    {  0,  0,  0,  0,  0,  0},   // 8039
    {  2,  3,  5, 67,  0,  0},   // 8040
    { 11, 17, 43,  0,  0,  0},   // 8041
    {  2,4021,  0,  0,  0,  0},   // 8042
    {  3,  7,383,  0,  0,  0},   // 8043
    {  2,2011,  0,  0,  0,  0},   // 8044
    {  5,1609,  0,  0,  0,  0},   // 8045
    {  2,  3,149,  0,  0,  0},   // 8046
    { 13,619,  0,  0,  0,  0},   // 8047
    {  2,503,  0,  0,  0,  0},   // 8048
    {  3,2683,  0,  0,  0,  0},   // 8049
    {  2,  5,  7, 23,  0,  0},   // 8050
    { 83, 97,  0,  0,  0,  0},   // 8051
    {  2,  3, 11, 61,  0,  0},   // 8052
    {  0,  0,  0,  0,  0,  0},   // 8053
    {  2,4027,  0,  0,  0,  0},   // 8054
    {  3,  5,179,  0,  0,  0},   // 8055
    {  2, 19, 53,  0,  0,  0},   // 8056
    {  7,1151,  0,  0,  0,  0},   // 8057
    {  2,  3, 17, 79,  0,  0},   // 8058
    {  0,  0,  0,  0,  0,  0},   // 8059
    {  2,  5, 13, 31,  0,  0},   // 8060
    {  3,2687,  0,  0,  0,  0},   // 8061
    {  2, 29,139,  0,  0,  0},   // 8062
    { 11,733,  0,  0,  0,  0},   // 8063
    {  2,  3,  7,  0,  0,  0},   // 8064
    {  5,1613,  0,  0,  0,  0},   // 8065
    {  2, 37,109,  0,  0,  0},   // 8066
    {  3,2689,  0,  0,  0,  0},   // 8067
    {  2,2017,  0,  0,  0,  0},   // 8068
    {  0,  0,  0,  0,  0,  0},   // 8069
    {  2,  3,  5,269,  0,  0},   // 8070
    {  7,1153,  0,  0,  0,  0},   // 8071
    {  2,1009,  0,  0,  0,  0},   // 8072
    {  3, 13, 23,  0,  0,  0},   // 8073
    {  2, 11,367,  0,  0,  0},   // 8074
    {  5, 17, 19,  0,  0,  0},   // 8075
    {  2,  3,673,  0,  0,  0},   // 8076
    { 41,197,  0,  0,  0,  0},   // 8077
    {  2,  7,577,  0,  0,  0},   // 8078
    {  3,2693,  0,  0,  0,  0},   // 8079
    {  2,  5,101,  0,  0,  0},   // 8080
    {  0,  0,  0,  0,  0,  0},   // 8081
    {  2,  3,449,  0,  0,  0},   // 8082
    { 59,137,  0,  0,  0,  0},   // 8083
    {  2, 43, 47,  0,  0,  0},   // 8084
    {  3,  5,  7, 11,  0,  0},   // 8085
    {  2, 13,311,  0,  0,  0},   // 8086
    {  0,  0,  0,  0,  0,  0},   // 8087
    {  2,  3,337,  0,  0,  0},   // 8088
    {  0,  0,  0,  0,  0,  0},   // 8089
    {  2,  5,809,  0,  0,  0},   // 8090
    {  3, 29, 31,  0,  0,  0},   // 8091
    {  2,  7, 17,  0,  0,  0},   // 8092
    {  0,  0,  0,  0,  0,  0},   // 8093
    {  2,  3, 19, 71,  0,  0},   // 8094
    {  5,1619,  0,  0,  0,  0},   // 8095
    {  2, 11, 23,  0,  0,  0},   // 8096
    {  3,2699,  0,  0,  0,  0},   // 8097
    {  2,4049,  0,  0,  0,  0},   // 8098
    {  7, 13, 89,  0,  0,  0},   // 8099
    {  2,  3,  5,  0,  0,  0},   // 8100
    {  0,  0,  0,  0,  0,  0},   // 8101
    {  2,4051,  0,  0,  0,  0},   // 8102
    {  3, 37, 73,  0,  0,  0},   // 8103
    {  2,1013,  0,  0,  0,  0},   // 8104
    {  5,1621,  0,  0,  0,  0},   // 8105
    {  2,  3,  7,193,  0,  0},   // 8106
    { 11, 67,  0,  0,  0,  0},   // 8107
    {  2,2027,  0,  0,  0,  0},   // 8108
    {  3, 17, 53,  0,  0,  0},   // 8109
    {  2,  5,811,  0,  0,  0},   // 8110
    {  0,  0,  0,  0,  0,  0},   // 8111
    {  2,  3, 13,  0,  0,  0},   // 8112
    {  7, 19, 61,  0,  0,  0},   // 8113
    {  2,4057,  0,  0,  0,  0},   // 8114
    {  3,  5,541,  0,  0,  0},   // 8115
    {  2,2029,  0,  0,  0,  0},   // 8116
    {  0,  0,  0,  0,  0,  0},   // 8117
    {  2,  3, 11, 41,  0,  0},   // 8118
    { 23,353,  0,  0,  0,  0},   // 8119
    {  2,  5,  7, 29,  0,  0},   // 8120
    {  3,2707,  0,  0,  0,  0},   // 8121
    {  2, 31,131,  0,  0,  0},   // 8122
    {  0,  0,  0,  0,  0,  0},   // 8123
    {  2,  3,677,  0,  0,  0},   // 8124
    {  5, 13,  0,  0,  0,  0},   // 8125
    {  2, 17,239,  0,  0,  0},   // 8126
    {  3,  7, 43,  0,  0,  0},   // 8127
    {  2,127,  0,  0,  0,  0},   // 8128
    { 11,739,  0,  0,  0,  0},   // 8129
    {  2,  3,  5,271,  0,  0},   // 8130
    { 47,173,  0,  0,  0,  0},   // 8131
    {  2, 19,107,  0,  0,  0},   // 8132
    {  3,2711,  0,  0,  0,  0},   // 8133
    {  2,  7, 83,  0,  0,  0},   // 8134
    {  5,1627,  0,  0,  0,  0},   // 8135
    {  2,  3,113,  0,  0,  0},   // 8136
    { 79,103,  0,  0,  0,  0},   // 8137
    {  2, 13,313,  0,  0,  0},   // 8138
    {  3,2713,  0,  0,  0,  0},   // 8139
    {  2,  5, 11, 37,  0,  0},   // 8140
    {  7,1163,  0,  0,  0,  0},   // 8141
    {  2,  3, 23, 59,  0,  0},   // 8142
    { 17,479,  0,  0,  0,  0},   // 8143
    {  2,509,  0,  0,  0,  0},   // 8144
    {  3,  5,181,  0,  0,  0},   // 8145
    {  2,4073,  0,  0,  0,  0},   // 8146
    {  0,  0,  0,  0,  0,  0},   // 8147
    {  2,  3,  7, 97,  0,  0},   // 8148
    { 29,281,  0,  0,  0,  0},   // 8149
    {  2,  5,163,  0,  0,  0},   // 8150
    {  3, 11, 13, 19,  0,  0},   // 8151
    {  2,1019,  0,  0,  0,  0},   // 8152
    { 31,263,  0,  0,  0,  0},   // 8153
    {  2,  3,151,  0,  0,  0},   // 8154
    {  5,  7,233,  0,  0,  0},   // 8155
    {  2,2039,  0,  0,  0,  0},   // 8156
    {  3,2719,  0,  0,  0,  0},   // 8157
    {  2,4079,  0,  0,  0,  0},   // 8158
    { 41,199,  0,  0,  0,  0},   // 8159
    {  2,  3,  5, 17,  0,  0},   // 8160
    {  0,  0,  0,  0,  0,  0},   // 8161
    {  2,  7, 11, 53,  0,  0},   // 8162
    {  3,907,  0,  0,  0,  0},   // 8163
    {  2, 13,157,  0,  0,  0},   // 8164
    {  5, 23, 71,  0,  0,  0},   // 8165
    {  2,  3,1361,  0,  0,  0},   // 8166
    {  0,  0,  0,  0,  0,  0},   // 8167
    {  2,1021,  0,  0,  0,  0},   // 8168
    {  3,  7,389,  0,  0,  0},   // 8169
    {  2,  5, 19, 43,  0,  0},   // 8170
    {  0,  0,  0,  0,  0,  0},   // 8171
    {  2,  3,227,  0,  0,  0},   // 8172
    { 11,743,  0,  0,  0,  0},   // 8173
    {  2, 61, 67,  0,  0,  0},   // 8174
    {  3,  5,109,  0,  0,  0},   // 8175
    {  2,  7, 73,  0,  0,  0},   // 8176
    { 13, 17, 37,  0,  0,  0},   // 8177
    {  2,  3, 29, 47,  0,  0},   // 8178
    {  0,  0,  0,  0,  0,  0},   // 8179
    {  2,  5,409,  0,  0,  0},   // 8180
    {  3,101,  0,  0,  0,  0},   // 8181
    {  2,4091,  0,  0,  0,  0},   // 8182
    {  7,167,  0,  0,  0,  0},   // 8183
    {  2,  3, 11, 31,  0,  0},   // 8184
    {  5,1637,  0,  0,  0,  0},   // 8185
    {  2,4093,  0,  0,  0,  0},   // 8186
    {  3,2729,  0,  0,  0,  0},   // 8187
    {  2, 23, 89,  0,  0,  0},   // 8188
    { 19,431,  0,  0,  0,  0},   // 8189
    {  2,  3,  5,  7, 13,  0},   // 8190
    {  0,  0,  0,  0,  0,  0},   // 8191
    {  2,  0,  0,  0,  0,  0},   // 8192
    {  3,2731,  0,  0,  0,  0},   // 8193
    {  2, 17,241,  0,  0,  0},   // 8194
    {  5, 11,149,  0,  0,  0},   // 8195
    {  2,  3,683,  0,  0,  0},   // 8196
    {  7,1171,  0,  0,  0,  0},   // 8197
    {  2,4099,  0,  0,  0,  0},   // 8198
    {  3,911,  0,  0,  0,  0},   // 8199
    {  2,  5, 41,  0,  0,  0},   // 8200
    { 59,139,  0,  0,  0,  0},   // 8201
    {  2,  3,1367,  0,  0,  0},   // 8202
    { 13,631,  0,  0,  0,  0},   // 8203
    {  2,  7,293,  0,  0,  0},   // 8204
    {  3,  5,547,  0,  0,  0},   // 8205
    {  2, 11,373,  0,  0,  0},   // 8206
    { 29,283,  0,  0,  0,  0},   // 8207
    {  2,  3, 19,  0,  0,  0},   // 8208
    {  0,  0,  0,  0,  0,  0},   // 8209
    {  2,  5,821,  0,  0,  0},   // 8210
    {  3,  7, 17, 23,  0,  0},   // 8211
    {  2,2053,  0,  0,  0,  0},   // 8212
    { 43,191,  0,  0,  0,  0},   // 8213
    {  2,  3, 37,  0,  0,  0},   // 8214
    {  5, 31, 53,  0,  0,  0},   // 8215
    {  2, 13, 79,  0,  0,  0},   // 8216
    {  3, 11, 83,  0,  0,  0},   // 8217
    {  2,  7,587,  0,  0,  0},   // 8218
    {  0,  0,  0,  0,  0,  0},   // 8219
    {  2,  3,  5,137,  0,  0},   // 8220
    {  0,  0,  0,  0,  0,  0},   // 8221
    {  2,4111,  0,  0,  0,  0},   // 8222
    {  3,2741,  0,  0,  0,  0},   // 8223
    {  2,257,  0,  0,  0,  0},   // 8224
    {  5,  7, 47,  0,  0,  0},   // 8225
    {  2,  3,457,  0,  0,  0},   // 8226
    { 19,433,  0,  0,  0,  0},   // 8227
    {  2, 11, 17,  0,  0,  0},   // 8228
    {  3, 13,211,  0,  0,  0},   // 8229
    {  2,  5,823,  0,  0,  0},   // 8230
    {  0,  0,  0,  0,  0,  0},   // 8231
    {  2,  3,  7,  0,  0,  0},   // 8232
    {  0,  0,  0,  0,  0,  0},   // 8233
    {  2, 23,179,  0,  0,  0},   // 8234
    {  3,  5, 61,  0,  0,  0},   // 8235
    {  2, 29, 71,  0,  0,  0},   // 8236
    {  0,  0,  0,  0,  0,  0},   // 8237
    {  2,  3,1373,  0,  0,  0},   // 8238
    {  7, 11,107,  0,  0,  0},   // 8239
    {  2,  5,103,  0,  0,  0},   // 8240
    {  3, 41, 67,  0,  0,  0},   // 8241
    {  2, 13,317,  0,  0,  0},   // 8242
    {  0,  0,  0,  0,  0,  0},   // 8243
    {  2,  3,229,  0,  0,  0},   // 8244
    {  5, 17, 97,  0,  0,  0},   // 8245
    {  2,  7, 19, 31,  0,  0},   // 8246
    {  3,2749,  0,  0,  0,  0},   // 8247
    {  2,1031,  0,  0,  0,  0},   // 8248
    { 73,113,  0,  0,  0,  0},   // 8249
    {  2,  3,  5, 11,  0,  0},   // 8250
    { 37,223,  0,  0,  0,  0},   // 8251
    {  2,2063,  0,  0,  0,  0},   // 8252
    {  3,  7,131,  0,  0,  0},   // 8253
    {  2,4127,  0,  0,  0,  0},   // 8254
    {  5, 13,127,  0,  0,  0},   // 8255
    {  2,  3, 43,  0,  0,  0},   // 8256
    { 23,359,  0,  0,  0,  0},   // 8257
    {  2,4129,  0,  0,  0,  0},   // 8258
    {  3,2753,  0,  0,  0,  0},   // 8259
    {  2,  5,  7, 59,  0,  0},   // 8260
    { 11,751,  0,  0,  0,  0},   // 8261
    {  2,  3, 17,  0,  0,  0},   // 8262
    {  0,  0,  0,  0,  0,  0},   // 8263
    {  2,1033,  0,  0,  0,  0},   // 8264
    {  3,  5, 19, 29,  0,  0},   // 8265
    {  2,4133,  0,  0,  0,  0},   // 8266
    {  7,1181,  0,  0,  0,  0},   // 8267
    {  2,  3, 13, 53,  0,  0},   // 8268
    {  0,  0,  0,  0,  0,  0},   // 8269
    {  2,  5,827,  0,  0,  0},   // 8270
    {  3,919,  0,  0,  0,  0},   // 8271
    {  2, 11, 47,  0,  0,  0},   // 8272
    {  0,  0,  0,  0,  0,  0},   // 8273
    {  2,  3,  7,197,  0,  0},   // 8274
    {  5,331,  0,  0,  0,  0},   // 8275
    {  2,2069,  0,  0,  0,  0},   // 8276
    {  3, 31, 89,  0,  0,  0},   // 8277
    {  2,4139,  0,  0,  0,  0},   // 8278
    { 17,487,  0,  0,  0,  0},   // 8279
    {  2,  3,  5, 23,  0,  0},   // 8280
    {  7, 13,  0,  0,  0,  0},   // 8281
    {  2, 41,101,  0,  0,  0},   // 8282
    {  3, 11,251,  0,  0,  0},   // 8283
    {  2, 19,109,  0,  0,  0},   // 8284
    {  5,1657,  0,  0,  0,  0},   // 8285
    {  2,  3,1381,  0,  0,  0},   // 8286
    {  0,  0,  0,  0,  0,  0},   // 8287
    {  2,  7, 37,  0,  0,  0},   // 8288
    {  3,307,  0,  0,  0,  0},   // 8289
    {  2,  5,829,  0,  0,  0},   // 8290
    {  0,  0,  0,  0,  0,  0},   // 8291
    {  2,  3,691,  0,  0,  0},   // 8292
    {  0,  0,  0,  0,  0,  0},   // 8293
    {  2, 11, 13, 29,  0,  0},   // 8294
    {  3,  5,  7, 79,  0,  0},   // 8295
    {  2, 17, 61,  0,  0,  0},   // 8296
    {  0,  0,  0,  0,  0,  0},   // 8297
    {  2,  3,461,  0,  0,  0},   // 8298
    { 43,193,  0,  0,  0,  0},   // 8299
    {  2,  5, 83,  0,  0,  0},   // 8300
    {  3,2767,  0,  0,  0,  0},   // 8301
    {  2,  7,593,  0,  0,  0},   // 8302
    { 19, 23,  0,  0,  0,  0},   // 8303
    {  2,  3,173,  0,  0,  0},   // 8304
    {  5, 11,151,  0,  0,  0},   // 8305
    {  2,4153,  0,  0,  0,  0},   // 8306
    {  3, 13, 71,  0,  0,  0},   // 8307
    {  2, 31, 67,  0,  0,  0},   // 8308
    {  7,1187,  0,  0,  0,  0},   // 8309
    {  2,  3,  5,277,  0,  0},   // 8310
    {  0,  0,  0,  0,  0,  0},   // 8311
    {  2,1039,  0,  0,  0,  0},   // 8312
    {  3, 17,163,  0,  0,  0},   // 8313
    {  2,4157,  0,  0,  0,  0},   // 8314
    {  5,1663,  0,  0,  0,  0},   // 8315
    {  2,  3,  7, 11,  0,  0},   // 8316
    {  0,  0,  0,  0,  0,  0},   // 8317
    {  2,4159,  0,  0,  0,  0},   // 8318
    {  3, 47, 59,  0,  0,  0},   // 8319
    {  2,  5, 13,  0,  0,  0},   // 8320
    { 53,157,  0,  0,  0,  0},   // 8321
    {  2,  3, 19, 73,  0,  0},   // 8322
    {  7, 29, 41,  0,  0,  0},   // 8323
    {  2,2081,  0,  0,  0,  0},   // 8324
    {  3,  5, 37,  0,  0,  0},   // 8325
    {  2, 23,181,  0,  0,  0},   // 8326
    { 11,757,  0,  0,  0,  0},   // 8327
    {  2,  3,347,  0,  0,  0},   // 8328
    {  0,  0,  0,  0,  0,  0},   // 8329
    {  2,  5,  7, 17,  0,  0},   // 8330
    {  3,2777,  0,  0,  0,  0},   // 8331
    {  2,2083,  0,  0,  0,  0},   // 8332
    { 13,641,  0,  0,  0,  0},   // 8333
    {  2,  3,463,  0,  0,  0},   // 8334
    {  5,1667,  0,  0,  0,  0},   // 8335
    {  2,521,  0,  0,  0,  0},   // 8336
    {  3,  7,397,  0,  0,  0},   // 8337
    {  2, 11,379,  0,  0,  0},   // 8338
    { 31,269,  0,  0,  0,  0},   // 8339
    {  2,  3,  5,139,  0,  0},   // 8340
    { 19,439,  0,  0,  0,  0},   // 8341
    {  2, 43, 97,  0,  0,  0},   // 8342
    {  3,103,  0,  0,  0,  0},   // 8343
    {  2,  7,149,  0,  0,  0},   // 8344
    {  5,1669,  0,  0,  0,  0},   // 8345
    {  2,  3, 13,107,  0,  0},   // 8346
    { 17,491,  0,  0,  0,  0},   // 8347
    {  2,2087,  0,  0,  0,  0},   // 8348
    {  3, 11, 23,  0,  0,  0},   // 8349
    {  2,  5,167,  0,  0,  0},   // 8350
    {  7,1193,  0,  0,  0,  0},   // 8351
    {  2,  3, 29,  0,  0,  0},   // 8352
    {  0,  0,  0,  0,  0,  0},   // 8353
    {  2,4177,  0,  0,  0,  0},   // 8354
    {  3,  5,557,  0,  0,  0},   // 8355
    {  2,2089,  0,  0,  0,  0},   // 8356
    { 61,137,  0,  0,  0,  0},   // 8357
    {  2,  3,  7,199,  0,  0},   // 8358
    { 13,643,  0,  0,  0,  0},   // 8359
    {  2,  5, 11, 19,  0,  0},   // 8360
    {  3,929,  0,  0,  0,  0},   // 8361
    {  2, 37,113,  0,  0,  0},   // 8362
    {  0,  0,  0,  0,  0,  0},   // 8363
    {  2,  3, 17, 41,  0,  0},   // 8364
    {  5,  7,239,  0,  0,  0},   // 8365
    {  2, 47, 89,  0,  0,  0},   // 8366
    {  3,2789,  0,  0,  0,  0},   // 8367
    {  2,523,  0,  0,  0,  0},   // 8368
    {  0,  0,  0,  0,  0,  0},   // 8369
    {  2,  3,  5, 31,  0,  0},   // 8370
    { 11,761,  0,  0,  0,  0},   // 8371
    {  2,  7, 13, 23,  0,  0},   // 8372
    {  3,2791,  0,  0,  0,  0},   // 8373
    {  2, 53, 79,  0,  0,  0},   // 8374
    {  5, 67,  0,  0,  0,  0},   // 8375
    {  2,  3,349,  0,  0,  0},   // 8376
    {  0,  0,  0,  0,  0,  0},   // 8377
    {  2, 59, 71,  0,  0,  0},   // 8378
    {  3,  7, 19,  0,  0,  0},   // 8379
    {  2,  5,419,  0,  0,  0},   // 8380
    { 17, 29,  0,  0,  0,  0},   // 8381
    {  2,  3, 11,127,  0,  0},   // 8382
    { 83,101,  0,  0,  0,  0},   // 8383
    {  2,131,  0,  0,  0,  0},   // 8384
    {  3,  5, 13, 43,  0,  0},   // 8385
    {  2,  7,599,  0,  0,  0},   // 8386
    {  0,  0,  0,  0,  0,  0},   // 8387
    {  2,  3,233,  0,  0,  0},   // 8388
    {  0,  0,  0,  0,  0,  0},   // 8389
    {  2,  5,839,  0,  0,  0},   // 8390
    {  3,2797,  0,  0,  0,  0},   // 8391
    {  2,1049,  0,  0,  0,  0},   // 8392
    {  7, 11,109,  0,  0,  0},   // 8393
    {  2,  3,1399,  0,  0,  0},   // 8394
    {  5, 23, 73,  0,  0,  0},   // 8395
    {  2,2099,  0,  0,  0,  0},   // 8396
    {  3,311,  0,  0,  0,  0},   // 8397
    {  2, 13, 17, 19,  0,  0},   // 8398
    { 37,227,  0,  0,  0,  0},   // 8399
    {  2,  3,  5,  7,  0,  0},   // 8400
    { 31,271,  0,  0,  0,  0},   // 8401
    {  2,4201,  0,  0,  0,  0},   // 8402
    {  3,2801,  0,  0,  0,  0},   // 8403
    {  2, 11,191,  0,  0,  0},   // 8404
    {  5, 41,  0,  0,  0,  0},   // 8405
    {  2,  3,467,  0,  0,  0},   // 8406
    {  7,1201,  0,  0,  0,  0},   // 8407
    {  2,1051,  0,  0,  0,  0},   // 8408
    {  3,2803,  0,  0,  0,  0},   // 8409
    {  2,  5, 29,  0,  0,  0},   // 8410
    { 13,647,  0,  0,  0,  0},   // 8411
    {  2,  3,701,  0,  0,  0},   // 8412
    { 47,179,  0,  0,  0,  0},   // 8413
    {  2,  7,601,  0,  0,  0},   // 8414
    {  3,  5, 11, 17,  0,  0},   // 8415
    {  2,263,  0,  0,  0,  0},   // 8416
    { 19,443,  0,  0,  0,  0},   // 8417
    {  2,  3, 23, 61,  0,  0},   // 8418
    {  0,  0,  0,  0,  0,  0},   // 8419
    {  2,  5,421,  0,  0,  0},   // 8420
    {  3,  7,401,  0,  0,  0},   // 8421
    {  2,4211,  0,  0,  0,  0},   // 8422
    {  0,  0,  0,  0,  0,  0},   // 8423
    {  2,  3, 13,  0,  0,  0},   // 8424
    {  5,337,  0,  0,  0,  0},   // 8425
    {  2, 11,383,  0,  0,  0},   // 8426
    {  3, 53,  0,  0,  0,  0},   // 8427
    {  2,  7, 43,  0,  0,  0},   // 8428
    {  0,  0,  0,  0,  0,  0},   // 8429
    {  2,  3,  5,281,  0,  0},   // 8430
    {  0,  0,  0,  0,  0,  0},   // 8431
    {  2, 17, 31,  0,  0,  0},   // 8432
    {  3,937,  0,  0,  0,  0},   // 8433
    {  2,4217,  0,  0,  0,  0},   // 8434
    {  5,  7,241,  0,  0,  0},   // 8435
    {  2,  3, 19, 37,  0,  0},   // 8436
    { 11, 13, 59,  0,  0,  0},   // 8437
    {  2,4219,  0,  0,  0,  0},   // 8438
    {  3, 29, 97,  0,  0,  0},   // 8439
    {  2,  5,211,  0,  0,  0},   // 8440
    { 23,367,  0,  0,  0,  0},   // 8441
    {  2,  3,  7, 67,  0,  0},   // 8442
    {  0,  0,  0,  0,  0,  0},   // 8443
    {  2,2111,  0,  0,  0,  0},   // 8444
    {  3,  5,563,  0,  0,  0},   // 8445
    {  2, 41,103,  0,  0,  0},   // 8446
    {  0,  0,  0,  0,  0,  0},   // 8447
    {  2,  3, 11,  0,  0,  0},   // 8448
    {  7, 17, 71,  0,  0,  0},   // 8449
    {  2,  5, 13,  0,  0,  0},   // 8450
    {  3,313,  0,  0,  0,  0},   // 8451
    {  2,2113,  0,  0,  0,  0},   // 8452
    { 79,107,  0,  0,  0,  0},   // 8453
    {  2,  3,1409,  0,  0,  0},   // 8454
    {  5, 19, 89,  0,  0,  0},   // 8455
    {  2,  7,151,  0,  0,  0},   // 8456
    {  3,2819,  0,  0,  0,  0},   // 8457
    {  2,4229,  0,  0,  0,  0},   // 8458
    { 11,769,  0,  0,  0,  0},   // 8459
    {  2,  3,  5, 47,  0,  0},   // 8460
    {  0,  0,  0,  0,  0,  0},   // 8461
    {  2,4231,  0,  0,  0,  0},   // 8462
    {  3,  7, 13, 31,  0,  0},   // 8463
    {  2, 23,  0,  0,  0,  0},   // 8464
    {  5,1693,  0,  0,  0,  0},   // 8465
    {  2,  3, 17, 83,  0,  0},   // 8466
    {  0,  0,  0,  0,  0,  0},   // 8467
    {  2, 29, 73,  0,  0,  0},   // 8468
    {  3,941,  0,  0,  0,  0},   // 8469
    {  2,  5,  7, 11,  0,  0},   // 8470
    { 43,197,  0,  0,  0,  0},   // 8471
    {  2,  3,353,  0,  0,  0},   // 8472
    { 37,229,  0,  0,  0,  0},   // 8473
    {  2, 19,223,  0,  0,  0},   // 8474
    {  3,  5,113,  0,  0,  0},   // 8475
    {  2, 13,163,  0,  0,  0},   // 8476
    {  7,173,  0,  0,  0,  0},   // 8477
    {  2,  3,157,  0,  0,  0},   // 8478
    { 61,139,  0,  0,  0,  0},   // 8479
    {  2,  5, 53,  0,  0,  0},   // 8480
    {  3, 11,257,  0,  0,  0},   // 8481
    {  2,4241,  0,  0,  0,  0},   // 8482
    { 17,499,  0,  0,  0,  0},   // 8483
    {  2,  3,  7,101,  0,  0},   // 8484
    {  5,1697,  0,  0,  0,  0},   // 8485
    {  2,4243,  0,  0,  0,  0},   // 8486
    {  3, 23, 41,  0,  0,  0},   // 8487
    {  2,1061,  0,  0,  0,  0},   // 8488
    { 13,653,  0,  0,  0,  0},   // 8489
    {  2,  3,  5,283,  0,  0},   // 8490
    {  7,1213,  0,  0,  0,  0},   // 8491
    {  2, 11,193,  0,  0,  0},   // 8492
    {  3, 19,149,  0,  0,  0},   // 8493
    {  2, 31,137,  0,  0,  0},   // 8494
    {  5,1699,  0,  0,  0,  0},   // 8495
    {  2,  3, 59,  0,  0,  0},   // 8496
    { 29,293,  0,  0,  0,  0},   // 8497
    {  2,  7,607,  0,  0,  0},   // 8498
    {  3,2833,  0,  0,  0,  0},   // 8499
    {  2,  5, 17,  0,  0,  0},   // 8500
    {  0,  0,  0,  0,  0,  0},   // 8501
    {  2,  3, 13,109,  0,  0},   // 8502
    { 11,773,  0,  0,  0,  0},   // 8503
    {  2,1063,  0,  0,  0,  0},   // 8504
    {  3,  5,  7,  0,  0,  0},   // 8505
    {  2,4253,  0,  0,  0,  0},   // 8506
    { 47,181,  0,  0,  0,  0},   // 8507
    {  2,  3,709,  0,  0,  0},   // 8508
    { 67,127,  0,  0,  0,  0},   // 8509
    {  2,  5, 23, 37,  0,  0},   // 8510
    {  3,2837,  0,  0,  0,  0},   // 8511
    {  2,  7, 19,  0,  0,  0},   // 8512
    {  0,  0,  0,  0,  0,  0},   // 8513
    {  2,  3, 11, 43,  0,  0},   // 8514
    {  5, 13,131,  0,  0,  0},   // 8515
    {  2,2129,  0,  0,  0,  0},   // 8516
    {  3, 17,167,  0,  0,  0},   // 8517
    {  2,4259,  0,  0,  0,  0},   // 8518
    {  7,1217,  0,  0,  0,  0},   // 8519
    {  2,  3,  5, 71,  0,  0},   // 8520
    {  0,  0,  0,  0,  0,  0},   // 8521
    {  2,4261,  0,  0,  0,  0},   // 8522
    {  3,947,  0,  0,  0,  0},   // 8523
    {  2,2131,  0,  0,  0,  0},   // 8524
    {  5, 11, 31,  0,  0,  0},   // 8525
    {  2,  3,  7, 29,  0,  0},   // 8526
    {  0,  0,  0,  0,  0,  0},   // 8527
    {  2, 13, 41,  0,  0,  0},   // 8528
    {  3,2843,  0,  0,  0,  0},   // 8529
    {  2,  5,853,  0,  0,  0},   // 8530
    { 19,449,  0,  0,  0,  0},   // 8531
    {  2,  3, 79,  0,  0,  0},   // 8532
    {  7, 23, 53,  0,  0,  0},   // 8533
    {  2, 17,251,  0,  0,  0},   // 8534
    {  3,  5,569,  0,  0,  0},   // 8535
    {  2, 11, 97,  0,  0,  0},   // 8536
    {  0,  0,  0,  0,  0,  0},   // 8537
    {  2,  3,1423,  0,  0,  0},   // 8538
    {  0,  0,  0,  0,  0,  0},   // 8539
    {  2,  5,  7, 61,  0,  0},   // 8540
    {  3, 13, 73,  0,  0,  0},   // 8541
    {  2,4271,  0,  0,  0,  0},   // 8542
    {  0,  0,  0,  0,  0,  0},   // 8543
    {  2,  3, 89,  0,  0,  0},   // 8544
    {  5,1709,  0,  0,  0,  0},   // 8545
    {  2,4273,  0,  0,  0,  0},   // 8546
    {  3,  7, 11, 37,  0,  0},   // 8547
    {  2,2137,  0,  0,  0,  0},   // 8548
    { 83,103,  0,  0,  0,  0},   // 8549
    {  2,  3,  5, 19,  0,  0},   // 8550
    { 17,503,  0,  0,  0,  0},   // 8551
    {  2,1069,  0,  0,  0,  0},   // 8552
    {  3,2851,  0,  0,  0,  0},   // 8553
    {  2,  7, 13, 47,  0,  0},   // 8554
    {  5, 29, 59,  0,  0,  0},   // 8555
    {  2,  3, 23, 31,  0,  0},   // 8556
    { 43,199,  0,  0,  0,  0},   // 8557
    {  2, 11,389,  0,  0,  0},   // 8558
    {  3,317,  0,  0,  0,  0},   // 8559
    {  2,  5,107,  0,  0,  0},   // 8560
    {  7,1223,  0,  0,  0,  0},   // 8561
    {  2,  3,1427,  0,  0,  0},   // 8562
    {  0,  0,  0,  0,  0,  0},   // 8563
    {  2,2141,  0,  0,  0,  0},   // 8564
    {  3,  5,571,  0,  0,  0},   // 8565
    {  2,4283,  0,  0,  0,  0},   // 8566
    { 13,659,  0,  0,  0,  0},   // 8567
    {  2,  3,  7, 17,  0,  0},   // 8568
    { 11, 19, 41,  0,  0,  0},   // 8569
    {  2,  5,857,  0,  0,  0},   // 8570
    {  3,2857,  0,  0,  0,  0},   // 8571
    {  2,2143,  0,  0,  0,  0},   // 8572
    {  0,  0,  0,  0,  0,  0},   // 8573
    {  2,  3,1429,  0,  0,  0},   // 8574
    {  5,  7,  0,  0,  0,  0},   // 8575
    {  2, 67,  0,  0,  0,  0},   // 8576
    {  3,953,  0,  0,  0,  0},   // 8577
    {  2,4289,  0,  0,  0,  0},   // 8578
    { 23,373,  0,  0,  0,  0},   // 8579
    {  2,  3,  5, 11, 13,  0},   // 8580
    {  0,  0,  0,  0,  0,  0},   // 8581
    {  2,  7,613,  0,  0,  0},   // 8582
    {  3,2861,  0,  0,  0,  0},   // 8583
    {  2, 29, 37,  0,  0,  0},   // 8584
    {  5, 17,101,  0,  0,  0},   // 8585
    {  2,  3, 53,  0,  0,  0},   // 8586
    { 31,277,  0,  0,  0,  0},   // 8587
    {  2, 19,113,  0,  0,  0},   // 8588
    {  3,  7,409,  0,  0,  0},   // 8589
    {  2,  5,859,  0,  0,  0},   // 8590
    { 11, 71,  0,  0,  0,  0},   // 8591
    {  2,  3,179,  0,  0,  0},   // 8592
    { 13,661,  0,  0,  0,  0},   // 8593
    {  2,4297,  0,  0,  0,  0},   // 8594
    {  3,  5,191,  0,  0,  0},   // 8595
    {  2,  7,307,  0,  0,  0},   // 8596
    {  0,  0,  0,  0,  0,  0},   // 8597
    {  2,  3,1433,  0,  0,  0},   // 8598
    {  0,  0,  0,  0,  0,  0},   // 8599
    {  2,  5, 43,  0,  0,  0},   // 8600
    {  3, 47, 61,  0,  0,  0},   // 8601
    {  2, 11, 17, 23,  0,  0},   // 8602
    {  7,1229,  0,  0,  0,  0},   // 8603
    {  2,  3,239,  0,  0,  0},   // 8604
    {  5,1721,  0,  0,  0,  0},   // 8605
    {  2, 13,331,  0,  0,  0},   // 8606
    {  3, 19,151,  0,  0,  0},   // 8607
    {  2,269,  0,  0,  0,  0},   // 8608
    {  0,  0,  0,  0,  0,  0},   // 8609
    {  2,  3,  5,  7, 41,  0},   // 8610
    { 79,109,  0,  0,  0,  0},   // 8611
    {  2,2153,  0,  0,  0,  0},   // 8612
    {  3, 11, 29,  0,  0,  0},   // 8613
    {  2, 59, 73,  0,  0,  0},   // 8614
    {  5,1723,  0,  0,  0,  0},   // 8615
    {  2,  3,359,  0,  0,  0},   // 8616
    {  7,1231,  0,  0,  0,  0},   // 8617
    {  2, 31,139,  0,  0,  0},   // 8618
    {  3, 13, 17,  0,  0,  0},   // 8619
    {  2,  5,431,  0,  0,  0},   // 8620
    { 37,233,  0,  0,  0,  0},   // 8621
    {  2,  3,479,  0,  0,  0},   // 8622
    {  0,  0,  0,  0,  0,  0},   // 8623
    {  2,  7, 11,  0,  0,  0},   // 8624
    {  3,  5, 23,  0,  0,  0},   // 8625
    {  2, 19,227,  0,  0,  0},   // 8626
    {  0,  0,  0,  0,  0,  0},   // 8627
    {  2,  3,719,  0,  0,  0},   // 8628
    {  0,  0,  0,  0,  0,  0},   // 8629
    {  2,  5,863,  0,  0,  0},   // 8630
    {  3,  7,137,  0,  0,  0},   // 8631
    {  2, 13, 83,  0,  0,  0},   // 8632
    { 89, 97,  0,  0,  0,  0},   // 8633
    {  2,  3,1439,  0,  0,  0},   // 8634
    {  5, 11,157,  0,  0,  0},   // 8635
    {  2, 17,127,  0,  0,  0},   // 8636
    {  3,2879,  0,  0,  0,  0},   // 8637
    {  2,  7,617,  0,  0,  0},   // 8638
    { 53,163,  0,  0,  0,  0},   // 8639
    {  2,  3,  5,  0,  0,  0},   // 8640
    {  0,  0,  0,  0,  0,  0},   // 8641
    {  2, 29,149,  0,  0,  0},   // 8642
    {  3, 43, 67,  0,  0,  0},   // 8643
    {  2,2161,  0,  0,  0,  0},   // 8644
    {  5,  7, 13, 19,  0,  0},   // 8645
    {  2,  3, 11,131,  0,  0},   // 8646
    {  0,  0,  0,  0,  0,  0},   // 8647
    {  2, 23, 47,  0,  0,  0},   // 8648
    {  3, 31,  0,  0,  0,  0},   // 8649
    {  2,  5,173,  0,  0,  0},   // 8650
    { 41,211,  0,  0,  0,  0},   // 8651
    {  2,  3,  7,103,  0,  0},   // 8652
    { 17,509,  0,  0,  0,  0},   // 8653
    {  2,4327,  0,  0,  0,  0},   // 8654
    {  3,  5,577,  0,  0,  0},   // 8655
    {  2,541,  0,  0,  0,  0},   // 8656
    { 11,787,  0,  0,  0,  0},   // 8657
    {  2,  3, 13, 37,  0,  0},   // 8658
    {  7,1237,  0,  0,  0,  0},   // 8659
    {  2,  5,433,  0,  0,  0},   // 8660
    {  3,2887,  0,  0,  0,  0},   // 8661
    {  2, 61, 71,  0,  0,  0},   // 8662
    {  0,  0,  0,  0,  0,  0},   // 8663
    {  2,  3, 19,  0,  0,  0},   // 8664
    {  5,1733,  0,  0,  0,  0},   // 8665
    {  2,  7,619,  0,  0,  0},   // 8666
    {  3,107,  0,  0,  0,  0},   // 8667
    {  2, 11,197,  0,  0,  0},   // 8668
    {  0,  0,  0,  0,  0,  0},   // 8669
    {  2,  3,  5, 17,  0,  0},   // 8670
    { 13, 23, 29,  0,  0,  0},   // 8671
    {  2,271,  0,  0,  0,  0},   // 8672
    {  3,  7, 59,  0,  0,  0},   // 8673
    {  2,4337,  0,  0,  0,  0},   // 8674
    {  5,347,  0,  0,  0,  0},   // 8675
    {  2,  3,241,  0,  0,  0},   // 8676
    {  0,  0,  0,  0,  0,  0},   // 8677
    {  2,4339,  0,  0,  0,  0},   // 8678
    {  3, 11,263,  0,  0,  0},   // 8679
    {  2,  5,  7, 31,  0,  0},   // 8680
    {  0,  0,  0,  0,  0,  0},   // 8681
    {  2,  3,1447,  0,  0,  0},   // 8682
    { 19,457,  0,  0,  0,  0},   // 8683
    {  2, 13,167,  0,  0,  0},   // 8684
    {  3,  5,193,  0,  0,  0},   // 8685
    {  2, 43,101,  0,  0,  0},   // 8686
    {  7, 17, 73,  0,  0,  0},   // 8687
    {  2,  3,181,  0,  0,  0},   // 8688
    {  0,  0,  0,  0,  0,  0},   // 8689
    {  2,  5, 11, 79,  0,  0},   // 8690
    {  3,2897,  0,  0,  0,  0},   // 8691
    {  2, 41, 53,  0,  0,  0},   // 8692
    {  0,  0,  0,  0,  0,  0},   // 8693
    {  2,  3,  7, 23,  0,  0},   // 8694
    {  5, 37, 47,  0,  0,  0},   // 8695
    {  2,1087,  0,  0,  0,  0},   // 8696
    {  3, 13,223,  0,  0,  0},   // 8697
    {  2,4349,  0,  0,  0,  0},   // 8698
    {  0,  0,  0,  0,  0,  0},   // 8699
    {  2,  3,  5, 29,  0,  0},   // 8700
    {  7, 11,113,  0,  0,  0},   // 8701
    {  2, 19,229,  0,  0,  0},   // 8702
    {  3,967,  0,  0,  0,  0},   // 8703
    {  2, 17,  0,  0,  0,  0},   // 8704
    {  5,1741,  0,  0,  0,  0},   // 8705
    {  2,  3,1451,  0,  0,  0},   // 8706
    {  0,  0,  0,  0,  0,  0},   // 8707
    {  2,  7,311,  0,  0,  0},   // 8708
    {  3,2903,  0,  0,  0,  0},   // 8709
    {  2,  5, 13, 67,  0,  0},   // 8710
    { 31,281,  0,  0,  0,  0},   // 8711
    {  2,  3, 11,  0,  0,  0},   // 8712
    {  0,  0,  0,  0,  0,  0},   // 8713
    {  2,4357,  0,  0,  0,  0},   // 8714
    {  3,  5,  7, 83,  0,  0},   // 8715
    {  2,2179,  0,  0,  0,  0},   // 8716
    { 23,379,  0,  0,  0,  0},   // 8717
    {  2,  3,1453,  0,  0,  0},   // 8718
    {  0,  0,  0,  0,  0,  0},   // 8719
    {  2,  5,109,  0,  0,  0},   // 8720
    {  3, 17, 19,  0,  0,  0},   // 8721
    {  2,  7, 89,  0,  0,  0},   // 8722
    { 11, 13, 61,  0,  0,  0},   // 8723
    {  2,  3,727,  0,  0,  0},   // 8724
    {  5,349,  0,  0,  0,  0},   // 8725
    {  2,4363,  0,  0,  0,  0},   // 8726
    {  3,2909,  0,  0,  0,  0},   // 8727
    {  2,1091,  0,  0,  0,  0},   // 8728
    {  7, 29, 43,  0,  0,  0},   // 8729
    {  2,  3,  5, 97,  0,  0},   // 8730
    {  0,  0,  0,  0,  0,  0},   // 8731
    {  2, 37, 59,  0,  0,  0},   // 8732
    {  3, 41, 71,  0,  0,  0},   // 8733
    {  2, 11,397,  0,  0,  0},   // 8734
    {  5,1747,  0,  0,  0,  0},   // 8735
    {  2,  3,  7, 13,  0,  0},   // 8736
    {  0,  0,  0,  0,  0,  0},   // 8737
    {  2, 17,257,  0,  0,  0},   // 8738
    {  3,971,  0,  0,  0,  0},   // 8739
    {  2,  5, 19, 23,  0,  0},   // 8740
    {  0,  0,  0,  0,  0,  0},   // 8741
    {  2,  3, 31, 47,  0,  0},   // 8742
    {  7,1249,  0,  0,  0,  0},   // 8743
    {  2,1093,  0,  0,  0,  0},   // 8744
    {  3,  5, 11, 53,  0,  0},   // 8745
    {  2,4373,  0,  0,  0,  0},   // 8746
    {  0,  0,  0,  0,  0,  0},   // 8747
    {  2,  3,  0,  0,  0,  0},   // 8748
    { 13,673,  0,  0,  0,  0},   // 8749
    {  2,  5,  7,  0,  0,  0},   // 8750
    {  3,2917,  0,  0,  0,  0},   // 8751
    {  2,547,  0,  0,  0,  0},   // 8752
    {  0,  0,  0,  0,  0,  0},   // 8753
    {  2,  3,1459,  0,  0,  0},   // 8754
    {  5, 17,103,  0,  0,  0},   // 8755
    {  2, 11,199,  0,  0,  0},   // 8756
    {  3,  7,139,  0,  0,  0},   // 8757
    {  2, 29,151,  0,  0,  0},   // 8758
    { 19,461,  0,  0,  0,  0},   // 8759
    {  2,  3,  5, 73,  0,  0},   // 8760
    {  0,  0,  0,  0,  0,  0},   // 8761
    {  2, 13,337,  0,  0,  0},   // 8762
    {  3, 23,127,  0,  0,  0},   // 8763
    {  2,  7,313,  0,  0,  0},   // 8764
    {  5,1753,  0,  0,  0,  0},   // 8765
    {  2,  3,487,  0,  0,  0},   // 8766
    { 11,797,  0,  0,  0,  0},   // 8767
    {  2,137,  0,  0,  0,  0},   // 8768
    {  3, 37, 79,  0,  0,  0},   // 8769
    {  2,  5,877,  0,  0,  0},   // 8770
    {  7,179,  0,  0,  0,  0},   // 8771
    {  2,  3, 17, 43,  0,  0},   // 8772
    { 31,283,  0,  0,  0,  0},   // 8773
    {  2, 41,107,  0,  0,  0},   // 8774
    {  3,  5, 13,  0,  0,  0},   // 8775
    {  2,1097,  0,  0,  0,  0},   // 8776
    { 67,131,  0,  0,  0,  0},   // 8777
    {  2,  3,  7, 11, 19,  0},   // 8778
    {  0,  0,  0,  0,  0,  0},   // 8779
    {  2,  5,439,  0,  0,  0},   // 8780
    {  3,2927,  0,  0,  0,  0},   // 8781
    {  2,4391,  0,  0,  0,  0},   // 8782
    {  0,  0,  0,  0,  0,  0},   // 8783
    {  2,  3, 61,  0,  0,  0},   // 8784
    {  5,  7,251,  0,  0,  0},   // 8785
    {  2, 23,191,  0,  0,  0},   // 8786
    {  3, 29,101,  0,  0,  0},   // 8787
    {  2, 13,  0,  0,  0,  0},   // 8788
    { 11, 17, 47,  0,  0,  0},   // 8789
    {  2,  3,  5,293,  0,  0},   // 8790
    { 59,149,  0,  0,  0,  0},   // 8791
    {  2,  7,157,  0,  0,  0},   // 8792
    {  3,977,  0,  0,  0,  0},   // 8793
    {  2,4397,  0,  0,  0,  0},   // 8794
    {  5,1759,  0,  0,  0,  0},   // 8795
    {  2,  3,733,  0,  0,  0},   // 8796
    { 19,463,  0,  0,  0,  0},   // 8797
    {  2, 53, 83,  0,  0,  0},   // 8798
    {  3,  7,419,  0,  0,  0},   // 8799
    {  2,  5, 11,  0,  0,  0},   // 8800
    { 13,677,  0,  0,  0,  0},   // 8801
    {  2,  3,163,  0,  0,  0},   // 8802
    {  0,  0,  0,  0,  0,  0},   // 8803
    {  2, 31, 71,  0,  0,  0},   // 8804
    {  3,  5,587,  0,  0,  0},   // 8805
    {  2,  7, 17, 37,  0,  0},   // 8806
    {  0,  0,  0,  0,  0,  0},   // 8807
    {  2,  3,367,  0,  0,  0},   // 8808
    { 23,383,  0,  0,  0,  0},   // 8809
    {  2,  5,881,  0,  0,  0},   // 8810
    {  3, 11, 89,  0,  0,  0},   // 8811
    {  2,2203,  0,  0,  0,  0},   // 8812
    {  7,1259,  0,  0,  0,  0},   // 8813
    {  2,  3, 13,113,  0,  0},   // 8814
    {  5, 41, 43,  0,  0,  0},   // 8815
    {  2, 19, 29,  0,  0,  0},   // 8816
    {  3,2939,  0,  0,  0,  0},   // 8817
    {  2,4409,  0,  0,  0,  0},   // 8818
    {  0,  0,  0,  0,  0,  0},   // 8819
    {  2,  3,  5,  7,  0,  0},   // 8820
    {  0,  0,  0,  0,  0,  0},   // 8821
    {  2, 11,401,  0,  0,  0},   // 8822
    {  3, 17,173,  0,  0,  0},   // 8823
    {  2,1103,  0,  0,  0,  0},   // 8824
    {  5,353,  0,  0,  0,  0},   // 8825
    {  2,  3,1471,  0,  0,  0},   // 8826
    {  7, 13, 97,  0,  0,  0},   // 8827
    {  2,2207,  0,  0,  0,  0},   // 8828
    {  3,109,  0,  0,  0,  0},   // 8829
    {  2,  5,883,  0,  0,  0},   // 8830
    {  0,  0,  0,  0,  0,  0},   // 8831
    {  2,  3, 23,  0,  0,  0},   // 8832
    { 11, 73,  0,  0,  0,  0},   // 8833
    {  2,  7,631,  0,  0,  0},   // 8834
    {  3,  5, 19, 31,  0,  0},   // 8835
    {  2, 47,  0,  0,  0,  0},   // 8836
    {  0,  0,  0,  0,  0,  0},   // 8837
    {  2,  3,491,  0,  0,  0},   // 8838
    {  0,  0,  0,  0,  0,  0},   // 8839
    {  2,  5, 13, 17,  0,  0},   // 8840
    {  3,  7,421,  0,  0,  0},   // 8841
    {  2,4421,  0,  0,  0,  0},   // 8842
    { 37,239,  0,  0,  0,  0},   // 8843
    {  2,  3, 11, 67,  0,  0},   // 8844
    {  5, 29, 61,  0,  0,  0},   // 8845
    {  2,4423,  0,  0,  0,  0},   // 8846
    {  3,983,  0,  0,  0,  0},   // 8847
    {  2,  7, 79,  0,  0,  0},   // 8848
    {  0,  0,  0,  0,  0,  0},   // 8849
    {  2,  3,  5, 59,  0,  0},   // 8850
    { 53,167,  0,  0,  0,  0},   // 8851
    {  2,2213,  0,  0,  0,  0},   // 8852
    {  3, 13,227,  0,  0,  0},   // 8853
    {  2, 19,233,  0,  0,  0},   // 8854
    {  5,  7, 11, 23,  0,  0},   // 8855
    {  2,  3, 41,  0,  0,  0},   // 8856
    { 17,521,  0,  0,  0,  0},   // 8857
    {  2, 43,103,  0,  0,  0},   // 8858
    {  3,2953,  0,  0,  0,  0},   // 8859
    {  2,  5,443,  0,  0,  0},   // 8860
    {  0,  0,  0,  0,  0,  0},   // 8861
    {  2,  3,  7,211,  0,  0},   // 8862
    {  0,  0,  0,  0,  0,  0},   // 8863
    {  2,277,  0,  0,  0,  0},   // 8864
    {  3,  5,197,  0,  0,  0},   // 8865
    {  2, 11, 13, 31,  0,  0},   // 8866
    {  0,  0,  0,  0,  0,  0},   // 8867
    {  2,  3,739,  0,  0,  0},   // 8868
    {  7,181,  0,  0,  0,  0},   // 8869
    {  2,  5,887,  0,  0,  0},   // 8870
    {  3,2957,  0,  0,  0,  0},   // 8871
    {  2,1109,  0,  0,  0,  0},   // 8872
    { 19,467,  0,  0,  0,  0},   // 8873
    {  2,  3, 17, 29,  0,  0},   // 8874
    {  5, 71,  0,  0,  0,  0},   // 8875
    {  2,  7,317,  0,  0,  0},   // 8876
    {  3, 11,269,  0,  0,  0},   // 8877
    {  2, 23,193,  0,  0,  0},   // 8878
    { 13,683,  0,  0,  0,  0},   // 8879
    {  2,  3,  5, 37,  0,  0},   // 8880
    { 83,107,  0,  0,  0,  0},   // 8881
    {  2,4441,  0,  0,  0,  0},   // 8882
    {  3,  7, 47,  0,  0,  0},   // 8883
    {  2,2221,  0,  0,  0,  0},   // 8884
    {  5,1777,  0,  0,  0,  0},   // 8885
    {  2,  3,1481,  0,  0,  0},   // 8886
    {  0,  0,  0,  0,  0,  0},   // 8887
    {  2, 11,101,  0,  0,  0},   // 8888
    {  3,2963,  0,  0,  0,  0},   // 8889
    {  2,  5,  7,127,  0,  0},   // 8890
    { 17,523,  0,  0,  0,  0},   // 8891
    {  2,  3, 13, 19,  0,  0},   // 8892
    {  0,  0,  0,  0,  0,  0},   // 8893
    {  2,4447,  0,  0,  0,  0},   // 8894
    {  3,  5,593,  0,  0,  0},   // 8895
    {  2,139,  0,  0,  0,  0},   // 8896
    {  7, 31, 41,  0,  0,  0},   // 8897
    {  2,  3,1483,  0,  0,  0},   // 8898
    { 11,809,  0,  0,  0,  0},   // 8899
    {  2,  5, 89,  0,  0,  0},   // 8900
    {  3, 23, 43,  0,  0,  0},   // 8901
    {  2,4451,  0,  0,  0,  0},   // 8902
    { 29,307,  0,  0,  0,  0},   // 8903
    {  2,  3,  7, 53,  0,  0},   // 8904
    {  5, 13,137,  0,  0,  0},   // 8905
    {  2, 61, 73,  0,  0,  0},   // 8906
    {  3,2969,  0,  0,  0,  0},   // 8907
    {  2, 17,131,  0,  0,  0},   // 8908
    { 59,151,  0,  0,  0,  0},   // 8909
    {  2,  3,  5, 11,  0,  0},   // 8910
    {  7, 19, 67,  0,  0,  0},   // 8911
    {  2,557,  0,  0,  0,  0},   // 8912
    {  3,2971,  0,  0,  0,  0},   // 8913
    {  2,4457,  0,  0,  0,  0},   // 8914
    {  5,1783,  0,  0,  0,  0},   // 8915
    {  2,  3,743,  0,  0,  0},   // 8916
    { 37,241,  0,  0,  0,  0},   // 8917
    {  2,  7, 13,  0,  0,  0},   // 8918
    {  3,991,  0,  0,  0,  0},   // 8919
    {  2,  5,223,  0,  0,  0},   // 8920
    { 11,811,  0,  0,  0,  0},   // 8921
    {  2,  3,1487,  0,  0,  0},   // 8922
    {  0,  0,  0,  0,  0,  0},   // 8923
    {  2, 23, 97,  0,  0,  0},   // 8924
    {  3,  5,  7, 17,  0,  0},   // 8925
    {  2,4463,  0,  0,  0,  0},   // 8926
    { 79,113,  0,  0,  0,  0},   // 8927
    {  2,  3, 31,  0,  0,  0},   // 8928
    {  0,  0,  0,  0,  0,  0},   // 8929
    {  2,  5, 19, 47,  0,  0},   // 8930
    {  3, 13,229,  0,  0,  0},   // 8931
    {  2,  7, 11, 29,  0,  0},   // 8932
    {  0,  0,  0,  0,  0,  0},   // 8933
    {  2,  3,1489,  0,  0,  0},   // 8934
    {  5,1787,  0,  0,  0,  0},   // 8935
    {  2,1117,  0,  0,  0,  0},   // 8936
    {  3,331,  0,  0,  0,  0},   // 8937
    {  2, 41,109,  0,  0,  0},   // 8938
    {  7,1277,  0,  0,  0,  0},   // 8939
    {  2,  3,  5,149,  0,  0},   // 8940
    {  0,  0,  0,  0,  0,  0},   // 8941
    {  2, 17,263,  0,  0,  0},   // 8942
    {  3, 11,271,  0,  0,  0},   // 8943
    {  2, 13, 43,  0,  0,  0},   // 8944
    {  5,1789,  0,  0,  0,  0},   // 8945
    {  2,  3,  7, 71,  0,  0},   // 8946
    { 23,389,  0,  0,  0,  0},   // 8947
    {  2,2237,  0,  0,  0,  0},   // 8948
    {  3, 19,157,  0,  0,  0},   // 8949
    {  2,  5,179,  0,  0,  0},   // 8950
    {  0,  0,  0,  0,  0,  0},   // 8951
    {  2,  3,373,  0,  0,  0},   // 8952
    {  7,1279,  0,  0,  0,  0},   // 8953
    {  2, 11, 37,  0,  0,  0},   // 8954
    {  3,  5,199,  0,  0,  0},   // 8955
    {  2,2239,  0,  0,  0,  0},   // 8956
    { 13, 53,  0,  0,  0,  0},   // 8957
    {  2,  3,1493,  0,  0,  0},   // 8958
    { 17, 31,  0,  0,  0,  0},   // 8959
    {  2,  5,  7,  0,  0,  0},   // 8960
    {  3, 29,103,  0,  0,  0},   // 8961
    {  2,4481,  0,  0,  0,  0},   // 8962
    {  0,  0,  0,  0,  0,  0},   // 8963
    {  2,  3, 83,  0,  0,  0},   // 8964
    {  5, 11,163,  0,  0,  0},   // 8965
    {  2,4483,  0,  0,  0,  0},   // 8966
    {  3,  7, 61,  0,  0,  0},   // 8967
    {  2, 19, 59,  0,  0,  0},   // 8968
    {  0,  0,  0,  0,  0,  0},   // 8969
    {  2,  3,  5, 13, 23,  0},   // 8970
    {  0,  0,  0,  0,  0,  0},   // 8971
    {  2,2243,  0,  0,  0,  0},   // 8972
    {  3,997,  0,  0,  0,  0},   // 8973
    {  2,  7,641,  0,  0,  0},   // 8974
    {  5,359,  0,  0,  0,  0},   // 8975
    {  2,  3, 11, 17,  0,  0},   // 8976
    { 47,191,  0,  0,  0,  0},   // 8977
    {  2, 67,  0,  0,  0,  0},   // 8978
    {  3, 41, 73,  0,  0,  0},   // 8979
    {  2,  5,449,  0,  0,  0},   // 8980
    {  7,1283,  0,  0,  0,  0},   // 8981
    {  2,  3,499,  0,  0,  0},   // 8982
    { 13,691,  0,  0,  0,  0},   // 8983
    {  2,1123,  0,  0,  0,  0},   // 8984
    {  3,  5,599,  0,  0,  0},   // 8985
    {  2,4493,  0,  0,  0,  0},   // 8986
    { 11, 19, 43,  0,  0,  0},   // 8987
    {  2,  3,  7,107,  0,  0},   // 8988
    { 89,101,  0,  0,  0,  0},   // 8989
    {  2,  5, 29, 31,  0,  0},   // 8990
    {  3, 37,  0,  0,  0,  0},   // 8991
    {  2,281,  0,  0,  0,  0},   // 8992
    { 17, 23,  0,  0,  0,  0},   // 8993
    {  2,  3,1499,  0,  0,  0},   // 8994
    {  5,  7,257,  0,  0,  0},   // 8995
    {  2, 13,173,  0,  0,  0},   // 8996
    {  3,2999,  0,  0,  0,  0},   // 8997
    {  2, 11,409,  0,  0,  0},   // 8998
    {  0,  0,  0,  0,  0,  0},   // 8999
    {  2,  3,  5,  0,  0,  0},   // 9000
    {  0,  0,  0,  0,  0,  0},   // 9001
    {  2,  7,643,  0,  0,  0},   // 9002
    {  3,3001,  0,  0,  0,  0},   // 9003
    {  2,2251,  0,  0,  0,  0},   // 9004
    {  5,1801,  0,  0,  0,  0},   // 9005
    {  2,  3, 19, 79,  0,  0},   // 9006
    {  0,  0,  0,  0,  0,  0},   // 9007
    {  2,563,  0,  0,  0,  0},   // 9008
    {  3,  7, 11, 13,  0,  0},   // 9009
    {  2,  5, 17, 53,  0,  0},   // 9010
    {  0,  0,  0,  0,  0,  0},   // 9011
    {  2,  3,751,  0,  0,  0},   // 9012
    {  0,  0,  0,  0,  0,  0},   // 9013
    {  2,4507,  0,  0,  0,  0},   // 9014
    {  3,  5,601,  0,  0,  0},   // 9015
    {  2,  7, 23,  0,  0,  0},   // 9016
    { 71,127,  0,  0,  0,  0},   // 9017
    {  2,  3,167,  0,  0,  0},   // 9018
    { 29,311,  0,  0,  0,  0},   // 9019
    {  2,  5, 11, 41,  0,  0},   // 9020
    {  3, 31, 97,  0,  0,  0},   // 9021
    {  2, 13,347,  0,  0,  0},   // 9022
    {  7,1289,  0,  0,  0,  0},   // 9023
    {  2,  3, 47,  0,  0,  0},   // 9024
    {  5, 19,  0,  0,  0,  0},   // 9025
    {  2,4513,  0,  0,  0,  0},   // 9026
    {  3, 17, 59,  0,  0,  0},   // 9027
    {  2, 37, 61,  0,  0,  0},   // 9028
    {  0,  0,  0,  0,  0,  0},   // 9029
    {  2,  3,  5,  7, 43,  0},   // 9030
    { 11,821,  0,  0,  0,  0},   // 9031
    {  2,1129,  0,  0,  0,  0},   // 9032
    {  3,3011,  0,  0,  0,  0},   // 9033
    {  2,4517,  0,  0,  0,  0},   // 9034
    {  5, 13,139,  0,  0,  0},   // 9035
    {  2,  3,251,  0,  0,  0},   // 9036
    {  7,1291,  0,  0,  0,  0},   // 9037
    {  2,4519,  0,  0,  0,  0},   // 9038
    {  3, 23,131,  0,  0,  0},   // 9039
    {  2,  5,113,  0,  0,  0},   // 9040
    {  0,  0,  0,  0,  0,  0},   // 9041
    {  2,  3, 11,137,  0,  0},   // 9042
    {  0,  0,  0,  0,  0,  0},   // 9043
    {  2,  7, 17, 19,  0,  0},   // 9044
    {  3,  5, 67,  0,  0,  0},   // 9045
    {  2,4523,  0,  0,  0,  0},   // 9046
    { 83,109,  0,  0,  0,  0},   // 9047
    {  2,  3, 13, 29,  0,  0},   // 9048
    {  0,  0,  0,  0,  0,  0},   // 9049
    {  2,  5,181,  0,  0,  0},   // 9050
    {  3,  7,431,  0,  0,  0},   // 9051
    {  2, 31, 73,  0,  0,  0},   // 9052
    { 11,823,  0,  0,  0,  0},   // 9053
    {  2,  3,503,  0,  0,  0},   // 9054
    {  5,1811,  0,  0,  0,  0},   // 9055
    {  2,283,  0,  0,  0,  0},   // 9056
    {  3,3019,  0,  0,  0,  0},   // 9057
    {  2,  7,647,  0,  0,  0},   // 9058
    {  0,  0,  0,  0,  0,  0},   // 9059
    {  2,  3,  5,151,  0,  0},   // 9060
    { 13, 17, 41,  0,  0,  0},   // 9061
    {  2, 23,197,  0,  0,  0},   // 9062
    {  3, 19, 53,  0,  0,  0},   // 9063
    {  2, 11,103,  0,  0,  0},   // 9064
    {  5,  7, 37,  0,  0,  0},   // 9065
    {  2,  3,1511,  0,  0,  0},   // 9066
    {  0,  0,  0,  0,  0,  0},   // 9067
    {  2,2267,  0,  0,  0,  0},   // 9068
    {  3,3023,  0,  0,  0,  0},   // 9069
    {  2,  5,907,  0,  0,  0},   // 9070
    { 47,193,  0,  0,  0,  0},   // 9071
    {  2,  3,  7,  0,  0,  0},   // 9072
    { 43,211,  0,  0,  0,  0},   // 9073
    {  2, 13,349,  0,  0,  0},   // 9074
    {  3,  5, 11,  0,  0,  0},   // 9075
    {  2,2269,  0,  0,  0,  0},   // 9076
    { 29,313,  0,  0,  0,  0},   // 9077
    {  2,  3, 17, 89,  0,  0},   // 9078
    {  7,1297,  0,  0,  0,  0},   // 9079
    {  2,  5,227,  0,  0,  0},   // 9080
    {  3,1009,  0,  0,  0,  0},   // 9081
    {  2, 19,239,  0,  0,  0},   // 9082
    { 31,293,  0,  0,  0,  0},   // 9083
    {  2,  3,757,  0,  0,  0},   // 9084
    {  5, 23, 79,  0,  0,  0},   // 9085
    {  2,  7, 11, 59,  0,  0},   // 9086
    {  3, 13,233,  0,  0,  0},   // 9087
    {  2, 71,  0,  0,  0,  0},   // 9088
    { 61,149,  0,  0,  0,  0},   // 9089
    {  2,  3,  5,101,  0,  0},   // 9090
    {  0,  0,  0,  0,  0,  0},   // 9091
    {  2,2273,  0,  0,  0,  0},   // 9092
    {  3,  7,433,  0,  0,  0},   // 9093
    {  2,4547,  0,  0,  0,  0},   // 9094
    {  5, 17,107,  0,  0,  0},   // 9095
    {  2,  3,379,  0,  0,  0},   // 9096
    { 11,827,  0,  0,  0,  0},   // 9097
    {  2,4549,  0,  0,  0,  0},   // 9098
    {  3,337,  0,  0,  0,  0},   // 9099
    {  2,  5,  7, 13,  0,  0},   // 9100
    { 19,479,  0,  0,  0,  0},   // 9101
    {  2,  3, 37, 41,  0,  0},   // 9102
    {  0,  0,  0,  0,  0,  0},   // 9103
    {  2,569,  0,  0,  0,  0},   // 9104
    {  3,  5,607,  0,  0,  0},   // 9105
    {  2, 29,157,  0,  0,  0},   // 9106
    {  7,1301,  0,  0,  0,  0},   // 9107
    {  2,  3, 11, 23,  0,  0},   // 9108
    {  0,  0,  0,  0,  0,  0},   // 9109
    {  2,  5,911,  0,  0,  0},   // 9110
    {  3,3037,  0,  0,  0,  0},   // 9111
    {  2, 17, 67,  0,  0,  0},   // 9112
    { 13,701,  0,  0,  0,  0},   // 9113
    {  2,  3,  7, 31,  0,  0},   // 9114
    {  5,1823,  0,  0,  0,  0},   // 9115
    {  2, 43, 53,  0,  0,  0},   // 9116
    {  3,1013,  0,  0,  0,  0},   // 9117
    {  2, 47, 97,  0,  0,  0},   // 9118
    { 11,829,  0,  0,  0,  0},   // 9119
    {  2,  3,  5, 19,  0,  0},   // 9120
    {  7,1303,  0,  0,  0,  0},   // 9121
    {  2,4561,  0,  0,  0,  0},   // 9122
    {  3,3041,  0,  0,  0,  0},   // 9123
    {  2,2281,  0,  0,  0,  0},   // 9124
    {  5, 73,  0,  0,  0,  0},   // 9125
    {  2,  3, 13,  0,  0,  0},   // 9126
    {  0,  0,  0,  0,  0,  0},   // 9127
    {  2,  7,163,  0,  0,  0},   // 9128
    {  3, 17,179,  0,  0,  0},   // 9129
    {  2,  5, 11, 83,  0,  0},   // 9130
    { 23,397,  0,  0,  0,  0},   // 9131
    {  2,  3,761,  0,  0,  0},   // 9132
    {  0,  0,  0,  0,  0,  0},   // 9133
    {  2,4567,  0,  0,  0,  0},   // 9134
    {  3,  5,  7, 29,  0,  0},   // 9135
    {  2,571,  0,  0,  0,  0},   // 9136
    {  0,  0,  0,  0,  0,  0},   // 9137
    {  2,  3,1523,  0,  0,  0},   // 9138
    { 13, 19, 37,  0,  0,  0},   // 9139
    {  2,  5,457,  0,  0,  0},   // 9140
    {  3, 11,277,  0,  0,  0},   // 9141
    {  2,  7,653,  0,  0,  0},   // 9142
    { 41,223,  0,  0,  0,  0},   // 9143
    {  2,  3,127,  0,  0,  0},   // 9144
    {  5, 31, 59,  0,  0,  0},   // 9145
    {  2, 17,269,  0,  0,  0},   // 9146
    {  3,3049,  0,  0,  0,  0},   // 9147
    {  2,2287,  0,  0,  0,  0},   // 9148
    {  7,1307,  0,  0,  0,  0},   // 9149
    {  2,  3,  5, 61,  0,  0},   // 9150
    {  0,  0,  0,  0,  0,  0},   // 9151
    {  2, 11, 13,  0,  0,  0},   // 9152
    {  3,113,  0,  0,  0,  0},   // 9153
    {  2, 23,199,  0,  0,  0},   // 9154
    {  5,1831,  0,  0,  0,  0},   // 9155
    {  2,  3,  7,109,  0,  0},   // 9156
    {  0,  0,  0,  0,  0,  0},   // 9157
    {  2, 19,241,  0,  0,  0},   // 9158
    {  3, 43, 71,  0,  0,  0},   // 9159
    {  2,  5,229,  0,  0,  0},   // 9160
    {  0,  0,  0,  0,  0,  0},   // 9161
    {  2,  3,509,  0,  0,  0},   // 9162
    {  7, 11, 17,  0,  0,  0},   // 9163
    {  2, 29, 79,  0,  0,  0},   // 9164
    {  3,  5, 13, 47,  0,  0},   // 9165
    {  2,4583,  0,  0,  0,  0},   // 9166
    { 89,103,  0,  0,  0,  0},   // 9167
    {  2,  3,191,  0,  0,  0},   // 9168
    { 53,173,  0,  0,  0,  0},   // 9169
    {  2,  5,  7,131,  0,  0},   // 9170
    {  3,1019,  0,  0,  0,  0},   // 9171
    {  2,2293,  0,  0,  0,  0},   // 9172
    {  0,  0,  0,  0,  0,  0},   // 9173
    {  2,  3, 11,139,  0,  0},   // 9174
    {  5,367,  0,  0,  0,  0},   // 9175
    {  2, 31, 37,  0,  0,  0},   // 9176
    {  3,  7, 19, 23,  0,  0},   // 9177
    {  2, 13,353,  0,  0,  0},   // 9178
    { 67,137,  0,  0,  0,  0},   // 9179
    {  2,  3,  5, 17,  0,  0},   // 9180
    {  0,  0,  0,  0,  0,  0},   // 9181
    {  2,4591,  0,  0,  0,  0},   // 9182
    {  3,3061,  0,  0,  0,  0},   // 9183
    {  2,  7, 41,  0,  0,  0},   // 9184
    {  5, 11,167,  0,  0,  0},   // 9185
    {  2,  3,1531,  0,  0,  0},   // 9186
    {  0,  0,  0,  0,  0,  0},   // 9187
    {  2,2297,  0,  0,  0,  0},   // 9188
    {  3,1021,  0,  0,  0,  0},   // 9189
    {  2,  5,919,  0,  0,  0},   // 9190
    {  7, 13,101,  0,  0,  0},   // 9191
    {  2,  3,383,  0,  0,  0},   // 9192
    { 29,317,  0,  0,  0,  0},   // 9193
    {  2,4597,  0,  0,  0,  0},   // 9194
    {  3,  5,613,  0,  0,  0},   // 9195
    {  2, 11, 19,  0,  0,  0},   // 9196
    { 17,541,  0,  0,  0,  0},   // 9197
    {  2,  3,  7, 73,  0,  0},   // 9198
    {  0,  0,  0,  0,  0,  0},   // 9199
    {  2,  5, 23,  0,  0,  0},   // 9200
    {  3,3067,  0,  0,  0,  0},   // 9201
    {  2, 43,107,  0,  0,  0},   // 9202
    {  0,  0,  0,  0,  0,  0},   // 9203
    {  2,  3, 13, 59,  0,  0},   // 9204
    {  5,  7,263,  0,  0,  0},   // 9205
    {  2,4603,  0,  0,  0,  0},   // 9206
    {  3, 11, 31,  0,  0,  0},   // 9207
    {  2,1151,  0,  0,  0,  0},   // 9208
    {  0,  0,  0,  0,  0,  0},   // 9209
    {  2,  3,  5,307,  0,  0},   // 9210
    { 61,151,  0,  0,  0,  0},   // 9211
    {  2,  7, 47,  0,  0,  0},   // 9212
    {  3, 37, 83,  0,  0,  0},   // 9213
    {  2, 17,271,  0,  0,  0},   // 9214
    {  5, 19, 97,  0,  0,  0},   // 9215
    {  2,  3,  0,  0,  0,  0},   // 9216
    { 13,709,  0,  0,  0,  0},   // 9217
    {  2, 11,419,  0,  0,  0},   // 9218
    {  3,  7,439,  0,  0,  0},   // 9219
    {  2,  5,461,  0,  0,  0},   // 9220
    {  0,  0,  0,  0,  0,  0},   // 9221
    {  2,  3, 29, 53,  0,  0},   // 9222
    { 23,401,  0,  0,  0,  0},   // 9223
    {  2,1153,  0,  0,  0,  0},   // 9224
    {  3,  5, 41,  0,  0,  0},   // 9225
    {  2,  7,659,  0,  0,  0},   // 9226
    {  0,  0,  0,  0,  0,  0},   // 9227
    {  2,  3,769,  0,  0,  0},   // 9228
    { 11,839,  0,  0,  0,  0},   // 9229
    {  2,  5, 13, 71,  0,  0},   // 9230
    {  3, 17,181,  0,  0,  0},   // 9231
    {  2,577,  0,  0,  0,  0},   // 9232
    {  7,1319,  0,  0,  0,  0},   // 9233
    {  2,  3, 19,  0,  0,  0},   // 9234
    {  5,1847,  0,  0,  0,  0},   // 9235
    {  2,2309,  0,  0,  0,  0},   // 9236
    {  3,3079,  0,  0,  0,  0},   // 9237
    {  2, 31,149,  0,  0,  0},   // 9238
    {  0,  0,  0,  0,  0,  0},   // 9239
    {  2,  3,  5,  7, 11,  0},   // 9240
    {  0,  0,  0,  0,  0,  0},   // 9241
    {  2,4621,  0,  0,  0,  0},   // 9242
    {  3, 13, 79,  0,  0,  0},   // 9243
    {  2,2311,  0,  0,  0,  0},   // 9244
    {  5, 43,  0,  0,  0,  0},   // 9245
    {  2,  3, 23, 67,  0,  0},   // 9246
    {  7,1321,  0,  0,  0,  0},   // 9247
    {  2, 17,  0,  0,  0,  0},   // 9248
    {  3,3083,  0,  0,  0,  0},   // 9249
    {  2,  5, 37,  0,  0,  0},   // 9250
    { 11, 29,  0,  0,  0,  0},   // 9251
    {  2,  3,257,  0,  0,  0},   // 9252
    { 19,487,  0,  0,  0,  0},   // 9253
    {  2,  7,661,  0,  0,  0},   // 9254
    {  3,  5,617,  0,  0,  0},   // 9255
    {  2, 13, 89,  0,  0,  0},   // 9256
    {  0,  0,  0,  0,  0,  0},   // 9257
    {  2,  3,1543,  0,  0,  0},   // 9258
    { 47,197,  0,  0,  0,  0},   // 9259
    {  2,  5,463,  0,  0,  0},   // 9260
    {  3,  7,  0,  0,  0,  0},   // 9261
    {  2, 11,421,  0,  0,  0},   // 9262
    { 59,157,  0,  0,  0,  0},   // 9263
    {  2,  3,193,  0,  0,  0},   // 9264
    {  5, 17,109,  0,  0,  0},   // 9265
    {  2, 41,113,  0,  0,  0},   // 9266
    {  3,3089,  0,  0,  0,  0},   // 9267
    {  2,  7,331,  0,  0,  0},   // 9268
    { 13, 23, 31,  0,  0,  0},   // 9269
    {  2,  3,  5,103,  0,  0},   // 9270
    { 73,127,  0,  0,  0,  0},   // 9271
    {  2, 19, 61,  0,  0,  0},   // 9272
    {  3, 11,281,  0,  0,  0},   // 9273
    {  2,4637,  0,  0,  0,  0},   // 9274
    {  5,  7, 53,  0,  0,  0},   // 9275
    {  2,  3,773,  0,  0,  0},   // 9276
    {  0,  0,  0,  0,  0,  0},   // 9277
    {  2,4639,  0,  0,  0,  0},   // 9278
    {  3,1031,  0,  0,  0,  0},   // 9279
    {  2,  5, 29,  0,  0,  0},   // 9280
    {  0,  0,  0,  0,  0,  0},   // 9281
    {  2,  3,  7, 13, 17,  0},   // 9282
    {  0,  0,  0,  0,  0,  0},   // 9283
    {  2, 11,211,  0,  0,  0},   // 9284
    {  3,  5,619,  0,  0,  0},   // 9285
    {  2,4643,  0,  0,  0,  0},   // 9286
    { 37,251,  0,  0,  0,  0},   // 9287
    {  2,  3, 43,  0,  0,  0},   // 9288
    {  7,1327,  0,  0,  0,  0},   // 9289
    {  2,  5,929,  0,  0,  0},   // 9290
    {  3, 19,163,  0,  0,  0},   // 9291
    {  2, 23,101,  0,  0,  0},   // 9292
    {  0,  0,  0,  0,  0,  0},   // 9293
    {  2,  3,1549,  0,  0,  0},   // 9294
    {  5, 11, 13,  0,  0,  0},   // 9295
    {  2,  7, 83,  0,  0,  0},   // 9296
    {  3,1033,  0,  0,  0,  0},   // 9297
    {  2,4649,  0,  0,  0,  0},   // 9298
    { 17,547,  0,  0,  0,  0},   // 9299
    {  2,  3,  5, 31,  0,  0},   // 9300
    { 71,131,  0,  0,  0,  0},   // 9301
    {  2,4651,  0,  0,  0,  0},   // 9302
    {  3,  7,443,  0,  0,  0},   // 9303
    {  2,1163,  0,  0,  0,  0},   // 9304
    {  5,1861,  0,  0,  0,  0},   // 9305
    {  2,  3, 11, 47,  0,  0},   // 9306
    { 41,227,  0,  0,  0,  0},   // 9307
    {  2, 13,179,  0,  0,  0},   // 9308
    {  3, 29,107,  0,  0,  0},   // 9309
    {  2,  5,  7, 19,  0,  0},   // 9310
    {  0,  0,  0,  0,  0,  0},   // 9311
    {  2,  3, 97,  0,  0,  0},   // 9312
    { 67,139,  0,  0,  0,  0},   // 9313
    {  2,4657,  0,  0,  0,  0},   // 9314
    {  3,  5, 23,  0,  0,  0},   // 9315
    {  2, 17,137,  0,  0,  0},   // 9316
    {  7, 11,  0,  0,  0,  0},   // 9317
    {  2,  3,1553,  0,  0,  0},   // 9318
    {  0,  0,  0,  0,  0,  0},   // 9319
    {  2,  5,233,  0,  0,  0},   // 9320
    {  3, 13,239,  0,  0,  0},   // 9321
    {  2, 59, 79,  0,  0,  0},   // 9322
    {  0,  0,  0,  0,  0,  0},   // 9323
    {  2,  3,  7, 37,  0,  0},   // 9324
    {  5,373,  0,  0,  0,  0},   // 9325
    {  2,4663,  0,  0,  0,  0},   // 9326
    {  3,3109,  0,  0,  0,  0},   // 9327
    {  2, 11, 53,  0,  0,  0},   // 9328
    { 19,491,  0,  0,  0,  0},   // 9329
    {  2,  3,  5,311,  0,  0},   // 9330
    {  7, 31, 43,  0,  0,  0},   // 9331
    {  2,2333,  0,  0,  0,  0},   // 9332
    {  3, 17, 61,  0,  0,  0},   // 9333
    {  2, 13,359,  0,  0,  0},   // 9334
    {  5,1867,  0,  0,  0,  0},   // 9335
    {  2,  3,389,  0,  0,  0},   // 9336
    {  0,  0,  0,  0,  0,  0},   // 9337
    {  2,  7, 23, 29,  0,  0},   // 9338
    {  3, 11,283,  0,  0,  0},   // 9339
    {  2,  5,467,  0,  0,  0},   // 9340
    {  0,  0,  0,  0,  0,  0},   // 9341
    {  2,  3,173,  0,  0,  0},   // 9342
    {  0,  0,  0,  0,  0,  0},   // 9343
    {  2, 73,  0,  0,  0,  0},   // 9344
    {  3,  5,  7, 89,  0,  0},   // 9345
    {  2,4673,  0,  0,  0,  0},   // 9346
    { 13,719,  0,  0,  0,  0},   // 9347
    {  2,  3, 19, 41,  0,  0},   // 9348
    {  0,  0,  0,  0,  0,  0},   // 9349
    {  2,  5, 11, 17,  0,  0},   // 9350
    {  3,1039,  0,  0,  0,  0},   // 9351
    {  2,  7,167,  0,  0,  0},   // 9352
    { 47,199,  0,  0,  0,  0},   // 9353
    {  2,  3,1559,  0,  0,  0},   // 9354
    {  5,1871,  0,  0,  0,  0},   // 9355
    {  2,2339,  0,  0,  0,  0},   // 9356
    {  3,3119,  0,  0,  0,  0},   // 9357
    {  2,4679,  0,  0,  0,  0},   // 9358
    {  7,191,  0,  0,  0,  0},   // 9359
    {  2,  3,  5, 13,  0,  0},   // 9360
    { 11, 23, 37,  0,  0,  0},   // 9361
    {  2, 31,151,  0,  0,  0},   // 9362
    {  3,3121,  0,  0,  0,  0},   // 9363
    {  2,2341,  0,  0,  0,  0},   // 9364
    {  5,1873,  0,  0,  0,  0},   // 9365
    {  2,  3,  7,223,  0,  0},   // 9366
    { 17, 19, 29,  0,  0,  0},   // 9367
    {  2,1171,  0,  0,  0,  0},   // 9368
    {  3,347,  0,  0,  0,  0},   // 9369
    {  2,  5,937,  0,  0,  0},   // 9370
    {  0,  0,  0,  0,  0,  0},   // 9371
    {  2,  3, 11, 71,  0,  0},   // 9372
    {  7, 13,103,  0,  0,  0},   // 9373
    {  2, 43,109,  0,  0,  0},   // 9374
    {  3,  5,  0,  0,  0,  0},   // 9375
    {  2,293,  0,  0,  0,  0},   // 9376
    {  0,  0,  0,  0,  0,  0},   // 9377
    {  2,  3,521,  0,  0,  0},   // 9378
    { 83,113,  0,  0,  0,  0},   // 9379
    {  2,  5,  7, 67,  0,  0},   // 9380
    {  3, 53, 59,  0,  0,  0},   // 9381
    {  2,4691,  0,  0,  0,  0},   // 9382
    { 11,853,  0,  0,  0,  0},   // 9383
    {  2,  3, 17, 23,  0,  0},   // 9384
    {  5,1877,  0,  0,  0,  0},   // 9385
    {  2, 13, 19,  0,  0,  0},   // 9386
    {  3,  7,149,  0,  0,  0},   // 9387
    {  2,2347,  0,  0,  0,  0},   // 9388
    { 41,229,  0,  0,  0,  0},   // 9389
    {  2,  3,  5,313,  0,  0},   // 9390
    {  0,  0,  0,  0,  0,  0},   // 9391
    {  2,587,  0,  0,  0,  0},   // 9392
    {  3, 31,101,  0,  0,  0},   // 9393
    {  2,  7, 11, 61,  0,  0},   // 9394
    {  5,1879,  0,  0,  0,  0},   // 9395
    {  2,  3, 29,  0,  0,  0},   // 9396
    {  0,  0,  0,  0,  0,  0},   // 9397
    {  2, 37,127,  0,  0,  0},   // 9398
    {  3, 13,241,  0,  0,  0},   // 9399
    {  2,  5, 47,  0,  0,  0},   // 9400
    {  7, 17, 79,  0,  0,  0},   // 9401
    {  2,  3,1567,  0,  0,  0},   // 9402
    {  0,  0,  0,  0,  0,  0},   // 9403
    {  2,2351,  0,  0,  0,  0},   // 9404
    {  3,  5, 11, 19,  0,  0},   // 9405
    {  2,4703,  0,  0,  0,  0},   // 9406
    { 23,409,  0,  0,  0,  0},   // 9407
    {  2,  3,  7,  0,  0,  0},   // 9408
    { 97,  0,  0,  0,  0,  0},   // 9409
    {  2,  5,941,  0,  0,  0},   // 9410
    {  3,3137,  0,  0,  0,  0},   // 9411
    {  2, 13,181,  0,  0,  0},   // 9412
    {  0,  0,  0,  0,  0,  0},   // 9413
    {  2,  3,523,  0,  0,  0},   // 9414
    {  5,  7,269,  0,  0,  0},   // 9415
    {  2, 11,107,  0,  0,  0},   // 9416
    {  3, 43, 73,  0,  0,  0},   // 9417
    {  2, 17,277,  0,  0,  0},   // 9418
    {  0,  0,  0,  0,  0,  0},   // 9419
    {  2,  3,  5,157,  0,  0},   // 9420
    {  0,  0,  0,  0,  0,  0},   // 9421
    {  2,  7,673,  0,  0,  0},   // 9422
    {  3,349,  0,  0,  0,  0},   // 9423
    {  2, 19, 31,  0,  0,  0},   // 9424
    {  5, 13, 29,  0,  0,  0},   // 9425
    {  2,  3,1571,  0,  0,  0},   // 9426
    { 11,857,  0,  0,  0,  0},   // 9427
    {  2,2357,  0,  0,  0,  0},   // 9428
    {  3,  7,449,  0,  0,  0},   // 9429
    {  2,  5, 23, 41,  0,  0},   // 9430
    {  0,  0,  0,  0,  0,  0},   // 9431
    {  2,  3,131,  0,  0,  0},   // 9432
    {  0,  0,  0,  0,  0,  0},   // 9433
    {  2, 53, 89,  0,  0,  0},   // 9434
    {  3,  5, 17, 37,  0,  0},   // 9435
    {  2,  7,337,  0,  0,  0},   // 9436
    {  0,  0,  0,  0,  0,  0},   // 9437
    {  2,  3, 11, 13,  0,  0},   // 9438
    {  0,  0,  0,  0,  0,  0},   // 9439
    {  2,  5, 59,  0,  0,  0},   // 9440
    {  3,1049,  0,  0,  0,  0},   // 9441
    {  2,4721,  0,  0,  0,  0},   // 9442
    {  7, 19, 71,  0,  0,  0},   // 9443
    {  2,  3,787,  0,  0,  0},   // 9444
    {  5,1889,  0,  0,  0,  0},   // 9445
    {  2,4723,  0,  0,  0,  0},   // 9446
    {  3, 47, 67,  0,  0,  0},   // 9447
    {  2,1181,  0,  0,  0,  0},   // 9448
    { 11,859,  0,  0,  0,  0},   // 9449
    {  2,  3,  5,  7,  0,  0},   // 9450
    { 13,727,  0,  0,  0,  0},   // 9451
    {  2, 17,139,  0,  0,  0},   // 9452
    {  3, 23,137,  0,  0,  0},   // 9453
    {  2, 29,163,  0,  0,  0},   // 9454
    {  5, 31, 61,  0,  0,  0},   // 9455
    {  2,  3,197,  0,  0,  0},   // 9456
    {  7,193,  0,  0,  0,  0},   // 9457
    {  2,4729,  0,  0,  0,  0},   // 9458
    {  3,1051,  0,  0,  0,  0},   // 9459
    {  2,  5, 11, 43,  0,  0},   // 9460
    {  0,  0,  0,  0,  0,  0},   // 9461
    {  2,  3, 19, 83,  0,  0},   // 9462
    {  0,  0,  0,  0,  0,  0},   // 9463
    {  2,  7, 13,  0,  0,  0},   // 9464
    {  3,  5,631,  0,  0,  0},   // 9465
    {  2,4733,  0,  0,  0,  0},   // 9466
    {  0,  0,  0,  0,  0,  0},   // 9467
    {  2,  3,263,  0,  0,  0},   // 9468
    { 17,557,  0,  0,  0,  0},   // 9469
    {  2,  5,947,  0,  0,  0},   // 9470
    {  3,  7, 11, 41,  0,  0},   // 9471
    {  2, 37,  0,  0,  0,  0},   // 9472
    {  0,  0,  0,  0,  0,  0},   // 9473
    {  2,  3,1579,  0,  0,  0},   // 9474
    {  5,379,  0,  0,  0,  0},   // 9475
    {  2, 23,103,  0,  0,  0},   // 9476
    {  3, 13,  0,  0,  0,  0},   // 9477
    {  2,  7,677,  0,  0,  0},   // 9478
    {  0,  0,  0,  0,  0,  0},   // 9479
    {  2,  3,  5, 79,  0,  0},   // 9480
    { 19,499,  0,  0,  0,  0},   // 9481
    {  2, 11,431,  0,  0,  0},   // 9482
    {  3, 29,109,  0,  0,  0},   // 9483
    {  2,2371,  0,  0,  0,  0},   // 9484
    {  5,  7,271,  0,  0,  0},   // 9485
    {  2,  3, 17, 31,  0,  0},   // 9486
    { 53,179,  0,  0,  0,  0},   // 9487
    {  2,593,  0,  0,  0,  0},   // 9488
    {  3,3163,  0,  0,  0,  0},   // 9489
    {  2,  5, 13, 73,  0,  0},   // 9490
    {  0,  0,  0,  0,  0,  0},   // 9491
    {  2,  3,  7,113,  0,  0},   // 9492
    { 11,863,  0,  0,  0,  0},   // 9493
    {  2, 47,101,  0,  0,  0},   // 9494
    {  3,  5,211,  0,  0,  0},   // 9495
    {  2,1187,  0,  0,  0,  0},   // 9496
    {  0,  0,  0,  0,  0,  0},   // 9497
    {  2,  3,1583,  0,  0,  0},   // 9498
    {  7, 23, 59,  0,  0,  0},   // 9499
    {  2,  5, 19,  0,  0,  0},   // 9500
    {  3,3167,  0,  0,  0,  0},   // 9501
    {  2,4751,  0,  0,  0,  0},   // 9502
    { 13, 17, 43,  0,  0,  0},   // 9503
    {  2,  3, 11,  0,  0,  0},   // 9504
    {  5,1901,  0,  0,  0,  0},   // 9505
    {  2,  7, 97,  0,  0,  0},   // 9506
    {  3,3169,  0,  0,  0,  0},   // 9507
    {  2,2377,  0,  0,  0,  0},   // 9508
    { 37,257,  0,  0,  0,  0},   // 9509
    {  2,  3,  5,317,  0,  0},   // 9510
    {  0,  0,  0,  0,  0,  0},   // 9511
    {  2, 29, 41,  0,  0,  0},   // 9512
    {  3,  7,151,  0,  0,  0},   // 9513
    {  2, 67, 71,  0,  0,  0},   // 9514
    {  5, 11,173,  0,  0,  0},   // 9515
    {  2,  3, 13, 61,  0,  0},   // 9516
    { 31,307,  0,  0,  0,  0},   // 9517
    {  2,4759,  0,  0,  0,  0},   // 9518
    {  3, 19,167,  0,  0,  0},   // 9519
    {  2,  5,  7, 17,  0,  0},   // 9520
    {  0,  0,  0,  0,  0,  0},   // 9521
    {  2,  3, 23,  0,  0,  0},   // 9522
    { 89,107,  0,  0,  0,  0},   // 9523
    {  2,2381,  0,  0,  0,  0},   // 9524
    {  3,  5,127,  0,  0,  0},   // 9525
    {  2, 11,433,  0,  0,  0},   // 9526
    {  7,1361,  0,  0,  0,  0},   // 9527
    {  2,  3,397,  0,  0,  0},   // 9528
    { 13,733,  0,  0,  0,  0},   // 9529
    {  2,  5,953,  0,  0,  0},   // 9530
    {  3,353,  0,  0,  0,  0},   // 9531
    {  2,2383,  0,  0,  0,  0},   // 9532
    {  0,  0,  0,  0,  0,  0},   // 9533
    {  2,  3,  7,227,  0,  0},   // 9534
    {  5,1907,  0,  0,  0,  0},   // 9535
    {  2,149,  0,  0,  0,  0},   // 9536
    {  3, 11, 17,  0,  0,  0},   // 9537
    {  2, 19,251,  0,  0,  0},   // 9538
    {  0,  0,  0,  0,  0,  0},   // 9539
    {  2,  3,  5, 53,  0,  0},   // 9540
    {  7, 29, 47,  0,  0,  0},   // 9541
    {  2, 13,367,  0,  0,  0},   // 9542
    {  3,3181,  0,  0,  0,  0},   // 9543
    {  2,1193,  0,  0,  0,  0},   // 9544
    {  5, 23, 83,  0,  0,  0},   // 9545
    {  2,  3, 37, 43,  0,  0},   // 9546
    {  0,  0,  0,  0,  0,  0},   // 9547
    {  2,  7, 11, 31,  0,  0},   // 9548
    {  3,1061,  0,  0,  0,  0},   // 9549
    {  2,  5,191,  0,  0,  0},   // 9550
    {  0,  0,  0,  0,  0,  0},   // 9551
    {  2,  3,199,  0,  0,  0},   // 9552
    { 41,233,  0,  0,  0,  0},   // 9553
    {  2, 17,281,  0,  0,  0},   // 9554
    {  3,  5,  7, 13,  0,  0},   // 9555
    {  2,2389,  0,  0,  0,  0},   // 9556
    { 19,503,  0,  0,  0,  0},   // 9557
    {  2,  3, 59,  0,  0,  0},   // 9558
    { 11, 79,  0,  0,  0,  0},   // 9559
    {  2,  5,239,  0,  0,  0},   // 9560
    {  3,3187,  0,  0,  0,  0},   // 9561
    {  2,  7,683,  0,  0,  0},   // 9562
    { 73,131,  0,  0,  0,  0},   // 9563
    {  2,  3,797,  0,  0,  0},   // 9564
    {  5,1913,  0,  0,  0,  0},   // 9565
    {  2,4783,  0,  0,  0,  0},   // 9566
    {  3,1063,  0,  0,  0,  0},   // 9567
    {  2, 13, 23,  0,  0,  0},   // 9568
    {  7,1367,  0,  0,  0,  0},   // 9569
    {  2,  3,  5, 11, 29,  0},   // 9570
    { 17,563,  0,  0,  0,  0},   // 9571
    {  2,2393,  0,  0,  0,  0},   // 9572
    {  3,3191,  0,  0,  0,  0},   // 9573
    {  2,4787,  0,  0,  0,  0},   // 9574
    {  5,383,  0,  0,  0,  0},   // 9575
    {  2,  3,  7, 19,  0,  0},   // 9576
    { 61,157,  0,  0,  0,  0},   // 9577
    {  2,4789,  0,  0,  0,  0},   // 9578
    {  3, 31,103,  0,  0,  0},   // 9579
    {  2,  5,479,  0,  0,  0},   // 9580
    { 11, 13, 67,  0,  0,  0},   // 9581
    {  2,  3,1597,  0,  0,  0},   // 9582
    {  7, 37,  0,  0,  0,  0},   // 9583
    {  2,599,  0,  0,  0,  0},   // 9584
    {  3,  5, 71,  0,  0,  0},   // 9585
    {  2,4793,  0,  0,  0,  0},   // 9586
    {  0,  0,  0,  0,  0,  0},   // 9587
    {  2,  3, 17, 47,  0,  0},   // 9588
    { 43,223,  0,  0,  0,  0},   // 9589
    {  2,  5,  7,137,  0,  0},   // 9590
    {  3, 23,139,  0,  0,  0},   // 9591
    {  2, 11,109,  0,  0,  0},   // 9592
    { 53,181,  0,  0,  0,  0},   // 9593
    {  2,  3, 13, 41,  0,  0},   // 9594
    {  5, 19,101,  0,  0,  0},   // 9595
    {  2,2399,  0,  0,  0,  0},   // 9596
    {  3,  7,457,  0,  0,  0},   // 9597
    {  2,4799,  0,  0,  0,  0},   // 9598
    { 29,331,  0,  0,  0,  0},   // 9599
    {  2,  3,  5,  0,  0,  0},   // 9600
    {  0,  0,  0,  0,  0,  0},   // 9601
    {  2,4801,  0,  0,  0,  0},   // 9602
    {  3, 11, 97,  0,  0,  0},   // 9603
    {  2,  7,  0,  0,  0,  0},   // 9604
    {  5, 17,113,  0,  0,  0},   // 9605
    {  2,  3,1601,  0,  0,  0},   // 9606
    { 13,739,  0,  0,  0,  0},   // 9607
    {  2,1201,  0,  0,  0,  0},   // 9608
    {  3,3203,  0,  0,  0,  0},   // 9609
    {  2,  5, 31,  0,  0,  0},   // 9610
    {  7,1373,  0,  0,  0,  0},   // 9611
    {  2,  3, 89,  0,  0,  0},   // 9612
    {  0,  0,  0,  0,  0,  0},   // 9613
    {  2, 11, 19, 23,  0,  0},   // 9614
    {  3,  5,641,  0,  0,  0},   // 9615
    {  2,601,  0,  0,  0,  0},   // 9616
    { 59,163,  0,  0,  0,  0},   // 9617
    {  2,  3,  7,229,  0,  0},   // 9618
    {  0,  0,  0,  0,  0,  0},   // 9619
    {  2,  5, 13, 37,  0,  0},   // 9620
    {  3,1069,  0,  0,  0,  0},   // 9621
    {  2, 17,283,  0,  0,  0},   // 9622
    {  0,  0,  0,  0,  0,  0},   // 9623
    {  2,  3,401,  0,  0,  0},   // 9624
    {  5,  7, 11,  0,  0,  0},   // 9625
    {  2,4813,  0,  0,  0,  0},   // 9626
    {  3,3209,  0,  0,  0,  0},   // 9627
    {  2, 29, 83,  0,  0,  0},   // 9628
    {  0,  0,  0,  0,  0,  0},   // 9629
    {  2,  3,  5,107,  0,  0},   // 9630
    {  0,  0,  0,  0,  0,  0},   // 9631
    {  2,  7, 43,  0,  0,  0},   // 9632
    {  3, 13, 19,  0,  0,  0},   // 9633
    {  2,4817,  0,  0,  0,  0},   // 9634
    {  5, 41, 47,  0,  0,  0},   // 9635
    {  2,  3, 11, 73,  0,  0},   // 9636
    { 23,419,  0,  0,  0,  0},   // 9637
    {  2, 61, 79,  0,  0,  0},   // 9638
    {  3,  7, 17,  0,  0,  0},   // 9639
    {  2,  5,241,  0,  0,  0},   // 9640
    { 31,311,  0,  0,  0,  0},   // 9641
    {  2,  3,1607,  0,  0,  0},   // 9642
    {  0,  0,  0,  0,  0,  0},   // 9643
    {  2,2411,  0,  0,  0,  0},   // 9644
    {  3,  5,643,  0,  0,  0},   // 9645
    {  2,  7, 13, 53,  0,  0},   // 9646
    { 11,877,  0,  0,  0,  0},   // 9647
    {  2,  3, 67,  0,  0,  0},   // 9648
    {  0,  0,  0,  0,  0,  0},   // 9649
    {  2,  5,193,  0,  0,  0},   // 9650
    {  3,3217,  0,  0,  0,  0},   // 9651
    {  2, 19,127,  0,  0,  0},   // 9652
    {  7,197,  0,  0,  0,  0},   // 9653
    {  2,  3,1609,  0,  0,  0},   // 9654
    {  5,1931,  0,  0,  0,  0},   // 9655
    {  2, 17, 71,  0,  0,  0},   // 9656
    {  3, 29, 37,  0,  0,  0},   // 9657
    {  2, 11,439,  0,  0,  0},   // 9658
    { 13,743,  0,  0,  0,  0},   // 9659
    {  2,  3,  5,  7, 23,  0},   // 9660
    {  0,  0,  0,  0,  0,  0},   // 9661
    {  2,4831,  0,  0,  0,  0},   // 9662
    {  3,3221,  0,  0,  0,  0},   // 9663
    {  2,151,  0,  0,  0,  0},   // 9664
    {  5,1933,  0,  0,  0,  0},   // 9665
    {  2,  3,179,  0,  0,  0},   // 9666
    {  7,1381,  0,  0,  0,  0},   // 9667
    {  2,2417,  0,  0,  0,  0},   // 9668
    {  3, 11,293,  0,  0,  0},   // 9669
    {  2,  5,967,  0,  0,  0},   // 9670
    { 19,509,  0,  0,  0,  0},   // 9671
    {  2,  3, 13, 31,  0,  0},   // 9672
    { 17,569,  0,  0,  0,  0},   // 9673
    {  2,  7,691,  0,  0,  0},   // 9674
    {  3,  5, 43,  0,  0,  0},   // 9675
    {  2, 41, 59,  0,  0,  0},   // 9676
    {  0,  0,  0,  0,  0,  0},   // 9677
    {  2,  3,1613,  0,  0,  0},   // 9678
    {  0,  0,  0,  0,  0,  0},   // 9679
    {  2,  5, 11,  0,  0,  0},   // 9680
    {  3,  7,461,  0,  0,  0},   // 9681
    {  2, 47,103,  0,  0,  0},   // 9682
    { 23,421,  0,  0,  0,  0},   // 9683
    {  2,  3,269,  0,  0,  0},   // 9684
    {  5, 13,149,  0,  0,  0},   // 9685
    {  2, 29,167,  0,  0,  0},   // 9686
    {  3,3229,  0,  0,  0,  0},   // 9687
    {  2,  7,173,  0,  0,  0},   // 9688
    {  0,  0,  0,  0,  0,  0},   // 9689
    {  2,  3,  5, 17, 19,  0},   // 9690
    { 11,881,  0,  0,  0,  0},   // 9691
    {  2,2423,  0,  0,  0,  0},   // 9692
    {  3,359,  0,  0,  0,  0},   // 9693
    {  2, 37,131,  0,  0,  0},   // 9694
    {  5,  7,277,  0,  0,  0},   // 9695
    {  2,  3,101,  0,  0,  0},   // 9696
    {  0,  0,  0,  0,  0,  0},   // 9697
    {  2, 13,373,  0,  0,  0},   // 9698
    {  3, 53, 61,  0,  0,  0},   // 9699
    {  2,  5, 97,  0,  0,  0},   // 9700
    { 89,109,  0,  0,  0,  0},   // 9701
    {  2,  3,  7, 11,  0,  0},   // 9702
    { 31,313,  0,  0,  0,  0},   // 9703
    {  2,1213,  0,  0,  0,  0},   // 9704
    {  3,  5,647,  0,  0,  0},   // 9705
    {  2, 23,211,  0,  0,  0},   // 9706
    { 17,571,  0,  0,  0,  0},   // 9707
    {  2,  3,809,  0,  0,  0},   // 9708
    {  7, 19, 73,  0,  0,  0},   // 9709
    {  2,  5,971,  0,  0,  0},   // 9710
    {  3, 13, 83,  0,  0,  0},   // 9711
    {  2,607,  0,  0,  0,  0},   // 9712
    { 11,883,  0,  0,  0,  0},   // 9713
    {  2,  3,1619,  0,  0,  0},   // 9714
    {  5, 29, 67,  0,  0,  0},   // 9715
    {  2,  7,347,  0,  0,  0},   // 9716
    {  3, 41, 79,  0,  0,  0},   // 9717
    {  2, 43,113,  0,  0,  0},   // 9718
    {  0,  0,  0,  0,  0,  0},   // 9719
    {  2,  3,  5,  0,  0,  0},   // 9720
    {  0,  0,  0,  0,  0,  0},   // 9721
    {  2,4861,  0,  0,  0,  0},   // 9722
    {  3,  7,463,  0,  0,  0},   // 9723
    {  2, 11, 13, 17,  0,  0},   // 9724
    {  5,389,  0,  0,  0,  0},   // 9725
    {  2,  3,1621,  0,  0,  0},   // 9726
    { 71,137,  0,  0,  0,  0},   // 9727
    {  2, 19,  0,  0,  0,  0},   // 9728
    {  3, 23, 47,  0,  0,  0},   // 9729
    {  2,  5,  7,139,  0,  0},   // 9730
    { 37,263,  0,  0,  0,  0},   // 9731
    {  2,  3,811,  0,  0,  0},   // 9732
    {  0,  0,  0,  0,  0,  0},   // 9733
    {  2, 31,157,  0,  0,  0},   // 9734
    {  3,  5, 11, 59,  0,  0},   // 9735
    {  2,1217,  0,  0,  0,  0},   // 9736
    {  7, 13,107,  0,  0,  0},   // 9737
    {  2,  3,541,  0,  0,  0},   // 9738
    {  0,  0,  0,  0,  0,  0},   // 9739
    {  2,  5,487,  0,  0,  0},   // 9740
    {  3, 17,191,  0,  0,  0},   // 9741
    {  2,4871,  0,  0,  0,  0},   // 9742
    {  0,  0,  0,  0,  0,  0},   // 9743
    {  2,  3,  7, 29,  0,  0},   // 9744
    {  5,1949,  0,  0,  0,  0},   // 9745
    {  2, 11,443,  0,  0,  0},   // 9746
    {  3, 19,  0,  0,  0,  0},   // 9747
    {  2,2437,  0,  0,  0,  0},   // 9748
    {  0,  0,  0,  0,  0,  0},   // 9749
    {  2,  3,  5, 13,  0,  0},   // 9750
    {  7,199,  0,  0,  0,  0},   // 9751
    {  2, 23, 53,  0,  0,  0},   // 9752
    {  3,3251,  0,  0,  0,  0},   // 9753
    {  2,4877,  0,  0,  0,  0},   // 9754
    {  5,1951,  0,  0,  0,  0},   // 9755
    {  2,  3,271,  0,  0,  0},   // 9756
    { 11,887,  0,  0,  0,  0},   // 9757
    {  2,  7, 17, 41,  0,  0},   // 9758
    {  3,3253,  0,  0,  0,  0},   // 9759
    {  2,  5, 61,  0,  0,  0},   // 9760
    { 43,227,  0,  0,  0,  0},   // 9761
    {  2,  3,1627,  0,  0,  0},   // 9762
    { 13,751,  0,  0,  0,  0},   // 9763
    {  2,2441,  0,  0,  0,  0},   // 9764
    {  3,  5,  7, 31,  0,  0},   // 9765
    {  2, 19,257,  0,  0,  0},   // 9766
    {  0,  0,  0,  0,  0,  0},   // 9767
    {  2,  3, 11, 37,  0,  0},   // 9768
    {  0,  0,  0,  0,  0,  0},   // 9769
    {  2,  5,977,  0,  0,  0},   // 9770
    {  3,3257,  0,  0,  0,  0},   // 9771
    {  2,  7,349,  0,  0,  0},   // 9772
    { 29,337,  0,  0,  0,  0},   // 9773
    {  2,  3,181,  0,  0,  0},   // 9774
    {  5, 17, 23,  0,  0,  0},   // 9775
    {  2, 13, 47,  0,  0,  0},   // 9776
    {  3,3259,  0,  0,  0,  0},   // 9777
    {  2,4889,  0,  0,  0,  0},   // 9778
    {  7, 11,127,  0,  0,  0},   // 9779
    {  2,  3,  5,163,  0,  0},   // 9780
    {  0,  0,  0,  0,  0,  0},   // 9781
    {  2, 67, 73,  0,  0,  0},   // 9782
    {  3,1087,  0,  0,  0,  0},   // 9783
    {  2,1223,  0,  0,  0,  0},   // 9784
    {  5, 19,103,  0,  0,  0},   // 9785
    {  2,  3,  7,233,  0,  0},   // 9786
    {  0,  0,  0,  0,  0,  0},   // 9787
    {  2,2447,  0,  0,  0,  0},   // 9788
    {  3, 13,251,  0,  0,  0},   // 9789
    {  2,  5, 11, 89,  0,  0},   // 9790
    {  0,  0,  0,  0,  0,  0},   // 9791
    {  2,  3, 17,  0,  0,  0},   // 9792
    {  7,1399,  0,  0,  0,  0},   // 9793
    {  2, 59, 83,  0,  0,  0},   // 9794
    {  3,  5,653,  0,  0,  0},   // 9795
    {  2, 31, 79,  0,  0,  0},   // 9796
    { 97,101,  0,  0,  0,  0},   // 9797
    {  2,  3, 23, 71,  0,  0},   // 9798
    { 41,239,  0,  0,  0,  0},   // 9799
    {  2,  5,  7,  0,  0,  0},   // 9800
    {  3, 11,  0,  0,  0,  0},   // 9801
    {  2, 13, 29,  0,  0,  0},   // 9802
    {  0,  0,  0,  0,  0,  0},   // 9803
    {  2,  3, 19, 43,  0,  0},   // 9804
    {  5, 37, 53,  0,  0,  0},   // 9805
    {  2,4903,  0,  0,  0,  0},   // 9806
    {  3,  7,467,  0,  0,  0},   // 9807
    {  2,613,  0,  0,  0,  0},   // 9808
    { 17,577,  0,  0,  0,  0},   // 9809
    {  2,  3,  5,109,  0,  0},   // 9810
    {  0,  0,  0,  0,  0,  0},   // 9811
    {  2, 11,223,  0,  0,  0},   // 9812
    {  3,3271,  0,  0,  0,  0},   // 9813
    {  2,  7,701,  0,  0,  0},   // 9814
    {  5, 13,151,  0,  0,  0},   // 9815
    {  2,  3,409,  0,  0,  0},   // 9816
    {  0,  0,  0,  0,  0,  0},   // 9817
    {  2,4909,  0,  0,  0,  0},   // 9818
    {  3,1091,  0,  0,  0,  0},   // 9819
    {  2,  5,491,  0,  0,  0},   // 9820
    {  7, 23, 61,  0,  0,  0},   // 9821
    {  2,  3,1637,  0,  0,  0},   // 9822
    { 11, 19, 47,  0,  0,  0},   // 9823
    {  2,307,  0,  0,  0,  0},   // 9824
    {  3,  5,131,  0,  0,  0},   // 9825
    {  2, 17,  0,  0,  0,  0},   // 9826
    { 31,317,  0,  0,  0,  0},   // 9827
    {  2,  3,  7, 13,  0,  0},   // 9828
    {  0,  0,  0,  0,  0,  0},   // 9829
    {  2,  5,983,  0,  0,  0},   // 9830
    {  3, 29,113,  0,  0,  0},   // 9831
    {  2,1229,  0,  0,  0,  0},   // 9832
    {  0,  0,  0,  0,  0,  0},   // 9833
    {  2,  3, 11,149,  0,  0},   // 9834
    {  5,  7,281,  0,  0,  0},   // 9835
    {  2,2459,  0,  0,  0,  0},   // 9836
    {  3,1093,  0,  0,  0,  0},   // 9837
    {  2,4919,  0,  0,  0,  0},   // 9838
    {  0,  0,  0,  0,  0,  0},   // 9839
    {  2,  3,  5, 41,  0,  0},   // 9840
    { 13,757,  0,  0,  0,  0},   // 9841
    {  2,  7, 19, 37,  0,  0},   // 9842
    {  3, 17,193,  0,  0,  0},   // 9843
    {  2, 23,107,  0,  0,  0},   // 9844
    {  5, 11,179,  0,  0,  0},   // 9845
    {  2,  3,547,  0,  0,  0},   // 9846
    { 43,229,  0,  0,  0,  0},   // 9847
    {  2,1231,  0,  0,  0,  0},   // 9848
    {  3,  7, 67,  0,  0,  0},   // 9849
    {  2,  5,197,  0,  0,  0},   // 9850
    {  0,  0,  0,  0,  0,  0},   // 9851
    {  2,  3,821,  0,  0,  0},   // 9852
    { 59,167,  0,  0,  0,  0},   // 9853
    {  2, 13,379,  0,  0,  0},   // 9854
    {  3,  5, 73,  0,  0,  0},   // 9855
    {  2,  7, 11,  0,  0,  0},   // 9856
    {  0,  0,  0,  0,  0,  0},   // 9857
    {  2,  3, 31, 53,  0,  0},   // 9858
    {  0,  0,  0,  0,  0,  0},   // 9859
    {  2,  5, 17, 29,  0,  0},   // 9860
    {  3, 19,173,  0,  0,  0},   // 9861
    {  2,4931,  0,  0,  0,  0},   // 9862
    {  7,1409,  0,  0,  0,  0},   // 9863
    {  2,  3,137,  0,  0,  0},   // 9864
    {  5,1973,  0,  0,  0,  0},   // 9865
    {  2,4933,  0,  0,  0,  0},   // 9866
    {  3, 11, 13, 23,  0,  0},   // 9867
    {  2,2467,  0,  0,  0,  0},   // 9868
    { 71,139,  0,  0,  0,  0},   // 9869
    {  2,  3,  5,  7, 47,  0},   // 9870
    {  0,  0,  0,  0,  0,  0},   // 9871
    {  2,617,  0,  0,  0,  0},   // 9872
    {  3,1097,  0,  0,  0,  0},   // 9873
    {  2,4937,  0,  0,  0,  0},   // 9874
    {  5, 79,  0,  0,  0,  0},   // 9875
    {  2,  3,823,  0,  0,  0},   // 9876
    {  7, 17, 83,  0,  0,  0},   // 9877
    {  2, 11,449,  0,  0,  0},   // 9878
    {  3, 37, 89,  0,  0,  0},   // 9879
    {  2,  5, 13, 19,  0,  0},   // 9880
    { 41,241,  0,  0,  0,  0},   // 9881
    {  2,  3, 61,  0,  0,  0},   // 9882
    {  0,  0,  0,  0,  0,  0},   // 9883
    {  2,  7,353,  0,  0,  0},   // 9884
    {  3,  5,659,  0,  0,  0},   // 9885
    {  2,4943,  0,  0,  0,  0},   // 9886
    {  0,  0,  0,  0,  0,  0},   // 9887
    {  2,  3,103,  0,  0,  0},   // 9888
    { 11, 29, 31,  0,  0,  0},   // 9889
    {  2,  5, 23, 43,  0,  0},   // 9890
    {  3,  7,157,  0,  0,  0},   // 9891
    {  2,2473,  0,  0,  0,  0},   // 9892
    { 13,761,  0,  0,  0,  0},   // 9893
    {  2,  3, 17, 97,  0,  0},   // 9894
    {  5,1979,  0,  0,  0,  0},   // 9895
    {  2,1237,  0,  0,  0,  0},   // 9896
    {  3,3299,  0,  0,  0,  0},   // 9897
    {  2,  7,101,  0,  0,  0},   // 9898
    { 19,521,  0,  0,  0,  0},   // 9899
    {  2,  3,  5, 11,  0,  0},   // 9900
    {  0,  0,  0,  0,  0,  0},   // 9901
    {  2,4951,  0,  0,  0,  0},   // 9902
    {  3,3301,  0,  0,  0,  0},   // 9903
    {  2,619,  0,  0,  0,  0},   // 9904
    {  5,  7,283,  0,  0,  0},   // 9905
    {  2,  3, 13,127,  0,  0},   // 9906
    {  0,  0,  0,  0,  0,  0},   // 9907
    {  2,2477,  0,  0,  0,  0},   // 9908
    {  3,367,  0,  0,  0,  0},   // 9909
    {  2,  5,991,  0,  0,  0},   // 9910
    { 11, 17, 53,  0,  0,  0},   // 9911
    {  2,  3,  7, 59,  0,  0},   // 9912
    { 23,431,  0,  0,  0,  0},   // 9913
    {  2,4957,  0,  0,  0,  0},   // 9914
    {  3,  5,661,  0,  0,  0},   // 9915
    {  2, 37, 67,  0,  0,  0},   // 9916
    { 47,211,  0,  0,  0,  0},   // 9917
    {  2,  3, 19, 29,  0,  0},   // 9918
    {  7, 13,109,  0,  0,  0},   // 9919
    {  2,  5, 31,  0,  0,  0},   // 9920
    {  3,3307,  0,  0,  0,  0},   // 9921
    {  2, 11, 41,  0,  0,  0},   // 9922
    {  0,  0,  0,  0,  0,  0},   // 9923
    {  2,  3,827,  0,  0,  0},   // 9924
    {  5,397,  0,  0,  0,  0},   // 9925
    {  2,  7,709,  0,  0,  0},   // 9926
    {  3,1103,  0,  0,  0,  0},   // 9927
    {  2, 17, 73,  0,  0,  0},   // 9928
    {  0,  0,  0,  0,  0,  0},   // 9929
    {  2,  3,  5,331,  0,  0},   // 9930
    {  0,  0,  0,  0,  0,  0},   // 9931
    {  2, 13,191,  0,  0,  0},   // 9932
    {  3,  7, 11, 43,  0,  0},   // 9933
    {  2,4967,  0,  0,  0,  0},   // 9934
    {  5,1987,  0,  0,  0,  0},   // 9935
    {  2,  3, 23,  0,  0,  0},   // 9936
    { 19,523,  0,  0,  0,  0},   // 9937
    {  2,4969,  0,  0,  0,  0},   // 9938
    {  3,3313,  0,  0,  0,  0},   // 9939
    {  2,  5,  7, 71,  0,  0},   // 9940
    {  0,  0,  0,  0,  0,  0},   // 9941
    {  2,  3,1657,  0,  0,  0},   // 9942
    { 61,163,  0,  0,  0,  0},   // 9943
    {  2, 11,113,  0,  0,  0},   // 9944
    {  3,  5, 13, 17,  0,  0},   // 9945
    {  2,4973,  0,  0,  0,  0},   // 9946
    {  7, 29,  0,  0,  0,  0},   // 9947
    {  2,  3,829,  0,  0,  0},   // 9948
    {  0,  0,  0,  0,  0,  0},   // 9949
    {  2,  5,199,  0,  0,  0},   // 9950
    {  3, 31,107,  0,  0,  0},   // 9951
    {  2,311,  0,  0,  0,  0},   // 9952
    { 37,269,  0,  0,  0,  0},   // 9953
    {  2,  3,  7, 79,  0,  0},   // 9954
    {  5, 11,181,  0,  0,  0},   // 9955
    {  2, 19,131,  0,  0,  0},   // 9956
    {  3,3319,  0,  0,  0,  0},   // 9957
    {  2, 13,383,  0,  0,  0},   // 9958
    { 23,433,  0,  0,  0,  0},   // 9959
    {  2,  3,  5, 83,  0,  0},   // 9960
    {  7,1423,  0,  0,  0,  0},   // 9961
    {  2, 17,293,  0,  0,  0},   // 9962
    {  3, 41,  0,  0,  0,  0},   // 9963
    {  2, 47, 53,  0,  0,  0},   // 9964
    {  5,1993,  0,  0,  0,  0},   // 9965
    {  2,  3, 11,151,  0,  0},   // 9966
    {  0,  0,  0,  0,  0,  0},   // 9967
    {  2,  7, 89,  0,  0,  0},   // 9968
    {  3,3323,  0,  0,  0,  0},   // 9969
    {  2,  5,997,  0,  0,  0},   // 9970
    { 13, 59,  0,  0,  0,  0},   // 9971
    {  2,  3,277,  0,  0,  0},   // 9972
    {  0,  0,  0,  0,  0,  0},   // 9973
    {  2,4987,  0,  0,  0,  0},   // 9974
    {  3,  5,  7, 19,  0,  0},   // 9975
    {  2, 29, 43,  0,  0,  0},   // 9976
    { 11,907,  0,  0,  0,  0},   // 9977
    {  2,  3,1663,  0,  0,  0},   // 9978
    { 17,587,  0,  0,  0,  0},   // 9979
    {  2,  5,499,  0,  0,  0},   // 9980
    {  3,1109,  0,  0,  0,  0},   // 9981
    {  2,  7, 23, 31,  0,  0},   // 9982
    { 67,149,  0,  0,  0,  0},   // 9983
    {  2,  3, 13,  0,  0,  0},   // 9984
    {  5,1997,  0,  0,  0,  0},   // 9985
    {  2,4993,  0,  0,  0,  0},   // 9986
    {  3,3329,  0,  0,  0,  0},   // 9987
    {  2, 11,227,  0,  0,  0},   // 9988
    {  7,1427,  0,  0,  0,  0},   // 9989
    {  2,  3,  5, 37,  0,  0},   // 9990
    { 97,103,  0,  0,  0,  0},   // 9991
    {  2,1249,  0,  0,  0,  0},   // 9992
    {  3,3331,  0,  0,  0,  0},   // 9993
    {  2, 19,263,  0,  0,  0},   // 9994
    {  5,1999,  0,  0,  0,  0},   // 9995
    {  2,  3,  7, 17,  0,  0},   // 9996
    { 13,769,  0,  0,  0,  0},   // 9997
    {  2,4999,  0,  0,  0,  0},   // 9998
    {  3, 11,101,  0,  0,  0},   // 9999
    {  2,  5,  0,  0,  0,  0}    // 10000
  };
#endif
