//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Projection/IntensityDataProjectionsWidget.h
//! @brief     Defines class IntensityDataProjectionsWidget
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_PROJECTION_INTENSITYDATAPROJECTIONSWIDGET_H
#define BORNAGAIN_GUI_VIEW_PROJECTION_INTENSITYDATAPROJECTIONSWIDGET_H

#include "GUI/View/Common/DataAccessWidget.h"

class IntensityDataPropertyWidget;
class ProjectionsEditorActions;
class ProjectionsEditorCanvas;
class ProjectionsToolbar;
class ProjectionsWidget;

//! Main widget to embed projections editor for IntensityDataItem.
//! Part of RealDataPresenter and JobResultsPresenter.

class IntensityDataProjectionsWidget : public DataAccessWidget {
public:
    IntensityDataProjectionsWidget(QWidget* parent = nullptr);

    void setJobOrRealItem(QObject* job_or_real_item) override;

    QList<QAction*> actionList() override;

private:
    void setContext();
    void resetContext();
    void showEvent(QShowEvent*) override;
    void hideEvent(QHideEvent*) override;
    void setup_connections();

    ProjectionsEditorActions* m_editorActions;
    ProjectionsToolbar* m_toolbar;                //! main tool bar with buttons at the right
    ProjectionsEditorCanvas* m_projectionsCanvas; //! canvas with color map at the top
    ProjectionsWidget* m_projectionsWidget;       //! bottom widget to draw projections plot
    IntensityDataPropertyWidget* m_propertyPanel; //! panel at the right with properties
};

#endif // BORNAGAIN_GUI_VIEW_PROJECTION_INTENSITYDATAPROJECTIONSWIDGET_H
