/*
 *    This file is part of CasADi.
 *
 *    CasADi -- A symbolic framework for dynamic optimization.
 *    Copyright (C) 2010-2023 Joel Andersson, Joris Gillis, Moritz Diehl,
 *                            KU Leuven. All rights reserved.
 *    Copyright (C) 2011-2014 Greg Horn
 *
 *    CasADi is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 3 of the License, or (at your option) any later version.
 *
 *    CasADi is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with CasADi; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */


      #include "feasiblesqpmethod.hpp"
      #include <string>

      const std::string casadi::Feasiblesqpmethod::meta_doc=
      "\n"
"\n"
"A textbook FeasibleSQPMethod\n"
"\n"
"Extra doc: https://github.com/casadi/casadi/wiki/L_241 \n"
"\n"
"\n"
">List of available options\n"
"\n"
"+----------------------------+-----------------+---------------------------+\n"
"|             Id             |      Type       |        Description        |\n"
"+============================+=================+===========================+\n"
"| anderson_memory            | OT_INT          | Anderson memory. If       |\n"
"|                            |                 | Anderson is used default  |\n"
"|                            |                 | is 1, else default is 0.  |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| contraction_acceptance_val | OT_DOUBLE       | If the empirical          |\n"
"| ue                         |                 | contraction rate in the   |\n"
"|                            |                 | feasibility iterations is |\n"
"|                            |                 | above this value in the   |\n"
"|                            |                 | heuristics the iterations |\n"
"|                            |                 | are aborted.              |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| convexify_margin           | OT_DOUBLE       | When using a              |\n"
"|                            |                 | convexification strategy, |\n"
"|                            |                 | make sure that the        |\n"
"|                            |                 | smallest eigenvalue4 is   |\n"
"|                            |                 | at least this (default:   |\n"
"|                            |                 | 1e-7).                    |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| convexify_strategy         | OT_STRING       | NONE|regularize|eigen-    |\n"
"|                            |                 | reflect|eigen-clip.       |\n"
"|                            |                 | Strategy to convexify the |\n"
"|                            |                 | Lagrange Hessian before   |\n"
"|                            |                 | passing it to the solver. |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| f                          | OT_FUNCTION     | Function for calculating  |\n"
"|                            |                 | the objective function    |\n"
"|                            |                 | (autogenerated by         |\n"
"|                            |                 | default)                  |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| feas_tol                   | OT_DOUBLE       | Feasibility tolerance.    |\n"
"|                            |                 | Below this tolerance an   |\n"
"|                            |                 | iterate is considered to  |\n"
"|                            |                 | be feasible.              |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| g                          | OT_FUNCTION     | Function for calculating  |\n"
"|                            |                 | the constraints           |\n"
"|                            |                 | (autogenerated by         |\n"
"|                            |                 | default)                  |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| grad_f                     | OT_FUNCTION     | Function for calculating  |\n"
"|                            |                 | the gradient of the       |\n"
"|                            |                 | objective (autogenerated  |\n"
"|                            |                 | by default)               |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| hess_lag                   | OT_FUNCTION     | Function for calculating  |\n"
"|                            |                 | the Hessian of the        |\n"
"|                            |                 | Lagrangian (autogenerated |\n"
"|                            |                 | by default)               |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| hessian_approximation      | OT_STRING       | limited-memory|exact      |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| init_feasible              | OT_BOOL         | Initialize the QP         |\n"
"|                            |                 | subproblems with a        |\n"
"|                            |                 | feasible initial value    |\n"
"|                            |                 | (default: false).         |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| jac_g                      | OT_FUNCTION     | Function for calculating  |\n"
"|                            |                 | the Jacobian of the       |\n"
"|                            |                 | constraints               |\n"
"|                            |                 | (autogenerated by         |\n"
"|                            |                 | default)                  |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| lbfgs_memory               | OT_INT          | Size of L-BFGS memory.    |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| max_inner_iter             | OT_DOUBLE       | Maximum number of inner   |\n"
"|                            |                 | iterations.               |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| max_iter                   | OT_INT          | Maximum number of SQP     |\n"
"|                            |                 | iterations                |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| max_iter_eig               | OT_DOUBLE       | Maximum number of         |\n"
"|                            |                 | iterations to compute an  |\n"
"|                            |                 | eigenvalue decomposition  |\n"
"|                            |                 | (default: 50).            |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| merit_memory               | OT_INT          | Size of memory to store   |\n"
"|                            |                 | history of merit function |\n"
"|                            |                 | values                    |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| min_iter                   | OT_INT          | Minimum number of SQP     |\n"
"|                            |                 | iterations                |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| optim_tol                  | OT_DOUBLE       | Optimality tolerance.     |\n"
"|                            |                 | Below this value an       |\n"
"|                            |                 | iterate is considered to  |\n"
"|                            |                 | be optimal.               |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| print_header               | OT_BOOL         | Print the header with     |\n"
"|                            |                 | problem statistics        |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| print_iteration            | OT_BOOL         | Print the iterations      |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| print_status               | OT_BOOL         | Print a status message    |\n"
"|                            |                 | after solving             |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| qpsol                      | OT_STRING       | The QP solver to be used  |\n"
"|                            |                 | by the SQP method         |\n"
"|                            |                 | [qpoases]                 |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| qpsol_options              | OT_DICT         | Options to be passed to   |\n"
"|                            |                 | the QP solver             |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| solve_type                 | OT_STRING       | The solver type: Either   |\n"
"|                            |                 | SQP or SLP. Defaults to   |\n"
"|                            |                 | SQP                       |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| tol_du                     | OT_DOUBLE       | Stopping criterion for    |\n"
"|                            |                 | dual infeasability        |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| tol_pr                     | OT_DOUBLE       | Stopping criterion for    |\n"
"|                            |                 | primal infeasibility      |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| tr_acceptance              | OT_DOUBLE       | Is the trust-region ratio |\n"
"|                            |                 | above this value, the     |\n"
"|                            |                 | step is accepted.         |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| tr_alpha1                  | OT_DOUBLE       | Lower alpha in trust-     |\n"
"|                            |                 | region size criterion.    |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| tr_alpha2                  | OT_DOUBLE       | Upper alpha in trust-     |\n"
"|                            |                 | region size criterion.    |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| tr_eta1                    | OT_DOUBLE       | Lower eta in trust-region |\n"
"|                            |                 | acceptance criterion.     |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| tr_eta2                    | OT_DOUBLE       | Upper eta in trust-region |\n"
"|                            |                 | acceptance criterion.     |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| tr_rad0                    | OT_DOUBLE       | Initial trust-region      |\n"
"|                            |                 | radius.                   |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| tr_rad_max                 | OT_DOUBLE       | Maximum trust-region      |\n"
"|                            |                 | radius.                   |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| tr_rad_min                 | OT_DOUBLE       | Minimum trust-region      |\n"
"|                            |                 | radius.                   |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| tr_scale_vector            | OT_DOUBLEVECTOR | Vector that tells where   |\n"
"|                            |                 | trust-region is applied.  |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| tr_tol                     | OT_DOUBLE       | Trust-region tolerance.   |\n"
"|                            |                 | Below this value another  |\n"
"|                            |                 | scalar is equal to the    |\n"
"|                            |                 | trust region radius.      |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| use_anderson               | OT_BOOL         | Use Anderson              |\n"
"|                            |                 | Acceleration. (default    |\n"
"|                            |                 | false)                    |\n"
"+----------------------------+-----------------+---------------------------+\n"
"| watchdog                   | OT_INT          | Number of watchdog        |\n"
"|                            |                 | iterations in feasibility |\n"
"|                            |                 | iterations. After this    |\n"
"|                            |                 | amount of iterations, it  |\n"
"|                            |                 | is checked with the       |\n"
"|                            |                 | contraction acceptance    |\n"
"|                            |                 | value, if iterations are  |\n"
"|                            |                 | converging.               |\n"
"+----------------------------+-----------------+---------------------------+\n"
"\n"
"\n"
"\n"
"\n"
;
