#include <cctbx/eltbx/electron_scattering.h>

namespace cctbx { namespace eltbx { namespace electron_scattering {

  namespace {

    /*
     peng1996_raw_table contains the reformatted data

     2008-06-30, translated by L. Lutterotti from
     L.-M. PENG, G. REN, S. L. DUDAREV & M. J. WHELAN
     Robust Parameterization of Elastic and Absorptive Electron Atomic
     Scattering Factors
     J. Appl. Cryst. A52, 257-276
     1996
     and
     L.-M. PENG
     Electron Scattering Factors of Ions and their Parameterization
     J. Appl. Cryst. A54, 481-485
     1998
     Electron scattering factors for atoms up to 6.0 Angstrom^-1
     */

    static const
    xray_scattering::detail::raw_table_entry<5> peng1996_raw_table[] =
    {
// BEGIN_COMPILED_IN_REFERENCE_DATA

      { "H",     { 0.0088,      0.0449, 0.1481, 0.2356, 0.0914 },
        { 0.1152,       1.0867, 4.9755, 16.5591,        43.2743 },
        0 },
      { "He",    { 0.0084,      0.0443, 0.1314, 0.1671, 0.0666 },
        { 0.0596,       0.536,  2.4274, 7.7852, 20.3126 },
        0 },
      { "Li",    { 0.0478,      0.2048, 0.5253, 1.5225, 0.9853 },
        { 0.2258,       2.1032, 12.9349,        50.7501,        136.628 },
        0 },
      { "Be",    { 0.0423,      0.1874, 0.6019, 1.4311, 0.7891 },
        { 0.1445,       1.418,  8.1165, 27.9705,        74.8684 },
        0 },
      { "B",     { 0.0436,      0.1898, 0.6788, 1.3273, 0.5544 },
        { 0.1207,       1.1595, 6.2474, 21.046, 59.3619 },
        0 },
      { "C",     { 0.0489,      0.2091, 0.7537, 1.142,  0.3555 },
        { 0.114,        1.0825, 5.4281, 17.8811,        51.1341 },
        0 },
      { "N",     { 0.0267,      0.1328, 0.5301, 1.102,  0.4215 },
        { 0.0541,       0.5165, 2.8207, 10.6297,        34.3764 },
        0 },
      { "O",     { 0.0365,      0.1729, 0.5805, 0.8814, 0.3121 },
        { 0.0652,       0.6184, 2.9449, 9.6298, 28.2194 },
        0 },
      { "F",     { 0.0382,      0.1822, 0.5972, 0.7707, 0.213 },
        { 0.0613,       0.5753, 2.6858, 8.8214, 25.6668 },
        0 },
      { "Ne",    { 0.038,       0.1785, 0.5494, 0.6942, 0.1918 },
        { 0.0554,       0.5087, 2.2639, 7.3316, 21.6912 },
        0 },
      { "Na",    { 0.126,       0.6442, 0.8893, 1.8197, 1.2988 },
        { 0.1684,       1.715,  8.8386, 50.8265,        147.2073 },
        0 },
      { "Mg",    { 0.113,       0.5575, 0.9046, 2.158,  1.4735 },
        { 0.1356,       1.3579, 6.9255, 32.3165,        92.113 },
        0 },
      { "Al",    { 0.1165,      0.5504, 1.0179, 2.6295, 1.5711 },
        { 0.1295,       1.2619, 6.8242, 28.4577,        88.475 },
        0 },
      { "Si",    { 0.0567,      0.3365, 0.8104, 2.496,  2.1186 },
        { 0.0582,       0.6155, 3.2522, 16.7929,        57.6767 },
        0 },
      { "P",     { 0.1005,      0.4615, 1.0663, 2.5854, 1.2725 },
        { 0.0977,       0.9084, 4.9654, 18.5471,        54.3648 },
        0 },
      { "S",     { 0.0915,      0.4312, 1.0847, 2.4671, 1.0852 },
        { 0.0838,       0.7788, 4.3462, 15.5846,        44.63655 },
        0 },
      { "Cl",    { 0.0799,      0.3891, 1.0037, 2.3332, 1.0507 },
        { 0.0694,       0.6443, 3.5351, 12.5058,        35.8633 },
        0 },
      { "Ar",    { 0.1044,      0.4551, 1.4232, 2.1533, 0.4459 },
        { 0.0853,       0.7701, 4.4684, 14.5864,        41.2474 },
        0 },
      { "K",     { 0.2149,      0.8703, 2.4999, 2.3591, 3.0318 },
        { 0.166,        1.6906, 8.7447, 46.7825,        165.6923 },
        0 },
      { "Ca",    { 0.2355,      0.9916, 2.3959, 3.7252, 2.5647 },
        { 0.1742,       1.8329, 8.8407, 47.4583,        134.9613 },
        0 },
      { "Sc",    { 0.4636,      2.0802, 2.9003, 1.4193, 2.4323 },
        { 0.3682,       4.0312, 22.6493,        71.82,  103.3691 },
        0 },
      { "Ti",    { 0.2123,      0.896,  2.1765, 3.0436, 2.4439 },
        { 0.1399,       1.4568, 6.7534, 33.1168,        101.8238 },
        0 },
      { "V",     { 0.2369,      1.0774, 2.1894, 3.0825, 1.719 },
        { 0.1505,       1.6392, 7.5691, 36.8741,        107.8517 },
        0 },
      { "Cr",    { 0.197,       0.8228, 2.02,   2.1717, 1.7516 },
        { 0.1197,       1.1985, 5.4097, 25.2361,        94.429 },
        0 },
      { "Mn",    { 0.1943,      0.819,  1.9296, 2.4968, 2.0625 },
        { 0.1135,       1.1313, 5.0341, 24.1798,        80.5598 },
        0 },
      { "Fe",    { 0.1929,      0.8239, 1.8689, 2.3694, 1.906 },
        { 0.1087,       1.0806, 4.7637, 22.85,  76.7309 },
        0 },
      { "Co",    { 0.2186,      0.9861, 1.854,  2.3258, 1.4685 },
        { 0.1182,       1.23,   5.4177, 25.7602,        80.8542 },
        0 },
      { "Ni",    { 0.2313,      1.0657, 1.8229, 2.2609, 1.1883 },
        { 0.121,        1.2691, 5.687,  27.0917,        83.0285 },
        0 },
      { "Cu",    { 0.3501,      1.6558, 1.9582, 0.2134, 1.4109 },
        { 0.1867,       1.9917, 11.3396,        53.2619,        63.252 },
        0 },
      { "Zn",    { 0.178,       0.8096, 1.6744, 1.9499, 1.4495 },
        { 0.0876,       0.865,  3.8612, 18.8726,        64.7016 },
        0 },
      { "Ga",    { 0.2135,      0.9768, 1.6669, 2.5662, 1.679 },
        { 0.102,        1.0219, 4.6275, 22.8742,        80.1535 },
        0 },
      { "Ge",    { 0.2135,      0.9761, 1.6555, 2.8938, 1.6356 },
        { 0.0989,       0.9845, 4.5527, 21.5563,        70.3903 },
        0 },
      { "As",    { 0.2059,      0.9518, 1.6372, 3.049,  1.4756 },
        { 0.0926,       0.9182, 4.3291, 19.2996,        58.9329 },
        0 },
      { "Se",    { 0.1574,      0.7614, 1.4834, 3.0016, 1.7978 },
        { 0.0686,       0.6808, 3.1163, 14.3458,        44.0455 },
        0 },
      { "Br",    { 0.1899,      0.8983, 1.6358, 3.1845, 1.15183 },
        { 0.081,        0.7957, 3.9054, 15.7701,        45.6124 },
        0 },
      { "Kr",    { 0.1742,      0.8447, 1.5944, 3.1507, 1.1338 },
        { 0.0723,       0.7123, 3.5192, 13.7724,        39.1148 },
        0 },
      { "Rb",    { 0.3781,      1.4904, 3.5753, 3.0031, 3.3272 },
        { 0.1557,       1.5347, 9.9947, 51.4251,        185.9828 },
        0 },
      { "Sr",    { 0.3723,      1.4598, 3.5124, 4.4612, 3.3031 },
        { 0.148,        1.4643, 9.232,  49.8807,        148.0937 },
        0 },
      { "Y",     { 0.3234,      1.2737, 3.2115, 4.0563, 3.7962 },
        { 0.1244,       1.1948, 7.2756, 34.143, 111.2079 },
        0 },
      { "Zr",    { 0.2997,      1.1879, 3.1075, 3.974,  3.5769 },
        { 0.1121,       1.0638, 6.3891, 28.7081,        97.4289 },
        0 },
      { "Nb",    { 0.168,       0.937,  2.73,   3.815,  3.0053 },
        { 0.0597,       0.6524, 4.4317, 19.554, 85.5011 },
        0 },
      { "Mo",    { 0.3069,      1.1714, 3.2293, 3.4254, 2.1224 },
        { 0.1101,       1.0222, 5.9613, 25.1965,        93.5831 },
        0 },
      { "Tc",    { 0.2928,      1.1267, 3.1675, 3.6619, 2.5942 },
        { 0.102,        0.9481, 5.4713, 23.8153,        82.8991 },
        0 },
      { "Ru",    { 0.2604,      1.0442, 3.0761, 3.2175, 1.9448 },
        { 0.0887,       0.824,  4.8278, 19.8977,        80.4566 },
        0 },
      { "Rh",    { 0.2713,      1.0556, 3.1416, 3.0451, 1.7179 },
        { 0.0907,       0.8324, 4.7702, 19.7862,        80.254 },
        0 },
      { "Pd",    { 0.2003,      0.8779, 2.6135, 2.8594, 1.0258 },
        { 0.0659,       0.6111, 3.5563, 12.7638,        44.4283 },
        0 },
      { "Ag",    { 0.2739,      1.0503, 3.1564, 2.7543, 1.4328 },
        { 0.0881,       0.8028, 4.4451, 18.7011,        79.2633 },
        0 },
      { "Cd",    { 0.3072,      1.1303, 3.2046, 2.9329, 1.656 },
        { 0.0966,       0.8856, 4.6273, 20.6789,        73.4723 },
        0 },
      { "In",    { 0.3564,      1.3011, 3.2424, 3.4839, 2.0459 },
        { 0.1091,       1.0452, 5.09,   24.6578,        88.0513 },
        0 },
      { "Sn",    { 0.2966,      1.1157, 3.0973, 3.8156, 2.5281 },
        { 0.0896,       0.8268, 4.2242, 20.69,  71.3399 },
        0 },
      { "Sb",    { 0.2725,      1.0651, 2.994,  4.0697, 2.5682 },
        { 0.0809,       0.7488, 3.871,  18.88,  60.6499 },
        0 },
      { "Te",    { 0.2422, 0.9692, 2.8114, 4.1509, 2.8161 },
        { 0.0708, 0.6472, 3.3609, 16.0752, 50.1724 },
        0 },
      { "I",     { 0.2617, 1.0325, 2.8097, 4.4809, 2.319 },
        { 0.0749, 0.6914, 3.4634, 16.3603, 48.2522 },
        0 },
      { "Xe",    { 0.2334, 0.9496, 2.6381, 4.468, 2.502 },
        { 0.0655, 0.605, 3.0389, 14.0809, 41.0005 },
        0 },
      { "Cs",    { 0.5713, 2.4866, 4.9795, 4.0198, 4.4403 },
        { 0.1626, 1.8213, 11.1049, 49.0568, 202.9987 },
        0 },
      { "Ba",    { 0.5229, 2.2874, 4.7243, 5.0807, 5.6389 },
        { 0.1434, 1.6019, 9.4511, 42.7685, 148.4969 },
        0 },
      { "La",    { 0.5461, 2.3856, 5.0653, 5.7601, 4.0463 },
        { 0.1479, 1.6552, 10.0059, 47.3245, 145.8464 },
        0 },
      { "Ce",    { 0.2227, 1.076, 2.9482, 5.8496, 7.1834 },
        { 0.0571, 0.5946, 3.2022, 16.4253, 95.703 },
        0 },
      { "Pr",    { 0.5237, 2.2913, 4.6161, 4.7233, 4.8173 },
        { 0.136, 1.5068, 8.8213, 41.9536, 141.2424 },
        0 },
      { "Nd",    { 0.5368, 2.3301, 4.6058, 4.6621, 4.4622 },
        { 0.1378, 1.514, 8.8719, 43.5967, 141.8065 },
        0 },
      { "Pm",    { 0.5232, 2.2627, 4.4552, 4.4787, 4.5073 },
        { 0.1317, 1.4336, 8.3087, 40.601, 135.9196 },
        0 },
      { "Sm",    { 0.5162, 2.2302, 4.3449, 4.3598, 4.4292 },
        { 0.1279, 1.3811, 7.9629, 39.1213, 132.7846 },
        0 },
      { "Eu",    { 0.5272, 2.2844, 4.3361, 4.3178, 4.0908 },
        { 0.1285, 1.3943, 8.1081, 40.9631, 134.1233 },
        0 },
      { "Gd",    { 0.9664, 3.4052, 5.0803, 1.4991, 4.2528 },
        { 0.2641, 2.6586, 16.2213, 80.206, 92.5359 },
        0 },
      { "Tb",    { 0.511, 2.157, 4.0308, 3.9936, 4.2466 },
        { 0.121, 1.2704, 7.1368, 35.0354, 123.5062 },
        0 },
      { "Dy",    { 0.4974, 2.1097, 3.8906, 3.81, 4.3084 },
        { 0.1157, 1.2108, 6.7377, 32.415, 116.9225 },
        0 },
      { "Ho",    { 0.4679, 1.9693, 3.7191, 3.9632, 4.2432 },
        { 0.1069, 1.0994, 5.9769, 27.1491, 96.3119 },
        0 },
      { "Er",    { 0.5034, 2.1088, 3.8232, 3.7299, 3.8963 },
        { 0.1141, 1.1769, 6.6087, 33.4332, 116.4913 },
        0 },
      { "Tm",    { 0.4839, 2.0262, 3.6851, 3.5874, 4.0037 },
        { 0.1081, 1.1012, 6.1114, 30.3728, 110.5988 },
        0 },
      { "Yb",    { 0.5221, 2.1695, 3.7567, 3.6685, 3.4274 },
        { 0.1148, 1.186, 6.752, 35.6807, 118.0692 },
        0 },
      { "Lu",    { 0.468, 1.9466, 3.5428, 3.849, 3.6594 },
        { 0.1015, 1.0195, 5.6058, 27.4899, 95.2846 },
        0 },
      { "Hf",    { 0.4048, 1.737, 3.3399, 3.9448, 3.7293 },
        { 0.0868, 0.8585, 4.6378, 21.69, 80.2408 },
        0 },
      { "Ta",    { 0.3835, 1.6747, 3.2986, 4.0462, 3.4303 },
        { 0.081, 0.802, 4.3545, 19.9644, 73.6337 },
        0 },
      { "W",     { 0.3661, 1.6191, 3.2455, 4.0856, 3.2064 },
        { 0.0761, 0.7543, 4.0952, 18.2886, 68.0967 },
        0 },
      { "Re",    { 0.3933, 1.6973, 3.4202, 4.1274, 2.6158 },
        { 0.0806, 0.7972, 4.4237, 19.5692, 68.7477 },
        0 },
      { "Os",    { 0.3854, 1.6555, 3.4129, 4.1111, 2.4106 },
        { 0.0787, 0.7638, 4.2441, 18.37, 65.1071 },
        0 },
      { "Ir",    { 0.351, 1.562, 3.2946, 4.0615, 2.4382 },
        { 0.0706, 0.6904, 3.8266, 16.0812, 58.7638 },
        0 },
      { "Pt",    { 0.3083, 1.4158, 2.9662, 3.9349, 2.1709 },
        { 0.0609, 0.5993, 3.1921, 12.5285, 49.7675 },
        0 },
      { "Au",    { 0.3055, 1.3945, 2.9617, 3.899, 2.0026 },
        { 0.0596, 0.5827, 3.1035, 11.9693, 47.9106 },
        0 },
      { "Hg",    { 0.3593, 1.5736, 3.5237, 3.8109, 1.6953 },
        { 0.0694, 0.6758, 3.8457, 15.6203, 56.6614 },
        0 },
      { "Tl",    { 0.3511, 1.5489, 3.5676, 4.09, 2.5251 },
        { 0.0672, 0.6522, 3.742, 15.9791, 65.1354 },
        0 },
      { "Pb",    { 0.354, 1.5453, 3.5975, 4.3152, 2.7743 },
        { 0.0668, 0.6465, 3.6968, 16.2056, 61.4909 },
        0 },
      { "Bi",    { 0.353, 1.5258, 3.5815, 4.5532, 3.0714 },
        { 0.0661, 0.6324, 3.5906, 15.9962, 57.576 },
        0 },
      { "Po",    { 0.3673, 1.5772, 3.7079, 4.8582, 2.844 },
        { 0.0678, 0.6527, 3.7396, 17.0668, 55.9789 },
        0 },
      { "At",    { 0.3547, 1.5206, 3.5621, 5.0184, 3.0075 },
        { 0.0649, 0.6188, 3.4696, 15.609, 49.4818 },
        0 },
      { "Rn",    { 0.4586, 1.7781, 3.9877, 5.7273, 1.546 },
        { 0.0831, 0.784, 4.3599, 20.0128, 62.1535 },
        0 },
      { "Fr",    { 0.8282, 2.9941, 5.6597, 4.9292, 4.2889 },
        { 0.1515, 1.6163, 9.7752, 42.848, 190.7366 },
        0 },
      { "Ra",    { 1.4129, 4.4269, 7.046, -1.0573, 8.643 },
        { 0.2921, 3.1381, 19.6767, 102.0436, 113.9798 },
        0 },
      { "Ac",    { 0.7169, 2.571, 5.1791, 6.3484, 5.6474 },
        { 0.1263, 1.29, 7.3686, 32.449, 118.0558 },
        0 },
      { "Th",    { 0.6958, 2.4936, 5.1269, 6.6988, 5.0799 },
        { 0.1211, 1.2247, 6.9398, 30.0991, 105.196 },
        0 },
      { "Pa",    { 1.2502, 4.2284, 7.0489, 1.139, 5.8222 },
        { 0.2415, 2.6442, 16.3313, 73.5757, 91.9401 },
        0 },
      { "U",     { 0.641, 2.2643, 4.8713, 5.9287, 5.3935 },
        { 0.1097, 1.0644, 5.7907, 25.0261, 101.3899 },
        0 },
      { "Np",    { 0.6938, 2.4652, 5.1227, 5.5965, 4.8543 },
        { 0.1171, 1.1757, 6.4053, 27.5217, 103.0482 },
        0 },
      { "Pu",    { 0.6902, 2.4509, 5.1284, 5.0339, 4.8575 },
        { 0.1153, 1.1545, 6.2291, 27.0741, 111.315 },
        0 },
      { "Am",    { 0.7577, 2.7264, 5.4184, 4.8198, 4.1013 },
        { 0.1257, 1.3044, 7.1035, 32.4649, 118.8647 },
        0 },
      { "Cm",    { 0.7567, 2.7565, 5.4364, 5.1918, 3.5643 },
        { 0.1239, 1.2979, 7.0798, 32.7871, 110.1512 },
        0 },
      { "Bk",    { 0.7492, 2.7267, 5.3521, 5.0369, 3.5321 },
        { 0.1217, 1.2651, 6.8101, 31.6088, 106.4853 },
        0 },
      { "Cf",    { 0.81, 3.0001, 5.4635, 4.1756, 3.5066 },
        { 0.131, 1.4038, 7.6057, 34.0186, 90.5226 },
        0 },
// ion now
      { "H1-",   { 1.40E-01,    6.49E-01,       1.37E+00,       3.37E-01,       7.87E-01 },
        { 9.84E-01,     8.67E+00,       3.89E+01,       1.11E+02,       1.66E+02 },
        0 },
      { "Li1+",  { 4.60E-03,    1.65E-02,       4.35E-02,       6.49E-02,       2.70E-02 },
        { 3.58E-02,     2.39E-01,       8.79E-01,       2.64E+00,       7.09E+00 },
        0 },
      { "Be2+",  { 3.40E-03,    1.03E-02,       2.33E-02,       3.25E-02,       1.20E-02 },
        { 2.67E-02,     1.62E-01,       5.31E-01,       1.48E+00,       3.88E+00 },
        0 },
      { "O1-",   { 2.05E-01,    6.28E-01,       1.17E+00,       1.03E+00,       2.90E-01 },
        { 3.97E-01,     2.64E+00,       8.80E+00,       2.71E+01,       9.18E+01 },
        0 },
      { "O2-",   { 4.21E-02,    2.10E-01,       8.52E-01,       1.82E+00,       1.17E+00 },
        { 6.09E-02,     5.59E-01,       2.96E+00,       1.15E+01,       3.77E+01 },
        0 },
      { "F1-",   { 1.34E-01,    3.91E-01,       8.14E-01,       9.28E-01,       3.47E-01 },
        { 2.28E-01,     1.47E+00,       4.68E+00,       1.32E+01,       3.60E+01 },
        0 },
      { "Na1+",  { 2.56E-02,    9.19E-02,       2.97E-01,       5.14E-01,       1.99E-01 },
        { 3.97E-02,     2.87E-01,       1.18E+00,       3.75E+00,       1.08E+01 },
        0 },
      { "Mg2+",  { 2.10E-02,    6.72E-02,       1.98E-01,       3.68E-01,       1.74E-01 },
        { 3.31E-02,     2.22E-01,       8.38E-01,       2.48E+00,       6.75E+00 },
        0 },
      { "Al3+",  { 1.92E-02,    5.79E-02,       1.63E-01,       2.84E-01,       1.14E-01 },
        { 3.06E-02,     1.98E-01,       7.13E-01,       2.04E+00,       5.25E+00 },
        0 },
      { "Si4+",  { 1.92E-01,    2.89E-01,       1.00E-01,       -7.28E-02,      1.20E-03 },
        { 3.59E-01,     1.96E+00,       9.34E+00,       1.11E+01,       1.34E+01 },
        0 },
      { "Cl1-",  { 2.65E-01,    5.96E-01,       1.60E+00,       2.69E+00,       1.23E+00 },
        { 2.52E-01,     1.56E+00,       6.21E+00,       1.78E+01,       4.78E+01 },
        0 },
      { "K1+",   { 1.99E-01,    3.96E-01,       9.28E-01,       1.45E+00,       4.50E-01 },
        { 1.92E-01,     1.10E+00,       3.91E+00,       9.75E+00,       2.34E+01 },
        0 },
      { "Ca2+",  { 1.64E-01,    3.27E-01,       7.43E-01,       1.16E+00,       3.07E-01 },
        { 1.57E-01,     8.94E-01,       3.15E+00,       7.67E+00,       1.77E+01 },
        0 },
      { "Sc3+",  { 1.63E-01,    3.07E-01,       7.16E-01,       8.80E-01,       1.39E-01 },
        { 1.57E-01,     8.99E-01,       3.06E+00,       7.05E+00,       1.61E+01 },
        0 },
      { "Ti2+",  { 3.99E-01,    1.04E+00,       1.21E+00,       -7.97E-02,      3.52E-01 },
        { 3.76E-01,     2.74E+00,       8.10E+00,       1.42E+01,       2.32E+01 },
        0 },
      { "Ti3+",  { 3.64E-01,    9.19E-01,       1.35E+00,       -9.33E-01,      5.89E-01 },
        { 3.64E-01,     2.67E+00,       8.18E+00,       1.18E+01,       1.49E+01 },
        0 },
      { "Ti4+",  { 1.16E-01,    2.56E-01,       5.65E-01,       7.72E-01,       1.32E-01 },
        { 1.08E-01,     6.55E-01,       2.38E+00,       5.51E+00,       1.23E+01 },
        0 },
      { "V2+",   { 3.17E-01,    9.39E-01,       1.49E+00,       -1.31E+00,      1.47E+00 },
        { 2.69E-01,     2.09E+00,       7.22E+00,       1.52E+01,       1.76E+01 },
        0 },
      { "V3+",   { 3.41E-01,    8.05E-01,       9.42E-01,       7.83E-02,       1.56E-01 },
        { 3.21E-01,     2.23E+00,       5.99E+00,       1.34E+01,       1.69E+01 },
        0 },
      { "V5+",   { 3.67E-02,    1.24E-01,       2.44E-01,       7.23E-01,       4.35E-01 },
        { 3.30E-02,     2.22E-01,       8.24E-01,       2.80E+00,       6.70E+00 },
        0 },
      { "Cr2+",  { 2.37E-01,    6.34E-01,       1.23E+00,       7.13E-01,       8.59E-02 },
        { 1.77E-01,     1.35E+00,       4.30E+00,       1.22E+01,       3.90E+01 },
        0 },
      { "Cr3+",  { 3.93E-01,    1.05E+00,       1.62E+00,       -1.15E+00,      4.07E-01 },
        { 3.59E-01,     2.57E+00,       8.68E+00,       1.10E+01,       1.58E+01 },
        0 },
      { "Cr4+",  { 1.32E-01,    2.92E-01,       7.03E-01,       6.92E-01,       9.59E-02 },
        { 1.09E-01,     6.95E-01,       2.39E+00,       5.65E+00,       1.47E+01 },
        0 },
      { "Mn2+",  { 5.76E-02,    2.10E-01,       6.04E-01,       1.32E+00,       6.59E-01 },
        { 3.98E-02,     2.84E-01,       1.29E+00,       4.23E+00,       1.45E+01 },
        0 },
      { "Mn3+",  { 1.16E-01,    5.23E-01,       8.81E-01,       5.89E-01,       2.14E-01 },
        { 1.17E-02,     8.76E-01,       3.06E+00,       6.44E+00,       1.43E+01 },
        0 },
      { "Mn4+",  { 3.81E-01,    1.83E+00,       -1.33E+00,      9.95E-01,       6.18E-02 },
        { 3.54E-01,     2.72E+00,       3.47E+00,       5.47E+00,       1.61E+01 },
        0 },
      { "Fe2+",  { 3.07E-01,    8.38E-01,       1.11E+00,       2.80E-01,       2.77E-01 },
        { 2.30E-01,     1.62E+00,       4.87E+00,       1.07E+01,       1.92E+01 },
        0 },
      { "Fe3+",  { 1.98E-01,    3.87E-01,       8.89E-01,       7.09E-01,       1.17E-01 },
        { 1.54E-01,     8.93E-01,       2.62E+00,       6.65E+00,       1.80E+01 },
        0 },
      { "Co2+",  { 2.13E-01,    4.88E-01,       9.98E-01,       8.28E-01,       2.30E-01 },
        { 1.48E-01,     9.39E-01,       2.78E+00,       7.31E+00,       2.07E+01 },
        0 },
      { "Co3+",  { 3.31E-01,    4.87E-01,       7.29E-01,       6.08E-01,       1.31E-01 },
        { 2.67E-01,     1.41E+00,       2.89E+00,       6.45E+00,       1.58E+01 },
        0 },
      { "Ni2+",  { 3.38E-01,    9.82E-01,       1.32E-02,       -3.56E+00,      3.62E+00 },
        { 2.37E-01,     1.67E+00,       5.73E+00,       1.14E+01,       1.21E+01 },
        0 },
      { "Ni3+",  { 3.47E-01,    8.77E-01,       7.90E-01,       5.38E-02,       1.92E-01 },
        { 2.60E-01,     1.71E+00,       4.75E+00,       7.51E+00,       1.30E+01 },
        0 },
      { "Cu1+",  { 3.12E-01,    8.12E-01,       1.11E+00,       7.94E-01,       2.57E-01 },
        { 2.01E-01,     1.31E+00,       3.80E+00,       1.05E+01,       2.82E+01 },
        0 },
      { "Cu2+",  { 2.24E-01,    5.44E-01,       9.70E-01,       7.27E-01,       1.82E-01 },
        { 1.45E-01,     9.33E-01,       2.69E+00,       7.11E+00,       1.94E+01 },
        0 },
      { "Zn2+",  { 2.52E-01,    6.00E-01,       9.17E-01,       6.63E-01,       1.61E-01 },
        { 1.61E-01,     1.01E+00,       2.76E+00,       7.08E+00,       1.90E+01 },
        0 },
      { "Ga3+",  { 3.91E-01,    9.47E-01,       6.90E-01,       7.09E-02,       6.53E-02 },
        { 2.64E-01,     1.65E+00,       4.82E+00,       1.07E+01,       1.52E+01 },
        0 },
      { "Ge4+",  { 3.46E-01,    8.30E-01,       5.99E-01,       9.49E-02,       -2.17E-02 },
        { 2.32E-01,     1.45E+00,       4.08E+00,       1.32E+01,       2.95E+01 },
        0 },
      { "Br1-",  { 1.25E-01,    5.63E-01,       1.43E+00,       3.52E+00,       3.22E+00 },
        { 5.30E-02,     4.69E-01,       2.15E+00,       1.11E+01,       3.89E+01 },
        0 },
      // in the Peng paper there is an error Br+1 instead of Rb+1
      { "Rb1+",  { 3.68E-01,    8.84E-01,       1.14E+00,       2.26E+00,       8.81E-01 },
        { 1.87E-01,     1.12E+00,       3.98E+00,       1.09E+01,       2.66E+01 },
        0 },
      { "Sr2+",  { 3.46E-01,    8.04E-01,       9.88E-01,       1.89E+00,       6.09E-01 },
        { 1.76E-01,     1.04E+00,       3.59E+00,       9.32E+00,       2.14E+01 },
        0 },
      { "Y3+",   { 4.65E-01,    9.23E-01,       2.41E+00,       -2.31E+00,      2.48E+00 },
        { 2.40E-01,     1.43E+00,       6.45E+00,       9.97E+00,       1.22E+01 },
        0 },
      { "Zr4+",  { 2.34E-01,    6.42E-01,       7.47E-01,       1.47E+00,       3.77E-01 },
        { 1.13E-01,     7.36E-01,       2.54E+00,       6.72E+00,       1.47E+01 },
        0 },
      { "Nb3+",  { 3.77E-01,    7.49E-01,       1.29E+00,       1.61E+00,       4.81E-01 },
        { 1.84E-01,     1.02E+00,       3.80E+00,       9.44E+00,       2.57E+01 },
        0 },
      { "Nb5+",  { 8.28E-02,    2.71E-01,       6.54E-01,       1.24E+00,       8.29E-01 },
        { 3.69E-02,     2.61E-01,       9.57E-01,       3.94E+00,       9.44E+00 },
        0 },
      { "Mo3+",  { 4.01E-01,    7.56E-01,       1.38E+00,       1.58E+00,       4.97E-01 },
        { 1.91E-01,     1.06E+00,       3.84E+00,       9.38E+00,       2.46E+01 },
        0 },
      { "Mo5+",  { 4.79E-01,    8.46E-01,       1.56E+01,       -1.52E+01,      1.60E+00 },
        { 2.41E-01,     1.46E+00,       6.79E+00,       7.13E+00,       1.04E+01 },
        0 },
      { "Mo6+",  { 2.03E-01,    5.67E-01,       6.46E-01,       1.16E+00,       1.71E-01 },
        { 9.71E-02,     6.47E-01,       2.28E+00,       5.61E+00,       1.24E+01 },
        0 },
      { "Ru3+",  { 4.28E-01,    7.73E-01,       1.55E+00,       1.46E+00,       4.86E-01 },
        { 1.91E-01,     1.09E+00,       3.82E+00,       9.08E+00,       2.17E+01 },
        0 },
      { "Ru4+",  { 2.82E-01,    6.53E-01,       1.14E+00,       1.53E+00,       4.18E-01 },
        { 1.25E-01,     7.53E-01,       2.85E+00,       7.01E+00,       1.75E+01 },
        0 },
      { "Rh3+",  { 3.52E-01,    7.23E-01,       1.50E+00,       1.63E+00,       4.99E-01 },
        { 1.51E-01,     8.78E-01,       3.28E+00,       8.16E+00,       2.07E+01 },
        0 },
      { "Rh4+",  { 3.97E-01,    7.25E-01,       1.51E+00,       1.19E+00,       2.51E-01 },
        { 1.77E-01,     1.01E+00,       3.62E+00,       8.56E+00,       1.89E+01 },
        0 },
      { "Pd2+",  { 9.35E-01,    3.11E+00,       2.46E+01,       -4.36E+01,      2.11E+01 },
        { 3.93E-01,     4.06E+00,       4.31E+01,       5.40E+01,       6.98E+01 },
        0 },
      { "Pd4+",  { 3.48E-01,    6.40E-01,       1.22E+00,       1.45E+00,       4.27E-01 },
        { 1.51E-01,     8.32E-01,       2.85E+00,       6.59E+00,       1.56E+01 },
        0 },
      { "Ag1+",  { 5.03E-01,    9.40E-01,       2.17E+00,       1.99E+00,       7.26E-01 },
        { 1.99E-01,     1.19E+00,       4.05E+00,       1.13E+01,       3.24E+01 },
        0 },
      { "Ag2+",  { 4.31E-01,    7.56E-01,       1.72E+00,       1.78E+00,       5.26E-01 },
        { 1.75E-01,     9.79E-01,       3.30E+00,       8.24E+00,       2.14E+01 },
        0 },
      { "Cd2+",  { 4.25E-01,    7.45E-01,       1.73E+00,       1.74E+00,       4.87E-01 },
        { 1.68E-01,     9.44E-01,       3.14E+00,       7.84E+00,       2.04E+01 },
        0 },
      { "In3+",  { 4.17E-01,    7.55E-01,       1.59E+00,       1.36E+00,       4.51E-01 },
        { 1.64E-01,     9.60E-01,       3.08E+00,       7.03E+00,       1.61E+01 },
        0 },
      { "Sn2+",  { 7.97E-01,    2.13E+00,       2.15E+00,       -1.64E+00,      2.72E+00 },
        { 3.17E-01,     2.51E+00,       9.04E+00,       2.42E+01,       2.64E+01 },
        0 },
      { "Sn4+",  { 2.61E-01,    6.42E-01,       1.53E+00, 1.36E+00, 1.77E-01 },
        { 9.57E-02,     6.25E-01,       2.51E+00,       6.31E+00,       1.59E+01 },
        0 },
      { "Sb3+",  { 5.52E-01,    1.14E+00,       1.87E+00,       1.36E+00,       4.14E-01 },
        { 2.12E-01,     1.42E+00,       4.21E+00,       1.25E+01,       2.90E+01 },
        0 },
      { "Sb5+",  { 3.77E-01,    5.88E-01,       1.22E+00,       1.18E+00,       2.44E-01 },
        { 1.51E-01,     8.12E-01,       2.40E+00,       5.27E+00,       1.19E+01 },
        0 },
      { "I1-",   { 9.01E-01,    2.80E+00,       5.61E+00, -8.69E+00, 1.26E+01 },
        { 3.12E-01, 2.59E+00, 1.41E+01, 3.44E+01, 3.95E+01 },
        0 },
      { "Cs1+",  { 5.87E-01, 1.40E+00, 1.87E+00, 3.48E+00, 1.67E+00 },
        { 2.00E-01, 1.38E+00, 4.12E+00, 1.30E+01, 3.18E+01 },
        0 },
      { "Ba2+",  { 7.33E-01, 2.05E+00, 2.30E+01, -1.52E+02, 1.34E+02 },
        { 2.58E-01, 1.96E+00, 1.18E+01, 1.44E+01, 1.49E+01 },
        0 },
      { "La3+",  { 4.93E-01, 1.10E+00, 1.50E+00, 2.70E-02, 1.08E+00 },
        { 1.67E-01, 1.11E+00, 3.11E+00, 9.61E+00, 2.12E+01 },
        0 },
      { "Ce3+",  { 5.60E-01, 1.35E+00, 1.59E+00, 2.63E+00, 7.06E-01 },
        { 1.90E-01, 1.30E+00, 3.93E+00, 1.07E+01, 2.38E+01 },
        0 },
      { "Ce4+",  { 4.83E-01, 1.09E+00, 1.34E+00, 2.45E+00, 7.97E-01 },
        { 1.65E-01, 1.10E+00, 3.02E+00, 8.85E+00, 1.88E+01 },
        0 },
      { "Pr3+",  { 6.63E-01, 1.73E+00, 2.35E+00, 3.51E-01, 1.59E+00 },
        { 2.26E-01, 1.61E+00, 6.33E+00, 1.10E+01, 1.69E+01 },
        0 },
      { "Pr4+",  { 5.21E-01, 1.19E+00, 1.33E+00, 2.36E+00, 6.90E-01 },
        { 1.77E-01, 1.17E+00, 3.28E+00, 8.94E+00, 1.93E+01 },
        0 },
      { "Nd3+",  { 5.01E-01, 1.18E+00, 1.45E+00, 2.53E+00, 9.20E-01 },
        { 1.62E-01, 1.08E+00, 3.06E+00, 8.80E+00, 1.96E+01 },
        0 },
      { "Pm3+",  { 4.96E-01, 1.20E+00, 1.47E+00, 2.43E+00, 9.43E-01 },
        { 1.56E-01, 1.05E+00, 3.07E+00, 8.56E+00, 1.92E+01 },
        0 },
      { "Sm3+",  { 5.18E-01, 1.24E+00, 1.43E+00, 2.40E+00, 7.81E-01 },
        { 1.63E-01, 1.08E+00, 3.11E+00, 8.52E+00, 1.91E+01 },
        0 },
      { "Eu2+",  { 6.13E-01, 1.53E+00, 1.84E+00, 2.46E+00, 7.14E-01 },
        { 1.90E-01, 1.27E+00, 4.18E+00, 1.07E+01, 2.62E+01 },
        0 },
      { "Eu3+",  { 4.96E-01, 1.21E+00, 1.45E+00, 2.36E+00, 7.74E-01 },
        { 1.52E-01, 1.01E+00, 2.95E+00, 8.18E+00, 1.85E+01 },
        0 },
      { "Gd3+",  { 4.90E+00, 1.19E-02, 1.42E+00, 2.30E+00, 7.95E-01 },
        { 1.48E-01, 9.74E-01, 2.81E+00, 7.78E+00, 1.77E+01 },
        0 },
      { "Tb3+",  { 5.03E-01, 1.22E+00, 1.42E+00, 2.24E+00, 7.10E-01 },
        { 1.50E-01, 9.82E-01, 2.86E+00, 7.77E+00, 1.77E+01 },
        0 },
      { "Dy3+",  { 5.03E-01, 1.24E+00, 1.44E+00, 2.17E+00, 6.43E-01 },
        { 1.48E-01, 9.70E-01, 2.88E+00, 7.73E+00, 1.76E+01 },
        0 },
      { "Ho3+",  { 4.56E-01, 1.17E+00, 1.43E+00, 2.15E+00, 6.92E-01 },
        { 1.29E-01, 8.69E-01, 2.61E+00, 7.24E+00, 1.67E+01 },
        0 },
      { "Er3+",  { 5.22E-01, 1.28E+00, 1.46E+00, 2.05E+00, 5.08E-01 },
        { 1.50E-01, 9.64E-01, 2.93E+00, 7.72E+00, 1.78E+01 },
        0 },
      { "Tm3+",  { 4.75E-01, 1.20E+00, 1.42E+00, 2.05E+00, 5.84E-01 },
        { 1.32E-01, 8.64E-01, 2.60E+00, 7.09E+00, 1.66E+01 },
        0 },
      { "Yb2+",  { 5.08E-01, 1.37E+00, 1.76E+00, 2.23E+00, 5.84E-01 },
        { 1.36E-01, 9.22E-01, 3.12E+00, 8.72E+00, 2.37E+01 },
        0 },
      { "Yb3+",  { 4.98E-01, 1.22E+00, 1.39E+00, 1.97E-02, 5.59E-01 },
        { 1.38E-01, 8.81E-01, 2.63E+00, 6.99E+00, 1.63E+01 },
        0 },
      { "Lu3+",  { 4.83E-01, 1.21E+00, 1.41E+00, 1.94E+00, 5.22E-01 },
        { 1.31E-01, 8.45E-01, 2.57E+00, 6.88E+00, 1.62E+01 },
        0 },
      { "Hf4+",  { 5.22E-01, 1.22E+00, 1.37E+00, 1.68E+00, 3.12E-01 },
        { 1.45E-01, 8.96E-01, 2.74E+00, 6.91E+00, 1.61E+01 },
        0 },
      { "Ta5+",  { 5.69E-01, 1.26E+00, 9.79E-01, 1.29E+00, 5.51E-01 },
        { 1.61E-01, 9.72E-01, 2.76E+00, 5.40E+00, 1.09E+01 },
        0 },
      { "W6+",   { 1.81E-01, 8.73E-01, 1.18E+00, 1.48E+00, 5.62E-01 },
        { 1.18E-02, 4.42E-01, 1.52E+00, 4.35E+00, 9.42E+00 },
        0 },
      { "Os4+",  { 5.86E-01, 1.31E+00, 1.63E+00, 1.71E+00, 5.40E-01 },
        { 1.55E-01, 9.38E-01, 3.19E+00, 7.84E+00, 1.93E+01 },
        0 },
      { "Ir3+",  { 6.92E-01, 1.37E+00, 1.80E+00, 1.97E+00, 8.04E-01 },
        { 1.82E-01, 1.04E+00, 3.47E+00, 8.51E+00, 2.12E+01 },
        0 },
      { "Ir4+",  { 6.53E-01, 1.29E+00, 1.50E+00, 1.74E+00, 6.83E-01 },
        { 1.74E-01, 9.92E-01, 3.14E+00, 7.22E+00, 1.72E+01 },
        0 },
      { "Pt2+",  { 8.72E-01, 1.68E+00, 2.63E+00, 1.93E+00, 4.75E-01 },
        { 2.23E-01, 1.35E+00, 4.99E+00, 1.36E+01, 3.30E+01 },
        0 },
      { "Pt4+",  { 5.50E-01, 1.21E+00, 1.62E+00, 1.95E+00, 6.10E-01 },
        { 1.42E-01, 8.33E-01, 2.81E+00, 7.21E+00, 1.77E+01 },
        0 },
      { "Au1+",  { 8.11E-01, 1.57E+00, 2.63E+00, 2.68E+00, 9.98E-01 },
        { 2.01E-01, 1.18E+00, 4.25E+00, 1.21E+01, 3.44E+01 },
        0 },
      { "Au3+",  { 7.22E-01, 1.39E+00, 1.94E+00, 1.94E+00, 6.99E-01 },
        { 1.84E-01, 1.06E+00, 3.58E+00, 8.56E+00, 2.04E+01 },
        0 },
      { "Hg1+",  { 7.96E-01, 1.56E+00, 2.72E+00, 2.76E+00, 1.18E+00 },
        { 1.94E-01, 1.14E+00, 4.21E+00, 1.24E+01, 3.62E+01 },
        0 },
      { "Hg2+",  { 7.73E-01, 1.49E+00, 2.45E+00, 2.23E+00, 5.70E-01 },
        { 1.91E-01, 1.12E+00, 4.00E+00, 1.08E+01, 2.76E+01 },
        0 },
      { "Tl1+",  { 8.20E-01, 1.57E+00, 2.78E+00, 2.82E+00, 1.31E+00 },
        { 1.97E-01, 1.16E+00, 4.23E+00, 1.27E+01, 3.57E+01 },
        0 },
      { "Tl3+",  { 8.36E-01, 1.43E+00, 3.94E-01, 2.51E+00, 1.50E+00 },
        { 2.08E-01, 1.20E+00, 2.57E+00, 4.86E+00, 1.35E+01 },
        0 },
      { "Pb2+",  { 7.55E-01, 1.44E+00, 2.48E+00, 2.45E+00, 1.03E+00 },
        { 1.81E-01, 1.05E+00, 3.75E+00, 1.06E+01, 2.79E+01 },
        0 },
      { "Pb4+",  { 5.83E-01, 1.14E+00, 1.60E+00, 2.06E+00, 6.62E-01 },
        { 1.44E-01, 7.96E-01, 2.58E+00, 6.22E+00, 1.48E+01 },
        0 },
      { "Bi3+",  { 7.08E-01, 1.35E+00, 2.28E+00, 2.18E+00, 7.97E-01 },
        { 1.70E-01, 9.81E-01, 3.44E+00, 9.41E+00, 2.37E+01 },
        0 },
      { "Bi5+",  { 6.54E-01, 1.18E+00, 1.25E+00, 1.66E+00, 7.78E-01 },
        { 1.62E-01, 9.05E-01, 2.68E+00, 5.14E+00, 1.12E+01 },
        0 },
      { "Ra2+",  { 9.11E-01, 1.65E+00, 2.53E+00, 3.62E+00, 1.58E+00 },
        { 2.04E-01, 1.26E+00, 4.03E+00, 1.26E+01, 3.00E+01 },
        0 },
      { "Ac3+",  { 9.15E-01, 1.64E+00, 2.26E+00, 3.18E+00, 1.25E+00 },
        { 2.05E-01, 1.28E+00, 3.92E+00, 1.13E+01, 2.51E+01 },
        0 },
      { "U3+",   { 1.14E+00, 2.48E+00, 3.61E+00, 1.13E-02, 9.00E-01 },
        { 2.50E-01, 1.84E+00, 7.39E+00, 1.80E+01, 2.27E+01 },
        0 },
      { "U4+",   { 1.09E+00, 2.32E+00, 1.20E+01, -9.11E+00, 2.15E+00 },
        { 2.43E-01, 1.75E+00, 7.79E+00, 8.31E+00, 1.65E+01 },
        0 },
      { "U6+",   { 6.87E-01, 1.14E+00, 1.83E+00, 2.53E+00, 9.57E-01 },
        { 1.54E-01, 8.61E-01, 2.58E+00, 7.70E+00, 1.59E+01 },
        0 },
      { 0,       { 0., 0., 0., 0., 0. },
        { 0., 0., 0., 0., 0. },
        0. }

// END_COMPILED_IN_REFERENCE_DATA
    };

  } // namespace <anonymous>

  peng1996::peng1996(std::string const& label, bool exact)
  :
  xray_scattering::base<5>(peng1996_raw_table, "PENG1996", label, exact)
  {}

  peng1996_iterator::peng1996_iterator()
  :
  current_("H", true)
  {}

  peng1996
  peng1996_iterator::next()
  {
    peng1996 result = current_;
    current_.next_entry();
    return result;
  }

}}} // namespace cctbx::eltbx::electron_scattering
