/* *****************************************************
   THIS IS AN AUTOMATICALLY GENERATED FILE. DO NOT EDIT.
   *****************************************************

   Generated by:
     scitbx.generate_error_h
 */

/*! \file
    Declarations and macros for exception handling.
 */

#ifndef SMTBX_ERROR_H
#define SMTBX_ERROR_H

#include <scitbx/error_utils.h>

#define SMTBX_CHECK_POINT \
  std::cout << __FILE__ << "(" << __LINE__ << ")" << std::endl << std::flush
#define SMTBX_CHECK_POINT_MSG(msg) \
  std::cout << msg << " @ " __FILE__ << "(" << __LINE__ << ")" << std::endl << std::flush
#define SMTBX_EXAMINE(A) \
  std::cout << "variable " << #A << ": " << A << std::endl << std::flush

//! Common smtbx namespace.
namespace smtbx {

  //! All smtbx exceptions are derived from this class.
  class error : public ::scitbx::error_base<error>
  {
    public:

      //! General smtbx error message.
      explicit
      error(std::string const& msg) throw()
        : ::scitbx::error_base<error>("smtbx", msg)
      {}

      //! Error message with file name and line number.
      /*! Used by the macros below.
       */
      error(const char* file, long line, std::string const& msg = "",
            bool internal = true) throw()
        : ::scitbx::error_base<error>("smtbx", file, line, msg, internal)
      {}
  };

  //! Special class for "Index out of range." exceptions.
  /*! These exceptions are propagated to Python as IndexError.
   */
  class error_index : public error
  {
    public:
      //! Default constructor. The message may be customized.
      explicit
      error_index(std::string const& msg = "Index out of range.") throw()
        : error(msg)
      {}
  };

} // namespace smtbx

//! For throwing an error exception with file name, line number, and message.
#define SMTBX_ERROR(msg) \
  SCITBX_ERROR_UTILS_REPORT(smtbx::error, msg)
//! For throwing an "Internal Error" exception.
#define SMTBX_INTERNAL_ERROR() \
  SCITBX_ERROR_UTILS_REPORT_INTERNAL(smtbx::error)
//! For throwing a "Not implemented" exception.
#define SMTBX_NOT_IMPLEMENTED() \
  SCITBX_ERROR_UTILS_REPORT_NOT_IMPLEMENTED(smtbx::error)

//! Custom smtbx assertion.
#define SMTBX_ASSERT(assertion) \
  SCITBX_ERROR_UTILS_ASSERT(smtbx::error, SMTBX_ASSERT, assertion)

#endif // SMTBX_ERROR_H
