/*
 * Decompiled with CFR 0.152.
 */
package opendap.servers.test;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import opendap.dap.DAP2Exception;
import opendap.dap.DAS;
import opendap.dap.Server.ServerDDS;
import opendap.dap.parser.ParseException;
import opendap.servers.test.test_ServerFactory;
import opendap.servlet.GuardedDataset;
import opendap.servlet.ReqState;
import opendap.util.Debug;

public class testDataset
implements GuardedDataset {
    private ReqState rs;
    private Exception DDXfailure;
    private Exception DDSfailure;

    testDataset(ReqState rs) {
        this.rs = rs;
    }

    public void release() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerDDS getDDS() throws DAP2Exception, ParseException {
        ServerDDS myDDS;
        block10: {
            myDDS = null;
            FilterInputStream dds_source = null;
            try {
                myDDS = this.getMyDDS();
                dds_source = this.openCachedDDX(this.rs);
                if (dds_source != null) {
                    myDDS.parseXML(dds_source, true);
                    break block10;
                }
                dds_source = this.openCachedDDS(this.rs);
                if (dds_source != null) {
                    myDDS.parse(dds_source);
                    myDDS.ingestDAS(this.getDAS());
                    break block10;
                }
                throw new DAP2Exception(5, "Cannot find a DDX or DDS file that matches the Dataset you have requested.\n" + this.getClass().getName() + ".openCachedDDX() said: " + this.DDXfailure.getMessage() + "\n" + this.getClass().getName() + ".openCachedDDS() said: " + this.DDSfailure.getMessage() + "\n");
            }
            finally {
                try {
                    if (dds_source != null) {
                        dds_source.close();
                    }
                }
                catch (IOException ioe) {
                    throw new DAP2Exception(0, ioe.getMessage());
                }
            }
        }
        return myDDS;
    }

    public DataInputStream openCachedDDX(ReqState rs) {
        String cacheDir = rs.getDDXCache();
        if (Debug.isSet("probeRequest")) {
            System.out.println("DDXCache: " + cacheDir);
            System.out.println("Attempting to open: '" + cacheDir + rs.getDataSet() + "'");
        }
        try {
            File fin = new File(cacheDir + rs.getDataSet());
            FileInputStream fp_in = new FileInputStream(fin);
            DataInputStream ddx_source = new DataInputStream(fp_in);
            return ddx_source;
        }
        catch (FileNotFoundException fnfe) {
            this.DDXfailure = fnfe;
            return null;
        }
    }

    public DataInputStream openCachedDDS(ReqState rs) {
        String cacheDir = rs.getDDSCache();
        if (Debug.isSet("probeRequest")) {
            System.out.println("DDSCache: " + cacheDir);
            System.out.println("Attempting to open: '" + cacheDir + rs.getDataSet() + "'");
        }
        try {
            File fin = new File(cacheDir + rs.getDataSet());
            FileInputStream fp_in = new FileInputStream(fin);
            DataInputStream dds_source = new DataInputStream(fp_in);
            return dds_source;
        }
        catch (FileNotFoundException fnfe) {
            this.DDSfailure = fnfe;
            return null;
        }
    }

    private ServerDDS getMyDDS() {
        ServerDDS myDDS = null;
        test_ServerFactory sfactory = new test_ServerFactory();
        myDDS = new ServerDDS(this.rs.getDataSet(), sfactory, this.rs.getSchemaLocation());
        return myDDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DAS getDAS() throws DAP2Exception, ParseException {
        DataInputStream is = null;
        DAS myDAS = null;
        boolean gotDDX = false;
        boolean gotDDS = false;
        boolean gotDAS = false;
        ServerDDS myDDS = this.getMyDDS();
        DataInputStream dds_source = this.openCachedDDX(this.rs);
        if (dds_source != null) {
            myDDS.parseXML(dds_source, true);
            myDAS = myDDS.getDAS();
            gotDDX = true;
        } else {
            dds_source = this.openCachedDDS(this.rs);
            if (dds_source != null) {
                myDDS.parse(dds_source);
                gotDDS = true;
                System.out.println("Got DDS.");
            }
            myDAS = new DAS();
            try {
                is = this.openCachedDAS(this.rs);
                myDAS.parse(is);
                gotDAS = true;
                System.out.println("Got DAS.");
                if (gotDDS) {
                    myDDS.ingestDAS(myDAS);
                    System.out.println("DDS ingested DAS.");
                    myDAS = myDDS.getDAS();
                }
            }
            catch (FileNotFoundException fnfe) {
                if (gotDDS) {
                    myDAS = myDDS.getDAS();
                }
                gotDAS = false;
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException ioe) {
                    throw new DAP2Exception(0, ioe.getMessage());
                }
            }
        }
        if (gotDAS) {
            if (gotDDX) {
                System.out.println("Got DAS from DDX for dataset: " + this.rs.getDataSet());
            } else if (gotDDS) {
                System.out.println("Got DAS, popped it into a DDS, and got back a complete DAS for dataset: " + this.rs.getDataSet());
            } else {
                System.out.println("Successfully opened and parsed DAS cache for dataset: " + this.rs.getDataSet());
            }
        } else if (gotDDS) {
            System.out.println("No DAS! Got a DDS, and sent a complete (but empty) DAS for dataset: " + this.rs.getDataSet());
        } else {
            System.out.println("No DAS or DDS present for dataset: " + this.rs.getDataSet());
        }
        return myDAS;
    }

    public DataInputStream openCachedDAS(ReqState rs) throws FileNotFoundException {
        String cacheDir = rs.getDASCache();
        if (Debug.isSet("probeRequest")) {
            System.out.println("DASCache: " + cacheDir);
            System.out.println("Attempting to open: '" + cacheDir + rs.getDataSet() + "'");
        }
        File fin = new File(cacheDir + rs.getDataSet());
        FileInputStream fp_in = new FileInputStream(fin);
        DataInputStream das_source = new DataInputStream(fp_in);
        return das_source;
    }
}

