/* bottle.c
**
**    code for high quality bottle, glass
**
**    Updated Version foobillard++ started at 12/2010
**    Copyright (C) 2010 - 2013 Holger Schaekel (foobillardplus@go4more.de)
**
**    This program is free software; you can redistribute it and/or modify
**    it under the terms of the GNU General Public License Version 2 as
**    published by the Free Software Foundation;
**
**    This program is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.
**
**    You should have received a copy of the GNU General Public License
**    along with this program; if not, write to the Free Software
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
*/

#include <stdio.h>
#include <stdlib.h>
#include "bottle.h"

static int bottle_id = -1;

/***********************************************************************
 *        This is a general routine to make a new material active      *
 ***********************************************************************/
void bottle_Material_Parameters(float shininess, float r_diffuseColor, float g_diffuseColor, float b_diffuseColor, float r_specularColor, float g_specularColor, float b_specularColor) {
	GLfloat glfModelSpecular[4];

	// This causes the polygon's ambient & diffuse colors to be derived from the glColor() value.
	glColorMaterial(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE);
	glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, shininess);
	/* Set the specular shading color. */
	glfModelSpecular[0] = r_specularColor;
	glfModelSpecular[1] = g_specularColor;
	glfModelSpecular[2] = b_specularColor;
	glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, glfModelSpecular);
	glColor3f(r_diffuseColor, g_diffuseColor, b_diffuseColor);
}

/***********************************************************************
 *                          Make an glcallist                          *
 ***********************************************************************/

void init_bottle(void) {
	 if(bottle_id != -1) {
	 	glDeleteLists(bottle_id,1);
	 }
  fprintf(stderr,"Initialize bottle graphics\n");
  bottle_id = glGenLists(1);
  glNewList(bottle_id, GL_COMPILE);
  bottle();
  glEndList();
}

/***********************************************************************
 *                         display the bottle                           *
 ***********************************************************************/

void display_bottle(void) {
	 if(bottle_id == -1) {
	 	init_bottle();
	 } else {
	 	glCallList(bottle_id);
	 }
}

/***********************************************************************
 *                           build the bottle                          *
 *                 Polygons for object (1506 polygons)                 *
 ***********************************************************************/

void bottle(void) {
	static const GLfloat VertexData[] = {
		-3.88940f, -0.174219f, 3.32862f, -3.88939f, -0.157863f, 3.32861f, -3.88937f, -0.137607f, 3.32861f, 
		-3.88935f, -0.114749f, 3.32861f, -3.88932f, -0.0905820f, 3.32861f, 
		-3.88930f, -0.0664040f, 3.32861f, -3.88928f, -0.0435090f, 3.32861f, 
		-3.88927f, 0.00695608f, 3.32864f, -3.88926f, -0.0231940f, 3.32861f, 
		-3.88924f, -0.00675300f, 3.32861f, -3.88921f, -0.185379f, 3.33298f, 
		-3.88912f, -0.191561f, 3.33309f, -3.88889f, -0.174219f, 3.32009f, 
		-3.88888f, -0.157863f, 3.32009f, -3.88886f, -0.137607f, 3.32009f, 
		-3.88884f, -0.114749f, 3.32009f, -3.88881f, -0.0905820f, 3.32010f, 
		-3.88879f, -0.0664040f, 3.32010f, -3.88877f, -0.0435090f, 3.32010f, 
		-3.88875f, -0.0231940f, 3.32011f, -3.88874f, -0.00675300f, 3.32011f, 
		-3.88824f, -0.174219f, 3.33708f, -3.88822f, -0.157863f, 3.33708f, 
		-3.88822f, -0.185380f, 3.31592f, -3.88821f, -0.137607f, 3.33707f, 
		-3.88818f, -0.114749f, 3.33707f, -3.88816f, -0.0905820f, 3.33706f, 
		-3.88814f, -0.0664040f, 3.33706f, -3.88812f, -0.0435090f, 3.33705f, 
		-3.88810f, -0.0231940f, 3.33705f, -3.88808f, -0.00675300f, 3.33705f, 
		-3.88807f, 0.00696432f, 3.31588f, -3.88798f, 0.0209354f, 3.33116f, 
		-3.88795f, -0.192767f, 3.31620f, -3.88752f, 0.0167670f, 3.31600f, 
		-3.88710f, 0.00696435f, 3.34120f, -3.88673f, -0.174219f, 3.31182f, 
		-3.88671f, -0.157863f, 3.31182f, -3.88669f, -0.137607f, 3.31183f, 
		-3.88667f, -0.114749f, 3.31184f, -3.88665f, -0.0905820f, 3.31185f, 
		-3.88663f, -0.0664040f, 3.31185f, -3.88661f, -0.0435090f, 3.31186f, 
		-3.88659f, -0.0231940f, 3.31187f, -3.88658f, -0.00675300f, 3.31187f, 
		-3.88657f, 0.0167667f, 3.34100f, -3.88640f, -0.195139f, 3.33684f, 
		-3.88550f, -0.190162f, 3.34515f, -3.88545f, -0.174219f, 3.34516f, 
		-3.88543f, -0.157863f, 3.34515f, -3.88542f, -0.137607f, 3.34515f, 
		-3.88540f, -0.114749f, 3.34514f, -3.88537f, -0.0905820f, 3.34513f, 
		-3.88535f, -0.0664040f, 3.34512f, -3.88533f, -0.0435090f, 3.34511f, 
		-3.88532f, -0.0231940f, 3.34510f, -3.88530f, -0.00675300f, 3.34509f, 
		-3.88504f, -0.188420f, 3.32845f, -3.88502f, 0.0137186f, 3.32845f, 
		-3.88457f, -0.187335f, 3.32077f, -3.88457f, 0.00856900f, 3.32077f, 
		-3.88456f, 0.0282833f, 3.31732f, -3.88399f, 0.00856900f, 3.33607f, 
		-3.88396f, -0.190056f, 3.33606f, -3.88372f, 0.0301060f, 3.33701f, 
		-3.88327f, 0.0232179f, 3.30870f, -3.88299f, -0.174219f, 3.30413f, 
		-3.88298f, -0.157863f, 3.30414f, -3.88296f, -0.137607f, 3.30415f, 
		-3.88294f, -0.114749f, 3.30416f, -3.88292f, -0.0905820f, 3.30417f, 
		-3.88290f, -0.0664040f, 3.30418f, -3.88288f, -0.0435090f, 3.30419f, 
		-3.88286f, -0.0122374f, 3.30421f, -3.88262f, -0.196470f, 3.31116f, 
		-3.88262f, 0.0137212f, 3.31334f, -3.88261f, -0.189989f, 3.31334f, 
		-3.88238f, -0.189863f, 3.30283f, -3.88224f, -0.193195f, 3.32266f, 
		-3.88216f, 0.0253954f, 3.32835f, -3.88181f, 0.0232178f, 3.34793f, 
		-3.88147f, -0.187335f, 3.34333f, -3.88146f, 0.0137205f, 3.34333f, 
		-3.88115f, 0.0254640f, 3.31774f, -3.88114f, -0.179801f, 3.35254f, 
		-3.88112f, -0.157863f, 3.35253f, -3.88110f, -0.137607f, 3.35252f, 
		-3.88108f, -0.114749f, 3.35250f, -3.88107f, -0.0905820f, 3.35249f, 
		-3.88105f, -0.0664040f, 3.35248f, -3.88103f, -0.0435090f, 3.35246f, 
		-3.88102f, -0.0231940f, 3.35245f, -3.88101f, 0.00695641f, 3.35248f, 
		-3.88101f, 0.0356668f, 3.33172f, -3.88100f, -0.00675300f, 3.35244f, 
		-3.88097f, -0.197287f, 3.32484f, -3.88061f, 0.00696406f, 3.30056f, 
		-3.88031f, 0.0254652f, 3.33891f, -3.88016f, 0.0167671f, 3.30088f, 
		-3.87927f, -0.187335f, 3.30642f, -3.87927f, 0.00856900f, 3.30642f, 
		-3.87880f, 0.0381780f, 3.32013f, -3.87813f, -0.193627f, 3.34172f, 
		-3.87810f, 0.0167670f, 3.35552f, -3.87805f, -0.194156f, 3.29885f, 
		-3.87783f, -0.179802f, 3.29732f, -3.87781f, -0.157863f, 3.29733f, 
		-3.87780f, -0.137607f, 3.29734f, -3.87778f, -0.114749f, 3.29736f, 
		-3.87777f, -0.0905820f, 3.29737f, -3.87763f, -0.197229f, 3.34558f, 
		-3.87760f, -0.188420f, 3.34997f, -3.87759f, 0.00856900f, 3.34997f, 
		-3.87743f, 0.0348086f, 3.32511f, -3.87694f, -0.195226f, 3.35484f, 
		-3.87662f, -0.189863f, 3.35808f, -3.87640f, 0.0310618f, 3.30369f, 
		-3.87573f, 0.0348086f, 3.33733f, -3.87546f, -0.174219f, 3.35893f, 
		-3.87545f, -0.157863f, 3.35892f, -3.87544f, -0.137607f, 3.35891f, 
		-3.87542f, -0.114749f, 3.35889f, -3.87541f, -0.0905820f, 3.35887f, 
		-3.87540f, 0.0264109f, 3.30599f, -3.87539f, -0.0664040f, 3.35886f, 
		-3.87538f, -0.0435090f, 3.35884f, -3.87536f, -0.0231940f, 3.35883f, 
		-3.87535f, -0.00675300f, 3.35881f, -3.87475f, -0.00675241f, 3.29426f, 
		-3.87462f, -0.188420f, 3.30029f, -3.87461f, 0.0137187f, 3.30030f, 
		-3.87460f, 0.0310617f, 3.35238f, -3.87455f, 0.0436244f, 3.33085f, 
		-3.87440f, -0.193603f, 3.32623f, -3.87434f, -0.197289f, 3.30534f, 
		-3.87356f, 0.0399519f, 3.31034f, -3.87353f, 0.0364233f, 3.31408f, 
		-3.87277f, 0.0411721f, 3.34261f, -3.87275f, 0.0209362f, 3.29424f, 
		-3.87257f, 0.0307349f, 3.34858f, -3.87248f, 0.0137189f, 3.35572f, 
		-3.87247f, -0.190102f, 3.35571f, -3.87227f, -0.196964f, 3.33607f, 
		-3.87222f, 0.00696413f, 3.36172f, -3.87143f, -0.174219f, 3.29165f, 
		-3.87143f, -0.190161f, 3.29160f, -3.87142f, -0.157863f, 3.29166f, 
		-3.87141f, -0.137607f, 3.29168f, -3.87140f, -0.114749f, 3.29170f, 
		-3.87139f, -0.0905820f, 3.29171f, -3.87035f, -0.196738f, 3.32202f, 
		-3.87027f, 0.0434883f, 3.33038f, -3.87023f, 0.0209464f, 3.36156f, 
		-3.87004f, 0.0484182f, 3.32015f, -3.86889f, 0.0441003f, 3.31916f, 
		-3.86887f, -0.187335f, 3.29519f, -3.86883f, 0.0152264f, 3.29523f, 
		-3.86870f, -0.190162f, 3.36411f, -3.86865f, -0.174219f, 3.36409f, 
		-3.86864f, -0.157863f, 3.36408f, -3.86863f, -0.137607f, 3.36407f, 
		-3.86862f, -0.114749f, 3.36405f, -3.86861f, 0.0304951f, 3.30136f, 
		-3.86861f, -0.0905820f, 3.36403f, -3.86860f, -0.0664040f, 3.36401f, 
		-3.86859f, -0.0435090f, 3.36399f, -3.86858f, -0.0231940f, 3.36397f, 
		-3.86857f, -0.00675300f, 3.36396f, -3.86809f, -0.192096f, 3.29602f, 
		-3.86787f, 0.00696426f, 3.28926f, -3.86785f, 0.0254653f, 3.35605f, 
		-3.86636f, -0.187335f, 3.36037f, -3.86636f, 0.00856900f, 3.36037f, 
		-3.86629f, -0.191394f, 3.33474f, -3.86590f, 0.0417192f, 3.30377f, 
		-3.86546f, 0.0526433f, 3.33564f, -3.86518f, 0.0310616f, 3.29377f, 
		-3.86473f, 0.0411715f, 3.35172f, -3.86464f, -0.193960f, 3.35283f, 
		-3.86426f, 0.0440114f, 3.34339f, -3.86424f, 0.0570138f, 3.32209f, 
		-3.86406f, -0.195353f, 3.33369f, -3.86405f, -0.174219f, 3.28733f, 
		-3.86405f, -0.157863f, 3.28735f, -3.86404f, -0.137607f, 3.28737f, 
		-3.86403f, -0.114749f, 3.28738f, -3.86402f, -0.0905820f, 3.28741f, 
		-3.86376f, -0.196177f, 3.31522f, -3.86357f, 0.0198206f, 3.28837f, 
		-3.86297f, 0.0722143f, 3.32707f, -3.86282f, -0.189862f, 3.28659f, 
		-3.86267f, 0.133318f, 3.32959f, -3.86250f, 0.121801f, 3.32528f, 
		-3.86243f, 0.0971989f, 3.32922f, -3.86230f, 0.0418437f, 3.30656f, 
		-3.86223f, -0.188420f, 3.29130f, -3.86223f, 0.00856900f, 3.29131f, 
		-3.86204f, 0.0972001f, 3.32270f, -3.86184f, 0.140207f, 3.33224f, 
		-3.86182f, -0.197239f, 3.35934f, -3.86160f, 0.122079f, 3.33250f, 
		-3.86153f, 0.0576784f, 3.32444f, -3.86138f, 0.0623165f, 3.32754f, 
		-3.86133f, 0.122738f, 3.31955f, -3.86132f, 0.133316f, 3.31926f, 
		-3.86127f, 0.0655056f, 3.33451f, -3.86121f, 0.0767368f, 3.31921f, 
		-3.86121f, 0.0578525f, 3.33063f, -3.86107f, 0.0914200f, 3.33421f, 
		-3.86097f, -0.179801f, 3.36784f, -3.86096f, -0.157863f, 3.36782f, 
		-3.86095f, -0.137607f, 3.36780f, -3.86094f, -0.114749f, 3.36778f, 
		-3.86094f, -0.0905820f, 3.36776f, -3.86093f, -0.192993f, 3.30524f, 
		-3.86093f, -0.0664040f, 3.36774f, -3.86092f, -0.0435090f, 3.36772f, 
		-3.86091f, -0.0231940f, 3.36770f, -3.86091f, -0.00675300f, 3.36768f, 
		-3.86089f, 0.00695625f, 3.36772f, -3.86078f, 0.138784f, 3.32752f, 
		-3.86061f, 0.138784f, 3.32459f, -3.86057f, 0.0198197f, 3.36676f, 
		-3.86055f, 0.0300929f, 3.36329f, -3.86043f, 0.0623157f, 3.32155f, 
		-3.86038f, 0.138784f, 3.33042f, -3.86007f, -0.186848f, 3.32466f, 
		-3.85997f, 0.0623124f, 3.33344f, -3.85986f, 0.138784f, 3.32175f, 
		-3.85962f, 0.0348089f, 3.35542f, -3.85946f, -0.194156f, 3.36745f, 
		-3.85943f, 0.0152270f, 3.36368f, -3.85943f, 0.138784f, 3.33319f, 
		-3.85942f, -0.191093f, 3.36366f, -3.85940f, -0.00675212f, 3.28549f, 
		-3.85910f, 0.0623134f, 3.31880f, -3.85907f, -0.196407f, 3.34534f, 
		-3.85904f, 0.109002f, 3.31693f, -3.85901f, -0.196422f, 3.28931f, 
		-3.85891f, 0.140207f, 3.31690f, -3.85883f, 0.0635902f, 3.31509f, 
		-3.85881f, 0.133316f, 3.33846f, -3.85863f, 0.0578545f, 3.33623f, 
		-3.85862f, 0.0553750f, 3.34167f, -3.85858f, 0.138784f, 3.31912f, 
		-3.85849f, -0.196761f, 3.30535f, -3.85827f, 0.122079f, 3.33811f, 
		-3.85811f, 0.0278124f, 3.29350f, -3.85794f, 0.138784f, 3.33572f, 
		-3.85750f, 0.0576785f, 3.31615f, -3.85723f, 0.0972172f, 3.33931f, 
		-3.85701f, -0.194156f, 3.28569f, -3.85681f, 0.138784f, 3.31678f, 
		-3.85666f, 0.0526443f, 3.30812f, -3.85641f, 0.0623129f, 3.33836f, 
		-3.85634f, 0.0722047f, 3.34063f, -3.85600f, 0.138784f, 3.33792f, 
		-3.85598f, -0.179802f, 3.28454f, -3.85597f, 0.00695621f, 3.28467f, 
		-3.85597f, -0.157863f, 3.28456f, -3.85597f, -0.137607f, 3.28457f, 
		-3.85596f, -0.114749f, 3.28460f, -3.85596f, -0.0905820f, 3.28462f, 
		-3.85595f, 0.0411717f, 3.29747f, -3.85547f, 0.0899863f, 3.31298f, 
		-3.85541f, 0.122353f, 3.31302f, -3.85528f, -0.193801f, 3.29222f, 
		-3.85497f, 0.0623159f, 3.31435f, -3.85496f, -0.187335f, 3.28879f, 
		-3.85496f, 0.0137194f, 3.28881f, -3.85488f, 0.0356674f, 3.36126f, 
		-3.85462f, 0.138784f, 3.31484f, -3.85456f, 0.0360008f, 3.29715f, 
		-3.85445f, -0.189942f, 3.33452f, -3.85413f, -0.189863f, 3.36993f, 
		-3.85409f, -0.197287f, 3.29248f, -3.85398f, 0.0623164f, 3.34020f, 
		-3.85384f, -0.188195f, 3.34192f, -3.85366f, 0.138784f, 3.33969f, 
		-3.85322f, 0.0436246f, 3.35496f, -3.85307f, 0.0209464f, 3.28521f, 
		-3.85305f, 0.122079f, 3.34202f, -3.85288f, 0.133317f, 3.31130f, 
		-3.85269f, -0.174219f, 3.37000f, -3.85269f, -0.157863f, 3.36998f, 
		-3.85269f, -0.137607f, 3.36996f, -3.85269f, -0.114749f, 3.36994f, 
		-3.85268f, -0.0905820f, 3.36992f, -3.85268f, -0.0664040f, 3.36990f, 
		-3.85268f, -0.0435090f, 3.36987f, -3.85267f, -0.0231940f, 3.36986f, 
		-3.85267f, -0.00675300f, 3.36984f, -3.85244f, -0.197062f, 3.36404f, 
		-3.85234f, 0.0623130f, 3.31281f, -3.85209f, 0.138784f, 3.31336f, 
		-3.85201f, -0.187335f, 3.36568f, -3.85201f, 0.00856900f, 3.36568f, 
		-3.85201f, 0.0434886f, 3.35083f, -3.85191f, -0.185917f, 3.31574f, 
		-3.85163f, 0.0972178f, 3.34273f, -3.85135f, 0.0576798f, 3.34184f, 
		-3.85103f, 0.138784f, 3.34097f, -3.85095f, 0.0229063f, 3.29005f, 
		-3.85089f, -0.185961f, 3.32263f, -3.85089f, 0.0549593f, 3.34591f, 
		-3.85041f, 0.0309319f, 3.36088f, -3.85034f, -0.193036f, 3.35359f, 
		-3.85011f, 0.140207f, 3.34287f, -3.85000f, -0.196854f, 3.35304f, 
		-3.84996f, -0.193886f, 3.31081f, -3.84954f, 0.0688885f, 3.30975f, 
		-3.84952f, 0.0578523f, 3.31157f, -3.84932f, 0.138784f, 3.31240f, 
		-3.84900f, 0.0443544f, 3.30284f, -3.84867f, 0.133317f, 3.34386f, 
		-3.84852f, 0.0803319f, 3.34386f, -3.84845f, 0.00696426f, 3.37052f, 
		-3.84843f, 0.0198663f, 3.36950f, -3.84832f, 0.0301055f, 3.28782f, 
		-3.84828f, 0.0623156f, 3.34231f, -3.84819f, 0.138784f, 3.34171f, 
		-3.84819f, 0.0582954f, 3.30847f, -3.84809f, 0.109001f, 3.31053f, 
		-3.84808f, 0.0195076f, 3.36509f, -3.84799f, 0.140207f, 3.31060f, 
		-3.84751f, -0.174219f, 3.28338f, -3.84751f, -0.157863f, 3.28339f, 
		-3.84751f, -0.137607f, 3.28341f, -3.84751f, -0.114749f, 3.28343f, 
		-3.84751f, -0.0905820f, 3.28346f, -3.84748f, -0.190162f, 3.28334f, 
		-3.84734f, 0.00856900f, 3.28775f, -3.84734f, -0.190056f, 3.28777f, 
		-3.84685f, -0.196854f, 3.30053f, -3.84674f, 0.122080f, 3.34363f, 
		-3.84643f, 0.0623170f, 3.31140f, -3.84643f, -0.0935485f, 3.21211f, 
		-3.84641f, 0.138784f, 3.31200f, -3.84584f, 0.138784f, 3.32694f, 
		-3.84580f, -0.182985f, 3.33037f, -3.84570f, -0.0935486f, 3.19390f, 
		-3.84526f, 0.138784f, 3.34189f, -3.84522f, 0.0578534f, 3.34274f, 
		-3.84494f, -0.193620f, 3.34298f, -3.84490f, 0.122744f, 3.30952f, 
		-3.84482f, 0.0857972f, 3.30976f, -3.84441f, -0.0934633f, 3.20809f, 
		-3.84434f, 0.0933194f, 3.34377f, -3.84433f, -0.189231f, 3.36614f, 
		-3.84433f, 0.00856900f, 3.36614f, -3.84421f, -0.0934632f, 3.19946f, 
		-3.84417f, -0.0231940f, 3.37036f, -3.84417f, -0.00675300f, 3.37035f, 
		-3.84417f, -0.0435090f, 3.37038f, -3.84417f, -0.0664040f, 3.37041f, 
		-3.84417f, -0.0905820f, 3.37043f, -3.84417f, -0.137607f, 3.37047f, 
		-3.84417f, -0.114749f, 3.37045f, -3.84417f, -0.157863f, 3.37049f, 
		-3.84416f, -0.179801f, 3.37051f, -3.84413f, 0.0463977f, 3.30065f, 
		-3.84384f, 0.0304963f, 3.29275f, -3.84366f, 0.0356672f, 3.29152f, 
		-3.84349f, 0.138784f, 3.31217f, -3.84344f, 0.0686262f, 3.34420f, 
		-3.84336f, 0.0578548f, 3.31133f, -3.84323f, 0.0167672f, 3.28393f, 
		-3.84322f, 0.00696412f, 3.28337f, -3.84317f, -0.00675237f, 3.28339f, 
		-3.84311f, 0.133318f, 3.30989f, -3.84282f, -0.145071f, 3.21234f, 
		-3.84280f, -0.0934632f, 3.21658f, -3.84252f, -0.193058f, 3.30095f, 
		-3.84236f, 0.138784f, 3.34149f, -3.84231f, -0.153196f, 3.19673f, 
		-3.84222f, -0.0934631f, 3.19105f, -3.84222f, 0.0623131f, 3.34207f, 
		-3.84206f, 0.0553471f, 3.34609f, -3.84197f, -0.184761f, 3.32922f, 
		-3.84100f, -0.197317f, 3.20867f, -3.84082f, 0.0418875f, 3.35262f, 
		-3.84074f, -0.176300f, 3.20890f, -3.84072f, -0.190717f, 3.34679f, 
		-3.84067f, 0.0310617f, 3.36499f, -3.84066f, -0.153170f, 3.21164f, 
		-3.84065f, 0.138784f, 3.31292f, -3.84051f, 0.107866f, 3.31114f, 
		-3.84044f, 0.0623159f, 3.31235f, -3.84039f, 0.133318f, 3.34311f, 
		-3.84009f, -0.188967f, 3.31850f, -3.83968f, -0.0935486f, 3.22904f, 
		-3.83967f, 0.0137203f, 3.28822f, -3.83967f, -0.188420f, 3.28820f, 
		-3.83964f, -0.194683f, 3.36852f, -3.83962f, 0.0418838f, 3.35705f, 
		-3.83959f, 0.138784f, 3.34053f, -3.83947f, -0.0934632f, 3.22454f, 
		-3.83923f, 0.0578546f, 3.34130f, -3.83899f, -0.0905820f, 3.28397f, 
		-3.83899f, -0.114749f, 3.28394f, -3.83898f, -0.137607f, 3.28392f, 
		-3.83898f, -0.157863f, 3.28390f, -3.83898f, -0.174219f, 3.28389f, 
		-3.83853f, -0.0934631f, 3.18324f, -3.83836f, -0.186839f, 3.31425f, 
		-3.83833f, 0.110189f, 3.34178f, -3.83814f, 0.0413572f, 3.30126f, 
		-3.83801f, 0.138784f, 3.31420f, -3.83800f, -0.193577f, 3.36216f, 
		-3.83769f, -0.146248f, 3.18449f, -3.83764f, -0.0935484f, 3.17756f, 
		-3.83754f, -0.189863f, 3.28395f, -3.83752f, 0.0576789f, 3.31340f, 
		-3.83706f, 0.138784f, 3.33905f, -3.83705f, -0.189863f, 3.36984f, 
		-3.83692f, 0.122744f, 3.34188f, -3.83673f, 0.0152272f, 3.36504f, 
		-3.83671f, -0.196151f, 3.30683f, -3.83671f, -0.187335f, 3.36509f, 
		-3.83670f, 0.0623159f, 3.33954f, -3.83644f, 0.0229065f, 3.29091f, 
		-3.83580f, 0.140207f, 3.31387f, -3.83578f, -0.196623f, 3.34871f, 
		-3.83573f, -0.00675300f, 3.36919f, -3.83573f, -0.0231940f, 3.36920f, 
		-3.83573f, -0.0435090f, 3.36922f, -3.83572f, -0.0664040f, 3.36925f, 
		-3.83572f, -0.0905820f, 3.36927f, -3.83571f, -0.114749f, 3.36929f, 
		-3.83571f, -0.137607f, 3.36931f, -3.83570f, -0.157863f, 3.36933f, 
		-3.83570f, 0.00695616f, 3.36921f, -3.83570f, -0.174219f, 3.36934f, 
		-3.83568f, 0.138784f, 3.31597f, -3.83542f, -0.185134f, 3.33085f, 
		-3.83537f, 0.0653538f, 3.31305f, -3.83530f, 0.0549366f, 3.30980f, 
		-3.83527f, 0.0623157f, 3.31553f, -3.83525f, -0.148944f, 3.22874f, 
		-3.83486f, 0.138784f, 3.33710f, -3.83476f, 0.140207f, 3.33959f, 
		-3.83459f, 0.0304956f, 3.35930f, -3.83456f, 0.111948f, 3.31477f, 
		-3.83455f, -0.0934633f, 3.23165f, -3.83444f, 0.133317f, 3.31408f, 
		-3.83442f, 0.0623163f, 3.33751f, -3.83441f, 0.0857971f, 3.33981f, 
		-3.83421f, 0.122741f, 3.31418f, -3.83418f, 0.0557155f, 3.34248f, 
		-3.83373f, 0.138784f, 3.31816f, -3.83364f, 0.0449538f, 3.30202f, 
		-3.83360f, 0.0209359f, 3.28640f, -3.83348f, 0.0849959f, 3.31503f, 
		-3.83339f, 0.133317f, 3.33885f, -3.83332f, -0.197251f, 3.19444f, 
		-3.83330f, -0.0934631f, 3.17637f, -3.83324f, 0.0623120f, 3.31781f, 
		-3.83309f, 0.138784f, 3.33477f, -3.83264f, 0.109002f, 3.33696f, 
		-3.83247f, -0.186736f, 3.19859f, -3.83243f, -0.186736f, 3.21101f, 
		-3.83230f, 0.0576802f, 3.33526f, -3.83228f, -0.192921f, 3.33405f, 
		-3.83225f, 0.138784f, 3.32069f, -3.83223f, 0.0122427f, 3.29017f, 
		-3.83223f, -0.187335f, 3.29015f, -3.83209f, -0.195620f, 3.28784f, 
		-3.83194f, 0.0198664f, 3.36725f, -3.83181f, 0.138784f, 3.33213f, 
		-3.83148f, 0.0578534f, 3.32033f, -3.83129f, 0.138784f, 3.32346f, 
		-3.83125f, 0.0623109f, 3.33234f, -3.83107f, 0.138784f, 3.32930f, 
		-3.83106f, 0.0688878f, 3.33648f, -3.83089f, 0.138784f, 3.32637f, 
		-3.83078f, 0.00695622f, 3.28617f, -3.83074f, -0.0905820f, 3.28613f, 
		-3.83073f, -0.114749f, 3.28611f, -3.83072f, -0.137607f, 3.28609f, 
		-3.83072f, -0.157863f, 3.28607f, -3.83071f, -0.174219f, 3.28605f, 
		-3.83071f, 0.0623122f, 3.32332f, -3.83058f, 0.0972175f, 3.31988f, 
		-3.83051f, -0.197270f, 3.29423f, -3.83047f, 0.0623155f, 3.32939f, 
		-3.83026f, 0.0317958f, 3.29222f, -3.82996f, 0.0576790f, 3.32633f, 
		-3.82989f, 0.122286f, 3.33241f, -3.82977f, 0.0278241f, 3.29515f, 
		-3.82964f, -0.145071f, 3.17424f, -3.82955f, 0.0913977f, 3.33121f, 
		-3.82954f, 0.133317f, 3.33172f, -3.82949f, 0.140207f, 3.32479f, 
		-3.82945f, -0.189932f, 3.36256f, -3.82945f, 0.0137187f, 3.36257f, 
		-3.82942f, 0.109002f, 3.32469f, -3.82937f, 0.122506f, 3.32262f, 
		-3.82912f, 0.133317f, 3.32308f, -3.82886f, 0.0726307f, 3.32434f, 
		-3.82883f, 0.0576408f, 3.31922f, -3.82876f, -0.197206f, 3.35971f, 
		-3.82851f, -0.186767f, 3.22058f, -3.82831f, -0.192728f, 3.30919f, 
		-3.82827f, -0.0934631f, 3.23757f, -3.82822f, -0.195113f, 3.32051f, 
		-3.82807f, -0.0935515f, 3.16886f, -3.82801f, 0.0590405f, 3.33160f, 
		-3.82795f, -0.153172f, 3.17576f, -3.82782f, 0.0364236f, 3.30229f, 
		-3.82777f, 0.0318010f, 3.36044f, -3.82769f, -0.00675300f, 3.36641f, 
		-3.82768f, -0.0231940f, 3.36642f, -3.82767f, -0.0435090f, 3.36644f, 
		-3.82766f, -0.0664040f, 3.36646f, -3.82766f, 0.0440604f, 3.34891f, 
		-3.82765f, -0.0905820f, 3.36648f, -3.82764f, -0.114749f, 3.36650f, 
		-3.82763f, -0.137607f, 3.36652f, -3.82763f, -0.157863f, 3.36654f, 
		-3.82762f, -0.174219f, 3.36655f, -3.82753f, 0.0461677f, 3.34078f, 
		-3.82745f, -0.186736f, 3.18723f, -3.82719f, -0.196908f, 3.30768f, 
		-3.82716f, -0.197251f, 3.22564f, -3.82692f, -0.146783f, 3.23689f, 
		-3.82676f, -0.185380f, 3.28753f, -3.82675f, -0.0934632f, 3.17074f, 
		-3.82663f, -0.0935486f, 3.24176f, -3.82654f, 0.0264113f, 3.35761f, 
		-3.82654f, 0.0390744f, 3.34855f, -3.82646f, -0.192537f, 3.34214f, 
		-3.82638f, -0.00675232f, 3.28789f, -3.82596f, -0.190428f, 3.36599f, 
		-3.82562f, -0.176304f, 3.17432f, -3.82555f, -0.197317f, 3.17398f, 
		-3.82533f, -0.191010f, 3.29355f, -3.82531f, 0.00856900f, 3.29352f, 
		-3.82473f, 0.0486348f, 3.33965f, -3.82435f, 0.0356671f, 3.29870f, 
		-3.82403f, 0.0418875f, 3.31248f, -3.82398f, -0.193908f, 3.30115f, 
		-3.82380f, 0.00696421f, 3.36463f, -3.82352f, -0.183963f, 3.22707f, 
		-3.82342f, -0.196667f, 3.33784f, -3.82340f, 0.0515193f, 3.32389f, 
		-3.82324f, 0.0447762f, 3.31023f, -3.82307f, -0.0905820f, 3.28986f, 
		-3.82305f, -0.114749f, 3.28984f, -3.82304f, -0.137607f, 3.28982f, 
		-3.82303f, -0.157863f, 3.28980f, -3.82302f, -0.174219f, 3.28979f, 
		-3.82289f, 0.0458292f, 3.32603f, -3.82281f, -0.187335f, 3.35870f, 
		-3.82281f, 0.00856900f, 3.35870f, -3.82233f, 0.0356669f, 3.35353f, 
		-3.82155f, -0.192607f, 3.32476f, -3.82126f, -0.197264f, 3.23658f, 
		-3.82089f, -0.0934632f, 3.24205f, -3.82034f, -0.00675300f, 3.36211f, 
		-3.82033f, -0.0231940f, 3.36212f, -3.82032f, -0.0435090f, 3.36214f, 
		-3.82030f, -0.0664040f, 3.36215f, -3.82029f, -0.0905820f, 3.36217f, 
		-3.82028f, -0.114749f, 3.36219f, -3.82026f, -0.137607f, 3.36221f, 
		-3.82025f, -0.157863f, 3.36222f, -3.82024f, -0.174219f, 3.36224f, 
		-3.82004f, 0.0198661f, 3.29300f, -3.81953f, -0.195238f, 3.35987f, 
		-3.81953f, 0.0264117f, 3.30204f, -3.81945f, 0.00696426f, 3.29216f, 
		-3.81920f, -0.191071f, 3.29818f, -3.81919f, 0.0137183f, 3.29817f, 
		-3.81917f, -0.0934632f, 3.16659f, -3.81910f, -0.193876f, 3.34790f, 
		-3.81909f, -0.196950f, 3.32124f, -3.81851f, 0.0304962f, 3.34759f, 
		-3.81835f, -0.176308f, 3.23929f, -3.81824f, -0.186756f, 3.17888f, 
		-3.81818f, 0.0188252f, 3.35963f, -3.81766f, 0.0429980f, 3.33653f, 
		-3.81713f, 0.0436243f, 3.32304f, -3.81707f, -0.189932f, 3.35358f, 
		-3.81706f, 0.00856900f, 3.35360f, -3.81672f, -0.185380f, 3.35965f, 
		-3.81641f, -0.145071f, 3.24281f, -3.81634f, -0.191475f, 3.29443f, 
		-3.81630f, 0.0304963f, 3.30960f, -3.81629f, 0.0288266f, 3.30079f, 
		-3.81627f, -0.0905820f, 3.29501f, -3.81625f, -0.114749f, 3.29500f, 
		-3.81624f, -0.137607f, 3.29498f, -3.81623f, -0.157863f, 3.29497f, 
		-3.81622f, -0.174219f, 3.29496f, -3.81598f, 0.0369317f, 3.33250f, 
		-3.81594f, -0.153174f, 3.24058f, -3.81586f, -0.153193f, 3.16688f, 
		-3.81537f, 0.0195088f, 3.35000f, -3.81517f, 0.0356671f, 3.30907f, 
		-3.81511f, -0.0935485f, 3.16252f, -3.81437f, -0.186772f, 3.23239f, 
		-3.81410f, 0.0122448f, 3.30393f, -3.81408f, -0.187335f, 3.30392f, 
		-3.81405f, -0.197285f, 3.23970f, -3.81397f, -0.00675300f, 3.35646f, 
		-3.81395f, -0.0231940f, 3.35647f, -3.81394f, -0.0435090f, 3.35648f, 
		-3.81392f, -0.0664040f, 3.35650f, -3.81391f, -0.0905820f, 3.35651f, 
		-3.81389f, -0.114749f, 3.35653f, -3.81387f, -0.137607f, 3.35654f, 
		-3.81386f, -0.157863f, 3.35655f, -3.81385f, -0.174219f, 3.35656f, 
		-3.81297f, 0.0324763f, 3.32169f, -3.81292f, -0.00675229f, 3.29831f, 
		-3.81274f, -0.0934633f, 3.24491f, -3.81241f, -0.187335f, 3.34747f, 
		-3.81241f, 0.00856900f, 3.34747f, -3.81220f, 0.0318015f, 3.34476f, 
		-3.81204f, 0.0227444f, 3.35188f, -3.81177f, 0.0283882f, 3.33582f, 
		-3.81152f, 0.0356669f, 3.33599f, -3.81151f, -0.197216f, 3.31343f, 
		-3.81142f, -0.194908f, 3.30300f, -3.81130f, -0.193683f, 3.31959f, 
		-3.81106f, 0.00696398f, 3.35333f, -3.81097f, -0.197236f, 3.33927f, 
		-3.81095f, -0.192197f, 3.35311f, -3.81090f, -0.0934633f, 3.16411f, 
		-3.81067f, 0.0356672f, 3.32217f, -3.81061f, -0.0905820f, 3.30140f, 
		-3.81059f, -0.114749f, 3.30138f, -3.81057f, -0.137607f, 3.30137f, 
		-3.81056f, -0.157863f, 3.30136f, -3.81054f, -0.174219f, 3.30135f, 
		-3.81020f, 0.00856900f, 3.31055f, -3.81019f, -0.188420f, 3.31055f, 
		-3.81005f, 0.0209459f, 3.30429f, -3.80974f, 0.0195086f, 3.31442f, 
		-3.80954f, -0.0935488f, 3.24807f, -3.80944f, -0.197214f, 3.17351f, 
		-3.80912f, -0.191093f, 3.34053f, -3.80910f, 0.0152268f, 3.34053f, 
		-3.80882f, -0.0122382f, 3.34967f, -3.80879f, -0.0435090f, 3.34969f, 
		-3.80877f, -0.0664040f, 3.34970f, -3.80875f, -0.0905820f, 3.34971f, 
		-3.80873f, -0.114749f, 3.34973f, -3.80871f, -0.137607f, 3.34974f, 
		-3.80870f, -0.157863f, 3.34975f, -3.80869f, -0.174219f, 3.34976f, 
		-3.80853f, 0.0288267f, 3.31409f, -3.80815f, 0.00696426f, 3.30491f, 
		-3.80808f, -0.185380f, 3.30477f, -3.80769f, 0.0195077f, 3.32919f, 
		-3.80769f, -0.187335f, 3.31782f, -3.80769f, 0.00856900f, 3.31782f, 
		-3.80710f, -0.187335f, 3.33311f, -3.80710f, 0.00856900f, 3.33311f, 
		-3.80664f, 0.00856900f, 3.32544f, -3.80664f, -0.190126f, 3.32544f, 
		-3.80649f, -0.183963f, 3.23473f, -3.80645f, 0.0288267f, 3.32935f, 
		-3.80642f, -0.185380f, 3.34602f, -3.80630f, -0.0905820f, 3.30876f, 
		-3.80628f, -0.183967f, 3.17466f, -3.80628f, -0.114749f, 3.30875f, 
		-3.80626f, -0.137607f, 3.30874f, -3.80624f, -0.157863f, 3.30873f, 
		-3.80623f, -0.174219f, 3.30873f, -3.80510f, 0.0167671f, 3.31289f, 
		-3.80510f, -0.00675300f, 3.34201f, -3.80502f, -0.0905820f, 3.34204f, 
		-3.80500f, -0.114749f, 3.34205f, -3.80498f, -0.137607f, 3.34206f, 
		-3.80496f, -0.157863f, 3.34206f, -3.80495f, -0.174219f, 3.34207f, 
		-3.80460f, 0.0198662f, 3.33778f, -3.80458f, -0.00675226f, 3.31274f, 
		-3.80417f, -0.0934631f, 3.24601f, -3.80369f, 0.0209363f, 3.32273f, 
		-3.80368f, -0.190789f, 3.31512f, -3.80363f, -0.195417f, 3.32728f, 
		-3.80361f, 0.00696414f, 3.33801f, -3.80351f, -0.0905820f, 3.31682f, 
		-3.80351f, -0.146248f, 3.24465f, -3.80349f, -0.114749f, 3.31682f, 
		-3.80347f, -0.137607f, 3.31681f, -3.80345f, -0.157863f, 3.31681f, 
		-3.80344f, -0.174219f, 3.31680f, -3.80296f, -0.146246f, 3.16476f, 
		-3.80288f, -0.190828f, 3.33537f, -3.80286f, -0.0905820f, 3.33379f, 
		-3.80284f, -0.114749f, 3.33379f, -3.80282f, -0.137607f, 3.33380f, 
		-3.80280f, -0.157863f, 3.33380f, -3.80278f, -0.174219f, 3.33380f, 
		-3.80259f, 0.00696444f, 3.32101f, -3.80235f, -0.0905820f, 3.32527f, 
		-3.80233f, -0.114749f, 3.32527f, -3.80231f, -0.137607f, 3.32527f, 
		-3.80229f, -0.0934632f, 3.16340f, -3.80229f, -0.157863f, 3.32527f, 
		-3.80228f, -0.00675214f, 3.32961f, -3.80227f, -0.174219f, 3.32527f, 
		-3.80226f, -0.0935513f, 3.16111f, -3.80223f, -0.190162f, 3.32530f, 
		-3.79938f, -0.197271f, 3.23603f, -3.79809f, -0.186772f, 3.17531f, 
		-3.79597f, -0.186772f, 3.23365f, -3.79556f, -0.0934630f, 3.24530f, 
		-3.79512f, -0.0935512f, 3.24755f, -3.79373f, -0.0934631f, 3.16450f, 
		-3.79228f, -0.197274f, 3.17010f, -3.79060f, -0.153195f, 3.24253f, 
		-3.79053f, -0.153169f, 3.16883f, -3.79005f, -0.145071f, 3.16660f, 
		-3.78822f, -0.183966f, 3.23091f, -3.78811f, -0.176305f, 3.17012f, 
		-3.78805f, -0.0935484f, 3.16359f, -3.78804f, -0.183965f, 3.17861f, 
		-3.78729f, -0.0934632f, 3.24282f, -3.78558f, -0.0934631f, 3.16735f, 
		-3.78520f, -0.197264f, 3.17283f, -3.78284f, -0.0935487f, 3.24350f, 
		-3.78181f, -0.186767f, 3.18392f, -3.78179f, -0.197315f, 3.23594f, 
		-3.78084f, -0.176304f, 3.23509f, -3.77971f, -0.0934631f, 3.23867f, 
		-3.77954f, -0.146784f, 3.17251f, -3.77931f, -0.197284f, 3.18377f, 
		-3.77902f, -0.186785f, 3.22219f, -3.77851f, -0.153172f, 3.23365f, 
		-3.77820f, -0.0934630f, 3.17184f, -3.77682f, -0.145072f, 3.23517f, 
		-3.77598f, -0.186756f, 3.19248f, -3.77452f, -0.186767f, 3.21287f, 
		-3.77382f, -0.197261f, 3.21606f, -3.77317f, -0.0934634f, 3.23304f, 
		-3.77304f, -0.183963f, 3.20481f, -3.77264f, -0.0935482f, 3.17333f, 
		-3.77191f, -0.0934632f, 3.17776f, -3.77121f, -0.148937f, 3.18067f, 
		-3.76882f, -0.0935488f, 3.23185f, -3.76878f, -0.146249f, 3.22492f, 
		-3.76793f, -0.0934631f, 3.22617f, -3.76699f, -0.0934632f, 3.18487f, 
		-3.76581f, -0.153177f, 3.19777f, -3.76572f, -0.176308f, 3.20051f, 
		-3.76546f, -0.197317f, 3.20074f, -3.76499f, -0.0935512f, 3.18375f, 
		-3.76424f, -0.0934632f, 3.21836f, -3.76415f, -0.153184f, 3.21268f, 
		-3.76366f, -0.0934631f, 3.19283f, -3.76364f, -0.145070f, 3.19707f, 
		-3.76225f, -0.0934631f, 3.20995f, -3.76206f, -0.0934632f, 3.20132f, 
		-3.76076f, -0.0935486f, 3.21550f, -3.76004f, -0.0935485f, 3.19730f
	};
	static const GLfloat NormalData[] = {
		-0.999731f, 0.00591003f, 0.0224293f, -0.999264f, 0.000943227f, 0.0383437f, -0.999263f, 0.000953985f, 0.0383630f, 
		-0.999263f, 0.000954540f, 0.0383766f, -0.999262f, 0.000923142f, 0.0383913f, 
		-0.999261f, 0.000935564f, 0.0384162f, -0.999229f, -0.00663992f, 0.0386899f, 
		-0.999013f, 0.00480376f, 0.0441478f, -0.998797f, 0.00874336f, 0.0482515f, 
		-0.998779f, 0.0256126f, -0.0422515f, -0.998225f, 0.0404691f, 0.0436983f, 
		-0.996120f, -0.0825594f, -0.0304744f, -0.995413f, 0.0102605f, -0.0951244f, 
		-0.994343f, 0.00556494f, 0.106070f, -0.993569f, -0.0887882f, -0.0702728f, 
		-0.993454f, -0.0177624f, -0.112847f, -0.992084f, -0.0144603f, 0.124739f, 
		-0.991506f, 0.129298f, -0.0140844f, -0.991452f, -0.0650132f, 0.113122f, 
		-0.990634f, 0.127148f, 0.0497816f, -0.990458f, 9.55945e-005f, -0.137811f, 
		-0.990419f, 0.0369482f, -0.133063f, -0.990209f, 0.0231939f, 0.137656f, 
		-0.990000f, 0.137478f, 0.0316250f, -0.987552f, 0.000939919f, -0.157293f, 
		-0.987551f, 0.000959297f, -0.157295f, -0.987549f, 0.000927940f, -0.157306f, 
		-0.987548f, 0.000934920f, -0.157316f, -0.987546f, 0.000964883f, -0.157327f, 
		-0.986867f, 0.139598f, 0.0812798f, -0.986630f, -0.00174872f, -0.162965f, 
		-0.980265f, -0.0956119f, -0.173029f, -0.978170f, -0.0257463f, -0.206205f, 
		-0.976972f, 0.000391690f, 0.213368f, -0.974310f, -0.223059f, -0.0310533f, 
		-0.972899f, 0.218708f, 0.0750625f, -0.972581f, 0.000958119f, 0.232562f, 
		-0.972581f, 0.000948072f, 0.232562f, -0.972579f, 0.000925629f, 0.232571f, 
		-0.972573f, 0.000934506f, 0.232597f, -0.972568f, 0.000931776f, 0.232615f, 
		-0.971610f, 0.0145301f, -0.236143f, -0.968313f, 0.223295f, -0.111844f, 
		-0.967811f, 0.000104655f, 0.251676f, -0.966106f, 0.0368854f, 0.255498f, 
		-0.963693f, 0.0389509f, -0.264157f, -0.961312f, 0.175302f, -0.212480f, 
		-0.960617f, -0.102922f, -0.258112f, -0.958390f, 0.00961376f, 0.285299f, 
		-0.956108f, -0.259529f, 0.136025f, -0.955978f, -0.151588f, 0.251253f, 
		-0.955102f, 0.264531f, -0.133431f, -0.954624f, 0.205130f, 0.215903f, 
		-0.953518f, -0.0632933f, -0.294615f, -0.952153f, 0.225556f, 0.206224f, 
		-0.950305f, 0.203049f, 0.235989f, -0.945250f, 0.134433f, -0.297374f, 
		-0.945211f, -0.0126951f, 0.326212f, -0.944554f, 0.0351750f, 0.326466f, 
		-0.942897f, 0.277493f, -0.184236f, -0.940230f, 0.00254957f, -0.340531f, 
		-0.939197f, -0.161199f, 0.303190f, -0.938254f, 0.00907495f, -0.345829f, 
		-0.937892f, 0.000956037f, -0.346925f, -0.937890f, 0.000929208f, -0.346931f, 
		-0.937888f, 0.000949037f, -0.346938f, -0.937886f, 0.000962877f, -0.346943f, 
		-0.937877f, 0.000931127f, -0.346968f, -0.935856f, 0.350579f, 0.0355969f, 
		-0.935841f, 0.00207086f, -0.352416f, -0.934939f, 0.128055f, 0.330895f, 
		-0.934867f, -0.246617f, 0.255350f, -0.934591f, 0.139784f, -0.327107f, 
		-0.932324f, 0.116142f, -0.342466f, -0.925600f, -0.296381f, -0.235421f, 
		-0.924819f, -0.0159885f, 0.380070f, -0.921803f, 0.247219f, -0.298598f, 
		-0.918704f, 0.00337002f, 0.394933f, -0.916063f, 0.126972f, 0.380404f, 
		-0.914659f, 0.00681042f, 0.404169f, -0.911017f, -0.0945925f, 0.401373f, 
		-0.910916f, -0.00507960f, 0.412561f, -0.910897f, -0.00173800f, 0.412630f, 
		-0.910191f, -0.00909123f, -0.414089f, -0.910156f, 0.348516f, -0.223950f, 
		-0.908773f, 0.134428f, 0.395045f, -0.908532f, 0.000958336f, 0.417814f, 
		-0.908526f, 0.000953646f, 0.417827f, -0.908519f, 0.000940507f, 0.417842f, 
		-0.908513f, 0.000923917f, 0.417856f, -0.908505f, 0.000956506f, 0.417872f, 
		-0.908495f, 0.000944830f, 0.417895f, -0.908122f, 0.115245f, -0.402533f, 
		-0.907617f, 0.130097f, -0.399132f, -0.907091f, -0.316430f, 0.277592f, 
		-0.906119f, 0.0726004f, -0.416747f, -0.904205f, 0.00874669f, 0.427010f, 
		-0.899700f, -0.263916f, -0.347691f, -0.899625f, -0.381427f, -0.212575f, 
		-0.896669f, 0.354091f, 0.265715f, -0.893822f, 0.00470570f, 0.448396f, 
		-0.891080f, 0.385072f, -0.240198f, -0.889717f, 0.124730f, 0.439143f, 
		-0.889145f, -0.0359575f, -0.456211f, -0.886485f, -0.178696f, 0.426864f, 
		-0.884121f, -0.387623f, 0.260917f, -0.879327f, 0.435351f, -0.193014f, 
		-0.871101f, -0.0186724f, -0.490749f, -0.870326f, -0.106216f, -0.480885f, 
		-0.868910f, 0.00786991f, -0.494908f, -0.868711f, -0.351301f, -0.349183f, 
		-0.865543f, 0.137934f, -0.481466f, -0.864544f, 0.0369736f, -0.501195f, 
		-0.862335f, 0.000952361f, -0.506338f, -0.862323f, 0.000949530f, -0.506358f, 
		-0.861024f, 0.00494911f, -0.508539f, -0.860617f, -0.0671248f, 0.504809f, 
		-0.854438f, -0.104805f, 0.508873f, -0.854296f, 0.461230f, 0.239678f, 
		-0.852646f, -0.00883492f, -0.522414f, -0.852190f, 0.000934449f, -0.523232f, 
		-0.852180f, 0.000933468f, -0.523248f, -0.852177f, 0.000943871f, -0.523252f, 
		-0.852163f, 0.000967873f, -0.523276f, -0.851688f, 0.00488320f, -0.524027f, 
		-0.842596f, 0.437456f, -0.314108f, -0.842512f, 0.538133f, -0.0242286f, 
		-0.841627f, -0.140917f, -0.521350f, -0.840557f, -0.0880698f, -0.534517f, 
		-0.837036f, 0.00480578f, -0.547127f, -0.832733f, 0.297196f, -0.467151f, 
		-0.829987f, -0.0956533f, -0.549520f, -0.829354f, -0.131603f, 0.543002f, 
		-0.828750f, 0.543763f, 0.132270f, -0.826559f, -0.220157f, 0.518006f, 
		-0.823660f, 0.305429f, 0.477806f, -0.820503f, 0.0265327f, 0.571026f, 
		-0.815795f, 0.571584f, 0.0881518f, -0.810858f, 0.0367391f, -0.584088f, 
		-0.809783f, -0.508027f, 0.293530f, -0.809547f, 0.000969036f, 0.587054f, 
		-0.809539f, 0.000933374f, 0.587065f, -0.809529f, 0.000943206f, 0.587079f, 
		-0.809529f, 0.000956350f, 0.587080f, -0.809520f, 0.000945536f, 0.587092f, 
		-0.808488f, 0.505918f, 0.300656f, -0.807398f, 0.00681496f, -0.589968f, 
		-0.806118f, 0.00480364f, 0.591736f, -0.805853f, 0.161191f, 0.569753f, 
		-0.804804f, 0.583469f, 0.108875f, -0.803433f, -0.00536968f, 0.595371f, 
		-0.799457f, 0.130094f, 0.586467f, -0.798708f, 0.545537f, 0.253878f, 
		-0.796105f, 0.582863f, 0.162750f, -0.794692f, 0.150729f, 0.588002f, 
		-0.793639f, 0.0369640f, 0.607266f, -0.791605f, -0.0159785f, -0.610824f, 
		-0.791501f, -0.0657338f, -0.607622f, -0.789234f, 0.121250f, -0.602003f, 
		-0.788831f, 0.598715f, -0.138874f, -0.787478f, 0.126967f, -0.603124f, 
		-0.786839f, 0.123055f, 0.604766f, -0.785604f, 0.101087f, -0.610416f, 
		-0.783502f, 0.560288f, 0.268703f, -0.777279f, 0.100088f, -0.621144f, 
		-0.776396f, -0.549214f, -0.309150f, -0.776238f, 0.00961140f, 0.630367f, 
		-0.774724f, 0.0102581f, -0.632216f, -0.761763f, 0.588361f, -0.271199f, 
		-0.757990f, 0.185592f, -0.625305f, -0.757284f, -0.613966f, -0.222637f, 
		-0.755041f, -0.0179125f, 0.655433f, -0.753937f, -0.595559f, 0.277286f, 
		-0.753672f, 0.377688f, -0.537894f, -0.752374f, 0.652138f, 0.0930020f, 
		-0.750576f, 0.139782f, 0.645831f, -0.747523f, 0.000773228f, -0.664236f, 
		-0.746726f, 0.561731f, -0.356172f, -0.746243f, 0.241403f, -0.620360f, 
		-0.740663f, -0.00535667f, -0.671855f, -0.736246f, -0.673347f, -0.0674203f, 
		-0.734562f, 0.654900f, -0.177552f, -0.733735f, 0.000952440f, -0.679435f, 
		-0.733724f, 0.000947566f, -0.679447f, -0.733713f, 0.000932129f, -0.679459f, 
		-0.728194f, 0.0421297f, 0.684075f, -0.727560f, 0.118411f, -0.675749f, 
		-0.726182f, -0.663094f, 0.181565f, -0.724848f, 0.230545f, 0.649187f, 
		-0.724627f, -0.164084f, -0.669323f, -0.721536f, 0.171460f, -0.670811f, 
		-0.710037f, 0.424200f, 0.562052f, -0.706944f, -0.122447f, 0.696590f, 
		-0.705056f, -0.254098f, 0.662065f, -0.702280f, 0.172822f, -0.690605f, 
		-0.695902f, -0.157984f, 0.700543f, -0.693772f, 0.000374655f, 0.720195f, 
		-0.692917f, 0.477566f, -0.540182f, -0.692148f, 0.607601f, -0.389555f, 
		-0.690843f, 0.617113f, 0.376705f, -0.688388f, -0.246832f, -0.682052f, 
		-0.682651f, 0.119621f, -0.720887f, -0.679471f, 0.000956644f, 0.733701f, 
		-0.679471f, 0.000936680f, 0.733702f, -0.679455f, 0.000945855f, 0.733717f, 
		-0.679449f, 0.000957272f, 0.733722f, -0.679423f, 0.000920216f, 0.733746f, 
		-0.676123f, 0.122556f, 0.726525f, -0.671521f, -0.429257f, 0.603985f, 
		-0.671452f, -0.368155f, 0.643129f, -0.667846f, 0.201902f, -0.716392f, 
		-0.666738f, 0.00495273f, 0.745275f, -0.663417f, -0.151813f, -0.732688f, 
		-0.659632f, -0.735106f, 0.156542f, -0.657515f, 0.00693841f, 0.753410f, 
		-0.656402f, -0.0214853f, 0.754105f, -0.655013f, 0.00787014f, 0.755576f, 
		-0.654507f, 0.225682f, -0.721587f, -0.653739f, 0.484177f, 0.581548f, 
		-0.649245f, -0.473644f, -0.595099f, -0.645134f, 0.220369f, -0.731601f, 
		-0.640153f, 0.259363f, -0.723143f, -0.631069f, -0.00377162f, -0.775717f, 
		-0.628202f, 0.432554f, 0.646730f, -0.619598f, -0.0972380f, 0.778873f, 
		-0.614910f, 0.584545f, 0.529333f, -0.612095f, 0.0343576f, 0.790038f, 
		-0.607617f, 0.0299272f, 0.793666f, -0.600932f, -0.192641f, -0.775739f, 
		-0.600250f, -0.573240f, -0.557760f, -0.595547f, -0.518622f, 0.613478f, 
		-0.593747f, 0.126380f, -0.794665f, -0.591668f, 0.210438f, 0.778232f, 
		-0.588037f, 0.00907923f, -0.808783f, -0.587094f, 0.000927999f, -0.809518f, 
		-0.587072f, 0.000942966f, -0.809534f, -0.587057f, 0.000953670f, -0.809545f, 
		-0.586947f, 0.00155823f, -0.809624f, -0.586805f, 0.260890f, 0.766549f, 
		-0.583710f, -0.00912085f, 0.811911f, -0.571014f, 0.000962346f, -0.820940f, 
		-0.568785f, 0.156166f, -0.807524f, -0.567725f, -0.723782f, 0.392209f, 
		-0.567604f, -0.00566878f, -0.823282f, -0.563871f, 0.139598f, -0.813979f, 
		-0.562234f, 0.0563493f, 0.825056f, -0.561962f, -0.0631079f, 0.824752f, 
		-0.561366f, -0.147077f, -0.814394f, -0.560926f, 0.194307f, 0.804740f, 
		-0.548487f, 0.464930f, -0.694984f, -0.544863f, -0.0602135f, 0.836360f, 
		-0.541924f, -0.0641091f, -0.837979f, -0.541447f, 0.625844f, -0.561386f, 
		-0.541083f, 0.0408068f, -0.839979f, -0.534664f, -0.843816f, 0.0459218f, 
		-0.533010f, -0.652843f, 0.538235f, -0.528127f, -0.00174740f, 0.849164f, 
		-0.526797f, -0.00913248f, -0.849942f, -0.526698f, 0.587802f, -0.614067f, 
		-0.523418f, 0.00155318f, 0.852075f, -0.523266f, 0.000960871f, 0.852169f, 
		-0.523264f, 0.000943764f, 0.852170f, -0.523255f, 0.000930062f, 0.852176f, 
		-0.523249f, 0.000944653f, 0.852179f, -0.522133f, 0.00907483f, 0.852816f, 
		-0.518748f, -0.0942315f, 0.849718f, -0.517543f, 0.126961f, 0.846186f, 
		-0.517411f, 0.000148936f, -0.855737f, -0.511948f, 0.0421495f, 0.857982f, 
		-0.505928f, 0.0501718f, -0.861115f, -0.505559f, -0.797534f, 0.329164f, 
		-0.504807f, 0.342910f, 0.792201f, -0.500763f, 0.0331447f, 0.864950f, 
		-0.496883f, -0.705553f, 0.505275f, -0.495189f, 0.498827f, -0.711308f, 
		-0.485329f, -0.180283f, 0.855543f, -0.483577f, 0.129290f, -0.865701f, 
		-0.478497f, -0.707046f, -0.520698f, -0.471792f, -0.0825086f, -0.877841f, 
		-0.469080f, -0.441281f, -0.765007f, -0.458167f, -0.860457f, -0.222930f, 
		-0.453639f, -0.00951867f, 0.891135f, -0.447546f, 0.00787680f, -0.894226f, 
		-0.445938f, -0.650340f, -0.614977f, -0.445562f, -0.0214962f, -0.894993f, 
		-0.441190f, -0.753615f, 0.487253f, -0.438953f, 0.0332618f, -0.897894f, 
		-0.437749f, 0.615930f, 0.654986f, -0.433366f, 0.00497746f, -0.901204f, 
		-0.432635f, -0.901530f, -0.00847187f, -0.432431f, -0.0896424f, -0.897200f, 
		-0.432403f, 0.536483f, -0.724716f, -0.427229f, -0.885377f, 0.183255f, 
		-0.425002f, 0.0477158f, -0.903934f, -0.418628f, 0.466308f, -0.779299f, 
		-0.418173f, 0.168552f, 0.892593f, -0.417855f, 0.000937480f, -0.908513f, 
		-0.417842f, 0.000955192f, -0.908519f, -0.417835f, 0.000944355f, -0.908523f, 
		-0.416310f, 0.00211174f, -0.909220f, -0.412307f, -0.909769f, -0.0482016f, 
		-0.410714f, -0.800539f, 0.436407f, -0.407231f, -0.244336f, -0.880036f, 
		-0.405659f, -0.893184f, -0.194068f, -0.402358f, -0.804813f, -0.436329f, 
		-0.399927f, 0.549803f, 0.733331f, -0.398774f, 0.196897f, -0.895662f, 
		-0.386830f, 0.223464f, -0.894666f, -0.385198f, 0.209861f, 0.898655f, 
		-0.377131f, 0.0293896f, -0.925694f, -0.372066f, -0.0930385f, -0.923532f, 
		-0.370206f, -0.897047f, -0.241358f, -0.363374f, -0.924417f, 0.115814f, 
		-0.362810f, 0.169474f, 0.916323f, -0.359782f, -0.103512f, 0.927277f, 
		-0.359753f, -0.905956f, 0.223207f, -0.350247f, 0.137556f, 0.926502f, 
		-0.346949f, 0.000953639f, 0.937884f, -0.346944f, 0.000927111f, 0.937886f, 
		-0.346933f, 0.000954470f, 0.937889f, -0.341486f, 0.00481416f, 0.939874f, 
		-0.341231f, 0.0416328f, 0.939057f, -0.337279f, -0.00535012f, 0.941389f, 
		-0.335562f, 0.227282f, 0.914189f, -0.328527f, 0.590681f, -0.736998f, 
		-0.326381f, 0.0111090f, 0.945173f, -0.325072f, 0.204637f, 0.923283f, 
		-0.323945f, 0.443782f, 0.835534f, -0.323203f, -0.934435f, -0.149570f, 
		-0.321936f, -0.938239f, -0.126747f, -0.321129f, 0.132475f, -0.937724f, 
		-0.319739f, -0.150372f, 0.935497f, -0.317808f, 0.278241f, 0.906411f, 
		-0.316962f, 0.371578f, -0.872620f, -0.315574f, -0.212092f, 0.924895f, 
		-0.304378f, -0.481802f, -0.821718f, -0.302449f, 0.130164f, 0.944236f, 
		-0.299858f, -0.00656783f, -0.953961f, -0.287503f, 0.0102644f, 0.957725f, 
		-0.285355f, 0.00960927f, -0.958374f, -0.281191f, 0.151997f, -0.947538f, 
		-0.274133f, 0.0518927f, -0.960291f, -0.268790f, -0.962424f, 0.0386357f, 
		-0.266423f, -0.948563f, 0.171018f, -0.265129f, -0.919021f, -0.291731f, 
		-0.259894f, -0.638663f, -0.724268f, -0.259850f, -0.961998f, 0.0838930f, 
		-0.258051f, -0.557387f, -0.789132f, -0.256943f, -0.102857f, -0.960938f, 
		-0.253937f, -0.719498f, 0.646404f, -0.251912f, 0.205691f, -0.945638f, 
		-0.248685f, 0.417120f, 0.874166f, -0.246048f, 0.112651f, -0.962689f, 
		-0.245026f, 0.312670f, 0.917714f, -0.242543f, -0.00535533f, -0.970126f, 
		-0.235857f, -0.348677f, 0.907081f, -0.235544f, 0.333321f, -0.912916f, 
		-0.232606f, 0.000936617f, -0.972571f, -0.232600f, 0.000949742f, -0.972572f, 
		-0.232587f, 0.000945046f, -0.972575f, -0.230823f, -0.933624f, 0.273984f, 
		-0.227612f, 0.139780f, 0.963667f, -0.226857f, -0.0668086f, -0.971634f, 
		-0.226188f, 0.0367772f, -0.973389f, -0.226011f, 0.620666f, -0.750795f, 
		-0.224923f, -0.879639f, 0.419101f, -0.224823f, 0.592636f, 0.773458f, 
		-0.222019f, -0.950174f, 0.218807f, -0.219640f, 0.352637f, -0.909618f, 
		-0.217898f, 0.574186f, -0.789197f, -0.215995f, -0.0946406f, -0.971797f, 
		-0.213885f, -0.163007f, 0.963163f, -0.213376f, 0.000779914f, -0.976970f, 
		-0.212055f, 0.245242f, -0.945986f, -0.210972f, -0.556740f, 0.803449f, 
		-0.208427f, -0.977045f, -0.0440642f, -0.205545f, -0.0112592f, 0.978583f, 
		-0.203961f, -0.458035f, 0.865219f, -0.192699f, -0.723722f, 0.662642f, 
		-0.189639f, -0.874459f, 0.446496f, -0.184036f, 0.139780f, -0.972930f, 
		-0.181035f, -0.117324f, 0.976453f, -0.178441f, -0.0679594f, 0.981601f, 
		-0.176767f, 0.000412547f, 0.984253f, -0.173082f, 0.00587844f, 0.984890f, 
		-0.171965f, -0.0279926f, 0.984705f, -0.169840f, 0.585883f, 0.792398f, 
		-0.169756f, -0.640307f, 0.749126f, -0.169185f, 0.352608f, 0.920350f, 
		-0.165289f, -0.984333f, -0.0613928f, -0.158893f, 0.634322f, 0.756564f, 
		-0.157831f, -0.00968001f, -0.987419f, -0.157322f, 0.000958089f, 0.987547f, 
		-0.157318f, 0.000930320f, 0.987548f, -0.157309f, 0.000949313f, 0.987549f, 
		-0.157298f, 0.000952942f, 0.987551f, -0.157293f, 0.000929850f, 0.987552f, 
		-0.157280f, 0.000934456f, 0.987554f, -0.157208f, -0.877909f, -0.452285f, 
		-0.154761f, -0.916224f, -0.369571f, -0.154553f, -0.0645507f, 0.985874f, 
		-0.153558f, -0.913629f, -0.376433f, -0.149299f, 0.312696f, -0.938047f, 
		-0.147467f, 0.00874942f, 0.989028f, -0.142964f, 0.240475f, -0.960069f, 
		-0.141905f, 0.101987f, 0.984612f, -0.141166f, 0.112798f, 0.983539f, 
		-0.140311f, 0.00496355f, 0.990095f, -0.125777f, -0.989721f, 0.0680613f, 
		-0.123052f, -0.962446f, 0.241983f, -0.121189f, 0.0375899f, 0.991917f, 
		-0.111465f, -0.587534f, -0.801486f, -0.110763f, -0.654091f, -0.748262f, 
		-0.107724f, 0.130173f, -0.985622f, -0.107310f, 0.448144f, 0.887497f, 
		-0.106495f, -0.973444f, -0.202645f, -0.101352f, -0.994642f, 0.0203679f, 
		-0.0982169f, -0.296535f, -0.949958f, -0.0871876f, -0.993803f, 0.0689500f, 
		-0.0829882f, -0.986541f, 0.140888f, -0.0822958f, 0.216214f, 0.972871f, 
		-0.0818234f, 0.00278574f, 0.996643f, -0.0807144f, 0.0535393f, -0.995298f, 
		-0.0797772f, -0.945081f, 0.316950f, -0.0741581f, -0.379641f, -0.922157f, 
		-0.0722096f, 0.358745f, -0.930638f, -0.0670661f, 0.280393f, -0.957540f, 
		-0.0670538f, -0.211091f, -0.975164f, -0.0651665f, 0.227687f, -0.971551f, 
		-0.0642955f, -0.994993f, 0.0765191f, -0.0620994f, 0.0369136f, -0.997387f, 
		-0.0599058f, 0.0422499f, 0.997310f, -0.0531702f, 0.195562f, 0.979249f, 
		-0.0528908f, -0.948355f, -0.312770f, -0.0512791f, -0.996921f, -0.0593209f, 
		-0.0482045f, 0.00873806f, -0.998799f, -0.0469393f, 0.561435f, -0.826189f, 
		-0.0429862f, 0.999075f, 0.000925289f, -0.0424754f, 0.999068f, -0.00762047f, 
		-0.0418747f, 0.999070f, 0.0103098f, -0.0415015f, 0.999130f, -0.00417701f, 
		-0.0411045f, -0.954500f, 0.295363f, -0.0407979f, 0.452590f, -0.890785f, 
		-0.0396815f, 0.999074f, -0.0166410f, -0.0395814f, 0.999131f, 0.0130350f, 
		-0.0389332f, 0.999073f, 0.0183560f, -0.0384569f, -0.138700f, 0.989587f, 
		-0.0383927f, 0.000940832f, -0.999262f, -0.0383741f, 0.000956505f, -0.999263f, 
		-0.0383478f, 0.000938314f, -0.999264f, -0.0382049f, 0.00154067f, -0.999269f, 
		-0.0370697f, 0.00157519f, -0.999311f, -0.0361438f, 0.999133f, -0.0206758f, 
		-0.0359516f, -0.910144f, -0.412729f, -0.0354293f, 0.999101f, -0.0232726f, 
		-0.0341595f, -0.967558f, -0.250330f, -0.0340983f, 0.999068f, 0.0264704f, 
		-0.0322387f, 0.0651602f, 0.997354f, -0.0308666f, 0.999131f, 0.0280120f, 
		-0.0281077f, 0.999073f, 0.0326035f, -0.0273718f, -0.0971283f, -0.994895f, 
		-0.0260917f, 0.999307f, -0.0265413f, -0.0235746f, 0.999214f, -0.0318557f, 
		-0.0225695f, 0.999069f, -0.0367535f, -0.0203846f, 0.999067f, 0.0380702f, 
		-0.0170939f, 0.999132f, -0.0379989f, -0.0168022f, 0.999129f, 0.0381881f, 
		-0.0162480f, -0.963624f, -0.266768f, -0.0139658f, 0.999173f, -0.0381882f, 
		-0.0130648f, 0.00338509f, -0.999909f, -0.0124235f, 0.999072f, 0.0412455f, 
		-0.0104057f, 0.223756f, 0.974590f, -0.00744280f, -0.999341f, -0.0355347f, 
		-0.00550299f, 0.999310f, -0.0367178f, -0.00471854f, -0.998409f, -0.0561956f, 
		-0.00410290f, -0.999991f, 0.00139960f, -0.00349799f, 0.999138f, 0.0413702f, 
		-0.00271017f, 0.999996f, 0.000705217f, -0.00250781f, 0.999997f, 0.000725928f, 
		-0.00175608f, 0.999998f, 0.000600422f, -0.00173601f, -0.999998f, -0.000996464f, 
		-0.000845288f, -0.999999f, -0.00116630f, -0.000691289f, -1.00000f, -2.26029e-005f, 
		-0.000604321f, -1.00000f, -0.000390359f, -0.000359238f, 0.999219f, -0.0395010f, 
		-0.000191936f, -1.00000f, -0.000554884f, -0.000129943f, 1.00000f, 0.000364122f, 
		-6.47482e-005f, -0.999999f, -0.00148674f, 0.000000f, 1.00000f, -3.90488e-017f, 
		6.72045e-005f, 0.999999f, -0.00101754f, 0.000103252f, 1.00000f, 0.000230408f, 
		0.000158093f, 0.999125f, 0.0418210f, 0.000185068f, -0.999998f, -0.00211968f, 
		0.000205769f, -0.999999f, 0.00102791f, 0.000216010f, 1.00000f, -0.000501970f, 
		0.000313903f, 0.999999f, 0.00158004f, 0.000592523f, 0.999999f, 0.00157165f, 
		0.000846795f, 1.00000f, 0.000167310f, 0.000919015f, -0.999999f, 0.000546743f, 
		0.00114867f, 0.999999f, -0.000184699f, 0.00116597f, 0.999999f, -0.000381354f, 
		0.00132230f, -0.999941f, -0.0107363f, 0.00173550f, -0.999998f, -0.000505970f, 
		0.00269598f, -0.999991f, -0.00329504f, 0.00287562f, -0.999944f, -0.0102047f, 
		0.00332993f, 0.999072f, -0.0429529f, 0.00486970f, -0.999943f, -0.00944647f, 
		0.00566710f, 0.999068f, 0.0427814f, 0.00812730f, -0.0172671f, 0.999818f, 
		0.00849498f, 0.999129f, -0.0408515f, 0.00857753f, 0.999217f, 0.0386284f, 
		0.00985395f, -0.988272f, 0.152386f, 0.0101394f, 0.176378f, -0.984270f, 
		0.0119765f, 0.999142f, -0.0396572f, 0.0129597f, -0.992426f, -0.122162f, 
		0.0130540f, 0.999308f, 0.0348390f, 0.0162775f, -0.992326f, -0.122572f, 
		0.0164701f, -0.0351916f, -0.999245f, 0.0189110f, -0.999184f, 0.0356900f, 
		0.0193280f, -0.995352f, -0.0943410f, 0.0193789f, -0.314460f, 0.949073f, 
		0.0206830f, 0.999075f, -0.0376896f, 0.0229670f, 0.999098f, 0.0357254f, 
		0.0231743f, 0.412341f, -0.910735f, 0.0234300f, 0.158636f, 0.987059f, 
		0.0241586f, -0.140930f, -0.989725f, 0.0243326f, 0.999133f, -0.0337828f, 
		0.0245146f, -0.888937f, -0.457374f, 0.0247591f, 0.999123f, 0.0337533f, 
		0.0261316f, -0.954075f, -0.298426f, 0.0267898f, 0.999105f, -0.0327437f, 
		0.0290294f, 0.999312f, -0.0230923f, 0.0295565f, 0.999069f, 0.0314330f, 
		0.0326714f, -0.00175233f, 0.999465f, 0.0331353f, -0.0873688f, 0.995625f, 
		0.0340293f, 0.999220f, -0.0200438f, 0.0357162f, -0.995169f, -0.0914464f, 
		0.0357734f, 0.999065f, 0.0242799f, 0.0363235f, 0.999124f, 0.0207769f, 
		0.0370116f, -0.269643f, 0.962249f, 0.0383412f, 0.000949662f, 0.999264f, 
		0.0383520f, 0.000957367f, 0.999264f, 0.0383550f, 0.000932375f, 0.999264f, 
		0.0383695f, 0.000958268f, 0.999263f, 0.0384015f, 0.000950225f, 0.999262f, 
		0.0384103f, 0.000929738f, 0.999262f, 0.0388698f, 0.999071f, -0.0185854f, 
		0.0396285f, 0.999129f, -0.0130570f, 0.0397829f, 0.999069f, 0.0166983f, 
		0.0403448f, 0.999141f, -0.00944706f, 0.0413914f, 0.0375699f, 0.998436f, 
		0.0415878f, 0.999126f, 0.00419038f, 0.0425204f, 0.999066f, 0.00762854f, 
		0.0430631f, 0.999072f, -0.000929695f, 0.0442394f, 0.466215f, -0.883565f, 
		0.0472451f, -0.00644094f, 0.998863f, 0.0477725f, -0.189136f, 0.980788f, 
		0.0515790f, -0.991028f, 0.123298f, 0.0531066f, 0.592513f, -0.803809f, 
		0.0538155f, -0.868055f, 0.493543f, 0.0541905f, 0.618982f, -0.783533f, 
		0.0630302f, -0.997597f, 0.0287531f, 0.0638446f, 0.0858437f, 0.994261f, 
		0.0656944f, 0.0199862f, -0.997640f, 0.0677393f, -0.993686f, -0.0894443f, 
		0.0685457f, -0.00204796f, -0.997646f, 0.0705990f, -0.0677606f, -0.995201f, 
		0.0723999f, 0.0563786f, -0.995781f, 0.0759162f, 0.457996f, 0.885707f, 
		0.0819520f, -0.970566f, -0.226463f, 0.0830371f, -0.987792f, 0.131805f, 
		0.0858592f, -0.0161182f, -0.996177f, 0.0891031f, -0.0226956f, -0.995764f, 
		0.0896542f, 0.129288f, 0.987546f, 0.0917825f, 0.106514f, -0.990066f, 
		0.0929485f, 0.00961703f, 0.995624f, 0.0929490f, -0.910363f, 0.403237f, 
		0.0930806f, -0.994896f, -0.0389706f, 0.0961678f, -0.994866f, -0.0315315f, 
		0.100190f, 0.149224f, -0.983715f, 0.102801f, 0.0131995f, -0.994614f, 
		0.103200f, 0.00960922f, -0.994614f, 0.105878f, -0.994258f, 0.0155410f, 
		0.108228f, -0.922886f, 0.369551f, 0.113713f, -0.979107f, 0.168581f, 
		0.120603f, 0.0156691f, 0.992577f, 0.120939f, -0.936466f, 0.329250f, 
		0.128125f, -0.820282f, 0.557424f, 0.128423f, -0.524382f, 0.841743f, 
		0.128636f, 0.126959f, -0.983531f, 0.129568f, -0.682484f, 0.719324f, 
		0.135717f, 0.0647943f, 0.988627f, 0.135787f, -0.942339f, 0.305874f, 
		0.137738f, -0.830361f, 0.539935f, 0.141619f, -0.608865f, 0.780530f, 
		0.141897f, -0.972383f, -0.185300f, 0.149846f, -0.172839f, 0.973485f, 
		0.154548f, 0.583667f, 0.797150f, 0.156990f, -0.831752f, -0.532487f, 
		0.157301f, 0.000919380f, -0.987550f, 0.157305f, 0.000954147f, -0.987550f, 
		0.157309f, 0.000940405f, -0.987549f, 0.158285f, -0.0640130f, 0.985316f, 
		0.164333f, -0.751373f, 0.639088f, 0.166281f, -0.00160716f, -0.986077f, 
		0.169046f, -0.869315f, -0.464452f, 0.169194f, -0.834503f, -0.524383f, 
		0.169841f, 0.621600f, 0.764701f, 0.169925f, -0.980640f, -0.0973157f, 
		0.170440f, 0.142981f, -0.974939f, 0.173751f, -0.965499f, 0.193965f, 
		0.173850f, -0.0352330f, -0.984142f, 0.176728f, 0.000975426f, -0.984259f, 
		0.181502f, 0.136900f, -0.973815f, 0.183987f, 0.139597f, 0.972965f, 
		0.185474f, -0.978583f, 0.0893051f, 0.192769f, 0.442107f, 0.876003f, 
		0.197219f, -0.733823f, -0.650083f, 0.198782f, -0.775190f, -0.599639f, 
		0.199716f, -0.754369f, -0.625332f, 0.201025f, 0.0834877f, -0.976022f, 
		0.201214f, -0.979277f, -0.0229984f, 0.206513f, -0.0812885f, 0.975061f, 
		0.207627f, 0.0920852f, 0.973864f, 0.208095f, 0.00339757f, 0.978103f, 
		0.208675f, 0.280288f, -0.936960f, 0.212417f, -0.192163f, -0.958098f, 
		0.213355f, -0.165275f, -0.962893f, 0.213537f, 0.0348489f, 0.976313f, 
		0.221954f, -0.914885f, -0.337226f, 0.224325f, 0.210804f, -0.951441f, 
		0.225601f, -0.973983f, -0.0214530f, 0.226735f, 0.175132f, 0.958081f, 
		0.228671f, -0.167121f, -0.959052f, 0.232549f, 0.000964934f, 0.972584f, 
		0.232566f, 0.000959123f, 0.972580f, 0.232579f, 0.000934055f, 0.972577f, 
		0.232582f, 0.000960446f, 0.972576f, 0.232599f, 0.000942264f, 0.972572f, 
		0.232786f, 0.596019f, -0.768487f, 0.234523f, -0.742726f, 0.627181f, 
		0.238216f, 0.00480864f, 0.971200f, 0.240409f, -0.958109f, 0.155662f, 
		0.242275f, 0.00874778f, 0.970168f, 0.247672f, -0.101456f, 0.963517f, 
		0.247774f, -0.529219f, -0.811502f, 0.249259f, 0.00494826f, 0.968424f, 
		0.251802f, -0.0159098f, -0.967648f, 0.262295f, 0.469822f, 0.842893f, 
		0.272020f, 0.240774f, -0.931683f, 0.274369f, -0.915306f, 0.294849f, 
		0.277901f, 0.203456f, 0.938817f, 0.284978f, -0.149897f, -0.946741f, 
		0.287641f, 0.0615861f, 0.955756f, 0.288453f, 0.0871121f, 0.953523f, 
		0.288566f, 0.198562f, 0.936644f, 0.298779f, -0.886959f, 0.352186f, 
		0.307620f, -0.889440f, -0.338032f, 0.310751f, 0.226033f, 0.923224f, 
		0.321887f, 0.0428985f, -0.945806f, 0.324151f, -0.000959418f, -0.946005f, 
		0.328347f, 9.42468e-005f, -0.944557f, 0.336056f, 0.494041f, -0.801866f, 
		0.337033f, -0.511987f, 0.790112f, 0.337483f, 0.00874386f, -0.941291f, 
		0.338179f, -0.941059f, 0.00651801f, 0.344105f, -0.935192f, -0.0837127f, 
		0.346515f, 0.629244f, -0.695686f, 0.346909f, 0.000929461f, -0.937898f, 
		0.346945f, 0.000947582f, -0.937885f, 0.346959f, 0.000951308f, -0.937880f, 
		0.347175f, -0.909668f, -0.227977f, 0.347867f, 0.00197532f, -0.937542f, 
		0.354360f, -0.931586f, -0.0810912f, 0.358126f, -0.0776753f, -0.930437f, 
		0.361820f, 0.00587542f, -0.932229f, 0.361884f, -0.192211f, 0.912192f, 
		0.363079f, -0.931670f, 0.0128598f, 0.370070f, -0.509061f, -0.777113f, 
		0.371832f, -0.296924f, 0.879532f, 0.379430f, 0.109734f, -0.918690f, 
		0.389389f, 0.365014f, -0.845660f, 0.391872f, -0.911599f, 0.124193f, 
		0.395204f, -0.0563124f, -0.916866f, 0.397602f, 0.237211f, 0.886365f, 
		0.399881f, 0.000394259f, 0.916567f, 0.401089f, -0.0642589f, -0.913782f, 
		0.403177f, -0.322563f, -0.856389f, 0.406723f, -0.807014f, 0.428140f, 
		0.409763f, 0.384467f, -0.827212f, 0.410755f, -0.291761f, 0.863803f, 
		0.413657f, -0.890647f, 0.188776f, 0.413668f, -0.0897017f, 0.905998f, 
		0.417833f, 0.000965165f, 0.908523f, 0.417844f, 0.000937318f, 0.908518f, 
		0.417859f, 0.000951158f, 0.908511f, 0.417861f, 0.000918443f, 0.908511f, 
		0.417894f, 0.000940327f, 0.908495f, 0.418054f, 0.00440815f, 0.908412f, 
		0.422967f, 0.139768f, -0.895301f, 0.425254f, -0.0109278f, 0.905008f, 
		0.426981f, 0.509333f, -0.747173f, 0.433336f, 0.483714f, 0.760421f, 
		0.434508f, 0.299000f, -0.849589f, 0.435749f, 0.198615f, 0.877881f, 
		0.440705f, -0.00772140f, -0.897619f, 0.442872f, -0.194329f, -0.875272f, 
		0.449322f, -0.891319f, 0.0604914f, 0.461291f, -0.0894280f, 0.882731f, 
		0.464957f, 0.141955f, 0.873879f, 0.465351f, 0.145821f, -0.873032f, 
		0.466044f, 0.565173f, 0.680722f, 0.466717f, 0.00960798f, 0.884355f, 
		0.468884f, 0.0102606f, -0.883200f, 0.469844f, -0.719954f, 0.510796f, 
		0.478122f, -0.823895f, -0.304296f, 0.482874f, -0.184073f, 0.856125f, 
		0.483754f, 0.129312f, 0.865598f, 0.486902f, 0.0284629f, 0.872993f, 
		0.490389f, 0.584626f, -0.646321f, 0.491588f, -0.0624856f, 0.868583f, 
		0.492159f, 0.130174f, -0.860717f, 0.498701f, 0.0430619f, -0.865704f, 
		0.507877f, 0.349330f, 0.787419f, 0.511476f, 0.623535f, 0.591267f, 
		0.513159f, 0.00754493f, -0.858260f, 0.518032f, 0.125378f, 0.846122f, 
		0.520587f, -0.0899479f, -0.849057f, 0.521866f, -0.792897f, -0.314594f, 
		0.523256f, 0.000947522f, -0.852175f, 0.523267f, 0.000954852f, -0.852168f, 
		0.523861f, 0.578307f, -0.625404f, 0.527487f, 0.597002f, 0.604439f, 
		0.534583f, 0.209199f, -0.818814f, 0.539086f, 0.121359f, -0.833462f, 
		0.539945f, 0.000847146f, -0.841700f, 0.545157f, -0.631860f, 0.550960f, 
		0.545494f, -0.0257735f, 0.837718f, 0.548178f, -0.396212f, -0.736558f, 
		0.553729f, 0.489850f, 0.673373f, 0.563850f, 0.139661f, 0.813983f, 
		0.564991f, -0.0719377f, 0.821955f, 0.574681f, 0.229527f, 0.785531f, 
		0.578323f, 0.158703f, -0.800222f, 0.580616f, -0.802099f, 0.139725f, 
		0.587030f, 0.00540516f, 0.809547f, 0.587045f, 0.000945445f, 0.809554f, 
		0.587055f, 0.000960689f, 0.809546f, 0.587061f, 0.000943864f, 0.809542f, 
		0.587063f, 0.000912528f, 0.809541f, 0.587066f, 0.000955794f, 0.809539f, 
		0.587094f, 0.000947914f, 0.809518f, 0.588436f, 0.0505332f, -0.806963f, 
		0.592346f, -0.714713f, -0.371904f, 0.596287f, 0.559992f, 0.575197f, 
		0.597147f, -0.712930f, -0.367623f, 0.597349f, 0.00825175f, 0.801939f, 
		0.597459f, -0.441577f, 0.669367f, 0.599307f, 0.116813f, -0.791951f, 
		0.600345f, 0.0935164f, -0.794254f, 0.601301f, -0.0431817f, 0.797855f, 
		0.604207f, -0.792786f, 0.0801532f, 0.609632f, 0.193153f, 0.768792f, 
		0.611499f, -0.0215221f, 0.790952f, 0.611594f, -0.0993606f, -0.784908f, 
		0.613296f, 0.00786902f, 0.789814f, 0.614282f, -0.764209f, -0.196575f, 
		0.616378f, 0.209463f, -0.759080f, 0.617814f, -0.739524f, 0.267227f, 
		0.619695f, 0.119477f, -0.775696f, 0.622338f, -0.0292426f, -0.782202f, 
		0.624336f, 0.0711578f, 0.777908f, 0.632751f, 0.00909667f, 0.774302f, 
		0.633844f, 0.595645f, 0.493405f, 0.643053f, -0.205726f, -0.737672f, 
		0.651117f, 0.624930f, -0.430709f, 0.654431f, 0.0999495f, -0.749486f, 
		0.654925f, 0.409191f, 0.635323f, 0.656354f, -0.120807f, -0.744719f, 
		0.657187f, -0.151476f, 0.738350f, 0.657296f, 0.105138f, 0.746262f, 
		0.672691f, 0.423028f, -0.607071f, 0.673322f, -0.737516f, 0.0520399f, 
		0.675415f, -0.000703362f, -0.737437f, 0.678483f, 0.00908012f, -0.734560f, 
		0.679426f, 0.000937696f, -0.733743f, 0.679443f, 0.000946730f, -0.733727f, 
		0.680649f, 0.00181606f, -0.732608f, 0.682172f, 0.126966f, -0.720084f, 
		0.682458f, -0.00917179f, 0.730868f, 0.683014f, -0.0647173f, -0.727533f, 
		0.683253f, 0.583089f, -0.439514f, 0.684625f, -0.241695f, 0.687657f, 
		0.684953f, -0.000319874f, -0.728587f, 0.685509f, 0.00107876f, -0.728063f, 
		0.692596f, -0.473410f, -0.544236f, 0.694031f, 0.124799f, 0.709046f, 
		0.695004f, 0.372269f, -0.615131f, 0.702261f, 0.121980f, -0.701392f, 
		0.707382f, 0.596095f, 0.379844f, 0.708358f, 0.642380f, 0.292535f, 
		0.708970f, 0.569788f, -0.415575f, 0.713955f, -0.107590f, 0.691876f, 
		0.716423f, -0.0255774f, 0.697198f, 0.717835f, 0.00146496f, 0.696212f, 
		0.720208f, 0.000936931f, 0.693758f, 0.720455f, 0.114026f, -0.684063f, 
		0.725345f, -0.163481f, 0.668692f, 0.726120f, 0.0864706f, 0.682109f, 
		0.727061f, -0.684572f, 0.0523705f, 0.727930f, 0.121670f, 0.674769f, 
		0.730878f, -0.00913388f, -0.682447f, 0.733708f, 0.000957854f, 0.679465f, 
		0.733718f, 0.000959065f, 0.679453f, 0.733723f, 0.000947800f, 0.679448f, 
		0.733728f, 0.000924585f, 0.679442f, 0.733733f, 0.000946517f, 0.679437f, 
		0.734496f, -0.424441f, 0.529496f, 0.734600f, 0.00907867f, 0.678440f, 
		0.737227f, -0.643132f, -0.207068f, 0.740531f, 0.210401f, -0.638236f, 
		0.740900f, 0.0229590f, 0.671223f, 0.741468f, 0.105061f, -0.662712f, 
		0.746976f, 9.60992e-005f, 0.664851f, 0.747320f, 0.198795f, 0.634030f, 
		0.749410f, 0.304884f, 0.587733f, 0.750379f, 0.441264f, 0.492156f, 
		0.758310f, -0.102214f, 0.643831f, 0.763720f, -0.284621f, -0.579416f, 
		0.767049f, -0.160264f, -0.621250f, 0.769268f, -0.00709324f, -0.638887f, 
		0.769454f, 0.633029f, -0.0849382f, 0.776882f, -0.00245924f, 0.629642f, 
		0.777108f, 0.449945f, -0.440059f, 0.778296f, -0.215095f, 0.589906f, 
		0.778991f, 0.582073f, 0.233161f, 0.779598f, 0.460025f, -0.424974f, 
		0.782547f, -0.0635403f, 0.619341f, 0.783705f, -0.514153f, -0.348501f, 
		0.783979f, 0.101641f, 0.612410f, 0.788032f, -0.0253459f, 0.615113f, 
		0.788545f, 0.0427185f, 0.613491f, 0.789813f, 0.00786754f, -0.613297f, 
		0.790801f, 0.481484f, 0.377899f, 0.790911f, -0.0214636f, -0.611555f, 
		0.794099f, 0.129299f, 0.593876f, 0.797818f, 0.000124936f, -0.602898f, 
		0.798520f, -0.0115305f, 0.601858f, 0.798731f, 0.585150f, -0.140103f, 
		0.800869f, 0.597075f, -0.0459471f, 0.801734f, 0.157235f, 0.576627f, 
		0.803710f, 0.186611f, 0.565001f, 0.806609f, 0.572506f, 0.147035f, 
		0.806628f, -0.574619f, -0.138435f, 0.809533f, 0.000942481f, -0.587073f, 
		0.809545f, 0.000960779f, -0.587057f, 0.811839f, 0.0972124f, -0.575732f, 
		0.813708f, 0.580359f, 0.0325993f, 0.816373f, 0.111946f, 0.566571f, 
		0.820373f, -0.571230f, 0.0261746f, 0.820941f, 0.000845109f, -0.571013f, 
		0.827640f, -0.0762323f, -0.556057f, 0.830740f, 0.159114f, 0.533436f, 
		0.832949f, -0.378175f, -0.403955f, 0.836274f, -0.0614914f, 0.544852f, 
		0.836386f, 0.253617f, -0.485939f, 0.836705f, -0.0561224f, -0.544770f, 
		0.837464f, 0.386786f, -0.386069f, 0.841152f, -0.140608f, 0.522201f, 
		0.841584f, 0.00537065f, 0.540100f, 0.841706f, 0.000951822f, 0.539936f, 
		0.841718f, 0.000952126f, 0.539917f, 0.841738f, -0.133873f, -0.523026f, 
		0.843952f, 0.230483f, -0.484378f, 0.846172f, 0.139653f, 0.514285f, 
		0.851808f, 0.0404837f, -0.522287f, 0.852186f, 0.000950678f, 0.523238f, 
		0.852200f, 0.000946774f, 0.523215f, 0.852208f, 0.000945867f, 0.523202f, 
		0.852214f, 0.000926213f, 0.523193f, 0.852327f, -0.00661864f, 0.522967f, 
		0.852378f, 0.160241f, -0.497770f, 0.852453f, 0.106634f, 0.511813f, 
		0.854185f, 0.0375114f, 0.518614f, 0.854390f, -0.104790f, -0.508956f, 
		0.859130f, 0.417546f, -0.295890f, 0.861149f, 0.490609f, -0.133138f, 
		0.862241f, 0.223657f, 0.454442f, 0.862688f, -0.0590726f, 0.502275f, 
		0.863489f, -0.499599f, 0.0691897f, 0.867504f, -0.113120f, 0.484397f, 
		0.868450f, 0.139775f, -0.475665f, 0.876161f, 0.0874065f, 0.474028f, 
		0.880513f, 0.386532f, 0.274391f, 0.880720f, 0.327861f, -0.341817f, 
		0.883163f, 0.0102624f, 0.468954f, 0.884286f, 0.00961326f, -0.466847f, 
		0.886375f, -0.260940f, -0.382426f, 0.889044f, 0.400440f, 0.221919f, 
		0.890328f, -0.0899983f, 0.446336f, 0.891264f, -0.0677262f, -0.448400f, 
		0.893575f, 0.151645f, -0.422525f, 0.898459f, -0.0184663f, 0.438669f, 
		0.903202f, 0.00781310f, -0.429144f, 0.903885f, 0.422928f, 0.0642142f, 
		0.903931f, 0.130089f, -0.407414f, 0.903993f, 0.0397772f, -0.425694f, 
		0.908508f, 0.000954643f, -0.417867f, 0.908513f, 0.000938444f, -0.417855f, 
		0.908523f, 0.000933042f, -0.417834f, 0.908866f, 0.00168005f, -0.417085f, 
		0.908891f, -0.135007f, -0.394577f, 0.909021f, 0.387565f, 0.153211f, 
		0.909464f, 0.00312869f, -0.415770f, 0.911661f, 0.226136f, -0.343128f, 
		0.914569f, 0.00683329f, -0.404372f, 0.916261f, -0.231833f, 0.326679f, 
		0.918701f, 0.329244f, 0.218143f, 0.922298f, 0.261648f, 0.284440f, 
		0.922459f, 0.124775f, 0.365377f, 0.923249f, -0.190799f, -0.333476f, 
		0.924755f, -0.0159758f, -0.380228f, 0.925259f, -0.368256f, -0.0910118f, 
		0.928395f, 0.146140f, 0.341653f, 0.928568f, 2.92808e-005f, 0.371162f, 
		0.930246f, 0.0618501f, 0.361687f, 0.934556f, 0.214377f, 0.283986f, 
		0.934579f, 0.00165646f, 0.355752f, 0.934878f, 0.148219f, -0.322543f, 
		0.937875f, 0.000952641f, 0.346972f, 0.937882f, 0.000947938f, 0.346953f, 
		0.937885f, 0.000936134f, 0.346944f, 0.939196f, -0.161153f, -0.303218f, 
		0.944527f, 0.000131514f, 0.328434f, 0.945754f, -0.00909665f, -0.324755f, 
		0.948444f, -0.00985149f, -0.316792f, 0.948735f, 0.00787389f, 0.315975f, 
		0.948876f, 0.0345127f, -0.313757f, 0.950075f, -0.0187214f, 0.311459f, 
		0.951853f, -0.0138141f, 0.306244f, 0.952428f, 0.00812323f, 0.304657f, 
		0.953528f, -0.0632914f, 0.294583f, 0.954188f, 0.261355f, 0.145665f, 
		0.954879f, -0.289111f, -0.0679771f, 0.955398f, 0.0927982f, 0.280361f, 
		0.957359f, -0.152622f, -0.245296f, 0.960189f, -0.103609f, 0.259426f, 
		0.963430f, -0.177643f, 0.200611f, 0.965417f, 0.181559f, 0.187098f, 
		0.966512f, 0.109501f, -0.232087f, 0.966522f, 0.0442208f, 0.252745f, 
		0.966993f, 0.129298f, 0.219559f, 0.967772f, 0.228894f, -0.105001f, 
		0.970154f, 0.0542379f, -0.236348f, 0.970169f, 0.00874832f, -0.242273f, 
		0.970772f, 0.0599418f, -0.232397f, 0.971855f, -0.0914163f, -0.217120f, 
		0.972393f, 0.00411516f, -0.233312f, 0.972572f, 0.000935192f, -0.232599f, 
		0.972574f, 0.000952349f, -0.232594f, 0.972575f, 0.000933969f, -0.232588f, 
		0.973491f, -0.00911766f, 0.228542f, 0.975114f, 0.126960f, -0.181754f, 
		0.976161f, 0.00585711f, -0.216969f, 0.977836f, 0.209076f, 0.0111085f, 
		0.979205f, -0.184673f, -0.0839854f, 0.979718f, 0.00185723f, -0.200375f, 
		0.981233f, 0.0469740f, -0.187015f, 0.981275f, 0.187268f, -0.0450582f, 
		0.981319f, -0.0590139f, 0.183112f, 0.982198f, 0.139655f, 0.125635f, 
		0.984254f, 0.000961651f, 0.176755f, 0.986111f, -0.00211604f, 0.166077f, 
		0.986313f, 0.164771f, 0.00613581f, 0.987544f, 0.000947593f, 0.157342f, 
		0.987549f, 0.000945776f, 0.157310f, 0.987709f, 0.00907992f, 0.156039f, 
		0.989033f, 0.0339955f, -0.143728f, 0.991590f, 0.125066f, -0.0332911f, 
		0.991913f, 0.0375873f, 0.121227f, 0.991966f, 0.0231173f, -0.124375f, 
		0.992470f, -0.0651350f, -0.103733f, 0.992522f, -0.107937f, -0.0569996f, 
		0.993572f, -0.0887672f, 0.0702534f, 0.994857f, 0.0102635f, -0.100770f, 
		0.996042f, -0.0831387f, 0.0314304f, 0.997369f, 0.0434229f, -0.0580401f, 
		0.998388f, 0.00335539f, -0.0566543f, 0.998643f, -0.00352772f, 0.0519524f, 
		0.999263f, 0.000942566f, -0.0383822f, 0.999263f, 0.000936307f, -0.0383703f, 
		0.999294f, 0.00124541f, -0.0375401f, 0.999825f, 0.00101580f, -0.0186863f
	};
	static const GLfloat TexCoordData[] = {
		0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.0724792f, 
		0.000000f, 0.100324f, 0.000000f, 0.100339f, 
		0.000000f, 0.100356f, 0.000000f, 0.145149f, 
		0.000000f, 0.157942f, 0.000000f, 0.175392f, 
		0.000000f, 0.211287f, 0.000000f, 0.211317f, 
		0.000000f, 0.211328f, 0.000000f, 0.211346f, 
		0.000000f, 0.211367f, 0.000000f, 0.211389f, 
		0.000000f, 0.211413f, 0.000000f, 0.232612f, 
		0.000000f, 0.291033f, 0.000000f, 0.310190f, 
		0.000000f, 0.320447f, 0.000000f, 0.332985f, 
		0.000000f, 0.333583f, 0.000000f, 0.340234f, 
		0.000000f, 0.342072f, 0.000000f, 0.343960f, 
		0.000000f, 0.356027f, 0.000000f, 0.356056f, 
		0.000000f, 0.356171f, 0.000000f, 0.356520f, 
		0.000000f, 0.359011f, 0.000000f, 0.359053f, 
		0.000000f, 0.359071f, 0.000000f, 0.359121f, 
		0.000000f, 0.362398f, 0.000000f, 0.362482f, 
		0.000000f, 0.362494f, 0.000000f, 0.362580f, 
		0.000000f, 0.362684f, 0.000000f, 0.362768f, 
		0.000000f, 0.362795f, 0.000000f, 0.362896f, 
		0.000000f, 0.364908f, 0.000000f, 0.369631f, 
		0.000000f, 0.376805f, 0.000000f, 0.377129f, 
		0.000000f, 0.381340f, 0.000000f, 0.383689f, 
		0.000000f, 0.383761f, 0.000000f, 0.383781f, 
		0.000000f, 0.384463f, 0.000000f, 0.386964f, 
		0.000000f, 0.387117f, 0.000000f, 0.387148f, 
		0.000000f, 0.387230f, 0.000000f, 0.389226f, 
		0.000000f, 0.389291f, 0.000000f, 0.389321f, 
		0.000000f, 0.389355f, 0.000000f, 0.390396f, 
		0.000000f, 0.390487f, 0.000000f, 0.394553f, 
		0.000000f, 0.395036f, 0.000000f, 0.395704f, 
		0.000000f, 0.395725f, 0.000000f, 0.401137f, 
		0.000000f, 0.402092f, 0.000000f, 0.403958f, 
		0.000000f, 0.406697f, 0.000000f, 0.406905f, 
		0.000000f, 0.414373f, 0.000000f, 0.414474f, 
		0.000000f, 0.414486f, 0.000000f, 0.414502f, 
		0.000000f, 0.414827f, 0.000000f, 0.414855f, 
		0.000000f, 0.422971f, 0.000000f, 0.423031f, 
		0.000000f, 0.423075f, 0.000000f, 0.423154f, 
		0.000000f, 0.423388f, 0.000000f, 0.423968f, 
		0.000000f, 0.424064f, 0.000000f, 0.424143f, 
		0.000000f, 0.427479f, 0.000000f, 0.427710f, 
		0.000000f, 0.429073f, 0.000000f, 0.429166f, 
		0.000000f, 0.435813f, 0.000000f, 0.436010f, 
		0.000000f, 0.436035f, 0.000000f, 0.436048f, 
		0.000000f, 0.436080f, 0.000000f, 0.436106f, 
		0.000000f, 0.436164f, 0.000000f, 0.436179f, 
		0.000000f, 0.436198f, 0.000000f, 0.436256f, 
		0.000000f, 0.436360f, 0.000000f, 0.436446f, 
		0.000000f, 0.436488f, 0.000000f, 0.436581f, 
		0.000000f, 0.436640f, 0.000000f, 0.436662f, 
		0.000000f, 0.436679f, 0.000000f, 0.436710f, 
		0.000000f, 0.436754f, 0.000000f, 0.436789f, 
		0.000000f, 0.436814f, 0.000000f, 0.436825f, 
		0.000000f, 0.436858f, 0.000000f, 0.436913f, 
		0.000000f, 0.437029f, 0.000000f, 0.437652f, 
		0.000000f, 0.437747f, 0.000000f, 0.437872f, 
		0.000000f, 0.437887f, 0.000000f, 0.437897f, 
		0.000000f, 0.438860f, 0.000000f, 0.438910f, 
		0.000000f, 0.439011f, 0.000000f, 0.439028f, 
		0.000000f, 0.439112f, 0.000000f, 0.439770f, 
		0.000000f, 0.440862f, 0.000000f, 0.440889f, 
		0.000000f, 0.440909f, 0.000000f, 0.440926f, 
		0.000000f, 0.440941f, 0.000000f, 0.440953f, 
		0.000000f, 0.440970f, 0.000000f, 0.440980f, 
		0.000000f, 0.441001f, 0.000000f, 0.441013f, 
		0.000000f, 0.441027f, 0.000000f, 0.441040f, 
		0.000000f, 0.441058f, 0.000000f, 0.441086f, 
		0.000000f, 0.441112f, 0.000000f, 0.441133f, 
		0.000000f, 0.441172f, 0.000000f, 0.441205f, 
		0.000000f, 0.441215f, 0.000000f, 0.446489f, 
		0.000000f, 0.447295f, 0.000000f, 0.447360f, 
		0.000000f, 0.448989f, 0.000000f, 0.451443f, 
		0.000000f, 0.451810f, 0.000000f, 0.452335f, 
		0.000000f, 0.454841f, 0.000000f, 0.455031f, 
		0.000000f, 0.455059f, 0.000000f, 0.455072f, 
		0.000000f, 0.455680f, 0.000000f, 0.455716f, 
		0.000000f, 0.455740f, 0.000000f, 0.455981f, 
		0.000000f, 0.456001f, 0.000000f, 0.456069f, 
		0.000000f, 0.460545f, 0.000000f, 0.470274f, 
		0.000000f, 0.470555f, 0.000000f, 0.472472f, 
		0.000000f, 0.472625f, 0.000000f, 0.472998f, 
		0.000000f, 0.473025f, 0.000000f, 0.473051f, 
		0.000000f, 0.476896f, 0.000000f, 0.476927f, 
		0.000000f, 0.477060f, 0.000000f, 0.477302f, 
		0.000000f, 0.477378f, 0.000000f, 0.477393f, 
		0.000000f, 0.477407f, 0.000000f, 0.477909f, 
		0.000000f, 0.478579f, 0.000000f, 0.478614f, 
		0.000000f, 0.478704f, 0.000000f, 0.478913f, 
		0.000000f, 0.479245f, 0.000000f, 0.480496f, 
		0.000000f, 0.480841f, 0.000000f, 0.485225f, 
		0.000000f, 0.485275f, 0.000000f, 0.485310f, 
		0.000000f, 0.485349f, 0.000000f, 0.485361f, 
		0.000000f, 0.485373f, 0.000000f, 0.485426f, 
		0.000000f, 0.485451f, 0.000000f, 0.485487f, 
		0.000000f, 0.487072f, 0.000000f, 0.487264f, 
		0.000000f, 0.487486f, 0.000000f, 0.487513f, 
		0.000000f, 0.487534f, 0.000000f, 0.487546f, 
		0.000000f, 0.487564f, 0.000000f, 0.487586f, 
		0.000000f, 0.487603f, 0.000000f, 0.487614f, 
		0.000000f, 0.487626f, 0.000000f, 0.487641f, 
		0.000000f, 0.487730f, 0.000000f, 0.487742f, 
		0.000000f, 0.487775f, 0.000000f, 0.487844f, 
		0.000000f, 0.487863f, 0.000000f, 0.487988f, 
		0.000000f, 0.488041f, 0.000000f, 0.488141f, 
		0.000000f, 0.489702f, 0.000000f, 0.489868f, 
		0.000000f, 0.490139f, 0.000000f, 0.490413f, 
		0.000000f, 0.490433f, 0.000000f, 0.490460f, 
		0.000000f, 0.492165f, 0.000000f, 0.492183f, 
		0.000000f, 0.492196f, 0.000000f, 0.492218f, 
		0.000000f, 0.492229f, 0.000000f, 0.492249f, 
		0.000000f, 0.492260f, 0.000000f, 0.492272f, 
		0.000000f, 0.492286f, 0.000000f, 0.492298f, 
		0.000000f, 0.492749f, 0.000000f, 0.492775f, 
		0.000000f, 0.492787f, 0.000000f, 0.492801f, 
		0.000000f, 0.492811f, 0.000000f, 0.492823f, 
		0.000000f, 0.492834f, 0.000000f, 0.492851f, 
		0.000000f, 0.492866f, 0.000000f, 0.492879f, 
		0.000000f, 0.492913f, 0.000000f, 0.494593f, 
		0.000000f, 0.494713f, 0.000000f, 0.494873f, 
		0.000000f, 0.494922f, 0.000000f, 0.495072f, 
		0.000000f, 0.495134f, 0.000000f, 0.495178f, 
		0.000000f, 0.495572f, 0.000000f, 0.495615f, 
		0.000000f, 0.498133f, 0.000000f, 0.499291f, 
		0.000000f, 0.499313f, 0.000000f, 0.499332f, 
		0.000000f, 0.499361f, 0.000000f, 0.499372f, 
		0.000000f, 0.499386f, 0.000000f, 0.499397f, 
		0.000000f, 0.499412f, 0.000000f, 0.499422f, 
		0.000000f, 0.499444f, 0.000000f, 0.499466f, 
		0.000000f, 0.499480f, 0.000000f, 0.499506f, 
		0.000000f, 0.499522f, 0.000000f, 0.499560f, 
		0.000000f, 0.499594f, 0.000000f, 0.499606f, 
		0.000000f, 0.500000f, 0.000000f, 0.500112f, 
		0.000000f, 0.500139f, 0.000000f, 0.500166f, 
		0.000000f, 0.500184f, 0.000000f, 0.500200f, 
		0.000000f, 0.500481f, 0.000000f, 0.500607f, 
		0.000000f, 0.502041f, 0.000000f, 0.502065f, 
		0.000000f, 0.502105f, 0.000000f, 0.502118f, 
		0.000000f, 0.502129f, 0.000000f, 0.502139f, 
		0.000000f, 0.502151f, 0.000000f, 0.502167f, 
		0.000000f, 0.502179f, 0.000000f, 0.502191f, 
		0.000000f, 0.502221f, 0.000000f, 0.502238f, 
		0.000000f, 0.502260f, 0.000000f, 0.503160f, 
		0.000000f, 0.503171f, 0.000000f, 0.503182f, 
		0.000000f, 0.503209f, 0.000000f, 0.503231f, 
		0.000000f, 0.503241f, 0.000000f, 0.503251f, 
		0.000000f, 0.503264f, 0.000000f, 0.503276f, 
		0.000000f, 0.503287f, 0.000000f, 0.503302f, 
		0.000000f, 0.503313f, 0.000000f, 0.503325f, 
		0.000000f, 0.503343f, 0.000000f, 0.503356f, 
		0.000000f, 0.503367f, 0.000000f, 0.503385f, 
		0.000000f, 0.503398f, 0.000000f, 0.503412f, 
		0.000000f, 0.503429f, 0.000000f, 0.503439f, 
		0.000000f, 0.503470f, 0.000000f, 0.503484f, 
		0.000000f, 0.503543f, 0.000000f, 0.503715f, 
		0.000000f, 0.503739f, 0.000000f, 0.503754f, 
		0.000000f, 0.503766f, 0.000000f, 0.503778f, 
		0.000000f, 0.503789f, 0.000000f, 0.503799f, 
		0.000000f, 0.503811f, 0.000000f, 0.503833f, 
		0.000000f, 0.503845f, 0.000000f, 0.503862f, 
		0.000000f, 0.503874f, 0.000000f, 0.503890f, 
		0.000000f, 0.503903f, 0.000000f, 0.503915f, 
		0.000000f, 0.503926f, 0.000000f, 0.503940f, 
		0.000000f, 0.503953f, 0.000000f, 0.503963f, 
		0.000000f, 0.503975f, 0.000000f, 0.504021f, 
		0.000000f, 0.504039f, 0.000000f, 0.504050f, 
		0.000000f, 0.504064f, 0.000000f, 0.504077f, 
		0.000000f, 0.504094f, 0.000000f, 0.504108f, 
		0.000000f, 0.504132f, 0.000000f, 0.504145f, 
		0.000000f, 0.504158f, 0.000000f, 0.504170f, 
		0.000000f, 0.504182f, 0.000000f, 0.504194f, 
		0.000000f, 0.504205f, 0.000000f, 0.504215f, 
		0.000000f, 0.504229f, 0.000000f, 0.504258f, 
		0.000000f, 0.504270f, 0.000000f, 0.506190f, 
		0.000000f, 0.506253f, 0.000000f, 0.506418f, 
		0.000000f, 0.506806f, 0.000000f, 0.506823f, 
		0.000000f, 0.506835f, 0.000000f, 0.506871f, 
		0.000000f, 0.506906f, 0.000000f, 0.506961f, 
		0.000000f, 0.507319f, 0.000000f, 0.507330f, 
		0.000000f, 0.507366f, 0.000000f, 0.507381f, 
		0.000000f, 0.507404f, 0.000000f, 0.507417f, 
		0.000000f, 0.508021f, 0.000000f, 0.508058f, 
		0.000000f, 0.508126f, 0.000000f, 0.508144f, 
		0.000000f, 0.508236f, 0.000000f, 0.508520f, 
		0.000000f, 0.510903f, 0.000000f, 0.510958f, 
		0.000000f, 0.511017f, 0.000000f, 0.511032f, 
		0.000000f, 0.511082f, 0.000000f, 0.511483f, 
		0.000000f, 0.511499f, 0.000000f, 0.512884f, 
		0.000000f, 0.513787f, 0.000000f, 0.513836f, 
		0.000000f, 0.515432f, 0.000000f, 0.515547f, 
		0.000000f, 0.516117f, 0.000000f, 0.516287f, 
		0.000000f, 0.516509f, 0.000000f, 0.518601f, 
		0.000000f, 0.519983f, 0.000000f, 0.523542f, 
		0.000000f, 0.523607f, 0.000000f, 0.524356f, 
		0.000000f, 0.525893f, 0.000000f, 0.526420f, 
		0.000000f, 0.526801f, 0.000000f, 0.526944f, 
		0.000000f, 0.526955f, 0.000000f, 0.527326f, 
		0.000000f, 0.527345f, 0.000000f, 0.527370f, 
		0.000000f, 0.527385f, 0.000000f, 0.530447f, 
		0.000000f, 0.530542f, 0.000000f, 0.530730f, 
		0.000000f, 0.530846f, 0.000000f, 0.532896f, 
		0.000000f, 0.532971f, 0.000000f, 0.533068f, 
		0.000000f, 0.533130f, 0.000000f, 0.537784f, 
		0.000000f, 0.542145f, 0.000000f, 0.542175f, 
		0.000000f, 0.542250f, 0.000000f, 0.542295f, 
		0.000000f, 0.542419f, 0.000000f, 0.542585f, 
		0.000000f, 0.543589f, 0.000000f, 0.543821f, 
		0.000000f, 0.544232f, 0.000000f, 0.546206f, 
		0.000000f, 0.546288f, 0.000000f, 0.546396f, 
		0.000000f, 0.546410f, 0.000000f, 0.546531f, 
		0.000000f, 0.547390f, 0.000000f, 0.552179f, 
		0.000000f, 0.552195f, 0.000000f, 0.552282f, 
		0.000000f, 0.552353f, 0.000000f, 0.552404f, 
		0.000000f, 0.552416f, 0.000000f, 0.552435f, 
		0.000000f, 0.552477f, 0.000000f, 0.552510f, 
		0.000000f, 0.552525f, 0.000000f, 0.552559f, 
		0.000000f, 0.552642f, 0.000000f, 0.552688f, 
		0.000000f, 0.552718f, 0.000000f, 0.552753f, 
		0.000000f, 0.552838f, 0.000000f, 0.552862f, 
		0.000000f, 0.552948f, 0.000000f, 0.553023f, 
		0.000000f, 0.553085f, 0.000000f, 0.553098f, 
		0.000000f, 0.553127f, 0.000000f, 0.560169f, 
		0.000000f, 0.560198f, 0.000000f, 0.560365f, 
		0.000000f, 0.560516f, 0.000000f, 0.560526f, 
		0.000000f, 0.560549f, 0.000000f, 0.560579f, 
		0.000000f, 0.560663f, 0.000000f, 0.561066f, 
		0.000000f, 0.561100f, 0.000000f, 0.563892f, 
		0.000000f, 0.564036f, 0.000000f, 0.564134f, 
		0.000000f, 0.564204f, 0.000000f, 0.564487f, 
		0.000000f, 0.564509f, 0.000000f, 0.564522f, 
		0.000000f, 0.570408f, 0.000000f, 0.570427f, 
		0.000000f, 0.570511f, 0.000000f, 0.570891f, 
		0.000000f, 0.572439f, 0.000000f, 0.572581f, 
		0.000000f, 0.572714f, 0.000000f, 0.572816f, 
		0.000000f, 0.572867f, 0.000000f, 0.572879f, 
		0.000000f, 0.572936f, 0.000000f, 0.572947f, 
		0.000000f, 0.573034f, 0.000000f, 0.573065f, 
		0.000000f, 0.573724f, 0.000000f, 0.573799f, 
		0.000000f, 0.573812f, 0.000000f, 0.573830f, 
		0.000000f, 0.574440f, 0.000000f, 0.574465f, 
		0.000000f, 0.574486f, 0.000000f, 0.574516f, 
		0.000000f, 0.574531f, 0.000000f, 0.574566f, 
		0.000000f, 0.574584f, 0.000000f, 0.575289f, 
		0.000000f, 0.575303f, 0.000000f, 0.575536f, 
		0.000000f, 0.575615f, 0.000000f, 0.575670f, 
		0.000000f, 0.575741f, 0.000000f, 0.577230f, 
		0.000000f, 0.579269f, 0.000000f, 0.581929f, 
		0.000000f, 0.586232f, 0.000000f, 0.586296f, 
		0.000000f, 0.586460f, 0.000000f, 0.586576f, 
		0.000000f, 0.586613f, 0.000000f, 0.586625f, 
		0.000000f, 0.586637f, 0.000000f, 0.586657f, 
		0.000000f, 0.586716f, 0.000000f, 0.586739f, 
		0.000000f, 0.586806f, 0.000000f, 0.587946f, 
		0.000000f, 0.588020f, 0.000000f, 0.589886f, 
		0.000000f, 0.589955f, 0.000000f, 0.589995f, 
		0.000000f, 0.590012f, 0.000000f, 0.590060f, 
		0.000000f, 0.590500f, 0.000000f, 0.591082f, 
		0.000000f, 0.592181f, 0.000000f, 0.593005f, 
		0.000000f, 0.593292f, 0.000000f, 0.595592f, 
		0.000000f, 0.596131f, 0.000000f, 0.596735f, 
		0.000000f, 0.599093f, 0.000000f, 0.603030f, 
		0.000000f, 0.603881f, 0.000000f, 0.603907f, 
		0.000000f, 0.603928f, 0.000000f, 0.604199f, 
		0.000000f, 0.606304f, 0.000000f, 0.606389f, 
		0.000000f, 0.606988f, 0.000000f, 0.607734f, 
		0.000000f, 0.610950f, 0.000000f, 0.611923f, 
		0.000000f, 0.615954f, 0.000000f, 0.615972f, 
		0.000000f, 0.615991f, 0.000000f, 0.616013f, 
		0.000000f, 0.616077f, 0.000000f, 0.616109f, 
		0.000000f, 0.617324f, 0.000000f, 0.619586f, 
		0.000000f, 0.622718f, 0.000000f, 0.622799f, 
		0.000000f, 0.622849f, 0.000000f, 0.622863f, 
		0.000000f, 0.623353f, 0.000000f, 0.624418f, 
		0.000000f, 0.624501f, 0.000000f, 0.624515f, 
		0.000000f, 0.624558f, 0.000000f, 0.624593f, 
		0.000000f, 0.624604f, 0.000000f, 0.624617f, 
		0.000000f, 0.638857f, 0.000000f, 0.643490f, 
		0.000000f, 0.653119f, 0.000000f, 0.658412f, 
		0.000000f, 0.658459f, 0.000000f, 0.658511f, 
		0.000000f, 0.658524f, 0.000000f, 0.658548f, 
		0.000000f, 0.658586f, 0.000000f, 0.658602f, 
		0.000000f, 0.658644f, 0.000000f, 0.662906f, 
		0.000000f, 0.662917f, 0.000000f, 0.662933f, 
		0.000000f, 0.662948f, 0.000000f, 0.663016f, 
		0.000000f, 0.667981f, 0.000000f, 0.669691f, 
		0.000000f, 0.671950f, 0.000000f, 0.671965f, 
		0.000000f, 0.675481f, 0.000000f, 0.677168f, 
		0.000000f, 0.680270f, 0.000000f, 0.682157f, 
		0.000000f, 0.682934f, 0.000000f, 0.699417f, 
		0.000000f, 0.725672f, 0.000000f, 0.740286f, 
		0.000000f, 0.740485f, 0.000000f, 0.740500f, 
		0.000000f, 0.763179f, 0.000000f, 0.773392f, 
		0.000000f, 0.773421f, 0.000000f, 0.773449f, 
		0.000000f, 0.773464f, 0.000000f, 0.773489f, 
		0.000000f, 0.781793f, 0.000000f, 0.781846f, 
		0.000000f, 0.781861f, 0.000000f, 0.781876f, 
		0.000000f, 0.781889f, 0.000000f, 0.781910f, 
		0.000000f, 0.781961f, 0.000000f, 0.781974f, 
		0.000000f, 0.782009f, 0.000000f, 0.783396f, 
		0.000000f, 1.00000f, 0.000000f, 1.00000f, 
		0.000929000f, 0.00240400f, 0.00118600f, 0.290335f, 
		0.00143000f, 0.562984f, 0.00176428f, 0.935385f, 
		0.0634280f, 0.00226868f, 0.0642090f, 1.00056f, 
		0.0698649f, 0.140064f, 0.0832571f, 0.831643f, 
		0.0832776f, 0.831788f, 0.0832814f, 0.831712f, 
		0.0879472f, 0.824106f, 0.0984856f, 0.803852f, 
		0.100526f, 0.807873f, 0.108515f, 0.675673f, 
		0.109708f, 0.284256f, 0.123600f, 0.624125f, 
		0.125928f, 0.00214784f, 0.137308f, 0.719456f, 
		0.143415f, 0.286830f, 0.146061f, 0.290353f, 
		0.151682f, 0.696637f, 0.156810f, 0.305292f, 
		0.157379f, 1.00039f, 0.160956f, 0.515205f, 
		0.161049f, 0.515089f, 0.161958f, 0.672609f, 
		0.162014f, 0.672678f, 0.165178f, 0.680912f, 
		0.165226f, 0.485065f, 0.165271f, 0.680867f, 
		0.165355f, 0.680911f, 0.170244f, 0.324942f, 
		0.173568f, 0.649220f, 0.174181f, 0.650111f, 
		0.174412f, 0.651175f, 0.175749f, 0.650811f, 
		0.182284f, 0.635431f, 0.188427f, 0.00204658f, 
		0.193638f, 0.612724f, 0.194733f, 0.610381f, 
		0.198869f, 0.397737f, 0.198990f, 0.408252f, 
		0.200004f, 0.599991f, 0.200706f, 0.403215f, 
		0.201962f, 0.403924f, 0.205279f, 0.589441f, 
		0.205880f, 0.411759f, 0.209529f, 0.290471f, 
		0.210468f, 0.693780f, 0.210620f, 0.421240f, 
		0.212826f, 0.425652f, 0.214617f, 0.570767f, 
		0.216421f, 0.567040f, 0.221247f, 0.440664f, 
		0.221300f, 0.557401f, 0.221855f, 0.672159f, 
		0.222698f, 0.552379f, 0.222701f, 0.552509f, 
		0.222701f, 0.552576f, 0.222734f, 0.552303f, 
		0.222752f, 0.552423f, 0.222784f, 0.552409f, 
		0.222931f, 0.552139f, 0.223925f, 0.552151f, 
		0.224399f, 0.555061f, 0.224460f, 0.444922f, 
		0.224511f, 0.555037f, 0.225238f, 0.545481f, 
		0.228540f, 0.457080f, 0.230571f, 0.455543f, 
		0.230984f, 0.464074f, 0.231377f, 0.462279f, 
		0.231397f, 0.462323f, 0.231896f, 0.533927f, 
		0.231981f, 0.531190f, 0.232190f, 0.531076f, 
		0.232301f, 0.452912f, 0.235114f, 0.529771f, 
		0.235226f, 0.470453f, 0.239890f, 0.492279f, 
		0.241284f, 0.515076f, 0.241398f, 0.515017f, 
		0.241405f, 0.514961f, 0.241418f, 0.514879f, 
		0.241783f, 0.509960f, 0.243789f, 0.602170f, 
		0.244220f, 0.500232f, 0.244282f, 0.510917f, 
		0.244417f, 0.510717f, 0.244463f, 0.488927f, 
		0.244601f, 0.494694f, 0.244649f, 0.486114f, 
		0.244732f, 0.500107f, 0.247237f, 0.505271f, 
		0.247266f, 0.495808f, 0.247278f, 0.505219f, 
		0.247292f, 0.505245f, 0.247894f, 0.493100f, 
		0.248022f, 0.492962f, 0.250000f, 0.500000f, 
		0.250085f, 0.499717f, 0.250926f, 0.00196580f, 
		0.252632f, 0.502183f, 0.252953f, 0.502343f, 
		0.256128f, 0.514717f, 0.258748f, 0.523226f, 
		0.258860f, 0.523137f, 0.258870f, 0.523060f, 
		0.258978f, 0.523083f, 0.259520f, 0.469823f, 
		0.260436f, 0.477651f, 0.261567f, 0.524726f, 
		0.262312f, 0.480128f, 0.262430f, 0.480180f, 
		0.262518f, 0.480100f, 0.263150f, 0.522440f, 
		0.263163f, 0.522257f, 0.263186f, 0.522512f, 
		0.263196f, 0.522281f, 0.263201f, 0.522357f, 
		0.263206f, 0.522327f, 0.263218f, 0.522272f, 
		0.263223f, 0.522464f, 0.263239f, 0.522570f, 
		0.263797f, 0.527594f, 0.265616f, 0.468768f, 
		0.265747f, 0.538609f, 0.266989f, 0.535519f, 
		0.267013f, 0.535541f, 0.269133f, 0.461735f, 
		0.269998f, 0.539995f, 0.270097f, 0.724239f, 
		0.271629f, 0.451160f, 0.272546f, 0.537470f, 
		0.273089f, 0.583815f, 0.274294f, 0.455005f, 
		0.274370f, 0.454937f, 0.274380f, 0.555036f, 
		0.276967f, 0.727305f, 0.279266f, 0.000000f, 
		0.281533f, 0.436933f, 0.281912f, 0.551132f, 
		0.282124f, 1.00023f, 0.282875f, 0.561960f, 
		0.284198f, 0.579992f, 0.285255f, 0.570511f, 
		0.285917f, 0.571834f, 0.286336f, 0.574139f, 
		0.286791f, 0.425028f, 0.286830f, 0.000000f, 
		0.287338f, 0.428322f, 0.287535f, 0.0160827f, 
		0.287755f, 0.428168f, 0.288073f, 0.423854f, 
		0.288175f, 0.423649f, 0.288486f, 0.423027f, 
		0.290353f, 0.000000f, 0.291469f, 0.417063f, 
		0.291726f, 0.580336f, 0.292426f, 0.584852f, 
		0.292858f, 0.579657f, 0.293996f, 0.595004f, 
		0.294044f, 0.595143f, 0.295921f, 0.591843f, 
		0.296460f, 0.592921f, 0.296515f, 0.593030f, 
		0.296539f, 0.150105f, 0.296539f, 0.644606f, 
		0.297252f, 0.405495f, 0.297967f, 0.603864f, 
		0.303164f, 0.607936f, 0.304752f, 0.615112f, 
		0.304812f, 0.609623f, 0.305292f, 0.172247f, 
		0.305688f, 0.394230f, 0.306777f, 0.620173f, 
		0.306965f, 0.620346f, 0.307108f, 0.620228f, 
		0.308591f, 0.371825f, 0.308794f, 0.371694f, 
		0.308815f, 0.371522f, 0.309025f, 0.625228f, 
		0.309037f, 0.371034f, 0.309086f, 0.375710f, 
		0.309658f, 0.619316f, 0.313425f, 0.00190046f, 
		0.315287f, 0.630573f, 0.315717f, 0.361843f, 
		0.315728f, 0.361939f, 0.315836f, 0.361867f, 
		0.315881f, 0.361786f, 0.316121f, 0.635069f, 
		0.316283f, 0.375855f, 0.316504f, 0.376356f, 
		0.317195f, 0.363678f, 0.317273f, 0.363654f, 
		0.318418f, 0.363163f, 0.318487f, 0.363026f, 
		0.319567f, 0.380421f, 0.319730f, 0.868915f, 
		0.321822f, 0.353225f, 0.322096f, 0.000000f, 
		0.322096f, 0.838952f, 0.324327f, 1.00000f, 
		0.325107f, 0.647545f, 0.326036f, 0.344554f, 
		0.328736f, 0.000000f, 0.328736f, 1.00000f, 
		0.328831f, 1.00000f, 0.330063f, 0.000000f, 
		0.332009f, 1.00000f, 0.332122f, 1.00000f, 
		0.332315f, 0.000000f, 0.332315f, 1.00000f, 
		0.332957f, 0.000000f, 0.333274f, 0.000000f, 
		0.333274f, 1.00000f, 0.333343f, 0.666686f, 
		0.333370f, 0.000000f, 0.333370f, 1.00000f, 
		0.333514f, 0.000000f, 0.333514f, 1.00000f, 
		0.333525f, 0.000000f, 0.333525f, 1.00000f, 
		0.333551f, 0.000000f, 0.333551f, 1.00000f, 
		0.333998f, 0.664117f, 0.334129f, 0.665749f, 
		0.334286f, 0.000000f, 0.334286f, 1.00000f, 
		0.334585f, 1.00000f, 0.335680f, 0.000000f, 
		0.335680f, 1.00000f, 0.336276f, 1.00000f, 
		0.336312f, 1.00000f, 0.336391f, 0.000000f, 
		0.336391f, 1.00000f, 0.336819f, 0.671887f, 
		0.337105f, 0.671914f, 0.338623f, 0.328974f, 
		0.338780f, 0.677561f, 0.339687f, 0.693950f, 
		0.339963f, 0.694163f, 0.340488f, 1.00000f, 
		0.340627f, 0.000000f, 0.344113f, 0.661289f, 
		0.345516f, 0.654484f, 0.345735f, 0.635434f, 
		0.347976f, 0.591793f, 0.348968f, 0.691110f, 
		0.349503f, 0.699005f, 0.349574f, 0.650426f, 
		0.349889f, 1.00000f, 0.350459f, 0.295684f, 
		0.351194f, 0.714992f, 0.356233f, 0.000000f, 
		0.356233f, 1.00000f, 0.357654f, 0.380356f, 
		0.359241f, 0.376708f, 0.361679f, 0.252645f, 
		0.361679f, 0.850372f, 0.361717f, 0.736832f, 
		0.364858f, 0.724920f, 0.369873f, 0.756765f, 
		0.370960f, 0.246589f, 0.370960f, 0.847929f, 
		0.372939f, 0.000000f, 0.373331f, 0.000000f, 
		0.373331f, 0.745076f, 0.374182f, 0.309720f, 
		0.374182f, 0.744814f, 0.374662f, 0.000000f, 
		0.374662f, 0.704164f, 0.375924f, 0.00185592f, 
		0.378484f, 0.000000f, 0.382007f, 0.000000f, 
		0.385949f, 0.000000f, 0.386520f, 0.773040f, 
		0.389050f, 0.834914f, 0.391633f, 0.000000f, 
		0.391633f, 1.00000f, 0.396271f, 0.000000f, 
		0.396271f, 1.00000f, 0.403958f, 0.000000f, 
		0.404246f, 1.00014f, 0.408959f, 0.000000f, 
		0.408959f, 1.00000f, 0.408960f, 0.000000f, 
		0.408960f, 1.00000f, 0.414943f, 0.000000f, 
		0.414943f, 1.00000f, 0.415148f, 1.00000f, 
		0.415384f, 1.00000f, 0.416802f, 0.833603f, 
		0.419058f, 1.00000f, 0.421908f, 0.150272f, 
		0.421908f, 0.729886f, 0.425891f, 0.000000f, 
		0.425891f, 1.00000f, 0.426439f, 0.000000f, 
		0.426439f, 1.00000f, 0.427268f, 0.333631f, 
		0.427268f, 0.823974f, 0.428911f, 0.000000f, 
		0.428911f, 0.811364f, 0.429089f, 0.000000f, 
		0.429089f, 0.811274f, 0.430134f, 0.334335f, 
		0.430134f, 0.817323f, 0.434723f, 0.000000f, 
		0.434723f, 0.654713f, 0.436496f, 0.000000f, 
		0.436496f, 0.816353f, 0.436607f, 0.000000f, 
		0.436607f, 0.819567f, 0.437270f, 0.158683f, 
		0.437270f, 1.00000f, 0.437495f, 0.000000f, 
		0.437495f, 1.00000f, 0.437688f, 0.000000f, 
		0.437688f, 0.721204f, 0.437871f, 0.000000f, 
		0.437871f, 0.789814f, 0.438424f, 0.00183011f, 
		0.439551f, 0.192924f, 0.439551f, 0.695111f, 
		0.440094f, 0.000000f, 0.440094f, 0.704892f, 
		0.440102f, 0.000000f, 0.440102f, 0.704881f, 
		0.441236f, 0.000000f, 0.441236f, 0.718793f, 
		0.442084f, 0.221042f, 0.442084f, 1.00000f, 
		0.444513f, 0.000000f, 0.444513f, 1.00000f, 
		0.444939f, 1.00000f, 0.444963f, 1.00000f, 
		0.446069f, 0.000000f, 0.446069f, 0.796409f, 
		0.448161f, 0.317451f, 0.448161f, 0.795559f, 
		0.449690f, 0.224845f, 0.449690f, 1.00000f, 
		0.450484f, 1.00000f, 0.450769f, 1.00000f, 
		0.453676f, 0.000000f, 0.453676f, 1.00000f, 
		0.454519f, 1.00000f, 0.455543f, 0.000000f, 
		0.457334f, 0.209042f, 0.457334f, 1.00000f, 
		0.459536f, 0.000000f, 0.459536f, 0.706576f, 
		0.459949f, 0.000000f, 0.459949f, 1.00000f, 
		0.459954f, 0.000000f, 0.459954f, 1.00000f, 
		0.461663f, 0.230832f, 0.461663f, 1.00000f, 
		0.463451f, 0.000000f, 0.463451f, 1.00000f, 
		0.464228f, 0.232222f, 0.464228f, 1.00000f, 
		0.468226f, 0.0852467f, 0.468251f, 0.0852665f, 
		0.469218f, 0.238083f, 0.469218f, 1.00000f, 
		0.469252f, 0.000000f, 0.469270f, 0.758526f, 
		0.469458f, 0.758358f, 0.469553f, 0.758326f, 
		0.470229f, 1.00000f, 0.472228f, 0.225439f, 
		0.472228f, 0.726494f, 0.472237f, 0.000000f, 
		0.472358f, 0.000000f, 0.472372f, 0.000000f, 
		0.472463f, 0.000000f, 0.472478f, 0.000000f, 
		0.472523f, 0.000000f, 0.472567f, 0.000000f, 
		0.472720f, 0.000000f, 0.472748f, 0.000000f, 
		0.473625f, 0.000000f, 0.476973f, 0.256508f, 
		0.476973f, 1.00000f, 0.477356f, 0.000000f, 
		0.477356f, 1.00000f, 0.478562f, 0.727244f, 
		0.478844f, 0.000000f, 0.478844f, 1.00000f, 
		0.479776f, 0.242967f, 0.479776f, 0.734676f, 
		0.481399f, 0.706036f, 0.481706f, 0.000000f, 
		0.481732f, 0.000000f, 0.481808f, 0.000000f, 
		0.481828f, 0.000000f, 0.481840f, 0.000000f, 
		0.481873f, 0.000000f, 0.481893f, 0.000000f, 
		0.481946f, 0.000000f, 0.481959f, 0.000000f, 
		0.481997f, 0.000000f, 0.482071f, 0.000000f, 
		0.482244f, 0.000000f, 0.482306f, 0.000000f, 
		0.486114f, 0.000000f, 0.488329f, 0.000000f, 
		0.488329f, 1.00000f, 0.488667f, 1.00000f, 
		0.488689f, 1.00000f, 0.488756f, 0.000000f, 
		0.488818f, 1.00000f, 0.488914f, 0.000000f, 
		0.488925f, 0.000000f, 0.488925f, 1.00000f, 
		0.488927f, 0.000000f, 0.488997f, 0.000000f, 
		0.489039f, 1.00000f, 0.489083f, 1.00000f, 
		0.489112f, 0.000000f, 0.489112f, 1.00000f, 
		0.489159f, 1.00000f, 0.489191f, 1.00000f, 
		0.489256f, 0.000000f, 0.489256f, 1.00000f, 
		0.489328f, 0.000000f, 0.489328f, 1.00000f, 
		0.489406f, 0.000000f, 0.489406f, 1.00000f, 
		0.489430f, 0.000000f, 0.489430f, 1.00000f, 
		0.489433f, 0.000000f, 0.489433f, 1.00000f, 
		0.489435f, 0.000000f, 0.489435f, 1.00000f, 
		0.489491f, 0.000000f, 0.489496f, 1.00000f, 
		0.489498f, 0.000000f, 0.489559f, 0.000000f, 
		0.489559f, 1.00000f, 0.489574f, 1.00000f, 
		0.489585f, 0.000000f, 0.489585f, 1.00000f, 
		0.489598f, 0.000000f, 0.489598f, 1.00000f, 
		0.489688f, 0.000000f, 0.489688f, 1.00000f, 
		0.489745f, 0.000000f, 0.489801f, 0.000000f, 
		0.489801f, 1.00000f, 0.489906f, 0.000000f, 
		0.489906f, 1.00000f, 0.489919f, 0.000000f, 
		0.489919f, 1.00000f, 0.489959f, 0.000000f, 
		0.489959f, 1.00000f, 0.490004f, 0.000000f, 
		0.490063f, 0.000000f, 0.490063f, 1.00000f, 
		0.490069f, 0.000000f, 0.490077f, 1.00000f, 
		0.490079f, 0.000000f, 0.490079f, 1.00000f, 
		0.490099f, 0.000000f, 0.490099f, 1.00000f, 
		0.490112f, 0.000000f, 0.490112f, 1.00000f, 
		0.490191f, 0.509809f, 0.490909f, 0.000000f, 
		0.490923f, 0.000000f, 0.490923f, 1.00000f, 
		0.490965f, 0.000000f, 0.490965f, 1.00000f, 
		0.490998f, 0.000000f, 0.490998f, 1.00000f, 
		0.491058f, 1.00000f, 0.491251f, 1.00000f, 
		0.491314f, 1.00000f, 0.491342f, 1.00000f, 
		0.491370f, 1.00000f, 0.491386f, 0.000000f, 
		0.491386f, 1.00000f, 0.491455f, 0.000000f, 
		0.491455f, 1.00000f, 0.491471f, 1.00000f, 
		0.491534f, 0.000000f, 0.491534f, 1.00000f, 
		0.491660f, 0.000000f, 0.491660f, 1.00000f, 
		0.491753f, 1.00000f, 0.491765f, 0.000000f, 
		0.491765f, 1.00000f, 0.491929f, 1.00000f, 
		0.492130f, 0.298604f, 0.492192f, 0.000000f, 
		0.492192f, 1.00000f, 0.492368f, 0.000000f, 
		0.492368f, 1.00000f, 0.492960f, 1.00000f, 
		0.493081f, 1.00000f, 0.493134f, 1.00000f, 
		0.493184f, 0.000000f, 0.493184f, 1.00000f, 
		0.493426f, 1.00000f, 0.493434f, 0.000000f, 
		0.493631f, 0.000000f, 0.493631f, 1.00000f, 
		0.493693f, 0.000000f, 0.493693f, 1.00000f, 
		0.493725f, 0.000000f, 0.493725f, 1.00000f, 
		0.493732f, 0.000000f, 0.493732f, 1.00000f, 
		0.493744f, 0.000000f, 0.493744f, 1.00000f, 
		0.493750f, 0.000000f, 0.493750f, 1.00000f, 
		0.493758f, 0.000000f, 0.493759f, 1.00000f, 
		0.493766f, 0.000000f, 0.493766f, 1.00000f, 
		0.493770f, 0.000000f, 0.493770f, 1.00000f, 
		0.493785f, 0.000000f, 0.493785f, 1.00000f, 
		0.493805f, 0.000000f, 0.493805f, 1.00000f, 
		0.493817f, 0.000000f, 0.493817f, 1.00000f, 
		0.493824f, 0.000000f, 0.493824f, 1.00000f, 
		0.493826f, 0.000000f, 0.493826f, 1.00000f, 
		0.493838f, 0.000000f, 0.493838f, 1.00000f, 
		0.493865f, 0.000000f, 0.493865f, 1.00000f, 
		0.493877f, 0.000000f, 0.493877f, 1.00000f, 
		0.493879f, 0.000000f, 0.493879f, 1.00000f, 
		0.494042f, 0.000000f, 0.494042f, 1.00000f, 
		0.494046f, 0.000000f, 0.494046f, 1.00000f, 
		0.494049f, 0.000000f, 0.494049f, 1.00000f, 
		0.494063f, 0.000000f, 0.494074f, 0.000000f, 
		0.494080f, 1.00000f, 0.494095f, 0.000000f, 
		0.494095f, 1.00000f, 0.494101f, 0.000000f, 
		0.494101f, 1.00000f, 0.494106f, 0.000000f, 
		0.494166f, 0.000000f, 0.494185f, 0.000000f, 
		0.494197f, 0.000000f, 0.494197f, 1.00000f, 
		0.494260f, 0.000000f, 0.494261f, 1.00000f, 
		0.494305f, 0.000000f, 0.494319f, 0.000000f, 
		0.494319f, 1.00000f, 0.494327f, 0.000000f, 
		0.494327f, 1.00000f, 0.494346f, 0.000000f, 
		0.494352f, 1.00000f, 0.494361f, 0.000000f, 
		0.494361f, 1.00000f, 0.494363f, 0.000000f, 
		0.494363f, 1.00000f, 0.494369f, 0.000000f, 
		0.494444f, 0.000000f, 0.494444f, 1.00000f, 
		0.494446f, 0.000000f, 0.494446f, 1.00000f, 
		0.494449f, 0.000000f, 0.494454f, 1.00000f, 
		0.494524f, 0.000000f, 0.494527f, 1.00000f, 
		0.494530f, 0.000000f, 0.494530f, 1.00000f, 
		0.494663f, 0.000000f, 0.494674f, 0.000000f, 
		0.494674f, 1.00000f, 0.494693f, 1.00000f, 
		0.494732f, 1.00000f, 0.494788f, 0.000000f, 
		0.494788f, 1.00000f, 0.494823f, 0.000000f, 
		0.494825f, 1.00000f, 0.494876f, 1.00000f, 
		0.494897f, 0.000000f, 0.494897f, 1.00000f, 
		0.494930f, 0.000000f, 0.494930f, 1.00000f, 
		0.494945f, 1.00000f, 0.494966f, 0.000000f, 
		0.494966f, 1.00000f, 0.494966f, 0.000000f, 
		0.494966f, 1.00000f, 0.494991f, 0.000000f, 
		0.494991f, 1.00000f, 0.495051f, 1.00000f, 
		0.495074f, 1.00000f, 0.495249f, 0.000000f, 
		0.495249f, 1.00000f, 0.495263f, 0.000000f, 
		0.495263f, 1.00000f, 0.495287f, 0.000000f, 
		0.495287f, 1.00000f, 0.495287f, 0.000000f, 
		0.495287f, 1.00000f, 0.495337f, 0.000000f, 
		0.495337f, 1.00000f, 0.495409f, 1.00000f, 
		0.495441f, 0.000000f, 0.495444f, 1.00000f, 
		0.495445f, 0.000000f, 0.495445f, 1.00000f, 
		0.495453f, 0.000000f, 0.495453f, 1.00000f, 
		0.495464f, 0.000000f, 0.495464f, 1.00000f, 
		0.495553f, 1.00000f, 0.495557f, 0.000000f, 
		0.495557f, 1.00000f, 0.495647f, 0.000000f, 
		0.495686f, 0.000000f, 0.495755f, 0.000000f, 
		0.495755f, 1.00000f, 0.495758f, 0.000000f, 
		0.495758f, 1.00000f, 0.495766f, 0.000000f, 
		0.495766f, 1.00000f, 0.495780f, 0.000000f, 
		0.495780f, 1.00000f, 0.495806f, 0.000000f, 
		0.495806f, 1.00000f, 0.495808f, 0.000000f, 
		0.495815f, 1.00000f, 0.495830f, 0.000000f, 
		0.495830f, 1.00000f, 0.495845f, 0.000000f, 
		0.495845f, 1.00000f, 0.495853f, 0.000000f, 
		0.495853f, 1.00000f, 0.495856f, 0.000000f, 
		0.495856f, 1.00000f, 0.495862f, 0.000000f, 
		0.495862f, 1.00000f, 0.495877f, 0.000000f, 
		0.495877f, 1.00000f, 0.495879f, 0.000000f, 
		0.495879f, 1.00000f, 0.496103f, 0.000000f, 
		0.496103f, 1.00000f, 0.496267f, 0.000000f, 
		0.496267f, 1.00000f, 0.496276f, 0.000000f, 
		0.496276f, 1.00000f, 0.496308f, 0.000000f, 
		0.496308f, 1.00000f, 0.496311f, 0.000000f, 
		0.496311f, 1.00000f, 0.496319f, 0.000000f, 
		0.496319f, 1.00000f, 0.496337f, 0.000000f, 
		0.496337f, 1.00000f, 0.496364f, 1.00000f, 
		0.496368f, 0.000000f, 0.496368f, 1.00000f, 
		0.496381f, 0.000000f, 0.496381f, 1.00000f, 
		0.496407f, 0.000000f, 0.496407f, 1.00000f, 
		0.496416f, 0.000000f, 0.496416f, 1.00000f, 
		0.496445f, 0.000000f, 0.496445f, 1.00000f, 
		0.496486f, 0.000000f, 0.496486f, 1.00000f, 
		0.496517f, 0.000000f, 0.496517f, 1.00000f, 
		0.496532f, 0.000000f, 0.496532f, 1.00000f, 
		0.496557f, 0.000000f, 0.496557f, 1.00000f, 
		0.496586f, 0.000000f, 0.496586f, 1.00000f, 
		0.496587f, 0.000000f, 0.496587f, 1.00000f, 
		0.496593f, 0.000000f, 0.496593f, 1.00000f, 
		0.496633f, 0.000000f, 0.496633f, 0.714011f, 
		0.496636f, 0.000000f, 0.496636f, 1.00000f, 
		0.496658f, 0.000000f, 0.496658f, 1.00000f, 
		0.496746f, 0.000000f, 0.496746f, 1.00000f, 
		0.496769f, 0.000000f, 0.496769f, 1.00000f, 
		0.496787f, 0.000000f, 0.496787f, 1.00000f, 
		0.496831f, 0.000000f, 0.496831f, 1.00000f, 
		0.496948f, 0.000000f, 0.496948f, 1.00000f, 
		0.497279f, 0.502721f, 0.497426f, 1.00000f, 
		0.497426f, 0.000000f, 0.497426f, 1.00000f, 
		0.497427f, 0.0722009f, 0.497427f, 1.00000f, 
		0.497504f, 0.000000f, 0.497504f, 1.00000f, 
		0.497515f, 0.000000f, 0.497515f, 1.00000f, 
		0.497538f, 0.000000f, 0.497538f, 1.00000f, 
		0.497553f, 1.00000f, 0.497570f, 1.00000f, 
		0.497571f, 0.000000f, 0.497573f, 1.00000f, 
		0.497588f, 1.00000f, 0.497610f, 0.000000f, 
		0.497635f, 0.000000f, 0.497635f, 1.00000f, 
		0.497663f, 0.000000f, 0.497666f, 1.00000f, 
		0.497671f, 0.000000f, 0.497671f, 1.00000f, 
		0.497685f, 1.00000f, 0.497688f, 0.000000f, 
		0.497688f, 1.00000f, 0.497689f, 0.000000f, 
		0.497689f, 1.00000f, 0.497689f, 0.000000f, 
		0.497689f, 1.00000f, 0.497696f, 0.000000f, 
		0.497696f, 1.00000f, 0.497706f, 0.000000f, 
		0.497706f, 1.00000f, 0.497731f, 0.000000f, 
		0.497741f, 1.00000f, 0.497747f, 0.000000f, 
		0.497747f, 1.00000f, 0.497763f, 0.000000f, 
		0.497769f, 1.00000f, 0.497775f, 0.000000f, 
		0.497819f, 1.00000f, 0.497821f, 0.000000f, 
		0.497821f, 1.00000f, 0.497827f, 0.000000f, 
		0.497827f, 1.00000f, 0.497835f, 0.000000f, 
		0.497835f, 1.00000f, 0.497871f, 0.000000f, 
		0.497871f, 1.00000f, 0.497900f, 1.00000f, 
		0.497950f, 0.000000f, 0.497950f, 1.00000f, 
		0.497968f, 0.000000f, 0.497968f, 1.00000f, 
		0.497979f, 1.00000f, 0.498076f, 1.00000f, 
		0.498147f, 1.00000f, 0.498157f, 0.000000f, 
		0.498157f, 1.00000f, 0.498161f, 0.000000f, 
		0.498161f, 1.00000f, 0.498165f, 0.000000f, 
		0.498165f, 1.00000f, 0.498182f, 1.00000f, 
		0.498184f, 0.000000f, 0.498184f, 1.00000f, 
		0.498193f, 0.501807f, 0.498199f, 0.000000f, 
		0.498212f, 0.501788f, 0.498216f, 1.00000f, 
		0.498240f, 1.00000f, 0.498248f, 0.000000f, 
		0.498248f, 1.00000f, 0.498285f, 0.000000f, 
		0.498285f, 1.00000f, 0.498288f, 0.000000f, 
		0.498288f, 1.00000f, 0.498301f, 0.000000f, 
		0.498301f, 1.00000f, 0.498324f, 0.000000f, 
		0.498324f, 1.00000f, 0.498328f, 0.000000f, 
		0.498328f, 1.00000f, 0.498353f, 1.00000f, 
		0.498368f, 0.000000f, 0.498368f, 1.00000f, 
		0.498488f, 0.000000f, 0.498488f, 1.00000f, 
		0.498540f, 0.000000f, 0.498540f, 1.00000f, 
		0.498550f, 0.000000f, 0.498550f, 1.00000f, 
		0.498560f, 0.000000f, 0.498563f, 1.00000f, 
		0.498569f, 0.000000f, 0.498569f, 1.00000f, 
		0.498574f, 0.000000f, 0.498574f, 1.00000f, 
		0.498586f, 1.00000f, 0.498592f, 0.000000f, 
		0.498592f, 1.00000f, 0.498596f, 0.000000f, 
		0.498596f, 1.00000f, 0.498596f, 0.000000f, 
		0.498596f, 0.749298f, 0.498599f, 0.000000f, 
		0.498599f, 1.00000f, 0.498599f, 0.000000f, 
		0.498599f, 1.00000f, 0.498616f, 0.000000f, 
		0.498616f, 1.00000f, 0.498656f, 0.000000f, 
		0.498656f, 1.00000f, 0.498709f, 0.000000f, 
		0.498722f, 0.000000f, 0.498723f, 1.00000f, 
		0.498770f, 1.00000f, 0.498779f, 0.000000f, 
		0.498779f, 1.00000f, 0.498792f, 1.00000f, 
		0.498809f, 0.000000f, 0.498841f, 0.000000f, 
		0.498870f, 0.000000f, 0.498879f, 1.00000f, 
		0.498881f, 0.000000f, 0.498881f, 1.00000f, 
		0.498892f, 0.000000f, 0.498892f, 1.00000f, 
		0.498895f, 0.000000f, 0.498895f, 1.00000f, 
		0.498966f, 0.000000f, 0.498966f, 1.00000f, 
		0.499066f, 1.00000f, 0.499110f, 0.000000f, 
		0.499110f, 1.00000f, 0.499112f, 0.000000f, 
		0.499112f, 1.00000f, 0.499131f, 0.000000f, 
		0.499131f, 1.00000f, 0.499157f, 0.000000f, 
		0.499157f, 1.00000f, 0.499206f, 0.000000f, 
		0.499206f, 1.00000f, 0.499214f, 0.000000f, 
		0.499214f, 1.00000f, 0.499239f, 0.000000f, 
		0.499239f, 1.00000f, 0.499264f, 0.000000f, 
		0.499264f, 1.00000f, 0.499389f, 0.000000f, 
		0.499389f, 1.00000f, 0.499392f, 0.000000f, 
		0.499392f, 1.00000f, 0.499400f, 0.000000f, 
		0.499400f, 1.00000f, 0.499402f, 0.000000f, 
		0.499402f, 1.00000f, 0.499404f, 0.000000f, 
		0.499404f, 1.00000f, 0.499422f, 0.000000f, 
		0.499422f, 1.00000f, 0.499432f, 0.000000f, 
		0.499432f, 1.00000f, 0.499449f, 0.000000f, 
		0.499449f, 1.00000f, 0.499456f, 0.000000f, 
		0.499456f, 1.00000f, 0.499458f, 0.000000f, 
		0.499458f, 1.00000f, 0.499476f, 0.000000f, 
		0.499476f, 1.00000f, 0.499489f, 0.000000f, 
		0.499489f, 1.00000f, 0.499514f, 0.000000f, 
		0.499514f, 1.00000f, 0.499542f, 1.00000f, 
		0.499581f, 0.000000f, 0.499581f, 1.00000f, 
		0.499586f, 0.000000f, 0.499586f, 1.00000f, 
		0.499627f, 0.000000f, 0.499627f, 1.00000f, 
		0.499644f, 0.000000f, 0.499644f, 1.00000f, 
		0.499686f, 0.000000f, 0.499686f, 1.00000f, 
		0.499717f, 0.000000f, 0.499743f, 1.00000f, 
		0.499752f, 0.000000f, 0.499752f, 1.00000f, 
		0.499772f, 1.00000f, 0.499803f, 1.00000f, 
		0.499827f, 1.00000f, 0.499842f, 0.000000f, 
		0.499847f, 1.00000f, 0.499848f, 0.000000f, 
		0.499848f, 1.00000f, 0.499849f, 0.000000f, 
		0.499849f, 1.00000f, 0.499863f, 1.00000f, 
		0.499911f, 0.000000f, 0.499911f, 1.00000f, 
		0.499967f, 0.000000f, 0.499967f, 1.00000f, 
		0.499978f, 0.000000f, 0.499978f, 1.00000f, 
		0.500000f, 0.000000f, 0.500000f, 0.250000f, 
		0.500000f, 0.500000f, 0.500000f, 0.750000f, 
		0.500000f, 1.00000f, 0.500030f, 0.000000f, 
		0.500030f, 1.00000f, 0.500032f, 0.000000f, 
		0.500032f, 1.00000f, 0.500074f, 1.00000f, 
		0.500079f, 0.000000f, 0.500079f, 1.00000f, 
		0.500100f, 0.000000f, 0.500100f, 1.00000f, 
		0.500114f, 0.000000f, 0.500114f, 1.00000f, 
		0.500133f, 0.000000f, 0.500133f, 1.00000f, 
		0.500140f, 0.000000f, 0.500140f, 1.00000f, 
		0.500146f, 0.000000f, 0.500146f, 1.00000f, 
		0.500149f, 0.000000f, 0.500149f, 1.00000f, 
		0.500150f, 0.000000f, 0.500150f, 1.00000f, 
		0.500170f, 0.000000f, 0.500170f, 1.00000f, 
		0.500192f, 0.000000f, 0.500192f, 1.00000f, 
		0.500221f, 0.000000f, 0.500221f, 1.00000f, 
		0.500223f, 0.000000f, 0.500256f, 1.00000f, 
		0.500277f, 0.000000f, 0.500277f, 1.00000f, 
		0.500313f, 0.000000f, 0.500313f, 1.00000f, 
		0.500322f, 0.000000f, 0.500322f, 1.00000f, 
		0.500324f, 0.000000f, 0.500324f, 1.00000f, 
		0.500331f, 0.000000f, 0.500331f, 1.00000f, 
		0.500331f, 0.000000f, 0.500331f, 1.00000f, 
		0.500332f, 0.000000f, 0.500332f, 1.00000f, 
		0.500334f, 0.000000f, 0.500334f, 1.00000f, 
		0.500340f, 0.000000f, 0.500348f, 1.00000f, 
		0.500348f, 0.000000f, 0.500348f, 1.00000f, 
		0.500352f, 0.000000f, 0.500378f, 0.000000f, 
		0.500378f, 1.00000f, 0.500398f, 0.000000f, 
		0.500398f, 1.00000f, 0.500422f, 0.000000f, 
		0.500422f, 1.00000f, 0.500437f, 0.000000f, 
		0.500437f, 1.00000f, 0.500450f, 0.000000f, 
		0.500450f, 1.00000f, 0.500454f, 0.000000f, 
		0.500457f, 1.00000f, 0.500481f, 0.000000f, 
		0.500481f, 1.00000f, 0.500485f, 0.000000f, 
		0.500485f, 1.00000f, 0.500497f, 0.000000f, 
		0.500497f, 1.00000f, 0.500510f, 0.000000f, 
		0.500519f, 1.00000f, 0.500527f, 0.000000f, 
		0.500527f, 1.00000f, 0.500537f, 0.000000f, 
		0.500537f, 1.00000f, 0.500551f, 0.000000f, 
		0.500563f, 0.000000f, 0.500563f, 1.00000f, 
		0.500567f, 0.000000f, 0.500599f, 0.749701f, 
		0.500611f, 0.000000f, 0.500812f, 0.000000f, 
		0.500812f, 1.00000f, 0.500923f, 0.00182009f, 
		0.500933f, 0.000000f, 0.500933f, 1.00000f, 
		0.500983f, 0.000000f, 0.500983f, 1.00000f, 
		0.501014f, 0.000000f, 0.501014f, 1.00000f, 
		0.501043f, 0.000000f, 0.501043f, 1.00000f, 
		0.501079f, 0.000000f, 0.501079f, 1.00000f, 
		0.501091f, 0.000000f, 0.501091f, 1.00000f, 
		0.501107f, 0.000000f, 0.501143f, 0.000000f, 
		0.501181f, 0.000000f, 0.501181f, 1.00000f, 
		0.501185f, 0.000000f, 0.501185f, 1.00000f, 
		0.501229f, 0.000000f, 0.501229f, 1.00000f, 
		0.501261f, 0.000000f, 0.501261f, 1.00000f, 
		0.501289f, 1.00000f, 0.501303f, 0.000000f, 
		0.501313f, 1.00000f, 0.501341f, 0.000000f, 
		0.501341f, 1.00000f, 0.501351f, 0.000000f, 
		0.501351f, 1.00000f, 0.501356f, 0.000000f, 
		0.501356f, 1.00000f, 0.501368f, 0.000000f, 
		0.501368f, 1.00000f, 0.501373f, 0.000000f, 
		0.501373f, 1.00000f, 0.501379f, 0.000000f, 
		0.501379f, 1.00000f, 0.501390f, 0.000000f, 
		0.501390f, 1.00000f, 0.501401f, 0.000000f, 
		0.501401f, 1.00000f, 0.501457f, 0.000000f, 
		0.501457f, 1.00000f, 0.501459f, 0.000000f, 
		0.501459f, 1.00000f, 0.501459f, 0.000000f, 
		0.501459f, 1.00000f, 0.501469f, 1.00000f, 
		0.501503f, 0.000000f, 0.501503f, 1.00000f, 
		0.501508f, 0.000000f, 0.501523f, 0.000000f, 
		0.501523f, 1.00000f, 0.501525f, 0.000000f, 
		0.501542f, 0.000000f, 0.501542f, 1.00000f, 
		0.501702f, 0.000000f, 0.501702f, 1.00000f, 
		0.501709f, 0.000000f, 0.501723f, 0.000000f, 
		0.501723f, 1.00000f, 0.501725f, 0.000000f, 
		0.501725f, 1.00000f, 0.501745f, 1.00000f, 
		0.501775f, 0.000000f, 0.501775f, 1.00000f, 
		0.501806f, 0.000000f, 0.501806f, 1.00000f, 
		0.501864f, 0.000000f, 0.501864f, 1.00000f, 
		0.501884f, 0.000000f, 0.501885f, 1.00000f, 
		0.501909f, 0.000000f, 0.501909f, 1.00000f, 
		0.501917f, 0.000000f, 0.501953f, 0.000000f, 
		0.501953f, 1.00000f, 0.501978f, 0.000000f, 
		0.501978f, 1.00000f, 0.501983f, 0.000000f, 
		0.501983f, 1.00000f, 0.502024f, 0.000000f, 
		0.502026f, 1.00000f, 0.502042f, 0.000000f, 
		0.502045f, 1.00000f, 0.502053f, 0.000000f, 
		0.502065f, 0.000000f, 0.502065f, 1.00000f, 
		0.502076f, 0.000000f, 0.502088f, 0.000000f, 
		0.502088f, 1.00000f, 0.502089f, 0.000000f, 
		0.502089f, 1.00000f, 0.502091f, 0.000000f, 
		0.502095f, 1.00000f, 0.502118f, 0.000000f, 
		0.502118f, 1.00000f, 0.502169f, 1.00000f, 
		0.502181f, 0.000000f, 0.502181f, 1.00000f, 
		0.502183f, 0.000000f, 0.502183f, 1.00000f, 
		0.502249f, 0.000000f, 0.502263f, 0.000000f, 
		0.502263f, 1.00000f, 0.502392f, 0.000000f, 
		0.502392f, 1.00000f, 0.502421f, 0.000000f, 
		0.502421f, 1.00000f, 0.502438f, 0.000000f, 
		0.502438f, 1.00000f, 0.502519f, 0.000000f, 
		0.502519f, 1.00000f, 0.502684f, 0.000000f, 
		0.502705f, 1.00000f, 0.502807f, 1.00000f, 
		0.502859f, 0.000000f, 0.502859f, 1.00000f, 
		0.502867f, 0.000000f, 0.502867f, 1.00000f, 
		0.502871f, 0.000000f, 0.502871f, 1.00000f, 
		0.502973f, 1.00000f, 0.502998f, 0.000000f, 
		0.502998f, 1.00000f, 0.503019f, 0.000000f, 
		0.503019f, 0.695287f, 0.503022f, 0.000000f, 
		0.503022f, 1.00000f, 0.503057f, 0.000000f, 
		0.503057f, 1.00000f, 0.503068f, 0.000000f, 
		0.503075f, 1.00000f, 0.503105f, 1.00000f, 
		0.503204f, 1.00000f, 0.503215f, 1.00000f, 
		0.503288f, 1.00000f, 0.503329f, 0.757308f, 
		0.503336f, 1.00000f, 0.503408f, 0.000000f, 
		0.503408f, 1.00000f, 0.503425f, 0.000000f, 
		0.503425f, 1.00000f, 0.503440f, 1.00000f, 
		0.503440f, 0.000000f, 0.503440f, 1.00000f, 
		0.503548f, 0.000000f, 0.503621f, 0.000000f, 
		0.503621f, 1.00000f, 0.503667f, 0.000000f, 
		0.503667f, 1.00000f, 0.503694f, 0.000000f, 
		0.503739f, 0.000000f, 0.503742f, 1.00000f, 
		0.503764f, 0.000000f, 0.503764f, 1.00000f, 
		0.503774f, 0.000000f, 0.503774f, 1.00000f, 
		0.503797f, 0.000000f, 0.503797f, 1.00000f, 
		0.503811f, 0.000000f, 0.503817f, 1.00000f, 
		0.503871f, 0.000000f, 0.503895f, 0.000000f, 
		0.503911f, 0.000000f, 0.503937f, 0.000000f, 
		0.503963f, 0.000000f, 0.503963f, 1.00000f, 
		0.503986f, 0.000000f, 0.504020f, 0.000000f, 
		0.504020f, 1.00000f, 0.504144f, 0.000000f, 
		0.504144f, 1.00000f, 0.504337f, 1.00000f, 
		0.504381f, 0.000000f, 0.504381f, 1.00000f, 
		0.504443f, 0.000000f, 0.504450f, 1.00000f, 
		0.504480f, 0.000000f, 0.504480f, 1.00000f, 
		0.504492f, 0.000000f, 0.504499f, 1.00000f, 
		0.504505f, 0.000000f, 0.504505f, 1.00000f, 
		0.504506f, 0.000000f, 0.504506f, 1.00000f, 
		0.504523f, 0.000000f, 0.504523f, 1.00000f, 
		0.504552f, 0.000000f, 0.504552f, 1.00000f, 
		0.504570f, 1.00000f, 0.504627f, 1.00000f, 
		0.504671f, 0.000000f, 0.504671f, 1.00000f, 
		0.504685f, 1.00000f, 0.504702f, 0.000000f, 
		0.504702f, 1.00000f, 0.504704f, 0.000000f, 
		0.504708f, 1.00000f, 0.504714f, 0.000000f, 
		0.504714f, 1.00000f, 0.504791f, 0.000000f, 
		0.504791f, 1.00000f, 0.504798f, 0.000000f, 
		0.504798f, 1.00000f, 0.504810f, 0.000000f, 
		0.504810f, 1.00000f, 0.504821f, 0.000000f, 
		0.504821f, 1.00000f, 0.504823f, 0.000000f, 
		0.504823f, 1.00000f, 0.504825f, 0.000000f, 
		0.504825f, 1.00000f, 0.504842f, 0.000000f, 
		0.504842f, 1.00000f, 0.504923f, 0.000000f, 
		0.505033f, 0.000000f, 0.505033f, 1.00000f, 
		0.505227f, 0.000000f, 0.505229f, 1.00000f, 
		0.505362f, 1.00000f, 0.505399f, 0.000000f, 
		0.505399f, 1.00000f, 0.505418f, 0.000000f, 
		0.505418f, 1.00000f, 0.505439f, 0.000000f, 
		0.505439f, 1.00000f, 0.505510f, 0.000000f, 
		0.505510f, 1.00000f, 0.505541f, 0.247230f, 
		0.505541f, 1.00000f, 0.505565f, 1.00000f, 
		0.505569f, 0.000000f, 0.505569f, 1.00000f, 
		0.505576f, 0.000000f, 0.505576f, 1.00000f, 
		0.505580f, 0.000000f, 0.505580f, 1.00000f, 
		0.505615f, 0.247193f, 0.505615f, 1.00000f, 
		0.505623f, 0.000000f, 0.505623f, 1.00000f, 
		0.505639f, 0.000000f, 0.505639f, 1.00000f, 
		0.505660f, 0.000000f, 0.505660f, 1.00000f, 
		0.505874f, 0.000000f, 0.505874f, 1.00000f, 
		0.505889f, 0.000000f, 0.505889f, 1.00000f, 
		0.505968f, 0.000000f, 0.505968f, 1.00000f, 
		0.506014f, 0.000000f, 0.506014f, 1.00000f, 
		0.506067f, 0.000000f, 0.506067f, 1.00000f, 
		0.506079f, 0.000000f, 0.506079f, 1.00000f, 
		0.506083f, 0.000000f, 0.506083f, 1.00000f, 
		0.506146f, 0.000000f, 0.506280f, 0.000000f, 
		0.506280f, 1.00000f, 0.506353f, 0.000000f, 
		0.506353f, 1.00000f, 0.506382f, 0.000000f, 
		0.506382f, 1.00000f, 0.506403f, 0.000000f, 
		0.506403f, 1.00000f, 0.506423f, 1.00000f, 
		0.506432f, 0.000000f, 0.506432f, 1.00000f, 
		0.506452f, 0.000000f, 0.506452f, 1.00000f, 
		0.506485f, 0.000000f, 0.506485f, 1.00000f, 
		0.506508f, 0.000000f, 0.506508f, 1.00000f, 
		0.506543f, 0.000000f, 0.506543f, 1.00000f, 
		0.506566f, 0.000000f, 0.506566f, 1.00000f, 
		0.506597f, 0.000000f, 0.506597f, 1.00000f, 
		0.506627f, 0.000000f, 0.506627f, 1.00000f, 
		0.506644f, 0.000000f, 0.506644f, 1.00000f, 
		0.506696f, 0.000000f, 0.506696f, 1.00000f, 
		0.506730f, 0.000000f, 0.506730f, 1.00000f, 
		0.506746f, 1.00000f, 0.506747f, 0.000000f, 
		0.506747f, 1.00000f, 0.506810f, 0.000000f, 
		0.506810f, 1.00000f, 0.506826f, 0.000000f, 
		0.506826f, 1.00000f, 0.506884f, 0.000000f, 
		0.506884f, 1.00000f, 0.506966f, 0.000000f, 
		0.506966f, 1.00000f, 0.506992f, 0.000000f, 
		0.506992f, 1.00000f, 0.506995f, 0.000000f, 
		0.506995f, 1.00000f, 0.507049f, 0.000000f, 
		0.507049f, 1.00000f, 0.507090f, 0.000000f, 
		0.507222f, 1.00000f, 0.507300f, 1.00000f, 
		0.507300f, 0.000000f, 0.507300f, 1.00000f, 
		0.507496f, 0.000000f, 0.507496f, 1.00000f, 
		0.507506f, 1.00000f, 0.507556f, 0.000000f, 
		0.507556f, 1.00000f, 0.507604f, 0.000000f, 
		0.507604f, 1.00000f, 0.507720f, 1.00000f, 
		0.509023f, 0.000000f, 0.509023f, 1.00000f, 
		0.509026f, 0.000000f, 0.509026f, 1.00000f, 
		0.509032f, 0.000000f, 0.509032f, 1.00000f, 
		0.509049f, 0.000000f, 0.509049f, 1.00000f, 
		0.509126f, 0.000000f, 0.509126f, 1.00000f, 
		0.509133f, 0.000000f, 0.509133f, 1.00000f, 
		0.509138f, 0.795060f, 0.509161f, 0.156975f, 
		0.509161f, 1.00000f, 0.509244f, 0.000000f, 
		0.509244f, 1.00000f, 0.509271f, 0.156949f, 
		0.509271f, 1.00000f, 0.509276f, 0.156923f, 
		0.509276f, 1.00000f, 0.509284f, 0.156918f, 
		0.509284f, 1.00000f, 0.509431f, 0.000000f, 
		0.509431f, 1.00000f, 0.509490f, 0.000000f, 
		0.509606f, 0.000000f, 0.509606f, 1.00000f, 
		0.509638f, 0.000000f, 0.509638f, 1.00000f, 
		0.509659f, 0.000000f, 0.509659f, 1.00000f, 
		0.509919f, 1.00000f, 0.509955f, 0.000000f, 
		0.509955f, 1.00000f, 0.510342f, 0.0724792f, 
		0.510365f, 0.000000f, 0.510365f, 1.00000f, 
		0.510419f, 0.000000f, 0.510419f, 1.00000f, 
		0.510632f, 0.000000f, 0.510808f, 0.000000f, 
		0.510808f, 1.00000f, 0.511426f, 0.000000f, 
		0.511514f, 0.000000f, 0.511714f, 0.000000f, 
		0.511714f, 1.00000f, 0.511784f, 0.000000f, 
		0.511784f, 1.00000f, 0.511860f, 1.00000f, 
		0.511899f, 1.00000f, 0.511917f, 0.000000f, 
		0.511917f, 1.00000f, 0.512162f, 0.000000f, 
		0.512162f, 1.00000f, 0.512429f, 0.000000f, 
		0.512429f, 1.00000f, 0.512472f, 0.000000f, 
		0.512472f, 1.00000f, 0.512737f, 0.000000f, 
		0.512737f, 1.00000f, 0.512761f, 0.000000f, 
		0.512761f, 1.00000f, 0.512764f, 0.000000f, 
		0.512764f, 1.00000f, 0.512820f, 0.000000f, 
		0.512820f, 1.00000f, 0.512885f, 0.000000f, 
		0.512905f, 0.000000f, 0.512936f, 0.000000f, 
		0.512936f, 1.00000f, 0.513057f, 0.000000f, 
		0.513057f, 1.00000f, 0.513267f, 0.000000f, 
		0.513267f, 1.00000f, 0.513325f, 0.000000f, 
		0.513325f, 1.00000f, 0.513327f, 0.000000f, 
		0.513327f, 1.00000f, 0.513457f, 0.000000f, 
		0.513457f, 1.00000f, 0.513460f, 0.000000f, 
		0.513460f, 1.00000f, 0.513641f, 0.000000f, 
		0.513707f, 0.000000f, 0.513707f, 1.00000f, 
		0.513835f, 1.00000f, 0.513945f, 0.000000f, 
		0.513945f, 1.00000f, 0.515781f, 1.00000f, 
		0.515962f, 0.000000f, 0.515962f, 1.00000f, 
		0.515986f, 0.000000f, 0.515986f, 1.00000f, 
		0.516193f, 0.000000f, 0.516193f, 1.00000f, 
		0.517353f, 0.000000f, 0.517353f, 1.00000f, 
		0.517590f, 1.00000f, 0.517656f, 1.00000f, 
		0.517686f, 0.000000f, 0.517686f, 1.00000f, 
		0.517756f, 0.000000f, 0.517756f, 1.00000f, 
		0.517814f, 0.000000f, 0.517814f, 1.00000f, 
		0.517847f, 0.276297f, 0.517862f, 1.00000f, 
		0.517877f, 1.00000f, 0.517911f, 1.00000f, 
		0.517912f, 0.000000f, 0.517912f, 1.00000f, 
		0.517918f, 0.000000f, 0.517918f, 1.00000f, 
		0.517975f, 0.000000f, 0.517975f, 1.00000f, 
		0.517990f, 0.000000f, 0.517990f, 1.00000f, 
		0.518210f, 1.00000f, 0.518642f, 0.000000f, 
		0.519230f, 0.000000f, 0.519230f, 1.00000f, 
		0.520187f, 0.000000f, 0.520187f, 1.00000f, 
		0.520335f, 0.000000f, 0.520335f, 1.00000f, 
		0.520368f, 0.000000f, 0.520571f, 0.000000f, 
		0.521848f, 0.000000f, 0.521848f, 1.00000f, 
		0.521957f, 0.795457f, 0.523060f, 0.000000f, 
		0.523137f, 0.000000f, 0.523230f, 0.000000f, 
		0.523273f, 0.000000f, 0.523450f, 0.000000f, 
		0.523475f, 0.000000f, 0.523475f, 1.00000f, 
		0.523481f, 0.000000f, 0.523507f, 0.000000f, 
		0.524880f, 0.000000f, 0.524880f, 1.00000f, 
		0.524890f, 0.300150f, 0.524890f, 1.00000f, 
		0.526748f, 1.00000f, 0.529037f, 1.00012f, 
		0.530177f, 0.757312f, 0.531361f, 0.234320f, 
		0.531361f, 1.00000f, 0.532671f, 0.000000f, 
		0.532671f, 1.00000f, 0.534502f, 0.000000f, 
		0.537102f, 0.231449f, 0.537102f, 1.00000f, 
		0.537228f, 0.000000f, 0.539991f, 0.250148f, 
		0.539995f, 0.231209f, 0.540101f, 0.000000f, 
		0.540101f, 0.773125f, 0.540484f, 1.00000f, 
		0.544093f, 0.266856f, 0.545995f, 0.000000f, 
		0.546552f, 0.140064f, 0.547390f, 0.273695f, 
		0.548580f, 0.000000f, 0.548580f, 0.794024f, 
		0.549615f, 0.000000f, 0.549615f, 0.766611f, 
		0.549872f, 0.000000f, 0.549872f, 0.766763f, 
		0.549876f, 0.289760f, 0.549876f, 0.794896f, 
		0.551083f, 0.000000f, 0.551127f, 0.000000f, 
		0.551127f, 0.775563f, 0.552523f, 1.00000f, 
		0.552541f, 1.00000f, 0.554051f, 0.000000f, 
		0.554051f, 1.00000f, 0.554144f, 0.301583f, 
		0.554144f, 0.803908f, 0.554221f, 0.000000f, 
		0.554221f, 0.815771f, 0.555367f, 0.205534f, 
		0.555367f, 1.00000f, 0.556496f, 1.00000f, 
		0.556528f, 1.00000f, 0.556540f, 1.00000f, 
		0.556570f, 1.00000f, 0.556581f, 1.00000f, 
		0.556617f, 1.00000f, 0.557030f, 0.278515f, 
		0.557030f, 0.778515f, 0.557033f, 0.000000f, 
		0.557033f, 1.00000f, 0.557237f, 0.278618f, 
		0.557237f, 0.778618f, 0.558197f, 0.000000f, 
		0.558197f, 1.00000f, 0.559559f, 0.000000f, 
		0.559559f, 0.806275f, 0.560363f, 0.000000f, 
		0.560398f, 0.000000f, 0.561800f, 0.000000f, 
		0.561800f, 1.00000f, 0.561981f, 0.000000f, 
		0.561981f, 1.00000f, 0.563007f, 0.000000f, 
		0.563007f, 0.781504f, 0.563066f, 1.00000f, 
		0.563422f, 0.00183176f, 0.566911f, 0.000000f, 
		0.566911f, 1.00000f, 0.567398f, 0.000000f, 
		0.567398f, 1.00000f, 0.567750f, 0.000000f, 
		0.567750f, 1.00000f, 0.568396f, 0.000000f, 
		0.568396f, 1.00000f, 0.569012f, 0.166870f, 
		0.569012f, 1.00000f, 0.569872f, 0.188764f, 
		0.569872f, 0.690029f, 0.571701f, 0.214150f, 
		0.571701f, 1.00000f, 0.572917f, 0.286458f, 
		0.572917f, 0.786458f, 0.574061f, 0.000000f, 
		0.574061f, 1.00000f, 0.575430f, 0.179965f, 
		0.575430f, 0.677190f, 0.578253f, 0.174939f, 
		0.578253f, 0.666964f, 0.578254f, 0.174952f, 
		0.578254f, 0.666907f, 0.579992f, 0.000000f, 
		0.580575f, 0.000000f, 0.580575f, 1.00000f, 
		0.581287f, 1.00000f, 0.582329f, 0.831712f, 
		0.582402f, 0.831788f, 0.582643f, 0.831643f, 
		0.582937f, 0.759047f, 0.584252f, 0.786040f, 
		0.584755f, 0.000000f, 0.586132f, 0.000000f, 
		0.586132f, 0.793066f, 0.587947f, 0.824106f, 
		0.589435f, 0.000000f, 0.589435f, 1.00000f, 
		0.589442f, 0.000000f, 0.590239f, 0.000000f, 
		0.594505f, 0.659771f, 0.594627f, 0.807873f, 
		0.596785f, 0.698381f, 0.598280f, 0.803852f, 
		0.599100f, 0.299634f, 0.599100f, 1.00000f, 
		0.599105f, 0.175392f, 0.600796f, 0.699417f, 
		0.605769f, 0.197115f, 0.605769f, 0.613871f, 
		0.606021f, 0.153349f, 0.609195f, 1.00000f, 
		0.615603f, 0.000000f, 0.615603f, 0.692199f, 
		0.618932f, 0.000000f, 0.618968f, 0.000000f, 
		0.618980f, 0.000000f, 0.619008f, 0.000000f, 
		0.619049f, 0.000000f, 0.619090f, 0.000000f, 
		0.619178f, 0.000000f, 0.619579f, 1.00000f, 
		0.621219f, 1.00000f, 0.625921f, 0.00186333f, 
		0.627025f, 0.142537f, 0.627025f, 0.620370f, 
		0.634137f, 0.719456f, 0.642155f, 0.178922f, 
		0.642155f, 0.678922f, 0.642488f, 1.00000f, 
		0.642561f, 1.00000f, 0.647049f, 0.000000f, 
		0.647049f, 1.00000f, 0.649227f, 0.284256f, 
		0.649640f, 0.000000f, 0.650497f, 0.699005f, 
		0.651359f, 0.682157f, 0.653212f, 1.00000f, 
		0.654484f, 0.654484f, 0.655569f, 0.276967f, 
		0.655971f, 0.000000f, 0.655971f, 1.00000f, 
		0.656043f, 1.00000f, 0.656153f, 1.00000f, 
		0.656450f, 1.00018f, 0.659629f, 0.170186f, 
		0.659629f, 0.670186f, 0.659765f, 0.000000f, 
		0.659765f, 1.00000f, 0.661220f, 0.677561f, 
		0.662497f, 0.675481f, 0.663194f, 1.00000f, 
		0.663271f, 1.00000f, 0.663385f, 0.320447f, 
		0.663454f, 1.00000f, 0.663521f, 1.00000f, 
		0.664235f, 0.000000f, 0.664235f, 1.00000f, 
		0.665038f, 0.671950f, 0.665042f, 0.671965f, 
		0.665426f, 0.000000f, 0.665426f, 1.00000f, 
		0.665952f, 0.000000f, 0.665952f, 1.00000f, 
		0.666177f, 0.000000f, 0.666177f, 1.00000f, 
		0.666197f, 0.000000f, 0.666197f, 1.00000f, 
		0.666410f, 0.333590f, 0.666657f, 0.666686f, 
		0.666925f, 0.000000f, 0.666925f, 1.00000f, 
		0.667021f, 1.00000f, 0.667183f, 0.000000f, 
		0.667558f, 1.00000f, 0.668435f, 0.000000f, 
		0.668435f, 1.00000f, 0.669437f, 0.340234f, 
		0.670399f, 0.000000f, 0.670399f, 1.00000f, 
		0.670586f, 0.343960f, 0.671026f, 1.00000f, 
		0.671036f, 0.342072f, 0.671059f, 0.342119f, 
		0.671504f, 0.000000f, 0.672582f, 0.682934f, 
		0.675026f, 1.00000f, 0.675622f, 0.362482f, 
		0.675629f, 0.000000f, 0.676058f, 0.650811f, 
		0.676128f, 0.362768f, 0.676268f, 0.359071f, 
		0.676317f, 0.359053f, 0.676389f, 0.359121f, 
		0.677997f, 0.642346f, 0.678003f, 0.154285f, 
		0.678003f, 0.648640f, 0.680353f, 0.640759f, 
		0.681983f, 0.108800f, 0.682284f, 0.635431f, 
		0.684868f, 0.617993f, 0.686078f, 0.557701f, 
		0.686078f, 0.902143f, 0.688421f, 0.00190621f, 
		0.688967f, 0.461394f, 0.688967f, 0.869197f, 
		0.689642f, 0.619316f, 0.693638f, 0.612724f, 
		0.693794f, 0.392009f, 0.694817f, 0.381340f, 
		0.695511f, 0.386964f, 0.696714f, 0.599093f, 
		0.696788f, 0.395704f, 0.696994f, 0.395725f, 
		0.697099f, 0.395796f, 0.698915f, 0.602170f, 
		0.700568f, 0.401137f, 0.702265f, 0.375710f, 
		0.702898f, 0.406905f, 0.703107f, 0.622718f, 
		0.703130f, 0.622724f, 0.703183f, 0.622849f, 
		0.703189f, 0.622873f, 0.703197f, 0.596735f, 
		0.703205f, 0.622799f, 0.703210f, 0.622863f, 
		0.703295f, 0.622846f, 0.703336f, 0.851668f, 
		0.704356f, 0.589441f, 0.704364f, 0.421240f, 
		0.704459f, 0.591082f, 0.704750f, 0.590500f, 
		0.705682f, 0.423388f, 0.705880f, 0.411759f, 
		0.706128f, 0.406697f, 0.708092f, 0.583815f, 
		0.711385f, 0.577230f, 0.711516f, 0.423031f, 
		0.711577f, 0.423154f, 0.712380f, 0.462772f, 
		0.712747f, 0.579657f, 0.712826f, 0.425652f, 
		0.713201f, 0.422971f, 0.713223f, 0.423075f, 
		0.715459f, 0.567040f, 0.716245f, 0.843172f, 
		0.717598f, 0.429073f, 0.717759f, 0.429166f, 
		0.721300f, 0.557401f, 0.724920f, 0.417367f, 
		0.725398f, 0.447365f, 0.725465f, 0.447295f, 
		0.725478f, 0.447314f, 0.725581f, 0.447360f, 
		0.726026f, 0.444922f, 0.731535f, 0.551132f, 
		0.732220f, 0.532971f, 0.733036f, 0.533927f, 
		0.733247f, 0.531190f, 0.733365f, 0.531076f, 
		0.733456f, 0.478704f, 0.733630f, 0.478913f, 
		0.733670f, 0.530748f, 0.733833f, 0.530846f, 
		0.734002f, 0.000000f, 0.734079f, 0.526375f, 
		0.734755f, 0.461735f, 0.740087f, 0.477909f, 
		0.740248f, 0.480496f, 0.741490f, 0.514717f, 
		0.746627f, 0.507870f, 0.747490f, 0.505245f, 
		0.747536f, 0.505271f, 0.747568f, 0.505219f, 
		0.748850f, 0.504341f, 0.748854f, 0.504353f, 
		0.748878f, 0.504314f, 0.750000f, 0.500000f, 
		0.750921f, 0.00197200f, 0.752016f, 0.500607f, 
		0.752088f, 0.500481f, 0.752461f, 0.495077f, 
		0.752548f, 0.494904f, 0.752650f, 0.506515f, 
		0.754464f, 0.492962f, 0.754481f, 0.493100f, 
		0.754668f, 0.480100f, 0.754867f, 0.480180f, 
		0.754891f, 0.480128f, 0.756141f, 0.509138f, 
		0.756416f, 0.515089f, 0.756585f, 0.515205f, 
		0.757462f, 0.495615f, 0.759808f, 0.240192f, 
		0.760914f, 0.481358f, 0.761192f, 0.482153f, 
		0.762095f, 0.524726f, 0.763374f, 0.526748f, 
		0.763797f, 0.527594f, 0.767535f, 0.465498f, 
		0.768489f, 0.454005f, 0.769423f, 0.538609f, 
		0.770242f, 0.540484f, 0.774351f, 0.451810f, 
		0.775476f, 0.555036f, 0.776144f, 0.448917f, 
		0.776375f, 1.00030f, 0.780183f, 0.560365f, 
		0.780258f, 0.560516f, 0.780263f, 0.560526f, 
		0.780274f, 0.560549f, 0.780289f, 0.560579f, 
		0.780331f, 0.560663f, 0.782987f, 0.564487f, 
		0.783439f, 0.564522f, 0.783581f, 0.564509f, 
		0.786402f, 0.574139f, 0.787275f, 0.574486f, 
		0.787486f, 0.425028f, 0.788073f, 0.423854f, 
		0.788175f, 0.423649f, 0.790735f, 0.580336f, 
		0.792770f, 0.570427f, 0.792877f, 0.570408f, 
		0.792948f, 0.570511f, 0.793348f, 0.581287f, 
		0.794656f, 0.410558f, 0.795345f, 0.409761f, 
		0.796532f, 0.592921f, 0.796646f, 0.593030f, 
		0.797702f, 0.439770f, 0.801131f, 0.397737f, 
		0.801230f, 0.402092f, 0.802007f, 0.607734f, 
		0.802034f, 0.603864f, 0.804812f, 0.609623f, 
		0.805878f, 0.609195f, 0.806399f, 0.387202f, 
		0.806718f, 0.620228f, 0.806787f, 0.620173f, 
		0.807109f, 0.620346f, 0.807768f, 0.384463f, 
		0.810610f, 0.621219f, 0.810880f, 0.0945601f, 
		0.810880f, 0.594560f, 0.812883f, 1.00000f, 
		0.813421f, 0.00206099f, 0.816718f, 0.635069f, 
		0.817311f, 0.363678f, 0.817359f, 0.363654f, 
		0.821244f, 0.642488f, 0.821281f, 0.642561f, 
		0.824948f, 0.647545f, 0.831943f, 0.624418f, 
		0.831979f, 0.624515f, 0.832953f, 0.508520f, 
		0.833001f, 0.664117f, 0.836636f, 0.514961f, 
		0.836646f, 0.514879f, 0.836801f, 0.515076f, 
		0.836814f, 0.515017f, 0.837095f, 0.675026f, 
		0.837394f, 0.332817f, 0.846009f, 0.691110f, 
		0.852158f, 0.295684f, 0.855066f, 0.714992f, 
		0.856510f, 0.586232f, 0.856890f, 0.716245f, 
		0.857245f, 0.291033f, 0.868416f, 0.736832f, 
		0.870584f, 0.740500f, 0.870669f, 0.740286f, 
		0.870695f, 0.740485f, 0.875920f, 0.00216565f, 
		0.888424f, 0.211413f, 0.888436f, 0.211328f, 
		0.888485f, 0.211389f, 0.888494f, 0.211413f, 
		0.888494f, 0.211329f, 0.888509f, 0.211350f, 
		0.888518f, 0.211367f, 0.888519f, 0.211287f, 
		0.888531f, 0.211395f, 0.888535f, 0.211317f, 
		0.888535f, 0.211396f, 0.890455f, 0.781861f, 
		0.890492f, 0.781793f, 0.890496f, 0.781886f, 
		0.890504f, 0.781910f, 0.890505f, 0.781961f, 
		0.890516f, 0.781793f, 0.890534f, 0.781846f, 
		0.890546f, 0.781897f, 0.890550f, 0.781876f, 
		0.890557f, 0.781891f, 0.890563f, 0.781846f, 
		0.890564f, 0.782009f, 0.890568f, 0.781974f, 
		0.890836f, 0.672159f, 0.897729f, 0.795457f, 
		0.905998f, 1.00052f, 0.916364f, 0.756765f, 
		0.920846f, 0.157942f, 0.938420f, 0.00228610f, 
		0.942767f, 0.833603f, 1.00000f, 0.000000f, 
		1.00000f, 0.000000f, 1.00000f, 0.0852467f, 
		1.00000f, 0.0852665f, 1.00000f, 0.100324f, 
		1.00000f, 0.100339f, 1.00000f, 0.100356f, 
		1.00000f, 0.232612f, 1.00000f, 0.265998f, 
		1.00000f, 0.310190f, 1.00000f, 0.319773f, 
		1.00000f, 0.319810f, 1.00000f, 0.319828f, 
		1.00000f, 0.332985f, 1.00000f, 0.333632f, 
		1.00000f, 0.344554f, 1.00000f, 0.347976f, 
		1.00000f, 0.353225f, 1.00000f, 0.356027f, 
		1.00000f, 0.356056f, 1.00000f, 0.356520f, 
		1.00000f, 0.359011f, 1.00000f, 0.361786f, 
		1.00000f, 0.361843f, 1.00000f, 0.361867f, 
		1.00000f, 0.361939f, 1.00000f, 0.362398f, 
		1.00000f, 0.362494f, 1.00000f, 0.362795f, 
		1.00000f, 0.363163f, 1.00000f, 0.364908f, 
		1.00000f, 0.369631f, 1.00000f, 0.371034f, 
		1.00000f, 0.371522f, 1.00000f, 0.371694f, 
		1.00000f, 0.371825f, 1.00000f, 0.373939f, 
		1.00000f, 0.375855f, 1.00000f, 0.376356f, 
		1.00000f, 0.376805f, 1.00000f, 0.377129f, 
		1.00000f, 0.380822f, 1.00000f, 0.380910f, 
		1.00000f, 0.380951f, 1.00000f, 0.380984f, 
		1.00000f, 0.381017f, 1.00000f, 0.381032f, 
		1.00000f, 0.381068f, 1.00000f, 0.382163f, 
		1.00000f, 0.383689f, 1.00000f, 0.383761f, 
		1.00000f, 0.383781f, 1.00000f, 0.387117f, 
		1.00000f, 0.387148f, 1.00000f, 0.387179f, 
		1.00000f, 0.387230f, 1.00000f, 0.389171f, 
		1.00000f, 0.389226f, 1.00000f, 0.389291f, 
		1.00000f, 0.389321f, 1.00000f, 0.390396f, 
		1.00000f, 0.390487f, 1.00000f, 0.393979f, 
		1.00000f, 0.395036f, 1.00000f, 0.403924f, 
		1.00000f, 0.408252f, 1.00000f, 0.414373f, 
		1.00000f, 0.414474f, 1.00000f, 0.414486f, 
		1.00000f, 0.414502f, 1.00000f, 0.414796f, 
		1.00000f, 0.414827f, 1.00000f, 0.414855f, 
		1.00000f, 0.423027f, 1.00000f, 0.423038f, 
		1.00000f, 0.423084f, 1.00000f, 0.423875f, 
		1.00000f, 0.427479f, 1.00000f, 0.428322f, 
		1.00000f, 0.435813f, 1.00000f, 0.436010f, 
		1.00000f, 0.436035f, 1.00000f, 0.436048f, 
		1.00000f, 0.436080f, 1.00000f, 0.436106f, 
		1.00000f, 0.436164f, 1.00000f, 0.436179f, 
		1.00000f, 0.436198f, 1.00000f, 0.436256f, 
		1.00000f, 0.436360f, 1.00000f, 0.436446f, 
		1.00000f, 0.436488f, 1.00000f, 0.436581f, 
		1.00000f, 0.436640f, 1.00000f, 0.436662f, 
		1.00000f, 0.436679f, 1.00000f, 0.436710f, 
		1.00000f, 0.436754f, 1.00000f, 0.436789f, 
		1.00000f, 0.436814f, 1.00000f, 0.436825f, 
		1.00000f, 0.436858f, 1.00000f, 0.436913f, 
		1.00000f, 0.437029f, 1.00000f, 0.437652f, 
		1.00000f, 0.437747f, 1.00000f, 0.437872f, 
		1.00000f, 0.437887f, 1.00000f, 0.437897f, 
		1.00000f, 0.438855f, 1.00000f, 0.439028f, 
		1.00000f, 0.439112f, 1.00000f, 0.439602f, 
		1.00000f, 0.439637f, 1.00000f, 0.440664f, 
		1.00000f, 0.440862f, 1.00000f, 0.440889f, 
		1.00000f, 0.440909f, 1.00000f, 0.440926f, 
		1.00000f, 0.440941f, 1.00000f, 0.440953f, 
		1.00000f, 0.440970f, 1.00000f, 0.440980f, 
		1.00000f, 0.441001f, 1.00000f, 0.441013f, 
		1.00000f, 0.441027f, 1.00000f, 0.441040f, 
		1.00000f, 0.441058f, 1.00000f, 0.441086f, 
		1.00000f, 0.441112f, 1.00000f, 0.441133f, 
		1.00000f, 0.441172f, 1.00000f, 0.441205f, 
		1.00000f, 0.441215f, 1.00000f, 0.446489f, 
		1.00000f, 0.448989f, 1.00000f, 0.451160f, 
		1.00000f, 0.451443f, 1.00000f, 0.452335f, 
		1.00000f, 0.452912f, 1.00000f, 0.454841f, 
		1.00000f, 0.454937f, 1.00000f, 0.455005f, 
		1.00000f, 0.455031f, 1.00000f, 0.455059f, 
		1.00000f, 0.455072f, 1.00000f, 0.455680f, 
		1.00000f, 0.455716f, 1.00000f, 0.455740f, 
		1.00000f, 0.455981f, 1.00000f, 0.455991f, 
		1.00000f, 0.457080f, 1.00000f, 0.460545f, 
		1.00000f, 0.462254f, 1.00000f, 0.462279f, 
		1.00000f, 0.462323f, 1.00000f, 0.464074f, 
		1.00000f, 0.468768f, 1.00000f, 0.470274f, 
		1.00000f, 0.470453f, 1.00000f, 0.470555f, 
		1.00000f, 0.472472f, 1.00000f, 0.472625f, 
		1.00000f, 0.472905f, 1.00000f, 0.472933f, 
		1.00000f, 0.472998f, 1.00000f, 0.473025f, 
		1.00000f, 0.473051f, 1.00000f, 0.476896f, 
		1.00000f, 0.476917f, 1.00000f, 0.477060f, 
		1.00000f, 0.477302f, 1.00000f, 0.477378f, 
		1.00000f, 0.477407f, 1.00000f, 0.477651f, 
		1.00000f, 0.478562f, 1.00000f, 0.478579f, 
		1.00000f, 0.478614f, 1.00000f, 0.479150f, 
		1.00000f, 0.479245f, 1.00000f, 0.480841f, 
		1.00000f, 0.481802f, 1.00000f, 0.481842f, 
		1.00000f, 0.485065f, 1.00000f, 0.485225f, 
		1.00000f, 0.485281f, 1.00000f, 0.485349f, 
		1.00000f, 0.485361f, 1.00000f, 0.485373f, 
		1.00000f, 0.485427f, 1.00000f, 0.485451f, 
		1.00000f, 0.485487f, 1.00000f, 0.487072f, 
		1.00000f, 0.487264f, 1.00000f, 0.487486f, 
		1.00000f, 0.487513f, 1.00000f, 0.487534f, 
		1.00000f, 0.487546f, 1.00000f, 0.487564f, 
		1.00000f, 0.487586f, 1.00000f, 0.487603f, 
		1.00000f, 0.487614f, 1.00000f, 0.487626f, 
		1.00000f, 0.487641f, 1.00000f, 0.487730f, 
		1.00000f, 0.487742f, 1.00000f, 0.487775f, 
		1.00000f, 0.487844f, 1.00000f, 0.487863f, 
		1.00000f, 0.487988f, 1.00000f, 0.488041f, 
		1.00000f, 0.488141f, 1.00000f, 0.489702f, 
		1.00000f, 0.489868f, 1.00000f, 0.489981f, 
		1.00000f, 0.490139f, 1.00000f, 0.490413f, 
		1.00000f, 0.490433f, 1.00000f, 0.492165f, 
		1.00000f, 0.492183f, 1.00000f, 0.492196f, 
		1.00000f, 0.492218f, 1.00000f, 0.492229f, 
		1.00000f, 0.492249f, 1.00000f, 0.492260f, 
		1.00000f, 0.492272f, 1.00000f, 0.492286f, 
		1.00000f, 0.492298f, 1.00000f, 0.492749f, 
		1.00000f, 0.492775f, 1.00000f, 0.492787f, 
		1.00000f, 0.492801f, 1.00000f, 0.492811f, 
		1.00000f, 0.492823f, 1.00000f, 0.492834f, 
		1.00000f, 0.492851f, 1.00000f, 0.492866f, 
		1.00000f, 0.492879f, 1.00000f, 0.492913f, 
		1.00000f, 0.494694f, 1.00000f, 0.494713f, 
		1.00000f, 0.494791f, 1.00000f, 0.494873f, 
		1.00000f, 0.494922f, 1.00000f, 0.495072f, 
		1.00000f, 0.495134f, 1.00000f, 0.495178f, 
		1.00000f, 0.495572f, 1.00000f, 0.498133f, 
		1.00000f, 0.499291f, 1.00000f, 0.499313f, 
		1.00000f, 0.499332f, 1.00000f, 0.499361f, 
		1.00000f, 0.499372f, 1.00000f, 0.499386f, 
		1.00000f, 0.499397f, 1.00000f, 0.499412f, 
		1.00000f, 0.499422f, 1.00000f, 0.499444f, 
		1.00000f, 0.499466f, 1.00000f, 0.499480f, 
		1.00000f, 0.499506f, 1.00000f, 0.499522f, 
		1.00000f, 0.499560f, 1.00000f, 0.499594f, 
		1.00000f, 0.499606f, 1.00000f, 0.500000f, 
		1.00000f, 0.500107f, 1.00000f, 0.500166f, 
		1.00000f, 0.500184f, 1.00000f, 0.500200f, 
		1.00000f, 0.500599f, 1.00000f, 0.502041f, 
		1.00000f, 0.502065f, 1.00000f, 0.502105f, 
		1.00000f, 0.502118f, 1.00000f, 0.502129f, 
		1.00000f, 0.502139f, 1.00000f, 0.502151f, 
		1.00000f, 0.502167f, 1.00000f, 0.502179f, 
		1.00000f, 0.502191f, 1.00000f, 0.502221f, 
		1.00000f, 0.502238f, 1.00000f, 0.502260f, 
		1.00000f, 0.502343f, 1.00000f, 0.503160f, 
		1.00000f, 0.503171f, 1.00000f, 0.503182f, 
		1.00000f, 0.503209f, 1.00000f, 0.503231f, 
		1.00000f, 0.503241f, 1.00000f, 0.503251f, 
		1.00000f, 0.503264f, 1.00000f, 0.503276f, 
		1.00000f, 0.503287f, 1.00000f, 0.503302f, 
		1.00000f, 0.503313f, 1.00000f, 0.503325f, 
		1.00000f, 0.503343f, 1.00000f, 0.503356f, 
		1.00000f, 0.503367f, 1.00000f, 0.503385f, 
		1.00000f, 0.503398f, 1.00000f, 0.503412f, 
		1.00000f, 0.503429f, 1.00000f, 0.503439f, 
		1.00000f, 0.503470f, 1.00000f, 0.503484f, 
		1.00000f, 0.503543f, 1.00000f, 0.503715f, 
		1.00000f, 0.503739f, 1.00000f, 0.503754f, 
		1.00000f, 0.503766f, 1.00000f, 0.503778f, 
		1.00000f, 0.503789f, 1.00000f, 0.503799f, 
		1.00000f, 0.503811f, 1.00000f, 0.503833f, 
		1.00000f, 0.503845f, 1.00000f, 0.503862f, 
		1.00000f, 0.503874f, 1.00000f, 0.503890f, 
		1.00000f, 0.503903f, 1.00000f, 0.503915f, 
		1.00000f, 0.503926f, 1.00000f, 0.503940f, 
		1.00000f, 0.503953f, 1.00000f, 0.503963f, 
		1.00000f, 0.503975f, 1.00000f, 0.504021f, 
		1.00000f, 0.504039f, 1.00000f, 0.504050f, 
		1.00000f, 0.504064f, 1.00000f, 0.504077f, 
		1.00000f, 0.504094f, 1.00000f, 0.504108f, 
		1.00000f, 0.504132f, 1.00000f, 0.504145f, 
		1.00000f, 0.504158f, 1.00000f, 0.504170f, 
		1.00000f, 0.504182f, 1.00000f, 0.504194f, 
		1.00000f, 0.504205f, 1.00000f, 0.504215f, 
		1.00000f, 0.504229f, 1.00000f, 0.504258f, 
		1.00000f, 0.504270f, 1.00000f, 0.506253f, 
		1.00000f, 0.506685f, 1.00000f, 0.506806f, 
		1.00000f, 0.506823f, 1.00000f, 0.506835f, 
		1.00000f, 0.506871f, 1.00000f, 0.506906f, 
		1.00000f, 0.506961f, 1.00000f, 0.507319f, 
		1.00000f, 0.507330f, 1.00000f, 0.507366f, 
		1.00000f, 0.507381f, 1.00000f, 0.507417f, 
		1.00000f, 0.508021f, 1.00000f, 0.508058f, 
		1.00000f, 0.508126f, 1.00000f, 0.508144f, 
		1.00000f, 0.508236f, 1.00000f, 0.509960f, 
		1.00000f, 0.510717f, 1.00000f, 0.510903f, 
		1.00000f, 0.510958f, 1.00000f, 0.511017f, 
		1.00000f, 0.511032f, 1.00000f, 0.511082f, 
		1.00000f, 0.511363f, 1.00000f, 0.511483f, 
		1.00000f, 0.511499f, 1.00000f, 0.512884f, 
		1.00000f, 0.513787f, 1.00000f, 0.513836f, 
		1.00000f, 0.515432f, 1.00000f, 0.515547f, 
		1.00000f, 0.516117f, 1.00000f, 0.516287f, 
		1.00000f, 0.516509f, 1.00000f, 0.522257f, 
		1.00000f, 0.522272f, 1.00000f, 0.522327f, 
		1.00000f, 0.522357f, 1.00000f, 0.522440f, 
		1.00000f, 0.522464f, 1.00000f, 0.522512f, 
		1.00000f, 0.522570f, 1.00000f, 0.523542f, 
		1.00000f, 0.523607f, 1.00000f, 0.524356f, 
		1.00000f, 0.525893f, 1.00000f, 0.526420f, 
		1.00000f, 0.526801f, 1.00000f, 0.526919f, 
		1.00000f, 0.526944f, 1.00000f, 0.527326f, 
		1.00000f, 0.527345f, 1.00000f, 0.527370f, 
		1.00000f, 0.527385f, 1.00000f, 0.532748f, 
		1.00000f, 0.532896f, 1.00000f, 0.533068f, 
		1.00000f, 0.533130f, 1.00000f, 0.535519f, 
		1.00000f, 0.535541f, 1.00000f, 0.537470f, 
		1.00000f, 0.542145f, 1.00000f, 0.542175f, 
		1.00000f, 0.542295f, 1.00000f, 0.542419f, 
		1.00000f, 0.542585f, 1.00000f, 0.543715f, 
		1.00000f, 0.543790f, 1.00000f, 0.544338f, 
		1.00000f, 0.546206f, 1.00000f, 0.546288f, 
		1.00000f, 0.546396f, 1.00000f, 0.546410f, 
		1.00000f, 0.546531f, 1.00000f, 0.552139f, 
		1.00000f, 0.552151f, 1.00000f, 0.552179f, 
		1.00000f, 0.552195f, 1.00000f, 0.552282f, 
		1.00000f, 0.552303f, 1.00000f, 0.552353f, 
		1.00000f, 0.552379f, 1.00000f, 0.552404f, 
		1.00000f, 0.552416f, 1.00000f, 0.552435f, 
		1.00000f, 0.552477f, 1.00000f, 0.552509f, 
		1.00000f, 0.552525f, 1.00000f, 0.552559f, 
		1.00000f, 0.552576f, 1.00000f, 0.552642f, 
		1.00000f, 0.552688f, 1.00000f, 0.552718f, 
		1.00000f, 0.552753f, 1.00000f, 0.552838f, 
		1.00000f, 0.552862f, 1.00000f, 0.552948f, 
		1.00000f, 0.553023f, 1.00000f, 0.553085f, 
		1.00000f, 0.553098f, 1.00000f, 0.553127f, 
		1.00000f, 0.556496f, 1.00000f, 0.556528f, 
		1.00000f, 0.556540f, 1.00000f, 0.556570f, 
		1.00000f, 0.556581f, 1.00000f, 0.556617f, 
		1.00000f, 0.560156f, 1.00000f, 0.560191f, 
		1.00000f, 0.561066f, 1.00000f, 0.561100f, 
		1.00000f, 0.561960f, 1.00000f, 0.563892f, 
		1.00000f, 0.564036f, 1.00000f, 0.564134f, 
		1.00000f, 0.570511f, 1.00000f, 0.570891f, 
		1.00000f, 0.572439f, 1.00000f, 0.572581f, 
		1.00000f, 0.572714f, 1.00000f, 0.572816f, 
		1.00000f, 0.572867f, 1.00000f, 0.572879f, 
		1.00000f, 0.572936f, 1.00000f, 0.572947f, 
		1.00000f, 0.573034f, 1.00000f, 0.573049f, 
		1.00000f, 0.573065f, 1.00000f, 0.573724f, 
		1.00000f, 0.573799f, 1.00000f, 0.573812f, 
		1.00000f, 0.573830f, 1.00000f, 0.574440f, 
		1.00000f, 0.574465f, 1.00000f, 0.574489f, 
		1.00000f, 0.574516f, 1.00000f, 0.574531f, 
		1.00000f, 0.574566f, 1.00000f, 0.574584f, 
		1.00000f, 0.575259f, 1.00000f, 0.575289f, 
		1.00000f, 0.575536f, 1.00000f, 0.575615f, 
		1.00000f, 0.575670f, 1.00000f, 0.579274f, 
		1.00000f, 0.579457f, 1.00000f, 0.581929f, 
		1.00000f, 0.582489f, 1.00000f, 0.582525f, 
		1.00000f, 0.584252f, 1.00000f, 0.586460f, 
		1.00000f, 0.586576f, 1.00000f, 0.586613f, 
		1.00000f, 0.586625f, 1.00000f, 0.586637f, 
		1.00000f, 0.586665f, 1.00000f, 0.586691f, 
		1.00000f, 0.586716f, 1.00000f, 0.586727f, 
		1.00000f, 0.586806f, 1.00000f, 0.587908f, 
		1.00000f, 0.587946f, 1.00000f, 0.589886f, 
		1.00000f, 0.589955f, 1.00000f, 0.589995f, 
		1.00000f, 0.591843f, 1.00000f, 0.592135f, 
		1.00000f, 0.592181f, 1.00000f, 0.593005f, 
		1.00000f, 0.593208f, 1.00000f, 0.593292f, 
		1.00000f, 0.595004f, 1.00000f, 0.595143f, 
		1.00000f, 0.595592f, 1.00000f, 0.596131f, 
		1.00000f, 0.599991f, 1.00000f, 0.603030f, 
		1.00000f, 0.603881f, 1.00000f, 0.603907f, 
		1.00000f, 0.603928f, 1.00000f, 0.604199f, 
		1.00000f, 0.606304f, 1.00000f, 0.606389f, 
		1.00000f, 0.606988f, 1.00000f, 0.607936f, 
		1.00000f, 0.610381f, 1.00000f, 0.611923f, 
		1.00000f, 0.615112f, 1.00000f, 0.615954f, 
		1.00000f, 0.615972f, 1.00000f, 0.615991f, 
		1.00000f, 0.616013f, 1.00000f, 0.616077f, 
		1.00000f, 0.616109f, 1.00000f, 0.617324f, 
		1.00000f, 0.619586f, 1.00000f, 0.623353f, 
		1.00000f, 0.624125f, 1.00000f, 0.624501f, 
		1.00000f, 0.624558f, 1.00000f, 0.624593f, 
		1.00000f, 0.624604f, 1.00000f, 0.624617f, 
		1.00000f, 0.625228f, 1.00000f, 0.630573f, 
		1.00000f, 0.635434f, 1.00000f, 0.638857f, 
		1.00000f, 0.643490f, 1.00000f, 0.649220f, 
		1.00000f, 0.651175f, 1.00000f, 0.653119f, 
		1.00000f, 0.658412f, 1.00000f, 0.658459f, 
		1.00000f, 0.658511f, 1.00000f, 0.658524f, 
		1.00000f, 0.658548f, 1.00000f, 0.658586f, 
		1.00000f, 0.658602f, 1.00000f, 0.658644f, 
		1.00000f, 0.661289f, 1.00000f, 0.662906f, 
		1.00000f, 0.662917f, 1.00000f, 0.662933f, 
		1.00000f, 0.662948f, 1.00000f, 0.663016f, 
		1.00000f, 0.665749f, 1.00000f, 0.667981f, 
		1.00000f, 0.671887f, 1.00000f, 0.671914f, 
		1.00000f, 0.672609f, 1.00000f, 0.672678f, 
		1.00000f, 0.677168f, 1.00000f, 0.680867f, 
		1.00000f, 0.680911f, 1.00000f, 0.688275f, 
		1.00000f, 0.693780f, 1.00000f, 0.693950f, 
		1.00000f, 0.694163f, 1.00000f, 0.703336f, 
		1.00000f, 0.724239f, 1.00000f, 0.725672f, 
		1.00000f, 0.763179f, 1.00000f, 0.773040f, 
		1.00000f, 0.773392f, 1.00000f, 0.773421f, 
		1.00000f, 0.773449f, 1.00000f, 0.773464f, 
		1.00000f, 0.773489f, 1.00000f, 0.783396f, 
		1.00000f, 1.00000f, 1.00000f, 1.00000f, 
		1.00006f, 0.935416f, 1.00041f, 0.563007f, 
		1.00066f, 0.290359f, 1.00092f, 0.00242500f, 
		1.11110f, 1.11110f
	};
	static const GLint Indices[] = {
		473, 490, 446, 446, 490, 458, 458, 490, 487, 487, 491, 453, 338, 457, 468, 338, 
		468, 472, 491, 492, 440, 473, 498, 490, 490, 498, 495, 490, 495, 487, 487, 495, 
		496, 487, 496, 497, 487, 497, 491, 491, 497, 492, 338, 472, 474, 338, 474, 470, 
		498, 482, 495, 498, 452, 482, 495, 482, 496, 338, 470, 463, 338, 463, 449, 492, 
		421, 440, 497, 444, 421, 497, 421, 492, 496, 447, 444, 496, 444, 497, 496, 442, 
		447, 482, 442, 496, 498, 435, 452, 452, 442, 482, 338, 449, 433, 338, 433, 407, 
		452, 386, 442, 435, 345, 452, 452, 345, 386, 442, 386, 344, 442, 344, 447, 447, 
		344, 369, 447, 369, 444, 338, 407, 385, 338, 385, 363, 421, 324, 440, 444, 369, 
		324, 444, 324, 421, 435, 310, 345, 345, 322, 386, 386, 322, 344, 338, 363, 337, 
		338, 337, 312, 369, 282, 324, 344, 282, 369, 322, 265, 344, 310, 264, 345, 345, 
		264, 322, 322, 264, 265, 344, 265, 282, 338, 312, 294, 338, 294, 271, 324, 239, 
		440, 282, 239, 324, 310, 206, 264, 264, 237, 265, 265, 204, 282, 282, 204, 239, 
		338, 271, 252, 338, 252, 244, 265, 203, 204, 237, 203, 265, 264, 206, 237, 206, 
		197, 237, 237, 197, 192, 237, 192, 203, 338, 244, 228, 338, 228, 221, 239, 198, 
		440, 204, 198, 239, 203, 192, 204, 206, 189, 197, 189, 193, 197, 197, 193, 192, 
		192, 191, 204, 204, 191, 198, 338, 221, 220, 338, 220, 225, 192, 200, 191, 193, 
		200, 192, 189, 208, 193, 189, 205, 208, 193, 208, 200, 200, 241, 191, 338, 225, 
		232, 338, 232, 248, 191, 241, 198, 200, 246, 241, 208, 246, 200, 208, 255, 250, 
		205, 255, 208, 208, 250, 246, 338, 248, 256, 338, 256, 278, 198, 307, 440, 241, 
		307, 198, 246, 281, 241, 250, 281, 246, 255, 299, 250, 255, 315, 299, 250, 299, 
		281, 281, 314, 241, 241, 314, 307, 338, 278, 301, 338, 301, 320, 281, 334, 314, 
		299, 334, 281, 315, 347, 299, 255, 364, 315, 299, 347, 334, 338, 320, 341, 338, 
		341, 373, 314, 388, 440, 314, 440, 307, 334, 415, 388, 334, 388, 314, 334, 405, 
		415, 347, 405, 334, 364, 347, 315, 364, 446, 347, 347, 446, 405, 338, 373, 395, 
		338, 395, 413, 388, 453, 440, 415, 453, 388, 364, 473, 446, 446, 458, 405, 405, 
		458, 415, 338, 413, 439, 439, 457, 338, 453, 491, 440, 415, 487, 453, 458, 487, 
		415, 735, 739, 755, 735, 755, 756, 756, 755, 757, 756, 757, 758, 747, 754, 752, 
		747, 752, 748, 758, 757, 752, 758, 752, 754, 748, 752, 749, 755, 751, 757, 731, 
		736, 735, 739, 735, 736, 739, 751, 755, 739, 736, 745, 739, 745, 751, 751, 745, 
		743, 751, 743, 757, 749, 752, 744, 749, 744, 737, 757, 743, 744, 757, 744, 752, 
		730, 749, 737, 743, 734, 744, 744, 732, 737, 744, 734, 732, 745, 738, 743, 736, 
		731, 738, 736, 738, 745, 731, 728, 738, 738, 728, 724, 738, 724, 743, 732, 727, 
		737, 743, 724, 734, 730, 737, 726, 724, 714, 734, 732, 714, 727, 732, 734, 714, 
		727, 726, 737, 728, 721, 724, 731, 717, 721, 731, 721, 728, 717, 710, 721, 717, 
		731, 709, 721, 710, 711, 721, 711, 724, 727, 714, 726, 724, 711, 714, 730, 726, 
		707, 711, 639, 685, 711, 685, 714, 726, 714, 685, 710, 679, 639, 710, 639, 711, 
		717, 709, 679, 717, 679, 710, 709, 661, 615, 709, 615, 679, 679, 615, 639, 726, 
		685, 707, 685, 585, 595, 685, 595, 707, 639, 585, 685, 639, 527, 585, 595, 577, 
		707, 615, 557, 527, 615, 527, 639, 731, 600, 709, 661, 709, 600, 661, 557, 615, 
		661, 600, 503, 661, 503, 557, 557, 503, 527, 577, 603, 707, 595, 585, 524, 595, 
		524, 577, 527, 524, 585, 730, 707, 603, 730, 603, 556, 527, 390, 438, 527, 438, 
		524, 524, 438, 556, 524, 556, 577, 577, 556, 603, 503, 443, 390, 503, 390, 527, 
		600, 542, 443, 600, 443, 503, 542, 396, 443, 542, 600, 501, 731, 501, 600, 443, 
		396, 390, 556, 438, 523, 730, 556, 523, 390, 336, 370, 390, 370, 438, 438, 384, 
		523, 438, 370, 384, 396, 371, 336, 396, 336, 390, 542, 501, 371, 542, 371, 396, 
		501, 460, 346, 501, 346, 371, 731, 460, 501, 371, 346, 336, 523, 381, 379, 384, 
		381, 523, 730, 523, 379, 336, 340, 374, 336, 374, 370, 384, 374, 381, 384, 370, 
		374, 346, 350, 340, 346, 340, 336, 460, 350, 346, 460, 459, 375, 460, 375, 350, 
		731, 459, 460, 350, 375, 340, 381, 374, 379, 730, 379, 454, 340, 410, 409, 340, 
		409, 374, 379, 374, 409, 379, 409, 454, 375, 403, 410, 375, 410, 340, 459, 403, 
		375, 459, 521, 455, 459, 455, 403, 731, 521, 459, 403, 455, 410, 409, 489, 507, 
		409, 507, 454, 410, 489, 409, 730, 454, 534, 410, 505, 489, 507, 533, 454, 454, 
		533, 534, 455, 526, 505, 455, 505, 410, 521, 526, 455, 521, 578, 573, 521, 573, 
		526, 731, 578, 521, 526, 573, 599, 526, 599, 505, 507, 489, 596, 507, 596, 533, 
		505, 599, 596, 505, 596, 489, 533, 596, 534, 573, 628, 599, 578, 628, 573, 578, 
		665, 701, 578, 701, 628, 628, 701, 705, 628, 705, 599, 534, 596, 690, 534, 690, 
		640, 599, 705, 690, 599, 690, 596, 730, 534, 640, 730, 640, 713, 705, 719, 716, 
		705, 716, 690, 690, 715, 640, 690, 716, 715, 701, 712, 719, 701, 719, 705, 731, 
		708, 578, 665, 578, 708, 665, 712, 701, 665, 708, 722, 665, 722, 712, 712, 722, 
		719, 640, 718, 713, 715, 718, 640, 719, 740, 729, 719, 729, 716, 715, 729, 718, 
		715, 716, 729, 722, 733, 740, 722, 740, 719, 708, 720, 733, 708, 733, 722, 720, 
		741, 733, 720, 708, 725, 731, 725, 708, 733, 741, 740, 718, 723, 713, 729, 742, 
		723, 729, 723, 718, 740, 742, 729, 730, 713, 723, 740, 750, 742, 723, 742, 730, 
		741, 746, 750, 741, 750, 740, 720, 725, 746, 720, 746, 741, 725, 735, 753, 725, 
		753, 746, 731, 735, 725, 746, 753, 758, 746, 758, 750, 742, 754, 747, 742, 747, 
		730, 750, 758, 754, 750, 754, 742, 747, 748, 730, 730, 748, 749, 753, 756, 758, 
		735, 756, 753, 646, 672, 645, 645, 672, 671, 645, 671, 644, 644, 671, 643, 672, 
		692, 703, 672, 703, 671, 692, 698, 703, 703, 684, 678, 698, 684, 703, 684, 664, 
		678, 664, 614, 678, 664, 630, 614, 630, 589, 614, 589, 531, 614, 589, 546, 531, 
		546, 476, 531, 476, 398, 368, 476, 368, 531, 398, 329, 368, 329, 234, 368, 329, 
		262, 234, 262, 186, 234, 186, 149, 128, 186, 128, 234, 149, 109, 128, 109, 72, 
		73, 109, 73, 128, 109, 71, 72, 109, 70, 71, 626, 682, 568, 568, 682, 627, 
		627, 682, 691, 627, 691, 663, 663, 676, 650, 650, 676, 675, 650, 675, 649, 649, 
		675, 674, 649, 674, 648, 648, 674, 673, 648, 673, 647, 647, 673, 672, 647, 672, 
		646, 643, 671, 683, 643, 683, 625, 625, 683, 677, 625, 677, 619, 619, 677, 618, 
		618, 621, 580, 457, 461, 471, 457, 471, 468, 520, 529, 594, 529, 576, 594, 576, 
		620, 594, 576, 597, 642, 576, 642, 620, 597, 617, 642, 617, 616, 641, 617, 641, 
		642, 530, 434, 555, 574, 530, 555, 641, 574, 624, 641, 660, 657, 642, 641, 657, 
		642, 657, 658, 642, 658, 654, 620, 642, 654, 520, 594, 551, 461, 520, 551, 461, 
		551, 486, 471, 461, 486, 471, 486, 484, 468, 471, 484, 468, 484, 472, 506, 498, 
		473, 537, 544, 506, 537, 580, 544, 618, 662, 621, 677, 662, 618, 671, 703, 683, 
		673, 693, 692, 673, 692, 672, 674, 694, 693, 674, 693, 673, 675, 695, 694, 675, 
		694, 674, 676, 696, 695, 676, 695, 675, 663, 691, 696, 663, 696, 676, 378, 504, 
		462, 462, 504, 543, 543, 504, 575, 543, 575, 626, 626, 622, 682, 682, 706, 691, 
		691, 706, 704, 691, 704, 696, 696, 704, 702, 696, 702, 695, 695, 702, 700, 695, 
		700, 694, 694, 700, 699, 694, 699, 693, 693, 699, 698, 693, 698, 692, 703, 697, 
		683, 683, 697, 680, 683, 680, 677, 677, 680, 662, 662, 629, 621, 621, 629, 581, 
		621, 581, 580, 580, 581, 544, 472, 484, 486, 472, 486, 474, 594, 620, 613, 620, 
		654, 613, 654, 658, 659, 658, 657, 660, 658, 660, 659, 641, 624, 660, 574, 555, 
		624, 660, 636, 655, 659, 660, 655, 659, 655, 656, 654, 659, 656, 654, 656, 638, 
		613, 654, 638, 551, 594, 613, 474, 486, 481, 474, 481, 470, 506, 499, 498, 544, 
		499, 506, 662, 651, 629, 680, 651, 662, 697, 670, 680, 703, 678, 697, 699, 686, 
		684, 699, 684, 698, 700, 687, 686, 700, 686, 699, 702, 688, 687, 702, 687, 700, 
		704, 689, 688, 704, 688, 702, 706, 681, 689, 706, 689, 704, 682, 681, 706, 575, 
		622, 626, 378, 389, 504, 682, 623, 681, 681, 653, 669, 681, 669, 689, 689, 669, 
		668, 689, 668, 688, 688, 668, 667, 688, 667, 687, 687, 667, 666, 687, 666, 686, 
		686, 666, 664, 686, 664, 684, 678, 652, 697, 697, 652, 670, 670, 637, 680, 680, 
		637, 651, 651, 598, 629, 629, 598, 545, 629, 545, 581, 581, 545, 544, 470, 481, 
		469, 470, 469, 463, 481, 486, 469, 486, 551, 539, 486, 539, 469, 551, 613, 539, 
		613, 587, 539, 613, 638, 587, 638, 656, 635, 656, 655, 636, 656, 636, 635, 660, 
		624, 571, 624, 555, 540, 555, 434, 404, 434, 339, 404, 555, 404, 502, 540, 555, 
		502, 636, 660, 571, 636, 571, 602, 635, 636, 602, 635, 602, 601, 638, 635, 601, 
		638, 601, 569, 587, 638, 569, 463, 469, 456, 463, 456, 449, 499, 435, 498, 544, 
		545, 499, 651, 588, 598, 637, 588, 651, 652, 637, 670, 678, 614, 652, 666, 631, 
		630, 666, 630, 664, 667, 632, 631, 667, 631, 666, 668, 633, 632, 668, 632, 667, 
		669, 634, 633, 669, 633, 668, 653, 634, 669, 681, 586, 653, 681, 623, 586, 622, 
		623, 682, 575, 522, 622, 504, 522, 575, 504, 389, 417, 504, 417, 522, 522, 483, 
		622, 622, 483, 466, 622, 466, 623, 653, 586, 593, 653, 593, 634, 634, 593, 592, 
		634, 592, 633, 633, 592, 591, 633, 591, 632, 632, 591, 590, 632, 590, 631, 631, 
		590, 589, 631, 589, 630, 614, 570, 652, 652, 570, 567, 652, 567, 637, 637, 567, 
		588, 588, 538, 598, 598, 538, 545, 545, 436, 499, 499, 436, 435, 449, 456, 437, 
		449, 437, 433, 456, 469, 412, 456, 412, 437, 469, 539, 412, 539, 587, 569, 539, 
		569, 508, 569, 601, 572, 601, 602, 571, 601, 571, 572, 571, 624, 540, 571, 540, 
		535, 572, 571, 535, 572, 535, 536, 569, 572, 488, 569, 488, 508, 539, 508, 406, 
		412, 539, 406, 433, 437, 412, 433, 412, 407, 545, 450, 436, 538, 450, 545, 588, 
		485, 538, 567, 485, 588, 614, 531, 570, 590, 547, 546, 590, 546, 589, 591, 548, 
		547, 591, 547, 590, 592, 549, 548, 592, 548, 591, 593, 550, 549, 593, 549, 592, 
		586, 525, 550, 586, 550, 593, 623, 466, 586, 522, 417, 483, 586, 466, 411, 586, 
		411, 525, 525, 480, 550, 550, 480, 479, 550, 479, 549, 549, 479, 478, 549, 478, 
		548, 548, 478, 477, 548, 477, 547, 547, 477, 476, 547, 476, 546, 531, 475, 570, 
		570, 475, 451, 570, 451, 567, 567, 451, 485, 538, 485, 450, 407, 412, 387, 407, 
		387, 385, 508, 488, 406, 488, 572, 464, 488, 464, 420, 572, 536, 464, 536, 535, 
		465, 536, 465, 464, 535, 392, 465, 540, 502, 372, 502, 404, 372, 404, 339, 298, 
		540, 372, 266, 535, 540, 266, 464, 465, 392, 464, 392, 391, 420, 464, 391, 488, 
		420, 361, 406, 488, 361, 412, 406, 313, 412, 313, 365, 387, 412, 365, 385, 387, 
		365, 385, 365, 363, 435, 321, 310, 436, 321, 435, 436, 360, 321, 450, 360, 436, 
		485, 362, 360, 485, 360, 450, 485, 318, 362, 451, 318, 485, 475, 367, 366, 475, 
		366, 451, 531, 368, 367, 531, 367, 475, 477, 399, 398, 477, 398, 476, 478, 400, 
		399, 478, 399, 477, 479, 401, 400, 479, 400, 478, 480, 402, 401, 480, 401, 479, 
		525, 411, 402, 525, 402, 480, 417, 333, 483, 389, 309, 417, 378, 303, 389, 389, 
		303, 309, 417, 309, 333, 333, 275, 483, 483, 275, 238, 483, 238, 466, 466, 238, 
		251, 466, 251, 330, 466, 330, 411, 411, 330, 325, 411, 325, 402, 402, 325, 326, 
		402, 326, 401, 401, 326, 327, 401, 327, 400, 400, 327, 328, 400, 328, 399, 399, 
		328, 329, 399, 329, 398, 366, 280, 451, 451, 280, 318, 363, 365, 335, 363, 335, 
		337, 406, 361, 272, 361, 420, 302, 420, 391, 302, 391, 392, 332, 391, 332, 331, 
		392, 535, 332, 535, 266, 332, 372, 404, 298, 266, 372, 214, 332, 266, 168, 332, 
		195, 268, 331, 332, 268, 331, 268, 269, 391, 331, 269, 302, 391, 269, 361, 302, 
		247, 272, 361, 247, 406, 272, 313, 365, 313, 311, 335, 365, 311, 337, 335, 311, 
		337, 311, 312, 360, 253, 321, 360, 263, 253, 362, 263, 360, 362, 318, 263, 367, 
		258, 280, 367, 280, 366, 368, 234, 258, 368, 258, 367, 328, 261, 262, 328, 262, 
		329, 327, 260, 261, 327, 261, 328, 326, 259, 260, 326, 260, 327, 325, 257, 259, 
		325, 259, 326, 330, 257, 325, 330, 190, 257, 330, 251, 190, 309, 245, 333, 333, 
		245, 275, 257, 190, 182, 257, 182, 183, 257, 183, 259, 259, 183, 184, 259, 184, 
		260, 260, 184, 185, 260, 185, 261, 261, 185, 186, 261, 186, 262, 234, 169, 258, 
		258, 169, 188, 258, 188, 280, 280, 188, 176, 280, 176, 318, 318, 176, 263, 321, 
		240, 310, 312, 311, 293, 312, 293, 294, 311, 313, 194, 302, 269, 247, 269, 268, 
		195, 269, 195, 196, 195, 332, 168, 372, 298, 214, 195, 168, 129, 195, 129, 155, 
		196, 195, 155, 196, 155, 156, 269, 196, 156, 247, 269, 156, 247, 156, 162, 272, 
		247, 162, 272, 162, 194, 313, 272, 194, 311, 194, 249, 293, 311, 249, 293, 249, 
		267, 294, 293, 267, 294, 267, 271, 321, 253, 240, 263, 174, 253, 176, 174, 263, 
		188, 138, 176, 169, 138, 188, 234, 128, 169, 185, 148, 149, 185, 149, 186, 184, 
		147, 148, 184, 148, 185, 183, 146, 147, 183, 147, 184, 182, 144, 146, 182, 146, 
		183, 190, 145, 144, 190, 144, 182, 251, 145, 190, 251, 104, 145, 238, 104, 251, 
		275, 134, 238, 245, 134, 275, 309, 303, 187, 309, 187, 245, 245, 187, 134, 134, 
		74, 238, 238, 74, 104, 145, 104, 77, 145, 77, 105, 145, 105, 144, 144, 105, 
		106, 144, 106, 146, 146, 106, 107, 146, 107, 147, 147, 107, 108, 147, 108, 148, 
		148, 108, 109, 148, 109, 149, 128, 96, 169, 169, 96, 98, 169, 98, 138, 138, 
		116, 176, 176, 116, 174, 240, 206, 310, 271, 267, 249, 271, 249, 252, 162, 156, 
		123, 156, 130, 123, 156, 155, 129, 156, 129, 130, 214, 298, 226, 266, 214, 78, 
		168, 266, 78, 129, 168, 76, 129, 76, 99, 130, 129, 99, 130, 99, 100, 194, 
		162, 123, 194, 123, 136, 194, 136, 154, 249, 194, 154, 252, 249, 235, 252, 235, 
		244, 253, 180, 240, 174, 153, 180, 174, 180, 253, 135, 153, 174, 116, 135, 174, 
		138, 65, 116, 98, 65, 138, 128, 73, 96, 108, 69, 70, 108, 70, 109, 107, 
		68, 69, 107, 69, 108, 106, 67, 68, 106, 68, 107, 105, 66, 67, 105, 67, 
		106, 105, 77, 66, 187, 150, 134, 74, 33, 104, 104, 33, 77, 77, 33, 23, 
		77, 23, 36, 77, 36, 66, 66, 36, 37, 66, 37, 67, 67, 37, 38, 67, 
		38, 68, 68, 38, 39, 68, 39, 69, 69, 39, 40, 69, 40, 70, 70, 40, 
		41, 70, 41, 71, 71, 41, 42, 71, 42, 72, 72, 42, 43, 72, 43, 73, 
		73, 43, 44, 73, 44, 31, 73, 31, 96, 96, 31, 34, 96, 34, 98, 98, 
		34, 65, 65, 61, 116, 116, 61, 135, 135, 101, 153, 244, 235, 224, 244, 224, 
		228, 235, 249, 201, 235, 201, 224, 249, 154, 201, 123, 83, 136, 123, 130, 75, 
		123, 75, 83, 130, 100, 75, 100, 99, 76, 100, 76, 75, 76, 168, 78, 78, 
		214, 133, 214, 226, 133, 298, 339, 226, 76, 57, 59, 75, 76, 59, 75, 59, 
		60, 136, 83, 113, 154, 136, 113, 228, 224, 201, 228, 201, 221, 240, 189, 206, 
		180, 189, 240, 61, 101, 135, 34, 61, 65, 44, 20, 31, 43, 19, 20, 43, 
		20, 44, 42, 18, 19, 42, 19, 43, 41, 17, 18, 41, 18, 42, 40, 16, 
		17, 40, 17, 41, 39, 15, 16, 39, 16, 40, 38, 14, 15, 38, 15, 39, 
		37, 13, 14, 37, 14, 38, 36, 12, 13, 36, 13, 37, 23, 12, 36, 134, 
		95, 74, 150, 95, 134, 303, 181, 187, 187, 181, 150, 150, 142, 95, 74, 46, 
		33, 33, 46, 11, 33, 11, 10, 33, 10, 23, 23, 10, 0, 23, 0, 12, 
		12, 0, 1, 12, 1, 13, 13, 1, 2, 13, 2, 14, 14, 2, 3, 14, 
		3, 15, 15, 3, 4, 15, 4, 16, 16, 4, 5, 16, 5, 17, 17, 5, 
		6, 17, 6, 18, 18, 6, 8, 18, 8, 19, 19, 8, 9, 19, 9, 20, 
		20, 9, 7, 20, 7, 31, 31, 7, 32, 31, 32, 34, 34, 32, 61, 61, 
		32, 64, 61, 64, 93, 61, 93, 101, 101, 93, 132, 101, 132, 153, 221, 201, 
		202, 221, 202, 220, 201, 154, 151, 154, 113, 151, 113, 83, 79, 83, 75, 58, 
		83, 58, 79, 75, 60, 58, 60, 59, 57, 60, 57, 58, 57, 76, 78, 78, 
		133, 102, 133, 226, 173, 78, 102, 63, 57, 78, 63, 58, 57, 63, 58, 63, 
		62, 79, 58, 97, 113, 79, 97, 113, 97, 117, 151, 113, 117, 201, 151, 207, 
		202, 201, 207, 220, 202, 207, 220, 207, 225, 180, 205, 189, 180, 175, 205, 153, 
		175, 180, 132, 175, 153, 7, 35, 45, 7, 45, 32, 9, 30, 35, 9, 35, 
		7, 8, 29, 30, 8, 30, 9, 6, 28, 29, 6, 29, 8, 5, 27, 28, 
		5, 28, 6, 4, 26, 27, 4, 27, 5, 3, 25, 26, 3, 26, 4, 2, 
		24, 25, 2, 25, 3, 1, 22, 24, 1, 24, 2, 0, 21, 22, 0, 22, 
		1, 10, 21, 0, 74, 110, 46, 95, 110, 74, 142, 110, 95, 150, 181, 142, 
		303, 273, 181, 110, 114, 46, 46, 47, 11, 11, 47, 10, 10, 47, 48, 10, 
		48, 21, 21, 48, 49, 21, 49, 22, 22, 49, 50, 22, 50, 24, 24, 50, 
		51, 24, 51, 25, 25, 51, 52, 25, 52, 26, 26, 52, 53, 26, 53, 27, 
		27, 53, 54, 27, 54, 28, 28, 54, 55, 28, 55, 29, 29, 55, 56, 29, 
		56, 30, 30, 56, 35, 45, 80, 32, 32, 80, 64, 93, 64, 137, 93, 137, 
		132, 132, 137, 175, 225, 207, 227, 225, 227, 232, 207, 151, 179, 151, 117, 179, 
		97, 58, 82, 58, 62, 82, 62, 63, 81, 62, 81, 82, 63, 111, 81, 133, 
		178, 102, 133, 173, 178, 173, 226, 277, 226, 339, 277, 63, 102, 141, 111, 63, 
		141, 82, 81, 111, 82, 111, 112, 97, 82, 139, 117, 97, 139, 179, 117, 139, 
		207, 179, 242, 227, 207, 242, 232, 227, 242, 232, 242, 248, 175, 243, 205, 64, 
		131, 137, 80, 131, 64, 45, 103, 80, 35, 92, 103, 35, 103, 45, 56, 94, 
		92, 56, 92, 35, 55, 91, 94, 55, 94, 56, 54, 90, 91, 54, 91, 55, 
		53, 89, 90, 53, 90, 54, 52, 88, 89, 52, 89, 53, 51, 87, 88, 51, 
		88, 52, 50, 86, 87, 50, 87, 51, 49, 85, 86, 49, 86, 50, 48, 84, 
		85, 48, 85, 49, 47, 84, 48, 47, 115, 84, 47, 114, 115, 46, 114, 47, 
		273, 236, 181, 303, 378, 273, 181, 236, 142, 142, 236, 110, 84, 115, 118, 84, 
		118, 119, 84, 119, 85, 85, 119, 120, 85, 120, 86, 86, 120, 121, 86, 121, 
		87, 87, 121, 122, 87, 122, 88, 88, 122, 124, 88, 124, 89, 89, 124, 125, 
		89, 125, 90, 90, 125, 126, 90, 126, 91, 91, 126, 127, 91, 127, 94, 94, 
		127, 143, 94, 143, 92, 92, 143, 103, 103, 152, 80, 80, 152, 131, 131, 177, 
		137, 137, 177, 243, 137, 243, 175, 243, 255, 205, 248, 242, 254, 248, 254, 256, 
		139, 82, 140, 139, 140, 170, 82, 112, 140, 112, 111, 141, 112, 141, 140, 141, 
		102, 233, 178, 173, 306, 173, 277, 306, 233, 102, 178, 141, 233, 171, 140, 141, 
		171, 140, 171, 172, 139, 170, 229, 179, 139, 229, 242, 179, 300, 254, 242, 300, 
		254, 300, 276, 256, 254, 276, 256, 276, 278, 131, 223, 177, 152, 223, 131, 143, 
		152, 103, 127, 167, 143, 126, 166, 167, 126, 167, 127, 125, 165, 166, 125, 166, 
		126, 124, 164, 165, 124, 165, 125, 122, 163, 164, 122, 164, 124, 121, 161, 163, 
		121, 163, 122, 120, 160, 161, 120, 161, 121, 119, 159, 160, 119, 160, 120, 118, 
		158, 159, 118, 159, 119, 115, 157, 158, 115, 158, 118, 114, 157, 115, 114, 230, 
		157, 110, 199, 114, 236, 199, 110, 378, 343, 273, 236, 308, 199, 199, 292, 114, 
		114, 292, 230, 157, 230, 274, 157, 274, 209, 157, 209, 158, 158, 209, 210, 158, 
		210, 159, 159, 210, 211, 159, 211, 160, 160, 211, 212, 160, 212, 161, 161, 212, 
		213, 161, 213, 163, 163, 213, 215, 163, 215, 164, 164, 215, 216, 164, 216, 165, 
		165, 216, 217, 165, 217, 166, 166, 217, 218, 166, 218, 167, 167, 218, 219, 167, 
		219, 143, 143, 219, 222, 143, 222, 152, 152, 222, 223, 223, 270, 177, 177, 270, 
		279, 177, 279, 304, 177, 304, 243, 243, 304, 255, 278, 276, 300, 278, 300, 301, 
		300, 179, 297, 179, 229, 297, 229, 170, 305, 170, 231, 305, 170, 140, 231, 140, 
		172, 231, 172, 171, 233, 172, 233, 231, 408, 178, 306, 233, 178, 408, 233, 348, 
		295, 231, 233, 295, 231, 295, 296, 231, 296, 323, 305, 231, 323, 297, 229, 305, 
		301, 300, 319, 301, 319, 320, 304, 364, 255, 222, 317, 223, 219, 316, 317, 219, 
		317, 222, 218, 291, 316, 218, 316, 219, 217, 290, 291, 217, 291, 218, 216, 289, 
		290, 216, 290, 217, 215, 288, 289, 215, 289, 216, 213, 287, 288, 213, 288, 215, 
		212, 286, 287, 212, 287, 213, 211, 285, 286, 211, 286, 212, 210, 284, 285, 210, 
		285, 211, 209, 283, 284, 209, 284, 210, 209, 274, 283, 308, 292, 199, 236, 343, 
		308, 273, 343, 236, 292, 393, 230, 230, 393, 414, 230, 414, 274, 274, 414, 359, 
		274, 359, 283, 283, 359, 358, 283, 358, 284, 284, 358, 356, 284, 356, 285, 285, 
		356, 357, 285, 357, 286, 286, 357, 355, 286, 355, 287, 287, 355, 354, 287, 354, 
		288, 288, 354, 353, 288, 353, 289, 289, 353, 351, 289, 351, 290, 290, 351, 352, 
		290, 352, 291, 291, 352, 316, 317, 383, 223, 223, 383, 270, 270, 383, 394, 270, 
		394, 279, 279, 394, 377, 279, 377, 304, 304, 377, 364, 320, 319, 342, 320, 342, 
		341, 319, 300, 342, 300, 297, 380, 300, 380, 342, 297, 305, 380, 323, 296, 349, 
		296, 295, 348, 296, 348, 349, 233, 408, 348, 306, 277, 382, 277, 339, 382, 348, 
		408, 493, 348, 493, 418, 349, 348, 418, 349, 418, 416, 323, 349, 416, 305, 323, 
		416, 305, 416, 441, 380, 305, 441, 341, 342, 376, 341, 376, 373, 317, 467, 383, 
		316, 431, 467, 316, 467, 317, 352, 423, 431, 352, 431, 316, 351, 424, 423, 351, 
		423, 352, 353, 425, 424, 353, 424, 351, 354, 426, 425, 354, 425, 353, 355, 427, 
		426, 355, 426, 354, 357, 428, 427, 357, 427, 355, 356, 429, 428, 356, 428, 357, 
		358, 430, 429, 358, 429, 356, 359, 432, 430, 359, 430, 358, 359, 414, 432, 292, 
		500, 393, 308, 422, 500, 308, 500, 292, 343, 422, 308, 500, 568, 393, 393, 568, 
		532, 393, 532, 414, 414, 532, 519, 414, 519, 432, 432, 519, 518, 432, 518, 430, 
		430, 518, 517, 430, 517, 429, 429, 517, 516, 429, 516, 428, 428, 516, 515, 428, 
		515, 427, 427, 515, 513, 427, 513, 426, 426, 513, 512, 426, 512, 425, 425, 512, 
		511, 425, 511, 424, 424, 511, 510, 424, 510, 423, 423, 510, 541, 423, 541, 431, 
		431, 541, 467, 467, 509, 383, 383, 509, 394, 394, 448, 377, 373, 376, 397, 373, 
		397, 395, 376, 342, 397, 342, 380, 397, 380, 441, 529, 441, 416, 528, 416, 494, 
		528, 416, 418, 493, 416, 493, 494, 408, 306, 574, 306, 530, 574, 306, 382, 530, 
		382, 339, 434, 382, 434, 530, 493, 408, 582, 493, 582, 552, 494, 493, 552, 494, 
		552, 553, 529, 441, 528, 380, 529, 520, 397, 380, 520, 395, 397, 419, 395, 419, 
		413, 377, 448, 473, 377, 473, 364, 394, 514, 448, 509, 554, 514, 509, 514, 394, 
		467, 579, 509, 541, 579, 467, 510, 558, 541, 511, 559, 558, 511, 558, 510, 512, 
		560, 559, 512, 559, 511, 513, 561, 560, 513, 560, 512, 515, 562, 561, 515, 561, 
		513, 516, 563, 562, 516, 562, 515, 517, 564, 563, 517, 563, 516, 518, 565, 564, 
		518, 564, 517, 519, 566, 565, 519, 565, 518, 532, 584, 566, 532, 566, 519, 343, 
		462, 422, 343, 378, 462, 462, 543, 422, 422, 543, 500, 500, 626, 568, 568, 627, 
		532, 532, 627, 584, 584, 612, 566, 566, 612, 611, 566, 611, 565, 565, 611, 610, 
		565, 610, 564, 564, 610, 609, 564, 609, 563, 563, 609, 608, 563, 608, 562, 562, 
		608, 607, 562, 607, 561, 561, 607, 606, 561, 606, 560, 560, 606, 605, 560, 605, 
		559, 559, 605, 604, 559, 604, 558, 558, 604, 625, 558, 625, 541, 541, 625, 579, 
		579, 619, 509, 509, 619, 554, 514, 537, 448, 413, 419, 445, 413, 445, 439, 419, 
		397, 461, 419, 461, 445, 397, 520, 461, 529, 528, 576, 528, 597, 576, 528, 494, 
		597, 494, 553, 583, 494, 583, 597, 553, 552, 582, 553, 582, 583, 582, 408, 641, 
		408, 574, 641, 582, 641, 616, 583, 582, 616, 583, 616, 617, 597, 583, 617, 439, 
		445, 461, 439, 461, 457, 448, 506, 473, 448, 537, 506, 514, 580, 537, 554, 618, 
		580, 554, 580, 514, 619, 618, 554, 625, 619, 579, 604, 643, 625, 605, 643, 604, 
		606, 644, 643, 606, 643, 605, 607, 645, 644, 607, 644, 606, 608, 646, 645, 608, 
		645, 607, 609, 647, 646, 609, 646, 608, 610, 648, 647, 610, 647, 609, 611, 649, 
		648, 611, 648, 610, 612, 650, 649, 612, 649, 611, 584, 663, 650, 584, 650, 612, 
		627, 663, 584, 543, 626, 500
	};

	glEnableClientState(GL_TEXTURE_COORD_ARRAY);
	glTexCoordPointer(2, GL_FLOAT, 0, TexCoordData);
	glEnableClientState(GL_NORMAL_ARRAY);
	glNormalPointer(GL_FLOAT, 0, NormalData);
	glEnableClientState(GL_VERTEX_ARRAY);
	glVertexPointer(3, GL_FLOAT, 0, VertexData);


	// Material attributes for surface 'tap'
	bottle_Material_Parameters(82.0000f, 0.400000f, 0.180479f, 0.320975f, 0.400000f, 0.400000f, 0.400000f);
	glDrawElements(GL_TRIANGLES, 417, GL_UNSIGNED_INT, &Indices[0]); //0-414

	// Material attributes for surface 'glass'
	bottle_Material_Parameters(84.0000f, 0.000000f, 0.000000f, 0.000000f, 0.400000f, 0.400000f, 0.400000f);
	glDrawElements(GL_TRIANGLES, 642, GL_UNSIGNED_INT, &Indices[417]); //417 - 1056

	// Material attributes for surface 'tiqueta_etiq_botella.jpg.001'
	bottle_Material_Parameters(96.0000f, 0.400000f, 0.400000f, 0.400000f, 0.000000f, 0.000000f, 0.000000f);
	glDrawElements(GL_TRIANGLES, 87, GL_UNSIGNED_INT, &Indices[1059]); //1059 - 1143

	// Material attributes for surface 'bottle'
	bottle_Material_Parameters(80.0000f, 0.362995f, 0.400000f, 0.362861f, 0.400000f, 0.400000f, 0.400000f);
	glDrawElements(GL_TRIANGLES,3372 , GL_UNSIGNED_INT, &Indices[1146]); // 1146 - 4515

}	// End of polygons for object 'bottle'
