/*
 *  
 *  $Id: refinarcalibrado.cpp $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-14 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <wx/msgdlg.h>
#include <wx/app.h>

#include <string>
//#define _GINKGO_TRACE
#include <api/globals.h>
#include <api/iwidgetsmanager.h>
#include <api/icontexto.h>
#include "refinarcalibrado.h"
#include "datospersistentescalibrado.h"
#include <widgets/wtrapezoide.h>

#include <main/entorno.h>

#include <iostream>


#include <vtk/widgets/widgetsactor.h>
#include <vtkImageData.h>
#include <vtkImageReslice.h>
#include <vtkMatrix4x4.h>

namespace GNC {
	namespace GUI {

		RefinarCalibrado::RefinarCalibrado(wxWindow* pParent,IWizard* pWizard, TipoWizardCalibrado* pDatosPersistentes):RefinarCalibradoBase(pParent),IPasoWizard(pWizard)
		{
			m_pDatosPersistentes = pDatosPersistentes;

			//se carga la imagen..
			// Setup del manejador de widgets */
			m_pWidgetsManager = GNC::Entorno::Instance()->NewWidgetsManager(NULL);
			GNC::GCS::IWidgetsRenderer* pR = ViewInteractor2D;
			pR->SetManager(m_pWidgetsManager);
			pR->SetVID(0,false);

			m_pWidgetsRepresentation = WidgetRepresentation::New();

			vtkRenderer* ren = ViewInteractor2D->FindPokedRenderer(0,0);
			m_pWidgetsRepresentation->SetRenderer(ren);
			//ren->AddViewProp(m_pWidgetsRepresentation);
			pR->SetRepresentation(m_pWidgetsRepresentation);
			m_pWidgetsRepresentation->SetWidgetsManager(m_pWidgetsManager);
			m_pWidgetsRepresentation->SetWidgetsRenderer(pR);

			ViewImage2D->SetBackgroundColor(0.0f, 0.0f, 0.0f);
			ViewImage2D->SetShowAnnotations(false);
			ViewImage2D->SetInterpolationMode(0);

			ViewImage2D->SetShowAnnotations(false);
			ViewImage2D->SetInterpolationMode(0);

			ViewInteractor2D->m_c->rotacion = 0;

			SetAutoLayout(true);
			m_pTrapezoideBuilder = new GNC::GCS::Widgets::WTrapezoideBuilder(m_pWidgetsManager, GNC::GCS::TriggerButton().EnableLeft(), 0,1);
			m_pWidgetsManager->OcultarTodosLosWidgets(false,0);

			//se enchufa la imagen
			static double axialElements[16] = {
           1, 0, 0, 0,
           0, 1, 0, 0,
           0, 0, 1, 0,
           0, 0, 0, 1 };
			vtkSmartPointer<vtkMatrix4x4> resliceAxes = vtkSmartPointer<vtkMatrix4x4>::New();
			resliceAxes->DeepCopy(axialElements);
			// Set the point through which to slice (la cero)
			resliceAxes->SetElement(0, 3, 0.0f);
			resliceAxes->SetElement(1, 3, 0.0f);
			resliceAxes->SetElement(2, 3, 0.0f);
			resliceAxes->SetElement(2, 3, (double)m_pDatosPersistentes->m_slice);

			vtkSmartPointer<vtkImageReslice> pReslice = vtkSmartPointer<vtkImageReslice>::New();
			pReslice->SetInput(m_pDatosPersistentes->m_pImageData);
			pReslice->SetOutputDimensionality(2);
			pReslice->SetResliceAxes(resliceAxes);
			pReslice->SetInterpolationModeToLinear();

			pReslice->Update();
			//TODOX
			//ViewImage2D->SetInputConnection(pReslice->GetOutputPort());

			ViewImage2D->SetOrientation(vtkGinkgoImageViewer::AXIAL_ID);
			ViewImage2D->Reset();
			ViewInteractor2D->m_pImageViewer = ViewImage2D;
			ViewImage2D->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
			ViewInteractor2D->InsertarListener(this);
		}

		RefinarCalibrado::~RefinarCalibrado()
		{
			m_pWidgetsManager->EliminarTodosLosWidgets(false);
			m_pDatosPersistentes = NULL;

			delete m_pTrapezoideBuilder;
			m_pTrapezoideBuilder = NULL;

			GNC::Entorno::Instance()->FreeWidgetsManager(m_pWidgetsManager);

			ViewInteractor2D->SetRepresentation(NULL);
			m_pWidgetsRepresentation->Delete();
			m_pWidgetsRepresentation = NULL;

			ViewImage2D->Detach();
			ViewImage2D->Delete();
			ViewInteractor2D->Delete();
		}

		//Isuscriptor de eventos

		void RefinarCalibrado::OnMouseEvents(GNC::GCS::Events::EventoRaton& evento)
		{
			m_pWidgetsManager->OnMouseEvents(evento);
		}

		void RefinarCalibrado::OnKeyDown(GNC::GCS::Events::EventoTeclado& evento)
		{
			m_pWidgetsManager->OnKeyEvents(evento);
		}
		//

		//region "Metodos heredados de Ipasowizard"
		bool RefinarCalibrado::Attach(){
			//se eliminan todos los widgets...
			m_pWidgetsManager->EliminarTodosLosWidgets(false);
			if(m_pDatosPersistentes->m_Puntos.size() == 4){
				//se crea un widget rectangulo
				GNC::GCS::Vector BB[4];
				TipoWizardCalibrado::TVectorPuntos::const_iterator it = m_pDatosPersistentes->m_Puntos.begin();
				for (int i = 0; i < 4; i++)  {
					const TPuntoCalibrado& point = *it;
					BB[i].Asignar(point.x, point.y);
				}

				GNC::GCS::Widgets::WTrapezoide* pTrapezoide = new GNC::GCS::Widgets::WTrapezoide(m_pWidgetsManager, BB, 0, "", 0);
				m_pWidgetsManager->InsertarWidget(pTrapezoide);
			}
			return true;
		}

		bool RefinarCalibrado::Detach(){
			return true;
		}

		std::string RefinarCalibrado::GetTitle(){
			return std::string("Refinar Calibrado");
		}

		std::string RefinarCalibrado::GetSubTitle(){
			return std::string("Si lo desea modifique los resultados obtenidos por el algoritmo de vision");
		}

		bool RefinarCalibrado::Siguiente(){
			return true;
		}

		bool RefinarCalibrado::Anterior(){
			return true;
		}

		bool RefinarCalibrado::Cancelar(){
			return true;
		}

		bool RefinarCalibrado::Validar(){
			//se pillan el widget..
			if(m_pWidgetsManager->GetListaWidgets().size() == 0){
				wxMessageBox(wxT("Debe seleccionar la baliza"), wxT("Info"),
					 wxOK | wxICON_INFORMATION, this);
				return false;
			}
			//GNC::GCS::Widgets::WParalelepipedo* pBaliza = (GNC::GCS::Widgets::WParalelepipedo*)(*(m_pWidgetsManager->GetListaWidgets().begin()));
			//TODO calcular el spacing a partir de los puntos...

			m_pDatosPersistentes->m_spacingHorizontal = 0.5f;
			m_pDatosPersistentes->m_spacingVertical = 0.5f;
			//
			return true;
		}
		//endregion
	}
}
