// +build !ignore_autogenerated

/*
Copyright 2016 The Kubernetes Authors All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// This file was autogenerated by deepcopy-gen. Do not edit it manually!

package api

import (
	resource "k8s.io/kubernetes/pkg/api/resource"
	unversioned "k8s.io/kubernetes/pkg/api/unversioned"
	conversion "k8s.io/kubernetes/pkg/conversion"
	fields "k8s.io/kubernetes/pkg/fields"
	labels "k8s.io/kubernetes/pkg/labels"
	runtime "k8s.io/kubernetes/pkg/runtime"
	types "k8s.io/kubernetes/pkg/types"
	intstr "k8s.io/kubernetes/pkg/util/intstr"
)

func init() {
	if err := Scheme.AddGeneratedDeepCopyFuncs(
		DeepCopy_api_AWSElasticBlockStoreVolumeSource,
		DeepCopy_api_Affinity,
		DeepCopy_api_AttachedVolume,
		DeepCopy_api_AzureFileVolumeSource,
		DeepCopy_api_Binding,
		DeepCopy_api_Capabilities,
		DeepCopy_api_CephFSVolumeSource,
		DeepCopy_api_CinderVolumeSource,
		DeepCopy_api_ComponentCondition,
		DeepCopy_api_ComponentStatus,
		DeepCopy_api_ComponentStatusList,
		DeepCopy_api_ConfigMap,
		DeepCopy_api_ConfigMapKeySelector,
		DeepCopy_api_ConfigMapList,
		DeepCopy_api_ConfigMapVolumeSource,
		DeepCopy_api_Container,
		DeepCopy_api_ContainerImage,
		DeepCopy_api_ContainerPort,
		DeepCopy_api_ContainerState,
		DeepCopy_api_ContainerStateRunning,
		DeepCopy_api_ContainerStateTerminated,
		DeepCopy_api_ContainerStateWaiting,
		DeepCopy_api_ContainerStatus,
		DeepCopy_api_ConversionError,
		DeepCopy_api_DaemonEndpoint,
		DeepCopy_api_DeleteOptions,
		DeepCopy_api_DownwardAPIVolumeFile,
		DeepCopy_api_DownwardAPIVolumeSource,
		DeepCopy_api_EmptyDirVolumeSource,
		DeepCopy_api_EndpointAddress,
		DeepCopy_api_EndpointPort,
		DeepCopy_api_EndpointSubset,
		DeepCopy_api_Endpoints,
		DeepCopy_api_EndpointsList,
		DeepCopy_api_EnvVar,
		DeepCopy_api_EnvVarSource,
		DeepCopy_api_Event,
		DeepCopy_api_EventList,
		DeepCopy_api_EventSource,
		DeepCopy_api_ExecAction,
		DeepCopy_api_ExportOptions,
		DeepCopy_api_FCVolumeSource,
		DeepCopy_api_FlexVolumeSource,
		DeepCopy_api_FlockerVolumeSource,
		DeepCopy_api_GCEPersistentDiskVolumeSource,
		DeepCopy_api_GitRepoVolumeSource,
		DeepCopy_api_GlusterfsVolumeSource,
		DeepCopy_api_HTTPGetAction,
		DeepCopy_api_HTTPHeader,
		DeepCopy_api_Handler,
		DeepCopy_api_HostPathVolumeSource,
		DeepCopy_api_ISCSIVolumeSource,
		DeepCopy_api_KeyToPath,
		DeepCopy_api_Lifecycle,
		DeepCopy_api_LimitRange,
		DeepCopy_api_LimitRangeItem,
		DeepCopy_api_LimitRangeList,
		DeepCopy_api_LimitRangeSpec,
		DeepCopy_api_List,
		DeepCopy_api_ListOptions,
		DeepCopy_api_LoadBalancerIngress,
		DeepCopy_api_LoadBalancerStatus,
		DeepCopy_api_LocalObjectReference,
		DeepCopy_api_NFSVolumeSource,
		DeepCopy_api_Namespace,
		DeepCopy_api_NamespaceList,
		DeepCopy_api_NamespaceSpec,
		DeepCopy_api_NamespaceStatus,
		DeepCopy_api_Node,
		DeepCopy_api_NodeAddress,
		DeepCopy_api_NodeAffinity,
		DeepCopy_api_NodeCondition,
		DeepCopy_api_NodeDaemonEndpoints,
		DeepCopy_api_NodeList,
		DeepCopy_api_NodeProxyOptions,
		DeepCopy_api_NodeResources,
		DeepCopy_api_NodeSelector,
		DeepCopy_api_NodeSelectorRequirement,
		DeepCopy_api_NodeSelectorTerm,
		DeepCopy_api_NodeSpec,
		DeepCopy_api_NodeStatus,
		DeepCopy_api_NodeSystemInfo,
		DeepCopy_api_ObjectFieldSelector,
		DeepCopy_api_ObjectMeta,
		DeepCopy_api_ObjectReference,
		DeepCopy_api_OwnerReference,
		DeepCopy_api_PersistentVolume,
		DeepCopy_api_PersistentVolumeClaim,
		DeepCopy_api_PersistentVolumeClaimList,
		DeepCopy_api_PersistentVolumeClaimSpec,
		DeepCopy_api_PersistentVolumeClaimStatus,
		DeepCopy_api_PersistentVolumeClaimVolumeSource,
		DeepCopy_api_PersistentVolumeList,
		DeepCopy_api_PersistentVolumeSource,
		DeepCopy_api_PersistentVolumeSpec,
		DeepCopy_api_PersistentVolumeStatus,
		DeepCopy_api_Pod,
		DeepCopy_api_PodAffinity,
		DeepCopy_api_PodAffinityTerm,
		DeepCopy_api_PodAntiAffinity,
		DeepCopy_api_PodAttachOptions,
		DeepCopy_api_PodCondition,
		DeepCopy_api_PodExecOptions,
		DeepCopy_api_PodList,
		DeepCopy_api_PodLogOptions,
		DeepCopy_api_PodProxyOptions,
		DeepCopy_api_PodSecurityContext,
		DeepCopy_api_PodSpec,
		DeepCopy_api_PodStatus,
		DeepCopy_api_PodStatusResult,
		DeepCopy_api_PodTemplate,
		DeepCopy_api_PodTemplateList,
		DeepCopy_api_PodTemplateSpec,
		DeepCopy_api_Preconditions,
		DeepCopy_api_PreferredSchedulingTerm,
		DeepCopy_api_Probe,
		DeepCopy_api_RBDVolumeSource,
		DeepCopy_api_RangeAllocation,
		DeepCopy_api_ReplicationController,
		DeepCopy_api_ReplicationControllerList,
		DeepCopy_api_ReplicationControllerSpec,
		DeepCopy_api_ReplicationControllerStatus,
		DeepCopy_api_ResourceFieldSelector,
		DeepCopy_api_ResourceQuota,
		DeepCopy_api_ResourceQuotaList,
		DeepCopy_api_ResourceQuotaSpec,
		DeepCopy_api_ResourceQuotaStatus,
		DeepCopy_api_ResourceRequirements,
		DeepCopy_api_SELinuxOptions,
		DeepCopy_api_Secret,
		DeepCopy_api_SecretKeySelector,
		DeepCopy_api_SecretList,
		DeepCopy_api_SecretVolumeSource,
		DeepCopy_api_SecurityContext,
		DeepCopy_api_SerializedReference,
		DeepCopy_api_Service,
		DeepCopy_api_ServiceAccount,
		DeepCopy_api_ServiceAccountList,
		DeepCopy_api_ServiceList,
		DeepCopy_api_ServicePort,
		DeepCopy_api_ServiceProxyOptions,
		DeepCopy_api_ServiceSpec,
		DeepCopy_api_ServiceStatus,
		DeepCopy_api_TCPSocketAction,
		DeepCopy_api_Taint,
		DeepCopy_api_Toleration,
		DeepCopy_api_Volume,
		DeepCopy_api_VolumeMount,
		DeepCopy_api_VolumeSource,
		DeepCopy_api_VsphereVirtualDiskVolumeSource,
		DeepCopy_api_WeightedPodAffinityTerm,
	); err != nil {
		// if one of the deep copy functions is malformed, detect it immediately.
		panic(err)
	}
}

func DeepCopy_api_AWSElasticBlockStoreVolumeSource(in AWSElasticBlockStoreVolumeSource, out *AWSElasticBlockStoreVolumeSource, c *conversion.Cloner) error {
	out.VolumeID = in.VolumeID
	out.FSType = in.FSType
	out.Partition = in.Partition
	out.ReadOnly = in.ReadOnly
	return nil
}

func DeepCopy_api_Affinity(in Affinity, out *Affinity, c *conversion.Cloner) error {
	if in.NodeAffinity != nil {
		in, out := in.NodeAffinity, &out.NodeAffinity
		*out = new(NodeAffinity)
		if err := DeepCopy_api_NodeAffinity(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.NodeAffinity = nil
	}
	if in.PodAffinity != nil {
		in, out := in.PodAffinity, &out.PodAffinity
		*out = new(PodAffinity)
		if err := DeepCopy_api_PodAffinity(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.PodAffinity = nil
	}
	if in.PodAntiAffinity != nil {
		in, out := in.PodAntiAffinity, &out.PodAntiAffinity
		*out = new(PodAntiAffinity)
		if err := DeepCopy_api_PodAntiAffinity(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.PodAntiAffinity = nil
	}
	return nil
}

func DeepCopy_api_AttachedVolume(in AttachedVolume, out *AttachedVolume, c *conversion.Cloner) error {
	out.Name = in.Name
	out.DevicePath = in.DevicePath
	return nil
}

func DeepCopy_api_AzureFileVolumeSource(in AzureFileVolumeSource, out *AzureFileVolumeSource, c *conversion.Cloner) error {
	out.SecretName = in.SecretName
	out.ShareName = in.ShareName
	out.ReadOnly = in.ReadOnly
	return nil
}

func DeepCopy_api_Binding(in Binding, out *Binding, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_ObjectMeta(in.ObjectMeta, &out.ObjectMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_ObjectReference(in.Target, &out.Target, c); err != nil {
		return err
	}
	return nil
}

func DeepCopy_api_Capabilities(in Capabilities, out *Capabilities, c *conversion.Cloner) error {
	if in.Add != nil {
		in, out := in.Add, &out.Add
		*out = make([]Capability, len(in))
		for i := range in {
			(*out)[i] = in[i]
		}
	} else {
		out.Add = nil
	}
	if in.Drop != nil {
		in, out := in.Drop, &out.Drop
		*out = make([]Capability, len(in))
		for i := range in {
			(*out)[i] = in[i]
		}
	} else {
		out.Drop = nil
	}
	return nil
}

func DeepCopy_api_CephFSVolumeSource(in CephFSVolumeSource, out *CephFSVolumeSource, c *conversion.Cloner) error {
	if in.Monitors != nil {
		in, out := in.Monitors, &out.Monitors
		*out = make([]string, len(in))
		copy(*out, in)
	} else {
		out.Monitors = nil
	}
	out.Path = in.Path
	out.User = in.User
	out.SecretFile = in.SecretFile
	if in.SecretRef != nil {
		in, out := in.SecretRef, &out.SecretRef
		*out = new(LocalObjectReference)
		if err := DeepCopy_api_LocalObjectReference(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.SecretRef = nil
	}
	out.ReadOnly = in.ReadOnly
	return nil
}

func DeepCopy_api_CinderVolumeSource(in CinderVolumeSource, out *CinderVolumeSource, c *conversion.Cloner) error {
	out.VolumeID = in.VolumeID
	out.FSType = in.FSType
	out.ReadOnly = in.ReadOnly
	return nil
}

func DeepCopy_api_ComponentCondition(in ComponentCondition, out *ComponentCondition, c *conversion.Cloner) error {
	out.Type = in.Type
	out.Status = in.Status
	out.Message = in.Message
	out.Error = in.Error
	return nil
}

func DeepCopy_api_ComponentStatus(in ComponentStatus, out *ComponentStatus, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_ObjectMeta(in.ObjectMeta, &out.ObjectMeta, c); err != nil {
		return err
	}
	if in.Conditions != nil {
		in, out := in.Conditions, &out.Conditions
		*out = make([]ComponentCondition, len(in))
		for i := range in {
			if err := DeepCopy_api_ComponentCondition(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Conditions = nil
	}
	return nil
}

func DeepCopy_api_ComponentStatusList(in ComponentStatusList, out *ComponentStatusList, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := unversioned.DeepCopy_unversioned_ListMeta(in.ListMeta, &out.ListMeta, c); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := in.Items, &out.Items
		*out = make([]ComponentStatus, len(in))
		for i := range in {
			if err := DeepCopy_api_ComponentStatus(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func DeepCopy_api_ConfigMap(in ConfigMap, out *ConfigMap, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_ObjectMeta(in.ObjectMeta, &out.ObjectMeta, c); err != nil {
		return err
	}
	if in.Data != nil {
		in, out := in.Data, &out.Data
		*out = make(map[string]string)
		for key, val := range in {
			(*out)[key] = val
		}
	} else {
		out.Data = nil
	}
	return nil
}

func DeepCopy_api_ConfigMapKeySelector(in ConfigMapKeySelector, out *ConfigMapKeySelector, c *conversion.Cloner) error {
	if err := DeepCopy_api_LocalObjectReference(in.LocalObjectReference, &out.LocalObjectReference, c); err != nil {
		return err
	}
	out.Key = in.Key
	return nil
}

func DeepCopy_api_ConfigMapList(in ConfigMapList, out *ConfigMapList, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := unversioned.DeepCopy_unversioned_ListMeta(in.ListMeta, &out.ListMeta, c); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := in.Items, &out.Items
		*out = make([]ConfigMap, len(in))
		for i := range in {
			if err := DeepCopy_api_ConfigMap(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func DeepCopy_api_ConfigMapVolumeSource(in ConfigMapVolumeSource, out *ConfigMapVolumeSource, c *conversion.Cloner) error {
	if err := DeepCopy_api_LocalObjectReference(in.LocalObjectReference, &out.LocalObjectReference, c); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := in.Items, &out.Items
		*out = make([]KeyToPath, len(in))
		for i := range in {
			if err := DeepCopy_api_KeyToPath(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func DeepCopy_api_Container(in Container, out *Container, c *conversion.Cloner) error {
	out.Name = in.Name
	out.Image = in.Image
	if in.Command != nil {
		in, out := in.Command, &out.Command
		*out = make([]string, len(in))
		copy(*out, in)
	} else {
		out.Command = nil
	}
	if in.Args != nil {
		in, out := in.Args, &out.Args
		*out = make([]string, len(in))
		copy(*out, in)
	} else {
		out.Args = nil
	}
	out.WorkingDir = in.WorkingDir
	if in.Ports != nil {
		in, out := in.Ports, &out.Ports
		*out = make([]ContainerPort, len(in))
		for i := range in {
			if err := DeepCopy_api_ContainerPort(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Ports = nil
	}
	if in.Env != nil {
		in, out := in.Env, &out.Env
		*out = make([]EnvVar, len(in))
		for i := range in {
			if err := DeepCopy_api_EnvVar(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	if err := DeepCopy_api_ResourceRequirements(in.Resources, &out.Resources, c); err != nil {
		return err
	}
	if in.VolumeMounts != nil {
		in, out := in.VolumeMounts, &out.VolumeMounts
		*out = make([]VolumeMount, len(in))
		for i := range in {
			if err := DeepCopy_api_VolumeMount(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.VolumeMounts = nil
	}
	if in.LivenessProbe != nil {
		in, out := in.LivenessProbe, &out.LivenessProbe
		*out = new(Probe)
		if err := DeepCopy_api_Probe(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.LivenessProbe = nil
	}
	if in.ReadinessProbe != nil {
		in, out := in.ReadinessProbe, &out.ReadinessProbe
		*out = new(Probe)
		if err := DeepCopy_api_Probe(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.ReadinessProbe = nil
	}
	if in.Lifecycle != nil {
		in, out := in.Lifecycle, &out.Lifecycle
		*out = new(Lifecycle)
		if err := DeepCopy_api_Lifecycle(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.Lifecycle = nil
	}
	out.TerminationMessagePath = in.TerminationMessagePath
	out.ImagePullPolicy = in.ImagePullPolicy
	if in.SecurityContext != nil {
		in, out := in.SecurityContext, &out.SecurityContext
		*out = new(SecurityContext)
		if err := DeepCopy_api_SecurityContext(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.SecurityContext = nil
	}
	out.Stdin = in.Stdin
	out.StdinOnce = in.StdinOnce
	out.TTY = in.TTY
	return nil
}

func DeepCopy_api_ContainerImage(in ContainerImage, out *ContainerImage, c *conversion.Cloner) error {
	if in.Names != nil {
		in, out := in.Names, &out.Names
		*out = make([]string, len(in))
		copy(*out, in)
	} else {
		out.Names = nil
	}
	out.SizeBytes = in.SizeBytes
	return nil
}

func DeepCopy_api_ContainerPort(in ContainerPort, out *ContainerPort, c *conversion.Cloner) error {
	out.Name = in.Name
	out.HostPort = in.HostPort
	out.ContainerPort = in.ContainerPort
	out.Protocol = in.Protocol
	out.HostIP = in.HostIP
	return nil
}

func DeepCopy_api_ContainerState(in ContainerState, out *ContainerState, c *conversion.Cloner) error {
	if in.Waiting != nil {
		in, out := in.Waiting, &out.Waiting
		*out = new(ContainerStateWaiting)
		if err := DeepCopy_api_ContainerStateWaiting(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.Waiting = nil
	}
	if in.Running != nil {
		in, out := in.Running, &out.Running
		*out = new(ContainerStateRunning)
		if err := DeepCopy_api_ContainerStateRunning(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.Running = nil
	}
	if in.Terminated != nil {
		in, out := in.Terminated, &out.Terminated
		*out = new(ContainerStateTerminated)
		if err := DeepCopy_api_ContainerStateTerminated(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.Terminated = nil
	}
	return nil
}

func DeepCopy_api_ContainerStateRunning(in ContainerStateRunning, out *ContainerStateRunning, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_Time(in.StartedAt, &out.StartedAt, c); err != nil {
		return err
	}
	return nil
}

func DeepCopy_api_ContainerStateTerminated(in ContainerStateTerminated, out *ContainerStateTerminated, c *conversion.Cloner) error {
	out.ExitCode = in.ExitCode
	out.Signal = in.Signal
	out.Reason = in.Reason
	out.Message = in.Message
	if err := unversioned.DeepCopy_unversioned_Time(in.StartedAt, &out.StartedAt, c); err != nil {
		return err
	}
	if err := unversioned.DeepCopy_unversioned_Time(in.FinishedAt, &out.FinishedAt, c); err != nil {
		return err
	}
	out.ContainerID = in.ContainerID
	return nil
}

func DeepCopy_api_ContainerStateWaiting(in ContainerStateWaiting, out *ContainerStateWaiting, c *conversion.Cloner) error {
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

func DeepCopy_api_ContainerStatus(in ContainerStatus, out *ContainerStatus, c *conversion.Cloner) error {
	out.Name = in.Name
	if err := DeepCopy_api_ContainerState(in.State, &out.State, c); err != nil {
		return err
	}
	if err := DeepCopy_api_ContainerState(in.LastTerminationState, &out.LastTerminationState, c); err != nil {
		return err
	}
	out.Ready = in.Ready
	out.RestartCount = in.RestartCount
	out.Image = in.Image
	out.ImageID = in.ImageID
	out.ContainerID = in.ContainerID
	return nil
}

func DeepCopy_api_ConversionError(in ConversionError, out *ConversionError, c *conversion.Cloner) error {
	if in.In == nil {
		out.In = nil
	} else if newVal, err := c.DeepCopy(in.In); err != nil {
		return err
	} else {
		out.In = newVal.(interface{})
	}
	if in.Out == nil {
		out.Out = nil
	} else if newVal, err := c.DeepCopy(in.Out); err != nil {
		return err
	} else {
		out.Out = newVal.(interface{})
	}
	out.Message = in.Message
	return nil
}

func DeepCopy_api_DaemonEndpoint(in DaemonEndpoint, out *DaemonEndpoint, c *conversion.Cloner) error {
	out.Port = in.Port
	return nil
}

func DeepCopy_api_DeleteOptions(in DeleteOptions, out *DeleteOptions, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if in.GracePeriodSeconds != nil {
		in, out := in.GracePeriodSeconds, &out.GracePeriodSeconds
		*out = new(int64)
		**out = *in
	} else {
		out.GracePeriodSeconds = nil
	}
	if in.Preconditions != nil {
		in, out := in.Preconditions, &out.Preconditions
		*out = new(Preconditions)
		if err := DeepCopy_api_Preconditions(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.Preconditions = nil
	}
	if in.OrphanDependents != nil {
		in, out := in.OrphanDependents, &out.OrphanDependents
		*out = new(bool)
		**out = *in
	} else {
		out.OrphanDependents = nil
	}
	return nil
}

func DeepCopy_api_DownwardAPIVolumeFile(in DownwardAPIVolumeFile, out *DownwardAPIVolumeFile, c *conversion.Cloner) error {
	out.Path = in.Path
	if in.FieldRef != nil {
		in, out := in.FieldRef, &out.FieldRef
		*out = new(ObjectFieldSelector)
		if err := DeepCopy_api_ObjectFieldSelector(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.FieldRef = nil
	}
	if in.ResourceFieldRef != nil {
		in, out := in.ResourceFieldRef, &out.ResourceFieldRef
		*out = new(ResourceFieldSelector)
		if err := DeepCopy_api_ResourceFieldSelector(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.ResourceFieldRef = nil
	}
	return nil
}

func DeepCopy_api_DownwardAPIVolumeSource(in DownwardAPIVolumeSource, out *DownwardAPIVolumeSource, c *conversion.Cloner) error {
	if in.Items != nil {
		in, out := in.Items, &out.Items
		*out = make([]DownwardAPIVolumeFile, len(in))
		for i := range in {
			if err := DeepCopy_api_DownwardAPIVolumeFile(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func DeepCopy_api_EmptyDirVolumeSource(in EmptyDirVolumeSource, out *EmptyDirVolumeSource, c *conversion.Cloner) error {
	out.Medium = in.Medium
	return nil
}

func DeepCopy_api_EndpointAddress(in EndpointAddress, out *EndpointAddress, c *conversion.Cloner) error {
	out.IP = in.IP
	out.Hostname = in.Hostname
	if in.TargetRef != nil {
		in, out := in.TargetRef, &out.TargetRef
		*out = new(ObjectReference)
		if err := DeepCopy_api_ObjectReference(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.TargetRef = nil
	}
	return nil
}

func DeepCopy_api_EndpointPort(in EndpointPort, out *EndpointPort, c *conversion.Cloner) error {
	out.Name = in.Name
	out.Port = in.Port
	out.Protocol = in.Protocol
	return nil
}

func DeepCopy_api_EndpointSubset(in EndpointSubset, out *EndpointSubset, c *conversion.Cloner) error {
	if in.Addresses != nil {
		in, out := in.Addresses, &out.Addresses
		*out = make([]EndpointAddress, len(in))
		for i := range in {
			if err := DeepCopy_api_EndpointAddress(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Addresses = nil
	}
	if in.NotReadyAddresses != nil {
		in, out := in.NotReadyAddresses, &out.NotReadyAddresses
		*out = make([]EndpointAddress, len(in))
		for i := range in {
			if err := DeepCopy_api_EndpointAddress(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.NotReadyAddresses = nil
	}
	if in.Ports != nil {
		in, out := in.Ports, &out.Ports
		*out = make([]EndpointPort, len(in))
		for i := range in {
			if err := DeepCopy_api_EndpointPort(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Ports = nil
	}
	return nil
}

func DeepCopy_api_Endpoints(in Endpoints, out *Endpoints, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_ObjectMeta(in.ObjectMeta, &out.ObjectMeta, c); err != nil {
		return err
	}
	if in.Subsets != nil {
		in, out := in.Subsets, &out.Subsets
		*out = make([]EndpointSubset, len(in))
		for i := range in {
			if err := DeepCopy_api_EndpointSubset(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Subsets = nil
	}
	return nil
}

func DeepCopy_api_EndpointsList(in EndpointsList, out *EndpointsList, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := unversioned.DeepCopy_unversioned_ListMeta(in.ListMeta, &out.ListMeta, c); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := in.Items, &out.Items
		*out = make([]Endpoints, len(in))
		for i := range in {
			if err := DeepCopy_api_Endpoints(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func DeepCopy_api_EnvVar(in EnvVar, out *EnvVar, c *conversion.Cloner) error {
	out.Name = in.Name
	out.Value = in.Value
	if in.ValueFrom != nil {
		in, out := in.ValueFrom, &out.ValueFrom
		*out = new(EnvVarSource)
		if err := DeepCopy_api_EnvVarSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.ValueFrom = nil
	}
	return nil
}

func DeepCopy_api_EnvVarSource(in EnvVarSource, out *EnvVarSource, c *conversion.Cloner) error {
	if in.FieldRef != nil {
		in, out := in.FieldRef, &out.FieldRef
		*out = new(ObjectFieldSelector)
		if err := DeepCopy_api_ObjectFieldSelector(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.FieldRef = nil
	}
	if in.ResourceFieldRef != nil {
		in, out := in.ResourceFieldRef, &out.ResourceFieldRef
		*out = new(ResourceFieldSelector)
		if err := DeepCopy_api_ResourceFieldSelector(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.ResourceFieldRef = nil
	}
	if in.ConfigMapKeyRef != nil {
		in, out := in.ConfigMapKeyRef, &out.ConfigMapKeyRef
		*out = new(ConfigMapKeySelector)
		if err := DeepCopy_api_ConfigMapKeySelector(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.ConfigMapKeyRef = nil
	}
	if in.SecretKeyRef != nil {
		in, out := in.SecretKeyRef, &out.SecretKeyRef
		*out = new(SecretKeySelector)
		if err := DeepCopy_api_SecretKeySelector(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.SecretKeyRef = nil
	}
	return nil
}

func DeepCopy_api_Event(in Event, out *Event, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_ObjectMeta(in.ObjectMeta, &out.ObjectMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_ObjectReference(in.InvolvedObject, &out.InvolvedObject, c); err != nil {
		return err
	}
	out.Reason = in.Reason
	out.Message = in.Message
	if err := DeepCopy_api_EventSource(in.Source, &out.Source, c); err != nil {
		return err
	}
	if err := unversioned.DeepCopy_unversioned_Time(in.FirstTimestamp, &out.FirstTimestamp, c); err != nil {
		return err
	}
	if err := unversioned.DeepCopy_unversioned_Time(in.LastTimestamp, &out.LastTimestamp, c); err != nil {
		return err
	}
	out.Count = in.Count
	out.Type = in.Type
	return nil
}

func DeepCopy_api_EventList(in EventList, out *EventList, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := unversioned.DeepCopy_unversioned_ListMeta(in.ListMeta, &out.ListMeta, c); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := in.Items, &out.Items
		*out = make([]Event, len(in))
		for i := range in {
			if err := DeepCopy_api_Event(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func DeepCopy_api_EventSource(in EventSource, out *EventSource, c *conversion.Cloner) error {
	out.Component = in.Component
	out.Host = in.Host
	return nil
}

func DeepCopy_api_ExecAction(in ExecAction, out *ExecAction, c *conversion.Cloner) error {
	if in.Command != nil {
		in, out := in.Command, &out.Command
		*out = make([]string, len(in))
		copy(*out, in)
	} else {
		out.Command = nil
	}
	return nil
}

func DeepCopy_api_ExportOptions(in ExportOptions, out *ExportOptions, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	out.Export = in.Export
	out.Exact = in.Exact
	return nil
}

func DeepCopy_api_FCVolumeSource(in FCVolumeSource, out *FCVolumeSource, c *conversion.Cloner) error {
	if in.TargetWWNs != nil {
		in, out := in.TargetWWNs, &out.TargetWWNs
		*out = make([]string, len(in))
		copy(*out, in)
	} else {
		out.TargetWWNs = nil
	}
	if in.Lun != nil {
		in, out := in.Lun, &out.Lun
		*out = new(int32)
		**out = *in
	} else {
		out.Lun = nil
	}
	out.FSType = in.FSType
	out.ReadOnly = in.ReadOnly
	return nil
}

func DeepCopy_api_FlexVolumeSource(in FlexVolumeSource, out *FlexVolumeSource, c *conversion.Cloner) error {
	out.Driver = in.Driver
	out.FSType = in.FSType
	if in.SecretRef != nil {
		in, out := in.SecretRef, &out.SecretRef
		*out = new(LocalObjectReference)
		if err := DeepCopy_api_LocalObjectReference(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.SecretRef = nil
	}
	out.ReadOnly = in.ReadOnly
	if in.Options != nil {
		in, out := in.Options, &out.Options
		*out = make(map[string]string)
		for key, val := range in {
			(*out)[key] = val
		}
	} else {
		out.Options = nil
	}
	return nil
}

func DeepCopy_api_FlockerVolumeSource(in FlockerVolumeSource, out *FlockerVolumeSource, c *conversion.Cloner) error {
	out.DatasetName = in.DatasetName
	return nil
}

func DeepCopy_api_GCEPersistentDiskVolumeSource(in GCEPersistentDiskVolumeSource, out *GCEPersistentDiskVolumeSource, c *conversion.Cloner) error {
	out.PDName = in.PDName
	out.FSType = in.FSType
	out.Partition = in.Partition
	out.ReadOnly = in.ReadOnly
	return nil
}

func DeepCopy_api_GitRepoVolumeSource(in GitRepoVolumeSource, out *GitRepoVolumeSource, c *conversion.Cloner) error {
	out.Repository = in.Repository
	out.Revision = in.Revision
	out.Directory = in.Directory
	return nil
}

func DeepCopy_api_GlusterfsVolumeSource(in GlusterfsVolumeSource, out *GlusterfsVolumeSource, c *conversion.Cloner) error {
	out.EndpointsName = in.EndpointsName
	out.Path = in.Path
	out.ReadOnly = in.ReadOnly
	return nil
}

func DeepCopy_api_HTTPGetAction(in HTTPGetAction, out *HTTPGetAction, c *conversion.Cloner) error {
	out.Path = in.Path
	if err := intstr.DeepCopy_intstr_IntOrString(in.Port, &out.Port, c); err != nil {
		return err
	}
	out.Host = in.Host
	out.Scheme = in.Scheme
	if in.HTTPHeaders != nil {
		in, out := in.HTTPHeaders, &out.HTTPHeaders
		*out = make([]HTTPHeader, len(in))
		for i := range in {
			if err := DeepCopy_api_HTTPHeader(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.HTTPHeaders = nil
	}
	return nil
}

func DeepCopy_api_HTTPHeader(in HTTPHeader, out *HTTPHeader, c *conversion.Cloner) error {
	out.Name = in.Name
	out.Value = in.Value
	return nil
}

func DeepCopy_api_Handler(in Handler, out *Handler, c *conversion.Cloner) error {
	if in.Exec != nil {
		in, out := in.Exec, &out.Exec
		*out = new(ExecAction)
		if err := DeepCopy_api_ExecAction(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.Exec = nil
	}
	if in.HTTPGet != nil {
		in, out := in.HTTPGet, &out.HTTPGet
		*out = new(HTTPGetAction)
		if err := DeepCopy_api_HTTPGetAction(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.HTTPGet = nil
	}
	if in.TCPSocket != nil {
		in, out := in.TCPSocket, &out.TCPSocket
		*out = new(TCPSocketAction)
		if err := DeepCopy_api_TCPSocketAction(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.TCPSocket = nil
	}
	return nil
}

func DeepCopy_api_HostPathVolumeSource(in HostPathVolumeSource, out *HostPathVolumeSource, c *conversion.Cloner) error {
	out.Path = in.Path
	return nil
}

func DeepCopy_api_ISCSIVolumeSource(in ISCSIVolumeSource, out *ISCSIVolumeSource, c *conversion.Cloner) error {
	out.TargetPortal = in.TargetPortal
	out.IQN = in.IQN
	out.Lun = in.Lun
	out.ISCSIInterface = in.ISCSIInterface
	out.FSType = in.FSType
	out.ReadOnly = in.ReadOnly
	return nil
}

func DeepCopy_api_KeyToPath(in KeyToPath, out *KeyToPath, c *conversion.Cloner) error {
	out.Key = in.Key
	out.Path = in.Path
	return nil
}

func DeepCopy_api_Lifecycle(in Lifecycle, out *Lifecycle, c *conversion.Cloner) error {
	if in.PostStart != nil {
		in, out := in.PostStart, &out.PostStart
		*out = new(Handler)
		if err := DeepCopy_api_Handler(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.PostStart = nil
	}
	if in.PreStop != nil {
		in, out := in.PreStop, &out.PreStop
		*out = new(Handler)
		if err := DeepCopy_api_Handler(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.PreStop = nil
	}
	return nil
}

func DeepCopy_api_LimitRange(in LimitRange, out *LimitRange, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_ObjectMeta(in.ObjectMeta, &out.ObjectMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_LimitRangeSpec(in.Spec, &out.Spec, c); err != nil {
		return err
	}
	return nil
}

func DeepCopy_api_LimitRangeItem(in LimitRangeItem, out *LimitRangeItem, c *conversion.Cloner) error {
	out.Type = in.Type
	if in.Max != nil {
		in, out := in.Max, &out.Max
		*out = make(ResourceList)
		for key, val := range in {
			newVal := new(resource.Quantity)
			if err := resource.DeepCopy_resource_Quantity(val, newVal, c); err != nil {
				return err
			}
			(*out)[key] = *newVal
		}
	} else {
		out.Max = nil
	}
	if in.Min != nil {
		in, out := in.Min, &out.Min
		*out = make(ResourceList)
		for key, val := range in {
			newVal := new(resource.Quantity)
			if err := resource.DeepCopy_resource_Quantity(val, newVal, c); err != nil {
				return err
			}
			(*out)[key] = *newVal
		}
	} else {
		out.Min = nil
	}
	if in.Default != nil {
		in, out := in.Default, &out.Default
		*out = make(ResourceList)
		for key, val := range in {
			newVal := new(resource.Quantity)
			if err := resource.DeepCopy_resource_Quantity(val, newVal, c); err != nil {
				return err
			}
			(*out)[key] = *newVal
		}
	} else {
		out.Default = nil
	}
	if in.DefaultRequest != nil {
		in, out := in.DefaultRequest, &out.DefaultRequest
		*out = make(ResourceList)
		for key, val := range in {
			newVal := new(resource.Quantity)
			if err := resource.DeepCopy_resource_Quantity(val, newVal, c); err != nil {
				return err
			}
			(*out)[key] = *newVal
		}
	} else {
		out.DefaultRequest = nil
	}
	if in.MaxLimitRequestRatio != nil {
		in, out := in.MaxLimitRequestRatio, &out.MaxLimitRequestRatio
		*out = make(ResourceList)
		for key, val := range in {
			newVal := new(resource.Quantity)
			if err := resource.DeepCopy_resource_Quantity(val, newVal, c); err != nil {
				return err
			}
			(*out)[key] = *newVal
		}
	} else {
		out.MaxLimitRequestRatio = nil
	}
	return nil
}

func DeepCopy_api_LimitRangeList(in LimitRangeList, out *LimitRangeList, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := unversioned.DeepCopy_unversioned_ListMeta(in.ListMeta, &out.ListMeta, c); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := in.Items, &out.Items
		*out = make([]LimitRange, len(in))
		for i := range in {
			if err := DeepCopy_api_LimitRange(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func DeepCopy_api_LimitRangeSpec(in LimitRangeSpec, out *LimitRangeSpec, c *conversion.Cloner) error {
	if in.Limits != nil {
		in, out := in.Limits, &out.Limits
		*out = make([]LimitRangeItem, len(in))
		for i := range in {
			if err := DeepCopy_api_LimitRangeItem(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Limits = nil
	}
	return nil
}

func DeepCopy_api_List(in List, out *List, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := unversioned.DeepCopy_unversioned_ListMeta(in.ListMeta, &out.ListMeta, c); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := in.Items, &out.Items
		*out = make([]runtime.Object, len(in))
		for i := range in {
			if newVal, err := c.DeepCopy(in[i]); err != nil {
				return err
			} else {
				(*out)[i] = newVal.(runtime.Object)
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func DeepCopy_api_ListOptions(in ListOptions, out *ListOptions, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if in.LabelSelector == nil {
		out.LabelSelector = nil
	} else if newVal, err := c.DeepCopy(in.LabelSelector); err != nil {
		return err
	} else {
		out.LabelSelector = newVal.(labels.Selector)
	}
	if in.FieldSelector == nil {
		out.FieldSelector = nil
	} else if newVal, err := c.DeepCopy(in.FieldSelector); err != nil {
		return err
	} else {
		out.FieldSelector = newVal.(fields.Selector)
	}
	out.Watch = in.Watch
	out.ResourceVersion = in.ResourceVersion
	if in.TimeoutSeconds != nil {
		in, out := in.TimeoutSeconds, &out.TimeoutSeconds
		*out = new(int64)
		**out = *in
	} else {
		out.TimeoutSeconds = nil
	}
	return nil
}

func DeepCopy_api_LoadBalancerIngress(in LoadBalancerIngress, out *LoadBalancerIngress, c *conversion.Cloner) error {
	out.IP = in.IP
	out.Hostname = in.Hostname
	return nil
}

func DeepCopy_api_LoadBalancerStatus(in LoadBalancerStatus, out *LoadBalancerStatus, c *conversion.Cloner) error {
	if in.Ingress != nil {
		in, out := in.Ingress, &out.Ingress
		*out = make([]LoadBalancerIngress, len(in))
		for i := range in {
			if err := DeepCopy_api_LoadBalancerIngress(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Ingress = nil
	}
	return nil
}

func DeepCopy_api_LocalObjectReference(in LocalObjectReference, out *LocalObjectReference, c *conversion.Cloner) error {
	out.Name = in.Name
	return nil
}

func DeepCopy_api_NFSVolumeSource(in NFSVolumeSource, out *NFSVolumeSource, c *conversion.Cloner) error {
	out.Server = in.Server
	out.Path = in.Path
	out.ReadOnly = in.ReadOnly
	return nil
}

func DeepCopy_api_Namespace(in Namespace, out *Namespace, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_ObjectMeta(in.ObjectMeta, &out.ObjectMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_NamespaceSpec(in.Spec, &out.Spec, c); err != nil {
		return err
	}
	if err := DeepCopy_api_NamespaceStatus(in.Status, &out.Status, c); err != nil {
		return err
	}
	return nil
}

func DeepCopy_api_NamespaceList(in NamespaceList, out *NamespaceList, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := unversioned.DeepCopy_unversioned_ListMeta(in.ListMeta, &out.ListMeta, c); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := in.Items, &out.Items
		*out = make([]Namespace, len(in))
		for i := range in {
			if err := DeepCopy_api_Namespace(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func DeepCopy_api_NamespaceSpec(in NamespaceSpec, out *NamespaceSpec, c *conversion.Cloner) error {
	if in.Finalizers != nil {
		in, out := in.Finalizers, &out.Finalizers
		*out = make([]FinalizerName, len(in))
		for i := range in {
			(*out)[i] = in[i]
		}
	} else {
		out.Finalizers = nil
	}
	return nil
}

func DeepCopy_api_NamespaceStatus(in NamespaceStatus, out *NamespaceStatus, c *conversion.Cloner) error {
	out.Phase = in.Phase
	return nil
}

func DeepCopy_api_Node(in Node, out *Node, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_ObjectMeta(in.ObjectMeta, &out.ObjectMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_NodeSpec(in.Spec, &out.Spec, c); err != nil {
		return err
	}
	if err := DeepCopy_api_NodeStatus(in.Status, &out.Status, c); err != nil {
		return err
	}
	return nil
}

func DeepCopy_api_NodeAddress(in NodeAddress, out *NodeAddress, c *conversion.Cloner) error {
	out.Type = in.Type
	out.Address = in.Address
	return nil
}

func DeepCopy_api_NodeAffinity(in NodeAffinity, out *NodeAffinity, c *conversion.Cloner) error {
	if in.RequiredDuringSchedulingIgnoredDuringExecution != nil {
		in, out := in.RequiredDuringSchedulingIgnoredDuringExecution, &out.RequiredDuringSchedulingIgnoredDuringExecution
		*out = new(NodeSelector)
		if err := DeepCopy_api_NodeSelector(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.RequiredDuringSchedulingIgnoredDuringExecution = nil
	}
	if in.PreferredDuringSchedulingIgnoredDuringExecution != nil {
		in, out := in.PreferredDuringSchedulingIgnoredDuringExecution, &out.PreferredDuringSchedulingIgnoredDuringExecution
		*out = make([]PreferredSchedulingTerm, len(in))
		for i := range in {
			if err := DeepCopy_api_PreferredSchedulingTerm(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.PreferredDuringSchedulingIgnoredDuringExecution = nil
	}
	return nil
}

func DeepCopy_api_NodeCondition(in NodeCondition, out *NodeCondition, c *conversion.Cloner) error {
	out.Type = in.Type
	out.Status = in.Status
	if err := unversioned.DeepCopy_unversioned_Time(in.LastHeartbeatTime, &out.LastHeartbeatTime, c); err != nil {
		return err
	}
	if err := unversioned.DeepCopy_unversioned_Time(in.LastTransitionTime, &out.LastTransitionTime, c); err != nil {
		return err
	}
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

func DeepCopy_api_NodeDaemonEndpoints(in NodeDaemonEndpoints, out *NodeDaemonEndpoints, c *conversion.Cloner) error {
	if err := DeepCopy_api_DaemonEndpoint(in.KubeletEndpoint, &out.KubeletEndpoint, c); err != nil {
		return err
	}
	return nil
}

func DeepCopy_api_NodeList(in NodeList, out *NodeList, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := unversioned.DeepCopy_unversioned_ListMeta(in.ListMeta, &out.ListMeta, c); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := in.Items, &out.Items
		*out = make([]Node, len(in))
		for i := range in {
			if err := DeepCopy_api_Node(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func DeepCopy_api_NodeProxyOptions(in NodeProxyOptions, out *NodeProxyOptions, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	out.Path = in.Path
	return nil
}

func DeepCopy_api_NodeResources(in NodeResources, out *NodeResources, c *conversion.Cloner) error {
	if in.Capacity != nil {
		in, out := in.Capacity, &out.Capacity
		*out = make(ResourceList)
		for key, val := range in {
			newVal := new(resource.Quantity)
			if err := resource.DeepCopy_resource_Quantity(val, newVal, c); err != nil {
				return err
			}
			(*out)[key] = *newVal
		}
	} else {
		out.Capacity = nil
	}
	return nil
}

func DeepCopy_api_NodeSelector(in NodeSelector, out *NodeSelector, c *conversion.Cloner) error {
	if in.NodeSelectorTerms != nil {
		in, out := in.NodeSelectorTerms, &out.NodeSelectorTerms
		*out = make([]NodeSelectorTerm, len(in))
		for i := range in {
			if err := DeepCopy_api_NodeSelectorTerm(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.NodeSelectorTerms = nil
	}
	return nil
}

func DeepCopy_api_NodeSelectorRequirement(in NodeSelectorRequirement, out *NodeSelectorRequirement, c *conversion.Cloner) error {
	out.Key = in.Key
	out.Operator = in.Operator
	if in.Values != nil {
		in, out := in.Values, &out.Values
		*out = make([]string, len(in))
		copy(*out, in)
	} else {
		out.Values = nil
	}
	return nil
}

func DeepCopy_api_NodeSelectorTerm(in NodeSelectorTerm, out *NodeSelectorTerm, c *conversion.Cloner) error {
	if in.MatchExpressions != nil {
		in, out := in.MatchExpressions, &out.MatchExpressions
		*out = make([]NodeSelectorRequirement, len(in))
		for i := range in {
			if err := DeepCopy_api_NodeSelectorRequirement(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.MatchExpressions = nil
	}
	return nil
}

func DeepCopy_api_NodeSpec(in NodeSpec, out *NodeSpec, c *conversion.Cloner) error {
	out.PodCIDR = in.PodCIDR
	out.ExternalID = in.ExternalID
	out.ProviderID = in.ProviderID
	out.Unschedulable = in.Unschedulable
	return nil
}

func DeepCopy_api_NodeStatus(in NodeStatus, out *NodeStatus, c *conversion.Cloner) error {
	if in.Capacity != nil {
		in, out := in.Capacity, &out.Capacity
		*out = make(ResourceList)
		for key, val := range in {
			newVal := new(resource.Quantity)
			if err := resource.DeepCopy_resource_Quantity(val, newVal, c); err != nil {
				return err
			}
			(*out)[key] = *newVal
		}
	} else {
		out.Capacity = nil
	}
	if in.Allocatable != nil {
		in, out := in.Allocatable, &out.Allocatable
		*out = make(ResourceList)
		for key, val := range in {
			newVal := new(resource.Quantity)
			if err := resource.DeepCopy_resource_Quantity(val, newVal, c); err != nil {
				return err
			}
			(*out)[key] = *newVal
		}
	} else {
		out.Allocatable = nil
	}
	out.Phase = in.Phase
	if in.Conditions != nil {
		in, out := in.Conditions, &out.Conditions
		*out = make([]NodeCondition, len(in))
		for i := range in {
			if err := DeepCopy_api_NodeCondition(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Conditions = nil
	}
	if in.Addresses != nil {
		in, out := in.Addresses, &out.Addresses
		*out = make([]NodeAddress, len(in))
		for i := range in {
			if err := DeepCopy_api_NodeAddress(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Addresses = nil
	}
	if err := DeepCopy_api_NodeDaemonEndpoints(in.DaemonEndpoints, &out.DaemonEndpoints, c); err != nil {
		return err
	}
	if err := DeepCopy_api_NodeSystemInfo(in.NodeInfo, &out.NodeInfo, c); err != nil {
		return err
	}
	if in.Images != nil {
		in, out := in.Images, &out.Images
		*out = make([]ContainerImage, len(in))
		for i := range in {
			if err := DeepCopy_api_ContainerImage(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Images = nil
	}
	if in.VolumesInUse != nil {
		in, out := in.VolumesInUse, &out.VolumesInUse
		*out = make([]UniqueVolumeName, len(in))
		for i := range in {
			(*out)[i] = in[i]
		}
	} else {
		out.VolumesInUse = nil
	}
	if in.VolumesAttached != nil {
		in, out := in.VolumesAttached, &out.VolumesAttached
		*out = make([]AttachedVolume, len(in))
		for i := range in {
			if err := DeepCopy_api_AttachedVolume(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.VolumesAttached = nil
	}
	return nil
}

func DeepCopy_api_NodeSystemInfo(in NodeSystemInfo, out *NodeSystemInfo, c *conversion.Cloner) error {
	out.MachineID = in.MachineID
	out.SystemUUID = in.SystemUUID
	out.BootID = in.BootID
	out.KernelVersion = in.KernelVersion
	out.OSImage = in.OSImage
	out.ContainerRuntimeVersion = in.ContainerRuntimeVersion
	out.KubeletVersion = in.KubeletVersion
	out.KubeProxyVersion = in.KubeProxyVersion
	out.OperatingSystem = in.OperatingSystem
	out.Architecture = in.Architecture
	return nil
}

func DeepCopy_api_ObjectFieldSelector(in ObjectFieldSelector, out *ObjectFieldSelector, c *conversion.Cloner) error {
	out.APIVersion = in.APIVersion
	out.FieldPath = in.FieldPath
	return nil
}

func DeepCopy_api_ObjectMeta(in ObjectMeta, out *ObjectMeta, c *conversion.Cloner) error {
	out.Name = in.Name
	out.GenerateName = in.GenerateName
	out.Namespace = in.Namespace
	out.SelfLink = in.SelfLink
	out.UID = in.UID
	out.ResourceVersion = in.ResourceVersion
	out.Generation = in.Generation
	if err := unversioned.DeepCopy_unversioned_Time(in.CreationTimestamp, &out.CreationTimestamp, c); err != nil {
		return err
	}
	if in.DeletionTimestamp != nil {
		in, out := in.DeletionTimestamp, &out.DeletionTimestamp
		*out = new(unversioned.Time)
		if err := unversioned.DeepCopy_unversioned_Time(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.DeletionTimestamp = nil
	}
	if in.DeletionGracePeriodSeconds != nil {
		in, out := in.DeletionGracePeriodSeconds, &out.DeletionGracePeriodSeconds
		*out = new(int64)
		**out = *in
	} else {
		out.DeletionGracePeriodSeconds = nil
	}
	if in.Labels != nil {
		in, out := in.Labels, &out.Labels
		*out = make(map[string]string)
		for key, val := range in {
			(*out)[key] = val
		}
	} else {
		out.Labels = nil
	}
	if in.Annotations != nil {
		in, out := in.Annotations, &out.Annotations
		*out = make(map[string]string)
		for key, val := range in {
			(*out)[key] = val
		}
	} else {
		out.Annotations = nil
	}
	if in.OwnerReferences != nil {
		in, out := in.OwnerReferences, &out.OwnerReferences
		*out = make([]OwnerReference, len(in))
		for i := range in {
			if err := DeepCopy_api_OwnerReference(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.OwnerReferences = nil
	}
	if in.Finalizers != nil {
		in, out := in.Finalizers, &out.Finalizers
		*out = make([]string, len(in))
		copy(*out, in)
	} else {
		out.Finalizers = nil
	}
	return nil
}

func DeepCopy_api_ObjectReference(in ObjectReference, out *ObjectReference, c *conversion.Cloner) error {
	out.Kind = in.Kind
	out.Namespace = in.Namespace
	out.Name = in.Name
	out.UID = in.UID
	out.APIVersion = in.APIVersion
	out.ResourceVersion = in.ResourceVersion
	out.FieldPath = in.FieldPath
	return nil
}

func DeepCopy_api_OwnerReference(in OwnerReference, out *OwnerReference, c *conversion.Cloner) error {
	out.APIVersion = in.APIVersion
	out.Kind = in.Kind
	out.Name = in.Name
	out.UID = in.UID
	if in.Controller != nil {
		in, out := in.Controller, &out.Controller
		*out = new(bool)
		**out = *in
	} else {
		out.Controller = nil
	}
	return nil
}

func DeepCopy_api_PersistentVolume(in PersistentVolume, out *PersistentVolume, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_ObjectMeta(in.ObjectMeta, &out.ObjectMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_PersistentVolumeSpec(in.Spec, &out.Spec, c); err != nil {
		return err
	}
	if err := DeepCopy_api_PersistentVolumeStatus(in.Status, &out.Status, c); err != nil {
		return err
	}
	return nil
}

func DeepCopy_api_PersistentVolumeClaim(in PersistentVolumeClaim, out *PersistentVolumeClaim, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_ObjectMeta(in.ObjectMeta, &out.ObjectMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_PersistentVolumeClaimSpec(in.Spec, &out.Spec, c); err != nil {
		return err
	}
	if err := DeepCopy_api_PersistentVolumeClaimStatus(in.Status, &out.Status, c); err != nil {
		return err
	}
	return nil
}

func DeepCopy_api_PersistentVolumeClaimList(in PersistentVolumeClaimList, out *PersistentVolumeClaimList, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := unversioned.DeepCopy_unversioned_ListMeta(in.ListMeta, &out.ListMeta, c); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := in.Items, &out.Items
		*out = make([]PersistentVolumeClaim, len(in))
		for i := range in {
			if err := DeepCopy_api_PersistentVolumeClaim(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func DeepCopy_api_PersistentVolumeClaimSpec(in PersistentVolumeClaimSpec, out *PersistentVolumeClaimSpec, c *conversion.Cloner) error {
	if in.AccessModes != nil {
		in, out := in.AccessModes, &out.AccessModes
		*out = make([]PersistentVolumeAccessMode, len(in))
		for i := range in {
			(*out)[i] = in[i]
		}
	} else {
		out.AccessModes = nil
	}
	if in.Selector != nil {
		in, out := in.Selector, &out.Selector
		*out = new(unversioned.LabelSelector)
		if err := unversioned.DeepCopy_unversioned_LabelSelector(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.Selector = nil
	}
	if err := DeepCopy_api_ResourceRequirements(in.Resources, &out.Resources, c); err != nil {
		return err
	}
	out.VolumeName = in.VolumeName
	return nil
}

func DeepCopy_api_PersistentVolumeClaimStatus(in PersistentVolumeClaimStatus, out *PersistentVolumeClaimStatus, c *conversion.Cloner) error {
	out.Phase = in.Phase
	if in.AccessModes != nil {
		in, out := in.AccessModes, &out.AccessModes
		*out = make([]PersistentVolumeAccessMode, len(in))
		for i := range in {
			(*out)[i] = in[i]
		}
	} else {
		out.AccessModes = nil
	}
	if in.Capacity != nil {
		in, out := in.Capacity, &out.Capacity
		*out = make(ResourceList)
		for key, val := range in {
			newVal := new(resource.Quantity)
			if err := resource.DeepCopy_resource_Quantity(val, newVal, c); err != nil {
				return err
			}
			(*out)[key] = *newVal
		}
	} else {
		out.Capacity = nil
	}
	return nil
}

func DeepCopy_api_PersistentVolumeClaimVolumeSource(in PersistentVolumeClaimVolumeSource, out *PersistentVolumeClaimVolumeSource, c *conversion.Cloner) error {
	out.ClaimName = in.ClaimName
	out.ReadOnly = in.ReadOnly
	return nil
}

func DeepCopy_api_PersistentVolumeList(in PersistentVolumeList, out *PersistentVolumeList, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := unversioned.DeepCopy_unversioned_ListMeta(in.ListMeta, &out.ListMeta, c); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := in.Items, &out.Items
		*out = make([]PersistentVolume, len(in))
		for i := range in {
			if err := DeepCopy_api_PersistentVolume(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func DeepCopy_api_PersistentVolumeSource(in PersistentVolumeSource, out *PersistentVolumeSource, c *conversion.Cloner) error {
	if in.GCEPersistentDisk != nil {
		in, out := in.GCEPersistentDisk, &out.GCEPersistentDisk
		*out = new(GCEPersistentDiskVolumeSource)
		if err := DeepCopy_api_GCEPersistentDiskVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.GCEPersistentDisk = nil
	}
	if in.AWSElasticBlockStore != nil {
		in, out := in.AWSElasticBlockStore, &out.AWSElasticBlockStore
		*out = new(AWSElasticBlockStoreVolumeSource)
		if err := DeepCopy_api_AWSElasticBlockStoreVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.AWSElasticBlockStore = nil
	}
	if in.HostPath != nil {
		in, out := in.HostPath, &out.HostPath
		*out = new(HostPathVolumeSource)
		if err := DeepCopy_api_HostPathVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.HostPath = nil
	}
	if in.Glusterfs != nil {
		in, out := in.Glusterfs, &out.Glusterfs
		*out = new(GlusterfsVolumeSource)
		if err := DeepCopy_api_GlusterfsVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.Glusterfs = nil
	}
	if in.NFS != nil {
		in, out := in.NFS, &out.NFS
		*out = new(NFSVolumeSource)
		if err := DeepCopy_api_NFSVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.NFS = nil
	}
	if in.RBD != nil {
		in, out := in.RBD, &out.RBD
		*out = new(RBDVolumeSource)
		if err := DeepCopy_api_RBDVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.RBD = nil
	}
	if in.ISCSI != nil {
		in, out := in.ISCSI, &out.ISCSI
		*out = new(ISCSIVolumeSource)
		if err := DeepCopy_api_ISCSIVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.ISCSI = nil
	}
	if in.FlexVolume != nil {
		in, out := in.FlexVolume, &out.FlexVolume
		*out = new(FlexVolumeSource)
		if err := DeepCopy_api_FlexVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.FlexVolume = nil
	}
	if in.Cinder != nil {
		in, out := in.Cinder, &out.Cinder
		*out = new(CinderVolumeSource)
		if err := DeepCopy_api_CinderVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.Cinder = nil
	}
	if in.CephFS != nil {
		in, out := in.CephFS, &out.CephFS
		*out = new(CephFSVolumeSource)
		if err := DeepCopy_api_CephFSVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.CephFS = nil
	}
	if in.FC != nil {
		in, out := in.FC, &out.FC
		*out = new(FCVolumeSource)
		if err := DeepCopy_api_FCVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.FC = nil
	}
	if in.Flocker != nil {
		in, out := in.Flocker, &out.Flocker
		*out = new(FlockerVolumeSource)
		if err := DeepCopy_api_FlockerVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.Flocker = nil
	}
	if in.AzureFile != nil {
		in, out := in.AzureFile, &out.AzureFile
		*out = new(AzureFileVolumeSource)
		if err := DeepCopy_api_AzureFileVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.AzureFile = nil
	}
	if in.VsphereVolume != nil {
		in, out := in.VsphereVolume, &out.VsphereVolume
		*out = new(VsphereVirtualDiskVolumeSource)
		if err := DeepCopy_api_VsphereVirtualDiskVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.VsphereVolume = nil
	}
	return nil
}

func DeepCopy_api_PersistentVolumeSpec(in PersistentVolumeSpec, out *PersistentVolumeSpec, c *conversion.Cloner) error {
	if in.Capacity != nil {
		in, out := in.Capacity, &out.Capacity
		*out = make(ResourceList)
		for key, val := range in {
			newVal := new(resource.Quantity)
			if err := resource.DeepCopy_resource_Quantity(val, newVal, c); err != nil {
				return err
			}
			(*out)[key] = *newVal
		}
	} else {
		out.Capacity = nil
	}
	if err := DeepCopy_api_PersistentVolumeSource(in.PersistentVolumeSource, &out.PersistentVolumeSource, c); err != nil {
		return err
	}
	if in.AccessModes != nil {
		in, out := in.AccessModes, &out.AccessModes
		*out = make([]PersistentVolumeAccessMode, len(in))
		for i := range in {
			(*out)[i] = in[i]
		}
	} else {
		out.AccessModes = nil
	}
	if in.ClaimRef != nil {
		in, out := in.ClaimRef, &out.ClaimRef
		*out = new(ObjectReference)
		if err := DeepCopy_api_ObjectReference(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.ClaimRef = nil
	}
	out.PersistentVolumeReclaimPolicy = in.PersistentVolumeReclaimPolicy
	return nil
}

func DeepCopy_api_PersistentVolumeStatus(in PersistentVolumeStatus, out *PersistentVolumeStatus, c *conversion.Cloner) error {
	out.Phase = in.Phase
	out.Message = in.Message
	out.Reason = in.Reason
	return nil
}

func DeepCopy_api_Pod(in Pod, out *Pod, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_ObjectMeta(in.ObjectMeta, &out.ObjectMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_PodSpec(in.Spec, &out.Spec, c); err != nil {
		return err
	}
	if err := DeepCopy_api_PodStatus(in.Status, &out.Status, c); err != nil {
		return err
	}
	return nil
}

func DeepCopy_api_PodAffinity(in PodAffinity, out *PodAffinity, c *conversion.Cloner) error {
	if in.RequiredDuringSchedulingIgnoredDuringExecution != nil {
		in, out := in.RequiredDuringSchedulingIgnoredDuringExecution, &out.RequiredDuringSchedulingIgnoredDuringExecution
		*out = make([]PodAffinityTerm, len(in))
		for i := range in {
			if err := DeepCopy_api_PodAffinityTerm(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.RequiredDuringSchedulingIgnoredDuringExecution = nil
	}
	if in.PreferredDuringSchedulingIgnoredDuringExecution != nil {
		in, out := in.PreferredDuringSchedulingIgnoredDuringExecution, &out.PreferredDuringSchedulingIgnoredDuringExecution
		*out = make([]WeightedPodAffinityTerm, len(in))
		for i := range in {
			if err := DeepCopy_api_WeightedPodAffinityTerm(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.PreferredDuringSchedulingIgnoredDuringExecution = nil
	}
	return nil
}

func DeepCopy_api_PodAffinityTerm(in PodAffinityTerm, out *PodAffinityTerm, c *conversion.Cloner) error {
	if in.LabelSelector != nil {
		in, out := in.LabelSelector, &out.LabelSelector
		*out = new(unversioned.LabelSelector)
		if err := unversioned.DeepCopy_unversioned_LabelSelector(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.LabelSelector = nil
	}
	if in.Namespaces != nil {
		in, out := in.Namespaces, &out.Namespaces
		*out = make([]string, len(in))
		copy(*out, in)
	} else {
		out.Namespaces = nil
	}
	out.TopologyKey = in.TopologyKey
	return nil
}

func DeepCopy_api_PodAntiAffinity(in PodAntiAffinity, out *PodAntiAffinity, c *conversion.Cloner) error {
	if in.RequiredDuringSchedulingIgnoredDuringExecution != nil {
		in, out := in.RequiredDuringSchedulingIgnoredDuringExecution, &out.RequiredDuringSchedulingIgnoredDuringExecution
		*out = make([]PodAffinityTerm, len(in))
		for i := range in {
			if err := DeepCopy_api_PodAffinityTerm(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.RequiredDuringSchedulingIgnoredDuringExecution = nil
	}
	if in.PreferredDuringSchedulingIgnoredDuringExecution != nil {
		in, out := in.PreferredDuringSchedulingIgnoredDuringExecution, &out.PreferredDuringSchedulingIgnoredDuringExecution
		*out = make([]WeightedPodAffinityTerm, len(in))
		for i := range in {
			if err := DeepCopy_api_WeightedPodAffinityTerm(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.PreferredDuringSchedulingIgnoredDuringExecution = nil
	}
	return nil
}

func DeepCopy_api_PodAttachOptions(in PodAttachOptions, out *PodAttachOptions, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	out.Stdin = in.Stdin
	out.Stdout = in.Stdout
	out.Stderr = in.Stderr
	out.TTY = in.TTY
	out.Container = in.Container
	return nil
}

func DeepCopy_api_PodCondition(in PodCondition, out *PodCondition, c *conversion.Cloner) error {
	out.Type = in.Type
	out.Status = in.Status
	if err := unversioned.DeepCopy_unversioned_Time(in.LastProbeTime, &out.LastProbeTime, c); err != nil {
		return err
	}
	if err := unversioned.DeepCopy_unversioned_Time(in.LastTransitionTime, &out.LastTransitionTime, c); err != nil {
		return err
	}
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

func DeepCopy_api_PodExecOptions(in PodExecOptions, out *PodExecOptions, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	out.Stdin = in.Stdin
	out.Stdout = in.Stdout
	out.Stderr = in.Stderr
	out.TTY = in.TTY
	out.Container = in.Container
	if in.Command != nil {
		in, out := in.Command, &out.Command
		*out = make([]string, len(in))
		copy(*out, in)
	} else {
		out.Command = nil
	}
	return nil
}

func DeepCopy_api_PodList(in PodList, out *PodList, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := unversioned.DeepCopy_unversioned_ListMeta(in.ListMeta, &out.ListMeta, c); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := in.Items, &out.Items
		*out = make([]Pod, len(in))
		for i := range in {
			if err := DeepCopy_api_Pod(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func DeepCopy_api_PodLogOptions(in PodLogOptions, out *PodLogOptions, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	out.Container = in.Container
	out.Follow = in.Follow
	out.Previous = in.Previous
	if in.SinceSeconds != nil {
		in, out := in.SinceSeconds, &out.SinceSeconds
		*out = new(int64)
		**out = *in
	} else {
		out.SinceSeconds = nil
	}
	if in.SinceTime != nil {
		in, out := in.SinceTime, &out.SinceTime
		*out = new(unversioned.Time)
		if err := unversioned.DeepCopy_unversioned_Time(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.SinceTime = nil
	}
	out.Timestamps = in.Timestamps
	if in.TailLines != nil {
		in, out := in.TailLines, &out.TailLines
		*out = new(int64)
		**out = *in
	} else {
		out.TailLines = nil
	}
	if in.LimitBytes != nil {
		in, out := in.LimitBytes, &out.LimitBytes
		*out = new(int64)
		**out = *in
	} else {
		out.LimitBytes = nil
	}
	return nil
}

func DeepCopy_api_PodProxyOptions(in PodProxyOptions, out *PodProxyOptions, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	out.Path = in.Path
	return nil
}

func DeepCopy_api_PodSecurityContext(in PodSecurityContext, out *PodSecurityContext, c *conversion.Cloner) error {
	out.HostNetwork = in.HostNetwork
	out.HostPID = in.HostPID
	out.HostIPC = in.HostIPC
	if in.SELinuxOptions != nil {
		in, out := in.SELinuxOptions, &out.SELinuxOptions
		*out = new(SELinuxOptions)
		if err := DeepCopy_api_SELinuxOptions(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.SELinuxOptions = nil
	}
	if in.RunAsUser != nil {
		in, out := in.RunAsUser, &out.RunAsUser
		*out = new(int64)
		**out = *in
	} else {
		out.RunAsUser = nil
	}
	if in.RunAsNonRoot != nil {
		in, out := in.RunAsNonRoot, &out.RunAsNonRoot
		*out = new(bool)
		**out = *in
	} else {
		out.RunAsNonRoot = nil
	}
	if in.SupplementalGroups != nil {
		in, out := in.SupplementalGroups, &out.SupplementalGroups
		*out = make([]int64, len(in))
		copy(*out, in)
	} else {
		out.SupplementalGroups = nil
	}
	if in.FSGroup != nil {
		in, out := in.FSGroup, &out.FSGroup
		*out = new(int64)
		**out = *in
	} else {
		out.FSGroup = nil
	}
	return nil
}

func DeepCopy_api_PodSpec(in PodSpec, out *PodSpec, c *conversion.Cloner) error {
	if in.Volumes != nil {
		in, out := in.Volumes, &out.Volumes
		*out = make([]Volume, len(in))
		for i := range in {
			if err := DeepCopy_api_Volume(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Volumes = nil
	}
	if in.InitContainers != nil {
		in, out := in.InitContainers, &out.InitContainers
		*out = make([]Container, len(in))
		for i := range in {
			if err := DeepCopy_api_Container(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.InitContainers = nil
	}
	if in.Containers != nil {
		in, out := in.Containers, &out.Containers
		*out = make([]Container, len(in))
		for i := range in {
			if err := DeepCopy_api_Container(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Containers = nil
	}
	out.RestartPolicy = in.RestartPolicy
	if in.TerminationGracePeriodSeconds != nil {
		in, out := in.TerminationGracePeriodSeconds, &out.TerminationGracePeriodSeconds
		*out = new(int64)
		**out = *in
	} else {
		out.TerminationGracePeriodSeconds = nil
	}
	if in.ActiveDeadlineSeconds != nil {
		in, out := in.ActiveDeadlineSeconds, &out.ActiveDeadlineSeconds
		*out = new(int64)
		**out = *in
	} else {
		out.ActiveDeadlineSeconds = nil
	}
	out.DNSPolicy = in.DNSPolicy
	if in.NodeSelector != nil {
		in, out := in.NodeSelector, &out.NodeSelector
		*out = make(map[string]string)
		for key, val := range in {
			(*out)[key] = val
		}
	} else {
		out.NodeSelector = nil
	}
	out.ServiceAccountName = in.ServiceAccountName
	out.NodeName = in.NodeName
	if in.SecurityContext != nil {
		in, out := in.SecurityContext, &out.SecurityContext
		*out = new(PodSecurityContext)
		if err := DeepCopy_api_PodSecurityContext(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.SecurityContext = nil
	}
	if in.ImagePullSecrets != nil {
		in, out := in.ImagePullSecrets, &out.ImagePullSecrets
		*out = make([]LocalObjectReference, len(in))
		for i := range in {
			if err := DeepCopy_api_LocalObjectReference(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.ImagePullSecrets = nil
	}
	out.Hostname = in.Hostname
	out.Subdomain = in.Subdomain
	return nil
}

func DeepCopy_api_PodStatus(in PodStatus, out *PodStatus, c *conversion.Cloner) error {
	out.Phase = in.Phase
	if in.Conditions != nil {
		in, out := in.Conditions, &out.Conditions
		*out = make([]PodCondition, len(in))
		for i := range in {
			if err := DeepCopy_api_PodCondition(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Conditions = nil
	}
	out.Message = in.Message
	out.Reason = in.Reason
	out.HostIP = in.HostIP
	out.PodIP = in.PodIP
	if in.StartTime != nil {
		in, out := in.StartTime, &out.StartTime
		*out = new(unversioned.Time)
		if err := unversioned.DeepCopy_unversioned_Time(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.StartTime = nil
	}
	if in.InitContainerStatuses != nil {
		in, out := in.InitContainerStatuses, &out.InitContainerStatuses
		*out = make([]ContainerStatus, len(in))
		for i := range in {
			if err := DeepCopy_api_ContainerStatus(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.InitContainerStatuses = nil
	}
	if in.ContainerStatuses != nil {
		in, out := in.ContainerStatuses, &out.ContainerStatuses
		*out = make([]ContainerStatus, len(in))
		for i := range in {
			if err := DeepCopy_api_ContainerStatus(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.ContainerStatuses = nil
	}
	return nil
}

func DeepCopy_api_PodStatusResult(in PodStatusResult, out *PodStatusResult, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_ObjectMeta(in.ObjectMeta, &out.ObjectMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_PodStatus(in.Status, &out.Status, c); err != nil {
		return err
	}
	return nil
}

func DeepCopy_api_PodTemplate(in PodTemplate, out *PodTemplate, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_ObjectMeta(in.ObjectMeta, &out.ObjectMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_PodTemplateSpec(in.Template, &out.Template, c); err != nil {
		return err
	}
	return nil
}

func DeepCopy_api_PodTemplateList(in PodTemplateList, out *PodTemplateList, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := unversioned.DeepCopy_unversioned_ListMeta(in.ListMeta, &out.ListMeta, c); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := in.Items, &out.Items
		*out = make([]PodTemplate, len(in))
		for i := range in {
			if err := DeepCopy_api_PodTemplate(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func DeepCopy_api_PodTemplateSpec(in PodTemplateSpec, out *PodTemplateSpec, c *conversion.Cloner) error {
	if err := DeepCopy_api_ObjectMeta(in.ObjectMeta, &out.ObjectMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_PodSpec(in.Spec, &out.Spec, c); err != nil {
		return err
	}
	return nil
}

func DeepCopy_api_Preconditions(in Preconditions, out *Preconditions, c *conversion.Cloner) error {
	if in.UID != nil {
		in, out := in.UID, &out.UID
		*out = new(types.UID)
		**out = *in
	} else {
		out.UID = nil
	}
	return nil
}

func DeepCopy_api_PreferredSchedulingTerm(in PreferredSchedulingTerm, out *PreferredSchedulingTerm, c *conversion.Cloner) error {
	out.Weight = in.Weight
	if err := DeepCopy_api_NodeSelectorTerm(in.Preference, &out.Preference, c); err != nil {
		return err
	}
	return nil
}

func DeepCopy_api_Probe(in Probe, out *Probe, c *conversion.Cloner) error {
	if err := DeepCopy_api_Handler(in.Handler, &out.Handler, c); err != nil {
		return err
	}
	out.InitialDelaySeconds = in.InitialDelaySeconds
	out.TimeoutSeconds = in.TimeoutSeconds
	out.PeriodSeconds = in.PeriodSeconds
	out.SuccessThreshold = in.SuccessThreshold
	out.FailureThreshold = in.FailureThreshold
	return nil
}

func DeepCopy_api_RBDVolumeSource(in RBDVolumeSource, out *RBDVolumeSource, c *conversion.Cloner) error {
	if in.CephMonitors != nil {
		in, out := in.CephMonitors, &out.CephMonitors
		*out = make([]string, len(in))
		copy(*out, in)
	} else {
		out.CephMonitors = nil
	}
	out.RBDImage = in.RBDImage
	out.FSType = in.FSType
	out.RBDPool = in.RBDPool
	out.RadosUser = in.RadosUser
	out.Keyring = in.Keyring
	if in.SecretRef != nil {
		in, out := in.SecretRef, &out.SecretRef
		*out = new(LocalObjectReference)
		if err := DeepCopy_api_LocalObjectReference(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.SecretRef = nil
	}
	out.ReadOnly = in.ReadOnly
	return nil
}

func DeepCopy_api_RangeAllocation(in RangeAllocation, out *RangeAllocation, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_ObjectMeta(in.ObjectMeta, &out.ObjectMeta, c); err != nil {
		return err
	}
	out.Range = in.Range
	if in.Data != nil {
		in, out := in.Data, &out.Data
		*out = make([]byte, len(in))
		copy(*out, in)
	} else {
		out.Data = nil
	}
	return nil
}

func DeepCopy_api_ReplicationController(in ReplicationController, out *ReplicationController, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_ObjectMeta(in.ObjectMeta, &out.ObjectMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_ReplicationControllerSpec(in.Spec, &out.Spec, c); err != nil {
		return err
	}
	if err := DeepCopy_api_ReplicationControllerStatus(in.Status, &out.Status, c); err != nil {
		return err
	}
	return nil
}

func DeepCopy_api_ReplicationControllerList(in ReplicationControllerList, out *ReplicationControllerList, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := unversioned.DeepCopy_unversioned_ListMeta(in.ListMeta, &out.ListMeta, c); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := in.Items, &out.Items
		*out = make([]ReplicationController, len(in))
		for i := range in {
			if err := DeepCopy_api_ReplicationController(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func DeepCopy_api_ReplicationControllerSpec(in ReplicationControllerSpec, out *ReplicationControllerSpec, c *conversion.Cloner) error {
	out.Replicas = in.Replicas
	if in.Selector != nil {
		in, out := in.Selector, &out.Selector
		*out = make(map[string]string)
		for key, val := range in {
			(*out)[key] = val
		}
	} else {
		out.Selector = nil
	}
	if in.Template != nil {
		in, out := in.Template, &out.Template
		*out = new(PodTemplateSpec)
		if err := DeepCopy_api_PodTemplateSpec(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.Template = nil
	}
	return nil
}

func DeepCopy_api_ReplicationControllerStatus(in ReplicationControllerStatus, out *ReplicationControllerStatus, c *conversion.Cloner) error {
	out.Replicas = in.Replicas
	out.FullyLabeledReplicas = in.FullyLabeledReplicas
	out.ObservedGeneration = in.ObservedGeneration
	return nil
}

func DeepCopy_api_ResourceFieldSelector(in ResourceFieldSelector, out *ResourceFieldSelector, c *conversion.Cloner) error {
	out.ContainerName = in.ContainerName
	out.Resource = in.Resource
	if err := resource.DeepCopy_resource_Quantity(in.Divisor, &out.Divisor, c); err != nil {
		return err
	}
	return nil
}

func DeepCopy_api_ResourceQuota(in ResourceQuota, out *ResourceQuota, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_ObjectMeta(in.ObjectMeta, &out.ObjectMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_ResourceQuotaSpec(in.Spec, &out.Spec, c); err != nil {
		return err
	}
	if err := DeepCopy_api_ResourceQuotaStatus(in.Status, &out.Status, c); err != nil {
		return err
	}
	return nil
}

func DeepCopy_api_ResourceQuotaList(in ResourceQuotaList, out *ResourceQuotaList, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := unversioned.DeepCopy_unversioned_ListMeta(in.ListMeta, &out.ListMeta, c); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := in.Items, &out.Items
		*out = make([]ResourceQuota, len(in))
		for i := range in {
			if err := DeepCopy_api_ResourceQuota(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func DeepCopy_api_ResourceQuotaSpec(in ResourceQuotaSpec, out *ResourceQuotaSpec, c *conversion.Cloner) error {
	if in.Hard != nil {
		in, out := in.Hard, &out.Hard
		*out = make(ResourceList)
		for key, val := range in {
			newVal := new(resource.Quantity)
			if err := resource.DeepCopy_resource_Quantity(val, newVal, c); err != nil {
				return err
			}
			(*out)[key] = *newVal
		}
	} else {
		out.Hard = nil
	}
	if in.Scopes != nil {
		in, out := in.Scopes, &out.Scopes
		*out = make([]ResourceQuotaScope, len(in))
		for i := range in {
			(*out)[i] = in[i]
		}
	} else {
		out.Scopes = nil
	}
	return nil
}

func DeepCopy_api_ResourceQuotaStatus(in ResourceQuotaStatus, out *ResourceQuotaStatus, c *conversion.Cloner) error {
	if in.Hard != nil {
		in, out := in.Hard, &out.Hard
		*out = make(ResourceList)
		for key, val := range in {
			newVal := new(resource.Quantity)
			if err := resource.DeepCopy_resource_Quantity(val, newVal, c); err != nil {
				return err
			}
			(*out)[key] = *newVal
		}
	} else {
		out.Hard = nil
	}
	if in.Used != nil {
		in, out := in.Used, &out.Used
		*out = make(ResourceList)
		for key, val := range in {
			newVal := new(resource.Quantity)
			if err := resource.DeepCopy_resource_Quantity(val, newVal, c); err != nil {
				return err
			}
			(*out)[key] = *newVal
		}
	} else {
		out.Used = nil
	}
	return nil
}

func DeepCopy_api_ResourceRequirements(in ResourceRequirements, out *ResourceRequirements, c *conversion.Cloner) error {
	if in.Limits != nil {
		in, out := in.Limits, &out.Limits
		*out = make(ResourceList)
		for key, val := range in {
			newVal := new(resource.Quantity)
			if err := resource.DeepCopy_resource_Quantity(val, newVal, c); err != nil {
				return err
			}
			(*out)[key] = *newVal
		}
	} else {
		out.Limits = nil
	}
	if in.Requests != nil {
		in, out := in.Requests, &out.Requests
		*out = make(ResourceList)
		for key, val := range in {
			newVal := new(resource.Quantity)
			if err := resource.DeepCopy_resource_Quantity(val, newVal, c); err != nil {
				return err
			}
			(*out)[key] = *newVal
		}
	} else {
		out.Requests = nil
	}
	return nil
}

func DeepCopy_api_SELinuxOptions(in SELinuxOptions, out *SELinuxOptions, c *conversion.Cloner) error {
	out.User = in.User
	out.Role = in.Role
	out.Type = in.Type
	out.Level = in.Level
	return nil
}

func DeepCopy_api_Secret(in Secret, out *Secret, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_ObjectMeta(in.ObjectMeta, &out.ObjectMeta, c); err != nil {
		return err
	}
	if in.Data != nil {
		in, out := in.Data, &out.Data
		*out = make(map[string][]byte)
		for key, val := range in {
			if newVal, err := c.DeepCopy(val); err != nil {
				return err
			} else {
				(*out)[key] = newVal.([]byte)
			}
		}
	} else {
		out.Data = nil
	}
	out.Type = in.Type
	return nil
}

func DeepCopy_api_SecretKeySelector(in SecretKeySelector, out *SecretKeySelector, c *conversion.Cloner) error {
	if err := DeepCopy_api_LocalObjectReference(in.LocalObjectReference, &out.LocalObjectReference, c); err != nil {
		return err
	}
	out.Key = in.Key
	return nil
}

func DeepCopy_api_SecretList(in SecretList, out *SecretList, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := unversioned.DeepCopy_unversioned_ListMeta(in.ListMeta, &out.ListMeta, c); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := in.Items, &out.Items
		*out = make([]Secret, len(in))
		for i := range in {
			if err := DeepCopy_api_Secret(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func DeepCopy_api_SecretVolumeSource(in SecretVolumeSource, out *SecretVolumeSource, c *conversion.Cloner) error {
	out.SecretName = in.SecretName
	if in.Items != nil {
		in, out := in.Items, &out.Items
		*out = make([]KeyToPath, len(in))
		for i := range in {
			if err := DeepCopy_api_KeyToPath(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func DeepCopy_api_SecurityContext(in SecurityContext, out *SecurityContext, c *conversion.Cloner) error {
	if in.Capabilities != nil {
		in, out := in.Capabilities, &out.Capabilities
		*out = new(Capabilities)
		if err := DeepCopy_api_Capabilities(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.Capabilities = nil
	}
	if in.Privileged != nil {
		in, out := in.Privileged, &out.Privileged
		*out = new(bool)
		**out = *in
	} else {
		out.Privileged = nil
	}
	if in.SELinuxOptions != nil {
		in, out := in.SELinuxOptions, &out.SELinuxOptions
		*out = new(SELinuxOptions)
		if err := DeepCopy_api_SELinuxOptions(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.SELinuxOptions = nil
	}
	if in.RunAsUser != nil {
		in, out := in.RunAsUser, &out.RunAsUser
		*out = new(int64)
		**out = *in
	} else {
		out.RunAsUser = nil
	}
	if in.RunAsNonRoot != nil {
		in, out := in.RunAsNonRoot, &out.RunAsNonRoot
		*out = new(bool)
		**out = *in
	} else {
		out.RunAsNonRoot = nil
	}
	if in.ReadOnlyRootFilesystem != nil {
		in, out := in.ReadOnlyRootFilesystem, &out.ReadOnlyRootFilesystem
		*out = new(bool)
		**out = *in
	} else {
		out.ReadOnlyRootFilesystem = nil
	}
	return nil
}

func DeepCopy_api_SerializedReference(in SerializedReference, out *SerializedReference, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_ObjectReference(in.Reference, &out.Reference, c); err != nil {
		return err
	}
	return nil
}

func DeepCopy_api_Service(in Service, out *Service, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_ObjectMeta(in.ObjectMeta, &out.ObjectMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_ServiceSpec(in.Spec, &out.Spec, c); err != nil {
		return err
	}
	if err := DeepCopy_api_ServiceStatus(in.Status, &out.Status, c); err != nil {
		return err
	}
	return nil
}

func DeepCopy_api_ServiceAccount(in ServiceAccount, out *ServiceAccount, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := DeepCopy_api_ObjectMeta(in.ObjectMeta, &out.ObjectMeta, c); err != nil {
		return err
	}
	if in.Secrets != nil {
		in, out := in.Secrets, &out.Secrets
		*out = make([]ObjectReference, len(in))
		for i := range in {
			if err := DeepCopy_api_ObjectReference(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Secrets = nil
	}
	if in.ImagePullSecrets != nil {
		in, out := in.ImagePullSecrets, &out.ImagePullSecrets
		*out = make([]LocalObjectReference, len(in))
		for i := range in {
			if err := DeepCopy_api_LocalObjectReference(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.ImagePullSecrets = nil
	}
	return nil
}

func DeepCopy_api_ServiceAccountList(in ServiceAccountList, out *ServiceAccountList, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := unversioned.DeepCopy_unversioned_ListMeta(in.ListMeta, &out.ListMeta, c); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := in.Items, &out.Items
		*out = make([]ServiceAccount, len(in))
		for i := range in {
			if err := DeepCopy_api_ServiceAccount(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func DeepCopy_api_ServiceList(in ServiceList, out *ServiceList, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	if err := unversioned.DeepCopy_unversioned_ListMeta(in.ListMeta, &out.ListMeta, c); err != nil {
		return err
	}
	if in.Items != nil {
		in, out := in.Items, &out.Items
		*out = make([]Service, len(in))
		for i := range in {
			if err := DeepCopy_api_Service(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

func DeepCopy_api_ServicePort(in ServicePort, out *ServicePort, c *conversion.Cloner) error {
	out.Name = in.Name
	out.Protocol = in.Protocol
	out.Port = in.Port
	if err := intstr.DeepCopy_intstr_IntOrString(in.TargetPort, &out.TargetPort, c); err != nil {
		return err
	}
	out.NodePort = in.NodePort
	return nil
}

func DeepCopy_api_ServiceProxyOptions(in ServiceProxyOptions, out *ServiceProxyOptions, c *conversion.Cloner) error {
	if err := unversioned.DeepCopy_unversioned_TypeMeta(in.TypeMeta, &out.TypeMeta, c); err != nil {
		return err
	}
	out.Path = in.Path
	return nil
}

func DeepCopy_api_ServiceSpec(in ServiceSpec, out *ServiceSpec, c *conversion.Cloner) error {
	out.Type = in.Type
	if in.Ports != nil {
		in, out := in.Ports, &out.Ports
		*out = make([]ServicePort, len(in))
		for i := range in {
			if err := DeepCopy_api_ServicePort(in[i], &(*out)[i], c); err != nil {
				return err
			}
		}
	} else {
		out.Ports = nil
	}
	if in.Selector != nil {
		in, out := in.Selector, &out.Selector
		*out = make(map[string]string)
		for key, val := range in {
			(*out)[key] = val
		}
	} else {
		out.Selector = nil
	}
	out.ClusterIP = in.ClusterIP
	if in.ExternalIPs != nil {
		in, out := in.ExternalIPs, &out.ExternalIPs
		*out = make([]string, len(in))
		copy(*out, in)
	} else {
		out.ExternalIPs = nil
	}
	out.LoadBalancerIP = in.LoadBalancerIP
	out.SessionAffinity = in.SessionAffinity
	if in.LoadBalancerSourceRanges != nil {
		in, out := in.LoadBalancerSourceRanges, &out.LoadBalancerSourceRanges
		*out = make([]string, len(in))
		copy(*out, in)
	} else {
		out.LoadBalancerSourceRanges = nil
	}
	return nil
}

func DeepCopy_api_ServiceStatus(in ServiceStatus, out *ServiceStatus, c *conversion.Cloner) error {
	if err := DeepCopy_api_LoadBalancerStatus(in.LoadBalancer, &out.LoadBalancer, c); err != nil {
		return err
	}
	return nil
}

func DeepCopy_api_TCPSocketAction(in TCPSocketAction, out *TCPSocketAction, c *conversion.Cloner) error {
	if err := intstr.DeepCopy_intstr_IntOrString(in.Port, &out.Port, c); err != nil {
		return err
	}
	return nil
}

func DeepCopy_api_Taint(in Taint, out *Taint, c *conversion.Cloner) error {
	out.Key = in.Key
	out.Value = in.Value
	out.Effect = in.Effect
	return nil
}

func DeepCopy_api_Toleration(in Toleration, out *Toleration, c *conversion.Cloner) error {
	out.Key = in.Key
	out.Operator = in.Operator
	out.Value = in.Value
	out.Effect = in.Effect
	return nil
}

func DeepCopy_api_Volume(in Volume, out *Volume, c *conversion.Cloner) error {
	out.Name = in.Name
	if err := DeepCopy_api_VolumeSource(in.VolumeSource, &out.VolumeSource, c); err != nil {
		return err
	}
	return nil
}

func DeepCopy_api_VolumeMount(in VolumeMount, out *VolumeMount, c *conversion.Cloner) error {
	out.Name = in.Name
	out.ReadOnly = in.ReadOnly
	out.MountPath = in.MountPath
	out.SubPath = in.SubPath
	return nil
}

func DeepCopy_api_VolumeSource(in VolumeSource, out *VolumeSource, c *conversion.Cloner) error {
	if in.HostPath != nil {
		in, out := in.HostPath, &out.HostPath
		*out = new(HostPathVolumeSource)
		if err := DeepCopy_api_HostPathVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.HostPath = nil
	}
	if in.EmptyDir != nil {
		in, out := in.EmptyDir, &out.EmptyDir
		*out = new(EmptyDirVolumeSource)
		if err := DeepCopy_api_EmptyDirVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.EmptyDir = nil
	}
	if in.GCEPersistentDisk != nil {
		in, out := in.GCEPersistentDisk, &out.GCEPersistentDisk
		*out = new(GCEPersistentDiskVolumeSource)
		if err := DeepCopy_api_GCEPersistentDiskVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.GCEPersistentDisk = nil
	}
	if in.AWSElasticBlockStore != nil {
		in, out := in.AWSElasticBlockStore, &out.AWSElasticBlockStore
		*out = new(AWSElasticBlockStoreVolumeSource)
		if err := DeepCopy_api_AWSElasticBlockStoreVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.AWSElasticBlockStore = nil
	}
	if in.GitRepo != nil {
		in, out := in.GitRepo, &out.GitRepo
		*out = new(GitRepoVolumeSource)
		if err := DeepCopy_api_GitRepoVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.GitRepo = nil
	}
	if in.Secret != nil {
		in, out := in.Secret, &out.Secret
		*out = new(SecretVolumeSource)
		if err := DeepCopy_api_SecretVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.Secret = nil
	}
	if in.NFS != nil {
		in, out := in.NFS, &out.NFS
		*out = new(NFSVolumeSource)
		if err := DeepCopy_api_NFSVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.NFS = nil
	}
	if in.ISCSI != nil {
		in, out := in.ISCSI, &out.ISCSI
		*out = new(ISCSIVolumeSource)
		if err := DeepCopy_api_ISCSIVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.ISCSI = nil
	}
	if in.Glusterfs != nil {
		in, out := in.Glusterfs, &out.Glusterfs
		*out = new(GlusterfsVolumeSource)
		if err := DeepCopy_api_GlusterfsVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.Glusterfs = nil
	}
	if in.PersistentVolumeClaim != nil {
		in, out := in.PersistentVolumeClaim, &out.PersistentVolumeClaim
		*out = new(PersistentVolumeClaimVolumeSource)
		if err := DeepCopy_api_PersistentVolumeClaimVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.PersistentVolumeClaim = nil
	}
	if in.RBD != nil {
		in, out := in.RBD, &out.RBD
		*out = new(RBDVolumeSource)
		if err := DeepCopy_api_RBDVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.RBD = nil
	}
	if in.FlexVolume != nil {
		in, out := in.FlexVolume, &out.FlexVolume
		*out = new(FlexVolumeSource)
		if err := DeepCopy_api_FlexVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.FlexVolume = nil
	}
	if in.Cinder != nil {
		in, out := in.Cinder, &out.Cinder
		*out = new(CinderVolumeSource)
		if err := DeepCopy_api_CinderVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.Cinder = nil
	}
	if in.CephFS != nil {
		in, out := in.CephFS, &out.CephFS
		*out = new(CephFSVolumeSource)
		if err := DeepCopy_api_CephFSVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.CephFS = nil
	}
	if in.Flocker != nil {
		in, out := in.Flocker, &out.Flocker
		*out = new(FlockerVolumeSource)
		if err := DeepCopy_api_FlockerVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.Flocker = nil
	}
	if in.DownwardAPI != nil {
		in, out := in.DownwardAPI, &out.DownwardAPI
		*out = new(DownwardAPIVolumeSource)
		if err := DeepCopy_api_DownwardAPIVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.DownwardAPI = nil
	}
	if in.FC != nil {
		in, out := in.FC, &out.FC
		*out = new(FCVolumeSource)
		if err := DeepCopy_api_FCVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.FC = nil
	}
	if in.AzureFile != nil {
		in, out := in.AzureFile, &out.AzureFile
		*out = new(AzureFileVolumeSource)
		if err := DeepCopy_api_AzureFileVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.AzureFile = nil
	}
	if in.ConfigMap != nil {
		in, out := in.ConfigMap, &out.ConfigMap
		*out = new(ConfigMapVolumeSource)
		if err := DeepCopy_api_ConfigMapVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.ConfigMap = nil
	}
	if in.VsphereVolume != nil {
		in, out := in.VsphereVolume, &out.VsphereVolume
		*out = new(VsphereVirtualDiskVolumeSource)
		if err := DeepCopy_api_VsphereVirtualDiskVolumeSource(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.VsphereVolume = nil
	}
	return nil
}

func DeepCopy_api_VsphereVirtualDiskVolumeSource(in VsphereVirtualDiskVolumeSource, out *VsphereVirtualDiskVolumeSource, c *conversion.Cloner) error {
	out.VolumePath = in.VolumePath
	out.FSType = in.FSType
	return nil
}

func DeepCopy_api_WeightedPodAffinityTerm(in WeightedPodAffinityTerm, out *WeightedPodAffinityTerm, c *conversion.Cloner) error {
	out.Weight = in.Weight
	if err := DeepCopy_api_PodAffinityTerm(in.PodAffinityTerm, &out.PodAffinityTerm, c); err != nil {
		return err
	}
	return nil
}
