# makefile variables and rules shared by both gkrellm and gkrellmd

GKRELLM_VERSION_MAJOR = 2
GKRELLM_VERSION_MINOR = 4
GKRELLM_VERSION_PATCH = 0
GKRELLM_VERSION = $(GKRELLM_VERSION_MAJOR).$(GKRELLM_VERSION_MINOR).$(GKRELLM_VERSION_PATCH)

ifdef CROSS
	# enforce overriding tools for mxe cross builds (http://mxe.cc)
	CC = $(CROSS)gcc
	AR = $(CROSS)ar
	PKG_CONFIG = $(CROSS)pkg-config
	WINDRES = $(CROSS)windres
else
	CC ?= gcc
	AR ?= ar
	PKG_CONFIG ?= pkg-config
	WINDRES ?= windres
endif

# Make configure use identical environment
export CC
export PKG_CONFIG

PREFIX ?= /usr/local
INSTALLROOT ?= $(DESTDIR)$(PREFIX)

BINMODE ?= 755
BINEXT ?=

INSTALLDIRMODE ?= 755

INCLUDEDIR ?= $(INSTALLROOT)/include
INCLUDEMODE ?= 644
INCLUDEDIRMODE ?= 755

LIBDIR ?= $(INSTALLROOT)/lib
LIBDIRMODE ?= 755

MANMODE ?= 644
MANDIRMODE ?= 755

INSTALL ?= install
STRIP ?=
LINK_FLAGS ?= -Wl,-E

SHARED_PATH = ../shared

%.o: %.c
	$(CC) -c -Wall $(FLAGS) $(CFLAGS) $(CPPFLAGS) $< -o $@

%-version.h: %-version.h.in
	sed \
		-e 's#@GKRELLM_VERSION_MAJOR@#$(GKRELLM_VERSION_MAJOR)#g'\
		-e 's#@GKRELLM_VERSION_MINOR@#$(GKRELLM_VERSION_MINOR)#g'\
		-e 's#@GKRELLM_VERSION_PATCH@#$(GKRELLM_VERSION_PATCH)#g'\
		$< > $@

%.rc: %.rc.in
	sed \
		-e 's#@GKRELLM_VERSION_MAJOR@#$(GKRELLM_VERSION_MAJOR)#g'\
		-e 's#@GKRELLM_VERSION_MINOR@#$(GKRELLM_VERSION_MINOR)#g'\
		-e 's#@GKRELLM_VERSION_PATCH@#$(GKRELLM_VERSION_PATCH)#g'\
		-e 's#@GKRELLM_VERSION@#$(GKRELLM_VERSION)#g'\
		$< > $@
