// Code generated by cuelang.org/go/pkg/gen. DO NOT EDIT.

package bits

import (
	"cuelang.org/go/internal/core/adt"
	"cuelang.org/go/internal/pkg"
)

func init() {
	pkg.Register("math/bits", p)
}

var _ = adt.TopKind // in case the adt package isn't used

var p = &pkg.Package{
	Native: []*pkg.Builtin{{
		Name: "Lsh",
		Params: []pkg.Param{
			{Kind: adt.IntKind},
			{Kind: adt.IntKind},
		},
		Result: adt.IntKind,
		Func: func(c *pkg.CallCtxt) {
			x, n := c.BigInt(0), c.Uint(1)
			if c.Do() {
				c.Ret = Lsh(x, n)
			}
		},
	}, {
		Name: "Rsh",
		Params: []pkg.Param{
			{Kind: adt.IntKind},
			{Kind: adt.IntKind},
		},
		Result: adt.IntKind,
		Func: func(c *pkg.CallCtxt) {
			x, n := c.BigInt(0), c.Uint(1)
			if c.Do() {
				c.Ret = Rsh(x, n)
			}
		},
	}, {
		Name: "At",
		Params: []pkg.Param{
			{Kind: adt.IntKind},
			{Kind: adt.IntKind},
		},
		Result: adt.IntKind,
		Func: func(c *pkg.CallCtxt) {
			x, i := c.BigInt(0), c.Uint(1)
			if c.Do() {
				c.Ret, c.Err = At(x, i)
			}
		},
	}, {
		Name: "Set",
		Params: []pkg.Param{
			{Kind: adt.IntKind},
			{Kind: adt.IntKind},
			{Kind: adt.IntKind},
		},
		Result: adt.IntKind,
		Func: func(c *pkg.CallCtxt) {
			x, i, bit := c.BigInt(0), c.Int(1), c.Uint(2)
			if c.Do() {
				c.Ret = Set(x, i, bit)
			}
		},
	}, {
		Name: "And",
		Params: []pkg.Param{
			{Kind: adt.IntKind},
			{Kind: adt.IntKind},
		},
		Result: adt.IntKind,
		Func: func(c *pkg.CallCtxt) {
			a, b := c.BigInt(0), c.BigInt(1)
			if c.Do() {
				c.Ret = And(a, b)
			}
		},
	}, {
		Name: "Or",
		Params: []pkg.Param{
			{Kind: adt.IntKind},
			{Kind: adt.IntKind},
		},
		Result: adt.IntKind,
		Func: func(c *pkg.CallCtxt) {
			a, b := c.BigInt(0), c.BigInt(1)
			if c.Do() {
				c.Ret = Or(a, b)
			}
		},
	}, {
		Name: "Xor",
		Params: []pkg.Param{
			{Kind: adt.IntKind},
			{Kind: adt.IntKind},
		},
		Result: adt.IntKind,
		Func: func(c *pkg.CallCtxt) {
			a, b := c.BigInt(0), c.BigInt(1)
			if c.Do() {
				c.Ret = Xor(a, b)
			}
		},
	}, {
		Name: "Clear",
		Params: []pkg.Param{
			{Kind: adt.IntKind},
			{Kind: adt.IntKind},
		},
		Result: adt.IntKind,
		Func: func(c *pkg.CallCtxt) {
			a, b := c.BigInt(0), c.BigInt(1)
			if c.Do() {
				c.Ret = Clear(a, b)
			}
		},
	}, {
		Name: "OnesCount",
		Params: []pkg.Param{
			{Kind: adt.IntKind},
		},
		Result: adt.IntKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.BigInt(0)
			if c.Do() {
				c.Ret = OnesCount(x)
			}
		},
	}, {
		Name: "Len",
		Params: []pkg.Param{
			{Kind: adt.IntKind},
		},
		Result: adt.IntKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.BigInt(0)
			if c.Do() {
				c.Ret = Len(x)
			}
		},
	}},
}
