//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by defaulter-gen. DO NOT EDIT.

package wholepkg

import (
	runtime "k8s.io/apimachinery/pkg/runtime"
)

// RegisterDefaults adds defaulters functions to the given scheme.
// Public to allow building arbitrary schemes.
// All generated defaulters are covering - they call all nested defaulters.
func RegisterDefaults(scheme *runtime.Scheme) error {
	scheme.AddTypeDefaultingFunc(&Struct_Everything{}, func(obj interface{}) { SetObjectDefaults_Struct_Everything(obj.(*Struct_Everything)) })
	scheme.AddTypeDefaultingFunc(&Struct_Pointer{}, func(obj interface{}) { SetObjectDefaults_Struct_Pointer(obj.(*Struct_Pointer)) })
	scheme.AddTypeDefaultingFunc(&Struct_Primitives{}, func(obj interface{}) { SetObjectDefaults_Struct_Primitives(obj.(*Struct_Primitives)) })
	scheme.AddTypeDefaultingFunc(&Struct_Slices{}, func(obj interface{}) { SetObjectDefaults_Struct_Slices(obj.(*Struct_Slices)) })
	scheme.AddTypeDefaultingFunc(&Struct_Struct_Primitives{}, func(obj interface{}) { SetObjectDefaults_Struct_Struct_Primitives(obj.(*Struct_Struct_Primitives)) })
	return nil
}

func SetObjectDefaults_Struct_Everything(in *Struct_Everything) {
	SetObjectDefaults_Struct_Pointer(&in.PointerStructField)
	SetObjectDefaults_Struct_Slices(&in.SlicesStructField)
}

func SetObjectDefaults_Struct_Pointer(in *Struct_Pointer) {
	SetObjectDefaults_Struct_Primitives(&in.PointerStructPrimitivesField)
	if in.PointerPointerStructPrimitivesField != nil {
		SetObjectDefaults_Struct_Primitives(in.PointerPointerStructPrimitivesField)
	}
	SetObjectDefaults_Struct_Struct_Primitives(&in.PointerStructStructPrimitives)
	if in.PointerPointerStructStructPrimitives != nil {
		SetObjectDefaults_Struct_Struct_Primitives(in.PointerPointerStructStructPrimitives)
	}
}

func SetObjectDefaults_Struct_Primitives(in *Struct_Primitives) {
	SetDefaults_Struct_Primitives(in)
}

func SetObjectDefaults_Struct_Slices(in *Struct_Slices) {
	for i := range in.SliceStructPrimitivesField {
		a := &in.SliceStructPrimitivesField[i]
		SetObjectDefaults_Struct_Primitives(a)
	}
	for i := range in.SlicePointerStructPrimitivesField {
		a := in.SlicePointerStructPrimitivesField[i]
		if a != nil {
			SetObjectDefaults_Struct_Primitives(a)
		}
	}
	for i := range in.SliceStructStructPrimitives {
		a := &in.SliceStructStructPrimitives[i]
		SetObjectDefaults_Struct_Struct_Primitives(a)
	}
	for i := range in.SlicePointerStructStructPrimitives {
		a := in.SlicePointerStructStructPrimitives[i]
		if a != nil {
			SetObjectDefaults_Struct_Struct_Primitives(a)
		}
	}
}

func SetObjectDefaults_Struct_Struct_Primitives(in *Struct_Struct_Primitives) {
	SetObjectDefaults_Struct_Primitives(&in.StructField)
}
