// Code generated by command: avogen -output zctors_test.go ctorstest. DO NOT EDIT.

package x86

import (
	"math"
	"testing"

	"github.com/mmcloughlin/avo/operand"
	"github.com/mmcloughlin/avo/reg"
)

func TestADCBValidForms(t *testing.T) {
	t.Run("form=imm8_al", func(t *testing.T) {
		if _, err := ADCB(operand.Imm(math.MaxInt8), reg.AL); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r8", func(t *testing.T) {
		if _, err := ADCB(operand.Imm(math.MaxInt8), reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := ADCB(operand.Imm(math.MaxInt8), reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := ADCB(operand.Imm(math.MaxInt8), reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r8_r8", func(t *testing.T) {
		if _, err := ADCB(reg.CH, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := ADCB(reg.CH, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := ADCB(reg.CH, reg.R13B); err != nil {
			t.Fatal(err)
		}
		if _, err := ADCB(reg.BL, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := ADCB(reg.BL, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := ADCB(reg.BL, reg.R13B); err != nil {
			t.Fatal(err)
		}
		if _, err := ADCB(reg.R13B, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := ADCB(reg.R13B, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := ADCB(reg.R13B, reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8_r8", func(t *testing.T) {
		if _, err := ADCB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := ADCB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := ADCB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m8", func(t *testing.T) {
		if _, err := ADCB(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r8_m8", func(t *testing.T) {
		if _, err := ADCB(reg.CH, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
		if _, err := ADCB(reg.BL, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
		if _, err := ADCB(reg.R13B, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestADCLValidForms(t *testing.T) {
	t.Run("form=imm32_eax", func(t *testing.T) {
		if _, err := ADCL(operand.Imm(math.MaxInt32), reg.EAX); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r32", func(t *testing.T) {
		if _, err := ADCL(operand.Imm(math.MaxInt8), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_r32", func(t *testing.T) {
		if _, err := ADCL(operand.Imm(math.MaxInt32), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := ADCL(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := ADCL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m32", func(t *testing.T) {
		if _, err := ADCL(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_m32", func(t *testing.T) {
		if _, err := ADCL(operand.Imm(math.MaxInt32), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_m32", func(t *testing.T) {
		if _, err := ADCL(reg.R10L, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestADCQValidForms(t *testing.T) {
	t.Run("form=imm32_rax", func(t *testing.T) {
		if _, err := ADCQ(operand.Imm(math.MaxInt32), reg.RAX); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r64", func(t *testing.T) {
		if _, err := ADCQ(operand.Imm(math.MaxInt8), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_r64", func(t *testing.T) {
		if _, err := ADCQ(operand.Imm(math.MaxInt32), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := ADCQ(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := ADCQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m64", func(t *testing.T) {
		if _, err := ADCQ(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_m64", func(t *testing.T) {
		if _, err := ADCQ(operand.Imm(math.MaxInt32), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_m64", func(t *testing.T) {
		if _, err := ADCQ(reg.R11, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestADCWValidForms(t *testing.T) {
	t.Run("form=imm16_ax", func(t *testing.T) {
		if _, err := ADCW(operand.Imm(math.MaxInt16), reg.AX); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r16", func(t *testing.T) {
		if _, err := ADCW(operand.Imm(math.MaxInt8), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := ADCW(operand.Imm(math.MaxInt8), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm16_r16", func(t *testing.T) {
		if _, err := ADCW(operand.Imm(math.MaxInt16), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := ADCW(operand.Imm(math.MaxInt16), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := ADCW(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := ADCW(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := ADCW(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := ADCW(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r16", func(t *testing.T) {
		if _, err := ADCW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := ADCW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m16", func(t *testing.T) {
		if _, err := ADCW(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm16_m16", func(t *testing.T) {
		if _, err := ADCW(operand.Imm(math.MaxInt16), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_m16", func(t *testing.T) {
		if _, err := ADCW(reg.CX, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
		if _, err := ADCW(reg.R9W, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestADCXLValidForms(t *testing.T) {
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := ADCXL(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := ADCXL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestADCXQValidForms(t *testing.T) {
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := ADCXQ(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := ADCXQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestADDBValidForms(t *testing.T) {
	t.Run("form=imm8_al", func(t *testing.T) {
		if _, err := ADDB(operand.Imm(math.MaxInt8), reg.AL); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r8", func(t *testing.T) {
		if _, err := ADDB(operand.Imm(math.MaxInt8), reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := ADDB(operand.Imm(math.MaxInt8), reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := ADDB(operand.Imm(math.MaxInt8), reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r8_r8", func(t *testing.T) {
		if _, err := ADDB(reg.CH, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := ADDB(reg.CH, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := ADDB(reg.CH, reg.R13B); err != nil {
			t.Fatal(err)
		}
		if _, err := ADDB(reg.BL, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := ADDB(reg.BL, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := ADDB(reg.BL, reg.R13B); err != nil {
			t.Fatal(err)
		}
		if _, err := ADDB(reg.R13B, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := ADDB(reg.R13B, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := ADDB(reg.R13B, reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8_r8", func(t *testing.T) {
		if _, err := ADDB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := ADDB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := ADDB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m8", func(t *testing.T) {
		if _, err := ADDB(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r8_m8", func(t *testing.T) {
		if _, err := ADDB(reg.CH, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
		if _, err := ADDB(reg.BL, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
		if _, err := ADDB(reg.R13B, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestADDLValidForms(t *testing.T) {
	t.Run("form=imm32_eax", func(t *testing.T) {
		if _, err := ADDL(operand.Imm(math.MaxInt32), reg.EAX); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r32", func(t *testing.T) {
		if _, err := ADDL(operand.Imm(math.MaxInt8), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_r32", func(t *testing.T) {
		if _, err := ADDL(operand.Imm(math.MaxInt32), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := ADDL(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := ADDL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m32", func(t *testing.T) {
		if _, err := ADDL(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_m32", func(t *testing.T) {
		if _, err := ADDL(operand.Imm(math.MaxInt32), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_m32", func(t *testing.T) {
		if _, err := ADDL(reg.R10L, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestADDPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := ADDPD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := ADDPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestADDPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := ADDPS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := ADDPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestADDQValidForms(t *testing.T) {
	t.Run("form=imm32_rax", func(t *testing.T) {
		if _, err := ADDQ(operand.Imm(math.MaxInt32), reg.RAX); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r64", func(t *testing.T) {
		if _, err := ADDQ(operand.Imm(math.MaxInt8), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_r64", func(t *testing.T) {
		if _, err := ADDQ(operand.Imm(math.MaxInt32), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := ADDQ(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := ADDQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m64", func(t *testing.T) {
		if _, err := ADDQ(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_m64", func(t *testing.T) {
		if _, err := ADDQ(operand.Imm(math.MaxInt32), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_m64", func(t *testing.T) {
		if _, err := ADDQ(reg.R11, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestADDSDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := ADDSD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := ADDSD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestADDSSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := ADDSS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm", func(t *testing.T) {
		if _, err := ADDSS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestADDSUBPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := ADDSUBPD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := ADDSUBPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestADDSUBPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := ADDSUBPS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := ADDSUBPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestADDWValidForms(t *testing.T) {
	t.Run("form=imm16_ax", func(t *testing.T) {
		if _, err := ADDW(operand.Imm(math.MaxInt16), reg.AX); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r16", func(t *testing.T) {
		if _, err := ADDW(operand.Imm(math.MaxInt8), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := ADDW(operand.Imm(math.MaxInt8), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm16_r16", func(t *testing.T) {
		if _, err := ADDW(operand.Imm(math.MaxInt16), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := ADDW(operand.Imm(math.MaxInt16), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := ADDW(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := ADDW(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := ADDW(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := ADDW(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r16", func(t *testing.T) {
		if _, err := ADDW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := ADDW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m16", func(t *testing.T) {
		if _, err := ADDW(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm16_m16", func(t *testing.T) {
		if _, err := ADDW(operand.Imm(math.MaxInt16), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_m16", func(t *testing.T) {
		if _, err := ADDW(reg.CX, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
		if _, err := ADDW(reg.R9W, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestADOXLValidForms(t *testing.T) {
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := ADOXL(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := ADOXL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestADOXQValidForms(t *testing.T) {
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := ADOXQ(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := ADOXQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestAESDECValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := AESDEC(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := AESDEC(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestAESDECLASTValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := AESDECLAST(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := AESDECLAST(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestAESENCValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := AESENC(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := AESENC(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestAESENCLASTValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := AESENCLAST(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := AESENCLAST(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestAESIMCValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := AESIMC(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := AESIMC(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestAESKEYGENASSISTValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := AESKEYGENASSIST(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm", func(t *testing.T) {
		if _, err := AESKEYGENASSIST(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestANDBValidForms(t *testing.T) {
	t.Run("form=imm8_al", func(t *testing.T) {
		if _, err := ANDB(operand.Imm(math.MaxInt8), reg.AL); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r8", func(t *testing.T) {
		if _, err := ANDB(operand.Imm(math.MaxInt8), reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := ANDB(operand.Imm(math.MaxInt8), reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := ANDB(operand.Imm(math.MaxInt8), reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r8_r8", func(t *testing.T) {
		if _, err := ANDB(reg.CH, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := ANDB(reg.CH, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := ANDB(reg.CH, reg.R13B); err != nil {
			t.Fatal(err)
		}
		if _, err := ANDB(reg.BL, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := ANDB(reg.BL, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := ANDB(reg.BL, reg.R13B); err != nil {
			t.Fatal(err)
		}
		if _, err := ANDB(reg.R13B, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := ANDB(reg.R13B, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := ANDB(reg.R13B, reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8_r8", func(t *testing.T) {
		if _, err := ANDB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := ANDB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := ANDB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m8", func(t *testing.T) {
		if _, err := ANDB(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r8_m8", func(t *testing.T) {
		if _, err := ANDB(reg.CH, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
		if _, err := ANDB(reg.BL, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
		if _, err := ANDB(reg.R13B, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestANDLValidForms(t *testing.T) {
	t.Run("form=imm32_eax", func(t *testing.T) {
		if _, err := ANDL(operand.Imm(math.MaxInt32), reg.EAX); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r32", func(t *testing.T) {
		if _, err := ANDL(operand.Imm(math.MaxInt8), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_r32", func(t *testing.T) {
		if _, err := ANDL(operand.Imm(math.MaxInt32), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := ANDL(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := ANDL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m32", func(t *testing.T) {
		if _, err := ANDL(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_m32", func(t *testing.T) {
		if _, err := ANDL(operand.Imm(math.MaxInt32), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_m32", func(t *testing.T) {
		if _, err := ANDL(reg.R10L, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestANDNLValidForms(t *testing.T) {
	t.Run("form=r32_r32_r32", func(t *testing.T) {
		if _, err := ANDNL(reg.R10L, reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32_r32", func(t *testing.T) {
		if _, err := ANDNL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestANDNPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := ANDNPD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := ANDNPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestANDNPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := ANDNPS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := ANDNPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestANDNQValidForms(t *testing.T) {
	t.Run("form=r64_r64_r64", func(t *testing.T) {
		if _, err := ANDNQ(reg.R11, reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64_r64", func(t *testing.T) {
		if _, err := ANDNQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestANDPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := ANDPD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := ANDPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestANDPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := ANDPS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := ANDPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestANDQValidForms(t *testing.T) {
	t.Run("form=imm32_rax", func(t *testing.T) {
		if _, err := ANDQ(operand.Imm(math.MaxInt32), reg.RAX); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r64", func(t *testing.T) {
		if _, err := ANDQ(operand.Imm(math.MaxInt8), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_r64", func(t *testing.T) {
		if _, err := ANDQ(operand.Imm(math.MaxInt32), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := ANDQ(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := ANDQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m64", func(t *testing.T) {
		if _, err := ANDQ(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_m64", func(t *testing.T) {
		if _, err := ANDQ(operand.Imm(math.MaxInt32), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_m64", func(t *testing.T) {
		if _, err := ANDQ(reg.R11, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestANDWValidForms(t *testing.T) {
	t.Run("form=imm16_ax", func(t *testing.T) {
		if _, err := ANDW(operand.Imm(math.MaxInt16), reg.AX); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r16", func(t *testing.T) {
		if _, err := ANDW(operand.Imm(math.MaxInt8), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := ANDW(operand.Imm(math.MaxInt8), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm16_r16", func(t *testing.T) {
		if _, err := ANDW(operand.Imm(math.MaxInt16), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := ANDW(operand.Imm(math.MaxInt16), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := ANDW(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := ANDW(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := ANDW(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := ANDW(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r16", func(t *testing.T) {
		if _, err := ANDW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := ANDW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m16", func(t *testing.T) {
		if _, err := ANDW(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm16_m16", func(t *testing.T) {
		if _, err := ANDW(operand.Imm(math.MaxInt16), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_m16", func(t *testing.T) {
		if _, err := ANDW(reg.CX, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
		if _, err := ANDW(reg.R9W, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBEXTRLValidForms(t *testing.T) {
	t.Run("form=r32_r32_r32", func(t *testing.T) {
		if _, err := BEXTRL(reg.R10L, reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_m32_r32", func(t *testing.T) {
		if _, err := BEXTRL(reg.R10L, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBEXTRQValidForms(t *testing.T) {
	t.Run("form=r64_r64_r64", func(t *testing.T) {
		if _, err := BEXTRQ(reg.R11, reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_m64_r64", func(t *testing.T) {
		if _, err := BEXTRQ(reg.R11, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBLENDPDValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := BLENDPD(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm", func(t *testing.T) {
		if _, err := BLENDPD(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBLENDPSValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := BLENDPS(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm", func(t *testing.T) {
		if _, err := BLENDPS(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBLENDVPDValidForms(t *testing.T) {
	t.Run("form=xmm0_xmm_xmm", func(t *testing.T) {
		if _, err := BLENDVPD(reg.X0, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm0_m128_xmm", func(t *testing.T) {
		if _, err := BLENDVPD(reg.X0, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBLENDVPSValidForms(t *testing.T) {
	t.Run("form=xmm0_xmm_xmm", func(t *testing.T) {
		if _, err := BLENDVPS(reg.X0, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm0_m128_xmm", func(t *testing.T) {
		if _, err := BLENDVPS(reg.X0, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBLSILValidForms(t *testing.T) {
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := BLSIL(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := BLSIL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBLSIQValidForms(t *testing.T) {
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := BLSIQ(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := BLSIQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBLSMSKLValidForms(t *testing.T) {
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := BLSMSKL(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := BLSMSKL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBLSMSKQValidForms(t *testing.T) {
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := BLSMSKQ(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := BLSMSKQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBLSRLValidForms(t *testing.T) {
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := BLSRL(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := BLSRL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBLSRQValidForms(t *testing.T) {
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := BLSRQ(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := BLSRQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBSFLValidForms(t *testing.T) {
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := BSFL(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := BSFL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBSFQValidForms(t *testing.T) {
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := BSFQ(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := BSFQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBSFWValidForms(t *testing.T) {
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := BSFW(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := BSFW(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := BSFW(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := BSFW(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r16", func(t *testing.T) {
		if _, err := BSFW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := BSFW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBSRLValidForms(t *testing.T) {
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := BSRL(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := BSRL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBSRQValidForms(t *testing.T) {
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := BSRQ(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := BSRQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBSRWValidForms(t *testing.T) {
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := BSRW(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := BSRW(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := BSRW(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := BSRW(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r16", func(t *testing.T) {
		if _, err := BSRW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := BSRW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBSWAPLValidForms(t *testing.T) {
	t.Run("form=r32", func(t *testing.T) {
		if _, err := BSWAPL(reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBSWAPQValidForms(t *testing.T) {
	t.Run("form=r64", func(t *testing.T) {
		if _, err := BSWAPQ(reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBTCLValidForms(t *testing.T) {
	t.Run("form=imm8_r32", func(t *testing.T) {
		if _, err := BTCL(operand.Imm(math.MaxInt8), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := BTCL(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m32", func(t *testing.T) {
		if _, err := BTCL(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_m32", func(t *testing.T) {
		if _, err := BTCL(reg.R10L, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBTCQValidForms(t *testing.T) {
	t.Run("form=imm8_r64", func(t *testing.T) {
		if _, err := BTCQ(operand.Imm(math.MaxInt8), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := BTCQ(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m64", func(t *testing.T) {
		if _, err := BTCQ(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_m64", func(t *testing.T) {
		if _, err := BTCQ(reg.R11, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBTCWValidForms(t *testing.T) {
	t.Run("form=imm8_r16", func(t *testing.T) {
		if _, err := BTCW(operand.Imm(math.MaxInt8), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := BTCW(operand.Imm(math.MaxInt8), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := BTCW(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := BTCW(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := BTCW(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := BTCW(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m16", func(t *testing.T) {
		if _, err := BTCW(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_m16", func(t *testing.T) {
		if _, err := BTCW(reg.CX, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
		if _, err := BTCW(reg.R9W, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBTLValidForms(t *testing.T) {
	t.Run("form=imm8_r32", func(t *testing.T) {
		if _, err := BTL(operand.Imm(math.MaxInt8), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := BTL(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m32", func(t *testing.T) {
		if _, err := BTL(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_m32", func(t *testing.T) {
		if _, err := BTL(reg.R10L, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBTQValidForms(t *testing.T) {
	t.Run("form=imm8_r64", func(t *testing.T) {
		if _, err := BTQ(operand.Imm(math.MaxInt8), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := BTQ(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m64", func(t *testing.T) {
		if _, err := BTQ(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_m64", func(t *testing.T) {
		if _, err := BTQ(reg.R11, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBTRLValidForms(t *testing.T) {
	t.Run("form=imm8_r32", func(t *testing.T) {
		if _, err := BTRL(operand.Imm(math.MaxInt8), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := BTRL(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m32", func(t *testing.T) {
		if _, err := BTRL(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_m32", func(t *testing.T) {
		if _, err := BTRL(reg.R10L, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBTRQValidForms(t *testing.T) {
	t.Run("form=imm8_r64", func(t *testing.T) {
		if _, err := BTRQ(operand.Imm(math.MaxInt8), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := BTRQ(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m64", func(t *testing.T) {
		if _, err := BTRQ(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_m64", func(t *testing.T) {
		if _, err := BTRQ(reg.R11, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBTRWValidForms(t *testing.T) {
	t.Run("form=imm8_r16", func(t *testing.T) {
		if _, err := BTRW(operand.Imm(math.MaxInt8), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := BTRW(operand.Imm(math.MaxInt8), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := BTRW(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := BTRW(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := BTRW(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := BTRW(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m16", func(t *testing.T) {
		if _, err := BTRW(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_m16", func(t *testing.T) {
		if _, err := BTRW(reg.CX, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
		if _, err := BTRW(reg.R9W, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBTSLValidForms(t *testing.T) {
	t.Run("form=imm8_r32", func(t *testing.T) {
		if _, err := BTSL(operand.Imm(math.MaxInt8), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := BTSL(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m32", func(t *testing.T) {
		if _, err := BTSL(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_m32", func(t *testing.T) {
		if _, err := BTSL(reg.R10L, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBTSQValidForms(t *testing.T) {
	t.Run("form=imm8_r64", func(t *testing.T) {
		if _, err := BTSQ(operand.Imm(math.MaxInt8), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := BTSQ(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m64", func(t *testing.T) {
		if _, err := BTSQ(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_m64", func(t *testing.T) {
		if _, err := BTSQ(reg.R11, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBTSWValidForms(t *testing.T) {
	t.Run("form=imm8_r16", func(t *testing.T) {
		if _, err := BTSW(operand.Imm(math.MaxInt8), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := BTSW(operand.Imm(math.MaxInt8), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := BTSW(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := BTSW(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := BTSW(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := BTSW(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m16", func(t *testing.T) {
		if _, err := BTSW(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_m16", func(t *testing.T) {
		if _, err := BTSW(reg.CX, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
		if _, err := BTSW(reg.R9W, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBTWValidForms(t *testing.T) {
	t.Run("form=imm8_r16", func(t *testing.T) {
		if _, err := BTW(operand.Imm(math.MaxInt8), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := BTW(operand.Imm(math.MaxInt8), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := BTW(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := BTW(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := BTW(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := BTW(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m16", func(t *testing.T) {
		if _, err := BTW(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_m16", func(t *testing.T) {
		if _, err := BTW(reg.CX, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
		if _, err := BTW(reg.R9W, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBZHILValidForms(t *testing.T) {
	t.Run("form=r32_r32_r32", func(t *testing.T) {
		if _, err := BZHIL(reg.R10L, reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_m32_r32", func(t *testing.T) {
		if _, err := BZHIL(reg.R10L, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestBZHIQValidForms(t *testing.T) {
	t.Run("form=r64_r64_r64", func(t *testing.T) {
		if _, err := BZHIQ(reg.R11, reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_m64_r64", func(t *testing.T) {
		if _, err := BZHIQ(reg.R11, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCALLValidForms(t *testing.T) {
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := CALL(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := CALL(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCBWValidForms(t *testing.T) {
	t.Run("form=", func(t *testing.T) {
		if _, err := CBW(); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCDQValidForms(t *testing.T) {
	t.Run("form=", func(t *testing.T) {
		if _, err := CDQ(); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCDQEValidForms(t *testing.T) {
	t.Run("form=", func(t *testing.T) {
		if _, err := CDQE(); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCLCValidForms(t *testing.T) {
	t.Run("form=", func(t *testing.T) {
		if _, err := CLC(); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCLDValidForms(t *testing.T) {
	t.Run("form=", func(t *testing.T) {
		if _, err := CLD(); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCLFLUSHValidForms(t *testing.T) {
	t.Run("form=m8", func(t *testing.T) {
		if _, err := CLFLUSH(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCLFLUSHOPTValidForms(t *testing.T) {
	t.Run("form=m8", func(t *testing.T) {
		if _, err := CLFLUSHOPT(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMCValidForms(t *testing.T) {
	t.Run("form=", func(t *testing.T) {
		if _, err := CMC(); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVLCCValidForms(t *testing.T) {
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := CMOVLCC(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := CMOVLCC(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVLCSValidForms(t *testing.T) {
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := CMOVLCS(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := CMOVLCS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVLEQValidForms(t *testing.T) {
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := CMOVLEQ(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := CMOVLEQ(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVLGEValidForms(t *testing.T) {
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := CMOVLGE(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := CMOVLGE(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVLGTValidForms(t *testing.T) {
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := CMOVLGT(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := CMOVLGT(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVLHIValidForms(t *testing.T) {
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := CMOVLHI(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := CMOVLHI(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVLLEValidForms(t *testing.T) {
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := CMOVLLE(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := CMOVLLE(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVLLSValidForms(t *testing.T) {
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := CMOVLLS(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := CMOVLLS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVLLTValidForms(t *testing.T) {
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := CMOVLLT(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := CMOVLLT(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVLMIValidForms(t *testing.T) {
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := CMOVLMI(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := CMOVLMI(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVLNEValidForms(t *testing.T) {
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := CMOVLNE(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := CMOVLNE(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVLOCValidForms(t *testing.T) {
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := CMOVLOC(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := CMOVLOC(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVLOSValidForms(t *testing.T) {
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := CMOVLOS(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := CMOVLOS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVLPCValidForms(t *testing.T) {
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := CMOVLPC(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := CMOVLPC(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVLPLValidForms(t *testing.T) {
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := CMOVLPL(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := CMOVLPL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVLPSValidForms(t *testing.T) {
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := CMOVLPS(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := CMOVLPS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVQCCValidForms(t *testing.T) {
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := CMOVQCC(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := CMOVQCC(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVQCSValidForms(t *testing.T) {
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := CMOVQCS(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := CMOVQCS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVQEQValidForms(t *testing.T) {
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := CMOVQEQ(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := CMOVQEQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVQGEValidForms(t *testing.T) {
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := CMOVQGE(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := CMOVQGE(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVQGTValidForms(t *testing.T) {
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := CMOVQGT(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := CMOVQGT(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVQHIValidForms(t *testing.T) {
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := CMOVQHI(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := CMOVQHI(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVQLEValidForms(t *testing.T) {
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := CMOVQLE(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := CMOVQLE(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVQLSValidForms(t *testing.T) {
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := CMOVQLS(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := CMOVQLS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVQLTValidForms(t *testing.T) {
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := CMOVQLT(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := CMOVQLT(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVQMIValidForms(t *testing.T) {
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := CMOVQMI(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := CMOVQMI(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVQNEValidForms(t *testing.T) {
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := CMOVQNE(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := CMOVQNE(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVQOCValidForms(t *testing.T) {
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := CMOVQOC(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := CMOVQOC(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVQOSValidForms(t *testing.T) {
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := CMOVQOS(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := CMOVQOS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVQPCValidForms(t *testing.T) {
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := CMOVQPC(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := CMOVQPC(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVQPLValidForms(t *testing.T) {
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := CMOVQPL(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := CMOVQPL(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVQPSValidForms(t *testing.T) {
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := CMOVQPS(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := CMOVQPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVWCCValidForms(t *testing.T) {
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := CMOVWCC(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWCC(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWCC(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWCC(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r16", func(t *testing.T) {
		if _, err := CMOVWCC(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWCC(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVWCSValidForms(t *testing.T) {
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := CMOVWCS(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWCS(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWCS(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWCS(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r16", func(t *testing.T) {
		if _, err := CMOVWCS(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWCS(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVWEQValidForms(t *testing.T) {
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := CMOVWEQ(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWEQ(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWEQ(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWEQ(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r16", func(t *testing.T) {
		if _, err := CMOVWEQ(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWEQ(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVWGEValidForms(t *testing.T) {
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := CMOVWGE(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWGE(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWGE(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWGE(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r16", func(t *testing.T) {
		if _, err := CMOVWGE(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWGE(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVWGTValidForms(t *testing.T) {
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := CMOVWGT(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWGT(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWGT(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWGT(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r16", func(t *testing.T) {
		if _, err := CMOVWGT(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWGT(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVWHIValidForms(t *testing.T) {
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := CMOVWHI(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWHI(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWHI(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWHI(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r16", func(t *testing.T) {
		if _, err := CMOVWHI(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWHI(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVWLEValidForms(t *testing.T) {
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := CMOVWLE(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWLE(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWLE(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWLE(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r16", func(t *testing.T) {
		if _, err := CMOVWLE(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWLE(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVWLSValidForms(t *testing.T) {
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := CMOVWLS(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWLS(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWLS(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWLS(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r16", func(t *testing.T) {
		if _, err := CMOVWLS(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWLS(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVWLTValidForms(t *testing.T) {
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := CMOVWLT(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWLT(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWLT(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWLT(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r16", func(t *testing.T) {
		if _, err := CMOVWLT(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWLT(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVWMIValidForms(t *testing.T) {
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := CMOVWMI(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWMI(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWMI(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWMI(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r16", func(t *testing.T) {
		if _, err := CMOVWMI(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWMI(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVWNEValidForms(t *testing.T) {
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := CMOVWNE(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWNE(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWNE(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWNE(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r16", func(t *testing.T) {
		if _, err := CMOVWNE(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWNE(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVWOCValidForms(t *testing.T) {
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := CMOVWOC(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWOC(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWOC(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWOC(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r16", func(t *testing.T) {
		if _, err := CMOVWOC(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWOC(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVWOSValidForms(t *testing.T) {
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := CMOVWOS(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWOS(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWOS(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWOS(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r16", func(t *testing.T) {
		if _, err := CMOVWOS(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWOS(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVWPCValidForms(t *testing.T) {
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := CMOVWPC(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWPC(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWPC(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWPC(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r16", func(t *testing.T) {
		if _, err := CMOVWPC(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWPC(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVWPLValidForms(t *testing.T) {
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := CMOVWPL(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWPL(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWPL(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWPL(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r16", func(t *testing.T) {
		if _, err := CMOVWPL(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWPL(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMOVWPSValidForms(t *testing.T) {
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := CMOVWPS(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWPS(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWPS(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWPS(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r16", func(t *testing.T) {
		if _, err := CMOVWPS(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMOVWPS(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMPBValidForms(t *testing.T) {
	t.Run("form=al_imm8", func(t *testing.T) {
		if _, err := CMPB(reg.AL, operand.Imm(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r8_imm8", func(t *testing.T) {
		if _, err := CMPB(reg.CH, operand.Imm(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPB(reg.BL, operand.Imm(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPB(reg.R13B, operand.Imm(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r8_r8", func(t *testing.T) {
		if _, err := CMPB(reg.CH, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPB(reg.CH, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPB(reg.CH, reg.R13B); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPB(reg.BL, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPB(reg.BL, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPB(reg.BL, reg.R13B); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPB(reg.R13B, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPB(reg.R13B, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPB(reg.R13B, reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r8_m8", func(t *testing.T) {
		if _, err := CMPB(reg.CH, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPB(reg.BL, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPB(reg.R13B, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8_imm8", func(t *testing.T) {
		if _, err := CMPB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, operand.Imm(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8_r8", func(t *testing.T) {
		if _, err := CMPB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMPLValidForms(t *testing.T) {
	t.Run("form=eax_imm32", func(t *testing.T) {
		if _, err := CMPL(reg.EAX, operand.Imm(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_imm8", func(t *testing.T) {
		if _, err := CMPL(reg.R10L, operand.Imm(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_imm32", func(t *testing.T) {
		if _, err := CMPL(reg.R10L, operand.Imm(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := CMPL(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_m32", func(t *testing.T) {
		if _, err := CMPL(reg.R10L, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_imm8", func(t *testing.T) {
		if _, err := CMPL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, operand.Imm(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_imm32", func(t *testing.T) {
		if _, err := CMPL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, operand.Imm(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := CMPL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMPPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_imm8", func(t *testing.T) {
		if _, err := CMPPD(reg.X7, reg.X7, operand.Imm(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_imm8", func(t *testing.T) {
		if _, err := CMPPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, operand.Imm(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMPPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_imm8", func(t *testing.T) {
		if _, err := CMPPS(reg.X7, reg.X7, operand.Imm(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_imm8", func(t *testing.T) {
		if _, err := CMPPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, operand.Imm(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMPQValidForms(t *testing.T) {
	t.Run("form=rax_imm32", func(t *testing.T) {
		if _, err := CMPQ(reg.RAX, operand.Imm(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_imm8", func(t *testing.T) {
		if _, err := CMPQ(reg.R11, operand.Imm(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_imm32", func(t *testing.T) {
		if _, err := CMPQ(reg.R11, operand.Imm(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := CMPQ(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_m64", func(t *testing.T) {
		if _, err := CMPQ(reg.R11, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_imm8", func(t *testing.T) {
		if _, err := CMPQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, operand.Imm(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_imm32", func(t *testing.T) {
		if _, err := CMPQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, operand.Imm(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := CMPQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMPSDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_imm8", func(t *testing.T) {
		if _, err := CMPSD(reg.X7, reg.X7, operand.Imm(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm_imm8", func(t *testing.T) {
		if _, err := CMPSD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, operand.Imm(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMPSSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_imm8", func(t *testing.T) {
		if _, err := CMPSS(reg.X7, reg.X7, operand.Imm(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm_imm8", func(t *testing.T) {
		if _, err := CMPSS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7, operand.Imm(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMPWValidForms(t *testing.T) {
	t.Run("form=ax_imm16", func(t *testing.T) {
		if _, err := CMPW(reg.AX, operand.Imm(math.MaxInt16)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_imm8", func(t *testing.T) {
		if _, err := CMPW(reg.CX, operand.Imm(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPW(reg.R9W, operand.Imm(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_imm16", func(t *testing.T) {
		if _, err := CMPW(reg.CX, operand.Imm(math.MaxInt16)); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPW(reg.R9W, operand.Imm(math.MaxInt16)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := CMPW(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPW(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPW(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPW(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_m16", func(t *testing.T) {
		if _, err := CMPW(reg.CX, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPW(reg.R9W, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_imm8", func(t *testing.T) {
		if _, err := CMPW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, operand.Imm(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_imm16", func(t *testing.T) {
		if _, err := CMPW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, operand.Imm(math.MaxInt16)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r16", func(t *testing.T) {
		if _, err := CMPW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMPXCHG16BValidForms(t *testing.T) {
	t.Run("form=m128", func(t *testing.T) {
		if _, err := CMPXCHG16B(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMPXCHG8BValidForms(t *testing.T) {
	t.Run("form=m64", func(t *testing.T) {
		if _, err := CMPXCHG8B(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMPXCHGBValidForms(t *testing.T) {
	t.Run("form=r8_r8", func(t *testing.T) {
		if _, err := CMPXCHGB(reg.CH, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPXCHGB(reg.CH, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPXCHGB(reg.CH, reg.R13B); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPXCHGB(reg.BL, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPXCHGB(reg.BL, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPXCHGB(reg.BL, reg.R13B); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPXCHGB(reg.R13B, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPXCHGB(reg.R13B, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPXCHGB(reg.R13B, reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r8_m8", func(t *testing.T) {
		if _, err := CMPXCHGB(reg.CH, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPXCHGB(reg.BL, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPXCHGB(reg.R13B, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMPXCHGLValidForms(t *testing.T) {
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := CMPXCHGL(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_m32", func(t *testing.T) {
		if _, err := CMPXCHGL(reg.R10L, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMPXCHGQValidForms(t *testing.T) {
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := CMPXCHGQ(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_m64", func(t *testing.T) {
		if _, err := CMPXCHGQ(reg.R11, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCMPXCHGWValidForms(t *testing.T) {
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := CMPXCHGW(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPXCHGW(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPXCHGW(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPXCHGW(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_m16", func(t *testing.T) {
		if _, err := CMPXCHGW(reg.CX, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
		if _, err := CMPXCHGW(reg.R9W, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCOMISDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := COMISD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := COMISD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCOMISSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := COMISS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm", func(t *testing.T) {
		if _, err := COMISS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCPUIDValidForms(t *testing.T) {
	t.Run("form=", func(t *testing.T) {
		if _, err := CPUID(); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCQOValidForms(t *testing.T) {
	t.Run("form=", func(t *testing.T) {
		if _, err := CQO(); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCRC32BValidForms(t *testing.T) {
	t.Run("form=r8_r32", func(t *testing.T) {
		if _, err := CRC32B(reg.CH, reg.R10L); err != nil {
			t.Fatal(err)
		}
		if _, err := CRC32B(reg.BL, reg.R10L); err != nil {
			t.Fatal(err)
		}
		if _, err := CRC32B(reg.R13B, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8_r32", func(t *testing.T) {
		if _, err := CRC32B(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r8_r64", func(t *testing.T) {
		if _, err := CRC32B(reg.CH, reg.R11); err != nil {
			t.Fatal(err)
		}
		if _, err := CRC32B(reg.BL, reg.R11); err != nil {
			t.Fatal(err)
		}
		if _, err := CRC32B(reg.R13B, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8_r64", func(t *testing.T) {
		if _, err := CRC32B(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCRC32LValidForms(t *testing.T) {
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := CRC32L(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := CRC32L(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCRC32QValidForms(t *testing.T) {
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := CRC32Q(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := CRC32Q(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCRC32WValidForms(t *testing.T) {
	t.Run("form=r16_r32", func(t *testing.T) {
		if _, err := CRC32W(reg.CX, reg.R10L); err != nil {
			t.Fatal(err)
		}
		if _, err := CRC32W(reg.R9W, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r32", func(t *testing.T) {
		if _, err := CRC32W(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCVTPD2PLValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := CVTPD2PL(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := CVTPD2PL(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCVTPD2PSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := CVTPD2PS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := CVTPD2PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCVTPL2PDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := CVTPL2PD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := CVTPL2PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCVTPL2PSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := CVTPL2PS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := CVTPL2PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCVTPS2PDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := CVTPS2PD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := CVTPS2PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCVTPS2PLValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := CVTPS2PL(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := CVTPS2PL(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCVTSD2SLValidForms(t *testing.T) {
	t.Run("form=xmm_r32", func(t *testing.T) {
		if _, err := CVTSD2SL(reg.X7, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r32", func(t *testing.T) {
		if _, err := CVTSD2SL(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_r64", func(t *testing.T) {
		if _, err := CVTSD2SL(reg.X7, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := CVTSD2SL(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCVTSD2SSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := CVTSD2SS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := CVTSD2SS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCVTSL2SDValidForms(t *testing.T) {
	t.Run("form=r32_xmm", func(t *testing.T) {
		if _, err := CVTSL2SD(reg.R10L, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm", func(t *testing.T) {
		if _, err := CVTSL2SD(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCVTSL2SSValidForms(t *testing.T) {
	t.Run("form=r32_xmm", func(t *testing.T) {
		if _, err := CVTSL2SS(reg.R10L, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm", func(t *testing.T) {
		if _, err := CVTSL2SS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCVTSQ2SDValidForms(t *testing.T) {
	t.Run("form=r64_xmm", func(t *testing.T) {
		if _, err := CVTSQ2SD(reg.R11, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := CVTSQ2SD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCVTSQ2SSValidForms(t *testing.T) {
	t.Run("form=r64_xmm", func(t *testing.T) {
		if _, err := CVTSQ2SS(reg.R11, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := CVTSQ2SS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCVTSS2SDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := CVTSS2SD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm", func(t *testing.T) {
		if _, err := CVTSS2SD(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCVTSS2SLValidForms(t *testing.T) {
	t.Run("form=xmm_r32", func(t *testing.T) {
		if _, err := CVTSS2SL(reg.X7, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := CVTSS2SL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_r64", func(t *testing.T) {
		if _, err := CVTSS2SL(reg.X7, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r64", func(t *testing.T) {
		if _, err := CVTSS2SL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCVTTPD2PLValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := CVTTPD2PL(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := CVTTPD2PL(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCVTTPS2PLValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := CVTTPS2PL(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := CVTTPS2PL(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCVTTSD2SLValidForms(t *testing.T) {
	t.Run("form=xmm_r32", func(t *testing.T) {
		if _, err := CVTTSD2SL(reg.X7, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r32", func(t *testing.T) {
		if _, err := CVTTSD2SL(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCVTTSD2SQValidForms(t *testing.T) {
	t.Run("form=xmm_r64", func(t *testing.T) {
		if _, err := CVTTSD2SQ(reg.X7, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := CVTTSD2SQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCVTTSS2SLValidForms(t *testing.T) {
	t.Run("form=xmm_r32", func(t *testing.T) {
		if _, err := CVTTSS2SL(reg.X7, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := CVTTSS2SL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_r64", func(t *testing.T) {
		if _, err := CVTTSS2SL(reg.X7, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r64", func(t *testing.T) {
		if _, err := CVTTSS2SL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCWDValidForms(t *testing.T) {
	t.Run("form=", func(t *testing.T) {
		if _, err := CWD(); err != nil {
			t.Fatal(err)
		}
	})
}

func TestCWDEValidForms(t *testing.T) {
	t.Run("form=", func(t *testing.T) {
		if _, err := CWDE(); err != nil {
			t.Fatal(err)
		}
	})
}

func TestDECBValidForms(t *testing.T) {
	t.Run("form=r8", func(t *testing.T) {
		if _, err := DECB(reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := DECB(reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := DECB(reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8", func(t *testing.T) {
		if _, err := DECB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestDECLValidForms(t *testing.T) {
	t.Run("form=r32", func(t *testing.T) {
		if _, err := DECL(reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32", func(t *testing.T) {
		if _, err := DECL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestDECQValidForms(t *testing.T) {
	t.Run("form=r64", func(t *testing.T) {
		if _, err := DECQ(reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64", func(t *testing.T) {
		if _, err := DECQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestDECWValidForms(t *testing.T) {
	t.Run("form=r16", func(t *testing.T) {
		if _, err := DECW(reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := DECW(reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16", func(t *testing.T) {
		if _, err := DECW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestDIVBValidForms(t *testing.T) {
	t.Run("form=r8", func(t *testing.T) {
		if _, err := DIVB(reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := DIVB(reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := DIVB(reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8", func(t *testing.T) {
		if _, err := DIVB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestDIVLValidForms(t *testing.T) {
	t.Run("form=r32", func(t *testing.T) {
		if _, err := DIVL(reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32", func(t *testing.T) {
		if _, err := DIVL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestDIVPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := DIVPD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := DIVPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestDIVPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := DIVPS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := DIVPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestDIVQValidForms(t *testing.T) {
	t.Run("form=r64", func(t *testing.T) {
		if _, err := DIVQ(reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64", func(t *testing.T) {
		if _, err := DIVQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestDIVSDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := DIVSD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := DIVSD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestDIVSSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := DIVSS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm", func(t *testing.T) {
		if _, err := DIVSS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestDIVWValidForms(t *testing.T) {
	t.Run("form=r16", func(t *testing.T) {
		if _, err := DIVW(reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := DIVW(reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16", func(t *testing.T) {
		if _, err := DIVW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestDPPDValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := DPPD(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm", func(t *testing.T) {
		if _, err := DPPD(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestDPPSValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := DPPS(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm", func(t *testing.T) {
		if _, err := DPPS(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestEXTRACTPSValidForms(t *testing.T) {
	t.Run("form=imm2u_xmm_r32", func(t *testing.T) {
		if _, err := EXTRACTPS(operand.Imm(1), reg.X7, reg.R10L); err != nil {
			t.Fatal(err)
		}
		if _, err := EXTRACTPS(operand.Imm(3), reg.X7, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm2u_xmm_m32", func(t *testing.T) {
		if _, err := EXTRACTPS(operand.Imm(1), reg.X7, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
		if _, err := EXTRACTPS(operand.Imm(3), reg.X7, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestHADDPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := HADDPD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := HADDPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestHADDPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := HADDPS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := HADDPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestHSUBPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := HSUBPD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := HSUBPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestHSUBPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := HSUBPS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := HSUBPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestIDIVBValidForms(t *testing.T) {
	t.Run("form=r8", func(t *testing.T) {
		if _, err := IDIVB(reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := IDIVB(reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := IDIVB(reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8", func(t *testing.T) {
		if _, err := IDIVB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestIDIVLValidForms(t *testing.T) {
	t.Run("form=r32", func(t *testing.T) {
		if _, err := IDIVL(reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32", func(t *testing.T) {
		if _, err := IDIVL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestIDIVQValidForms(t *testing.T) {
	t.Run("form=r64", func(t *testing.T) {
		if _, err := IDIVQ(reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64", func(t *testing.T) {
		if _, err := IDIVQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestIDIVWValidForms(t *testing.T) {
	t.Run("form=r16", func(t *testing.T) {
		if _, err := IDIVW(reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := IDIVW(reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16", func(t *testing.T) {
		if _, err := IDIVW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestIMUL3LValidForms(t *testing.T) {
	t.Run("form=imm8_r32_r32", func(t *testing.T) {
		if _, err := IMUL3L(operand.Imm(math.MaxInt8), reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_r32_r32", func(t *testing.T) {
		if _, err := IMUL3L(operand.Imm(math.MaxInt32), reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m32_r32", func(t *testing.T) {
		if _, err := IMUL3L(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_m32_r32", func(t *testing.T) {
		if _, err := IMUL3L(operand.Imm(math.MaxInt32), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestIMUL3QValidForms(t *testing.T) {
	t.Run("form=imm8_r64_r64", func(t *testing.T) {
		if _, err := IMUL3Q(operand.Imm(math.MaxInt8), reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_r64_r64", func(t *testing.T) {
		if _, err := IMUL3Q(operand.Imm(math.MaxInt32), reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m64_r64", func(t *testing.T) {
		if _, err := IMUL3Q(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_m64_r64", func(t *testing.T) {
		if _, err := IMUL3Q(operand.Imm(math.MaxInt32), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestIMUL3WValidForms(t *testing.T) {
	t.Run("form=imm8_r16_r16", func(t *testing.T) {
		if _, err := IMUL3W(operand.Imm(math.MaxInt8), reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := IMUL3W(operand.Imm(math.MaxInt8), reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := IMUL3W(operand.Imm(math.MaxInt8), reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := IMUL3W(operand.Imm(math.MaxInt8), reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm16_r16_r16", func(t *testing.T) {
		if _, err := IMUL3W(operand.Imm(math.MaxInt16), reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := IMUL3W(operand.Imm(math.MaxInt16), reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := IMUL3W(operand.Imm(math.MaxInt16), reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := IMUL3W(operand.Imm(math.MaxInt16), reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m16_r16", func(t *testing.T) {
		if _, err := IMUL3W(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := IMUL3W(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm16_m16_r16", func(t *testing.T) {
		if _, err := IMUL3W(operand.Imm(math.MaxInt16), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := IMUL3W(operand.Imm(math.MaxInt16), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
}

func TestIMULBValidForms(t *testing.T) {
	t.Run("form=r8", func(t *testing.T) {
		if _, err := IMULB(reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := IMULB(reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := IMULB(reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8", func(t *testing.T) {
		if _, err := IMULB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestIMULLValidForms(t *testing.T) {
	t.Run("form=r32", func(t *testing.T) {
		if _, err := IMULL(reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32", func(t *testing.T) {
		if _, err := IMULL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := IMULL(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := IMULL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestIMULQValidForms(t *testing.T) {
	t.Run("form=r64", func(t *testing.T) {
		if _, err := IMULQ(reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64", func(t *testing.T) {
		if _, err := IMULQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := IMULQ(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := IMULQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestIMULWValidForms(t *testing.T) {
	t.Run("form=r16", func(t *testing.T) {
		if _, err := IMULW(reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := IMULW(reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16", func(t *testing.T) {
		if _, err := IMULW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := IMULW(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := IMULW(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := IMULW(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := IMULW(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r16", func(t *testing.T) {
		if _, err := IMULW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := IMULW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
}

func TestINCBValidForms(t *testing.T) {
	t.Run("form=r8", func(t *testing.T) {
		if _, err := INCB(reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := INCB(reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := INCB(reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8", func(t *testing.T) {
		if _, err := INCB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestINCLValidForms(t *testing.T) {
	t.Run("form=r32", func(t *testing.T) {
		if _, err := INCL(reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32", func(t *testing.T) {
		if _, err := INCL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestINCQValidForms(t *testing.T) {
	t.Run("form=r64", func(t *testing.T) {
		if _, err := INCQ(reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64", func(t *testing.T) {
		if _, err := INCQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestINCWValidForms(t *testing.T) {
	t.Run("form=r16", func(t *testing.T) {
		if _, err := INCW(reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := INCW(reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16", func(t *testing.T) {
		if _, err := INCW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestINSERTPSValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := INSERTPS(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m32_xmm", func(t *testing.T) {
		if _, err := INSERTPS(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestINTValidForms(t *testing.T) {
	t.Run("form=3", func(t *testing.T) {
		if _, err := INT(operand.Imm(3)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8", func(t *testing.T) {
		if _, err := INT(operand.Imm(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJAValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JA(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JA(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JA(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJAEValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JAE(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JAE(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JAE(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJBValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JB(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JB(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JB(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJBEValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JBE(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JBE(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JBE(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJCValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JC(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JC(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JC(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJCCValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JCC(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JCC(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JCC(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJCSValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JCS(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JCS(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JCS(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJCXZLValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JCXZL(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJCXZQValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JCXZQ(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJEValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JE(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JE(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JE(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJEQValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JEQ(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JEQ(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JEQ(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJGValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JG(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JG(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JG(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJGEValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JGE(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JGE(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JGE(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJGTValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JGT(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JGT(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JGT(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJHIValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JHI(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JHI(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JHI(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJHSValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JHS(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JHS(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JHS(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJLValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JL(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JL(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JL(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJLEValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JLE(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JLE(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JLE(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJLOValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JLO(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JLO(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JLO(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJLSValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JLS(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JLS(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JLS(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJLTValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JLT(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JLT(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JLT(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJMIValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JMI(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JMI(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JMI(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJMPValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JMP(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JMP(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JMP(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64", func(t *testing.T) {
		if _, err := JMP(reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64", func(t *testing.T) {
		if _, err := JMP(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJNAValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JNA(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JNA(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JNA(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJNAEValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JNAE(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JNAE(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JNAE(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJNBValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JNB(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JNB(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JNB(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJNBEValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JNBE(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JNBE(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JNBE(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJNCValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JNC(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JNC(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JNC(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJNEValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JNE(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JNE(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JNE(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJNGValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JNG(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JNG(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JNG(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJNGEValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JNGE(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JNGE(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JNGE(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJNLValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JNL(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JNL(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JNL(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJNLEValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JNLE(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JNLE(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JNLE(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJNOValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JNO(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JNO(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JNO(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJNPValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JNP(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JNP(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JNP(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJNSValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JNS(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JNS(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JNS(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJNZValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JNZ(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JNZ(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JNZ(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJOValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JO(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JO(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JO(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJOCValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JOC(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JOC(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JOC(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJOSValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JOS(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JOS(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JOS(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJPValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JP(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JP(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JP(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJPCValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JPC(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JPC(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JPC(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJPEValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JPE(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JPE(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JPE(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJPLValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JPL(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JPL(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JPL(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJPOValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JPO(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JPO(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JPO(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJPSValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JPS(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JPS(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JPS(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJSValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JS(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JS(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JS(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestJZValidForms(t *testing.T) {
	t.Run("form=rel8", func(t *testing.T) {
		if _, err := JZ(operand.Rel(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rel32", func(t *testing.T) {
		if _, err := JZ(operand.Rel(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
		if _, err := JZ(operand.LabelRef("lbl")); err != nil {
			t.Fatal(err)
		}
	})
}

func TestLDDQUValidForms(t *testing.T) {
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := LDDQU(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestLDMXCSRValidForms(t *testing.T) {
	t.Run("form=m32", func(t *testing.T) {
		if _, err := LDMXCSR(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestLEALValidForms(t *testing.T) {
	t.Run("form=m_r32", func(t *testing.T) {
		if _, err := LEAL(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestLEAQValidForms(t *testing.T) {
	t.Run("form=m_r64", func(t *testing.T) {
		if _, err := LEAQ(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestLEAWValidForms(t *testing.T) {
	t.Run("form=m_r16", func(t *testing.T) {
		if _, err := LEAW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := LEAW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
}

func TestLFENCEValidForms(t *testing.T) {
	t.Run("form=", func(t *testing.T) {
		if _, err := LFENCE(); err != nil {
			t.Fatal(err)
		}
	})
}

func TestLZCNTLValidForms(t *testing.T) {
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := LZCNTL(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := LZCNTL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestLZCNTQValidForms(t *testing.T) {
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := LZCNTQ(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := LZCNTQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestLZCNTWValidForms(t *testing.T) {
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := LZCNTW(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := LZCNTW(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := LZCNTW(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := LZCNTW(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r16", func(t *testing.T) {
		if _, err := LZCNTW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := LZCNTW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMASKMOVDQUValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := MASKMOVDQU(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMASKMOVOUValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := MASKMOVOU(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMAXPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := MAXPD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := MAXPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMAXPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := MAXPS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := MAXPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMAXSDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := MAXSD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := MAXSD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMAXSSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := MAXSS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm", func(t *testing.T) {
		if _, err := MAXSS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMFENCEValidForms(t *testing.T) {
	t.Run("form=", func(t *testing.T) {
		if _, err := MFENCE(); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMINPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := MINPD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := MINPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMINPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := MINPS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := MINPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMINSDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := MINSD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := MINSD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMINSSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := MINSS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm", func(t *testing.T) {
		if _, err := MINSS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMONITORValidForms(t *testing.T) {
	t.Run("form=", func(t *testing.T) {
		if _, err := MONITOR(); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVAPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := MOVAPD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := MOVAPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_m128", func(t *testing.T) {
		if _, err := MOVAPD(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVAPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := MOVAPS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := MOVAPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_m128", func(t *testing.T) {
		if _, err := MOVAPS(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVBValidForms(t *testing.T) {
	t.Run("form=imm8_r8", func(t *testing.T) {
		if _, err := MOVB(operand.Imm(math.MaxInt8), reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVB(operand.Imm(math.MaxInt8), reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVB(operand.Imm(math.MaxInt8), reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r8_r8", func(t *testing.T) {
		if _, err := MOVB(reg.CH, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVB(reg.CH, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVB(reg.CH, reg.R13B); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVB(reg.BL, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVB(reg.BL, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVB(reg.BL, reg.R13B); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVB(reg.R13B, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVB(reg.R13B, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVB(reg.R13B, reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8_r8", func(t *testing.T) {
		if _, err := MOVB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m8", func(t *testing.T) {
		if _, err := MOVB(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r8_m8", func(t *testing.T) {
		if _, err := MOVB(reg.CH, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVB(reg.BL, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVB(reg.R13B, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVBELLValidForms(t *testing.T) {
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := MOVBELL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_m32", func(t *testing.T) {
		if _, err := MOVBELL(reg.R10L, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVBEQQValidForms(t *testing.T) {
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := MOVBEQQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_m64", func(t *testing.T) {
		if _, err := MOVBEQQ(reg.R11, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVBEWWValidForms(t *testing.T) {
	t.Run("form=m16_r16", func(t *testing.T) {
		if _, err := MOVBEWW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVBEWW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_m16", func(t *testing.T) {
		if _, err := MOVBEWW(reg.CX, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVBEWW(reg.R9W, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVBLSXValidForms(t *testing.T) {
	t.Run("form=r8_r32", func(t *testing.T) {
		if _, err := MOVBLSX(reg.CH, reg.R10L); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVBLSX(reg.BL, reg.R10L); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVBLSX(reg.R13B, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8_r32", func(t *testing.T) {
		if _, err := MOVBLSX(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVBLZXValidForms(t *testing.T) {
	t.Run("form=r8_r32", func(t *testing.T) {
		if _, err := MOVBLZX(reg.CH, reg.R10L); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVBLZX(reg.BL, reg.R10L); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVBLZX(reg.R13B, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8_r32", func(t *testing.T) {
		if _, err := MOVBLZX(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVBQSXValidForms(t *testing.T) {
	t.Run("form=r8_r64", func(t *testing.T) {
		if _, err := MOVBQSX(reg.CH, reg.R11); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVBQSX(reg.BL, reg.R11); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVBQSX(reg.R13B, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8_r64", func(t *testing.T) {
		if _, err := MOVBQSX(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVBQZXValidForms(t *testing.T) {
	t.Run("form=r8_r64", func(t *testing.T) {
		if _, err := MOVBQZX(reg.CH, reg.R11); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVBQZX(reg.BL, reg.R11); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVBQZX(reg.R13B, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8_r64", func(t *testing.T) {
		if _, err := MOVBQZX(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVBWSXValidForms(t *testing.T) {
	t.Run("form=r8_r16", func(t *testing.T) {
		if _, err := MOVBWSX(reg.CH, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVBWSX(reg.CH, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVBWSX(reg.BL, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVBWSX(reg.BL, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVBWSX(reg.R13B, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVBWSX(reg.R13B, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8_r16", func(t *testing.T) {
		if _, err := MOVBWSX(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVBWSX(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVBWZXValidForms(t *testing.T) {
	t.Run("form=r8_r16", func(t *testing.T) {
		if _, err := MOVBWZX(reg.CH, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVBWZX(reg.CH, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVBWZX(reg.BL, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVBWZX(reg.BL, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVBWZX(reg.R13B, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVBWZX(reg.R13B, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8_r16", func(t *testing.T) {
		if _, err := MOVBWZX(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVBWZX(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVDValidForms(t *testing.T) {
	t.Run("form=imm32_r64", func(t *testing.T) {
		if _, err := MOVD(operand.Imm(math.MaxInt32), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm64_r64", func(t *testing.T) {
		if _, err := MOVD(operand.Imm(math.MaxInt64), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := MOVD(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := MOVD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_m64", func(t *testing.T) {
		if _, err := MOVD(operand.Imm(math.MaxInt32), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_m64", func(t *testing.T) {
		if _, err := MOVD(reg.R11, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_r64", func(t *testing.T) {
		if _, err := MOVD(reg.X7, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_xmm", func(t *testing.T) {
		if _, err := MOVD(reg.R11, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := MOVD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := MOVD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_m64", func(t *testing.T) {
		if _, err := MOVD(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_r32", func(t *testing.T) {
		if _, err := MOVD(reg.X7, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_xmm", func(t *testing.T) {
		if _, err := MOVD(reg.R10L, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm", func(t *testing.T) {
		if _, err := MOVD(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_m32", func(t *testing.T) {
		if _, err := MOVD(reg.X7, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVDDUPValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := MOVDDUP(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := MOVDDUP(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVDQ2QValidForms(t *testing.T) {
	t.Run("form=imm32_r64", func(t *testing.T) {
		if _, err := MOVDQ2Q(operand.Imm(math.MaxInt32), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm64_r64", func(t *testing.T) {
		if _, err := MOVDQ2Q(operand.Imm(math.MaxInt64), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := MOVDQ2Q(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := MOVDQ2Q(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_m64", func(t *testing.T) {
		if _, err := MOVDQ2Q(operand.Imm(math.MaxInt32), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_m64", func(t *testing.T) {
		if _, err := MOVDQ2Q(reg.R11, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_r64", func(t *testing.T) {
		if _, err := MOVDQ2Q(reg.X7, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_xmm", func(t *testing.T) {
		if _, err := MOVDQ2Q(reg.R11, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := MOVDQ2Q(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := MOVDQ2Q(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_m64", func(t *testing.T) {
		if _, err := MOVDQ2Q(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_r32", func(t *testing.T) {
		if _, err := MOVDQ2Q(reg.X7, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_xmm", func(t *testing.T) {
		if _, err := MOVDQ2Q(reg.R10L, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm", func(t *testing.T) {
		if _, err := MOVDQ2Q(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_m32", func(t *testing.T) {
		if _, err := MOVDQ2Q(reg.X7, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVHLPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := MOVHLPS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVHPDValidForms(t *testing.T) {
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := MOVHPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_m64", func(t *testing.T) {
		if _, err := MOVHPD(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVHPSValidForms(t *testing.T) {
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := MOVHPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_m64", func(t *testing.T) {
		if _, err := MOVHPS(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVLValidForms(t *testing.T) {
	t.Run("form=imm32_r32", func(t *testing.T) {
		if _, err := MOVL(operand.Imm(math.MaxInt32), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := MOVL(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := MOVL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_m32", func(t *testing.T) {
		if _, err := MOVL(operand.Imm(math.MaxInt32), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_m32", func(t *testing.T) {
		if _, err := MOVL(reg.R10L, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVLHPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := MOVLHPS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVLPDValidForms(t *testing.T) {
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := MOVLPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_m64", func(t *testing.T) {
		if _, err := MOVLPD(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVLPSValidForms(t *testing.T) {
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := MOVLPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_m64", func(t *testing.T) {
		if _, err := MOVLPS(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVLQSXValidForms(t *testing.T) {
	t.Run("form=r32_r64", func(t *testing.T) {
		if _, err := MOVLQSX(reg.R10L, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r64", func(t *testing.T) {
		if _, err := MOVLQSX(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVLQZXValidForms(t *testing.T) {
	t.Run("form=m32_r64", func(t *testing.T) {
		if _, err := MOVLQZX(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVMSKPDValidForms(t *testing.T) {
	t.Run("form=xmm_r32", func(t *testing.T) {
		if _, err := MOVMSKPD(reg.X7, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVMSKPSValidForms(t *testing.T) {
	t.Run("form=xmm_r32", func(t *testing.T) {
		if _, err := MOVMSKPS(reg.X7, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVNTDQValidForms(t *testing.T) {
	t.Run("form=xmm_m128", func(t *testing.T) {
		if _, err := MOVNTDQ(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVNTDQAValidForms(t *testing.T) {
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := MOVNTDQA(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVNTILValidForms(t *testing.T) {
	t.Run("form=r32_m32", func(t *testing.T) {
		if _, err := MOVNTIL(reg.R10L, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVNTIQValidForms(t *testing.T) {
	t.Run("form=r64_m64", func(t *testing.T) {
		if _, err := MOVNTIQ(reg.R11, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVNTOValidForms(t *testing.T) {
	t.Run("form=xmm_m128", func(t *testing.T) {
		if _, err := MOVNTO(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVNTPDValidForms(t *testing.T) {
	t.Run("form=xmm_m128", func(t *testing.T) {
		if _, err := MOVNTPD(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVNTPSValidForms(t *testing.T) {
	t.Run("form=xmm_m128", func(t *testing.T) {
		if _, err := MOVNTPS(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVOValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := MOVO(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := MOVO(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_m128", func(t *testing.T) {
		if _, err := MOVO(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVOAValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := MOVOA(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := MOVOA(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_m128", func(t *testing.T) {
		if _, err := MOVOA(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVOUValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := MOVOU(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := MOVOU(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_m128", func(t *testing.T) {
		if _, err := MOVOU(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVQValidForms(t *testing.T) {
	t.Run("form=imm32_r64", func(t *testing.T) {
		if _, err := MOVQ(operand.Imm(math.MaxInt32), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm64_r64", func(t *testing.T) {
		if _, err := MOVQ(operand.Imm(math.MaxInt64), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := MOVQ(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := MOVQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_m64", func(t *testing.T) {
		if _, err := MOVQ(operand.Imm(math.MaxInt32), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_m64", func(t *testing.T) {
		if _, err := MOVQ(reg.R11, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_r64", func(t *testing.T) {
		if _, err := MOVQ(reg.X7, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_xmm", func(t *testing.T) {
		if _, err := MOVQ(reg.R11, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := MOVQ(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := MOVQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_m64", func(t *testing.T) {
		if _, err := MOVQ(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_r32", func(t *testing.T) {
		if _, err := MOVQ(reg.X7, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_xmm", func(t *testing.T) {
		if _, err := MOVQ(reg.R10L, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm", func(t *testing.T) {
		if _, err := MOVQ(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_m32", func(t *testing.T) {
		if _, err := MOVQ(reg.X7, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVSDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := MOVSD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := MOVSD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_m64", func(t *testing.T) {
		if _, err := MOVSD(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVSHDUPValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := MOVSHDUP(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := MOVSHDUP(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVSLDUPValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := MOVSLDUP(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := MOVSLDUP(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVSSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := MOVSS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm", func(t *testing.T) {
		if _, err := MOVSS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_m32", func(t *testing.T) {
		if _, err := MOVSS(reg.X7, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVUPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := MOVUPD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := MOVUPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_m128", func(t *testing.T) {
		if _, err := MOVUPD(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVUPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := MOVUPS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := MOVUPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_m128", func(t *testing.T) {
		if _, err := MOVUPS(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVWValidForms(t *testing.T) {
	t.Run("form=imm16_r16", func(t *testing.T) {
		if _, err := MOVW(operand.Imm(math.MaxInt16), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVW(operand.Imm(math.MaxInt16), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := MOVW(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVW(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVW(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVW(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r16", func(t *testing.T) {
		if _, err := MOVW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm16_m16", func(t *testing.T) {
		if _, err := MOVW(operand.Imm(math.MaxInt16), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_m16", func(t *testing.T) {
		if _, err := MOVW(reg.CX, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVW(reg.R9W, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVWLSXValidForms(t *testing.T) {
	t.Run("form=r16_r32", func(t *testing.T) {
		if _, err := MOVWLSX(reg.CX, reg.R10L); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVWLSX(reg.R9W, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r32", func(t *testing.T) {
		if _, err := MOVWLSX(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVWLZXValidForms(t *testing.T) {
	t.Run("form=r16_r32", func(t *testing.T) {
		if _, err := MOVWLZX(reg.CX, reg.R10L); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVWLZX(reg.R9W, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r32", func(t *testing.T) {
		if _, err := MOVWLZX(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVWQSXValidForms(t *testing.T) {
	t.Run("form=r16_r64", func(t *testing.T) {
		if _, err := MOVWQSX(reg.CX, reg.R11); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVWQSX(reg.R9W, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r64", func(t *testing.T) {
		if _, err := MOVWQSX(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMOVWQZXValidForms(t *testing.T) {
	t.Run("form=r16_r64", func(t *testing.T) {
		if _, err := MOVWQZX(reg.CX, reg.R11); err != nil {
			t.Fatal(err)
		}
		if _, err := MOVWQZX(reg.R9W, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r64", func(t *testing.T) {
		if _, err := MOVWQZX(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMPSADBWValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := MPSADBW(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm", func(t *testing.T) {
		if _, err := MPSADBW(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMULBValidForms(t *testing.T) {
	t.Run("form=r8", func(t *testing.T) {
		if _, err := MULB(reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := MULB(reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := MULB(reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8", func(t *testing.T) {
		if _, err := MULB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMULLValidForms(t *testing.T) {
	t.Run("form=r32", func(t *testing.T) {
		if _, err := MULL(reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32", func(t *testing.T) {
		if _, err := MULL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMULPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := MULPD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := MULPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMULPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := MULPS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := MULPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMULQValidForms(t *testing.T) {
	t.Run("form=r64", func(t *testing.T) {
		if _, err := MULQ(reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64", func(t *testing.T) {
		if _, err := MULQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMULSDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := MULSD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := MULSD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMULSSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := MULSS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm", func(t *testing.T) {
		if _, err := MULSS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMULWValidForms(t *testing.T) {
	t.Run("form=r16", func(t *testing.T) {
		if _, err := MULW(reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := MULW(reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16", func(t *testing.T) {
		if _, err := MULW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMULXLValidForms(t *testing.T) {
	t.Run("form=r32_r32_r32", func(t *testing.T) {
		if _, err := MULXL(reg.R10L, reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32_r32", func(t *testing.T) {
		if _, err := MULXL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMULXQValidForms(t *testing.T) {
	t.Run("form=r64_r64_r64", func(t *testing.T) {
		if _, err := MULXQ(reg.R11, reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64_r64", func(t *testing.T) {
		if _, err := MULXQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestMWAITValidForms(t *testing.T) {
	t.Run("form=", func(t *testing.T) {
		if _, err := MWAIT(); err != nil {
			t.Fatal(err)
		}
	})
}

func TestNEGBValidForms(t *testing.T) {
	t.Run("form=r8", func(t *testing.T) {
		if _, err := NEGB(reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := NEGB(reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := NEGB(reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8", func(t *testing.T) {
		if _, err := NEGB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestNEGLValidForms(t *testing.T) {
	t.Run("form=r32", func(t *testing.T) {
		if _, err := NEGL(reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32", func(t *testing.T) {
		if _, err := NEGL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestNEGQValidForms(t *testing.T) {
	t.Run("form=r64", func(t *testing.T) {
		if _, err := NEGQ(reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64", func(t *testing.T) {
		if _, err := NEGQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestNEGWValidForms(t *testing.T) {
	t.Run("form=r16", func(t *testing.T) {
		if _, err := NEGW(reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := NEGW(reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16", func(t *testing.T) {
		if _, err := NEGW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestNOPValidForms(t *testing.T) {
	t.Run("form=", func(t *testing.T) {
		if _, err := NOP(); err != nil {
			t.Fatal(err)
		}
	})
}

func TestNOTBValidForms(t *testing.T) {
	t.Run("form=r8", func(t *testing.T) {
		if _, err := NOTB(reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := NOTB(reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := NOTB(reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8", func(t *testing.T) {
		if _, err := NOTB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestNOTLValidForms(t *testing.T) {
	t.Run("form=r32", func(t *testing.T) {
		if _, err := NOTL(reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32", func(t *testing.T) {
		if _, err := NOTL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestNOTQValidForms(t *testing.T) {
	t.Run("form=r64", func(t *testing.T) {
		if _, err := NOTQ(reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64", func(t *testing.T) {
		if _, err := NOTQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestNOTWValidForms(t *testing.T) {
	t.Run("form=r16", func(t *testing.T) {
		if _, err := NOTW(reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := NOTW(reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16", func(t *testing.T) {
		if _, err := NOTW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestORBValidForms(t *testing.T) {
	t.Run("form=imm8_al", func(t *testing.T) {
		if _, err := ORB(operand.Imm(math.MaxInt8), reg.AL); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r8", func(t *testing.T) {
		if _, err := ORB(operand.Imm(math.MaxInt8), reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := ORB(operand.Imm(math.MaxInt8), reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := ORB(operand.Imm(math.MaxInt8), reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r8_r8", func(t *testing.T) {
		if _, err := ORB(reg.CH, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := ORB(reg.CH, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := ORB(reg.CH, reg.R13B); err != nil {
			t.Fatal(err)
		}
		if _, err := ORB(reg.BL, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := ORB(reg.BL, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := ORB(reg.BL, reg.R13B); err != nil {
			t.Fatal(err)
		}
		if _, err := ORB(reg.R13B, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := ORB(reg.R13B, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := ORB(reg.R13B, reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8_r8", func(t *testing.T) {
		if _, err := ORB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := ORB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := ORB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m8", func(t *testing.T) {
		if _, err := ORB(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r8_m8", func(t *testing.T) {
		if _, err := ORB(reg.CH, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
		if _, err := ORB(reg.BL, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
		if _, err := ORB(reg.R13B, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestORLValidForms(t *testing.T) {
	t.Run("form=imm32_eax", func(t *testing.T) {
		if _, err := ORL(operand.Imm(math.MaxInt32), reg.EAX); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r32", func(t *testing.T) {
		if _, err := ORL(operand.Imm(math.MaxInt8), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_r32", func(t *testing.T) {
		if _, err := ORL(operand.Imm(math.MaxInt32), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := ORL(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := ORL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m32", func(t *testing.T) {
		if _, err := ORL(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_m32", func(t *testing.T) {
		if _, err := ORL(operand.Imm(math.MaxInt32), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_m32", func(t *testing.T) {
		if _, err := ORL(reg.R10L, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestORPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := ORPD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := ORPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestORPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := ORPS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := ORPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestORQValidForms(t *testing.T) {
	t.Run("form=imm32_rax", func(t *testing.T) {
		if _, err := ORQ(operand.Imm(math.MaxInt32), reg.RAX); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r64", func(t *testing.T) {
		if _, err := ORQ(operand.Imm(math.MaxInt8), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_r64", func(t *testing.T) {
		if _, err := ORQ(operand.Imm(math.MaxInt32), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := ORQ(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := ORQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m64", func(t *testing.T) {
		if _, err := ORQ(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_m64", func(t *testing.T) {
		if _, err := ORQ(operand.Imm(math.MaxInt32), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_m64", func(t *testing.T) {
		if _, err := ORQ(reg.R11, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestORWValidForms(t *testing.T) {
	t.Run("form=imm16_ax", func(t *testing.T) {
		if _, err := ORW(operand.Imm(math.MaxInt16), reg.AX); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r16", func(t *testing.T) {
		if _, err := ORW(operand.Imm(math.MaxInt8), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := ORW(operand.Imm(math.MaxInt8), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm16_r16", func(t *testing.T) {
		if _, err := ORW(operand.Imm(math.MaxInt16), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := ORW(operand.Imm(math.MaxInt16), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := ORW(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := ORW(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := ORW(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := ORW(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r16", func(t *testing.T) {
		if _, err := ORW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := ORW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m16", func(t *testing.T) {
		if _, err := ORW(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm16_m16", func(t *testing.T) {
		if _, err := ORW(operand.Imm(math.MaxInt16), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_m16", func(t *testing.T) {
		if _, err := ORW(reg.CX, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
		if _, err := ORW(reg.R9W, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPABSBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PABSB(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PABSB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPABSDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PABSD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PABSD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPABSWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PABSW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PABSW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPACKSSLWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PACKSSLW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PACKSSLW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPACKSSWBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PACKSSWB(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PACKSSWB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPACKUSDWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PACKUSDW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PACKUSDW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPACKUSWBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PACKUSWB(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PACKUSWB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPADDBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PADDB(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PADDB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPADDDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PADDD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PADDD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPADDLValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PADDL(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PADDL(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPADDQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PADDQ(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PADDQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPADDSBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PADDSB(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PADDSB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPADDSWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PADDSW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PADDSW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPADDUSBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PADDUSB(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PADDUSB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPADDUSWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PADDUSW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PADDUSW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPADDWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PADDW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PADDW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPALIGNRValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := PALIGNR(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm", func(t *testing.T) {
		if _, err := PALIGNR(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPANDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PAND(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PAND(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPANDNValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PANDN(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PANDN(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPAUSEValidForms(t *testing.T) {
	t.Run("form=", func(t *testing.T) {
		if _, err := PAUSE(); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPAVGBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PAVGB(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PAVGB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPAVGWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PAVGW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PAVGW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPBLENDVBValidForms(t *testing.T) {
	t.Run("form=xmm0_xmm_xmm", func(t *testing.T) {
		if _, err := PBLENDVB(reg.X0, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm0_m128_xmm", func(t *testing.T) {
		if _, err := PBLENDVB(reg.X0, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPBLENDWValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := PBLENDW(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm", func(t *testing.T) {
		if _, err := PBLENDW(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPCLMULQDQValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := PCLMULQDQ(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm", func(t *testing.T) {
		if _, err := PCLMULQDQ(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPCMPEQBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PCMPEQB(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PCMPEQB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPCMPEQLValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PCMPEQL(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PCMPEQL(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPCMPEQQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PCMPEQQ(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PCMPEQQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPCMPEQWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PCMPEQW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PCMPEQW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPCMPESTRIValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := PCMPESTRI(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm", func(t *testing.T) {
		if _, err := PCMPESTRI(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPCMPESTRMValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := PCMPESTRM(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm", func(t *testing.T) {
		if _, err := PCMPESTRM(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPCMPGTBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PCMPGTB(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PCMPGTB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPCMPGTLValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PCMPGTL(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PCMPGTL(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPCMPGTQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PCMPGTQ(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PCMPGTQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPCMPGTWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PCMPGTW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PCMPGTW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPCMPISTRIValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := PCMPISTRI(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm", func(t *testing.T) {
		if _, err := PCMPISTRI(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPCMPISTRMValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := PCMPISTRM(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm", func(t *testing.T) {
		if _, err := PCMPISTRM(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPDEPLValidForms(t *testing.T) {
	t.Run("form=r32_r32_r32", func(t *testing.T) {
		if _, err := PDEPL(reg.R10L, reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32_r32", func(t *testing.T) {
		if _, err := PDEPL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPDEPQValidForms(t *testing.T) {
	t.Run("form=r64_r64_r64", func(t *testing.T) {
		if _, err := PDEPQ(reg.R11, reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64_r64", func(t *testing.T) {
		if _, err := PDEPQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPEXTLValidForms(t *testing.T) {
	t.Run("form=r32_r32_r32", func(t *testing.T) {
		if _, err := PEXTL(reg.R10L, reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32_r32", func(t *testing.T) {
		if _, err := PEXTL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPEXTQValidForms(t *testing.T) {
	t.Run("form=r64_r64_r64", func(t *testing.T) {
		if _, err := PEXTQ(reg.R11, reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64_r64", func(t *testing.T) {
		if _, err := PEXTQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPEXTRBValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_r32", func(t *testing.T) {
		if _, err := PEXTRB(operand.Imm(math.MaxInt8), reg.X7, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_xmm_m8", func(t *testing.T) {
		if _, err := PEXTRB(operand.Imm(math.MaxInt8), reg.X7, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPEXTRDValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_r32", func(t *testing.T) {
		if _, err := PEXTRD(operand.Imm(math.MaxInt8), reg.X7, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_xmm_m32", func(t *testing.T) {
		if _, err := PEXTRD(operand.Imm(math.MaxInt8), reg.X7, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPEXTRQValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_r64", func(t *testing.T) {
		if _, err := PEXTRQ(operand.Imm(math.MaxInt8), reg.X7, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_xmm_m64", func(t *testing.T) {
		if _, err := PEXTRQ(operand.Imm(math.MaxInt8), reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPEXTRWValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_r32", func(t *testing.T) {
		if _, err := PEXTRW(operand.Imm(math.MaxInt8), reg.X7, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_xmm_m16", func(t *testing.T) {
		if _, err := PEXTRW(operand.Imm(math.MaxInt8), reg.X7, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPHADDDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PHADDD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PHADDD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPHADDSWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PHADDSW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PHADDSW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPHADDWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PHADDW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PHADDW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPHMINPOSUWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PHMINPOSUW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PHMINPOSUW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPHSUBDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PHSUBD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PHSUBD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPHSUBSWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PHSUBSW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PHSUBSW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPHSUBWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PHSUBW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PHSUBW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPINSRBValidForms(t *testing.T) {
	t.Run("form=imm8_r32_xmm", func(t *testing.T) {
		if _, err := PINSRB(operand.Imm(math.MaxInt8), reg.R10L, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m8_xmm", func(t *testing.T) {
		if _, err := PINSRB(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPINSRDValidForms(t *testing.T) {
	t.Run("form=imm8_r32_xmm", func(t *testing.T) {
		if _, err := PINSRD(operand.Imm(math.MaxInt8), reg.R10L, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m32_xmm", func(t *testing.T) {
		if _, err := PINSRD(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPINSRQValidForms(t *testing.T) {
	t.Run("form=imm8_r64_xmm", func(t *testing.T) {
		if _, err := PINSRQ(operand.Imm(math.MaxInt8), reg.R11, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m64_xmm", func(t *testing.T) {
		if _, err := PINSRQ(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPINSRWValidForms(t *testing.T) {
	t.Run("form=imm8_r32_xmm", func(t *testing.T) {
		if _, err := PINSRW(operand.Imm(math.MaxInt8), reg.R10L, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m16_xmm", func(t *testing.T) {
		if _, err := PINSRW(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMADDUBSWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PMADDUBSW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PMADDUBSW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMADDWLValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PMADDWL(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PMADDWL(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMAXSBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PMAXSB(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PMAXSB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMAXSDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PMAXSD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PMAXSD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMAXSWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PMAXSW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PMAXSW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMAXUBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PMAXUB(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PMAXUB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMAXUDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PMAXUD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PMAXUD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMAXUWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PMAXUW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PMAXUW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMINSBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PMINSB(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PMINSB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMINSDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PMINSD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PMINSD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMINSWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PMINSW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PMINSW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMINUBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PMINUB(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PMINUB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMINUDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PMINUD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PMINUD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMINUWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PMINUW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PMINUW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMOVMSKBValidForms(t *testing.T) {
	t.Run("form=xmm_r32", func(t *testing.T) {
		if _, err := PMOVMSKB(reg.X7, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMOVSXBDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PMOVSXBD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm", func(t *testing.T) {
		if _, err := PMOVSXBD(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMOVSXBQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PMOVSXBQ(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_xmm", func(t *testing.T) {
		if _, err := PMOVSXBQ(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMOVSXBWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PMOVSXBW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := PMOVSXBW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMOVSXDQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PMOVSXDQ(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := PMOVSXDQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMOVSXWDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PMOVSXWD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := PMOVSXWD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMOVSXWQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PMOVSXWQ(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm", func(t *testing.T) {
		if _, err := PMOVSXWQ(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMOVZXBDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PMOVZXBD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm", func(t *testing.T) {
		if _, err := PMOVZXBD(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMOVZXBQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PMOVZXBQ(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_xmm", func(t *testing.T) {
		if _, err := PMOVZXBQ(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMOVZXBWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PMOVZXBW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := PMOVZXBW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMOVZXDQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PMOVZXDQ(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := PMOVZXDQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMOVZXWDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PMOVZXWD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := PMOVZXWD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMOVZXWQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PMOVZXWQ(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm", func(t *testing.T) {
		if _, err := PMOVZXWQ(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMULDQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PMULDQ(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PMULDQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMULHRSWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PMULHRSW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PMULHRSW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMULHUWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PMULHUW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PMULHUW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMULHWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PMULHW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PMULHW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMULLDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PMULLD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PMULLD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMULLWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PMULLW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PMULLW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPMULULQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PMULULQ(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PMULULQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPOPCNTLValidForms(t *testing.T) {
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := POPCNTL(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := POPCNTL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPOPCNTQValidForms(t *testing.T) {
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := POPCNTQ(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := POPCNTQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPOPCNTWValidForms(t *testing.T) {
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := POPCNTW(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := POPCNTW(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := POPCNTW(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := POPCNTW(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r16", func(t *testing.T) {
		if _, err := POPCNTW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := POPCNTW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPOPQValidForms(t *testing.T) {
	t.Run("form=r64", func(t *testing.T) {
		if _, err := POPQ(reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64", func(t *testing.T) {
		if _, err := POPQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPOPWValidForms(t *testing.T) {
	t.Run("form=r16", func(t *testing.T) {
		if _, err := POPW(reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := POPW(reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16", func(t *testing.T) {
		if _, err := POPW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPORValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := POR(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := POR(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPREFETCHNTAValidForms(t *testing.T) {
	t.Run("form=m8", func(t *testing.T) {
		if _, err := PREFETCHNTA(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPREFETCHT0ValidForms(t *testing.T) {
	t.Run("form=m8", func(t *testing.T) {
		if _, err := PREFETCHT0(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPREFETCHT1ValidForms(t *testing.T) {
	t.Run("form=m8", func(t *testing.T) {
		if _, err := PREFETCHT1(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPREFETCHT2ValidForms(t *testing.T) {
	t.Run("form=m8", func(t *testing.T) {
		if _, err := PREFETCHT2(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPSADBWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PSADBW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PSADBW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPSHUFBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PSHUFB(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PSHUFB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPSHUFDValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := PSHUFD(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm", func(t *testing.T) {
		if _, err := PSHUFD(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPSHUFHWValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := PSHUFHW(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm", func(t *testing.T) {
		if _, err := PSHUFHW(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPSHUFLValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := PSHUFL(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm", func(t *testing.T) {
		if _, err := PSHUFL(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPSHUFLWValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := PSHUFLW(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm", func(t *testing.T) {
		if _, err := PSHUFLW(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPSIGNBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PSIGNB(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PSIGNB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPSIGNDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PSIGND(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PSIGND(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPSIGNWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PSIGNW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PSIGNW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPSLLDQValidForms(t *testing.T) {
	t.Run("form=imm8_xmm", func(t *testing.T) {
		if _, err := PSLLDQ(operand.Imm(math.MaxInt8), reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPSLLLValidForms(t *testing.T) {
	t.Run("form=imm8_xmm", func(t *testing.T) {
		if _, err := PSLLL(operand.Imm(math.MaxInt8), reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PSLLL(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PSLLL(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPSLLOValidForms(t *testing.T) {
	t.Run("form=imm8_xmm", func(t *testing.T) {
		if _, err := PSLLO(operand.Imm(math.MaxInt8), reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPSLLQValidForms(t *testing.T) {
	t.Run("form=imm8_xmm", func(t *testing.T) {
		if _, err := PSLLQ(operand.Imm(math.MaxInt8), reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PSLLQ(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PSLLQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPSLLWValidForms(t *testing.T) {
	t.Run("form=imm8_xmm", func(t *testing.T) {
		if _, err := PSLLW(operand.Imm(math.MaxInt8), reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PSLLW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PSLLW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPSRALValidForms(t *testing.T) {
	t.Run("form=imm8_xmm", func(t *testing.T) {
		if _, err := PSRAL(operand.Imm(math.MaxInt8), reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PSRAL(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PSRAL(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPSRAWValidForms(t *testing.T) {
	t.Run("form=imm8_xmm", func(t *testing.T) {
		if _, err := PSRAW(operand.Imm(math.MaxInt8), reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PSRAW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PSRAW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPSRLDQValidForms(t *testing.T) {
	t.Run("form=imm8_xmm", func(t *testing.T) {
		if _, err := PSRLDQ(operand.Imm(math.MaxInt8), reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPSRLLValidForms(t *testing.T) {
	t.Run("form=imm8_xmm", func(t *testing.T) {
		if _, err := PSRLL(operand.Imm(math.MaxInt8), reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PSRLL(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PSRLL(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPSRLOValidForms(t *testing.T) {
	t.Run("form=imm8_xmm", func(t *testing.T) {
		if _, err := PSRLO(operand.Imm(math.MaxInt8), reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPSRLQValidForms(t *testing.T) {
	t.Run("form=imm8_xmm", func(t *testing.T) {
		if _, err := PSRLQ(operand.Imm(math.MaxInt8), reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PSRLQ(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PSRLQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPSRLWValidForms(t *testing.T) {
	t.Run("form=imm8_xmm", func(t *testing.T) {
		if _, err := PSRLW(operand.Imm(math.MaxInt8), reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PSRLW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PSRLW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPSUBBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PSUBB(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PSUBB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPSUBLValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PSUBL(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PSUBL(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPSUBQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PSUBQ(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PSUBQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPSUBSBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PSUBSB(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PSUBSB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPSUBSWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PSUBSW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PSUBSW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPSUBUSBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PSUBUSB(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PSUBUSB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPSUBUSWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PSUBUSW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PSUBUSW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPSUBWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PSUBW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PSUBW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPTESTValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PTEST(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PTEST(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPUNPCKHBWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PUNPCKHBW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PUNPCKHBW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPUNPCKHLQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PUNPCKHLQ(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PUNPCKHLQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPUNPCKHQDQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PUNPCKHQDQ(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PUNPCKHQDQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPUNPCKHWLValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PUNPCKHWL(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PUNPCKHWL(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPUNPCKLBWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PUNPCKLBW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PUNPCKLBW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPUNPCKLLQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PUNPCKLLQ(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PUNPCKLLQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPUNPCKLQDQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PUNPCKLQDQ(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PUNPCKLQDQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPUNPCKLWLValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PUNPCKLWL(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PUNPCKLWL(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPUSHQValidForms(t *testing.T) {
	t.Run("form=imm8", func(t *testing.T) {
		if _, err := PUSHQ(operand.Imm(math.MaxInt8)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32", func(t *testing.T) {
		if _, err := PUSHQ(operand.Imm(math.MaxInt32)); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64", func(t *testing.T) {
		if _, err := PUSHQ(reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64", func(t *testing.T) {
		if _, err := PUSHQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPUSHWValidForms(t *testing.T) {
	t.Run("form=r16", func(t *testing.T) {
		if _, err := PUSHW(reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := PUSHW(reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16", func(t *testing.T) {
		if _, err := PUSHW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestPXORValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := PXOR(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := PXOR(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestRCLBValidForms(t *testing.T) {
	t.Run("form=1_r8", func(t *testing.T) {
		if _, err := RCLB(operand.Imm(1), reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := RCLB(operand.Imm(1), reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := RCLB(operand.Imm(1), reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r8", func(t *testing.T) {
		if _, err := RCLB(operand.Imm(math.MaxInt8), reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := RCLB(operand.Imm(math.MaxInt8), reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := RCLB(operand.Imm(math.MaxInt8), reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r8", func(t *testing.T) {
		if _, err := RCLB(reg.CL, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := RCLB(reg.CL, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := RCLB(reg.CL, reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=1_m8", func(t *testing.T) {
		if _, err := RCLB(operand.Imm(1), operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m8", func(t *testing.T) {
		if _, err := RCLB(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_m8", func(t *testing.T) {
		if _, err := RCLB(reg.CL, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestRCLLValidForms(t *testing.T) {
	t.Run("form=1_r32", func(t *testing.T) {
		if _, err := RCLL(operand.Imm(1), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r32", func(t *testing.T) {
		if _, err := RCLL(operand.Imm(math.MaxInt8), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r32", func(t *testing.T) {
		if _, err := RCLL(reg.CL, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=1_m32", func(t *testing.T) {
		if _, err := RCLL(operand.Imm(1), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m32", func(t *testing.T) {
		if _, err := RCLL(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_m32", func(t *testing.T) {
		if _, err := RCLL(reg.CL, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestRCLQValidForms(t *testing.T) {
	t.Run("form=1_r64", func(t *testing.T) {
		if _, err := RCLQ(operand.Imm(1), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r64", func(t *testing.T) {
		if _, err := RCLQ(operand.Imm(math.MaxInt8), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r64", func(t *testing.T) {
		if _, err := RCLQ(reg.CL, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=1_m64", func(t *testing.T) {
		if _, err := RCLQ(operand.Imm(1), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m64", func(t *testing.T) {
		if _, err := RCLQ(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_m64", func(t *testing.T) {
		if _, err := RCLQ(reg.CL, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestRCLWValidForms(t *testing.T) {
	t.Run("form=1_r16", func(t *testing.T) {
		if _, err := RCLW(operand.Imm(1), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := RCLW(operand.Imm(1), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r16", func(t *testing.T) {
		if _, err := RCLW(operand.Imm(math.MaxInt8), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := RCLW(operand.Imm(math.MaxInt8), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r16", func(t *testing.T) {
		if _, err := RCLW(reg.CL, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := RCLW(reg.CL, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=1_m16", func(t *testing.T) {
		if _, err := RCLW(operand.Imm(1), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m16", func(t *testing.T) {
		if _, err := RCLW(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_m16", func(t *testing.T) {
		if _, err := RCLW(reg.CL, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestRCPPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := RCPPS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := RCPPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestRCPSSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := RCPSS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm", func(t *testing.T) {
		if _, err := RCPSS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestRCRBValidForms(t *testing.T) {
	t.Run("form=1_r8", func(t *testing.T) {
		if _, err := RCRB(operand.Imm(1), reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := RCRB(operand.Imm(1), reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := RCRB(operand.Imm(1), reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r8", func(t *testing.T) {
		if _, err := RCRB(operand.Imm(math.MaxInt8), reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := RCRB(operand.Imm(math.MaxInt8), reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := RCRB(operand.Imm(math.MaxInt8), reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r8", func(t *testing.T) {
		if _, err := RCRB(reg.CL, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := RCRB(reg.CL, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := RCRB(reg.CL, reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=1_m8", func(t *testing.T) {
		if _, err := RCRB(operand.Imm(1), operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m8", func(t *testing.T) {
		if _, err := RCRB(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_m8", func(t *testing.T) {
		if _, err := RCRB(reg.CL, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestRCRLValidForms(t *testing.T) {
	t.Run("form=1_r32", func(t *testing.T) {
		if _, err := RCRL(operand.Imm(1), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r32", func(t *testing.T) {
		if _, err := RCRL(operand.Imm(math.MaxInt8), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r32", func(t *testing.T) {
		if _, err := RCRL(reg.CL, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=1_m32", func(t *testing.T) {
		if _, err := RCRL(operand.Imm(1), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m32", func(t *testing.T) {
		if _, err := RCRL(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_m32", func(t *testing.T) {
		if _, err := RCRL(reg.CL, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestRCRQValidForms(t *testing.T) {
	t.Run("form=1_r64", func(t *testing.T) {
		if _, err := RCRQ(operand.Imm(1), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r64", func(t *testing.T) {
		if _, err := RCRQ(operand.Imm(math.MaxInt8), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r64", func(t *testing.T) {
		if _, err := RCRQ(reg.CL, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=1_m64", func(t *testing.T) {
		if _, err := RCRQ(operand.Imm(1), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m64", func(t *testing.T) {
		if _, err := RCRQ(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_m64", func(t *testing.T) {
		if _, err := RCRQ(reg.CL, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestRCRWValidForms(t *testing.T) {
	t.Run("form=1_r16", func(t *testing.T) {
		if _, err := RCRW(operand.Imm(1), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := RCRW(operand.Imm(1), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r16", func(t *testing.T) {
		if _, err := RCRW(operand.Imm(math.MaxInt8), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := RCRW(operand.Imm(math.MaxInt8), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r16", func(t *testing.T) {
		if _, err := RCRW(reg.CL, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := RCRW(reg.CL, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=1_m16", func(t *testing.T) {
		if _, err := RCRW(operand.Imm(1), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m16", func(t *testing.T) {
		if _, err := RCRW(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_m16", func(t *testing.T) {
		if _, err := RCRW(reg.CL, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestRDRANDLValidForms(t *testing.T) {
	t.Run("form=r32", func(t *testing.T) {
		if _, err := RDRANDL(reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestRDRANDQValidForms(t *testing.T) {
	t.Run("form=r64", func(t *testing.T) {
		if _, err := RDRANDQ(reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestRDRANDWValidForms(t *testing.T) {
	t.Run("form=r16", func(t *testing.T) {
		if _, err := RDRANDW(reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := RDRANDW(reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
}

func TestRDSEEDLValidForms(t *testing.T) {
	t.Run("form=r32", func(t *testing.T) {
		if _, err := RDSEEDL(reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestRDSEEDQValidForms(t *testing.T) {
	t.Run("form=r64", func(t *testing.T) {
		if _, err := RDSEEDQ(reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestRDSEEDWValidForms(t *testing.T) {
	t.Run("form=r16", func(t *testing.T) {
		if _, err := RDSEEDW(reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := RDSEEDW(reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
}

func TestRDTSCValidForms(t *testing.T) {
	t.Run("form=", func(t *testing.T) {
		if _, err := RDTSC(); err != nil {
			t.Fatal(err)
		}
	})
}

func TestRDTSCPValidForms(t *testing.T) {
	t.Run("form=", func(t *testing.T) {
		if _, err := RDTSCP(); err != nil {
			t.Fatal(err)
		}
	})
}

func TestRETValidForms(t *testing.T) {
	t.Run("form=", func(t *testing.T) {
		if _, err := RET(); err != nil {
			t.Fatal(err)
		}
	})
}

func TestRETFLValidForms(t *testing.T) {
	t.Run("form=imm16", func(t *testing.T) {
		if _, err := RETFL(operand.Imm(math.MaxInt16)); err != nil {
			t.Fatal(err)
		}
	})
}

func TestRETFQValidForms(t *testing.T) {
	t.Run("form=imm16", func(t *testing.T) {
		if _, err := RETFQ(operand.Imm(math.MaxInt16)); err != nil {
			t.Fatal(err)
		}
	})
}

func TestRETFWValidForms(t *testing.T) {
	t.Run("form=imm16", func(t *testing.T) {
		if _, err := RETFW(operand.Imm(math.MaxInt16)); err != nil {
			t.Fatal(err)
		}
	})
}

func TestROLBValidForms(t *testing.T) {
	t.Run("form=1_r8", func(t *testing.T) {
		if _, err := ROLB(operand.Imm(1), reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := ROLB(operand.Imm(1), reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := ROLB(operand.Imm(1), reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r8", func(t *testing.T) {
		if _, err := ROLB(operand.Imm(math.MaxInt8), reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := ROLB(operand.Imm(math.MaxInt8), reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := ROLB(operand.Imm(math.MaxInt8), reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r8", func(t *testing.T) {
		if _, err := ROLB(reg.CL, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := ROLB(reg.CL, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := ROLB(reg.CL, reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=1_m8", func(t *testing.T) {
		if _, err := ROLB(operand.Imm(1), operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m8", func(t *testing.T) {
		if _, err := ROLB(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_m8", func(t *testing.T) {
		if _, err := ROLB(reg.CL, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestROLLValidForms(t *testing.T) {
	t.Run("form=1_r32", func(t *testing.T) {
		if _, err := ROLL(operand.Imm(1), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r32", func(t *testing.T) {
		if _, err := ROLL(operand.Imm(math.MaxInt8), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r32", func(t *testing.T) {
		if _, err := ROLL(reg.CL, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=1_m32", func(t *testing.T) {
		if _, err := ROLL(operand.Imm(1), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m32", func(t *testing.T) {
		if _, err := ROLL(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_m32", func(t *testing.T) {
		if _, err := ROLL(reg.CL, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestROLQValidForms(t *testing.T) {
	t.Run("form=1_r64", func(t *testing.T) {
		if _, err := ROLQ(operand.Imm(1), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r64", func(t *testing.T) {
		if _, err := ROLQ(operand.Imm(math.MaxInt8), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r64", func(t *testing.T) {
		if _, err := ROLQ(reg.CL, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=1_m64", func(t *testing.T) {
		if _, err := ROLQ(operand.Imm(1), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m64", func(t *testing.T) {
		if _, err := ROLQ(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_m64", func(t *testing.T) {
		if _, err := ROLQ(reg.CL, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestROLWValidForms(t *testing.T) {
	t.Run("form=1_r16", func(t *testing.T) {
		if _, err := ROLW(operand.Imm(1), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := ROLW(operand.Imm(1), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r16", func(t *testing.T) {
		if _, err := ROLW(operand.Imm(math.MaxInt8), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := ROLW(operand.Imm(math.MaxInt8), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r16", func(t *testing.T) {
		if _, err := ROLW(reg.CL, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := ROLW(reg.CL, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=1_m16", func(t *testing.T) {
		if _, err := ROLW(operand.Imm(1), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m16", func(t *testing.T) {
		if _, err := ROLW(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_m16", func(t *testing.T) {
		if _, err := ROLW(reg.CL, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestRORBValidForms(t *testing.T) {
	t.Run("form=1_r8", func(t *testing.T) {
		if _, err := RORB(operand.Imm(1), reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := RORB(operand.Imm(1), reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := RORB(operand.Imm(1), reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r8", func(t *testing.T) {
		if _, err := RORB(operand.Imm(math.MaxInt8), reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := RORB(operand.Imm(math.MaxInt8), reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := RORB(operand.Imm(math.MaxInt8), reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r8", func(t *testing.T) {
		if _, err := RORB(reg.CL, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := RORB(reg.CL, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := RORB(reg.CL, reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=1_m8", func(t *testing.T) {
		if _, err := RORB(operand.Imm(1), operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m8", func(t *testing.T) {
		if _, err := RORB(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_m8", func(t *testing.T) {
		if _, err := RORB(reg.CL, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestRORLValidForms(t *testing.T) {
	t.Run("form=1_r32", func(t *testing.T) {
		if _, err := RORL(operand.Imm(1), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r32", func(t *testing.T) {
		if _, err := RORL(operand.Imm(math.MaxInt8), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r32", func(t *testing.T) {
		if _, err := RORL(reg.CL, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=1_m32", func(t *testing.T) {
		if _, err := RORL(operand.Imm(1), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m32", func(t *testing.T) {
		if _, err := RORL(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_m32", func(t *testing.T) {
		if _, err := RORL(reg.CL, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestRORQValidForms(t *testing.T) {
	t.Run("form=1_r64", func(t *testing.T) {
		if _, err := RORQ(operand.Imm(1), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r64", func(t *testing.T) {
		if _, err := RORQ(operand.Imm(math.MaxInt8), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r64", func(t *testing.T) {
		if _, err := RORQ(reg.CL, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=1_m64", func(t *testing.T) {
		if _, err := RORQ(operand.Imm(1), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m64", func(t *testing.T) {
		if _, err := RORQ(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_m64", func(t *testing.T) {
		if _, err := RORQ(reg.CL, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestRORWValidForms(t *testing.T) {
	t.Run("form=1_r16", func(t *testing.T) {
		if _, err := RORW(operand.Imm(1), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := RORW(operand.Imm(1), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r16", func(t *testing.T) {
		if _, err := RORW(operand.Imm(math.MaxInt8), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := RORW(operand.Imm(math.MaxInt8), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r16", func(t *testing.T) {
		if _, err := RORW(reg.CL, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := RORW(reg.CL, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=1_m16", func(t *testing.T) {
		if _, err := RORW(operand.Imm(1), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m16", func(t *testing.T) {
		if _, err := RORW(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_m16", func(t *testing.T) {
		if _, err := RORW(reg.CL, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestRORXLValidForms(t *testing.T) {
	t.Run("form=imm8_r32_r32", func(t *testing.T) {
		if _, err := RORXL(operand.Imm(math.MaxInt8), reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m32_r32", func(t *testing.T) {
		if _, err := RORXL(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestRORXQValidForms(t *testing.T) {
	t.Run("form=imm8_r64_r64", func(t *testing.T) {
		if _, err := RORXQ(operand.Imm(math.MaxInt8), reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m64_r64", func(t *testing.T) {
		if _, err := RORXQ(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestROUNDPDValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := ROUNDPD(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm", func(t *testing.T) {
		if _, err := ROUNDPD(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestROUNDPSValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := ROUNDPS(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm", func(t *testing.T) {
		if _, err := ROUNDPS(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestROUNDSDValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := ROUNDSD(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m64_xmm", func(t *testing.T) {
		if _, err := ROUNDSD(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestROUNDSSValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := ROUNDSS(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m32_xmm", func(t *testing.T) {
		if _, err := ROUNDSS(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestRSQRTPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := RSQRTPS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := RSQRTPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestRSQRTSSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := RSQRTSS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm", func(t *testing.T) {
		if _, err := RSQRTSS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSALBValidForms(t *testing.T) {
	t.Run("form=1_r8", func(t *testing.T) {
		if _, err := SALB(operand.Imm(1), reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SALB(operand.Imm(1), reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SALB(operand.Imm(1), reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r8", func(t *testing.T) {
		if _, err := SALB(operand.Imm(math.MaxInt8), reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SALB(operand.Imm(math.MaxInt8), reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SALB(operand.Imm(math.MaxInt8), reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r8", func(t *testing.T) {
		if _, err := SALB(reg.CL, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SALB(reg.CL, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SALB(reg.CL, reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=1_m8", func(t *testing.T) {
		if _, err := SALB(operand.Imm(1), operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m8", func(t *testing.T) {
		if _, err := SALB(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_m8", func(t *testing.T) {
		if _, err := SALB(reg.CL, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSALLValidForms(t *testing.T) {
	t.Run("form=1_r32", func(t *testing.T) {
		if _, err := SALL(operand.Imm(1), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r32", func(t *testing.T) {
		if _, err := SALL(operand.Imm(math.MaxInt8), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r32", func(t *testing.T) {
		if _, err := SALL(reg.CL, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=1_m32", func(t *testing.T) {
		if _, err := SALL(operand.Imm(1), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m32", func(t *testing.T) {
		if _, err := SALL(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_m32", func(t *testing.T) {
		if _, err := SALL(reg.CL, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSALQValidForms(t *testing.T) {
	t.Run("form=1_r64", func(t *testing.T) {
		if _, err := SALQ(operand.Imm(1), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r64", func(t *testing.T) {
		if _, err := SALQ(operand.Imm(math.MaxInt8), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r64", func(t *testing.T) {
		if _, err := SALQ(reg.CL, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=1_m64", func(t *testing.T) {
		if _, err := SALQ(operand.Imm(1), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m64", func(t *testing.T) {
		if _, err := SALQ(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_m64", func(t *testing.T) {
		if _, err := SALQ(reg.CL, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSALWValidForms(t *testing.T) {
	t.Run("form=1_r16", func(t *testing.T) {
		if _, err := SALW(operand.Imm(1), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := SALW(operand.Imm(1), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r16", func(t *testing.T) {
		if _, err := SALW(operand.Imm(math.MaxInt8), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := SALW(operand.Imm(math.MaxInt8), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r16", func(t *testing.T) {
		if _, err := SALW(reg.CL, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := SALW(reg.CL, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=1_m16", func(t *testing.T) {
		if _, err := SALW(operand.Imm(1), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m16", func(t *testing.T) {
		if _, err := SALW(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_m16", func(t *testing.T) {
		if _, err := SALW(reg.CL, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSARBValidForms(t *testing.T) {
	t.Run("form=1_r8", func(t *testing.T) {
		if _, err := SARB(operand.Imm(1), reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SARB(operand.Imm(1), reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SARB(operand.Imm(1), reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r8", func(t *testing.T) {
		if _, err := SARB(operand.Imm(math.MaxInt8), reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SARB(operand.Imm(math.MaxInt8), reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SARB(operand.Imm(math.MaxInt8), reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r8", func(t *testing.T) {
		if _, err := SARB(reg.CL, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SARB(reg.CL, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SARB(reg.CL, reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=1_m8", func(t *testing.T) {
		if _, err := SARB(operand.Imm(1), operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m8", func(t *testing.T) {
		if _, err := SARB(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_m8", func(t *testing.T) {
		if _, err := SARB(reg.CL, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSARLValidForms(t *testing.T) {
	t.Run("form=1_r32", func(t *testing.T) {
		if _, err := SARL(operand.Imm(1), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r32", func(t *testing.T) {
		if _, err := SARL(operand.Imm(math.MaxInt8), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r32", func(t *testing.T) {
		if _, err := SARL(reg.CL, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=1_m32", func(t *testing.T) {
		if _, err := SARL(operand.Imm(1), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m32", func(t *testing.T) {
		if _, err := SARL(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_m32", func(t *testing.T) {
		if _, err := SARL(reg.CL, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSARQValidForms(t *testing.T) {
	t.Run("form=1_r64", func(t *testing.T) {
		if _, err := SARQ(operand.Imm(1), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r64", func(t *testing.T) {
		if _, err := SARQ(operand.Imm(math.MaxInt8), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r64", func(t *testing.T) {
		if _, err := SARQ(reg.CL, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=1_m64", func(t *testing.T) {
		if _, err := SARQ(operand.Imm(1), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m64", func(t *testing.T) {
		if _, err := SARQ(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_m64", func(t *testing.T) {
		if _, err := SARQ(reg.CL, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSARWValidForms(t *testing.T) {
	t.Run("form=1_r16", func(t *testing.T) {
		if _, err := SARW(operand.Imm(1), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := SARW(operand.Imm(1), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r16", func(t *testing.T) {
		if _, err := SARW(operand.Imm(math.MaxInt8), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := SARW(operand.Imm(math.MaxInt8), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r16", func(t *testing.T) {
		if _, err := SARW(reg.CL, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := SARW(reg.CL, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=1_m16", func(t *testing.T) {
		if _, err := SARW(operand.Imm(1), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m16", func(t *testing.T) {
		if _, err := SARW(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_m16", func(t *testing.T) {
		if _, err := SARW(reg.CL, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSARXLValidForms(t *testing.T) {
	t.Run("form=r32_r32_r32", func(t *testing.T) {
		if _, err := SARXL(reg.R10L, reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_m32_r32", func(t *testing.T) {
		if _, err := SARXL(reg.R10L, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSARXQValidForms(t *testing.T) {
	t.Run("form=r64_r64_r64", func(t *testing.T) {
		if _, err := SARXQ(reg.R11, reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_m64_r64", func(t *testing.T) {
		if _, err := SARXQ(reg.R11, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSBBBValidForms(t *testing.T) {
	t.Run("form=imm8_al", func(t *testing.T) {
		if _, err := SBBB(operand.Imm(math.MaxInt8), reg.AL); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r8", func(t *testing.T) {
		if _, err := SBBB(operand.Imm(math.MaxInt8), reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SBBB(operand.Imm(math.MaxInt8), reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SBBB(operand.Imm(math.MaxInt8), reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r8_r8", func(t *testing.T) {
		if _, err := SBBB(reg.CH, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SBBB(reg.CH, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SBBB(reg.CH, reg.R13B); err != nil {
			t.Fatal(err)
		}
		if _, err := SBBB(reg.BL, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SBBB(reg.BL, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SBBB(reg.BL, reg.R13B); err != nil {
			t.Fatal(err)
		}
		if _, err := SBBB(reg.R13B, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SBBB(reg.R13B, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SBBB(reg.R13B, reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8_r8", func(t *testing.T) {
		if _, err := SBBB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SBBB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SBBB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m8", func(t *testing.T) {
		if _, err := SBBB(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r8_m8", func(t *testing.T) {
		if _, err := SBBB(reg.CH, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
		if _, err := SBBB(reg.BL, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
		if _, err := SBBB(reg.R13B, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSBBLValidForms(t *testing.T) {
	t.Run("form=imm32_eax", func(t *testing.T) {
		if _, err := SBBL(operand.Imm(math.MaxInt32), reg.EAX); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r32", func(t *testing.T) {
		if _, err := SBBL(operand.Imm(math.MaxInt8), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_r32", func(t *testing.T) {
		if _, err := SBBL(operand.Imm(math.MaxInt32), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := SBBL(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := SBBL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m32", func(t *testing.T) {
		if _, err := SBBL(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_m32", func(t *testing.T) {
		if _, err := SBBL(operand.Imm(math.MaxInt32), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_m32", func(t *testing.T) {
		if _, err := SBBL(reg.R10L, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSBBQValidForms(t *testing.T) {
	t.Run("form=imm32_rax", func(t *testing.T) {
		if _, err := SBBQ(operand.Imm(math.MaxInt32), reg.RAX); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r64", func(t *testing.T) {
		if _, err := SBBQ(operand.Imm(math.MaxInt8), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_r64", func(t *testing.T) {
		if _, err := SBBQ(operand.Imm(math.MaxInt32), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := SBBQ(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := SBBQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m64", func(t *testing.T) {
		if _, err := SBBQ(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_m64", func(t *testing.T) {
		if _, err := SBBQ(operand.Imm(math.MaxInt32), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_m64", func(t *testing.T) {
		if _, err := SBBQ(reg.R11, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSBBWValidForms(t *testing.T) {
	t.Run("form=imm16_ax", func(t *testing.T) {
		if _, err := SBBW(operand.Imm(math.MaxInt16), reg.AX); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r16", func(t *testing.T) {
		if _, err := SBBW(operand.Imm(math.MaxInt8), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := SBBW(operand.Imm(math.MaxInt8), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm16_r16", func(t *testing.T) {
		if _, err := SBBW(operand.Imm(math.MaxInt16), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := SBBW(operand.Imm(math.MaxInt16), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := SBBW(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := SBBW(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := SBBW(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := SBBW(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r16", func(t *testing.T) {
		if _, err := SBBW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := SBBW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m16", func(t *testing.T) {
		if _, err := SBBW(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm16_m16", func(t *testing.T) {
		if _, err := SBBW(operand.Imm(math.MaxInt16), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_m16", func(t *testing.T) {
		if _, err := SBBW(reg.CX, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
		if _, err := SBBW(reg.R9W, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSETCCValidForms(t *testing.T) {
	t.Run("form=r8", func(t *testing.T) {
		if _, err := SETCC(reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SETCC(reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SETCC(reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8", func(t *testing.T) {
		if _, err := SETCC(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSETCSValidForms(t *testing.T) {
	t.Run("form=r8", func(t *testing.T) {
		if _, err := SETCS(reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SETCS(reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SETCS(reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8", func(t *testing.T) {
		if _, err := SETCS(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSETEQValidForms(t *testing.T) {
	t.Run("form=r8", func(t *testing.T) {
		if _, err := SETEQ(reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SETEQ(reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SETEQ(reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8", func(t *testing.T) {
		if _, err := SETEQ(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSETGEValidForms(t *testing.T) {
	t.Run("form=r8", func(t *testing.T) {
		if _, err := SETGE(reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SETGE(reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SETGE(reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8", func(t *testing.T) {
		if _, err := SETGE(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSETGTValidForms(t *testing.T) {
	t.Run("form=r8", func(t *testing.T) {
		if _, err := SETGT(reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SETGT(reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SETGT(reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8", func(t *testing.T) {
		if _, err := SETGT(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSETHIValidForms(t *testing.T) {
	t.Run("form=r8", func(t *testing.T) {
		if _, err := SETHI(reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SETHI(reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SETHI(reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8", func(t *testing.T) {
		if _, err := SETHI(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSETLEValidForms(t *testing.T) {
	t.Run("form=r8", func(t *testing.T) {
		if _, err := SETLE(reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SETLE(reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SETLE(reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8", func(t *testing.T) {
		if _, err := SETLE(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSETLSValidForms(t *testing.T) {
	t.Run("form=r8", func(t *testing.T) {
		if _, err := SETLS(reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SETLS(reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SETLS(reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8", func(t *testing.T) {
		if _, err := SETLS(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSETLTValidForms(t *testing.T) {
	t.Run("form=r8", func(t *testing.T) {
		if _, err := SETLT(reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SETLT(reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SETLT(reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8", func(t *testing.T) {
		if _, err := SETLT(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSETMIValidForms(t *testing.T) {
	t.Run("form=r8", func(t *testing.T) {
		if _, err := SETMI(reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SETMI(reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SETMI(reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8", func(t *testing.T) {
		if _, err := SETMI(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSETNEValidForms(t *testing.T) {
	t.Run("form=r8", func(t *testing.T) {
		if _, err := SETNE(reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SETNE(reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SETNE(reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8", func(t *testing.T) {
		if _, err := SETNE(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSETOCValidForms(t *testing.T) {
	t.Run("form=r8", func(t *testing.T) {
		if _, err := SETOC(reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SETOC(reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SETOC(reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8", func(t *testing.T) {
		if _, err := SETOC(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSETOSValidForms(t *testing.T) {
	t.Run("form=r8", func(t *testing.T) {
		if _, err := SETOS(reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SETOS(reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SETOS(reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8", func(t *testing.T) {
		if _, err := SETOS(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSETPCValidForms(t *testing.T) {
	t.Run("form=r8", func(t *testing.T) {
		if _, err := SETPC(reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SETPC(reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SETPC(reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8", func(t *testing.T) {
		if _, err := SETPC(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSETPLValidForms(t *testing.T) {
	t.Run("form=r8", func(t *testing.T) {
		if _, err := SETPL(reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SETPL(reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SETPL(reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8", func(t *testing.T) {
		if _, err := SETPL(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSETPSValidForms(t *testing.T) {
	t.Run("form=r8", func(t *testing.T) {
		if _, err := SETPS(reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SETPS(reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SETPS(reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8", func(t *testing.T) {
		if _, err := SETPS(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSFENCEValidForms(t *testing.T) {
	t.Run("form=", func(t *testing.T) {
		if _, err := SFENCE(); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSHA1MSG1ValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := SHA1MSG1(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := SHA1MSG1(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSHA1MSG2ValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := SHA1MSG2(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := SHA1MSG2(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSHA1NEXTEValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := SHA1NEXTE(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := SHA1NEXTE(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSHA1RNDS4ValidForms(t *testing.T) {
	t.Run("form=imm2u_xmm_xmm", func(t *testing.T) {
		if _, err := SHA1RNDS4(operand.Imm(1), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
		if _, err := SHA1RNDS4(operand.Imm(3), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm2u_m128_xmm", func(t *testing.T) {
		if _, err := SHA1RNDS4(operand.Imm(1), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
		if _, err := SHA1RNDS4(operand.Imm(3), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSHA256MSG1ValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := SHA256MSG1(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := SHA256MSG1(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSHA256MSG2ValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := SHA256MSG2(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := SHA256MSG2(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSHA256RNDS2ValidForms(t *testing.T) {
	t.Run("form=xmm0_xmm_xmm", func(t *testing.T) {
		if _, err := SHA256RNDS2(reg.X0, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm0_m128_xmm", func(t *testing.T) {
		if _, err := SHA256RNDS2(reg.X0, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSHLBValidForms(t *testing.T) {
	t.Run("form=1_r8", func(t *testing.T) {
		if _, err := SHLB(operand.Imm(1), reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SHLB(operand.Imm(1), reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SHLB(operand.Imm(1), reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r8", func(t *testing.T) {
		if _, err := SHLB(operand.Imm(math.MaxInt8), reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SHLB(operand.Imm(math.MaxInt8), reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SHLB(operand.Imm(math.MaxInt8), reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r8", func(t *testing.T) {
		if _, err := SHLB(reg.CL, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SHLB(reg.CL, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SHLB(reg.CL, reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=1_m8", func(t *testing.T) {
		if _, err := SHLB(operand.Imm(1), operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m8", func(t *testing.T) {
		if _, err := SHLB(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_m8", func(t *testing.T) {
		if _, err := SHLB(reg.CL, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSHLLValidForms(t *testing.T) {
	t.Run("form=1_r32", func(t *testing.T) {
		if _, err := SHLL(operand.Imm(1), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r32", func(t *testing.T) {
		if _, err := SHLL(operand.Imm(math.MaxInt8), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r32", func(t *testing.T) {
		if _, err := SHLL(reg.CL, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=1_m32", func(t *testing.T) {
		if _, err := SHLL(operand.Imm(1), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m32", func(t *testing.T) {
		if _, err := SHLL(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_m32", func(t *testing.T) {
		if _, err := SHLL(reg.CL, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r32_r32", func(t *testing.T) {
		if _, err := SHLL(operand.Imm(math.MaxInt8), reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r32_r32", func(t *testing.T) {
		if _, err := SHLL(reg.CL, reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r32_m32", func(t *testing.T) {
		if _, err := SHLL(operand.Imm(math.MaxInt8), reg.R10L, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r32_m32", func(t *testing.T) {
		if _, err := SHLL(reg.CL, reg.R10L, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSHLQValidForms(t *testing.T) {
	t.Run("form=1_r64", func(t *testing.T) {
		if _, err := SHLQ(operand.Imm(1), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r64", func(t *testing.T) {
		if _, err := SHLQ(operand.Imm(math.MaxInt8), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r64", func(t *testing.T) {
		if _, err := SHLQ(reg.CL, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=1_m64", func(t *testing.T) {
		if _, err := SHLQ(operand.Imm(1), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m64", func(t *testing.T) {
		if _, err := SHLQ(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_m64", func(t *testing.T) {
		if _, err := SHLQ(reg.CL, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r64_r64", func(t *testing.T) {
		if _, err := SHLQ(operand.Imm(math.MaxInt8), reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r64_r64", func(t *testing.T) {
		if _, err := SHLQ(reg.CL, reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r64_m64", func(t *testing.T) {
		if _, err := SHLQ(operand.Imm(math.MaxInt8), reg.R11, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r64_m64", func(t *testing.T) {
		if _, err := SHLQ(reg.CL, reg.R11, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSHLWValidForms(t *testing.T) {
	t.Run("form=1_r16", func(t *testing.T) {
		if _, err := SHLW(operand.Imm(1), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := SHLW(operand.Imm(1), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r16", func(t *testing.T) {
		if _, err := SHLW(operand.Imm(math.MaxInt8), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := SHLW(operand.Imm(math.MaxInt8), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r16", func(t *testing.T) {
		if _, err := SHLW(reg.CL, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := SHLW(reg.CL, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=1_m16", func(t *testing.T) {
		if _, err := SHLW(operand.Imm(1), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m16", func(t *testing.T) {
		if _, err := SHLW(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_m16", func(t *testing.T) {
		if _, err := SHLW(reg.CL, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r16_r16", func(t *testing.T) {
		if _, err := SHLW(operand.Imm(math.MaxInt8), reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := SHLW(operand.Imm(math.MaxInt8), reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := SHLW(operand.Imm(math.MaxInt8), reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := SHLW(operand.Imm(math.MaxInt8), reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r16_r16", func(t *testing.T) {
		if _, err := SHLW(reg.CL, reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := SHLW(reg.CL, reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := SHLW(reg.CL, reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := SHLW(reg.CL, reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r16_m16", func(t *testing.T) {
		if _, err := SHLW(operand.Imm(math.MaxInt8), reg.CX, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
		if _, err := SHLW(operand.Imm(math.MaxInt8), reg.R9W, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r16_m16", func(t *testing.T) {
		if _, err := SHLW(reg.CL, reg.CX, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
		if _, err := SHLW(reg.CL, reg.R9W, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSHLXLValidForms(t *testing.T) {
	t.Run("form=r32_r32_r32", func(t *testing.T) {
		if _, err := SHLXL(reg.R10L, reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_m32_r32", func(t *testing.T) {
		if _, err := SHLXL(reg.R10L, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSHLXQValidForms(t *testing.T) {
	t.Run("form=r64_r64_r64", func(t *testing.T) {
		if _, err := SHLXQ(reg.R11, reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_m64_r64", func(t *testing.T) {
		if _, err := SHLXQ(reg.R11, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSHRBValidForms(t *testing.T) {
	t.Run("form=1_r8", func(t *testing.T) {
		if _, err := SHRB(operand.Imm(1), reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SHRB(operand.Imm(1), reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SHRB(operand.Imm(1), reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r8", func(t *testing.T) {
		if _, err := SHRB(operand.Imm(math.MaxInt8), reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SHRB(operand.Imm(math.MaxInt8), reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SHRB(operand.Imm(math.MaxInt8), reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r8", func(t *testing.T) {
		if _, err := SHRB(reg.CL, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SHRB(reg.CL, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SHRB(reg.CL, reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=1_m8", func(t *testing.T) {
		if _, err := SHRB(operand.Imm(1), operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m8", func(t *testing.T) {
		if _, err := SHRB(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_m8", func(t *testing.T) {
		if _, err := SHRB(reg.CL, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSHRLValidForms(t *testing.T) {
	t.Run("form=1_r32", func(t *testing.T) {
		if _, err := SHRL(operand.Imm(1), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r32", func(t *testing.T) {
		if _, err := SHRL(operand.Imm(math.MaxInt8), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r32", func(t *testing.T) {
		if _, err := SHRL(reg.CL, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=1_m32", func(t *testing.T) {
		if _, err := SHRL(operand.Imm(1), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m32", func(t *testing.T) {
		if _, err := SHRL(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_m32", func(t *testing.T) {
		if _, err := SHRL(reg.CL, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r32_r32", func(t *testing.T) {
		if _, err := SHRL(operand.Imm(math.MaxInt8), reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r32_r32", func(t *testing.T) {
		if _, err := SHRL(reg.CL, reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r32_m32", func(t *testing.T) {
		if _, err := SHRL(operand.Imm(math.MaxInt8), reg.R10L, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r32_m32", func(t *testing.T) {
		if _, err := SHRL(reg.CL, reg.R10L, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSHRQValidForms(t *testing.T) {
	t.Run("form=1_r64", func(t *testing.T) {
		if _, err := SHRQ(operand.Imm(1), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r64", func(t *testing.T) {
		if _, err := SHRQ(operand.Imm(math.MaxInt8), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r64", func(t *testing.T) {
		if _, err := SHRQ(reg.CL, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=1_m64", func(t *testing.T) {
		if _, err := SHRQ(operand.Imm(1), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m64", func(t *testing.T) {
		if _, err := SHRQ(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_m64", func(t *testing.T) {
		if _, err := SHRQ(reg.CL, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r64_r64", func(t *testing.T) {
		if _, err := SHRQ(operand.Imm(math.MaxInt8), reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r64_r64", func(t *testing.T) {
		if _, err := SHRQ(reg.CL, reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r64_m64", func(t *testing.T) {
		if _, err := SHRQ(operand.Imm(math.MaxInt8), reg.R11, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r64_m64", func(t *testing.T) {
		if _, err := SHRQ(reg.CL, reg.R11, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSHRWValidForms(t *testing.T) {
	t.Run("form=1_r16", func(t *testing.T) {
		if _, err := SHRW(operand.Imm(1), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := SHRW(operand.Imm(1), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r16", func(t *testing.T) {
		if _, err := SHRW(operand.Imm(math.MaxInt8), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := SHRW(operand.Imm(math.MaxInt8), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r16", func(t *testing.T) {
		if _, err := SHRW(reg.CL, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := SHRW(reg.CL, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=1_m16", func(t *testing.T) {
		if _, err := SHRW(operand.Imm(1), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m16", func(t *testing.T) {
		if _, err := SHRW(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_m16", func(t *testing.T) {
		if _, err := SHRW(reg.CL, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r16_r16", func(t *testing.T) {
		if _, err := SHRW(operand.Imm(math.MaxInt8), reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := SHRW(operand.Imm(math.MaxInt8), reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := SHRW(operand.Imm(math.MaxInt8), reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := SHRW(operand.Imm(math.MaxInt8), reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r16_r16", func(t *testing.T) {
		if _, err := SHRW(reg.CL, reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := SHRW(reg.CL, reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := SHRW(reg.CL, reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := SHRW(reg.CL, reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r16_m16", func(t *testing.T) {
		if _, err := SHRW(operand.Imm(math.MaxInt8), reg.CX, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
		if _, err := SHRW(operand.Imm(math.MaxInt8), reg.R9W, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=cl_r16_m16", func(t *testing.T) {
		if _, err := SHRW(reg.CL, reg.CX, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
		if _, err := SHRW(reg.CL, reg.R9W, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSHRXLValidForms(t *testing.T) {
	t.Run("form=r32_r32_r32", func(t *testing.T) {
		if _, err := SHRXL(reg.R10L, reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_m32_r32", func(t *testing.T) {
		if _, err := SHRXL(reg.R10L, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSHRXQValidForms(t *testing.T) {
	t.Run("form=r64_r64_r64", func(t *testing.T) {
		if _, err := SHRXQ(reg.R11, reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_m64_r64", func(t *testing.T) {
		if _, err := SHRXQ(reg.R11, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSHUFPDValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := SHUFPD(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm", func(t *testing.T) {
		if _, err := SHUFPD(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSHUFPSValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := SHUFPS(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm", func(t *testing.T) {
		if _, err := SHUFPS(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSQRTPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := SQRTPD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := SQRTPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSQRTPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := SQRTPS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := SQRTPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSQRTSDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := SQRTSD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := SQRTSD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSQRTSSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := SQRTSS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm", func(t *testing.T) {
		if _, err := SQRTSS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSTCValidForms(t *testing.T) {
	t.Run("form=", func(t *testing.T) {
		if _, err := STC(); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSTDValidForms(t *testing.T) {
	t.Run("form=", func(t *testing.T) {
		if _, err := STD(); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSTMXCSRValidForms(t *testing.T) {
	t.Run("form=m32", func(t *testing.T) {
		if _, err := STMXCSR(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSUBBValidForms(t *testing.T) {
	t.Run("form=imm8_al", func(t *testing.T) {
		if _, err := SUBB(operand.Imm(math.MaxInt8), reg.AL); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r8", func(t *testing.T) {
		if _, err := SUBB(operand.Imm(math.MaxInt8), reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SUBB(operand.Imm(math.MaxInt8), reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SUBB(operand.Imm(math.MaxInt8), reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r8_r8", func(t *testing.T) {
		if _, err := SUBB(reg.CH, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SUBB(reg.CH, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SUBB(reg.CH, reg.R13B); err != nil {
			t.Fatal(err)
		}
		if _, err := SUBB(reg.BL, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SUBB(reg.BL, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SUBB(reg.BL, reg.R13B); err != nil {
			t.Fatal(err)
		}
		if _, err := SUBB(reg.R13B, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SUBB(reg.R13B, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SUBB(reg.R13B, reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8_r8", func(t *testing.T) {
		if _, err := SUBB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := SUBB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := SUBB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m8", func(t *testing.T) {
		if _, err := SUBB(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r8_m8", func(t *testing.T) {
		if _, err := SUBB(reg.CH, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
		if _, err := SUBB(reg.BL, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
		if _, err := SUBB(reg.R13B, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSUBLValidForms(t *testing.T) {
	t.Run("form=imm32_eax", func(t *testing.T) {
		if _, err := SUBL(operand.Imm(math.MaxInt32), reg.EAX); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r32", func(t *testing.T) {
		if _, err := SUBL(operand.Imm(math.MaxInt8), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_r32", func(t *testing.T) {
		if _, err := SUBL(operand.Imm(math.MaxInt32), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := SUBL(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := SUBL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m32", func(t *testing.T) {
		if _, err := SUBL(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_m32", func(t *testing.T) {
		if _, err := SUBL(operand.Imm(math.MaxInt32), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_m32", func(t *testing.T) {
		if _, err := SUBL(reg.R10L, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSUBPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := SUBPD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := SUBPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSUBPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := SUBPS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := SUBPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSUBQValidForms(t *testing.T) {
	t.Run("form=imm32_rax", func(t *testing.T) {
		if _, err := SUBQ(operand.Imm(math.MaxInt32), reg.RAX); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r64", func(t *testing.T) {
		if _, err := SUBQ(operand.Imm(math.MaxInt8), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_r64", func(t *testing.T) {
		if _, err := SUBQ(operand.Imm(math.MaxInt32), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := SUBQ(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := SUBQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m64", func(t *testing.T) {
		if _, err := SUBQ(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_m64", func(t *testing.T) {
		if _, err := SUBQ(operand.Imm(math.MaxInt32), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_m64", func(t *testing.T) {
		if _, err := SUBQ(reg.R11, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSUBSDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := SUBSD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := SUBSD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSUBSSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := SUBSS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm", func(t *testing.T) {
		if _, err := SUBSS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSUBWValidForms(t *testing.T) {
	t.Run("form=imm16_ax", func(t *testing.T) {
		if _, err := SUBW(operand.Imm(math.MaxInt16), reg.AX); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r16", func(t *testing.T) {
		if _, err := SUBW(operand.Imm(math.MaxInt8), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := SUBW(operand.Imm(math.MaxInt8), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm16_r16", func(t *testing.T) {
		if _, err := SUBW(operand.Imm(math.MaxInt16), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := SUBW(operand.Imm(math.MaxInt16), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := SUBW(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := SUBW(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := SUBW(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := SUBW(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r16", func(t *testing.T) {
		if _, err := SUBW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := SUBW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m16", func(t *testing.T) {
		if _, err := SUBW(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm16_m16", func(t *testing.T) {
		if _, err := SUBW(operand.Imm(math.MaxInt16), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_m16", func(t *testing.T) {
		if _, err := SUBW(reg.CX, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
		if _, err := SUBW(reg.R9W, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestSYSCALLValidForms(t *testing.T) {
	t.Run("form=", func(t *testing.T) {
		if _, err := SYSCALL(); err != nil {
			t.Fatal(err)
		}
	})
}

func TestTESTBValidForms(t *testing.T) {
	t.Run("form=imm8_al", func(t *testing.T) {
		if _, err := TESTB(operand.Imm(math.MaxInt8), reg.AL); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r8", func(t *testing.T) {
		if _, err := TESTB(operand.Imm(math.MaxInt8), reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := TESTB(operand.Imm(math.MaxInt8), reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := TESTB(operand.Imm(math.MaxInt8), reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r8_r8", func(t *testing.T) {
		if _, err := TESTB(reg.CH, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := TESTB(reg.CH, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := TESTB(reg.CH, reg.R13B); err != nil {
			t.Fatal(err)
		}
		if _, err := TESTB(reg.BL, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := TESTB(reg.BL, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := TESTB(reg.BL, reg.R13B); err != nil {
			t.Fatal(err)
		}
		if _, err := TESTB(reg.R13B, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := TESTB(reg.R13B, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := TESTB(reg.R13B, reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m8", func(t *testing.T) {
		if _, err := TESTB(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r8_m8", func(t *testing.T) {
		if _, err := TESTB(reg.CH, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
		if _, err := TESTB(reg.BL, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
		if _, err := TESTB(reg.R13B, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestTESTLValidForms(t *testing.T) {
	t.Run("form=imm32_eax", func(t *testing.T) {
		if _, err := TESTL(operand.Imm(math.MaxInt32), reg.EAX); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_r32", func(t *testing.T) {
		if _, err := TESTL(operand.Imm(math.MaxInt32), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := TESTL(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_m32", func(t *testing.T) {
		if _, err := TESTL(operand.Imm(math.MaxInt32), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_m32", func(t *testing.T) {
		if _, err := TESTL(reg.R10L, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestTESTQValidForms(t *testing.T) {
	t.Run("form=imm32_rax", func(t *testing.T) {
		if _, err := TESTQ(operand.Imm(math.MaxInt32), reg.RAX); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_r64", func(t *testing.T) {
		if _, err := TESTQ(operand.Imm(math.MaxInt32), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := TESTQ(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_m64", func(t *testing.T) {
		if _, err := TESTQ(operand.Imm(math.MaxInt32), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_m64", func(t *testing.T) {
		if _, err := TESTQ(reg.R11, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestTESTWValidForms(t *testing.T) {
	t.Run("form=imm16_ax", func(t *testing.T) {
		if _, err := TESTW(operand.Imm(math.MaxInt16), reg.AX); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm16_r16", func(t *testing.T) {
		if _, err := TESTW(operand.Imm(math.MaxInt16), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := TESTW(operand.Imm(math.MaxInt16), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := TESTW(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := TESTW(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := TESTW(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := TESTW(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm16_m16", func(t *testing.T) {
		if _, err := TESTW(operand.Imm(math.MaxInt16), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_m16", func(t *testing.T) {
		if _, err := TESTW(reg.CX, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
		if _, err := TESTW(reg.R9W, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestTZCNTLValidForms(t *testing.T) {
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := TZCNTL(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := TZCNTL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestTZCNTQValidForms(t *testing.T) {
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := TZCNTQ(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := TZCNTQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestTZCNTWValidForms(t *testing.T) {
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := TZCNTW(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := TZCNTW(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := TZCNTW(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := TZCNTW(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r16", func(t *testing.T) {
		if _, err := TZCNTW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := TZCNTW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
}

func TestUCOMISDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := UCOMISD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := UCOMISD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestUCOMISSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := UCOMISS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm", func(t *testing.T) {
		if _, err := UCOMISS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestUD2ValidForms(t *testing.T) {
	t.Run("form=", func(t *testing.T) {
		if _, err := UD2(); err != nil {
			t.Fatal(err)
		}
	})
}

func TestUNPCKHPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := UNPCKHPD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := UNPCKHPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestUNPCKHPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := UNPCKHPS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := UNPCKHPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestUNPCKLPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := UNPCKLPD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := UNPCKLPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestUNPCKLPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := UNPCKLPS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := UNPCKLPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVADDPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VADDPD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VADDPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VADDPD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VADDPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVADDPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VADDPS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VADDPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VADDPS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VADDPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVADDSDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VADDSD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm_xmm", func(t *testing.T) {
		if _, err := VADDSD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVADDSSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VADDSS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm_xmm", func(t *testing.T) {
		if _, err := VADDSS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVADDSUBPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VADDSUBPD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VADDSUBPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VADDSUBPD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VADDSUBPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVADDSUBPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VADDSUBPS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VADDSUBPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VADDSUBPS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VADDSUBPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVAESDECValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VAESDEC(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VAESDEC(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVAESDECLASTValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VAESDECLAST(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VAESDECLAST(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVAESENCValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VAESENC(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VAESENC(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVAESENCLASTValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VAESENCLAST(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VAESENCLAST(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVAESIMCValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VAESIMC(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := VAESIMC(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVAESKEYGENASSISTValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := VAESKEYGENASSIST(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm", func(t *testing.T) {
		if _, err := VAESKEYGENASSIST(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVANDNPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VANDNPD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VANDNPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VANDNPD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VANDNPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVANDNPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VANDNPS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VANDNPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VANDNPS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VANDNPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVANDPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VANDPD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VANDPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VANDPD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VANDPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVANDPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VANDPS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VANDPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VANDPS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VANDPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVBLENDPDValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VBLENDPD(operand.Imm(math.MaxInt8), reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm_xmm", func(t *testing.T) {
		if _, err := VBLENDPD(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VBLENDPD(operand.Imm(math.MaxInt8), reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m256_ymm_ymm", func(t *testing.T) {
		if _, err := VBLENDPD(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVBLENDPSValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VBLENDPS(operand.Imm(math.MaxInt8), reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm_xmm", func(t *testing.T) {
		if _, err := VBLENDPS(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VBLENDPS(operand.Imm(math.MaxInt8), reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m256_ymm_ymm", func(t *testing.T) {
		if _, err := VBLENDPS(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVBLENDVPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VBLENDVPD(reg.X7, reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_m128_xmm_xmm", func(t *testing.T) {
		if _, err := VBLENDVPD(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VBLENDVPD(reg.Y15, reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_m256_ymm_ymm", func(t *testing.T) {
		if _, err := VBLENDVPD(reg.Y15, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVBLENDVPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VBLENDVPS(reg.X7, reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_m128_xmm_xmm", func(t *testing.T) {
		if _, err := VBLENDVPS(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VBLENDVPS(reg.Y15, reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_m256_ymm_ymm", func(t *testing.T) {
		if _, err := VBLENDVPS(reg.Y15, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVBROADCASTF128ValidForms(t *testing.T) {
	t.Run("form=m128_ymm", func(t *testing.T) {
		if _, err := VBROADCASTF128(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVBROADCASTI128ValidForms(t *testing.T) {
	t.Run("form=m128_ymm", func(t *testing.T) {
		if _, err := VBROADCASTI128(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVBROADCASTSDValidForms(t *testing.T) {
	t.Run("form=xmm_ymm", func(t *testing.T) {
		if _, err := VBROADCASTSD(reg.X7, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_ymm", func(t *testing.T) {
		if _, err := VBROADCASTSD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVBROADCASTSSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VBROADCASTSS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm", func(t *testing.T) {
		if _, err := VBROADCASTSS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_ymm", func(t *testing.T) {
		if _, err := VBROADCASTSS(reg.X7, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_ymm", func(t *testing.T) {
		if _, err := VBROADCASTSS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVCMPPDValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VCMPPD(operand.Imm(math.MaxInt8), reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm_xmm", func(t *testing.T) {
		if _, err := VCMPPD(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VCMPPD(operand.Imm(math.MaxInt8), reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m256_ymm_ymm", func(t *testing.T) {
		if _, err := VCMPPD(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVCMPPSValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VCMPPS(operand.Imm(math.MaxInt8), reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm_xmm", func(t *testing.T) {
		if _, err := VCMPPS(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VCMPPS(operand.Imm(math.MaxInt8), reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m256_ymm_ymm", func(t *testing.T) {
		if _, err := VCMPPS(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVCMPSDValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VCMPSD(operand.Imm(math.MaxInt8), reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m64_xmm_xmm", func(t *testing.T) {
		if _, err := VCMPSD(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVCMPSSValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VCMPSS(operand.Imm(math.MaxInt8), reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m32_xmm_xmm", func(t *testing.T) {
		if _, err := VCMPSS(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVCOMISDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VCOMISD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := VCOMISD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVCOMISSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VCOMISS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm", func(t *testing.T) {
		if _, err := VCOMISS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVCVTDQ2PDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VCVTDQ2PD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := VCVTDQ2PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_ymm", func(t *testing.T) {
		if _, err := VCVTDQ2PD(reg.X7, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_ymm", func(t *testing.T) {
		if _, err := VCVTDQ2PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVCVTDQ2PSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VCVTDQ2PS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := VCVTDQ2PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm", func(t *testing.T) {
		if _, err := VCVTDQ2PS(reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm", func(t *testing.T) {
		if _, err := VCVTDQ2PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVCVTPD2DQXValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VCVTPD2DQX(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := VCVTPD2DQX(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVCVTPD2DQYValidForms(t *testing.T) {
	t.Run("form=ymm_xmm", func(t *testing.T) {
		if _, err := VCVTPD2DQY(reg.Y15, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_xmm", func(t *testing.T) {
		if _, err := VCVTPD2DQY(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVCVTPD2PSXValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VCVTPD2PSX(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := VCVTPD2PSX(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVCVTPD2PSYValidForms(t *testing.T) {
	t.Run("form=ymm_xmm", func(t *testing.T) {
		if _, err := VCVTPD2PSY(reg.Y15, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_xmm", func(t *testing.T) {
		if _, err := VCVTPD2PSY(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVCVTPH2PSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VCVTPH2PS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := VCVTPH2PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_ymm", func(t *testing.T) {
		if _, err := VCVTPH2PS(reg.X7, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_ymm", func(t *testing.T) {
		if _, err := VCVTPH2PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVCVTPS2DQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VCVTPS2DQ(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := VCVTPS2DQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm", func(t *testing.T) {
		if _, err := VCVTPS2DQ(reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm", func(t *testing.T) {
		if _, err := VCVTPS2DQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVCVTPS2PDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VCVTPS2PD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := VCVTPS2PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_ymm", func(t *testing.T) {
		if _, err := VCVTPS2PD(reg.X7, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_ymm", func(t *testing.T) {
		if _, err := VCVTPS2PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVCVTPS2PHValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := VCVTPS2PH(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_ymm_xmm", func(t *testing.T) {
		if _, err := VCVTPS2PH(operand.Imm(math.MaxInt8), reg.Y15, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_xmm_m64", func(t *testing.T) {
		if _, err := VCVTPS2PH(operand.Imm(math.MaxInt8), reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_ymm_m128", func(t *testing.T) {
		if _, err := VCVTPS2PH(operand.Imm(math.MaxInt8), reg.Y15, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVCVTSD2SIValidForms(t *testing.T) {
	t.Run("form=xmm_r32", func(t *testing.T) {
		if _, err := VCVTSD2SI(reg.X7, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r32", func(t *testing.T) {
		if _, err := VCVTSD2SI(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVCVTSD2SIQValidForms(t *testing.T) {
	t.Run("form=xmm_r64", func(t *testing.T) {
		if _, err := VCVTSD2SIQ(reg.X7, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := VCVTSD2SIQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVCVTSD2SSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VCVTSD2SS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm_xmm", func(t *testing.T) {
		if _, err := VCVTSD2SS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVCVTSI2SDLValidForms(t *testing.T) {
	t.Run("form=r32_xmm_xmm", func(t *testing.T) {
		if _, err := VCVTSI2SDL(reg.R10L, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm_xmm", func(t *testing.T) {
		if _, err := VCVTSI2SDL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVCVTSI2SDQValidForms(t *testing.T) {
	t.Run("form=r64_xmm_xmm", func(t *testing.T) {
		if _, err := VCVTSI2SDQ(reg.R11, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm_xmm", func(t *testing.T) {
		if _, err := VCVTSI2SDQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVCVTSI2SSLValidForms(t *testing.T) {
	t.Run("form=r32_xmm_xmm", func(t *testing.T) {
		if _, err := VCVTSI2SSL(reg.R10L, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm_xmm", func(t *testing.T) {
		if _, err := VCVTSI2SSL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVCVTSI2SSQValidForms(t *testing.T) {
	t.Run("form=r64_xmm_xmm", func(t *testing.T) {
		if _, err := VCVTSI2SSQ(reg.R11, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm_xmm", func(t *testing.T) {
		if _, err := VCVTSI2SSQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVCVTSS2SDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VCVTSS2SD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm_xmm", func(t *testing.T) {
		if _, err := VCVTSS2SD(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVCVTSS2SIValidForms(t *testing.T) {
	t.Run("form=xmm_r32", func(t *testing.T) {
		if _, err := VCVTSS2SI(reg.X7, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := VCVTSS2SI(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVCVTSS2SIQValidForms(t *testing.T) {
	t.Run("form=xmm_r64", func(t *testing.T) {
		if _, err := VCVTSS2SIQ(reg.X7, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r64", func(t *testing.T) {
		if _, err := VCVTSS2SIQ(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVCVTTPD2DQXValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VCVTTPD2DQX(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := VCVTTPD2DQX(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVCVTTPD2DQYValidForms(t *testing.T) {
	t.Run("form=ymm_xmm", func(t *testing.T) {
		if _, err := VCVTTPD2DQY(reg.Y15, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_xmm", func(t *testing.T) {
		if _, err := VCVTTPD2DQY(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVCVTTPS2DQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VCVTTPS2DQ(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := VCVTTPS2DQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm", func(t *testing.T) {
		if _, err := VCVTTPS2DQ(reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm", func(t *testing.T) {
		if _, err := VCVTTPS2DQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVCVTTSD2SIValidForms(t *testing.T) {
	t.Run("form=xmm_r32", func(t *testing.T) {
		if _, err := VCVTTSD2SI(reg.X7, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r32", func(t *testing.T) {
		if _, err := VCVTTSD2SI(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVCVTTSD2SIQValidForms(t *testing.T) {
	t.Run("form=xmm_r64", func(t *testing.T) {
		if _, err := VCVTTSD2SIQ(reg.X7, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := VCVTTSD2SIQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVCVTTSS2SIValidForms(t *testing.T) {
	t.Run("form=xmm_r32", func(t *testing.T) {
		if _, err := VCVTTSS2SI(reg.X7, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := VCVTTSS2SI(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVCVTTSS2SIQValidForms(t *testing.T) {
	t.Run("form=xmm_r64", func(t *testing.T) {
		if _, err := VCVTTSS2SIQ(reg.X7, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r64", func(t *testing.T) {
		if _, err := VCVTTSS2SIQ(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVDIVPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VDIVPD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VDIVPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VDIVPD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VDIVPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVDIVPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VDIVPS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VDIVPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VDIVPS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VDIVPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVDIVSDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VDIVSD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm_xmm", func(t *testing.T) {
		if _, err := VDIVSD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVDIVSSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VDIVSS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm_xmm", func(t *testing.T) {
		if _, err := VDIVSS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVDPPDValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VDPPD(operand.Imm(math.MaxInt8), reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm_xmm", func(t *testing.T) {
		if _, err := VDPPD(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVDPPSValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VDPPS(operand.Imm(math.MaxInt8), reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm_xmm", func(t *testing.T) {
		if _, err := VDPPS(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VDPPS(operand.Imm(math.MaxInt8), reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m256_ymm_ymm", func(t *testing.T) {
		if _, err := VDPPS(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVEXTRACTF128ValidForms(t *testing.T) {
	t.Run("form=imm8_ymm_xmm", func(t *testing.T) {
		if _, err := VEXTRACTF128(operand.Imm(math.MaxInt8), reg.Y15, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_ymm_m128", func(t *testing.T) {
		if _, err := VEXTRACTF128(operand.Imm(math.MaxInt8), reg.Y15, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVEXTRACTI128ValidForms(t *testing.T) {
	t.Run("form=imm8_ymm_xmm", func(t *testing.T) {
		if _, err := VEXTRACTI128(operand.Imm(math.MaxInt8), reg.Y15, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_ymm_m128", func(t *testing.T) {
		if _, err := VEXTRACTI128(operand.Imm(math.MaxInt8), reg.Y15, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVEXTRACTPSValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_r32", func(t *testing.T) {
		if _, err := VEXTRACTPS(operand.Imm(math.MaxInt8), reg.X7, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_xmm_m32", func(t *testing.T) {
		if _, err := VEXTRACTPS(operand.Imm(math.MaxInt8), reg.X7, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMADD132PDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADD132PD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADD132PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFMADD132PD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFMADD132PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMADD132PSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADD132PS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADD132PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFMADD132PS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFMADD132PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMADD132SDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADD132SD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADD132SD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMADD132SSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADD132SS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADD132SS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMADD213PDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADD213PD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADD213PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFMADD213PD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFMADD213PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMADD213PSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADD213PS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADD213PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFMADD213PS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFMADD213PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMADD213SDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADD213SD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADD213SD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMADD213SSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADD213SS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADD213SS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMADD231PDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADD231PD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADD231PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFMADD231PD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFMADD231PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMADD231PSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADD231PS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADD231PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFMADD231PS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFMADD231PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMADD231SDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADD231SD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADD231SD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMADD231SSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADD231SS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADD231SS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMADDSUB132PDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADDSUB132PD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADDSUB132PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFMADDSUB132PD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFMADDSUB132PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMADDSUB132PSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADDSUB132PS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADDSUB132PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFMADDSUB132PS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFMADDSUB132PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMADDSUB213PDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADDSUB213PD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADDSUB213PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFMADDSUB213PD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFMADDSUB213PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMADDSUB213PSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADDSUB213PS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADDSUB213PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFMADDSUB213PS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFMADDSUB213PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMADDSUB231PDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADDSUB231PD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADDSUB231PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFMADDSUB231PD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFMADDSUB231PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMADDSUB231PSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADDSUB231PS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFMADDSUB231PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFMADDSUB231PS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFMADDSUB231PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMSUB132PDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUB132PD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUB132PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFMSUB132PD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFMSUB132PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMSUB132PSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUB132PS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUB132PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFMSUB132PS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFMSUB132PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMSUB132SDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUB132SD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUB132SD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMSUB132SSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUB132SS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUB132SS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMSUB213PDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUB213PD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUB213PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFMSUB213PD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFMSUB213PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMSUB213PSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUB213PS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUB213PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFMSUB213PS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFMSUB213PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMSUB213SDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUB213SD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUB213SD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMSUB213SSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUB213SS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUB213SS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMSUB231PDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUB231PD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUB231PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFMSUB231PD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFMSUB231PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMSUB231PSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUB231PS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUB231PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFMSUB231PS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFMSUB231PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMSUB231SDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUB231SD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUB231SD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMSUB231SSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUB231SS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUB231SS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMSUBADD132PDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUBADD132PD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUBADD132PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFMSUBADD132PD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFMSUBADD132PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMSUBADD132PSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUBADD132PS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUBADD132PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFMSUBADD132PS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFMSUBADD132PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMSUBADD213PDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUBADD213PD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUBADD213PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFMSUBADD213PD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFMSUBADD213PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMSUBADD213PSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUBADD213PS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUBADD213PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFMSUBADD213PS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFMSUBADD213PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMSUBADD231PDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUBADD231PD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUBADD231PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFMSUBADD231PD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFMSUBADD231PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFMSUBADD231PSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUBADD231PS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFMSUBADD231PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFMSUBADD231PS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFMSUBADD231PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFNMADD132PDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMADD132PD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMADD132PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFNMADD132PD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFNMADD132PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFNMADD132PSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMADD132PS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMADD132PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFNMADD132PS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFNMADD132PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFNMADD132SDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMADD132SD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMADD132SD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFNMADD132SSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMADD132SS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMADD132SS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFNMADD213PDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMADD213PD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMADD213PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFNMADD213PD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFNMADD213PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFNMADD213PSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMADD213PS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMADD213PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFNMADD213PS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFNMADD213PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFNMADD213SDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMADD213SD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMADD213SD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFNMADD213SSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMADD213SS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMADD213SS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFNMADD231PDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMADD231PD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMADD231PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFNMADD231PD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFNMADD231PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFNMADD231PSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMADD231PS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMADD231PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFNMADD231PS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFNMADD231PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFNMADD231SDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMADD231SD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMADD231SD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFNMADD231SSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMADD231SS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMADD231SS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFNMSUB132PDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMSUB132PD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMSUB132PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFNMSUB132PD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFNMSUB132PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFNMSUB132PSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMSUB132PS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMSUB132PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFNMSUB132PS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFNMSUB132PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFNMSUB132SDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMSUB132SD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMSUB132SD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFNMSUB132SSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMSUB132SS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMSUB132SS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFNMSUB213PDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMSUB213PD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMSUB213PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFNMSUB213PD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFNMSUB213PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFNMSUB213PSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMSUB213PS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMSUB213PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFNMSUB213PS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFNMSUB213PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFNMSUB213SDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMSUB213SD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMSUB213SD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFNMSUB213SSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMSUB213SS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMSUB213SS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFNMSUB231PDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMSUB231PD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMSUB231PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFNMSUB231PD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFNMSUB231PD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFNMSUB231PSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMSUB231PS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMSUB231PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VFNMSUB231PS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VFNMSUB231PS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFNMSUB231SDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMSUB231SD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMSUB231SD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVFNMSUB231SSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMSUB231SS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm_xmm", func(t *testing.T) {
		if _, err := VFNMSUB231SS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVGATHERDPDValidForms(t *testing.T) {
	t.Run("form=xmm_vm32x_xmm", func(t *testing.T) {
		if _, err := VGATHERDPD(reg.X7, operand.Mem{Base: reg.R13, Index: reg.X4, Scale: 1}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_vm32x_ymm", func(t *testing.T) {
		if _, err := VGATHERDPD(reg.Y15, operand.Mem{Base: reg.R13, Index: reg.X4, Scale: 1}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVGATHERDPSValidForms(t *testing.T) {
	t.Run("form=xmm_vm32x_xmm", func(t *testing.T) {
		if _, err := VGATHERDPS(reg.X7, operand.Mem{Base: reg.R13, Index: reg.X4, Scale: 1}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_vm32y_ymm", func(t *testing.T) {
		if _, err := VGATHERDPS(reg.Y15, operand.Mem{Base: reg.R13, Index: reg.Y4, Scale: 1}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVGATHERQPDValidForms(t *testing.T) {
	t.Run("form=xmm_vm64x_xmm", func(t *testing.T) {
		if _, err := VGATHERQPD(reg.X7, operand.Mem{Base: reg.R13, Index: reg.X8, Scale: 1}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_vm64y_ymm", func(t *testing.T) {
		if _, err := VGATHERQPD(reg.Y15, operand.Mem{Base: reg.R13, Index: reg.Y8, Scale: 1}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVGATHERQPSValidForms(t *testing.T) {
	t.Run("form=xmm_vm64x_xmm", func(t *testing.T) {
		if _, err := VGATHERQPS(reg.X7, operand.Mem{Base: reg.R13, Index: reg.X8, Scale: 1}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_vm64y_xmm", func(t *testing.T) {
		if _, err := VGATHERQPS(reg.X7, operand.Mem{Base: reg.R13, Index: reg.Y8, Scale: 1}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVHADDPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VHADDPD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VHADDPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VHADDPD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VHADDPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVHADDPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VHADDPS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VHADDPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VHADDPS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VHADDPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVHSUBPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VHSUBPD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VHSUBPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VHSUBPD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VHSUBPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVHSUBPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VHSUBPS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VHSUBPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VHSUBPS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VHSUBPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVINSERTF128ValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_ymm_ymm", func(t *testing.T) {
		if _, err := VINSERTF128(operand.Imm(math.MaxInt8), reg.X7, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_ymm_ymm", func(t *testing.T) {
		if _, err := VINSERTF128(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVINSERTI128ValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_ymm_ymm", func(t *testing.T) {
		if _, err := VINSERTI128(operand.Imm(math.MaxInt8), reg.X7, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_ymm_ymm", func(t *testing.T) {
		if _, err := VINSERTI128(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVINSERTPSValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VINSERTPS(operand.Imm(math.MaxInt8), reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m32_xmm_xmm", func(t *testing.T) {
		if _, err := VINSERTPS(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVLDDQUValidForms(t *testing.T) {
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := VLDDQU(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm", func(t *testing.T) {
		if _, err := VLDDQU(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVLDMXCSRValidForms(t *testing.T) {
	t.Run("form=m32", func(t *testing.T) {
		if _, err := VLDMXCSR(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMASKMOVDQUValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VMASKMOVDQU(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMASKMOVPDValidForms(t *testing.T) {
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VMASKMOVPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VMASKMOVPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_xmm_m128", func(t *testing.T) {
		if _, err := VMASKMOVPD(reg.X7, reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_m256", func(t *testing.T) {
		if _, err := VMASKMOVPD(reg.Y15, reg.Y15, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMASKMOVPSValidForms(t *testing.T) {
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VMASKMOVPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VMASKMOVPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_xmm_m128", func(t *testing.T) {
		if _, err := VMASKMOVPS(reg.X7, reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_m256", func(t *testing.T) {
		if _, err := VMASKMOVPS(reg.Y15, reg.Y15, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMAXPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VMAXPD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VMAXPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VMAXPD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VMAXPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMAXPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VMAXPS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VMAXPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VMAXPS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VMAXPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMAXSDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VMAXSD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm_xmm", func(t *testing.T) {
		if _, err := VMAXSD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMAXSSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VMAXSS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm_xmm", func(t *testing.T) {
		if _, err := VMAXSS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMINPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VMINPD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VMINPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VMINPD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VMINPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMINPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VMINPS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VMINPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VMINPS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VMINPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMINSDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VMINSD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm_xmm", func(t *testing.T) {
		if _, err := VMINSD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMINSSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VMINSS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm_xmm", func(t *testing.T) {
		if _, err := VMINSS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMOVAPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VMOVAPD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := VMOVAPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm", func(t *testing.T) {
		if _, err := VMOVAPD(reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm", func(t *testing.T) {
		if _, err := VMOVAPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_m128", func(t *testing.T) {
		if _, err := VMOVAPD(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_m256", func(t *testing.T) {
		if _, err := VMOVAPD(reg.Y15, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMOVAPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VMOVAPS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := VMOVAPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm", func(t *testing.T) {
		if _, err := VMOVAPS(reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm", func(t *testing.T) {
		if _, err := VMOVAPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_m128", func(t *testing.T) {
		if _, err := VMOVAPS(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_m256", func(t *testing.T) {
		if _, err := VMOVAPS(reg.Y15, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMOVDValidForms(t *testing.T) {
	t.Run("form=xmm_r32", func(t *testing.T) {
		if _, err := VMOVD(reg.X7, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_xmm", func(t *testing.T) {
		if _, err := VMOVD(reg.R10L, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm", func(t *testing.T) {
		if _, err := VMOVD(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_m32", func(t *testing.T) {
		if _, err := VMOVD(reg.X7, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMOVDDUPValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VMOVDDUP(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := VMOVDDUP(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm", func(t *testing.T) {
		if _, err := VMOVDDUP(reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm", func(t *testing.T) {
		if _, err := VMOVDDUP(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMOVDQAValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VMOVDQA(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := VMOVDQA(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm", func(t *testing.T) {
		if _, err := VMOVDQA(reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm", func(t *testing.T) {
		if _, err := VMOVDQA(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_m128", func(t *testing.T) {
		if _, err := VMOVDQA(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_m256", func(t *testing.T) {
		if _, err := VMOVDQA(reg.Y15, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMOVDQUValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VMOVDQU(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := VMOVDQU(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm", func(t *testing.T) {
		if _, err := VMOVDQU(reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm", func(t *testing.T) {
		if _, err := VMOVDQU(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_m128", func(t *testing.T) {
		if _, err := VMOVDQU(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_m256", func(t *testing.T) {
		if _, err := VMOVDQU(reg.Y15, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMOVHLPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VMOVHLPS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMOVHPDValidForms(t *testing.T) {
	t.Run("form=xmm_m64", func(t *testing.T) {
		if _, err := VMOVHPD(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm_xmm", func(t *testing.T) {
		if _, err := VMOVHPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMOVHPSValidForms(t *testing.T) {
	t.Run("form=xmm_m64", func(t *testing.T) {
		if _, err := VMOVHPS(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm_xmm", func(t *testing.T) {
		if _, err := VMOVHPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMOVLHPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VMOVLHPS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMOVLPDValidForms(t *testing.T) {
	t.Run("form=xmm_m64", func(t *testing.T) {
		if _, err := VMOVLPD(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm_xmm", func(t *testing.T) {
		if _, err := VMOVLPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMOVLPSValidForms(t *testing.T) {
	t.Run("form=xmm_m64", func(t *testing.T) {
		if _, err := VMOVLPS(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm_xmm", func(t *testing.T) {
		if _, err := VMOVLPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMOVMSKPDValidForms(t *testing.T) {
	t.Run("form=xmm_r32", func(t *testing.T) {
		if _, err := VMOVMSKPD(reg.X7, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_r32", func(t *testing.T) {
		if _, err := VMOVMSKPD(reg.Y15, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMOVMSKPSValidForms(t *testing.T) {
	t.Run("form=xmm_r32", func(t *testing.T) {
		if _, err := VMOVMSKPS(reg.X7, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_r32", func(t *testing.T) {
		if _, err := VMOVMSKPS(reg.Y15, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMOVNTDQValidForms(t *testing.T) {
	t.Run("form=xmm_m128", func(t *testing.T) {
		if _, err := VMOVNTDQ(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_m256", func(t *testing.T) {
		if _, err := VMOVNTDQ(reg.Y15, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMOVNTDQAValidForms(t *testing.T) {
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := VMOVNTDQA(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm", func(t *testing.T) {
		if _, err := VMOVNTDQA(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMOVNTPDValidForms(t *testing.T) {
	t.Run("form=xmm_m128", func(t *testing.T) {
		if _, err := VMOVNTPD(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_m256", func(t *testing.T) {
		if _, err := VMOVNTPD(reg.Y15, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMOVNTPSValidForms(t *testing.T) {
	t.Run("form=xmm_m128", func(t *testing.T) {
		if _, err := VMOVNTPS(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_m256", func(t *testing.T) {
		if _, err := VMOVNTPS(reg.Y15, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMOVQValidForms(t *testing.T) {
	t.Run("form=xmm_r64", func(t *testing.T) {
		if _, err := VMOVQ(reg.X7, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_xmm", func(t *testing.T) {
		if _, err := VMOVQ(reg.R11, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VMOVQ(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := VMOVQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_m64", func(t *testing.T) {
		if _, err := VMOVQ(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMOVSDValidForms(t *testing.T) {
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := VMOVSD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_m64", func(t *testing.T) {
		if _, err := VMOVSD(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VMOVSD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMOVSHDUPValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VMOVSHDUP(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := VMOVSHDUP(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm", func(t *testing.T) {
		if _, err := VMOVSHDUP(reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm", func(t *testing.T) {
		if _, err := VMOVSHDUP(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMOVSLDUPValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VMOVSLDUP(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := VMOVSLDUP(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm", func(t *testing.T) {
		if _, err := VMOVSLDUP(reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm", func(t *testing.T) {
		if _, err := VMOVSLDUP(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMOVSSValidForms(t *testing.T) {
	t.Run("form=m32_xmm", func(t *testing.T) {
		if _, err := VMOVSS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_m32", func(t *testing.T) {
		if _, err := VMOVSS(reg.X7, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VMOVSS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMOVUPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VMOVUPD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := VMOVUPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm", func(t *testing.T) {
		if _, err := VMOVUPD(reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm", func(t *testing.T) {
		if _, err := VMOVUPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_m128", func(t *testing.T) {
		if _, err := VMOVUPD(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_m256", func(t *testing.T) {
		if _, err := VMOVUPD(reg.Y15, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMOVUPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VMOVUPS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := VMOVUPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm", func(t *testing.T) {
		if _, err := VMOVUPS(reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm", func(t *testing.T) {
		if _, err := VMOVUPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_m128", func(t *testing.T) {
		if _, err := VMOVUPS(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_m256", func(t *testing.T) {
		if _, err := VMOVUPS(reg.Y15, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMPSADBWValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VMPSADBW(operand.Imm(math.MaxInt8), reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm_xmm", func(t *testing.T) {
		if _, err := VMPSADBW(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VMPSADBW(operand.Imm(math.MaxInt8), reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m256_ymm_ymm", func(t *testing.T) {
		if _, err := VMPSADBW(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMULPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VMULPD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VMULPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VMULPD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VMULPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMULPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VMULPS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VMULPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VMULPS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VMULPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMULSDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VMULSD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm_xmm", func(t *testing.T) {
		if _, err := VMULSD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVMULSSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VMULSS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm_xmm", func(t *testing.T) {
		if _, err := VMULSS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVORPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VORPD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VORPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VORPD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VORPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVORPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VORPS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VORPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VORPS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VORPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPABSBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VPABSB(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := VPABSB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm", func(t *testing.T) {
		if _, err := VPABSB(reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm", func(t *testing.T) {
		if _, err := VPABSB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPABSDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VPABSD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := VPABSD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm", func(t *testing.T) {
		if _, err := VPABSD(reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm", func(t *testing.T) {
		if _, err := VPABSD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPABSWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VPABSW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := VPABSW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm", func(t *testing.T) {
		if _, err := VPABSW(reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm", func(t *testing.T) {
		if _, err := VPABSW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPACKSSDWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPACKSSDW(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPACKSSDW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPACKSSDW(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPACKSSDW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPACKSSWBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPACKSSWB(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPACKSSWB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPACKSSWB(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPACKSSWB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPACKUSDWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPACKUSDW(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPACKUSDW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPACKUSDW(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPACKUSDW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPACKUSWBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPACKUSWB(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPACKUSWB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPACKUSWB(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPACKUSWB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPADDBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPADDB(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPADDB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPADDB(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPADDB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPADDDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPADDD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPADDD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPADDD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPADDD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPADDQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPADDQ(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPADDQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPADDQ(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPADDQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPADDSBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPADDSB(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPADDSB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPADDSB(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPADDSB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPADDSWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPADDSW(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPADDSW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPADDSW(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPADDSW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPADDUSBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPADDUSB(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPADDUSB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPADDUSB(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPADDUSB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPADDUSWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPADDUSW(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPADDUSW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPADDUSW(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPADDUSW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPADDWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPADDW(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPADDW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPADDW(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPADDW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPALIGNRValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPALIGNR(operand.Imm(math.MaxInt8), reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPALIGNR(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPALIGNR(operand.Imm(math.MaxInt8), reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPALIGNR(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPANDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPAND(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPAND(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPAND(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPAND(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPANDNValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPANDN(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPANDN(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPANDN(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPANDN(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPAVGBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPAVGB(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPAVGB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPAVGB(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPAVGB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPAVGWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPAVGW(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPAVGW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPAVGW(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPAVGW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPBLENDDValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPBLENDD(operand.Imm(math.MaxInt8), reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPBLENDD(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPBLENDD(operand.Imm(math.MaxInt8), reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPBLENDD(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPBLENDVBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPBLENDVB(reg.X7, reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPBLENDVB(reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPBLENDVB(reg.Y15, reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPBLENDVB(reg.Y15, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPBLENDWValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPBLENDW(operand.Imm(math.MaxInt8), reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPBLENDW(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPBLENDW(operand.Imm(math.MaxInt8), reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPBLENDW(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPBROADCASTBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VPBROADCASTB(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8_xmm", func(t *testing.T) {
		if _, err := VPBROADCASTB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_ymm", func(t *testing.T) {
		if _, err := VPBROADCASTB(reg.X7, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8_ymm", func(t *testing.T) {
		if _, err := VPBROADCASTB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPBROADCASTDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VPBROADCASTD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm", func(t *testing.T) {
		if _, err := VPBROADCASTD(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_ymm", func(t *testing.T) {
		if _, err := VPBROADCASTD(reg.X7, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_ymm", func(t *testing.T) {
		if _, err := VPBROADCASTD(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPBROADCASTQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VPBROADCASTQ(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := VPBROADCASTQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_ymm", func(t *testing.T) {
		if _, err := VPBROADCASTQ(reg.X7, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_ymm", func(t *testing.T) {
		if _, err := VPBROADCASTQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPBROADCASTWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VPBROADCASTW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_xmm", func(t *testing.T) {
		if _, err := VPBROADCASTW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_ymm", func(t *testing.T) {
		if _, err := VPBROADCASTW(reg.X7, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_ymm", func(t *testing.T) {
		if _, err := VPBROADCASTW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPCLMULQDQValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPCLMULQDQ(operand.Imm(math.MaxInt8), reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPCLMULQDQ(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPCMPEQBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPCMPEQB(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPCMPEQB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPCMPEQB(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPCMPEQB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPCMPEQDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPCMPEQD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPCMPEQD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPCMPEQD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPCMPEQD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPCMPEQQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPCMPEQQ(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPCMPEQQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPCMPEQQ(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPCMPEQQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPCMPEQWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPCMPEQW(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPCMPEQW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPCMPEQW(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPCMPEQW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPCMPESTRIValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := VPCMPESTRI(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm", func(t *testing.T) {
		if _, err := VPCMPESTRI(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPCMPESTRMValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := VPCMPESTRM(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm", func(t *testing.T) {
		if _, err := VPCMPESTRM(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPCMPGTBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPCMPGTB(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPCMPGTB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPCMPGTB(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPCMPGTB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPCMPGTDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPCMPGTD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPCMPGTD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPCMPGTD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPCMPGTD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPCMPGTQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPCMPGTQ(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPCMPGTQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPCMPGTQ(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPCMPGTQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPCMPGTWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPCMPGTW(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPCMPGTW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPCMPGTW(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPCMPGTW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPCMPISTRIValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := VPCMPISTRI(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm", func(t *testing.T) {
		if _, err := VPCMPISTRI(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPCMPISTRMValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := VPCMPISTRM(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm", func(t *testing.T) {
		if _, err := VPCMPISTRM(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPERM2F128ValidForms(t *testing.T) {
	t.Run("form=imm8_ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPERM2F128(operand.Imm(math.MaxInt8), reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPERM2F128(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPERM2I128ValidForms(t *testing.T) {
	t.Run("form=imm8_ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPERM2I128(operand.Imm(math.MaxInt8), reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPERM2I128(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPERMDValidForms(t *testing.T) {
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPERMD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPERMD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPERMILPDValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := VPERMILPD(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPERMILPD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPERMILPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm", func(t *testing.T) {
		if _, err := VPERMILPD(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_ymm_ymm", func(t *testing.T) {
		if _, err := VPERMILPD(operand.Imm(math.MaxInt8), reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPERMILPD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPERMILPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m256_ymm", func(t *testing.T) {
		if _, err := VPERMILPD(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPERMILPSValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := VPERMILPS(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPERMILPS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPERMILPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm", func(t *testing.T) {
		if _, err := VPERMILPS(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_ymm_ymm", func(t *testing.T) {
		if _, err := VPERMILPS(operand.Imm(math.MaxInt8), reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPERMILPS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPERMILPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m256_ymm", func(t *testing.T) {
		if _, err := VPERMILPS(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPERMPDValidForms(t *testing.T) {
	t.Run("form=imm8_ymm_ymm", func(t *testing.T) {
		if _, err := VPERMPD(operand.Imm(math.MaxInt8), reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m256_ymm", func(t *testing.T) {
		if _, err := VPERMPD(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPERMPSValidForms(t *testing.T) {
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPERMPS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPERMPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPERMQValidForms(t *testing.T) {
	t.Run("form=imm8_ymm_ymm", func(t *testing.T) {
		if _, err := VPERMQ(operand.Imm(math.MaxInt8), reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m256_ymm", func(t *testing.T) {
		if _, err := VPERMQ(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPEXTRBValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_r32", func(t *testing.T) {
		if _, err := VPEXTRB(operand.Imm(math.MaxInt8), reg.X7, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_xmm_m8", func(t *testing.T) {
		if _, err := VPEXTRB(operand.Imm(math.MaxInt8), reg.X7, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPEXTRDValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_r32", func(t *testing.T) {
		if _, err := VPEXTRD(operand.Imm(math.MaxInt8), reg.X7, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_xmm_m32", func(t *testing.T) {
		if _, err := VPEXTRD(operand.Imm(math.MaxInt8), reg.X7, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPEXTRQValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_r64", func(t *testing.T) {
		if _, err := VPEXTRQ(operand.Imm(math.MaxInt8), reg.X7, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_xmm_m64", func(t *testing.T) {
		if _, err := VPEXTRQ(operand.Imm(math.MaxInt8), reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPEXTRWValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_r32", func(t *testing.T) {
		if _, err := VPEXTRW(operand.Imm(math.MaxInt8), reg.X7, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_xmm_m16", func(t *testing.T) {
		if _, err := VPEXTRW(operand.Imm(math.MaxInt8), reg.X7, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPGATHERDDValidForms(t *testing.T) {
	t.Run("form=xmm_vm32x_xmm", func(t *testing.T) {
		if _, err := VPGATHERDD(reg.X7, operand.Mem{Base: reg.R13, Index: reg.X4, Scale: 1}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_vm32y_ymm", func(t *testing.T) {
		if _, err := VPGATHERDD(reg.Y15, operand.Mem{Base: reg.R13, Index: reg.Y4, Scale: 1}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPGATHERDQValidForms(t *testing.T) {
	t.Run("form=xmm_vm32x_xmm", func(t *testing.T) {
		if _, err := VPGATHERDQ(reg.X7, operand.Mem{Base: reg.R13, Index: reg.X4, Scale: 1}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_vm32x_ymm", func(t *testing.T) {
		if _, err := VPGATHERDQ(reg.Y15, operand.Mem{Base: reg.R13, Index: reg.X4, Scale: 1}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPGATHERQDValidForms(t *testing.T) {
	t.Run("form=xmm_vm64x_xmm", func(t *testing.T) {
		if _, err := VPGATHERQD(reg.X7, operand.Mem{Base: reg.R13, Index: reg.X8, Scale: 1}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_vm64y_xmm", func(t *testing.T) {
		if _, err := VPGATHERQD(reg.X7, operand.Mem{Base: reg.R13, Index: reg.Y8, Scale: 1}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPGATHERQQValidForms(t *testing.T) {
	t.Run("form=xmm_vm64x_xmm", func(t *testing.T) {
		if _, err := VPGATHERQQ(reg.X7, operand.Mem{Base: reg.R13, Index: reg.X8, Scale: 1}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_vm64y_ymm", func(t *testing.T) {
		if _, err := VPGATHERQQ(reg.Y15, operand.Mem{Base: reg.R13, Index: reg.Y8, Scale: 1}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPHADDDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPHADDD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPHADDD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPHADDD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPHADDD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPHADDSWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPHADDSW(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPHADDSW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPHADDSW(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPHADDSW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPHADDWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPHADDW(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPHADDW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPHADDW(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPHADDW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPHMINPOSUWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VPHMINPOSUW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := VPHMINPOSUW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPHSUBDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPHSUBD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPHSUBD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPHSUBD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPHSUBD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPHSUBSWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPHSUBSW(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPHSUBSW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPHSUBSW(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPHSUBSW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPHSUBWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPHSUBW(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPHSUBW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPHSUBW(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPHSUBW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPINSRBValidForms(t *testing.T) {
	t.Run("form=imm8_r32_xmm_xmm", func(t *testing.T) {
		if _, err := VPINSRB(operand.Imm(math.MaxInt8), reg.R10L, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m8_xmm_xmm", func(t *testing.T) {
		if _, err := VPINSRB(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPINSRDValidForms(t *testing.T) {
	t.Run("form=imm8_r32_xmm_xmm", func(t *testing.T) {
		if _, err := VPINSRD(operand.Imm(math.MaxInt8), reg.R10L, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m32_xmm_xmm", func(t *testing.T) {
		if _, err := VPINSRD(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPINSRQValidForms(t *testing.T) {
	t.Run("form=imm8_r64_xmm_xmm", func(t *testing.T) {
		if _, err := VPINSRQ(operand.Imm(math.MaxInt8), reg.R11, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m64_xmm_xmm", func(t *testing.T) {
		if _, err := VPINSRQ(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPINSRWValidForms(t *testing.T) {
	t.Run("form=imm8_r32_xmm_xmm", func(t *testing.T) {
		if _, err := VPINSRW(operand.Imm(math.MaxInt8), reg.R10L, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m16_xmm_xmm", func(t *testing.T) {
		if _, err := VPINSRW(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMADDUBSWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPMADDUBSW(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPMADDUBSW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPMADDUBSW(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPMADDUBSW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMADDWDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPMADDWD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPMADDWD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPMADDWD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPMADDWD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMASKMOVDValidForms(t *testing.T) {
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPMASKMOVD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPMASKMOVD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_xmm_m128", func(t *testing.T) {
		if _, err := VPMASKMOVD(reg.X7, reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_m256", func(t *testing.T) {
		if _, err := VPMASKMOVD(reg.Y15, reg.Y15, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMASKMOVQValidForms(t *testing.T) {
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPMASKMOVQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPMASKMOVQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_xmm_m128", func(t *testing.T) {
		if _, err := VPMASKMOVQ(reg.X7, reg.X7, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_m256", func(t *testing.T) {
		if _, err := VPMASKMOVQ(reg.Y15, reg.Y15, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMAXSBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPMAXSB(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPMAXSB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPMAXSB(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPMAXSB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMAXSDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPMAXSD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPMAXSD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPMAXSD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPMAXSD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMAXSWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPMAXSW(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPMAXSW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPMAXSW(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPMAXSW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMAXUBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPMAXUB(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPMAXUB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPMAXUB(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPMAXUB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMAXUDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPMAXUD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPMAXUD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPMAXUD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPMAXUD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMAXUWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPMAXUW(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPMAXUW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPMAXUW(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPMAXUW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMINSBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPMINSB(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPMINSB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPMINSB(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPMINSB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMINSDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPMINSD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPMINSD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPMINSD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPMINSD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMINSWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPMINSW(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPMINSW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPMINSW(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPMINSW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMINUBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPMINUB(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPMINUB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPMINUB(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPMINUB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMINUDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPMINUD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPMINUD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPMINUD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPMINUD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMINUWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPMINUW(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPMINUW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPMINUW(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPMINUW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMOVMSKBValidForms(t *testing.T) {
	t.Run("form=xmm_r32", func(t *testing.T) {
		if _, err := VPMOVMSKB(reg.X7, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_r32", func(t *testing.T) {
		if _, err := VPMOVMSKB(reg.Y15, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMOVSXBDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VPMOVSXBD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm", func(t *testing.T) {
		if _, err := VPMOVSXBD(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_ymm", func(t *testing.T) {
		if _, err := VPMOVSXBD(reg.X7, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_ymm", func(t *testing.T) {
		if _, err := VPMOVSXBD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMOVSXBQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VPMOVSXBQ(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_xmm", func(t *testing.T) {
		if _, err := VPMOVSXBQ(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_ymm", func(t *testing.T) {
		if _, err := VPMOVSXBQ(reg.X7, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_ymm", func(t *testing.T) {
		if _, err := VPMOVSXBQ(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMOVSXBWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VPMOVSXBW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := VPMOVSXBW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_ymm", func(t *testing.T) {
		if _, err := VPMOVSXBW(reg.X7, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_ymm", func(t *testing.T) {
		if _, err := VPMOVSXBW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMOVSXDQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VPMOVSXDQ(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := VPMOVSXDQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_ymm", func(t *testing.T) {
		if _, err := VPMOVSXDQ(reg.X7, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_ymm", func(t *testing.T) {
		if _, err := VPMOVSXDQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMOVSXWDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VPMOVSXWD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := VPMOVSXWD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_ymm", func(t *testing.T) {
		if _, err := VPMOVSXWD(reg.X7, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_ymm", func(t *testing.T) {
		if _, err := VPMOVSXWD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMOVSXWQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VPMOVSXWQ(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm", func(t *testing.T) {
		if _, err := VPMOVSXWQ(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_ymm", func(t *testing.T) {
		if _, err := VPMOVSXWQ(reg.X7, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_ymm", func(t *testing.T) {
		if _, err := VPMOVSXWQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMOVZXBDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VPMOVZXBD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm", func(t *testing.T) {
		if _, err := VPMOVZXBD(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_ymm", func(t *testing.T) {
		if _, err := VPMOVZXBD(reg.X7, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_ymm", func(t *testing.T) {
		if _, err := VPMOVZXBD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMOVZXBQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VPMOVZXBQ(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_xmm", func(t *testing.T) {
		if _, err := VPMOVZXBQ(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_ymm", func(t *testing.T) {
		if _, err := VPMOVZXBQ(reg.X7, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_ymm", func(t *testing.T) {
		if _, err := VPMOVZXBQ(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMOVZXBWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VPMOVZXBW(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := VPMOVZXBW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_ymm", func(t *testing.T) {
		if _, err := VPMOVZXBW(reg.X7, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_ymm", func(t *testing.T) {
		if _, err := VPMOVZXBW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMOVZXDQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VPMOVZXDQ(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := VPMOVZXDQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_ymm", func(t *testing.T) {
		if _, err := VPMOVZXDQ(reg.X7, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_ymm", func(t *testing.T) {
		if _, err := VPMOVZXDQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMOVZXWDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VPMOVZXWD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := VPMOVZXWD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_ymm", func(t *testing.T) {
		if _, err := VPMOVZXWD(reg.X7, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_ymm", func(t *testing.T) {
		if _, err := VPMOVZXWD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMOVZXWQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VPMOVZXWQ(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm", func(t *testing.T) {
		if _, err := VPMOVZXWQ(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_ymm", func(t *testing.T) {
		if _, err := VPMOVZXWQ(reg.X7, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_ymm", func(t *testing.T) {
		if _, err := VPMOVZXWQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMULDQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPMULDQ(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPMULDQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPMULDQ(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPMULDQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMULHRSWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPMULHRSW(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPMULHRSW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPMULHRSW(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPMULHRSW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMULHUWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPMULHUW(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPMULHUW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPMULHUW(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPMULHUW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMULHWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPMULHW(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPMULHW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPMULHW(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPMULHW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMULLDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPMULLD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPMULLD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPMULLD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPMULLD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMULLWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPMULLW(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPMULLW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPMULLW(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPMULLW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPMULUDQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPMULUDQ(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPMULUDQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPMULUDQ(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPMULUDQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPORValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPOR(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPOR(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPOR(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPOR(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPSADBWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPSADBW(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPSADBW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPSADBW(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPSADBW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPSHUFBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPSHUFB(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPSHUFB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPSHUFB(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPSHUFB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPSHUFDValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := VPSHUFD(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm", func(t *testing.T) {
		if _, err := VPSHUFD(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_ymm_ymm", func(t *testing.T) {
		if _, err := VPSHUFD(operand.Imm(math.MaxInt8), reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m256_ymm", func(t *testing.T) {
		if _, err := VPSHUFD(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPSHUFHWValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := VPSHUFHW(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm", func(t *testing.T) {
		if _, err := VPSHUFHW(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_ymm_ymm", func(t *testing.T) {
		if _, err := VPSHUFHW(operand.Imm(math.MaxInt8), reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m256_ymm", func(t *testing.T) {
		if _, err := VPSHUFHW(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPSHUFLWValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := VPSHUFLW(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm", func(t *testing.T) {
		if _, err := VPSHUFLW(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_ymm_ymm", func(t *testing.T) {
		if _, err := VPSHUFLW(operand.Imm(math.MaxInt8), reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m256_ymm", func(t *testing.T) {
		if _, err := VPSHUFLW(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPSIGNBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPSIGNB(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPSIGNB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPSIGNB(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPSIGNB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPSIGNDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPSIGND(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPSIGND(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPSIGND(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPSIGND(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPSIGNWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPSIGNW(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPSIGNW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPSIGNW(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPSIGNW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPSLLDValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := VPSLLD(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPSLLD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPSLLD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_ymm_ymm", func(t *testing.T) {
		if _, err := VPSLLD(operand.Imm(math.MaxInt8), reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_ymm_ymm", func(t *testing.T) {
		if _, err := VPSLLD(reg.X7, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_ymm_ymm", func(t *testing.T) {
		if _, err := VPSLLD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPSLLDQValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := VPSLLDQ(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_ymm_ymm", func(t *testing.T) {
		if _, err := VPSLLDQ(operand.Imm(math.MaxInt8), reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPSLLQValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := VPSLLQ(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPSLLQ(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPSLLQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_ymm_ymm", func(t *testing.T) {
		if _, err := VPSLLQ(operand.Imm(math.MaxInt8), reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_ymm_ymm", func(t *testing.T) {
		if _, err := VPSLLQ(reg.X7, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_ymm_ymm", func(t *testing.T) {
		if _, err := VPSLLQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPSLLVDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPSLLVD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPSLLVD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPSLLVD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPSLLVD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPSLLVQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPSLLVQ(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPSLLVQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPSLLVQ(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPSLLVQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPSLLWValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := VPSLLW(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPSLLW(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPSLLW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_ymm_ymm", func(t *testing.T) {
		if _, err := VPSLLW(operand.Imm(math.MaxInt8), reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_ymm_ymm", func(t *testing.T) {
		if _, err := VPSLLW(reg.X7, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_ymm_ymm", func(t *testing.T) {
		if _, err := VPSLLW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPSRADValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := VPSRAD(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPSRAD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPSRAD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_ymm_ymm", func(t *testing.T) {
		if _, err := VPSRAD(operand.Imm(math.MaxInt8), reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_ymm_ymm", func(t *testing.T) {
		if _, err := VPSRAD(reg.X7, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_ymm_ymm", func(t *testing.T) {
		if _, err := VPSRAD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPSRAVDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPSRAVD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPSRAVD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPSRAVD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPSRAVD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPSRAWValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := VPSRAW(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPSRAW(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPSRAW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_ymm_ymm", func(t *testing.T) {
		if _, err := VPSRAW(operand.Imm(math.MaxInt8), reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_ymm_ymm", func(t *testing.T) {
		if _, err := VPSRAW(reg.X7, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_ymm_ymm", func(t *testing.T) {
		if _, err := VPSRAW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPSRLDValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := VPSRLD(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPSRLD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPSRLD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_ymm_ymm", func(t *testing.T) {
		if _, err := VPSRLD(operand.Imm(math.MaxInt8), reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_ymm_ymm", func(t *testing.T) {
		if _, err := VPSRLD(reg.X7, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_ymm_ymm", func(t *testing.T) {
		if _, err := VPSRLD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPSRLDQValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := VPSRLDQ(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_ymm_ymm", func(t *testing.T) {
		if _, err := VPSRLDQ(operand.Imm(math.MaxInt8), reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPSRLQValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := VPSRLQ(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPSRLQ(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPSRLQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_ymm_ymm", func(t *testing.T) {
		if _, err := VPSRLQ(operand.Imm(math.MaxInt8), reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_ymm_ymm", func(t *testing.T) {
		if _, err := VPSRLQ(reg.X7, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_ymm_ymm", func(t *testing.T) {
		if _, err := VPSRLQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPSRLVDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPSRLVD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPSRLVD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPSRLVD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPSRLVD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPSRLVQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPSRLVQ(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPSRLVQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPSRLVQ(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPSRLVQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPSRLWValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := VPSRLW(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPSRLW(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPSRLW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_ymm_ymm", func(t *testing.T) {
		if _, err := VPSRLW(operand.Imm(math.MaxInt8), reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=xmm_ymm_ymm", func(t *testing.T) {
		if _, err := VPSRLW(reg.X7, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_ymm_ymm", func(t *testing.T) {
		if _, err := VPSRLW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPSUBBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPSUBB(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPSUBB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPSUBB(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPSUBB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPSUBDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPSUBD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPSUBD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPSUBD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPSUBD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPSUBQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPSUBQ(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPSUBQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPSUBQ(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPSUBQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPSUBSBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPSUBSB(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPSUBSB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPSUBSB(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPSUBSB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPSUBSWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPSUBSW(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPSUBSW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPSUBSW(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPSUBSW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPSUBUSBValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPSUBUSB(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPSUBUSB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPSUBUSB(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPSUBUSB(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPSUBUSWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPSUBUSW(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPSUBUSW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPSUBUSW(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPSUBUSW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPSUBWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPSUBW(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPSUBW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPSUBW(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPSUBW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPTESTValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VPTEST(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := VPTEST(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm", func(t *testing.T) {
		if _, err := VPTEST(reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm", func(t *testing.T) {
		if _, err := VPTEST(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPUNPCKHBWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPUNPCKHBW(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPUNPCKHBW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPUNPCKHBW(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPUNPCKHBW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPUNPCKHDQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPUNPCKHDQ(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPUNPCKHDQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPUNPCKHDQ(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPUNPCKHDQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPUNPCKHQDQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPUNPCKHQDQ(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPUNPCKHQDQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPUNPCKHQDQ(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPUNPCKHQDQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPUNPCKHWDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPUNPCKHWD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPUNPCKHWD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPUNPCKHWD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPUNPCKHWD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPUNPCKLBWValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPUNPCKLBW(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPUNPCKLBW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPUNPCKLBW(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPUNPCKLBW(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPUNPCKLDQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPUNPCKLDQ(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPUNPCKLDQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPUNPCKLDQ(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPUNPCKLDQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPUNPCKLQDQValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPUNPCKLQDQ(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPUNPCKLQDQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPUNPCKLQDQ(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPUNPCKLQDQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPUNPCKLWDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPUNPCKLWD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPUNPCKLWD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPUNPCKLWD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPUNPCKLWD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVPXORValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VPXOR(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VPXOR(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VPXOR(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VPXOR(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVRCPPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VRCPPS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := VRCPPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm", func(t *testing.T) {
		if _, err := VRCPPS(reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm", func(t *testing.T) {
		if _, err := VRCPPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVRCPSSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VRCPSS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm_xmm", func(t *testing.T) {
		if _, err := VRCPSS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVROUNDPDValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := VROUNDPD(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm", func(t *testing.T) {
		if _, err := VROUNDPD(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_ymm_ymm", func(t *testing.T) {
		if _, err := VROUNDPD(operand.Imm(math.MaxInt8), reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m256_ymm", func(t *testing.T) {
		if _, err := VROUNDPD(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVROUNDPSValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm", func(t *testing.T) {
		if _, err := VROUNDPS(operand.Imm(math.MaxInt8), reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm", func(t *testing.T) {
		if _, err := VROUNDPS(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_ymm_ymm", func(t *testing.T) {
		if _, err := VROUNDPS(operand.Imm(math.MaxInt8), reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m256_ymm", func(t *testing.T) {
		if _, err := VROUNDPS(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVROUNDSDValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VROUNDSD(operand.Imm(math.MaxInt8), reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m64_xmm_xmm", func(t *testing.T) {
		if _, err := VROUNDSD(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVROUNDSSValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VROUNDSS(operand.Imm(math.MaxInt8), reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m32_xmm_xmm", func(t *testing.T) {
		if _, err := VROUNDSS(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVRSQRTPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VRSQRTPS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := VRSQRTPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm", func(t *testing.T) {
		if _, err := VRSQRTPS(reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm", func(t *testing.T) {
		if _, err := VRSQRTPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVRSQRTSSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VRSQRTSS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm_xmm", func(t *testing.T) {
		if _, err := VRSQRTSS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVSHUFPDValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VSHUFPD(operand.Imm(math.MaxInt8), reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm_xmm", func(t *testing.T) {
		if _, err := VSHUFPD(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VSHUFPD(operand.Imm(math.MaxInt8), reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m256_ymm_ymm", func(t *testing.T) {
		if _, err := VSHUFPD(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVSHUFPSValidForms(t *testing.T) {
	t.Run("form=imm8_xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VSHUFPS(operand.Imm(math.MaxInt8), reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m128_xmm_xmm", func(t *testing.T) {
		if _, err := VSHUFPS(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VSHUFPS(operand.Imm(math.MaxInt8), reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m256_ymm_ymm", func(t *testing.T) {
		if _, err := VSHUFPS(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVSQRTPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VSQRTPD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := VSQRTPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm", func(t *testing.T) {
		if _, err := VSQRTPD(reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm", func(t *testing.T) {
		if _, err := VSQRTPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVSQRTPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VSQRTPS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := VSQRTPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm", func(t *testing.T) {
		if _, err := VSQRTPS(reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm", func(t *testing.T) {
		if _, err := VSQRTPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVSQRTSDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VSQRTSD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm_xmm", func(t *testing.T) {
		if _, err := VSQRTSD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVSQRTSSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VSQRTSS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm_xmm", func(t *testing.T) {
		if _, err := VSQRTSS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVSTMXCSRValidForms(t *testing.T) {
	t.Run("form=m32", func(t *testing.T) {
		if _, err := VSTMXCSR(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVSUBPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VSUBPD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VSUBPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VSUBPD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VSUBPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVSUBPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VSUBPS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VSUBPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VSUBPS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VSUBPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVSUBSDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VSUBSD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm_xmm", func(t *testing.T) {
		if _, err := VSUBSD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVSUBSSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VSUBSS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm_xmm", func(t *testing.T) {
		if _, err := VSUBSS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVTESTPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VTESTPD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := VTESTPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm", func(t *testing.T) {
		if _, err := VTESTPD(reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm", func(t *testing.T) {
		if _, err := VTESTPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVTESTPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VTESTPS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := VTESTPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm", func(t *testing.T) {
		if _, err := VTESTPS(reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm", func(t *testing.T) {
		if _, err := VTESTPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVUCOMISDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VUCOMISD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_xmm", func(t *testing.T) {
		if _, err := VUCOMISD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVUCOMISSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := VUCOMISS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_xmm", func(t *testing.T) {
		if _, err := VUCOMISS(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVUNPCKHPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VUNPCKHPD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VUNPCKHPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VUNPCKHPD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VUNPCKHPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVUNPCKHPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VUNPCKHPS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VUNPCKHPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VUNPCKHPS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VUNPCKHPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVUNPCKLPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VUNPCKLPD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VUNPCKLPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VUNPCKLPD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VUNPCKLPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVUNPCKLPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VUNPCKLPS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VUNPCKLPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VUNPCKLPS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VUNPCKLPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVXORPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VXORPD(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VXORPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VXORPD(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VXORPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVXORPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm_xmm", func(t *testing.T) {
		if _, err := VXORPS(reg.X7, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm_xmm", func(t *testing.T) {
		if _, err := VXORPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ymm_ymm_ymm", func(t *testing.T) {
		if _, err := VXORPS(reg.Y15, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m256_ymm_ymm", func(t *testing.T) {
		if _, err := VXORPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.Y15, reg.Y15); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVZEROALLValidForms(t *testing.T) {
	t.Run("form=", func(t *testing.T) {
		if _, err := VZEROALL(); err != nil {
			t.Fatal(err)
		}
	})
}

func TestVZEROUPPERValidForms(t *testing.T) {
	t.Run("form=", func(t *testing.T) {
		if _, err := VZEROUPPER(); err != nil {
			t.Fatal(err)
		}
	})
}

func TestXADDBValidForms(t *testing.T) {
	t.Run("form=r8_r8", func(t *testing.T) {
		if _, err := XADDB(reg.CH, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := XADDB(reg.CH, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := XADDB(reg.CH, reg.R13B); err != nil {
			t.Fatal(err)
		}
		if _, err := XADDB(reg.BL, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := XADDB(reg.BL, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := XADDB(reg.BL, reg.R13B); err != nil {
			t.Fatal(err)
		}
		if _, err := XADDB(reg.R13B, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := XADDB(reg.R13B, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := XADDB(reg.R13B, reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r8_m8", func(t *testing.T) {
		if _, err := XADDB(reg.CH, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
		if _, err := XADDB(reg.BL, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
		if _, err := XADDB(reg.R13B, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestXADDLValidForms(t *testing.T) {
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := XADDL(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_m32", func(t *testing.T) {
		if _, err := XADDL(reg.R10L, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestXADDQValidForms(t *testing.T) {
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := XADDQ(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_m64", func(t *testing.T) {
		if _, err := XADDQ(reg.R11, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestXADDWValidForms(t *testing.T) {
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := XADDW(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := XADDW(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := XADDW(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := XADDW(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_m16", func(t *testing.T) {
		if _, err := XADDW(reg.CX, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
		if _, err := XADDW(reg.R9W, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestXCHGBValidForms(t *testing.T) {
	t.Run("form=r8_r8", func(t *testing.T) {
		if _, err := XCHGB(reg.CH, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := XCHGB(reg.CH, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := XCHGB(reg.CH, reg.R13B); err != nil {
			t.Fatal(err)
		}
		if _, err := XCHGB(reg.BL, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := XCHGB(reg.BL, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := XCHGB(reg.BL, reg.R13B); err != nil {
			t.Fatal(err)
		}
		if _, err := XCHGB(reg.R13B, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := XCHGB(reg.R13B, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := XCHGB(reg.R13B, reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8_r8", func(t *testing.T) {
		if _, err := XCHGB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := XCHGB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := XCHGB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r8_m8", func(t *testing.T) {
		if _, err := XCHGB(reg.CH, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
		if _, err := XCHGB(reg.BL, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
		if _, err := XCHGB(reg.R13B, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestXCHGLValidForms(t *testing.T) {
	t.Run("form=r32_eax", func(t *testing.T) {
		if _, err := XCHGL(reg.R10L, reg.EAX); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=eax_r32", func(t *testing.T) {
		if _, err := XCHGL(reg.EAX, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := XCHGL(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := XCHGL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_m32", func(t *testing.T) {
		if _, err := XCHGL(reg.R10L, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestXCHGQValidForms(t *testing.T) {
	t.Run("form=r64_rax", func(t *testing.T) {
		if _, err := XCHGQ(reg.R11, reg.RAX); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=rax_r64", func(t *testing.T) {
		if _, err := XCHGQ(reg.RAX, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := XCHGQ(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := XCHGQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_m64", func(t *testing.T) {
		if _, err := XCHGQ(reg.R11, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestXCHGWValidForms(t *testing.T) {
	t.Run("form=r16_ax", func(t *testing.T) {
		if _, err := XCHGW(reg.CX, reg.AX); err != nil {
			t.Fatal(err)
		}
		if _, err := XCHGW(reg.R9W, reg.AX); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=ax_r16", func(t *testing.T) {
		if _, err := XCHGW(reg.AX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := XCHGW(reg.AX, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := XCHGW(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := XCHGW(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := XCHGW(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := XCHGW(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r16", func(t *testing.T) {
		if _, err := XCHGW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := XCHGW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_m16", func(t *testing.T) {
		if _, err := XCHGW(reg.CX, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
		if _, err := XCHGW(reg.R9W, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestXGETBVValidForms(t *testing.T) {
	t.Run("form=", func(t *testing.T) {
		if _, err := XGETBV(); err != nil {
			t.Fatal(err)
		}
	})
}

func TestXLATValidForms(t *testing.T) {
	t.Run("form=", func(t *testing.T) {
		if _, err := XLAT(); err != nil {
			t.Fatal(err)
		}
	})
}

func TestXORBValidForms(t *testing.T) {
	t.Run("form=imm8_al", func(t *testing.T) {
		if _, err := XORB(operand.Imm(math.MaxInt8), reg.AL); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r8", func(t *testing.T) {
		if _, err := XORB(operand.Imm(math.MaxInt8), reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := XORB(operand.Imm(math.MaxInt8), reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := XORB(operand.Imm(math.MaxInt8), reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r8_r8", func(t *testing.T) {
		if _, err := XORB(reg.CH, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := XORB(reg.CH, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := XORB(reg.CH, reg.R13B); err != nil {
			t.Fatal(err)
		}
		if _, err := XORB(reg.BL, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := XORB(reg.BL, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := XORB(reg.BL, reg.R13B); err != nil {
			t.Fatal(err)
		}
		if _, err := XORB(reg.R13B, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := XORB(reg.R13B, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := XORB(reg.R13B, reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m8_r8", func(t *testing.T) {
		if _, err := XORB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.CH); err != nil {
			t.Fatal(err)
		}
		if _, err := XORB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.BL); err != nil {
			t.Fatal(err)
		}
		if _, err := XORB(operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}, reg.R13B); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m8", func(t *testing.T) {
		if _, err := XORB(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r8_m8", func(t *testing.T) {
		if _, err := XORB(reg.CH, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
		if _, err := XORB(reg.BL, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
		if _, err := XORB(reg.R13B, operand.Mem{Base: reg.BL, Index: reg.CH, Scale: 1}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestXORLValidForms(t *testing.T) {
	t.Run("form=imm32_eax", func(t *testing.T) {
		if _, err := XORL(operand.Imm(math.MaxInt32), reg.EAX); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r32", func(t *testing.T) {
		if _, err := XORL(operand.Imm(math.MaxInt8), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_r32", func(t *testing.T) {
		if _, err := XORL(operand.Imm(math.MaxInt32), reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_r32", func(t *testing.T) {
		if _, err := XORL(reg.R10L, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m32_r32", func(t *testing.T) {
		if _, err := XORL(operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}, reg.R10L); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m32", func(t *testing.T) {
		if _, err := XORL(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_m32", func(t *testing.T) {
		if _, err := XORL(operand.Imm(math.MaxInt32), operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r32_m32", func(t *testing.T) {
		if _, err := XORL(reg.R10L, operand.Mem{Base: reg.EBX, Index: reg.ECX, Scale: 4}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestXORPDValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := XORPD(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := XORPD(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestXORPSValidForms(t *testing.T) {
	t.Run("form=xmm_xmm", func(t *testing.T) {
		if _, err := XORPS(reg.X7, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m128_xmm", func(t *testing.T) {
		if _, err := XORPS(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.X7); err != nil {
			t.Fatal(err)
		}
	})
}

func TestXORQValidForms(t *testing.T) {
	t.Run("form=imm32_rax", func(t *testing.T) {
		if _, err := XORQ(operand.Imm(math.MaxInt32), reg.RAX); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r64", func(t *testing.T) {
		if _, err := XORQ(operand.Imm(math.MaxInt8), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_r64", func(t *testing.T) {
		if _, err := XORQ(operand.Imm(math.MaxInt32), reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_r64", func(t *testing.T) {
		if _, err := XORQ(reg.R11, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m64_r64", func(t *testing.T) {
		if _, err := XORQ(operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}, reg.R11); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m64", func(t *testing.T) {
		if _, err := XORQ(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm32_m64", func(t *testing.T) {
		if _, err := XORQ(operand.Imm(math.MaxInt32), operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r64_m64", func(t *testing.T) {
		if _, err := XORQ(reg.R11, operand.Mem{Base: reg.RBX, Index: reg.RCX, Scale: 8}); err != nil {
			t.Fatal(err)
		}
	})
}

func TestXORWValidForms(t *testing.T) {
	t.Run("form=imm16_ax", func(t *testing.T) {
		if _, err := XORW(operand.Imm(math.MaxInt16), reg.AX); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_r16", func(t *testing.T) {
		if _, err := XORW(operand.Imm(math.MaxInt8), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := XORW(operand.Imm(math.MaxInt8), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm16_r16", func(t *testing.T) {
		if _, err := XORW(operand.Imm(math.MaxInt16), reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := XORW(operand.Imm(math.MaxInt16), reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_r16", func(t *testing.T) {
		if _, err := XORW(reg.CX, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := XORW(reg.CX, reg.R9W); err != nil {
			t.Fatal(err)
		}
		if _, err := XORW(reg.R9W, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := XORW(reg.R9W, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=m16_r16", func(t *testing.T) {
		if _, err := XORW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.CX); err != nil {
			t.Fatal(err)
		}
		if _, err := XORW(operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}, reg.R9W); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm8_m16", func(t *testing.T) {
		if _, err := XORW(operand.Imm(math.MaxInt8), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=imm16_m16", func(t *testing.T) {
		if _, err := XORW(operand.Imm(math.MaxInt16), operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
	t.Run("form=r16_m16", func(t *testing.T) {
		if _, err := XORW(reg.CX, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
		if _, err := XORW(reg.R9W, operand.Mem{Base: reg.BX, Index: reg.CX, Scale: 2}); err != nil {
			t.Fatal(err)
		}
	})
}
