/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * The count limit on rows or columns in the pivot group.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PivotGroupLimit extends com.google.api.client.json.GenericJson {

  /**
   * The order in which the group limit is applied to the pivot table. Pivot group limits are
   * applied from lower to higher order number. Order numbers are normalized to consecutive integers
   * from 0. For write request, to fully customize the applying orders, all pivot group limits
   * should have this field set with an unique number. Otherwise, the order is determined by the
   * index in the PivotTable.rows list and then the PivotTable.columns list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer applyOrder;

  /**
   * The count limit.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer countLimit;

  /**
   * The order in which the group limit is applied to the pivot table. Pivot group limits are
   * applied from lower to higher order number. Order numbers are normalized to consecutive integers
   * from 0. For write request, to fully customize the applying orders, all pivot group limits
   * should have this field set with an unique number. Otherwise, the order is determined by the
   * index in the PivotTable.rows list and then the PivotTable.columns list.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getApplyOrder() {
    return applyOrder;
  }

  /**
   * The order in which the group limit is applied to the pivot table. Pivot group limits are
   * applied from lower to higher order number. Order numbers are normalized to consecutive integers
   * from 0. For write request, to fully customize the applying orders, all pivot group limits
   * should have this field set with an unique number. Otherwise, the order is determined by the
   * index in the PivotTable.rows list and then the PivotTable.columns list.
   * @param applyOrder applyOrder or {@code null} for none
   */
  public PivotGroupLimit setApplyOrder(java.lang.Integer applyOrder) {
    this.applyOrder = applyOrder;
    return this;
  }

  /**
   * The count limit.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getCountLimit() {
    return countLimit;
  }

  /**
   * The count limit.
   * @param countLimit countLimit or {@code null} for none
   */
  public PivotGroupLimit setCountLimit(java.lang.Integer countLimit) {
    this.countLimit = countLimit;
    return this;
  }

  @Override
  public PivotGroupLimit set(String fieldName, Object value) {
    return (PivotGroupLimit) super.set(fieldName, value);
  }

  @Override
  public PivotGroupLimit clone() {
    return (PivotGroupLimit) super.clone();
  }

}
