/*
 * Copyright 2015 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.model.internal.manage.schema.extract

import org.gradle.model.ModelMap
import org.gradle.model.internal.manage.schema.SpecializedMapSchema
import org.gradle.model.internal.type.ModelType
import spock.lang.Specification

class SpecializedModelMapStrategyTest extends Specification {
    def store = new DefaultModelSchemaStore(DefaultModelSchemaExtractor.withDefaultStrategies())

    def "assembles schema for model map subtype"() {
        expect:
        def schema = store.getSchema(ModelType.of(SpecializedMap))
        schema instanceof SpecializedMapSchema
        schema.elementType == ModelType.of(String)
        schema.elementTypeSchema == store.getSchema(ModelType.of(String))
        SpecializedMap.isAssignableFrom schema.implementationType
    }

    interface SpecializedMap extends ModelMap<String> {
    }
}
