#ifndef _BIGCHUMPPOWER_H_
#define _BIGCHUMPPOWER_H_
// bigchumppower_table generated by DK/circ_table_gen.py -- do not modify manually

 // variables used
 // --sig_max  5.000000
 // --table_div  9.127496
 // --table_op  0.002000

struct tablebigchumppower { // 1-dimensional function table
    float low;
    float high;
    float istep;
    int size;
    float data[];
};

template <int tab_size>
struct tablebigchumppower_imp {
    float low;
    float high;
    float istep;
    int size;
    float data[tab_size];
    operator tablebigchumppower&() const { return *(tablebigchumppower*)this; }
};

 static tablebigchumppower_imp<2048> bigchumppower_table __rt_data = {
	0,0.833333,0.8188,2048, {
	0.000000000000,0.026881587742,0.053355325982,0.079413890819,0.105051321689,
	0.130262957880,0.155045369615,0.179396285807,0.203314519063,0.226799889648,
	0.249853148839,0.272475903055,0.294670539313,0.316440152520,0.337788475315,
	0.358719810868,0.379238968676,0.399351204077,0.419062161116,0.438377819111,
	0.457304443057,0.475848537447,0.494016803843,0.511816101816,0.529253413418,
	0.546335810610,0.563070425985,0.579464426190,0.595524988196,0.611259277996,
	0.626674431709,0.641777538855,0.656575627688,0.671075652297,0.685284481459,
	0.699208889090,0.712855546048,0.726231013223,0.739341735763,0.752194038507,
	0.764794122128,0.777148060265,0.789261797460,0.801141147524,0.812791792878,
	0.824219284017,0.835429039778,0.846426347756,0.857216365278,0.867804120586,
	0.878194514222,0.888392320834,0.898402191032,0.908228653327,0.917876116427,
	0.927348871607,0.936651094875,0.945786849581,0.954760088911,0.963574658379,
	0.972234298441,0.980742647044,0.989103242174,0.997319524506,1.005394839894,
	1.013332441944,1.021135494433,1.028807073880,1.036350171908,1.043767697688,
	1.051062480227,1.058237270665,1.065294744597,1.072237504210,1.079068080405,
	1.085788934975,1.092402462588,1.098910992807,1.105316792010,1.111622065272,
	1.117828958220,1.123939558796,1.129955899044,1.135879956661,1.141713656775,
	1.147458873461,1.153117431256,1.158691106698,1.164181629727,1.169590685149,
	1.174919913910,1.180170914427,1.185345243935,1.190444419638,1.195469919911,
	1.200423185537,1.205305620715,1.210118594196,1.214863440367,1.219541460199,
	1.224153922250,1.228702063673,1.233187091055,1.237610181343,1.241972482735,
	1.246275115492,1.250519172676,1.254705721097,1.258835801897,1.262910431377,
	1.266930601709,1.270897281620,1.274811416947,1.278673931456,1.282485727402,
	1.286247686014,1.289960668274,1.293625515314,1.297243049098,1.300814072862,
	1.304339371636,1.307819712818,1.311255846567,1.314648506315,1.317998409195,
	1.321306256529,1.324572734194,1.327798513072,1.330984249435,1.334130585337,
	1.337238149004,1.340307555140,1.343339405374,1.346334288490,1.349292780904,
	1.352215446829,1.355102838683,1.357955497392,1.360773952618,1.363558723131,
	1.366310317002,1.369029231973,1.371715955570,1.374370965546,1.376994729946,
	1.379587707432,1.382150347585,1.384683090932,1.387186369398,1.389660606319,
	1.392106216784,1.394523607795,1.396913178415,1.399275320031,1.401610416457,
	1.403918844218,1.406200972636,1.408457164008,1.410687773825,1.412893150896,
	1.415073637460,1.417229569441,1.419361276513,1.421469082230,1.423553304274,
	1.425614254462,1.427652238938,1.429667558334,1.431660507817,1.433631377252,
	1.435580451384,1.437508009793,1.439414327193,1.441299673380,1.443164313450,
	1.445008507842,1.446832512490,1.448636578845,1.450420954066,1.452185881005,
	1.453931598417,1.455658340930,1.457366339251,1.459057187640,1.460728328604,
	1.462381395920,1.464016604206,1.465634167163,1.467234291142,1.468817181994,
	1.470383042039,1.471932069180,1.473464458184,1.474980400971,1.476480087059,
	1.477963702307,1.479431428726,1.480883447343,1.482319933803,1.483741063865,
	1.485147008505,1.486537937125,1.487914015267,1.489275406862,1.490622272979,
	1.491954772614,1.493273061094,1.494577293179,1.495867620019,1.497144190079,
	1.498407150916,1.499656647776,1.500892822072,1.502115814885,1.503325764441,
	1.504522807413,1.505707077061,1.506878706553,1.508037825443,1.509184562480,
	1.510319044928,1.511441397057,1.512551740732,1.513650199298,1.514736890031,
	1.515811932197,1.516875440951,1.517927530719,1.518968315014,1.519997904560,
	1.521016409212,1.522023937015,1.523020594522,1.524006486817,1.524981718018,
	1.525946390328,1.526900604025,1.527844458959,1.528778053449,1.529701484330,
	1.530614847000,1.531518235572,1.532411743346,1.533295461997,1.534169481885,
	1.535033892301,1.535888781341,1.536734236260,1.537570342622,1.538397185234,
	1.539214847867,1.540023412873,1.540822961806,1.541613574970,1.542395331909,
	1.543168311055,1.543932589617,1.544688243950,1.545435349566,1.546173980903,
	1.546904211631,1.547626114472,1.548339760927,1.549045221634,1.549742567170,
	1.550431865910,1.551113186575,1.551786596310,1.552452161859,1.553109949083,
	1.553760022415,1.554402446728,1.555037285202,1.555664600220,1.556284454010,
	1.556896907576,1.557502021445,1.558099855324,1.558690468095,1.559273918286,
	1.559850263466,1.560419560583,1.560981865883,1.561537235182,1.562085723333,
	1.562627384615,1.563162273155,1.563690441681,1.564211943092,1.564726828955,
	1.565235150882,1.565736959422,1.566232304825,1.566721236972,1.567203804577,
	1.567680056341,1.568150040270,1.568613803804,1.569071393739,1.569522856631,
	1.569968238291,1.570407584228,1.570840939336,1.571268347849,1.571689853972,
	1.572105500997,1.572515331994,1.572919389538,1.573317715542,1.573710351842,
	1.574097339476,1.574478719278,1.574854531488,1.575224816167,1.575589612698,
	1.575948960200,1.576302897271,1.576651462162,1.576994692812,1.577332626664,
	1.577665300832,1.577992751999,1.578315016543,1.578632130366,1.578944129136,
	1.579251048055,1.579552921992,1.579849785579,1.580141672867,1.580428617792,
	1.580710653829,1.580987814202,1.581260131724,1.581527638912,1.581790368051,
	1.582048350910,1.582301619172,1.582550204056,1.582794136538,1.583033447301,
	1.583268166678,1.583498324815,1.583723951450,1.583945076143,1.584161728061,
	1.584373936181,1.584581729211,1.584785135503,1.584984183227,1.585178900248,
	1.585369314197,1.585555452392,1.585737341993,1.585915009806,1.586088482429,
	1.586257786289,1.586422947400,1.586583991756,1.586740944904,1.586893832306,
	1.587042679143,1.587187510350,1.587328350670,1.587465224592,1.587598156433,
	1.587727170214,1.587852289880,1.587973539010,1.588090941055,1.588204519225,
	1.588314296591,1.588420296007,1.588522540027,1.588621051083,1.588715851510,
	1.588806963224,1.588894408204,1.588978208009,1.589058384196,1.589134958052,
	1.589207950694,1.589277383047,1.589343275863,1.589405649746,1.589464525140,
	1.589519922251,1.589571861211,1.589620361870,1.589665443996,1.589707127173,
	1.589745430770,1.589780374192,1.589811976398,1.589840256385,1.589865233008,
	1.589886924787,1.589905350334,1.589920527918,1.589932475752,1.589941211924,
	1.589946754283,1.589949120649,1.589948328615,1.589944395651,1.589937339132,
	1.589927176315,1.589913924154,1.589897599750,1.589878219774,1.589855800964,
	1.589830359933,1.589801913015,1.589770476537,1.589736066696,1.589698699532,
	1.589658391038,1.589615156945,1.589569012967,1.589519974690,1.589468057561,
	1.589413276956,1.589355648060,1.589295185969,1.589231905744,1.589165822284,
	1.589096950284,1.589025304530,1.588950899520,1.588873749740,1.588793869567,
	1.588711273220,1.588625974856,1.588537988534,1.588447328241,1.588354007751,
	1.588258040886,1.588159441240,1.588058222417,1.587954397860,1.587847980964,
	1.587738984969,1.587627423099,1.587513308413,1.587396653899,1.587277472535,
	1.587155777069,1.587031580285,1.586904894789,1.586775733219,1.586644107959,
	1.586510031466,1.586373516029,1.586234573883,1.586093217195,1.585949457938,
	1.585803308212,1.585654779884,1.585503884738,1.585350634567,1.585195041044,
	1.585037115752,1.584876870213,1.584714315892,1.584549464120,1.584382326266,
	1.584212913472,1.584041236966,1.583867307794,1.583691136965,1.583512735483,
	1.583332114130,1.583149283769,1.582964255167,1.582777038941,1.582587645716,
	1.582396086067,1.582202370398,1.582006509206,1.581808512780,1.581608391389,
	1.581406155326,1.581201814705,1.580995379614,1.580786860101,1.580576266148,
	1.580363607695,1.580148894593,1.579932136622,1.579713343539,1.579492525027,
	1.579269690700,1.579044850158,1.578818012887,1.578589188386,1.578358386010,
	1.578125615137,1.577890885107,1.577654205095,1.577415584318,1.577175031964,
	1.576932557069,1.576688168642,1.576441875747,1.576193687298,1.575943612119,
	1.575691659092,1.575437837028,1.575182154617,1.574924620621,1.574665243596,
	1.574404032210,1.574140994958,1.573876140394,1.573609476930,1.573341013004,
	1.573070756973,1.572798717149,1.572524901848,1.572249319240,1.571971977580,
	1.571692884962,1.571412049520,1.571129479293,1.570845182345,1.570559166615,
	1.570271440047,1.569982010507,1.569690885921,1.569398074037,1.569103582650,
	1.568807419531,1.568509592332,1.568210108718,1.567908976312,1.567606202729,
	1.567301795465,1.566995762026,1.566688109917,1.566378846532,1.566067979267,
	1.565755515533,1.565441462563,1.565125827739,1.564808618256,1.564489841323,
	1.564169504156,1.563847613890,1.563524177648,1.563199202458,1.562872695457,
	1.562544663571,1.562215113811,1.561884053140,1.561551488478,1.561217426628,
	1.560881874538,1.560544838989,1.560206326787,1.559866344611,1.559524899289,
	1.559181997452,1.558837645791,1.558491850905,1.558144619430,1.557795957940,
	1.557445872954,1.557094370996,1.556741458596,1.556387142144,1.556031428109,
	1.555674322858,1.555315832826,1.554955964311,1.554594723640,1.554232117075,
	1.553868150904,1.553502831369,1.553136164676,1.552768156999,1.552398814493,
	1.552028143283,1.551656149478,1.551282839186,1.550908218422,1.550532293219,
	1.550155069612,1.549776553488,1.549396750900,1.549015667720,1.548633309870,
	1.548249683181,1.547864793606,1.547478646889,1.547091248873,1.546702605339,
	1.546312722046,1.545921604696,1.545529259064,1.545135690804,1.544740905580,
	1.544344909045,1.543947706835,1.543549304533,1.543149707725,1.542748921974,
	1.542346952810,1.541943805749,1.541539486297,1.541133999888,1.540727351977,
	1.540319548004,1.539910593384,1.539500493575,1.539089253808,1.538676879492,
	1.538263375944,1.537848748497,1.537433002471,1.537016143007,1.536598175450,
	1.536179105004,1.535758936886,1.535337676238,1.534915328316,1.534491898172,
	1.534067390995,1.533641811903,1.533215165995,1.532787458274,1.532358693832,
	1.531928877783,1.531498015038,1.531066110677,1.530633169637,1.530199196929,
	1.529764197422,1.529328176140,1.528891137947,1.528453087766,1.528014030373,
	1.527573970805,1.527132913784,1.526690864173,1.526247826766,1.525803806336,
	1.525358807713,1.524912835648,1.524465894859,1.524017990117,1.523569126068,
	1.523119307477,1.522668538919,1.522216825189,1.521764170884,1.521310580588,
	1.520856058943,1.520400610590,1.519944240039,1.519486951937,1.519028750794,
	1.518569641187,1.518109627600,1.517648714546,1.517186906468,1.516724207933,
	1.516260623404,1.515796157303,1.515330814033,1.514864598025,1.514397513709,
	1.513929565469,1.513460757667,1.512991094691,1.512520580857,1.512049220553,
	1.511577017991,1.511103977647,1.510630103643,1.510155400266,1.509679871915,
	1.509203522798,1.508726357074,1.508248379066,1.507769592791,1.507290002700,
	1.506809612815,1.506328427375,1.505846450538,1.505363686391,1.504880139008,
	1.504395812685,1.503910711401,1.503424839293,1.502938200419,1.502450798839,
	1.501962638638,1.501473723794,1.500984058386,1.500493646418,1.500002491944,
	1.499510598866,1.499017971176,1.498524612884,1.498030527956,1.497535720247,
	1.497040193741,1.496543952340,1.496046999998,1.495549340551,1.495050977866,
	1.494551915871,1.494052158397,1.493551709267,1.493050572337,1.492548751442,
	1.492046250315,1.491543072897,1.491039222785,1.490534703969,1.490029520029,
	1.489523674842,1.489017172028,1.488510015421,1.488002208714,1.487493755629,
	1.486984659793,1.486474924923,1.485964554705,1.485453552842,1.484941922904,
	1.484429668586,1.483916793463,1.483403301227,1.482889195475,1.482374479703,
	1.481859157603,1.481343232752,1.480826708655,1.480309588876,1.479791876946,
	1.479273576496,1.478754690945,1.478235223776,1.477715178597,1.477194558878,
	1.476673368027,1.476151609583,1.475629286984,1.475106403613,1.474582962973,
	1.474058968522,1.473534423628,1.473009331672,1.472483696126,1.471957520349,
	1.471430807702,1.470903561532,1.470375785279,1.469847482183,1.469318655664,
	1.468789308992,1.468259445557,1.467729068504,1.467198181346,1.466666787285,
	1.466134889513,1.465602491413,1.465069596119,1.464536207019,1.464002327232,
	1.463467960148,1.462933108764,1.462397776443,1.461861966367,1.461325681660,
	1.460788925652,1.460251701288,1.459714011874,1.459175860608,1.458637250438,
	1.458098184714,1.457558666505,1.457018698778,1.456478284788,1.455937427668,
	1.455396130326,1.454854395994,1.454312227626,1.453769628384,1.453226601287,
	1.452683149344,1.452139275546,1.451594983030,1.451050274704,1.450505153694,
	1.449959622839,1.449413685219,1.448867343746,1.448320601469,1.447773461314,
	1.447225926162,1.446677999126,1.446129682965,1.445580980664,1.445031895087,
	1.444482429235,1.443932585917,1.443382368074,1.442831778506,1.442280820228,
	1.441729495941,1.441177808611,1.440625760990,1.440073355970,1.439520596331,
	1.438967484954,1.438414024575,1.437860218000,1.437306068120,1.436751577547,
	1.436196749229,1.435641585840,1.435086090049,1.434530264783,1.433974112642,
	1.433417636374,1.432860838816,1.432303722583,1.431746290329,1.431188544839,
	1.430630488751,1.430072124793,1.429513455585,1.428954483770,1.428395212056,
	1.427835643091,1.427275779498,1.426715623786,1.426155178751,1.425594446931,
	1.425033430941,1.424472133357,1.423910556741,1.423348703728,1.422786576827,
	1.422224178623,1.421661511690,1.421098578610,1.420535381805,1.419971923842,
	1.419408207367,1.418844234692,1.418280008382,1.417715530994,1.417150805015,
	1.416585832863,1.416020617055,1.415455160046,1.414889464255,1.414323532195,
	1.413757366203,1.413190968790,1.412624342323,1.412057489286,1.411490411986,
	1.410923112929,1.410355594453,1.409787858964,1.409219908748,1.408651746202,
	1.408083373803,1.407514793835,1.406946008542,1.406377020340,1.405807831582,
	1.405238444550,1.404668861566,1.404099084869,1.403529116807,1.402958959689,
	1.402388615840,1.401818087373,1.401247376636,1.400676485906,1.400105417393,
	1.399534173406,1.398962756100,1.398391167675,1.397819410431,1.397247486551,
	1.396675398227,1.396103147614,1.395530736931,1.394958168402,1.394385444181,
	1.393812566270,1.393239537082,1.392666358588,1.392093032907,1.391519562295,
	1.390945948857,1.390372194656,1.389798301803,1.389224272374,1.388650108486,
	1.388075812379,1.387501385848,1.386926831143,1.386352150371,1.385777345358,
	1.385202418396,1.384627371411,1.384052206448,1.383476925558,1.382901530694,
	1.382326023922,1.381750407303,1.381174682743,1.380598852259,1.380022917815,
	1.379446881419,1.378870744985,1.378294510508,1.377718179931,1.377141755214,
	1.376565238317,1.375988631081,1.375411935513,1.374835153411,1.374258286855,
	1.373681337692,1.373104307745,1.372527198851,1.371950013081,1.371372752152,
	1.370795418004,1.370218012395,1.369640537303,1.369062994512,1.368485385871,
	1.367907713216,1.367329978274,1.366752182988,1.366174329082,1.365596418340,
	1.365018452670,1.364440433732,1.363862363361,1.363284243311,1.362706075399,
	1.362127861341,1.361549602828,1.360971301655,1.360392959624,1.359814578365,
	1.359236159669,1.358657705178,1.358079216768,1.357500695844,1.356922144302,
	1.356343563893,1.355764956129,1.355186322798,1.354607665489,1.354028985860,
	1.353450285704,1.352871566464,1.352292829904,1.351714077664,1.351135311325,
	1.350556532487,1.349977742836,1.349398943828,1.348820137295,1.348241324612,
	1.347662507529,1.347083687455,1.346504866054,1.345926044894,1.345347225595,
	1.344768409543,1.344189598414,1.343610793658,1.343031996937,1.342453209634,
	1.341874433399,1.341295669585,1.340716919815,1.340138185600,1.339559468276,
	1.338980769532,1.338402090667,1.337823433328,1.337244798859,1.336666188716,
	1.336087604353,1.335509047296,1.334930518953,1.334352020701,1.333773553979,
	1.333195120200,1.332616720915,1.332038357374,1.331460030967,1.330881743213,
	1.330303495418,1.329725288958,1.329147125252,1.328569005623,1.327990931501,
	1.327412904140,1.326834924888,1.326256995266,1.325679116451,1.325101289813,
	1.324523516608,1.323945798268,1.323368136089,1.322790531363,1.322212985387,
	1.321635499342,1.321058074708,1.320480712589,1.319903414414,1.319326181378,
	1.318749014771,1.318171915719,1.317594885697,1.317017925788,1.316441037292,
	1.315864221434,1.315287479443,1.314710812450,1.314134221817,1.313557708691,
	1.312981274271,1.312404919716,1.311828646275,1.311252455128,1.310676347409,
	1.310100324314,1.309524387055,1.308948536751,1.308372774537,1.307797101577,
	1.307221519067,1.306646028066,1.306070629735,1.305495325302,1.304920115622,
	1.304345002152,1.303769985677,1.303195067542,1.302620248738,1.302045530331,
	1.301470913566,1.300896399308,1.300321988814,1.299747683037,1.299173483050,
	1.298599390004,1.298025404824,1.297451528646,1.296877762488,1.296304107390,
	1.295730564286,1.295157134356,1.294583818592,1.294010617949,1.293437533378,
	1.292864566069,1.292291716859,1.291718986779,1.291146376900,1.290573888041,
	1.290001521329,1.289429277628,1.288857158004,1.288285163289,1.287713294567,
	1.287141552738,1.286569938711,1.285998453460,1.285427097923,1.284855872984,
	1.284284779603,1.283713818745,1.283142991220,1.282572298023,1.282001739984,
	1.281431318036,1.280861033065,1.280290886018,1.279720877670,1.279151008939,
	1.278581280763,1.278011693858,1.277442249257,1.276872947734,1.276303790122,
	1.275734777301,1.275165910053,1.274597189303,1.274028615862,1.273460190551,
	1.272891914122,1.272323787482,1.271755811394,1.271187986684,1.270620314134,
	1.270052794548,1.269485428786,1.268918217437,1.268351161546,1.267784261722,
	1.267217518825,1.266650933519,1.266084506653,1.265518238994,1.264952131190,
	1.264386184161,1.263820398467,1.263254774990,1.262689314375,1.262124017425,
	1.261558884783,1.260993917257,1.260429115546,1.259864480285,1.259300012262,
	1.258735712190,1.258171580673,1.257607618456,1.257043826310,1.256480204819,
	1.255916754697,1.255353476610,1.254790371226,1.254227439327,1.253664681310,
	1.253102098121,1.252539690249,1.251977458406,1.251415403197,1.250853525232,
	1.250291825263,1.249730303895,1.249168961635,1.248607799242,1.248046817292,
	1.247486016370,1.246925397113,1.246364960137,1.245804706059,1.245244635455,
	1.244684748902,1.244125046999,1.243565530369,1.243006199565,1.242447055167,
	1.241888097740,1.241329327909,1.240770746144,1.240212353059,1.239654149231,
	1.239096135204,1.238538311477,1.237980678693,1.237423237307,1.236865987963,
	1.236308931036,1.235752067154,1.235195396852,1.234638920657,1.234082639044,
	1.233526552554,1.232970661643,1.232414966939,1.231859468831,1.231304167886,
	1.230749064518,1.230194159324,1.229639452777,1.229084945287,1.228530637370,
	1.227976529553,1.227422622242,1.226868915921,1.226315411073,1.225762108214,
	1.225209007702,1.224656110000,1.224103415592,1.223550924974,1.222998638547,
	1.222446556703,1.221894679973,1.221343008734,1.220791543413,1.220240284468,
	1.219689232318,1.219138387303,1.218587749961,1.218037320662,1.217487099807,
	1.216937087817,1.216387285029,1.215837691906,1.215288308873,1.214739136226,
	1.214190174401,1.213641423867,1.213092884879,1.212544557923,1.211996443260,
	1.211448541330,1.210900852542,1.210353377200,1.209806115681,1.209259068348,
	1.208712235626,1.208165617722,1.207619215102,1.207073028089,1.206527057039,
	1.205981302235,1.205435764075,1.204890442877,1.204345338937,1.203800452651,
	1.203255784332,1.202711334253,1.202167102748,1.201623090159,1.201079296823,
	1.200535722998,1.199992368992,1.199449235127,1.198906321764,1.198363629160,
	1.197821157524,1.197278907265,1.196736878588,1.196195071917,1.195653487381,
	1.195112125313,1.194570986056,1.194030069784,1.193489376922,1.192948907552,
	1.192408662077,1.191868640686,1.191328843669,1.190789271330,1.190249923862,
	1.189710801555,1.189171904648,1.188633233396,1.188094788012,1.187556568810,
	1.187018575932,1.186480809753,1.185943270418,1.185405958138,1.184868873192,
	1.184332015799,1.183795386210,1.183258984602,1.182722811185,1.182186866213,
	1.181651149889,1.181115662468,1.180580404096,1.180045375024,1.179510575415,
	1.178976005495,1.178441665505,1.177907555615,1.177373675984,1.176840026841,
	1.176306608398,1.175773420792,1.175240464227,1.174707738922,1.174175245023,
	1.173642982753,1.173110952176,1.172579153599,1.172047587142,1.171516252974,
	1.170985151243,1.170454282124,1.169923645840,1.169393242498,1.168863072255,
	1.168333135266,1.167803431729,1.167273961721,1.166744725468,1.166215723048,
	1.165686954702,1.165158420517,1.164630120635,1.164102055154,1.163574224273,
	1.163046628139,1.162519266826,1.161992140522,1.161465249316,1.160938593346,
	1.160412172744,1.159885987664,1.159360038152,1.158834324416,1.158308846515,
	1.157783604545,1.157258598689,1.156733829027,1.156209295657,1.155684998684,
	1.155160938239,1.154637114426,1.154113527310,1.153590177025,1.153067063675,
	1.152544187277,1.152021548041,1.151499146049,1.150976981299,1.150455053933,
	1.149933364077,1.149411911739,1.148890697091,1.148369720134,1.147848980995,
	1.147328479735,1.146808216424,1.146288191157,1.145768404021,1.145248855053,
	1.144729544319,1.144210471924,1.143691637944,1.143173042378,1.142654685344,
	1.142136566888,1.141618687047,1.141101045976,1.140583643600,1.140066480028,
	1.139549555352,1.139032869553,1.138516422781,1.138000214975,1.137484246264,
	1.136968516652,1.136453026185,1.135937774928,1.135422762923,1.134907990167,
	1.134393456761,1.133879162714,1.133365108030,1.132851292777,1.132337716976,
	1.131824380681,1.131311283899,1.130798426659,1.130285809025,1.129773430949,
	1.129261292510,1.128749393686,1.128237734605,1.127726315132,1.127215135432,
	1.126704195443,1.126193495135,1.125683034644,1.125172813891,1.124662832928,
	1.124153091788,1.123643590400,1.123134328832,1.122625307070,1.122116525182,
	1.121607983075,1.121099680794,1.120591618350,1.120083795741,1.119576212961,
	1.119068869980,1.118561766852,1.118054903537,1.117548280045,1.117041896361,
	1.116535752463,1.116029848353,1.115524184042,1.115018759510,1.114513574696,
	1.114008629635,1.113503924339,1.112999458737,1.112495232805,1.111991246570,
	1.111487499962,1.110983993027,1.110480725711,1.109977698019,1.109474909839,
	1.108972361217,1.108470052132,1.107967982533,1.107466152377,1.106964561672,
	1.106463210395,1.105962098483,1.105461225922,1.104960592622,1.104460198648,
	1.103960043904,1.103460128363,1.102960452017,1.102461014769,1.101961816652,
	1.101462857548,1.100964137497,1.100465656402,1.099967414242,1.099469410963,
	1.098971646520,1.098474120883,1.097976833996,1.097479785804,1.096982976274,
	1.096486405367,1.095990072991,1.095493979127,1.094998123760,1.094502506759,
	1.094007128112,1.093511987794,1.093017085691,1.092522421772,1.092027996001,
	1.091533808280,1.091039858581,1.090546146861,1.090052673034,1.089559437054,
	1.089066438835,1.088573678308,1.088081155468,1.087588870227,1.087096822471,
	1.086605012186,1.086113439314,1.085622103774,1.085131005477,1.084640144374,
	1.084149520410,1.083659133490,1.083168983547,1.082679070554,1.082189394392,
	1.081699954993,1.081210752293,1.080721786222,1.080233056686,1.079744563645,
	1.079256306999,1.078768286710,1.078280502625,1.077792954753,1.077305642933,
	1.076818567162,1.076331727336,1.075845123337,1.075358755099,1.074872622605,
	1.074386725701,1.073901064328,1.073415638407,1.072930447851,1.072445492592,
	1.071960772477,1.071476287542,1.070992037626,1.070508022591,1.070024242462,
	1.069540697072,1.069057386392,1.068574310268,1.068091468655,1.067608861456,
	1.067126488594,1.066644349938,1.066162445436,1.065680774981,1.065199338461,
	1.064718135826,1.064237166975,1.063756431790,1.063275930165,1.062795662051,
	1.062315627337,1.061835825895,1.061356257690,1.060876922561,1.060397820422,
	1.059918951240,1.059440314848,1.058961911165,1.058483740115,1.058005801583,
	1.057528095479,1.057050621679,1.056573380083,1.056096370631,1.055619593172,
	1.055143047664,1.054666733934,1.054190651915,1.053714801507,1.053239182605,
	1.052763795109,1.052288638920,1.051813713903,1.051339019995,1.050864557063,
	1.050390324976,1.049916323705,1.049442553055,1.048969012989,1.048495703383,
	1.048022624096,1.047549775077,1.047077156166,1.046604767291,1.046132608297,
	1.045660679128,1.045188979638,1.044717509739,1.044246269332,1.043775258282,
	1.043304476471,1.042833923826,1.042363600181,1.041893505473,1.041423639564,
	1.040954002367,1.040484593739,1.040015413574,1.039546461796,1.039077738249,
	1.038609242847,1.038140975439,1.037672935966,1.037205124251,1.036737540230,
	1.036270183764,1.035803054731,1.035336153050,1.034869478572,1.034403031177,
	1.033936810815,1.033470817287,1.033005050497,1.032539510358,1.032074196727,
	1.031609109505,1.031144248553,1.030679613771,1.030215205035,1.029751022248,
	1.029287065238,1.028823333938,1.028359828207,1.027896547938,1.027433492983,
	1.026970663251,1.026508058635,1.026045678978,1.025583524173,1.025121594135,
	1.024659888708,1.024198407743,1.023737151166,1.023276118841,1.022815310673,
	1.022354726495,1.021894366222,1.021434229722,1.020974316856,1.020514627514,
	1.020055161598,1.019595918951,1.019136899460,1.018678103011,1.018219529481,
	1.017761178750,1.017303050666,1.016845145152,1.016387462050,1.015930001250,
	1.015472762649,1.015015746077,1.014558951420,1.014102378616,1.013646027466,
	1.013189897868,1.012733989718,1.012278302879,1.011822837240,1.011367592624,
	1.010912568986,1.010457766144,1.010003183993,1.009548822398,1.009094681242,
	1.008640760407,1.008187059758,1.007733579174,1.007280318514,1.006827277683,
	1.006374456518,1.005921854929,1.005469472778,1.005017309934,1.004565366274,
	1.004113641690,1.003662136009,1.003210849143,1.002759780971,1.002308931329,
	1.001858300135,1.001407887244,1.000957692505,1.000507715824,1.000057957073,
	0.999608416110,0.999159092813,0.998709987071,0.998261098728,0.997812427683,
	0.997363973795,0.996915736954,0.996467717015,0.996019913837,0.995572327351,
	0.995124957353,0.994677803781,0.994230866468,0.993784145313,0.993337640172,
	0.992891350932,0.992445277436,0.991999419595,0.991553777259,0.991108350287,
	0.990663138591,0.990218142017,0.989773360444,0.989328793733,0.988884441773,
	0.988440304447,0.987996381599,0.987552673106,0.987109178863,0.986665898725,
	0.986222832545,0.985779980242,0.985337341671,0.984894916676,0.984452705154,
	0.984010706987,0.983568922038,0.983127350156,0.982685991243,0.982244845163,
	0.981803911810,0.981363191007,0.980922682682,0.980482386665,0.980042302839,
	0.979602431066,0.979162771247,0.978723323244,0.978284086928,0.977845062170,
	0.977406248848,0.976967646814,0.976529255967,0.976091076152,0.975653107286,
	0.975215349192,0.974777801768,0.974340464885,0.973903338427,0.973466422237,
	0.973029716219,0.972593220210,0.972156934127,0.971720857804,0.971284991143,
	0.970849333989,0.970413886262,0.969978647761,0.969543618421,0.969108798099,
	0.968674186667,0.968239783996,0.967805589947,0.967371604396,0.966937827265,
	0.966504258351,0.966070897582,0.965637744824,0.965204799921,0.964772062781,
	0.964339533243,0.963907211222,0.963475096559,0.963043189137,0.962611488846,
	0.962179995533,0.961748709083,0.961317629367,0.960886756282,0.960456089669,
	0.960025629421,0.959595375416,0.959165327489,0.958735485579,0.958305849519,
	0.957876419192,0.957447194470,0.957018175222,0.956589361363,0.956160752690,
	0.955732349143,0.955304150568,0.954876156846,0.954448367850,0.954020783485,
	0.953593403578,0.953166228029,0.952739256707,0.952312489510,0.951885926290,
	0.951459566887,0.951033411267,0.950607459235,0.950181710677,0.949756165480,
	0.949330823529,0.948905684668,0.948480748819,0.948056015815,0.947631485566,
	0.947207157922,0.946783032761,0.946359109951,0.945935389415,0.945511871009,
	0.945088554584,0.944665440016,0.944242527218,0.943819816033,0.943397306363,
	0.942974998064,0.942552891016,0.942130985111,0.941709280223,0.941287776216,
	0.940866472985,0.940445370387,0.940024468323,0.939603766646,0.939183265251,
	0.938762964008,0.938342862800,0.937922961501,0.937503259998,0.937083758153,
	0.936664455855,0.936245352975,0.935826449398,0.935407745002,0.934989239659,
	0.934570933259,0.934152825685,0.933734916798,0.933317206491,0.932899694628,
	0.932482381090,0.932065265791,0.931648348552,0.931231629311,0.930815107902,
	0.930398784227,0.929982658152,0.929566729571,0.929150998363,0.928735464416,
	0.928320127590,0.927904987754,0.927490044822,0.927075298654,0.926660749161,
	0.926246396178,0.925832239605,0.925418279347,0.925004515230,0.924590947181,
	0.924177575069,0.923764398772,0.923351418169,0.922938633148,0.922526043581,
	0.922113649362,0.921701450369,0.921289446486,0.920877637586,0.920466023562,
	0.920054604267,0.919643379623,0.919232349501,0.918821513769,0.918410872329,
	0.918000425041,0.917590171792,0.917180112485,0.916770247003,0.916360575187,
	0.915951096968,0.915541812203,0.915132720784,0.914723822594,0.914315117516,
	0.913906605425,0.913498286225,0.913090159780,0.912682225986,0.912274484724,
	0.911866935880,0.911459579339,0.911052414960,0.910645442669,0.910238662338,
	0.909832073819,0.909425677040,0.909019471858,0.908613458178,0.908207635864,
	0.907802004821,0.907396564915,0.906991316055,0.906586258114,0.906181390973,
	0.905776714532,0.905372228652,0.904967933235,0.904563828174,0.904159913337,
	0.903756188633,0.903352653925,0.902949309127,0.902546154103,0.902143188736,
	0.901740412930,0.901337826564,0.900935429526,0.900533221704,0.900131202982,
	0.899729373248,0.899327732392,0.898926280287,0.898525016856,0.898123941959,
	0.897723055473,0.897322357323,0.896921847375,0.896521525516,0.896121391657,
	0.895721445641,0.895321687377,0.894922116786,0.894522733727,0.894123538072,
	0.893724529730,0.893325708593,0.892927074571,0.892528627499,0.892130367322,
	0.891732293887,0.891334407104,0.890936706868,0.890539193066,0.890141865579,
	0.889744724290,0.889347769101,0.888950999916,0.888554416594,0.888158019056,
	0.887761807176,0.887365780847,0.886969939952,0.886574284395,0.886178814073,
	0.885783528849,0.885388428647,0.884993513349,0.884598782823,0.884204236993,
	0.883809875731,0.883415698933,0.883021706492,0.882627898303,0.882234274240,
	0.881840834234,0.881447578143,0.881054505892,0.880661617308,0.880268912376,
	0.879876390908,0.879484052832,0.879091898051,0.878699926432,0.878308137892,
	0.877916532306,0.877525109582,0.877133869609,0.876742812278,0.876351937485,
	0.875961245112,0.875570735069,0.875180407234,0.874790261551,0.874400297842,
	0.874010516051,0.873620916041,0.873231497721,0.872842261001,0.872453205747,
	0.872064331866,0.871675639276,0.871287127834,0.870898797477,0.870510648049,
	0.870122679481,0.869734891662,0.869347284481,0.868959857845,0.868572611635,
	0.868185545754,0.867798660103,0.867411954592,0.867025429087,0.866639083497,
	0.866252917710,0.865866931660,0.865481125186,0.865095498230,0.864710050670,
	0.864324782407,0.863939693333,0.863554783368,0.863170052371,0.862785500271,
	0.862401126942,0.862016932318,0.861632916266,0.861249078673,0.860865419476,
	0.860481938533,0.860098635764,0.859715511086,0.859332564357,0.858949795494,
	0.858567204404,0.858184790968,0.857802555106,0.857420496703,0.857038615658,
	0.856656911881,0.856275385257,0.855894035707,0.855512863076,0.855131867355,
	0.854751048359,0.854370406025,0.853989940240,0.853609650918,0.853229537959,
	0.852849601250,0.852469840711,0.852090256216,0.851710847677,0.851331615021,
	0.850952558108,0.850573676861,0.850194971165,0.849816440938,0.849438086049,
	0.849059906471,0.848681902028,0.848304072660,0.847926418258,0.847548938746,
	0.847171633986,0.846794503906,0.846417548398,0.846040767377,0.845664160717,
	0.845287728357,0.844911470171,0.844535386069,0.844159475978,0.843783739767,
	0.843408177340,0.843032788619,0.842657573479,0.842282531861,0.841907663648,
	0.841532968744,0.841158447056,0.840784098491,0.840409922922,0.840035920302,
	0.839662090484,0.839288433415,0.838914948972,0.838541637054,0.838168497589,
	0.837795530478,0.837422735619,0.837050112914,0.836677662262,0.836305383567,
	0.835933276742,0.835561341697,0.835189578341,0.834817986555,0.834446566260,
	0.834075317342,0.833704239748,0.833333333342
	}
};

double always_inline bigchumppowerclip(double x) {
    double f = fabs(x);
    f = f * bigchumppower_table.istep;
    int i = static_cast<int>(f);
    if (i < 0) {
        f = bigchumppower_table.data[0];
    } else if (i >= bigchumppower_table.size-1) {
        f = bigchumppower_table.data[bigchumppower_table.size-1];
    } else {
    f -= i;
    f = bigchumppower_table.data[i]*(1-f) + bigchumppower_table.data[i+1]*f;
    }
    return copysign(f, x);
}

#endif //_BIGCHUMPPOWER_H_
