/*
 * This program source code file is part of KiCad, a free EDA CAD application.
 *
 * Copyright (C) 2009 Wayne Stambaugh <stambaughw@verizon.net>
 * Copyright (C) 1992-2011 KiCad Developers, see AUTHORS.txt for contributors.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you may find one here:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * or you may search the http://www.gnu.org website for the version 2 license,
 * or you may write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 */

/**
 * @file dialog_libedit_options.h
 *
 * Subclass of DIALOG_LIBEDIT_OPTIONS_BASE, which is generated by wxFormBuilder.
 */

#ifndef __DIALOG_LIBEDIT_OPTIONS__
#define __DIALOG_LIBEDIT_OPTIONS__

#include <dialog_libedit_options_base.h>

class LIB_EDIT_FRAME;

class DIALOG_LIBEDIT_OPTIONS : public DIALOG_LIBEDIT_OPTIONS_BASE
{
public:
    DIALOG_LIBEDIT_OPTIONS( LIB_EDIT_FRAME* parent );

    LIB_EDIT_FRAME* Parent() { return (LIB_EDIT_FRAME*) GetParent(); }

    void SetGridSelection( int select ) { m_choiceGridSize->SetSelection( select ); }
    int GetGridSelection( void ) { return m_choiceGridSize->GetSelection(); }
    void SetGridSizes( const GRIDS& grid_sizes, int grid_id );

    void SetShowGrid( bool show ) { m_checkShowGrid->SetValue( show ); }
    bool GetShowGrid( void ) { return m_checkShowGrid->GetValue(); }

    void SetLineWidth( int aWidth ) { m_spinLineWidth->SetValue( aWidth ); }
    int GetLineWidth( void ) { return m_spinLineWidth->GetValue(); }

    void SetPinLength( int aLength ) { m_spinPinLength->SetValue( aLength ); }
    int GetPinLength( void ) { return m_spinPinLength->GetValue(); }

    void SetPinNumSize( int text_size ) { m_spinPinNumSize->SetValue( text_size ); }
    int GetPinNumSize( void ) { return m_spinPinNumSize->GetValue(); }

    void SetPinNameSize( int text_size ) { m_spinPinNameSize->SetValue( text_size ); }
    int GetPinNameSize( void ) { return m_spinPinNameSize->GetValue(); }

    void SetPinRepeatStep( int aValue ) { m_choicePinDisplacement->SetSelection( aValue == 50 ? 1 : 0 ); }
    int GetPinRepeatStep( void )
    {
        return m_choicePinDisplacement->GetSelection() == 1 ? 50 : 100;
    }

    void SetItemRepeatStep( wxPoint aValue )
    {
        m_spinRepeatHorizontal->SetValue( aValue.x );
        m_spinRepeatVertical->SetValue( aValue.y );
     }
    wxPoint GetItemRepeatStep( void )
    {
        wxPoint step;
        step.x = m_spinRepeatHorizontal->GetValue();
        step.y = m_spinRepeatVertical->GetValue();
        return step;
    }

    void SetRepeatLabelInc( int aValue ) { m_spinRepeatLabel->SetValue( aValue ); }
    int GetRepeatLabelInc( void )
    {
        return m_spinRepeatLabel->GetValue();
    }

    void SetMaxUndoItems( int aItems ) { m_spinMaxUndoItems->SetValue( aItems ); }
    int GetMaxUndoItems() const { return m_spinMaxUndoItems->GetValue(); }
};

#endif // __DIALOG_LIBEDIT_OPTIONS__
