import unittest
from support import GNATCOLL_TestCase, chdir, pathsep, requires_not_windows
import os


class Test(GNATCOLL_TestCase):
    @chdir("vfs1")
    def test_vfs1(self):
        self.gprbuild()
        self.runexec("obj/test_vfs", "test_vfs.expected")

    @requires_not_windows
    @chdir("links1")
    def test_links1(self):
        self.gprbuild()

        file("hello.orig", "w").write("This is the original")
        try:
            os.unlink("hello.adb")
        except:
            pass
        os.symlink("hello.orig", "hello.adb")

        self.runexec("test_links", "")

        orig = file("hello.orig").read()
        self.assertEqual(orig, "This is the new version")

    @chdir("relative")
    def test_relative(self):
        self.gprbuild()
        self.runexec("main", "")

    @chdir("perms")
    def test_perms(self):
        self.gprbuild()

        os.chmod('c.sh', 0777)
        flags = os.stat('c.sh')
        self.runexec("main", "")
        newflags = os.stat('c.sh')

        self.assertEqual(flags.st_mode, newflags.st_mode)

    @chdir("PA21-007")
    def test_hash(self):
        self.gprbuild()
        self.runexec("obj/main", "")
