#!/bin/sh

set -eu

# Remove manpages for modules listed in debian/ignored-manpages from package
# installation drectory
#
# See also debian/ignore-manpage.sh

TMP=${TMP:-debian/tmp}

cat debian/ignored-manpages \
| while read md5 mod; do
    FILE="lib/`echo PDF::API2::${mod} | sed 's,::,/,g'`.pm"
    CHECK_MD5=`md5sum $FILE | cut -f1 -d ' '`
    if [ "$md5" = "$CHECK_MD5" ]; then
        rm "$TMP/usr/share/man/man3/PDF::API2::${mod}.3pm"
    else
        echo WARNING: Checksum mismatch for module ${mod}. Manpage not removed
    fi
done
