# coding: utf-8

"""
Copyright 2015 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems


class V1PersistentVolumeClaimStatus(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Swagger model

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'phase': 'str',
            'access_modes': 'list[V1PersistentVolumeAccessMode]',
            'capacity': 'str'
        }

        self.attribute_map = {
            'phase': 'phase',
            'access_modes': 'accessModes',
            'capacity': 'capacity'
        }

        self._phase = None
        self._access_modes = None
        self._capacity = None

    @property
    def phase(self):
        """
        Gets the phase of this V1PersistentVolumeClaimStatus.
        the current phase of the claim

        :return: The phase of this V1PersistentVolumeClaimStatus.
        :rtype: str
        """
        return self._phase

    @phase.setter
    def phase(self, phase):
        """
        Sets the phase of this V1PersistentVolumeClaimStatus.
        the current phase of the claim

        :param phase: The phase of this V1PersistentVolumeClaimStatus.
        :type: str
        """
        self._phase = phase

    @property
    def access_modes(self):
        """
        Gets the access_modes of this V1PersistentVolumeClaimStatus.
        the actual access modes the volume has; see http://releases.k8s.io/v1.0.4/docs/persistent-volumes.md#access-modes-1

        :return: The access_modes of this V1PersistentVolumeClaimStatus.
        :rtype: list[V1PersistentVolumeAccessMode]
        """
        return self._access_modes

    @access_modes.setter
    def access_modes(self, access_modes):
        """
        Sets the access_modes of this V1PersistentVolumeClaimStatus.
        the actual access modes the volume has; see http://releases.k8s.io/v1.0.4/docs/persistent-volumes.md#access-modes-1

        :param access_modes: The access_modes of this V1PersistentVolumeClaimStatus.
        :type: list[V1PersistentVolumeAccessMode]
        """
        self._access_modes = access_modes

    @property
    def capacity(self):
        """
        Gets the capacity of this V1PersistentVolumeClaimStatus.
        the actual resources the volume has

        :return: The capacity of this V1PersistentVolumeClaimStatus.
        :rtype: str
        """
        return self._capacity

    @capacity.setter
    def capacity(self, capacity):
        """
        Sets the capacity of this V1PersistentVolumeClaimStatus.
        the actual resources the volume has

        :param capacity: The capacity of this V1PersistentVolumeClaimStatus.
        :type: str
        """
        self._capacity = capacity

    def to_dict(self):
        """
        Return model properties dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Return model properties str
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()
