/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <sstream>
#include <vector>
#include <stdio.h>

#include "MvFileInfo.h"

MvFileInfo::MvFileInfo(string name)
{
	name_=name;

	string buf="ls -lhd \"" + name_ + "\"";

	FILE *in;
	char cbuf[512];

	if (!(in = popen(buf.c_str(),"r")) )
	{
		return;
	}

	if(fgets(cbuf, sizeof(cbuf), in) == NULL)
	{
		pclose(in);
		return;
	}	
	
	pclose(in);

	stringstream ss(cbuf); 
    	vector<string> tokens; 

   	while (ss >> buf)
        {			
		tokens.push_back(buf);	
	}
	
	if(tokens.size() < 7)	
	{
		return;
	}  

	permissions_=tokens[0];
	owner_=tokens[2];
	group_=tokens[3];
	//size_=tokens[4];
	size_=sizeInBytes(name_);
	if(size_ != "???")
	{
	  	size_.append("B");
	}
	
	modified_=tokens[5] + " " +tokens[6] ;

	if(permissions_.find("l") != string::npos)
	{
		size_="???";
	  	string sbuf(cbuf);
		string::size_type pos;
		if((pos=sbuf.find("->")) != string::npos)
		{
			linkTo_=sbuf.substr(pos+3);
			if((pos=linkTo_.find('\n')) != string::npos)
			{
			  	linkTo_.erase(pos,1);	
			}
			
			size_=sizeInBytes(linkTo_);
			if(size_ != "???")
			{
	  			size_.append("B");
			}
		}
	}
}

string MvFileInfo::sizeInBytes(string path)
{
	string buf="du -sh \"" + path + "\"";

	FILE *in;
	char cbuf[512];

	if (!(in = popen(buf.c_str(),"r")) )
	{
		return string("???");
	}

	if(fgets(cbuf, sizeof(cbuf), in) == NULL)
	{
		pclose(in);
		return string("???");
	}	
	
	pclose(in);

	stringstream ss(cbuf); 
   
   	while(ss >> buf)
        {			
		return buf;	
	}
	
	return string("???");
}	