/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File TextLine.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef ListHelp_H
#define ListHelp_H

#include "UIListHelp.h"

#ifndef RequestPanelHelp_H
#include "RequestPanelHelp.h"
#endif

#ifndef ParamList_H
#include "ParamList.h"
#endif

class ListHelp: public XHelp<UIListHelp_c> {
public:

// -- Contructors

	ListHelp(Widget, RequestPanel&, const Parameter&);

// -- Destructor

	virtual ~ListHelp(); 

private:

// No copy allowed

	ListHelp(const ListHelp&);
	ListHelp& operator=(const ListHelp&);

// -- Members
	
	ParamList xlist_;

// -- Overridden methods

	// From XD

	virtual void browseCB(Widget,XtPointer);
	virtual void singleCB(Widget,XtPointer);
	virtual void multipleCB(Widget,XtPointer);
	virtual void extendedCB(Widget,XtPointer);

	// From RequestPanelItem

	virtual void refresh(const vector<string>&);
  	virtual long flags();
	virtual void set(Request&);

};

#endif
