/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQPlotView_H
#define MvQPlotView_H

#include <QGraphicsView>

class MvKeyProfile;

class MvQAreaSelection;
class MvQCursorData;
class MvQDrop;
class MvQLineSelection;
class MvQMagnifier;
class MvQZoom;
class MvQPlaceMark;
class MvQPlaceMarkItem;
class MvQPlaceMarkWidget;
class MvQPointSelection;

class MgQPlotScene;
class MgQLayoutItem;
class MgQSceneItem;

#include "Layer.h"

class MvQPlotView : public QGraphicsView
{
Q_OBJECT

public:
	MvQPlotView(QGraphicsScene*,QWidget *parent=0);
	~MvQPlotView();
	void resetBegin();
	void resetEnd();
	void setMvPlotSize(double,double);
	void setPlaceMark(MvQPlaceMarkWidget*);
	void setDataProbe(MvQPlaceMark*);
	void DrawRectangle(double,double,double,double);

public slots:
	void slotSetEnableZoom(bool);
	void slotSetEnableMagnifier(bool);
	void slotMagnifierChanged();
	void slotSetEnableCursorData(bool);
	void slotEnableCursorDataProbe(bool);
	void slotSetEnableAreaSelection(bool);
	void slotSetEnableLineSelection(bool);
	void slotSetEnablePointSelection(bool);
	void slotCreatePlaceMark();
	void slotChangeArea(double,double,double,double);
	void slotClearArea();
	void slotSelectAllArea();
	void slotChangeLine(double,double,double,double);
	void slotClearLine();
	void slotChangeLineDirection();
	void slotChangePoint(double,double);
	void slotClearPoint();
	void slotFrameProfileChanged(MvKeyProfile*);
	void slotSelectScene();

signals:
	void zoomRectangleIsDefined(const string&,const string&);
	void areaIsDefined(double,double,double,double);
	void areaIsUndefined();
	void lineIsDefined(double,double,double,double);
	void lineIsUndefined();
	void pointIsDefined(double,double);
	void pointIsUndefined();
	void magnifierIsEnabledProgramatically(bool);
	void zoomIsEnabledProgramatically(bool);
	void inputSIsEnabledProgramatically(bool);
	void sceneSelected(QPointF);
	void contextMenuEventHappened(const QPoint&,const QPointF&); 
	void resizeEventHappened(const QSize&);
	void zoomActionStarted(MgQSceneItem*);	
	void cursorDataChanged(QPointF,QList<ValuesCollector>);
	void iconDropped(const MvQDrop&,QPoint);

protected:
	void mouseMoveEvent ( QMouseEvent * event );
	void mousePressEvent ( QMouseEvent * event );
	void mouseReleaseEvent ( QMouseEvent * event );
	void contextMenuEvent(QContextMenuEvent *);
	void resizeEvent(QResizeEvent *);
	void dragEnterEvent(QDragEnterEvent *);
	void dragMoveEvent(QDragMoveEvent *);
	void dropEvent(QDropEvent *);

	MgQPlotScene* plotScene_;

	//Zoom
	MvQZoom *zoom_;
	MvQMagnifier *magnifier_;
	MvQCursorData* cursorData_;
	MvQPlaceMark* cursorDataProbe_;
	MvQAreaSelection *area_;
	MvQLineSelection *line_;
	MvQPointSelection *point_;
	MvQPlaceMarkWidget *placeMark_;
	bool placeMarkIsBeingCreated_;
	QList<MvQPlaceMarkItem*> pointData_;
	bool sceneIsBeingSelected_;
	MvQPlaceMark* dataProbe_;
};

#endif
