/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2013 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2013 Sun Microsystems, Inc.
 */
package org.netbeans.modules.web.webkit.tooling.networkmonitor;

import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 */
public class NetworkMonitorTopComponentTest {

    public NetworkMonitorTopComponentTest() {
    }

    @Test
    public void testGetJSONPResponse() {
        String data = "jQuery191025532260071486235_1363731616216({\"completed_in\":0.036,\"max_id\":314139239291949056,\"max_id_str\":\"314139239291949056\",\"next_page\":\"?page=2&max_id=314139239291949056&q=html\",\"page\":1,\"query\":\"html\",\"refresh_url\":\"?since_id=314139239291949056&q=html\",\"results\":[{\"created_at\":\"Tue, 19 Mar 2013 22:20:05 +0000\",\"from_user\":\"Maxi_Bibbo\",\"from_user_id\":143203311,\"from_user_id_str\":\"143203311\",\"from_user_name\":\"Maximiliano Bibb\\u00f3\",\"geo\":null,\"id\":314139239291949056,\"id_str\":\"314139239291949056\",\"iso_language_code\":\"es\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/976630752\\/14125_1418876277484_1399958245_2029164_712608_n_normal.jpg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/976630752\\/14125_1418876277484_1399958245_2029164_712608_n_normal.jpg\",\"source\":\"&lt;a href=&quot;http:\\/\\/www.tweetdeck.com&quot;&gt;TweetDeck&lt;\\/a&gt;\",\"text\":\"@actcargentina #TCPista @GonzaPerlo cambia dentro del @mvdcompeticion http:\\/\\/t.co\\/FxZl3jTiXj\",\"to_user\":\"actcargentina\",\"to_user_id\":86116342,\"to_user_id_str\":\"86116342\",\"to_user_name\":\"ACTC\"},{\"created_at\":\"Tue, 19 Mar 2013 22:20:05 +0000\",\"from_user\":\"V_Impavida\",\"from_user_id\":21921604,\"from_user_id_str\":\"21921604\",\"from_user_name\":\"Deborah Fox\",\"geo\":null,\"id\":314139238847373312,\"id_str\":\"314139238847373312\",\"iso_language_code\":\"en\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/1234881548\\/80500602_normal.jpg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/1234881548\\/80500602_normal.jpg\",\"source\":\"&lt;a href=&quot;http:\\/\\/www.echofon.com\\/&quot;&gt;Echofon&lt;\\/a&gt;\",\"text\":\"Mt RT @valmcdermid: Speaking as an alumna of @StHildasOx I'm baffled that my alma mater appears to have lost its SOH .http:\\/\\/t.co\\/DhrcJPLBwh\"},{\"created_at\":\"Tue, 19 Mar 2013 22:20:05 +0000\",\"from_user\":\"viking_olof\",\"from_user_id\":147300633,\"from_user_id_str\":\"147300633\",\"from_user_name\":\"Olof\",\"geo\":null,\"id\":314139238822199298,\"id_str\":\"314139238822199298\",\"iso_language_code\":\"en\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/936074674\\/80x80_comic0024_laymGAJROZkAVpgnnqSvQ_normal.jpg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/936074674\\/80x80_comic0024_laymGAJROZkAVpgnnqSvQ_normal.jpg\",\"source\":\"&lt;a href=&quot;http:\\/\\/myworld.se\\/olga-olof-sitting-in-a-tree\\/&quot;&gt;Olga&lt;\\/a&gt;\",\"text\":\"JQuery Autocomplete PHP MySQL JSON Example http:\\/\\/t.co\\/ldguJIOw6S #jquery\"},{\"created_at\":\"Tue, 19 Mar 2013 22:20:05 +0000\",\"from_user\":\"dwm227n2\",\"from_user_id\":1218224354,\"from_user_id_str\":\"1218224354\",\"from_user_name\":\"\\u3061\\u306a\\u307f\",\"geo\":null,\"id\":314139238717341697,\"id_str\":\"314139238717341697\",\"iso_language_code\":\"ja\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/3306146798\\/bc5919a5de35c6845dab20217e34c261_normal.jpeg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/3306146798\\/bc5919a5de35c6845dab20217e34c261_normal.jpeg\",\"source\":\"&lt;a href=&quot;http:\\/\\/bipblog.com\\/&quot;&gt;dwm227n2&lt;\\/a&gt;\",\"text\":\"\\u3010\\u61f8\\u8cde\\u3011\\u30b9\\u30de\\u30db\\u306e\\u96fb\\u6c60\\u5207\\u308c\\u89e3\\u6d88\\uff013500mAh \\u30bd\\u30fc\\u30e9\\u30fc\\u5145\\u96fb\\u5668\\u30923\\u540d\\u69d8\\u306b\\u30d7\\u30ec\\u30bc\\u30f3\\u30c8\\uff01\\u8a73\\u7d30\\u306f\\u3053\\u3061\\u3089\\u2192http:\\/\\/t.co\\/SLGqQoaPqO #\\u30d7\\u30ec\\u30bc\\u30f3\\u30c8 #\\u61f8\\u8cde #iphone #\\u30b9\\u30de\\u30db #\\u901a\\u8ca9 #HGX\"},{\"created_at\":\"Tue, 19 Mar 2013 22:20:05 +0000\",\"from_user\":\"EdwinRivera_AON\",\"from_user_id\":298530186,\"from_user_id_str\":\"298530186\",\"from_user_name\":\"Edwin Rivera\",\"geo\":null,\"id\":314139238679601152,\"id_str\":\"314139238679601152\",\"iso_language_code\":\"es\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/2059258266\\/Foto_Edwin_Eli_Samuel_Santa_normal.jpg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/2059258266\\/Foto_Edwin_Eli_Samuel_Santa_normal.jpg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitter.com\\/#!\\/download\\/ipad&quot;&gt;Twitter for iPad&lt;\\/a&gt;\",\"text\":\"RT @LourdesToledo2: LOURDES TOLEDO LANZA SU PRIMER LIBRO: \\\"PROVISIONES PARA TU ALFORJA\\\" | BuenasNuevasPR: http:\\/\\/t.co\\/CLRAu7G6Lh\"},{\"created_at\":\"Tue, 19 Mar 2013 22:20:05 +0000\",\"from_user\":\"DerrickWyrms\",\"from_user_id\":441196417,\"from_user_id_str\":\"441196417\",\"from_user_name\":\"Derrick\",\"geo\":null,\"id\":314139238587301888,\"id_str\":\"314139238587301888\",\"iso_language_code\":\"en\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/2796421931\\/5d6d0e900ab8ab2db00824f339fd3254_normal.jpeg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/2796421931\\/5d6d0e900ab8ab2db00824f339fd3254_normal.jpeg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitter.com\\/download\\/iphone&quot;&gt;Twitter for iPhone&lt;\\/a&gt;\",\"text\":\"RT @keithboykin: NY Times: Republicans have now voted and failed 54 times to repeal Obamacare. http:\\/\\/t.co\\/s7md6fs02V\"},{\"created_at\":\"Tue, 19 Mar 2013 22:20:05 +0000\",\"from_user\":\"vakbondsnieuws\",\"from_user_id\":418628843,\"from_user_id_str\":\"418628843\",\"from_user_name\":\"Sociale Partners\",\"geo\":null,\"id\":314139238578921473,\"id_str\":\"314139238578921473\",\"iso_language_code\":\"nl\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/1651862644\\/sociaal_normal.jpg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/1651862644\\/sociaal_normal.jpg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitterfeed.com&quot;&gt;twitterfeed&lt;\\/a&gt;\",\"text\":\"#vakbond #Albert Heijn-chef rijdt in op staker: Een teamleider van het Landelijk Distributiecentrum van Albert... http:\\/\\/t.co\\/Ukqzrmyvy3\"},{\"created_at\":\"Tue, 19 Mar 2013 22:20:05 +0000\",\"from_user\":\"PlasterersForum\",\"from_user_id\":95203435,\"from_user_id_str\":\"95203435\",\"from_user_name\":\"The Plasterers Forum\",\"geo\":null,\"id\":314139238536986624,\"id_str\":\"314139238536986624\",\"iso_language_code\":\"en\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/1337669622\\/pforumlogo_normal.png\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/1337669622\\/pforumlogo_normal.png\",\"source\":\"&lt;a href=&quot;http:\\/\\/www.plasterersforum.com&quot;&gt;plasterersforum.com&lt;\\/a&gt;\",\"text\":\"Human plastering machine - http:\\/\\/t.co\\/srIyagRIPy\"},{\"created_at\":\"Tue, 19 Mar 2013 22:20:05 +0000\",\"from_user\":\"Ronggo_lawe9\",\"from_user_id\":1274932086,\"from_user_id_str\":\"1274932086\",\"from_user_name\":\"Ronggo_lawe\",\"geo\":null,\"id\":314139238046261248,\"id_str\":\"314139238046261248\",\"iso_language_code\":\"in\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/3392002854\\/f34225b2ef3386bcf8e712f19a927efc_normal.jpeg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/3392002854\\/f34225b2ef3386bcf8e712f19a927efc_normal.jpeg\",\"source\":\"&lt;a href=&quot;https:\\/\\/twitter.com\\/Ronggo_lawe9&quot;&gt;menteng47&lt;\\/a&gt;\",\"text\":\"RT @RanMouri25: http:\\/\\/t.co\\/iq5Vkx2buM : Harga bawang putih selangit, istri Dahlan Iskan kena semprot pembeli http:\\/\\/t.co\\/O0QpHPpeNN via @merdekadotcom\"},{\"created_at\":\"Tue, 19 Mar 2013 22:20:05 +0000\",\"from_user\":\"gegez\",\"from_user_id\":40371805,\"from_user_id_str\":\"40371805\",\"from_user_name\":\"Geraldo\",\"geo\":null,\"id\":314139238025265152,\"id_str\":\"314139238025265152\",\"iso_language_code\":\"en\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/2173973981\\/euuuuuu_normal.jpg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/2173973981\\/euuuuuu_normal.jpg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitter.com\\/tweetbutton&quot;&gt;Tweet Button&lt;\\/a&gt;\",\"text\":\"HeavynRoll Space: [Braziland] FUEL \\u2018N\\u2019 FIRE: Realizar\\u00e1 show no Rock ... http:\\/\\/t.co\\/EfWU53jDlr\"},{\"created_at\":\"Tue, 19 Mar 2013 22:20:05 +0000\",\"from_user\":\"ferchLe0n\",\"from_user_id\":435319001,\"from_user_id_str\":\"435319001\",\"from_user_name\":\"Fer P\\u00e9rez\",\"geo\":null,\"id\":314139237949796352,\"id_str\":\"314139237949796352\",\"iso_language_code\":\"es\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/2281131602\\/ed68kggcmfvcm1h51cqz_normal.jpeg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/2281131602\\/ed68kggcmfvcm1h51cqz_normal.jpeg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitterfeed.com&quot;&gt;twitterfeed&lt;\\/a&gt;\",\"text\":\"\\u00a1\\u00daltimas Noticias! Corte ordena archivo definitivo de querella contra rector de la UASD http:\\/\\/t.co\\/xTAqdVrzmt #RepublicaDominicana\"},{\"created_at\":\"Tue, 19 Mar 2013 22:20:05 +0000\",\"from_user\":\"MeAyuDewi\",\"from_user_id\":1271343547,\"from_user_id_str\":\"1271343547\",\"from_user_name\":\"Ayu Dewi\",\"geo\":null,\"id\":314139237945573376,\"id_str\":\"314139237945573376\",\"iso_language_code\":\"in\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/3385629006\\/8391f432234e9bd9046e57c913ea7242_normal.jpeg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/3385629006\\/8391f432234e9bd9046e57c913ea7242_normal.jpeg\",\"source\":\"&lt;a href=&quot;http:\\/\\/www.tweetdeck.com&quot;&gt;TweetDeck&lt;\\/a&gt;\",\"text\":\"Dahlan Iskan: BUMN Konstruksi Siap Kerjakan Studi Kelayakan Jembatan Selat Sunda http:\\/\\/t.co\\/PApMengXqo via @beritasatu\"},{\"created_at\":\"Tue, 19 Mar 2013 22:20:05 +0000\",\"from_user\":\"slfeed_net\",\"from_user_id\":129430093,\"from_user_id_str\":\"129430093\",\"from_user_name\":\"slfeed.net\",\"geo\":null,\"id\":314139237941399552,\"id_str\":\"314139237941399552\",\"iso_language_code\":\"en\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/797171704\\/20091113-information_normal.png\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/797171704\\/20091113-information_normal.png\",\"source\":\"&lt;a href=&quot;http:\\/\\/info.slfeed.net\\/twitter_apis.html&quot;&gt;(@\\u76ca@.:;)\\uff89\\uff7c&lt;\\/a&gt;\",\"text\":\"New POST in 20 min \\u300eSweet Pitulandia\\u300f I N O C E N C I A 07:02 am http:\\/\\/t.co\\/hxfzzwrU4a #slfeed\"},{\"created_at\":\"Tue, 19 Mar 2013 22:20:05 +0000\",\"from_user\":\"rilekat\",\"from_user_id\":334258626,\"from_user_id_str\":\"334258626\",\"from_user_name\":\"Katherine Riley\",\"geo\":null,\"id\":314139237899460608,\"id_str\":\"314139237899460608\",\"iso_language_code\":\"en\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/1478141693\\/Photo0145_normal.jpg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/1478141693\\/Photo0145_normal.jpg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitter.com\\/tweetbutton&quot;&gt;Tweet Button&lt;\\/a&gt;\",\"text\":\"Where the Mome Raths Outgrabe is giving away a $15 (USD) Amazon card!  http:\\/\\/t.co\\/sB3A94NvZm\"},{\"created_at\":\"Tue, 19 Mar 2013 22:20:05 +0000\",\"from_user\":\"nautilus302\",\"from_user_id\":135437141,\"from_user_id_str\":\"135437141\",\"from_user_name\":\"\\u30ce\\u30fc\\u30c1\\u30e9\\u30b9GO\",\"geo\":null,\"id\":314139237886873601,\"id_str\":\"314139237886873601\",\"iso_language_code\":\"ja\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/3164325797\\/c340013bab9ce3a944a94d523aff134a_normal.jpeg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/3164325797\\/c340013bab9ce3a944a94d523aff134a_normal.jpeg\",\"source\":\"&lt;a href=&quot;http:\\/\\/ap.macdb.jp\\/&quot;&gt;nautilus302&lt;\\/a&gt;\",\"text\":\"\\u798f\\u5cf6\\u7b2c\\u4e00\\u505c\\u96fb \\u4eee\\u8a2d\\u914d\\u96fb\\u76e4 \\u4ea4\\u63db\\u305b\\u305a \\u539f\\u56e0\\u4e0d\\u660e\\u306e\\u307e\\u307e\\u4eee\\u5fa9\\u65e7 - \\u6771\\u4eac\\u65b0\\u805e http:\\/\\/t.co\\/IKGyPpYrHF\"}],\"results_per_page\":15,\"since_id\":0,\"since_id_str\":\"0\"});";
        String response = "{\"completed_in\":0.036,\"max_id\":314139239291949056,\"max_id_str\":\"314139239291949056\",\"next_page\":\"?page=2&max_id=314139239291949056&q=html\",\"page\":1,\"query\":\"html\",\"refresh_url\":\"?since_id=314139239291949056&q=html\",\"results\":[{\"created_at\":\"Tue, 19 Mar 2013 22:20:05 +0000\",\"from_user\":\"Maxi_Bibbo\",\"from_user_id\":143203311,\"from_user_id_str\":\"143203311\",\"from_user_name\":\"Maximiliano Bibb\\u00f3\",\"geo\":null,\"id\":314139239291949056,\"id_str\":\"314139239291949056\",\"iso_language_code\":\"es\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/976630752\\/14125_1418876277484_1399958245_2029164_712608_n_normal.jpg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/976630752\\/14125_1418876277484_1399958245_2029164_712608_n_normal.jpg\",\"source\":\"&lt;a href=&quot;http:\\/\\/www.tweetdeck.com&quot;&gt;TweetDeck&lt;\\/a&gt;\",\"text\":\"@actcargentina #TCPista @GonzaPerlo cambia dentro del @mvdcompeticion http:\\/\\/t.co\\/FxZl3jTiXj\",\"to_user\":\"actcargentina\",\"to_user_id\":86116342,\"to_user_id_str\":\"86116342\",\"to_user_name\":\"ACTC\"},{\"created_at\":\"Tue, 19 Mar 2013 22:20:05 +0000\",\"from_user\":\"V_Impavida\",\"from_user_id\":21921604,\"from_user_id_str\":\"21921604\",\"from_user_name\":\"Deborah Fox\",\"geo\":null,\"id\":314139238847373312,\"id_str\":\"314139238847373312\",\"iso_language_code\":\"en\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/1234881548\\/80500602_normal.jpg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/1234881548\\/80500602_normal.jpg\",\"source\":\"&lt;a href=&quot;http:\\/\\/www.echofon.com\\/&quot;&gt;Echofon&lt;\\/a&gt;\",\"text\":\"Mt RT @valmcdermid: Speaking as an alumna of @StHildasOx I'm baffled that my alma mater appears to have lost its SOH .http:\\/\\/t.co\\/DhrcJPLBwh\"},{\"created_at\":\"Tue, 19 Mar 2013 22:20:05 +0000\",\"from_user\":\"viking_olof\",\"from_user_id\":147300633,\"from_user_id_str\":\"147300633\",\"from_user_name\":\"Olof\",\"geo\":null,\"id\":314139238822199298,\"id_str\":\"314139238822199298\",\"iso_language_code\":\"en\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/936074674\\/80x80_comic0024_laymGAJROZkAVpgnnqSvQ_normal.jpg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/936074674\\/80x80_comic0024_laymGAJROZkAVpgnnqSvQ_normal.jpg\",\"source\":\"&lt;a href=&quot;http:\\/\\/myworld.se\\/olga-olof-sitting-in-a-tree\\/&quot;&gt;Olga&lt;\\/a&gt;\",\"text\":\"JQuery Autocomplete PHP MySQL JSON Example http:\\/\\/t.co\\/ldguJIOw6S #jquery\"},{\"created_at\":\"Tue, 19 Mar 2013 22:20:05 +0000\",\"from_user\":\"dwm227n2\",\"from_user_id\":1218224354,\"from_user_id_str\":\"1218224354\",\"from_user_name\":\"\\u3061\\u306a\\u307f\",\"geo\":null,\"id\":314139238717341697,\"id_str\":\"314139238717341697\",\"iso_language_code\":\"ja\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/3306146798\\/bc5919a5de35c6845dab20217e34c261_normal.jpeg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/3306146798\\/bc5919a5de35c6845dab20217e34c261_normal.jpeg\",\"source\":\"&lt;a href=&quot;http:\\/\\/bipblog.com\\/&quot;&gt;dwm227n2&lt;\\/a&gt;\",\"text\":\"\\u3010\\u61f8\\u8cde\\u3011\\u30b9\\u30de\\u30db\\u306e\\u96fb\\u6c60\\u5207\\u308c\\u89e3\\u6d88\\uff013500mAh \\u30bd\\u30fc\\u30e9\\u30fc\\u5145\\u96fb\\u5668\\u30923\\u540d\\u69d8\\u306b\\u30d7\\u30ec\\u30bc\\u30f3\\u30c8\\uff01\\u8a73\\u7d30\\u306f\\u3053\\u3061\\u3089\\u2192http:\\/\\/t.co\\/SLGqQoaPqO #\\u30d7\\u30ec\\u30bc\\u30f3\\u30c8 #\\u61f8\\u8cde #iphone #\\u30b9\\u30de\\u30db #\\u901a\\u8ca9 #HGX\"},{\"created_at\":\"Tue, 19 Mar 2013 22:20:05 +0000\",\"from_user\":\"EdwinRivera_AON\",\"from_user_id\":298530186,\"from_user_id_str\":\"298530186\",\"from_user_name\":\"Edwin Rivera\",\"geo\":null,\"id\":314139238679601152,\"id_str\":\"314139238679601152\",\"iso_language_code\":\"es\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/2059258266\\/Foto_Edwin_Eli_Samuel_Santa_normal.jpg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/2059258266\\/Foto_Edwin_Eli_Samuel_Santa_normal.jpg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitter.com\\/#!\\/download\\/ipad&quot;&gt;Twitter for iPad&lt;\\/a&gt;\",\"text\":\"RT @LourdesToledo2: LOURDES TOLEDO LANZA SU PRIMER LIBRO: \\\"PROVISIONES PARA TU ALFORJA\\\" | BuenasNuevasPR: http:\\/\\/t.co\\/CLRAu7G6Lh\"},{\"created_at\":\"Tue, 19 Mar 2013 22:20:05 +0000\",\"from_user\":\"DerrickWyrms\",\"from_user_id\":441196417,\"from_user_id_str\":\"441196417\",\"from_user_name\":\"Derrick\",\"geo\":null,\"id\":314139238587301888,\"id_str\":\"314139238587301888\",\"iso_language_code\":\"en\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/2796421931\\/5d6d0e900ab8ab2db00824f339fd3254_normal.jpeg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/2796421931\\/5d6d0e900ab8ab2db00824f339fd3254_normal.jpeg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitter.com\\/download\\/iphone&quot;&gt;Twitter for iPhone&lt;\\/a&gt;\",\"text\":\"RT @keithboykin: NY Times: Republicans have now voted and failed 54 times to repeal Obamacare. http:\\/\\/t.co\\/s7md6fs02V\"},{\"created_at\":\"Tue, 19 Mar 2013 22:20:05 +0000\",\"from_user\":\"vakbondsnieuws\",\"from_user_id\":418628843,\"from_user_id_str\":\"418628843\",\"from_user_name\":\"Sociale Partners\",\"geo\":null,\"id\":314139238578921473,\"id_str\":\"314139238578921473\",\"iso_language_code\":\"nl\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/1651862644\\/sociaal_normal.jpg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/1651862644\\/sociaal_normal.jpg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitterfeed.com&quot;&gt;twitterfeed&lt;\\/a&gt;\",\"text\":\"#vakbond #Albert Heijn-chef rijdt in op staker: Een teamleider van het Landelijk Distributiecentrum van Albert... http:\\/\\/t.co\\/Ukqzrmyvy3\"},{\"created_at\":\"Tue, 19 Mar 2013 22:20:05 +0000\",\"from_user\":\"PlasterersForum\",\"from_user_id\":95203435,\"from_user_id_str\":\"95203435\",\"from_user_name\":\"The Plasterers Forum\",\"geo\":null,\"id\":314139238536986624,\"id_str\":\"314139238536986624\",\"iso_language_code\":\"en\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/1337669622\\/pforumlogo_normal.png\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/1337669622\\/pforumlogo_normal.png\",\"source\":\"&lt;a href=&quot;http:\\/\\/www.plasterersforum.com&quot;&gt;plasterersforum.com&lt;\\/a&gt;\",\"text\":\"Human plastering machine - http:\\/\\/t.co\\/srIyagRIPy\"},{\"created_at\":\"Tue, 19 Mar 2013 22:20:05 +0000\",\"from_user\":\"Ronggo_lawe9\",\"from_user_id\":1274932086,\"from_user_id_str\":\"1274932086\",\"from_user_name\":\"Ronggo_lawe\",\"geo\":null,\"id\":314139238046261248,\"id_str\":\"314139238046261248\",\"iso_language_code\":\"in\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/3392002854\\/f34225b2ef3386bcf8e712f19a927efc_normal.jpeg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/3392002854\\/f34225b2ef3386bcf8e712f19a927efc_normal.jpeg\",\"source\":\"&lt;a href=&quot;https:\\/\\/twitter.com\\/Ronggo_lawe9&quot;&gt;menteng47&lt;\\/a&gt;\",\"text\":\"RT @RanMouri25: http:\\/\\/t.co\\/iq5Vkx2buM : Harga bawang putih selangit, istri Dahlan Iskan kena semprot pembeli http:\\/\\/t.co\\/O0QpHPpeNN via @merdekadotcom\"},{\"created_at\":\"Tue, 19 Mar 2013 22:20:05 +0000\",\"from_user\":\"gegez\",\"from_user_id\":40371805,\"from_user_id_str\":\"40371805\",\"from_user_name\":\"Geraldo\",\"geo\":null,\"id\":314139238025265152,\"id_str\":\"314139238025265152\",\"iso_language_code\":\"en\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/2173973981\\/euuuuuu_normal.jpg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/2173973981\\/euuuuuu_normal.jpg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitter.com\\/tweetbutton&quot;&gt;Tweet Button&lt;\\/a&gt;\",\"text\":\"HeavynRoll Space: [Braziland] FUEL \\u2018N\\u2019 FIRE: Realizar\\u00e1 show no Rock ... http:\\/\\/t.co\\/EfWU53jDlr\"},{\"created_at\":\"Tue, 19 Mar 2013 22:20:05 +0000\",\"from_user\":\"ferchLe0n\",\"from_user_id\":435319001,\"from_user_id_str\":\"435319001\",\"from_user_name\":\"Fer P\\u00e9rez\",\"geo\":null,\"id\":314139237949796352,\"id_str\":\"314139237949796352\",\"iso_language_code\":\"es\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/2281131602\\/ed68kggcmfvcm1h51cqz_normal.jpeg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/2281131602\\/ed68kggcmfvcm1h51cqz_normal.jpeg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitterfeed.com&quot;&gt;twitterfeed&lt;\\/a&gt;\",\"text\":\"\\u00a1\\u00daltimas Noticias! Corte ordena archivo definitivo de querella contra rector de la UASD http:\\/\\/t.co\\/xTAqdVrzmt #RepublicaDominicana\"},{\"created_at\":\"Tue, 19 Mar 2013 22:20:05 +0000\",\"from_user\":\"MeAyuDewi\",\"from_user_id\":1271343547,\"from_user_id_str\":\"1271343547\",\"from_user_name\":\"Ayu Dewi\",\"geo\":null,\"id\":314139237945573376,\"id_str\":\"314139237945573376\",\"iso_language_code\":\"in\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/3385629006\\/8391f432234e9bd9046e57c913ea7242_normal.jpeg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/3385629006\\/8391f432234e9bd9046e57c913ea7242_normal.jpeg\",\"source\":\"&lt;a href=&quot;http:\\/\\/www.tweetdeck.com&quot;&gt;TweetDeck&lt;\\/a&gt;\",\"text\":\"Dahlan Iskan: BUMN Konstruksi Siap Kerjakan Studi Kelayakan Jembatan Selat Sunda http:\\/\\/t.co\\/PApMengXqo via @beritasatu\"},{\"created_at\":\"Tue, 19 Mar 2013 22:20:05 +0000\",\"from_user\":\"slfeed_net\",\"from_user_id\":129430093,\"from_user_id_str\":\"129430093\",\"from_user_name\":\"slfeed.net\",\"geo\":null,\"id\":314139237941399552,\"id_str\":\"314139237941399552\",\"iso_language_code\":\"en\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/797171704\\/20091113-information_normal.png\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/797171704\\/20091113-information_normal.png\",\"source\":\"&lt;a href=&quot;http:\\/\\/info.slfeed.net\\/twitter_apis.html&quot;&gt;(@\\u76ca@.:;)\\uff89\\uff7c&lt;\\/a&gt;\",\"text\":\"New POST in 20 min \\u300eSweet Pitulandia\\u300f I N O C E N C I A 07:02 am http:\\/\\/t.co\\/hxfzzwrU4a #slfeed\"},{\"created_at\":\"Tue, 19 Mar 2013 22:20:05 +0000\",\"from_user\":\"rilekat\",\"from_user_id\":334258626,\"from_user_id_str\":\"334258626\",\"from_user_name\":\"Katherine Riley\",\"geo\":null,\"id\":314139237899460608,\"id_str\":\"314139237899460608\",\"iso_language_code\":\"en\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/1478141693\\/Photo0145_normal.jpg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/1478141693\\/Photo0145_normal.jpg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitter.com\\/tweetbutton&quot;&gt;Tweet Button&lt;\\/a&gt;\",\"text\":\"Where the Mome Raths Outgrabe is giving away a $15 (USD) Amazon card!  http:\\/\\/t.co\\/sB3A94NvZm\"},{\"created_at\":\"Tue, 19 Mar 2013 22:20:05 +0000\",\"from_user\":\"nautilus302\",\"from_user_id\":135437141,\"from_user_id_str\":\"135437141\",\"from_user_name\":\"\\u30ce\\u30fc\\u30c1\\u30e9\\u30b9GO\",\"geo\":null,\"id\":314139237886873601,\"id_str\":\"314139237886873601\",\"iso_language_code\":\"ja\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/3164325797\\/c340013bab9ce3a944a94d523aff134a_normal.jpeg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/3164325797\\/c340013bab9ce3a944a94d523aff134a_normal.jpeg\",\"source\":\"&lt;a href=&quot;http:\\/\\/ap.macdb.jp\\/&quot;&gt;nautilus302&lt;\\/a&gt;\",\"text\":\"\\u798f\\u5cf6\\u7b2c\\u4e00\\u505c\\u96fb \\u4eee\\u8a2d\\u914d\\u96fb\\u76e4 \\u4ea4\\u63db\\u305b\\u305a \\u539f\\u56e0\\u4e0d\\u660e\\u306e\\u307e\\u307e\\u4eee\\u5fa9\\u65e7 - \\u6771\\u4eac\\u65b0\\u805e http:\\/\\/t.co\\/IKGyPpYrHF\"}],\"results_per_page\":15,\"since_id\":0,\"since_id_str\":\"0\"}";
        assertEquals(response, ModelItem.getJSONPResponse(data));

        data = "jQuery19107153239955659956_1363732332706({\"completed_in\":0.02,\"max_id\":314141412667060224,\"max_id_str\":\"314141412667060224\",\"next_page\":\"?page=2&max_id=314141412667060224&q=werty\",\"page\":1,\"query\":\"werty\",\"refresh_url\":\"?since_id=314141412667060224&q=werty\",\"results\":[{\"created_at\":\"Tue, 19 Mar 2013 22:28:43 +0000\",\"from_user\":\"_sougo_follow__\",\"from_user_id\":1024373904,\"from_user_id_str\":\"1024373904\",\"from_user_name\":\"\\u76f8\\u4e92\\u30d5\\u30a9\\u30ed\\u30fc100%\\u652f\\u63f4\\u30a2\\u30ab\\u30a6\\u30f3\\u30c8\",\"geo\":null,\"id\":314141412667060224,\"id_str\":\"314141412667060224\",\"iso_language_code\":\"en\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/3200734309\\/8ae6c035325b352cdfa80c974982a8c4_normal.png\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/3200734309\\/8ae6c035325b352cdfa80c974982a8c4_normal.png\",\"source\":\"&lt;a href=&quot;http:\\/\\/botmaker.dplays.net\\/&quot;&gt;BotMaker&lt;\\/a&gt;\",\"text\":\"@null werty\",\"to_user\":\"null\",\"to_user_id\":3562471,\"to_user_id_str\":\"3562471\",\"to_user_name\":\"not quite nothing\"},{\"created_at\":\"Tue, 19 Mar 2013 22:00:17 +0000\",\"from_user\":\"bandr_18\",\"from_user_id\":352301144,\"from_user_id_str\":\"352301144\",\"from_user_name\":\"\\u0628\\u0646\\u062f\\u0631 \\u0628\\u0646 \\u0639\\u0628\\u062f\\u0627\\u0644\\u0644\\u0647 \",\"geo\":null,\"id\":314134253703143424,\"id_str\":\"314134253703143424\",\"iso_language_code\":\"ar\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/2719237368\\/1f47886a239e3044e6d3a541e723c732_normal.jpeg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/2719237368\\/1f47886a239e3044e6d3a541e723c732_normal.jpeg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitter.com\\/download\\/android&quot;&gt;Twitter for Android&lt;\\/a&gt;\",\"text\":\"RT @Dr_singing: @werty_69 #\\u062e\\u0637\\u0627\\u0628_\\u0627\\u0644\\u0639\\u0648\\u062f\\u0629_\\u064a\\u0645\\u062b\\u0644\\u0646\\u064a #\\u062e\\u0637\\u0627\\u0628_\\u0627\\u0644\\u0639\\u0648\\u062f\\u0629_\\u0644\\u0627\\u064a\\u0645\\u062b\\u0644\\u0646\\u064a \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0638\\u0646 \\u0623\\u0646 \\u0627\\u0644\\u0634\\u063a\\u0644\\u0647 \\u062a\\u0631\\u0642\\u064a\\u0645 \\u0627\\u0644\\u0639\\u0648\\u062f\\u0647 \\u0633\\u062f\\u062d \\u0627\\u0644\\u0631\\u0642\\u0645 \\u0644\\u064a\\u0646\\u0635\\u062d\\u0647\\u0627 \\u0628\\u062a\\u063a\\u0637\\u064a\\u0629 \\u0648\\u062c\\u0647\\u0647\\u0627  http:\\/\\/t.co\\/MKjqRuDyen\",\"in_reply_to_status_id\":312655907123261441,\"in_reply_to_status_id_str\":\"312655907123261441\"},{\"created_at\":\"Tue, 19 Mar 2013 20:18:01 +0000\",\"from_user\":\"Q__werty\",\"from_user_id\":575870843,\"from_user_id_str\":\"575870843\",\"from_user_name\":\"Mike Whirity\",\"geo\":null,\"id\":314108519366397953,\"id_str\":\"314108519366397953\",\"iso_language_code\":\"en\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/3032069009\\/77e5ed53cfac14470f7bda12bba0ced0_normal.jpeg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/3032069009\\/77e5ed53cfac14470f7bda12bba0ced0_normal.jpeg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitter.com\\/download\\/android&quot;&gt;Twitter for Android&lt;\\/a&gt;\",\"text\":\"@Kingsof_LEONard they just showed him and he wanted nothing to do with anyone\",\"to_user\":\"Kingsof_LEONard\",\"to_user_id\":59384044,\"to_user_id_str\":\"59384044\",\"to_user_name\":\"Ryan Leonard\",\"in_reply_to_status_id\":314108024329474048,\"in_reply_to_status_id_str\":\"314108024329474048\"},{\"created_at\":\"Tue, 19 Mar 2013 20:16:03 +0000\",\"from_user\":\"Kingsof_LEONard\",\"from_user_id\":59384044,\"from_user_id_str\":\"59384044\",\"from_user_name\":\"Ryan Leonard\",\"geo\":null,\"id\":314108024329474048,\"id_str\":\"314108024329474048\",\"iso_language_code\":\"en\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/3070239043\\/4d5e8f6d1a319a2ba077038e4c1227b9_normal.jpeg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/3070239043\\/4d5e8f6d1a319a2ba077038e4c1227b9_normal.jpeg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitter.com\\/download\\/iphone&quot;&gt;Twitter for iPhone&lt;\\/a&gt;\",\"text\":\"@Q__werty his interviews are hilauous\",\"to_user\":\"Q__werty\",\"to_user_id\":575870843,\"to_user_id_str\":\"575870843\",\"to_user_name\":\"Mike Whirity\",\"in_reply_to_status_id\":314106610454769664,\"in_reply_to_status_id_str\":\"314106610454769664\"},{\"created_at\":\"Tue, 19 Mar 2013 20:10:26 +0000\",\"from_user\":\"Q__werty\",\"from_user_id\":575870843,\"from_user_id_str\":\"575870843\",\"from_user_name\":\"Mike Whirity\",\"geo\":null,\"id\":314106610454769664,\"id_str\":\"314106610454769664\",\"iso_language_code\":\"en\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/3032069009\\/77e5ed53cfac14470f7bda12bba0ced0_normal.jpeg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/3032069009\\/77e5ed53cfac14470f7bda12bba0ced0_normal.jpeg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitter.com\\/download\\/android&quot;&gt;Twitter for Android&lt;\\/a&gt;\",\"text\":\"Bill Belichick knows he's better than everyone #beast\"},{\"created_at\":\"Tue, 19 Mar 2013 19:04:18 +0000\",\"from_user\":\"DrAlaani\",\"from_user_id\":375506761,\"from_user_id_str\":\"375506761\",\"from_user_name\":\"\\u062f. \\u0646\\u0632\\u0627\\u0631 \\u0646\\u0632\\u0627\\u0631 \\u0627\\u0644\\u0639\\u0627\\u0646\\u064a\",\"geo\":null,\"id\":314089968911937536,\"id_str\":\"314089968911937536\",\"iso_language_code\":\"ar\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/2689889308\\/cf652d6fb9806d555b606deadf635191_normal.jpeg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/2689889308\\/cf652d6fb9806d555b606deadf635191_normal.jpeg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitter.com\\/download\\/iphone&quot;&gt;Twitter for iPhone&lt;\\/a&gt;\",\"text\":\"@werty_69 \\n\\n\\u0643\\u0646\\u062a \\u0627\\u0643\\u062a\\u0628 \\u0627\\u062e\\u062a\\u0627\\u0631 \\u0627\\u0644\\u0633\\u0648\\u0631\\u0629 \\u0627\\u0644\\u062a\\u064a \\u064a\\u0639\\u062c\\u0628\\u0643 \\u0633\\u0645\\u0627\\u0639\\u0647\\u0627 ...\",\"to_user\":\"werty_69\",\"to_user_id\":334545705,\"to_user_id_str\":\"334545705\",\"to_user_name\":\"sultan alfarraj\",\"in_reply_to_status_id\":314088750546292736,\"in_reply_to_status_id_str\":\"314088750546292736\"},{\"created_at\":\"Tue, 19 Mar 2013 19:03:41 +0000\",\"from_user\":\"DrAlaani\",\"from_user_id\":375506761,\"from_user_id_str\":\"375506761\",\"from_user_name\":\"\\u062f. \\u0646\\u0632\\u0627\\u0631 \\u0646\\u0632\\u0627\\u0631 \\u0627\\u0644\\u0639\\u0627\\u0646\\u064a\",\"geo\":null,\"id\":314089811407409153,\"id_str\":\"314089811407409153\",\"iso_language_code\":\"ar\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/2689889308\\/cf652d6fb9806d555b606deadf635191_normal.jpeg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/2689889308\\/cf652d6fb9806d555b606deadf635191_normal.jpeg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitter.com\\/download\\/iphone&quot;&gt;Twitter for iPhone&lt;\\/a&gt;\",\"text\":\"@werty_69 \\n\\n\\u0634\\u0643\\u0631\\u064b\\u0627 \\u0644\\u0644\\u0645\\u0644\\u0627\\u062d\\u0638\\u0629 \\u0623\\u062e\\u064a \\u0627\\u0644\\u0643\\u0631\\u064a\\u0645 \\u0641\\u0647\\u0648 \\u062e\\u0637\\u0623 \\u0625\\u0645\\u0644\\u0627\\u0626\\u064a \\u0644\\u0645 \\u0627\\u0646\\u062a\\u0628\\u0647 \\u0644\\u0647\",\"to_user\":\"werty_69\",\"to_user_id\":334545705,\"to_user_id_str\":\"334545705\",\"to_user_name\":\"sultan alfarraj\",\"in_reply_to_status_id\":314088750546292736,\"in_reply_to_status_id_str\":\"314088750546292736\"},{\"created_at\":\"Tue, 19 Mar 2013 18:52:22 +0000\",\"from_user\":\"werty_69\",\"from_user_id\":334545705,\"from_user_id_str\":\"334545705\",\"from_user_name\":\"sultan alfarraj\",\"geo\":null,\"id\":314086966280986624,\"id_str\":\"314086966280986624\",\"iso_language_code\":\"ar\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/3376745699\\/ff594a5d08e6af806a81c520027e64ee_normal.jpeg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/3376745699\\/ff594a5d08e6af806a81c520027e64ee_normal.jpeg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitter.com\\/download\\/iphone&quot;&gt;Twitter for iPhone&lt;\\/a&gt;\",\"text\":\"#\\u0627\\u0644\\u0642\\u0628\\u0636_\\u0639\\u0644\\u064918_\\u062c\\u0627\\u0633\\u0648\\u0633\\n\\n\\u0644\\u0644\\u0623\\u0645\\u0627\\u0646\\u0629 \\u0627\\u0646\\u0627 \\u0645\\u0627 \\u0642\\u062f\\u0631\\u062a \\u0627\\u0635\\u062f\\u0642 \\n\\u0648\\u0644\\u0648 \\u0643\\u0627\\u0646 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0628\\u064a\\u0639\\u0627\\u0642\\u0628\\u0648\\u0646 \\u0627\\u0644\\u0633\\u0639\\u0648\\u062f\\u064a\\u064a\\u0646\\n\\u0648\\u0639\\u0641\\u0648 \\u0645\\u0644\\u0643\\u064a \\u062d\\u0642  \\u0627\\u0644\\u0628\\u0627\\u0642\\u064a\\u0646 \\u0643\\u0627\\u0644\\u0639\\u0627\\u062f\\u0629\"},{\"created_at\":\"Tue, 19 Mar 2013 18:40:50 +0000\",\"from_user\":\"werty\",\"from_user_id\":777781,\"from_user_id_str\":\"777781\",\"from_user_name\":\"David Wertheimer\",\"geo\":null,\"id\":314084061197000704,\"id_str\":\"314084061197000704\",\"iso_language_code\":\"en\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/825780530\\/dw-tacos_bigger_normal.jpg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/825780530\\/dw-tacos_bigger_normal.jpg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitter.com\\/download\\/iphone&quot;&gt;Twitter for iPhone&lt;\\/a&gt;\",\"text\":\"@petershankman last time I was in there I got to try on a game-worn Jeter home jersey. Love it up there\",\"to_user\":\"petershankman\",\"to_user_id\":2569261,\"to_user_id_str\":\"2569261\",\"to_user_name\":\"Peter Shankman\",\"in_reply_to_status_id\":314053721044701185,\"in_reply_to_status_id_str\":\"314053721044701185\"},{\"created_at\":\"Tue, 19 Mar 2013 18:14:00 +0000\",\"from_user\":\"werty_69\",\"from_user_id\":334545705,\"from_user_id_str\":\"334545705\",\"from_user_name\":\"sultan alfarraj\",\"geo\":null,\"id\":314077308703084544,\"id_str\":\"314077308703084544\",\"iso_language_code\":\"ar\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/3376745699\\/ff594a5d08e6af806a81c520027e64ee_normal.jpeg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/3376745699\\/ff594a5d08e6af806a81c520027e64ee_normal.jpeg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitter.com\\/download\\/iphone&quot;&gt;Twitter for iPhone&lt;\\/a&gt;\",\"text\":\"\\u0627\\u0644\\u0623\\u0633\\u0628\\u0627\\u0628 \\u0644\\u0627 \\u062a\\u0646\\u062c\\u064a \\u0625\\u0644\\u0627 \\u0628\\u0627\\u0644\\u0644\\u0647\\u060c \\u0627\\u0644\\u0628\\u062d\\u0631 \\u0627\\u0644\\u0630\\u064a \\u0646\\u062c\\u0649 \\u0627\\u0644\\u0644\\u0647 \\u0645\\u0646\\u0647 \\u0645\\u0648\\u0633\\u0649 \\u0648\\u0647\\u0648 \\u0631\\u0636\\u064a\\u0639 \\u0647\\u0648 \\u0627\\u0644\\u0630\\u064a \\u0623\\u063a\\u0631\\u0642 \\u0641\\u064a\\u0647 \\u0641\\u0631\\u0639\\u0648\\u0646 \\u0648\\u0647\\u0648 \\u062c\\u0628\\u0627\\u0631.\\n(\\u0641\\u0644\\u064a\\u0644\\u0642\\u0647 \\u0627\\u0644\\u064a\\u0645 \\u0628\\u0627\\u0644\\u0633\\u0627\\u062d\\u0644)-(\\u0641\\u0623\\u063a\\u0631\\u0642\\u0646\\u0627\\u0647\\u0645 \\u0641\\u064a \\u0627\\u0644\\u064a\\u0645)\"},{\"created_at\":\"Tue, 19 Mar 2013 18:04:16 +0000\",\"from_user\":\"Jawaad_Hugs_Me\",\"from_user_id\":596629242,\"from_user_id_str\":\"596629242\",\"from_user_name\":\"william?\",\"geo\":null,\"id\":314074859678359552,\"id_str\":\"314074859678359552\",\"iso_language_code\":\"en\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/3400845981\\/08ae286d977b575ce57a28fe7bbe8fce_normal.jpeg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/3400845981\\/08ae286d977b575ce57a28fe7bbe8fce_normal.jpeg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitter.com\\/&quot;&gt;web&lt;\\/a&gt;\",\"text\":\"werty http:\\/\\/t.co\\/FnqCpo6YWi\"},{\"created_at\":\"Tue, 19 Mar 2013 16:57:11 +0000\",\"from_user\":\"_sougo_follow__\",\"from_user_id\":1024373904,\"from_user_id_str\":\"1024373904\",\"from_user_name\":\"\\u76f8\\u4e92\\u30d5\\u30a9\\u30ed\\u30fc100%\\u652f\\u63f4\\u30a2\\u30ab\\u30a6\\u30f3\\u30c8\",\"geo\":null,\"id\":314057979731275777,\"id_str\":\"314057979731275777\",\"iso_language_code\":\"en\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/3200734309\\/8ae6c035325b352cdfa80c974982a8c4_normal.png\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/3200734309\\/8ae6c035325b352cdfa80c974982a8c4_normal.png\",\"source\":\"&lt;a href=&quot;http:\\/\\/botmaker.dplays.net\\/&quot;&gt;BotMaker&lt;\\/a&gt;\",\"text\":\"@null werty\",\"to_user\":\"null\",\"to_user_id\":3562471,\"to_user_id_str\":\"3562471\",\"to_user_name\":\"not quite nothing\"},{\"created_at\":\"Tue, 19 Mar 2013 16:51:18 +0000\",\"from_user\":\"werty\",\"from_user_id\":777781,\"from_user_id_str\":\"777781\",\"from_user_name\":\"David Wertheimer\",\"geo\":null,\"id\":314056497053179905,\"id_str\":\"314056497053179905\",\"iso_language_code\":\"en\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/825780530\\/dw-tacos_bigger_normal.jpg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/825780530\\/dw-tacos_bigger_normal.jpg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitter.com\\/tweetbutton&quot;&gt;Tweet Button&lt;\\/a&gt;\",\"text\":\"\\u201c\\u2018He's on the roster, and he'll get a chance to compete,\\u2019 [Rex] Ryan said of [Tim] Tebow.\\u201d more #Jets #problemsolving http:\\/\\/t.co\\/ftMMkXd82o\"},{\"created_at\":\"Tue, 19 Mar 2013 16:35:13 +0000\",\"from_user\":\"lingfreerdir\",\"from_user_id\":354793789,\"from_user_id_str\":\"354793789\",\"from_user_name\":\"\\u041a\\u0441\\u044e\\u0448\\u0430 \\u0421\\u0451\\u043c\\u0438\\u043d\\u0430\",\"geo\":null,\"id\":314052450967506944,\"id_str\":\"314052450967506944\",\"iso_language_code\":\"und\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/1494525306\\/187_normal.jpg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/1494525306\\/187_normal.jpg\",\"source\":\"&lt;a href=&quot;https:\\/\\/twitter.com\\/kpv399&quot;&gt;\\u041f\\u0440\\u043e\\u0441\\u0442\\u043e \\u0438\\u043d\\u0442\\u0435\\u0440\\u0435\\u0441\\u043d\\u043e &lt;\\/a&gt;\",\"text\":\"http:\\/\\/t.co\\/lQTug2RDWR\"},{\"created_at\":\"Tue, 19 Mar 2013 16:25:39 +0000\",\"from_user\":\"fer_werty\",\"from_user_id\":1043531665,\"from_user_id_str\":\"1043531665\",\"from_user_name\":\"Fernanda Garcia \",\"geo\":null,\"id\":314050042799464448,\"id_str\":\"314050042799464448\",\"iso_language_code\":\"es\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/3035197105\\/5f12b480c6cd3559de37e3cf2419cb0a_normal.jpeg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/3035197105\\/5f12b480c6cd3559de37e3cf2419cb0a_normal.jpeg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitter.com\\/&quot;&gt;web&lt;\\/a&gt;\",\"text\":\"Y es que tengo el coraz\\u00f3n equivocado por quererte demasiado!\"}],\"results_per_page\":15,\"since_id\":0,\"since_id_str\":\"0\"});";
        response = "{\"completed_in\":0.02,\"max_id\":314141412667060224,\"max_id_str\":\"314141412667060224\",\"next_page\":\"?page=2&max_id=314141412667060224&q=werty\",\"page\":1,\"query\":\"werty\",\"refresh_url\":\"?since_id=314141412667060224&q=werty\",\"results\":[{\"created_at\":\"Tue, 19 Mar 2013 22:28:43 +0000\",\"from_user\":\"_sougo_follow__\",\"from_user_id\":1024373904,\"from_user_id_str\":\"1024373904\",\"from_user_name\":\"\\u76f8\\u4e92\\u30d5\\u30a9\\u30ed\\u30fc100%\\u652f\\u63f4\\u30a2\\u30ab\\u30a6\\u30f3\\u30c8\",\"geo\":null,\"id\":314141412667060224,\"id_str\":\"314141412667060224\",\"iso_language_code\":\"en\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/3200734309\\/8ae6c035325b352cdfa80c974982a8c4_normal.png\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/3200734309\\/8ae6c035325b352cdfa80c974982a8c4_normal.png\",\"source\":\"&lt;a href=&quot;http:\\/\\/botmaker.dplays.net\\/&quot;&gt;BotMaker&lt;\\/a&gt;\",\"text\":\"@null werty\",\"to_user\":\"null\",\"to_user_id\":3562471,\"to_user_id_str\":\"3562471\",\"to_user_name\":\"not quite nothing\"},{\"created_at\":\"Tue, 19 Mar 2013 22:00:17 +0000\",\"from_user\":\"bandr_18\",\"from_user_id\":352301144,\"from_user_id_str\":\"352301144\",\"from_user_name\":\"\\u0628\\u0646\\u062f\\u0631 \\u0628\\u0646 \\u0639\\u0628\\u062f\\u0627\\u0644\\u0644\\u0647 \",\"geo\":null,\"id\":314134253703143424,\"id_str\":\"314134253703143424\",\"iso_language_code\":\"ar\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/2719237368\\/1f47886a239e3044e6d3a541e723c732_normal.jpeg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/2719237368\\/1f47886a239e3044e6d3a541e723c732_normal.jpeg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitter.com\\/download\\/android&quot;&gt;Twitter for Android&lt;\\/a&gt;\",\"text\":\"RT @Dr_singing: @werty_69 #\\u062e\\u0637\\u0627\\u0628_\\u0627\\u0644\\u0639\\u0648\\u062f\\u0629_\\u064a\\u0645\\u062b\\u0644\\u0646\\u064a #\\u062e\\u0637\\u0627\\u0628_\\u0627\\u0644\\u0639\\u0648\\u062f\\u0629_\\u0644\\u0627\\u064a\\u0645\\u062b\\u0644\\u0646\\u064a \\u0644\\u0627 \\u0623\\u062d\\u062f \\u064a\\u0638\\u0646 \\u0623\\u0646 \\u0627\\u0644\\u0634\\u063a\\u0644\\u0647 \\u062a\\u0631\\u0642\\u064a\\u0645 \\u0627\\u0644\\u0639\\u0648\\u062f\\u0647 \\u0633\\u062f\\u062d \\u0627\\u0644\\u0631\\u0642\\u0645 \\u0644\\u064a\\u0646\\u0635\\u062d\\u0647\\u0627 \\u0628\\u062a\\u063a\\u0637\\u064a\\u0629 \\u0648\\u062c\\u0647\\u0647\\u0627  http:\\/\\/t.co\\/MKjqRuDyen\",\"in_reply_to_status_id\":312655907123261441,\"in_reply_to_status_id_str\":\"312655907123261441\"},{\"created_at\":\"Tue, 19 Mar 2013 20:18:01 +0000\",\"from_user\":\"Q__werty\",\"from_user_id\":575870843,\"from_user_id_str\":\"575870843\",\"from_user_name\":\"Mike Whirity\",\"geo\":null,\"id\":314108519366397953,\"id_str\":\"314108519366397953\",\"iso_language_code\":\"en\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/3032069009\\/77e5ed53cfac14470f7bda12bba0ced0_normal.jpeg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/3032069009\\/77e5ed53cfac14470f7bda12bba0ced0_normal.jpeg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitter.com\\/download\\/android&quot;&gt;Twitter for Android&lt;\\/a&gt;\",\"text\":\"@Kingsof_LEONard they just showed him and he wanted nothing to do with anyone\",\"to_user\":\"Kingsof_LEONard\",\"to_user_id\":59384044,\"to_user_id_str\":\"59384044\",\"to_user_name\":\"Ryan Leonard\",\"in_reply_to_status_id\":314108024329474048,\"in_reply_to_status_id_str\":\"314108024329474048\"},{\"created_at\":\"Tue, 19 Mar 2013 20:16:03 +0000\",\"from_user\":\"Kingsof_LEONard\",\"from_user_id\":59384044,\"from_user_id_str\":\"59384044\",\"from_user_name\":\"Ryan Leonard\",\"geo\":null,\"id\":314108024329474048,\"id_str\":\"314108024329474048\",\"iso_language_code\":\"en\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/3070239043\\/4d5e8f6d1a319a2ba077038e4c1227b9_normal.jpeg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/3070239043\\/4d5e8f6d1a319a2ba077038e4c1227b9_normal.jpeg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitter.com\\/download\\/iphone&quot;&gt;Twitter for iPhone&lt;\\/a&gt;\",\"text\":\"@Q__werty his interviews are hilauous\",\"to_user\":\"Q__werty\",\"to_user_id\":575870843,\"to_user_id_str\":\"575870843\",\"to_user_name\":\"Mike Whirity\",\"in_reply_to_status_id\":314106610454769664,\"in_reply_to_status_id_str\":\"314106610454769664\"},{\"created_at\":\"Tue, 19 Mar 2013 20:10:26 +0000\",\"from_user\":\"Q__werty\",\"from_user_id\":575870843,\"from_user_id_str\":\"575870843\",\"from_user_name\":\"Mike Whirity\",\"geo\":null,\"id\":314106610454769664,\"id_str\":\"314106610454769664\",\"iso_language_code\":\"en\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/3032069009\\/77e5ed53cfac14470f7bda12bba0ced0_normal.jpeg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/3032069009\\/77e5ed53cfac14470f7bda12bba0ced0_normal.jpeg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitter.com\\/download\\/android&quot;&gt;Twitter for Android&lt;\\/a&gt;\",\"text\":\"Bill Belichick knows he's better than everyone #beast\"},{\"created_at\":\"Tue, 19 Mar 2013 19:04:18 +0000\",\"from_user\":\"DrAlaani\",\"from_user_id\":375506761,\"from_user_id_str\":\"375506761\",\"from_user_name\":\"\\u062f. \\u0646\\u0632\\u0627\\u0631 \\u0646\\u0632\\u0627\\u0631 \\u0627\\u0644\\u0639\\u0627\\u0646\\u064a\",\"geo\":null,\"id\":314089968911937536,\"id_str\":\"314089968911937536\",\"iso_language_code\":\"ar\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/2689889308\\/cf652d6fb9806d555b606deadf635191_normal.jpeg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/2689889308\\/cf652d6fb9806d555b606deadf635191_normal.jpeg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitter.com\\/download\\/iphone&quot;&gt;Twitter for iPhone&lt;\\/a&gt;\",\"text\":\"@werty_69 \\n\\n\\u0643\\u0646\\u062a \\u0627\\u0643\\u062a\\u0628 \\u0627\\u062e\\u062a\\u0627\\u0631 \\u0627\\u0644\\u0633\\u0648\\u0631\\u0629 \\u0627\\u0644\\u062a\\u064a \\u064a\\u0639\\u062c\\u0628\\u0643 \\u0633\\u0645\\u0627\\u0639\\u0647\\u0627 ...\",\"to_user\":\"werty_69\",\"to_user_id\":334545705,\"to_user_id_str\":\"334545705\",\"to_user_name\":\"sultan alfarraj\",\"in_reply_to_status_id\":314088750546292736,\"in_reply_to_status_id_str\":\"314088750546292736\"},{\"created_at\":\"Tue, 19 Mar 2013 19:03:41 +0000\",\"from_user\":\"DrAlaani\",\"from_user_id\":375506761,\"from_user_id_str\":\"375506761\",\"from_user_name\":\"\\u062f. \\u0646\\u0632\\u0627\\u0631 \\u0646\\u0632\\u0627\\u0631 \\u0627\\u0644\\u0639\\u0627\\u0646\\u064a\",\"geo\":null,\"id\":314089811407409153,\"id_str\":\"314089811407409153\",\"iso_language_code\":\"ar\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/2689889308\\/cf652d6fb9806d555b606deadf635191_normal.jpeg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/2689889308\\/cf652d6fb9806d555b606deadf635191_normal.jpeg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitter.com\\/download\\/iphone&quot;&gt;Twitter for iPhone&lt;\\/a&gt;\",\"text\":\"@werty_69 \\n\\n\\u0634\\u0643\\u0631\\u064b\\u0627 \\u0644\\u0644\\u0645\\u0644\\u0627\\u062d\\u0638\\u0629 \\u0623\\u062e\\u064a \\u0627\\u0644\\u0643\\u0631\\u064a\\u0645 \\u0641\\u0647\\u0648 \\u062e\\u0637\\u0623 \\u0625\\u0645\\u0644\\u0627\\u0626\\u064a \\u0644\\u0645 \\u0627\\u0646\\u062a\\u0628\\u0647 \\u0644\\u0647\",\"to_user\":\"werty_69\",\"to_user_id\":334545705,\"to_user_id_str\":\"334545705\",\"to_user_name\":\"sultan alfarraj\",\"in_reply_to_status_id\":314088750546292736,\"in_reply_to_status_id_str\":\"314088750546292736\"},{\"created_at\":\"Tue, 19 Mar 2013 18:52:22 +0000\",\"from_user\":\"werty_69\",\"from_user_id\":334545705,\"from_user_id_str\":\"334545705\",\"from_user_name\":\"sultan alfarraj\",\"geo\":null,\"id\":314086966280986624,\"id_str\":\"314086966280986624\",\"iso_language_code\":\"ar\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/3376745699\\/ff594a5d08e6af806a81c520027e64ee_normal.jpeg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/3376745699\\/ff594a5d08e6af806a81c520027e64ee_normal.jpeg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitter.com\\/download\\/iphone&quot;&gt;Twitter for iPhone&lt;\\/a&gt;\",\"text\":\"#\\u0627\\u0644\\u0642\\u0628\\u0636_\\u0639\\u0644\\u064918_\\u062c\\u0627\\u0633\\u0648\\u0633\\n\\n\\u0644\\u0644\\u0623\\u0645\\u0627\\u0646\\u0629 \\u0627\\u0646\\u0627 \\u0645\\u0627 \\u0642\\u062f\\u0631\\u062a \\u0627\\u0635\\u062f\\u0642 \\n\\u0648\\u0644\\u0648 \\u0643\\u0627\\u0646 \\u062d\\u0642\\u064a\\u0642\\u0629 \\u0628\\u064a\\u0639\\u0627\\u0642\\u0628\\u0648\\u0646 \\u0627\\u0644\\u0633\\u0639\\u0648\\u062f\\u064a\\u064a\\u0646\\n\\u0648\\u0639\\u0641\\u0648 \\u0645\\u0644\\u0643\\u064a \\u062d\\u0642  \\u0627\\u0644\\u0628\\u0627\\u0642\\u064a\\u0646 \\u0643\\u0627\\u0644\\u0639\\u0627\\u062f\\u0629\"},{\"created_at\":\"Tue, 19 Mar 2013 18:40:50 +0000\",\"from_user\":\"werty\",\"from_user_id\":777781,\"from_user_id_str\":\"777781\",\"from_user_name\":\"David Wertheimer\",\"geo\":null,\"id\":314084061197000704,\"id_str\":\"314084061197000704\",\"iso_language_code\":\"en\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/825780530\\/dw-tacos_bigger_normal.jpg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/825780530\\/dw-tacos_bigger_normal.jpg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitter.com\\/download\\/iphone&quot;&gt;Twitter for iPhone&lt;\\/a&gt;\",\"text\":\"@petershankman last time I was in there I got to try on a game-worn Jeter home jersey. Love it up there\",\"to_user\":\"petershankman\",\"to_user_id\":2569261,\"to_user_id_str\":\"2569261\",\"to_user_name\":\"Peter Shankman\",\"in_reply_to_status_id\":314053721044701185,\"in_reply_to_status_id_str\":\"314053721044701185\"},{\"created_at\":\"Tue, 19 Mar 2013 18:14:00 +0000\",\"from_user\":\"werty_69\",\"from_user_id\":334545705,\"from_user_id_str\":\"334545705\",\"from_user_name\":\"sultan alfarraj\",\"geo\":null,\"id\":314077308703084544,\"id_str\":\"314077308703084544\",\"iso_language_code\":\"ar\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/3376745699\\/ff594a5d08e6af806a81c520027e64ee_normal.jpeg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/3376745699\\/ff594a5d08e6af806a81c520027e64ee_normal.jpeg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitter.com\\/download\\/iphone&quot;&gt;Twitter for iPhone&lt;\\/a&gt;\",\"text\":\"\\u0627\\u0644\\u0623\\u0633\\u0628\\u0627\\u0628 \\u0644\\u0627 \\u062a\\u0646\\u062c\\u064a \\u0625\\u0644\\u0627 \\u0628\\u0627\\u0644\\u0644\\u0647\\u060c \\u0627\\u0644\\u0628\\u062d\\u0631 \\u0627\\u0644\\u0630\\u064a \\u0646\\u062c\\u0649 \\u0627\\u0644\\u0644\\u0647 \\u0645\\u0646\\u0647 \\u0645\\u0648\\u0633\\u0649 \\u0648\\u0647\\u0648 \\u0631\\u0636\\u064a\\u0639 \\u0647\\u0648 \\u0627\\u0644\\u0630\\u064a \\u0623\\u063a\\u0631\\u0642 \\u0641\\u064a\\u0647 \\u0641\\u0631\\u0639\\u0648\\u0646 \\u0648\\u0647\\u0648 \\u062c\\u0628\\u0627\\u0631.\\n(\\u0641\\u0644\\u064a\\u0644\\u0642\\u0647 \\u0627\\u0644\\u064a\\u0645 \\u0628\\u0627\\u0644\\u0633\\u0627\\u062d\\u0644)-(\\u0641\\u0623\\u063a\\u0631\\u0642\\u0646\\u0627\\u0647\\u0645 \\u0641\\u064a \\u0627\\u0644\\u064a\\u0645)\"},{\"created_at\":\"Tue, 19 Mar 2013 18:04:16 +0000\",\"from_user\":\"Jawaad_Hugs_Me\",\"from_user_id\":596629242,\"from_user_id_str\":\"596629242\",\"from_user_name\":\"william?\",\"geo\":null,\"id\":314074859678359552,\"id_str\":\"314074859678359552\",\"iso_language_code\":\"en\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/3400845981\\/08ae286d977b575ce57a28fe7bbe8fce_normal.jpeg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/3400845981\\/08ae286d977b575ce57a28fe7bbe8fce_normal.jpeg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitter.com\\/&quot;&gt;web&lt;\\/a&gt;\",\"text\":\"werty http:\\/\\/t.co\\/FnqCpo6YWi\"},{\"created_at\":\"Tue, 19 Mar 2013 16:57:11 +0000\",\"from_user\":\"_sougo_follow__\",\"from_user_id\":1024373904,\"from_user_id_str\":\"1024373904\",\"from_user_name\":\"\\u76f8\\u4e92\\u30d5\\u30a9\\u30ed\\u30fc100%\\u652f\\u63f4\\u30a2\\u30ab\\u30a6\\u30f3\\u30c8\",\"geo\":null,\"id\":314057979731275777,\"id_str\":\"314057979731275777\",\"iso_language_code\":\"en\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/3200734309\\/8ae6c035325b352cdfa80c974982a8c4_normal.png\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/3200734309\\/8ae6c035325b352cdfa80c974982a8c4_normal.png\",\"source\":\"&lt;a href=&quot;http:\\/\\/botmaker.dplays.net\\/&quot;&gt;BotMaker&lt;\\/a&gt;\",\"text\":\"@null werty\",\"to_user\":\"null\",\"to_user_id\":3562471,\"to_user_id_str\":\"3562471\",\"to_user_name\":\"not quite nothing\"},{\"created_at\":\"Tue, 19 Mar 2013 16:51:18 +0000\",\"from_user\":\"werty\",\"from_user_id\":777781,\"from_user_id_str\":\"777781\",\"from_user_name\":\"David Wertheimer\",\"geo\":null,\"id\":314056497053179905,\"id_str\":\"314056497053179905\",\"iso_language_code\":\"en\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/825780530\\/dw-tacos_bigger_normal.jpg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/825780530\\/dw-tacos_bigger_normal.jpg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitter.com\\/tweetbutton&quot;&gt;Tweet Button&lt;\\/a&gt;\",\"text\":\"\\u201c\\u2018He's on the roster, and he'll get a chance to compete,\\u2019 [Rex] Ryan said of [Tim] Tebow.\\u201d more #Jets #problemsolving http:\\/\\/t.co\\/ftMMkXd82o\"},{\"created_at\":\"Tue, 19 Mar 2013 16:35:13 +0000\",\"from_user\":\"lingfreerdir\",\"from_user_id\":354793789,\"from_user_id_str\":\"354793789\",\"from_user_name\":\"\\u041a\\u0441\\u044e\\u0448\\u0430 \\u0421\\u0451\\u043c\\u0438\\u043d\\u0430\",\"geo\":null,\"id\":314052450967506944,\"id_str\":\"314052450967506944\",\"iso_language_code\":\"und\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/1494525306\\/187_normal.jpg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/1494525306\\/187_normal.jpg\",\"source\":\"&lt;a href=&quot;https:\\/\\/twitter.com\\/kpv399&quot;&gt;\\u041f\\u0440\\u043e\\u0441\\u0442\\u043e \\u0438\\u043d\\u0442\\u0435\\u0440\\u0435\\u0441\\u043d\\u043e &lt;\\/a&gt;\",\"text\":\"http:\\/\\/t.co\\/lQTug2RDWR\"},{\"created_at\":\"Tue, 19 Mar 2013 16:25:39 +0000\",\"from_user\":\"fer_werty\",\"from_user_id\":1043531665,\"from_user_id_str\":\"1043531665\",\"from_user_name\":\"Fernanda Garcia \",\"geo\":null,\"id\":314050042799464448,\"id_str\":\"314050042799464448\",\"iso_language_code\":\"es\",\"metadata\":{\"result_type\":\"recent\"},\"profile_image_url\":\"http:\\/\\/a0.twimg.com\\/profile_images\\/3035197105\\/5f12b480c6cd3559de37e3cf2419cb0a_normal.jpeg\",\"profile_image_url_https\":\"https:\\/\\/si0.twimg.com\\/profile_images\\/3035197105\\/5f12b480c6cd3559de37e3cf2419cb0a_normal.jpeg\",\"source\":\"&lt;a href=&quot;http:\\/\\/twitter.com\\/&quot;&gt;web&lt;\\/a&gt;\",\"text\":\"Y es que tengo el coraz\\u00f3n equivocado por quererte demasiado!\"}],\"results_per_page\":15,\"since_id\":0,\"since_id_str\":\"0\"}";
        assertEquals(response, ModelItem.getJSONPResponse(data));


        data = "jQuery17209219797009136528_1363731838379({\n" +
"  \"meta\": {\n" +
"    \"X-RateLimit-Limit\": \"60\",\n" +
"    \"X-RateLimit-Remaining\": \"56\",\n" +
"    \"X-GitHub-Media-Type\": \"github.beta\",\n" +
"    \"status\": 200\n" +
"  },\n" +
"  \"data\": [\n" +
"    {\n" +
"      \"login\": \"wagenet\",\n" +
"      \"id\": 9835,\n" +
"      \"avatar_url\": \"https://secure.gravatar.com/avatar/88a1521be4c8a667dbb7d61e68cc0668?d=https://a248.e.akamai.net/assets.github.com%2Fimages%2Fgravatars%2Fgravatar-user-420.png\",\n" +
"      \"gravatar_id\": \"88a1521be4c8a667dbb7d61e68cc0668\",\n" +
"      \"url\": \"https://api.github.com/users/wagenet\",\n" +
"      \"html_url\": \"https://github.com/wagenet\",\n" +
"      \"followers_url\": \"https://api.github.com/users/wagenet/followers\",\n" +
"      \"following_url\": \"https://api.github.com/users/wagenet/following\",\n" +
"      \"gists_url\": \"https://api.github.com/users/wagenet/gists{/gist_id}\",\n" +
"      \"starred_url\": \"https://api.github.com/users/wagenet/starred{/owner}{/repo}\",\n" +
"      \"subscriptions_url\": \"https://api.github.com/users/wagenet/subscriptions\",\n" +
"      \"organizations_url\": \"https://api.github.com/users/wagenet/orgs\",\n" +
"      \"repos_url\": \"https://api.github.com/users/wagenet/repos\",\n" +
"      \"events_url\": \"https://api.github.com/users/wagenet/events{/privacy}\",\n" +
"      \"received_events_url\": \"https://api.github.com/users/wagenet/received_events\",\n" +
"      \"type\": \"User\",\n" +
"      \"contributions\": 918\n" +
"    },\n" +
"    {\n" +
"      \"login\": \"wycats\",\n" +
"      \"id\": 4,\n" +
"      \"avatar_url\": \"https://secure.gravatar.com/avatar/428167a3ec72235ba971162924492609?d=https://a248.e.akamai.net/assets.github.com%2Fimages%2Fgravatars%2Fgravatar-user-420.png\",\n" +
"      \"gravatar_id\": \"428167a3ec72235ba971162924492609\",\n" +
"      \"url\": \"https://api.github.com/users/wycats\",\n" +
"      \"html_url\": \"https://github.com/wycats\",\n" +
"      \"followers_url\": \"https://api.github.com/users/wycats/followers\",\n" +
"      \"following_url\": \"https://api.github.com/users/wycats/following\",\n" +
"      \"gists_url\": \"https://api.github.com/users/wycats/gists{/gist_id}\",\n" +
"      \"starred_url\": \"https://api.github.com/users/wycats/starred{/owner}{/repo}\",\n" +
"      \"subscriptions_url\": \"https://api.github.com/users/wycats/subscriptions\",\n" +
"      \"organizations_url\": \"https://api.github.com/users/wycats/orgs\",\n" +
"      \"repos_url\": \"https://api.github.com/users/wycats/repos\",\n" +
"      \"events_url\": \"https://api.github.com/users/wycats/events{/privacy}\",\n" +
"      \"received_events_url\": \"https://api.github.com/users/wycats/received_events\",\n" +
"      \"type\": \"User\",\n" +
"      \"contributions\": 448\n" +
"    }\n" +
"  ]\n" +
"})\n";
        response = "{\n" +
"  \"meta\": {\n" +
"    \"X-RateLimit-Limit\": \"60\",\n" +
"    \"X-RateLimit-Remaining\": \"56\",\n" +
"    \"X-GitHub-Media-Type\": \"github.beta\",\n" +
"    \"status\": 200\n" +
"  },\n" +
"  \"data\": [\n" +
"    {\n" +
"      \"login\": \"wagenet\",\n" +
"      \"id\": 9835,\n" +
"      \"avatar_url\": \"https://secure.gravatar.com/avatar/88a1521be4c8a667dbb7d61e68cc0668?d=https://a248.e.akamai.net/assets.github.com%2Fimages%2Fgravatars%2Fgravatar-user-420.png\",\n" +
"      \"gravatar_id\": \"88a1521be4c8a667dbb7d61e68cc0668\",\n" +
"      \"url\": \"https://api.github.com/users/wagenet\",\n" +
"      \"html_url\": \"https://github.com/wagenet\",\n" +
"      \"followers_url\": \"https://api.github.com/users/wagenet/followers\",\n" +
"      \"following_url\": \"https://api.github.com/users/wagenet/following\",\n" +
"      \"gists_url\": \"https://api.github.com/users/wagenet/gists{/gist_id}\",\n" +
"      \"starred_url\": \"https://api.github.com/users/wagenet/starred{/owner}{/repo}\",\n" +
"      \"subscriptions_url\": \"https://api.github.com/users/wagenet/subscriptions\",\n" +
"      \"organizations_url\": \"https://api.github.com/users/wagenet/orgs\",\n" +
"      \"repos_url\": \"https://api.github.com/users/wagenet/repos\",\n" +
"      \"events_url\": \"https://api.github.com/users/wagenet/events{/privacy}\",\n" +
"      \"received_events_url\": \"https://api.github.com/users/wagenet/received_events\",\n" +
"      \"type\": \"User\",\n" +
"      \"contributions\": 918\n" +
"    },\n" +
"    {\n" +
"      \"login\": \"wycats\",\n" +
"      \"id\": 4,\n" +
"      \"avatar_url\": \"https://secure.gravatar.com/avatar/428167a3ec72235ba971162924492609?d=https://a248.e.akamai.net/assets.github.com%2Fimages%2Fgravatars%2Fgravatar-user-420.png\",\n" +
"      \"gravatar_id\": \"428167a3ec72235ba971162924492609\",\n" +
"      \"url\": \"https://api.github.com/users/wycats\",\n" +
"      \"html_url\": \"https://github.com/wycats\",\n" +
"      \"followers_url\": \"https://api.github.com/users/wycats/followers\",\n" +
"      \"following_url\": \"https://api.github.com/users/wycats/following\",\n" +
"      \"gists_url\": \"https://api.github.com/users/wycats/gists{/gist_id}\",\n" +
"      \"starred_url\": \"https://api.github.com/users/wycats/starred{/owner}{/repo}\",\n" +
"      \"subscriptions_url\": \"https://api.github.com/users/wycats/subscriptions\",\n" +
"      \"organizations_url\": \"https://api.github.com/users/wycats/orgs\",\n" +
"      \"repos_url\": \"https://api.github.com/users/wycats/repos\",\n" +
"      \"events_url\": \"https://api.github.com/users/wycats/events{/privacy}\",\n" +
"      \"received_events_url\": \"https://api.github.com/users/wycats/received_events\",\n" +
"      \"type\": \"User\",\n" +
"      \"contributions\": 448\n" +
"    }\n" +
"  ]\n" +
"}";
        assertEquals(response, ModelItem.getJSONPResponse(data));
    }

}