<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [puppeteer](./puppeteer.md) &gt; [HTTPRequest](./puppeteer.httprequest.md) &gt; [continue](./puppeteer.httprequest.continue.md)

## HTTPRequest.continue() method

Continues request with optional request overrides.

<b>Signature:</b>

```typescript
continue(overrides?: ContinueRequestOverrides, priority?: number): Promise<void>;
```

## Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  overrides | [ContinueRequestOverrides](./puppeteer.continuerequestoverrides.md) | optional overrides to apply to the request. |
|  priority | number | If provided, intercept is resolved using cooperative handling rules. Otherwise, intercept is resolved immediately. |

<b>Returns:</b>

Promise&lt;void&gt;

## Remarks

To use this, request interception should be enabled with [Page.setRequestInterception()](./puppeteer.page.setrequestinterception.md).

Exception is immediately thrown if the request interception is not enabled.

## Example


```js
await page.setRequestInterception(true);
page.on('request', request => {
  // Override headers
  const headers = Object.assign({}, request.headers(), {
    foo: 'bar', // set "foo" header
    origin: undefined, // remove "origin" header
  });
  request.continue({headers});
});

```

