#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "todo_interface.h"
#include "i18n.h"

GtkWidget*
create_add_task (void)
{
  GtkWidget *add_task;
  GtkWidget *vbox_top;
  GtkWidget *hbuttonbox;
  GtkWidget *button, *vseparator, *checkbutton, *spinbutton;
  GtkWidget *notebook;
  GtkWidget *vbox_top_basic;
  GtkWidget *table;
  GtkWidget *label;
  GtkWidget *hbox_be;
  GtkWidget *hbox29;
  GtkWidget *alignment;
  GtkWidget *vbox6;
  GtkWidget *hbox_cp;
  GtkWidget *combobox;
  GtkWidget *entry;
  GtkWidget *hbox_sum;
  GtkWidget *image;
  GtkWidget *scrolledwindow;
  GtkWidget *textview;
  GtkWidget *hbox_label_basic;
  GtkWidget *vbox_top_advanced;
  GtkWidget *hbox56;
  GtkWidget *frame;
  GtkWidget *hbox57;
  GtkWidget *hbox58;
  GtkWidget *vbox15;
  GtkWidget *hbox59;
  GtkWidget *vbox13;
  GtkWidget *hbox49;
  GtkWidget *vbox12;
  GtkWidget *hbox_label_advanced;
  GtkWidget *vbox_top_recurrency;
  GtkWidget *hbox52;
  GtkWidget *hbox60;
  GtkWidget *table20;
  GtkWidget *table19;
  GtkWidget *hbox61;
  GtkWidget *hbox_label_recurrency;
	GtkObject *adjustment;

  add_task = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_container_set_border_width (GTK_CONTAINER (add_task), 8);
  gtk_window_set_title (GTK_WINDOW (add_task), _("Add Task/Event"));

  vbox_top = gtk_vbox_new (FALSE, 8);
  gtk_container_add (GTK_CONTAINER (add_task), vbox_top);

  hbuttonbox = gtk_hbutton_box_new ();
  gtk_box_pack_end (GTK_BOX (vbox_top), hbuttonbox, FALSE, FALSE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox), GTK_BUTTONBOX_END);
  gtk_box_set_spacing (GTK_BOX (hbuttonbox), 8);

  button = gtk_button_new_from_stock ("gtk-cancel");
  gtk_container_add (GTK_CONTAINER (hbuttonbox), button);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);

  button = gtk_button_new_from_stock ("gtk-ok");
  gtk_container_add (GTK_CONTAINER (hbuttonbox), button);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);

  notebook = gtk_notebook_new ();
  gtk_box_pack_start (GTK_BOX (vbox_top), notebook, TRUE, TRUE, 0);

  vbox_top_basic = gtk_vbox_new (FALSE, 8);
  gtk_container_add (GTK_CONTAINER (notebook), vbox_top_basic);
  gtk_notebook_set_tab_label_packing (GTK_NOTEBOOK (notebook), vbox_top_basic,
                                      FALSE, FALSE, GTK_PACK_START);
  gtk_container_set_border_width (GTK_CONTAINER (vbox_top_basic), 8);

  table = gtk_table_new (4, 2, FALSE);
  gtk_box_pack_start (GTK_BOX (vbox_top_basic), table, FALSE, TRUE, 0);
  gtk_table_set_row_spacings (GTK_TABLE (table), 8);
  gtk_table_set_col_spacings (GTK_TABLE (table), 8);

  label = gtk_label_new (_("<b>Summary:</b>"));
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  label = gtk_label_new_with_mnemonic (_("<b>Begin:</b>"));
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  hbox_be = gtk_hbox_new (FALSE, 8);
  gtk_table_attach (GTK_TABLE (table), hbox_be, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  button = gtk_button_new ();
  gtk_box_pack_start (GTK_BOX (hbox_be), button, TRUE, TRUE, 0);

  alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_container_add (GTK_CONTAINER (button), alignment);

  hbox29 = gtk_hbox_new (FALSE, 2);
  gtk_container_add (GTK_CONTAINER (alignment), hbox29);

  vbox6 = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox29), vbox6, FALSE, FALSE, 0);

  label = gtk_label_new (_("13:45.00"));
  gtk_box_pack_start (GTK_BOX (vbox6), label, FALSE, FALSE, 0);

  label = gtk_label_new (_("13.07.2009"));
  gtk_box_pack_start (GTK_BOX (vbox6), label, FALSE, FALSE, 0);

  label = gtk_label_new_with_mnemonic (_("<b>End:</b>"));
  gtk_box_pack_start (GTK_BOX (hbox_be), label, FALSE, FALSE, 0);
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  button = gtk_button_new_with_mnemonic (_("No date"));
  gtk_box_pack_start (GTK_BOX (hbox_be), button, TRUE, TRUE, 0);

  label = gtk_label_new (_("<b>Tags:</b>"));
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  label = gtk_label_new (_("<b>Category:</b>"));
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);

  hbox_cp = gtk_hbox_new (FALSE, 8);
  gtk_table_attach (GTK_TABLE (table), hbox_cp, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  combobox = gtk_combo_box_new_text ();
  gtk_box_pack_start (GTK_BOX (hbox_cp), combobox, TRUE, TRUE, 0);
  gtk_combo_box_append_text (GTK_COMBO_BOX (combobox), _("Sport"));

  label = gtk_label_new (_("<b>Priority:</b>"));
  gtk_box_pack_start (GTK_BOX (hbox_cp), label, FALSE, FALSE, 0);
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);

  combobox = gtk_combo_box_new_text ();
  gtk_box_pack_start (GTK_BOX (hbox_cp), combobox, TRUE, TRUE, 0);
  gtk_combo_box_append_text (GTK_COMBO_BOX (combobox), _("Medium"));

  entry = gtk_entry_new ();
  gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_text (GTK_ENTRY (entry), _("dom, wakacje"));
  gtk_entry_set_invisible_char (GTK_ENTRY (entry), 8226);

  hbox_sum = gtk_hbox_new (FALSE, 8);
  gtk_table_attach (GTK_TABLE (table), hbox_sum, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  entry = gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX (hbox_sum), entry, TRUE, TRUE, 0);
  gtk_entry_set_text (GTK_ENTRY (entry), _("zadanko"));
  gtk_entry_set_invisible_char (GTK_ENTRY (entry), 8226);

  image = gtk_image_new_from_stock ("gtk-apply", GTK_ICON_SIZE_BUTTON);
  gtk_box_pack_start (GTK_BOX (hbox_sum), image, FALSE, FALSE, 0);

  label = gtk_label_new (_("<b>Description:</b>"));
  gtk_box_pack_start (GTK_BOX (vbox_top_basic), label, FALSE, FALSE, 0);
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_box_pack_start (GTK_BOX (vbox_top_basic), scrolledwindow, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow), GTK_POLICY_NEVER, GTK_POLICY_NEVER);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scrolledwindow), GTK_SHADOW_IN);

  textview = gtk_text_view_new ();
  gtk_container_add (GTK_CONTAINER (scrolledwindow), textview);

  hbox_label_basic = gtk_hbox_new (FALSE, 0);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 0), hbox_label_basic);

  image = gtk_image_new_from_stock ("gtk-properties", GTK_ICON_SIZE_BUTTON);
  gtk_box_pack_start (GTK_BOX (hbox_label_basic), image, TRUE, TRUE, 0);

  label = gtk_label_new (_("Basic"));
  gtk_box_pack_start (GTK_BOX (hbox_label_basic), label, FALSE, FALSE, 0);
  gtk_widget_show_all (hbox_label_basic);

  vbox_top_advanced = gtk_vbox_new (FALSE, 8);
  gtk_container_add (GTK_CONTAINER (notebook), vbox_top_advanced);
  gtk_container_set_border_width (GTK_CONTAINER (vbox_top_advanced), 8);

  hbox56 = gtk_hbox_new (FALSE, 8);
  gtk_box_pack_start (GTK_BOX (vbox_top_advanced), hbox56, FALSE, FALSE, 0);

  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (hbox56), frame, TRUE, TRUE, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_NONE);

  alignment = gtk_alignment_new (0.5, 0.5, 1, 1);
  gtk_container_add (GTK_CONTAINER (frame), alignment);
  gtk_alignment_set_padding (GTK_ALIGNMENT (alignment), 4, 0, 12, 0);

  hbox57 = gtk_hbox_new (FALSE, 8);
  gtk_container_add (GTK_CONTAINER (alignment), hbox57);

  button = gtk_button_new ();
  gtk_box_pack_start (GTK_BOX (hbox57), button, TRUE, TRUE, 0);

  alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_container_add (GTK_CONTAINER (button), alignment);

  hbox58 = gtk_hbox_new (FALSE, 2);
  gtk_container_add (GTK_CONTAINER (alignment), hbox58);

  vbox15 = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox58), vbox15, FALSE, FALSE, 0);

  label = gtk_label_new (_("13:45.00"));
  gtk_box_pack_start (GTK_BOX (vbox15), label, FALSE, FALSE, 0);

  label = gtk_label_new (_("13.07.2009"));
  gtk_box_pack_start (GTK_BOX (vbox15), label, FALSE, FALSE, 0);

  label = gtk_label_new_with_mnemonic (_("<b>Alarm warning:</b>"));
  gtk_frame_set_label_widget (GTK_FRAME (frame), label);
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  vseparator = gtk_vseparator_new ();
  gtk_box_pack_start (GTK_BOX (hbox56), vseparator, TRUE, TRUE, 0);

  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (hbox56), frame, TRUE, TRUE, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_NONE);

  alignment = gtk_alignment_new (0.5, 0.5, 1, 1);
  gtk_container_add (GTK_CONTAINER (frame), alignment);
  gtk_alignment_set_padding (GTK_ALIGNMENT (alignment), 4, 0, 12, 0);

  hbox59 = gtk_hbox_new (FALSE, 8);
  gtk_container_add (GTK_CONTAINER (alignment), hbox59);

  adjustment = gtk_adjustment_new (0, 0, 100, 1, 10, 10);
  spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (adjustment), 1, 0);
  gtk_box_pack_start (GTK_BOX (hbox59), spinbutton, FALSE, TRUE, 0);

  label = gtk_label_new (_("minutes"));
  gtk_box_pack_start (GTK_BOX (hbox59), label, TRUE, TRUE, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  label = gtk_label_new (_("<b>Postpone time:</b>"));
  gtk_frame_set_label_widget (GTK_FRAME (frame), label);
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);

  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (vbox_top_advanced), frame, FALSE, FALSE, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_NONE);

  alignment = gtk_alignment_new (0.5, 0.5, 1, 1);
  gtk_container_add (GTK_CONTAINER (frame), alignment);
  gtk_alignment_set_padding (GTK_ALIGNMENT (alignment), 4, 0, 12, 0);

  vbox13 = gtk_vbox_new (FALSE, 4);
  gtk_container_add (GTK_CONTAINER (alignment), vbox13);

  hbox49 = gtk_hbox_new (FALSE, 8);
  gtk_box_pack_start (GTK_BOX (vbox13), hbox49, TRUE, TRUE, 0);

  entry = gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX (hbox49), entry, TRUE, TRUE, 0);
  gtk_entry_set_invisible_char (GTK_ENTRY (entry), 8226);

  image = gtk_image_new_from_stock ("gtk-apply", GTK_ICON_SIZE_BUTTON);
  gtk_box_pack_start (GTK_BOX (hbox49), image, FALSE, FALSE, 0);

  checkbutton = gtk_check_button_new_with_mnemonic (_("Save data before running command"));
  gtk_box_pack_start (GTK_BOX (vbox13), checkbutton, FALSE, FALSE, 0);

  label = gtk_label_new (_("<b>Command to run:</b>"));
  gtk_frame_set_label_widget (GTK_FRAME (frame), label);
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);

  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (vbox_top_advanced), frame, FALSE, FALSE, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_NONE);

  alignment = gtk_alignment_new (0.5, 0.5, 1, 1);
  gtk_container_add (GTK_CONTAINER (frame), alignment);
  gtk_alignment_set_padding (GTK_ALIGNMENT (alignment), 4, 0, 12, 0);

  vbox12 = gtk_vbox_new (FALSE, 4);
  gtk_container_add (GTK_CONTAINER (alignment), vbox12);

  checkbutton = gtk_check_button_new_with_mnemonic (_("Sound notification"));
  gtk_box_pack_start (GTK_BOX (vbox12), checkbutton, FALSE, FALSE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton), TRUE);

  checkbutton = gtk_check_button_new_with_mnemonic (_("Visual notification"));
  gtk_box_pack_start (GTK_BOX (vbox12), checkbutton, FALSE, FALSE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton), TRUE);

  checkbutton = gtk_check_button_new_with_mnemonic (_("Ignore alarm when task expired offline"));
  gtk_box_pack_start (GTK_BOX (vbox12), checkbutton, FALSE, FALSE, 0);

  checkbutton = gtk_check_button_new_with_mnemonic (_("Activate"));
  gtk_box_pack_start (GTK_BOX (vbox12), checkbutton, FALSE, FALSE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton), TRUE);

  label = gtk_label_new (_("<b>Miscellaneous:</b>"));
  gtk_frame_set_label_widget (GTK_FRAME (frame), label);
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  hbox_label_advanced = gtk_hbox_new (FALSE, 0);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 1), hbox_label_advanced);

  image = gtk_image_new_from_stock ("gtk-preferences", GTK_ICON_SIZE_BUTTON);
  gtk_box_pack_start (GTK_BOX (hbox_label_advanced), image, TRUE, TRUE, 0);

  label = gtk_label_new (_("Advanced"));
  gtk_box_pack_start (GTK_BOX (hbox_label_advanced), label, FALSE, FALSE, 0);
  gtk_widget_show_all (hbox_label_advanced);

  vbox_top_recurrency = gtk_vbox_new (FALSE, 8);
  gtk_container_add (GTK_CONTAINER (notebook), vbox_top_recurrency);
  gtk_container_set_border_width (GTK_CONTAINER (vbox_top_recurrency), 8);

  hbox52 = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox_top_recurrency), hbox52, FALSE, FALSE, 0);

  checkbutton = gtk_check_button_new_with_mnemonic (_("Enable recurrency"));
  gtk_box_pack_start (GTK_BOX (hbox52), checkbutton, FALSE, FALSE, 0);

  image = gtk_image_new_from_stock ("gtk-apply", GTK_ICON_SIZE_BUTTON);
  gtk_box_pack_end (GTK_BOX (hbox52), image, FALSE, FALSE, 0);

  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (vbox_top_recurrency), frame, FALSE, FALSE, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_NONE);

  alignment = gtk_alignment_new (0.5, 0.5, 1, 1);
  gtk_container_add (GTK_CONTAINER (frame), alignment);
  gtk_alignment_set_padding (GTK_ALIGNMENT (alignment), 4, 0, 12, 0);

  hbox60 = gtk_hbox_new (FALSE, 8);
  gtk_container_add (GTK_CONTAINER (alignment), hbox60);

  adjustment = gtk_adjustment_new (0, 0, 100, 1, 10, 0);
  spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (adjustment), 1, 0);
  gtk_box_pack_start (GTK_BOX (hbox60), spinbutton, FALSE, FALSE, 0);

  label = gtk_label_new (_("days"));
  gtk_box_pack_start (GTK_BOX (hbox60), label, FALSE, FALSE, 0);

  adjustment = gtk_adjustment_new (0, 0, 100, 1, 10, 0);
  spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (adjustment), 1, 0);
  gtk_box_pack_start (GTK_BOX (hbox60), spinbutton, FALSE, FALSE, 0);

  label = gtk_label_new (_("months"));
  gtk_box_pack_start (GTK_BOX (hbox60), label, FALSE, FALSE, 0);

  label = gtk_label_new (_("<b>Date interval:</b>"));
  gtk_frame_set_label_widget (GTK_FRAME (frame), label);
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (vbox_top_recurrency), frame, FALSE, FALSE, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_NONE);

  alignment = gtk_alignment_new (0.5, 0.5, 1, 1);
  gtk_container_add (GTK_CONTAINER (frame), alignment);
  gtk_alignment_set_padding (GTK_ALIGNMENT (alignment), 4, 0, 12, 0);

  table20 = gtk_table_new (2, 3, FALSE);
  gtk_container_add (GTK_CONTAINER (alignment), table20);
  gtk_table_set_row_spacings (GTK_TABLE (table20), 2);
  gtk_table_set_col_spacings (GTK_TABLE (table20), 8);

  button = gtk_button_new_with_mnemonic (_("00:00.00"));
  gtk_table_attach (GTK_TABLE (table20), button, 2, 3, 1, 2,
                    (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);

  button = gtk_button_new_with_mnemonic (_("23:59.00"));
  gtk_table_attach (GTK_TABLE (table20), button, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);

  label = gtk_label_new (_("<small>Begin at:</small>"));
  gtk_table_attach (GTK_TABLE (table20), label, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  label = gtk_label_new (_("End at:"));
  gtk_table_attach (GTK_TABLE (table20), label, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  label = gtk_label_new (_("Interval:"));
  gtk_table_attach (GTK_TABLE (table20), label, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  button = gtk_button_new_with_mnemonic (_("00:00.00"));
  gtk_table_attach (GTK_TABLE (table20), button, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);

  label = gtk_label_new (_("<b>Time period:</b>"));
  gtk_frame_set_label_widget (GTK_FRAME (frame), label);
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (vbox_top_recurrency), frame, FALSE, TRUE, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_NONE);

  alignment = gtk_alignment_new (0.5, 0.5, 1, 1);
  gtk_container_add (GTK_CONTAINER (frame), alignment);
  gtk_alignment_set_padding (GTK_ALIGNMENT (alignment), 4, 0, 12, 0);

  table19 = gtk_table_new (2, 4, FALSE);
  gtk_container_add (GTK_CONTAINER (alignment), table19);
  gtk_table_set_row_spacings (GTK_TABLE (table19), 4);
  gtk_table_set_col_spacings (GTK_TABLE (table19), 8);

  checkbutton = gtk_check_button_new_with_mnemonic (_("Tuesday"));
  gtk_table_attach (GTK_TABLE (table19), checkbutton, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton), TRUE);

  checkbutton = gtk_check_button_new_with_mnemonic (_("Friday"));
  gtk_table_attach (GTK_TABLE (table19), checkbutton, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton), TRUE);

  checkbutton = gtk_check_button_new_with_mnemonic (_("Saturday"));
  gtk_table_attach (GTK_TABLE (table19), checkbutton, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton), TRUE);

  checkbutton = gtk_check_button_new_with_mnemonic (_("Wednesday"));
  gtk_table_attach (GTK_TABLE (table19), checkbutton, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton), TRUE);

  checkbutton = gtk_check_button_new_with_mnemonic (_("Thursday"));
  gtk_table_attach (GTK_TABLE (table19), checkbutton, 3, 4, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton), TRUE);

  checkbutton = gtk_check_button_new_with_mnemonic (_("Sunday"));
  gtk_table_attach (GTK_TABLE (table19), checkbutton, 2, 3, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton), TRUE);

  label = gtk_label_new ("");
  gtk_table_attach (GTK_TABLE (table19), label, 3, 4, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  checkbutton = gtk_check_button_new_with_mnemonic (_("Monday"));
  gtk_table_attach (GTK_TABLE (table19), checkbutton, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton), TRUE);

  label = gtk_label_new (_("<b>Alarm only on the following days:</b>"));
  gtk_frame_set_label_widget (GTK_FRAME (frame), label);
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (vbox_top_recurrency), frame, FALSE, TRUE, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_NONE);

  alignment = gtk_alignment_new (0.5, 0.5, 1, 1);
  gtk_container_add (GTK_CONTAINER (frame), alignment);
  gtk_alignment_set_padding (GTK_ALIGNMENT (alignment), 4, 0, 12, 0);

  hbox61 = gtk_hbox_new (FALSE, 8);
  gtk_container_add (GTK_CONTAINER (alignment), hbox61);

  adjustment = gtk_adjustment_new (0, 0, 100, 1, 10, 0);
  spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (adjustment), 1, 0);
  gtk_box_pack_start (GTK_BOX (hbox61), spinbutton, FALSE, FALSE, 0);

  label = gtk_label_new (_("cyles (0 for infinity)"));
  gtk_box_pack_start (GTK_BOX (hbox61), label, FALSE, FALSE, 0);

  label = gtk_label_new (_("<b>Miscellaneous:</b>"));
  gtk_frame_set_label_widget (GTK_FRAME (frame), label);
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  hbox_label_recurrency = gtk_hbox_new (FALSE, 0);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 2), hbox_label_recurrency);

  image = gtk_image_new_from_stock ("gtk-refresh", GTK_ICON_SIZE_BUTTON);
  gtk_box_pack_start (GTK_BOX (hbox_label_recurrency), image, TRUE, TRUE, 0);

  label = gtk_label_new (_("Recurrency"));
  gtk_box_pack_start (GTK_BOX (hbox_label_recurrency), label, FALSE, FALSE, 0);
  gtk_widget_show_all (hbox_label_recurrency);

  gtk_label_set_mnemonic_widget (GTK_LABEL (label), button);

  return add_task;
}

GtkWidget*
create_set_begin_date (void)
{
  GtkWidget *set_begin_date;
  GtkObject *adjustment;
  GtkWidget *vbox_top;
  GtkWidget *radiob1;
  GSList *radiob1_group = NULL;
  GtkWidget *calendar;
  GtkWidget *hbox_time;
  GtkWidget *checkb_time;
  GtkWidget *table_time;
  GtkWidget *spinb_dth;
  GtkWidget *spinb_dtm;
  GtkWidget *spinb_dts;
  GtkWidget *radiob2;
  GtkWidget *table_datetime;
  GtkWidget *spinb_dm;
  GtkWidget *spinb_dd;
  GtkWidget *spinb_th;
  GtkWidget *spinb_tm;
  GtkWidget *label;
  GtkWidget *spinb_ts;
  GtkWidget *hseparator;
  GtkWidget *hbox_buttons;
  GtkWidget *button;
  GtkWidget *image;

  set_begin_date = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_container_set_border_width (GTK_CONTAINER (set_begin_date), 8);
  gtk_window_set_title (GTK_WINDOW (set_begin_date), _("Set begin date"));
  gtk_window_set_resizable (GTK_WINDOW (set_begin_date), FALSE);

  vbox_top = gtk_vbox_new (FALSE, 8);
  gtk_container_add (GTK_CONTAINER (set_begin_date), vbox_top);

  radiob1 = gtk_radio_button_new_with_mnemonic (NULL, _("Set date:"));
  gtk_box_pack_start (GTK_BOX (vbox_top), radiob1, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (radiob1), radiob1_group);
  radiob1_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radiob1));

  calendar = gtk_calendar_new ();
  gtk_box_pack_start (GTK_BOX (vbox_top), calendar, FALSE, TRUE, 0);
/*  gtk_calendar_set_display_options (GTK_CALENDAR (calendar), GTK_CALENDAR_SHOW_HEADING | GTK_CALENDAR_SHOW_DAY_NAMES);*/
  gtk_calendar_set_display_options (GTK_CALENDAR (calendar), GTK_CALENDAR_SHOW_DAY_NAMES);

  hbox_time = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox_top), hbox_time, FALSE, TRUE, 0);

  gtk_widget_set_sensitive (hbox_time, FALSE);
  gtk_widget_set_sensitive (calendar, FALSE);

  checkb_time = gtk_check_button_new_with_mnemonic (_("Set time:"));
  gtk_box_pack_start (GTK_BOX (hbox_time), checkb_time, FALSE, FALSE, 0);

  table_time = gtk_table_new (2, 3, FALSE);
  gtk_box_pack_end (GTK_BOX (hbox_time), table_time, FALSE, TRUE, 0);
  gtk_table_set_col_spacings (GTK_TABLE (table_time), 4);

  label = gtk_label_new (_("<small>Hour</small>"));
  gtk_table_attach (GTK_TABLE (table_time), label, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  label = gtk_label_new (_("<small>Minute</small>"));
  gtk_table_attach (GTK_TABLE (table_time), label, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  label = gtk_label_new (_("<small>Second</small>"));
  gtk_table_attach (GTK_TABLE (table_time), label, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  adjustment = gtk_adjustment_new (0, 0, 100, 1, 10, 0);
  spinb_dth = gtk_spin_button_new (GTK_ADJUSTMENT (adjustment), 1, 0);
  gtk_table_attach (GTK_TABLE (table_time), spinb_dth, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);

  adjustment = gtk_adjustment_new (0, 0, 100, 1, 10, 0);
  spinb_dtm = gtk_spin_button_new (GTK_ADJUSTMENT (adjustment), 1, 0);
  gtk_table_attach (GTK_TABLE (table_time), spinb_dtm, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);

  adjustment = gtk_adjustment_new (0, 0, 100, 1, 10, 0);
  spinb_dts = gtk_spin_button_new (GTK_ADJUSTMENT (adjustment), 1, 0);
  gtk_table_attach (GTK_TABLE (table_time), spinb_dts, 2, 3, 1, 2,
                    (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);

  radiob2 = gtk_radio_button_new_with_mnemonic (NULL, _("Task starts in:/Set running time"));
  gtk_box_pack_start (GTK_BOX (vbox_top), radiob2, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (radiob2), radiob1_group);
  radiob1_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radiob2));

  table_datetime = gtk_table_new (2, 5, FALSE);
  gtk_box_pack_start (GTK_BOX (vbox_top), table_datetime, FALSE, TRUE, 0);
  gtk_table_set_col_spacings (GTK_TABLE (table_datetime), 4);

  label = gtk_label_new (_("<small>Months</small>"));
  gtk_table_attach (GTK_TABLE (table_datetime), label, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  label = gtk_label_new (_("<small>Days</small>"));
  gtk_table_attach (GTK_TABLE (table_datetime), label, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  label = gtk_label_new (_("<small>Hours</small>"));
  gtk_table_attach (GTK_TABLE (table_datetime), label, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  label = gtk_label_new (_("<small>Minutes</small>"));
  gtk_table_attach (GTK_TABLE (table_datetime), label, 3, 4, 0, 1,
                    (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  label = gtk_label_new (_("<small>Seconds</small>"));
  gtk_table_attach (GTK_TABLE (table_datetime), label, 4, 5, 0, 1,
                    (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  adjustment = gtk_adjustment_new (0, 0, 24, 1, 10, 0);
  spinb_dm = gtk_spin_button_new (GTK_ADJUSTMENT (adjustment), 1, 0);
  gtk_table_attach (GTK_TABLE (table_datetime), spinb_dm, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);

  adjustment = gtk_adjustment_new (0, 0, 200, 1, 10, 0);
  spinb_dd = gtk_spin_button_new (GTK_ADJUSTMENT (adjustment), 1, 0);
  gtk_table_attach (GTK_TABLE (table_datetime), spinb_dd, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);

  adjustment = gtk_adjustment_new (0, 0, 23, 1, 10, 0);
  spinb_th = gtk_spin_button_new (GTK_ADJUSTMENT (adjustment), 1, 0);
  gtk_table_attach (GTK_TABLE (table_datetime), spinb_th, 2, 3, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);

  adjustment = gtk_adjustment_new (0, 0, 59, 1, 10, 0);
  spinb_tm = gtk_spin_button_new (GTK_ADJUSTMENT (adjustment), 1, 0);
  gtk_table_attach (GTK_TABLE (table_datetime), spinb_tm, 3, 4, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);

  adjustment = gtk_adjustment_new (0, 0, 59, 1, 10, 0);
  spinb_ts = gtk_spin_button_new (GTK_ADJUSTMENT (adjustment), 1, 0);
  gtk_table_attach (GTK_TABLE (table_datetime), spinb_ts, 4, 5, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);

  hseparator = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (vbox_top), hseparator, FALSE, TRUE, 0);

  hbox_buttons = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox_top), hbox_buttons, FALSE, TRUE, 0);

  button = gtk_button_new ();
  gtk_box_pack_start (GTK_BOX (hbox_buttons), button, FALSE, FALSE, 0);

  label = gtk_label_new_with_mnemonic (_("Today"));
  gtk_container_add (GTK_CONTAINER (button), label);

  button = gtk_button_new ();
  gtk_box_pack_start (GTK_BOX (hbox_buttons), button, FALSE, FALSE, 0);

  label = gtk_label_new_with_mnemonic (_("Tommorow"));
  gtk_container_add (GTK_CONTAINER (button), label);

  button = gtk_button_new ();
  gtk_box_pack_start (GTK_BOX (hbox_buttons), button, FALSE, FALSE, 0);

  label = gtk_label_new_with_mnemonic (_("No date"));
  gtk_container_add (GTK_CONTAINER (button), label);

  button = gtk_button_new ();
  gtk_box_pack_end (GTK_BOX (hbox_buttons), button, FALSE, FALSE, 0);
  gtk_button_set_relief (GTK_BUTTON (button), GTK_RELIEF_NONE);

  image = gtk_image_new_from_stock ("gtk-ok", GTK_ICON_SIZE_BUTTON);
  gtk_container_add (GTK_CONTAINER (button), image);

  button = gtk_button_new ();
  gtk_box_pack_end (GTK_BOX (hbox_buttons), button, FALSE, FALSE, 0);
  gtk_button_set_relief (GTK_BUTTON (button), GTK_RELIEF_NONE);

  image = gtk_image_new_from_stock ("gtk-cancel", GTK_ICON_SIZE_BUTTON);
  gtk_container_add (GTK_CONTAINER (button), image);

  gtk_widget_set_sensitive (table_datetime, FALSE);
  return set_begin_date;
}

GtkWidget*
create_set_time_period (void)
{
  GtkWidget *set_time_period;
  GtkWidget *vbox_top;
  GtkWidget *table;
  GtkWidget *label;
  GtkWidget *spinb_bh;
  GtkWidget *spinb_eh;
  GtkWidget *spinb_ih;
  GtkWidget *spinb_im;
  GtkWidget *spinb_em;
  GtkWidget *spinb_bm;
  GtkWidget *spinb_bs;
  GtkObject *adjustment;
  GtkWidget *spinb_es;
  GtkWidget *spinb_is;
  GtkWidget *hseparator;
  GtkWidget *hbuttonbox;
  GtkWidget *button;

  set_time_period = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_container_set_border_width (GTK_CONTAINER (set_time_period), 8);
  gtk_window_set_title (GTK_WINDOW (set_time_period), _("Set time period"));
  gtk_window_set_resizable (GTK_WINDOW (set_time_period), FALSE);

  vbox_top = gtk_vbox_new (FALSE, 8);
  gtk_container_add (GTK_CONTAINER (set_time_period), vbox_top);

  table = gtk_table_new (4, 4, FALSE);
  gtk_box_pack_start (GTK_BOX (vbox_top), table, TRUE, TRUE, 0);
  gtk_table_set_row_spacings (GTK_TABLE (table), 4);
  gtk_table_set_col_spacings (GTK_TABLE (table), 8);

  label = gtk_label_new (_("<small>Hour</small>"));
  gtk_table_attach (GTK_TABLE (table), label, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  label = gtk_label_new (_("<small>Minute</small>"));
  gtk_table_attach (GTK_TABLE (table), label, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  label = gtk_label_new (_("<small>Second</small>"));
  gtk_table_attach (GTK_TABLE (table), label, 3, 4, 0, 1,
                    (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  label = gtk_label_new (_("Begin at:"));
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  adjustment = gtk_adjustment_new (0, 0, 23, 1, 10, 0);
  spinb_bh = gtk_spin_button_new (GTK_ADJUSTMENT (adjustment), 1, 0);
  gtk_table_attach (GTK_TABLE (table), spinb_bh, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);

  adjustment = gtk_adjustment_new (0, 0, 59, 1, 10, 0);
  spinb_bm = gtk_spin_button_new (GTK_ADJUSTMENT (adjustment), 1, 0);
  gtk_table_attach (GTK_TABLE (table), spinb_bm, 2, 3, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);

  adjustment = gtk_adjustment_new (0, 0, 59, 1, 10, 0);
  spinb_bs = gtk_spin_button_new (GTK_ADJUSTMENT (adjustment), 1, 0);
  gtk_table_attach (GTK_TABLE (table), spinb_bs, 3, 4, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);

  label = gtk_label_new (_("End at:"));
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  adjustment = gtk_adjustment_new (0, 0, 23, 1, 10, 0);
  spinb_eh = gtk_spin_button_new (GTK_ADJUSTMENT (adjustment), 1, 0);
  gtk_table_attach (GTK_TABLE (table), spinb_eh, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);

  adjustment = gtk_adjustment_new (0, 0, 59, 1, 10, 0);
  spinb_em = gtk_spin_button_new (GTK_ADJUSTMENT (adjustment), 1, 0);
  gtk_table_attach (GTK_TABLE (table), spinb_em, 2, 3, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);

  adjustment = gtk_adjustment_new (0, 0, 59, 1, 10, 0);
  spinb_es = gtk_spin_button_new (GTK_ADJUSTMENT (adjustment), 1, 0);
  gtk_table_attach (GTK_TABLE (table), spinb_es, 3, 4, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);

  label = gtk_label_new (_("Interval:"));
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

  adjustment = gtk_adjustment_new (0, 0, 23, 1, 10, 0);
  spinb_ih = gtk_spin_button_new (GTK_ADJUSTMENT (adjustment), 1, 0);
  gtk_table_attach (GTK_TABLE (table), spinb_ih, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);

  adjustment = gtk_adjustment_new (0, 0, 59, 1, 10, 0);
  spinb_im = gtk_spin_button_new (GTK_ADJUSTMENT (adjustment), 1, 0);
  gtk_table_attach (GTK_TABLE (table), spinb_im, 2, 3, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);

  adjustment = gtk_adjustment_new (0, 0, 59, 1, 10, 0);
  spinb_is = gtk_spin_button_new (GTK_ADJUSTMENT (adjustment), 1, 0);
  gtk_table_attach (GTK_TABLE (table), spinb_is, 3, 4, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);

  hseparator = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (vbox_top), hseparator, TRUE, TRUE, 0);

  hbuttonbox = gtk_hbutton_box_new ();
  gtk_box_pack_start (GTK_BOX (vbox_top), hbuttonbox, TRUE, TRUE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox), GTK_BUTTONBOX_END);
  gtk_box_set_spacing (GTK_BOX (hbuttonbox), 8);

  button = gtk_button_new_from_stock ("gtk-cancel");
  gtk_container_add (GTK_CONTAINER (hbuttonbox), button);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);

  button = gtk_button_new_from_stock ("gtk-clear");
  gtk_container_add (GTK_CONTAINER (hbuttonbox), button);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);

  button = gtk_button_new_from_stock ("gtk-ok");
  gtk_container_add (GTK_CONTAINER (hbuttonbox), button);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);

  return set_time_period;
}

