/* This file is part of the Palabos library.
 *
 * Copyright (C) 2011-2015 FlowKit Sarl
 * Route d'Oron 2
 * 1010 Lausanne, Switzerland
 * E-mail contact: contact@flowkit.com
 *
 * The most recent release of Palabos can be downloaded at 
 * <http://www.palabos.org/>
 *
 * The library Palabos is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * The library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifdef COMPILE_3D

#include "multiBlock/nonLocalTransfer3D.h"
#include "multiBlock/nonLocalTransfer3D.hh"
#include "latticeBoltzmann/nearestNeighborLattices3D.h"
#include "latticeBoltzmann/nearestNeighborLattices3D.hh"

namespace plb {

template
void copyNonLocal<FLOAT_T,descriptors::DESCRIPTOR_3D> (
        MultiBlockLattice3D<FLOAT_T,descriptors::DESCRIPTOR_3D> const& from,
        MultiBlockLattice3D<FLOAT_T,descriptors::DESCRIPTOR_3D>& to, Box3D const& domain,
        modif::ModifT whichContent );

template
void copy<FLOAT_T,descriptors::DESCRIPTOR_3D> (
        MultiBlockLattice3D<FLOAT_T,descriptors::DESCRIPTOR_3D> const& from, Box3D const& fromDomain,
        MultiBlockLattice3D<FLOAT_T,descriptors::DESCRIPTOR_3D>& to, Box3D const& toDomain,
        modif::ModifT typeOfModif );

template
void copyPopulations<FLOAT_T,descriptors::DESCRIPTOR_3D> (
        MultiBlockLattice3D<FLOAT_T,descriptors::DESCRIPTOR_3D> const& from, Box3D const& fromDomain,
        MultiBlockLattice3D<FLOAT_T,descriptors::DESCRIPTOR_3D>& to, Box3D const& toDomain );

template
void copyAll<FLOAT_T,descriptors::DESCRIPTOR_3D> (
        MultiBlockLattice3D<FLOAT_T,descriptors::DESCRIPTOR_3D> const& from, Box3D const& fromDomain,
        MultiBlockLattice3D<FLOAT_T,descriptors::DESCRIPTOR_3D>& to, Box3D const& toDomain );

template
void copyRegenerate<FLOAT_T,descriptors::DESCRIPTOR_3D> (
        MultiBlockLattice3D<FLOAT_T,descriptors::DESCRIPTOR_3D> const& from, Box3D const& fromDomain,
        MultiBlockLattice3D<FLOAT_T,descriptors::DESCRIPTOR_3D>& to, Box3D const& toDomain );

}

#endif  // COMPILE_3D
