% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{nbinomLRT}
\alias{nbinomLRT}
\title{Likelihood ratio test (chi-squared test) for GLMs}
\usage{
nbinomLRT(object, full = design(object), reduced, betaTol = 1e-08,
  maxit = 100, useOptim = TRUE, quiet = FALSE, useQR = TRUE,
  minmu = 0.5)
}
\arguments{
\item{object}{a DESeqDataSet}

\item{full}{the full model formula, this should be the formula in
\code{design(object)}.
alternatively, can be a matrix}

\item{reduced}{a reduced formula to compare against, e.g.
the full model with a term or terms of interest removed.
alternatively, can be a matrix}

\item{betaTol}{control parameter defining convergence}

\item{maxit}{the maximum number of iterations to allow for convergence of the
coefficient vector}

\item{useOptim}{whether to use the native optim function on rows which do not
converge within maxit}

\item{quiet}{whether to print messages at each step}

\item{useQR}{whether to use the QR decomposition on the design
matrix X while fitting the GLM}

\item{minmu}{lower bound on the estimated count while fitting the GLM}
}
\value{
a DESeqDataSet with new results columns accessible
with the \code{\link{results}} function.  The coefficients and standard errors are
reported on a log2 scale.
}
\description{
This function tests for significance of change in deviance between a
full and reduced model which are provided as \code{formula}.
Fitting uses previously calculated \code{\link{sizeFactors}} (or \code{\link{normalizationFactors}})
and dispersion estimates.
}
\details{
The difference in deviance is compared to a chi-squared distribution
with df = (reduced residual degrees of freedom - full residual degrees of freedom).
This function is comparable to the \code{nbinomGLMTest} of the previous version of DESeq
and an alternative to the default \code{\link{nbinomWaldTest}}.
}
\examples{

dds <- makeExampleDESeqDataSet()
dds <- estimateSizeFactors(dds)
dds <- estimateDispersions(dds)
dds <- nbinomLRT(dds, reduced = ~ 1)
res <- results(dds)

}
\seealso{
\code{\link{DESeq}}, \code{\link{nbinomWaldTest}}
}
