% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RangeTrack-class.R
\docType{class}
\name{RangeTrack-class}
\alias{RangeTrack-class}
\alias{initialize,RangeTrack-method}
\alias{ranges,RangeTrack-method}
\alias{range,RangeTrack-method}
\alias{seqnames,RangeTrack-method}
\alias{seqlevels,RangeTrack-method}
\alias{seqinfo,RangeTrack-method}
\alias{genome,RangeTrack-method}
\alias{genome<-,RangeTrack-method}
\alias{chromosome,RangeTrack-method}
\alias{chromosome<-,RangeTrack-method}
\alias{start,RangeTrack-method}
\alias{start<-,RangeTrack-method}
\alias{end,RangeTrack-method}
\alias{end<-,RangeTrack-method}
\alias{width,RangeTrack-method}
\alias{width<-,RangeTrack-method}
\alias{min,RangeTrack-method}
\alias{max,RangeTrack-method}
\alias{length,RangeTrack-method}
\alias{strand,RangeTrack-method}
\alias{strand<-,RangeTrack,ANY-method}
\alias{position,RangeTrack-method}
\alias{[,RangeTrack,ANY,ANY,ANY-method}
\alias{subset,RangeTrack-method}
\alias{split,RangeTrack,ANY-method}
\alias{values,RangeTrack-method}
\alias{feature,RangeTrack-method}
\alias{feature<-,RangeTrack,character-method}
\alias{consolidateTrack,RangeTrack-method}
\title{RangeTrack class and methods}
\usage{
\S4method{initialize}{RangeTrack}(.Object, range, chromosome, genome, ...)

\S4method{ranges}{RangeTrack}(x)

\S4method{range}{RangeTrack}(x)

\S4method{seqnames}{RangeTrack}(x)

\S4method{seqlevels}{RangeTrack}(x)

\S4method{seqinfo}{RangeTrack}(x)

\S4method{genome}{RangeTrack}(x)

\S4method{genome}{RangeTrack}(x) <- value

\S4method{chromosome}{RangeTrack}(GdObject)

\S4method{chromosome}{RangeTrack}(GdObject) <- value

\S4method{start}{RangeTrack}(x)

\S4method{start}{RangeTrack}(x) <- value

\S4method{end}{RangeTrack}(x)

\S4method{end}{RangeTrack}(x) <- value

\S4method{width}{RangeTrack}(x)

\S4method{width}{RangeTrack}(x) <- value

\S4method{min}{RangeTrack}(x)

\S4method{max}{RangeTrack}(x)

\S4method{length}{RangeTrack}(x)

\S4method{strand}{RangeTrack}(x)

\S4method{strand}{RangeTrack,ANY}(x) <- value

\S4method{position}{RangeTrack}(GdObject, from = NULL, to = NULL, sort = FALSE, ...)

\S4method{[}{RangeTrack,ANY,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{subset}{RangeTrack}(
  x,
  from = NULL,
  to = NULL,
  sort = FALSE,
  drop = TRUE,
  use.defaults = TRUE,
  ...
)

\S4method{split}{RangeTrack,ANY}(x, f, drop = FALSE, ...)

\S4method{values}{RangeTrack}(x)

\S4method{feature}{RangeTrack}(GdObject)

\S4method{feature}{RangeTrack,character}(GdObject) <- value

\S4method{consolidateTrack}{RangeTrack}(GdObject, chromosome, ...)
}
\arguments{
\item{.Object}{.Object}

\item{range}{range}

\item{chromosome}{the currently active chromosome which may have to be set
for a \code{RangeTrack} or a \code{SequenceTrack} object
parameters}

\item{genome}{genome}

\item{...}{Additional arguments.}

\item{x}{A valid track object class name, or the object itself, in which
case the class is derived directly from it.}

\item{value}{Value to be set.}

\item{GdObject}{the input track object}

\item{from, to}{Numeric scalar, giving the range of genomic coordinates to
limit the tracks in. Note that \code{to} cannot be larger than \code{from.}}

\item{sort}{\code{logical}.}

\item{i}{Numeric scalar, index to subset.}

\item{j}{Numeric scalar, index to subset. Ignored.}

\item{drop}{\code{logical}, indicating if levels that do not occur should be dropped (if \code{f} is a factor).}

\item{use.defaults}{\code{logical}.}

\item{f}{\code{factor} in the sense that \code{as.factor(f)} defines the grouping,}
}
\value{
A virtual class: No objects may be created from it.
}
\description{
The virtual parent class for all track items in the Gviz package that
contain some form of genomic ranges (start, end, strand, chromosome
and the associated genome.)
}
\section{Functions}{
\itemize{
\item \code{initialize(RangeTrack)}: Initialize.

\item \code{ranges(RangeTrack)}: return the genomic coordinates for the track
along with all additional annotation information as an object of
class \code{GRanges.}

\item \code{range(RangeTrack)}: return the genomic coordinates for the
track as an object of class IRanges.

\item \code{seqnames(RangeTrack)}: return the track's seqnames.

\item \code{seqlevels(RangeTrack)}: return the track's seqlevels.

\item \code{seqinfo(RangeTrack)}: return the track's seqinfo.

\item \code{genome(RangeTrack)}: return the track's genome.

\item \code{genome(RangeTrack) <- value}: set the track's genome. Usually this has to
be a valid UCSC identifier, however this is not formally enforced here.

\item \code{chromosome(RangeTrack)}: return the chromosome for which the track is defined.

\item \code{chromosome(RangeTrack) <- value}: replace the value of the track's chromosome.
This has to be a valid UCSC chromosome identifier or an integer or character
scalar that can be reasonably coerced into one.

\item \code{start(RangeTrack)}: the start of the track items in genomic
coordinates.

\item \code{start(RangeTrack) <- value}: replace the start of the track items in
genomic coordinates.

\item \code{end(RangeTrack)}: the end of the track items in genomic
coordinates.

\item \code{end(RangeTrack) <- value}: replace the end of the track items in
genomic coordinates.

\item \code{width(RangeTrack)}: the width of the track items in genomic
coordinates.

\item \code{width(RangeTrack) <- value}: replace the width of the track items in genomic
coordinates.

\item \code{min(RangeTrack)}: return the start position for the leftmost range item.

\item \code{max(RangeTrack)}: return the end position for the rightmost range item.

\item \code{length(RangeTrack)}: return the number of items in the track.

\item \code{strand(RangeTrack)}: return a vector of strand specifiers for all
track items, in the form '+' for the Watson strand, '-' for the Crick
strand or '*' for either of the two.

\item \code{strand(x = RangeTrack) <- value}: replace the strand information for the track
items. The replacement value needs to be an appropriate scalar or vector
of strand values.

\item \code{position(RangeTrack)}: the arithmetic mean of the track item's
coordionates, i.e., \code{(end(obj)-start(obj))/2}.

\item \code{x[i}: subset the items in the \code{RangeTrack} object.
This is essentially similar to subsetting of the \code{GRanges} object in the
\code{range} slot. For most applications, the subset method may be more appropriate.

\item \code{subset(RangeTrack)}: subset a \code{RangeTrack} by coordinates and
sort if necessary.

\item \code{split(x = RangeTrack, f = ANY)}: split a \code{RangeTrack} object by an appropriate
factor vector (or another vector that can be coerced into one). The output
of this operation is a list of objects of the same class as the input
object, all inheriting from class \code{RangeTrack.}

\item \code{values(RangeTrack)}: return all additional annotation information
except for the genomic coordinates for the track items as a \code{data.frame}.

\item \code{feature(RangeTrack)}: return the grouping information for track
items. For certain sub-classes, groups may be indicated by different colour
schemes when plotting. See grouping or \code{AnnotationTrack} and
\code{GeneRegionTrack} for details.
@export

\item \code{feature(GdObject = RangeTrack) <- value}: set the grouping information for track items.
This has to be a factor vector (or another type of vector that can be
coerced into one) of the same length as the number of items in the
\code{RangeTrack.} See grouping or \code{AnnotationTrack} and \code{GeneRegionTrack} for
details.
@export

\item \code{consolidateTrack(RangeTrack)}: Consolidate.

}}
\section{Slots}{

\describe{
\item{\code{dp}}{Object of \code{DisplayPars-class}, the display settings controlling the
look and feel of a track. See settings for details on setting graphical
parameters for tracks.}

\item{\code{name}}{Object of class \code{character}, a human-readable name for the track
that will be used in the track's annotation panel if necessary.}

\item{\code{imageMap}}{Object of \code{ImageMap-class}, containing optional information
for an HTML image map. This will be created by the \code{drawGD} methods when the
track is plotted to a device and is usually not set by the user.}

\item{\code{range}}{Object of class \code{GRanges}, the genomic ranges of the track items
as well as additional annotation information in its \code{elementMetaData} slot.
Please not that the slot is actually implemented as a class union between
\code{GRanges} and IRanges to increase efficiency, for instance for DataTrack
objects. This usually does not concern the user.}

\item{\code{chromosome}}{Object of class \code{character}, the chromosome on which the
track is defined. There can only be a single chromosome for one track. For
certain subclasses, the space of allowed chromosome names is limited (e.g.,
only those chromosomes that exist for a particular genome). Throughout the
package, chromosome name have to be entered either as a single integer scalar
or as a character scalar of the form chrXYZ, where XYZ may be an arbitrary
character string.}

\item{\code{genome}}{Object of class \code{character}, the genome for which the track is
defined. For most sub-classes this has to be valid UCSC genome identifier,
however this may not always be formally checked upon object instantiation.}
}}

\examples{
## This is a reference class therefore we show below
## an example from AnnotationTrack

## An empty object
AnnotationTrack()

## Construct from individual arguments
st <- c(2000000, 2070000, 2100000, 2160000)
ed <- c(2050000, 2130000, 2150000, 2170000)
str <- c("-", "+", "-", "-")
gr <- c("Group1", "Group2", "Group1", "Group3")

annTrack <- AnnotationTrack(
    start = st, end = ed, strand = str, chromosome = 7,
    genome = "hg19", feature = "test", group = gr,
    id = paste("annTrack item", 1:4),
    name = "generic annotation", stacking = "squish"
)
\dontshow{
## For some annoying reason the postscript device does not know about
## the sans font
if (!interactive()) {
    font <- ps.options()$family
    displayPars(annTrack) <- list(fontfamily = font, fontfamily.title = font)
}
}

## Plotting
plotTracks(annTrack)
}
\seealso{
\code{\linkS4class{DisplayPars}}

\code{\linkS4class{GdObject}}

\code{\linkS4class{GRanges}}

\code{\linkS4class{HighlightTrack}}

\code{\linkS4class{ImageMap}}

\code{\linkS4class{IRanges}}

\code{\linkS4class{RangeTrack}}

\code{\linkS4class{DataTrack}}

\code{\link{collapsing}}

\code{\link{grouping}}

\code{\link{panel.grid}}

\code{\link{plotTracks}}

\code{\link{settings}}
}
\author{
Florian Hahne
}
