% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_junction.R
\name{read_junction_table}
\alias{read_junction_table}
\title{Read a junction TSV file created by Megadepth as a table}
\usage{
read_junction_table(tsv_file)
}
\arguments{
\item{tsv_file}{A \code{character(1)} specifying the path to the tab-separated
(TSV) file created manually using \code{megadepth_shell()} or on a previous
\code{bam_to_junctions()} run.}
}
\value{
A \code{tibble::tibble()} with the junction data that follows the format
specified at \url{https://github.com/ChristopherWilks/megadepth#junctions}.
}
\description{
Read an \verb{*all_jxs.tsv} or \verb{*jxs.tsv} file created by \code{bam_to_junctions()} or
manually by the user using Megadepth. The rows of a \verb{*jxs.tsv} can have
either 7 or 14 columns, which can lead to warnings when reading in - these
are safe to ignore. For details on the format of the input TSV file, check
\url{https://github.com/ChristopherWilks/megadepth#junctions}.
}
\examples{

## Install if necessary
install_megadepth()

## Find the example BAM file
example_bam <- system.file("tests", "test.bam",
    package = "megadepth", mustWork = TRUE
)

## Run bam_to_junctions()
example_jxs <- bam_to_junctions(example_bam, overwrite = TRUE)

## Read the junctions in as a tibble
all_jxs <- read_junction_table(example_jxs[["all_jxs.tsv"]])

all_jxs
}
