% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildSNNGraph.R
\docType{methods}
\name{buildSNNGraph}
\alias{buildSNNGraph}
\alias{buildSNNGraph,ANY-method}
\alias{buildSNNGraph,SummarizedExperiment-method}
\alias{buildSNNGraph,SingleCellExperiment-method}
\alias{buildKNNGraph}
\alias{buildKNNGraph,ANY-method}
\alias{buildKNNGraph,SingleCellExperiment-method}
\title{Build a nearest-neighbor graph}
\usage{
buildSNNGraph(x, ...)

\S4method{buildSNNGraph}{ANY}(
  x,
  ...,
  d = 50,
  transposed = FALSE,
  subset.row = NULL,
  BSPARAM = bsparam(),
  BPPARAM = SerialParam()
)

\S4method{buildSNNGraph}{SummarizedExperiment}(x, ..., assay.type = "logcounts")

\S4method{buildSNNGraph}{SingleCellExperiment}(x, ..., use.dimred = NULL)

buildKNNGraph(x, ...)

\S4method{buildKNNGraph}{ANY}(
  x,
  ...,
  d = 50,
  transposed = FALSE,
  subset.row = NULL,
  BSPARAM = bsparam(),
  BPPARAM = SerialParam()
)

\S4method{buildKNNGraph}{SingleCellExperiment}(x, ..., use.dimred = NULL)

\S4method{buildKNNGraph}{SingleCellExperiment}(x, ..., use.dimred = NULL)
}
\arguments{
\item{x}{A matrix-like object containing expression values for each gene (row) in each cell (column).
These dimensions can be transposed if \code{transposed=TRUE}.

Alternatively, a \linkS4class{SummarizedExperiment} or \linkS4class{SingleCellExperiment} containing such an expression matrix.
If \code{x} is a SingleCellExperiment and \code{use.dimred} is set, its \code{\link{reducedDims}} will be used instead.}

\item{...}{For the generics, additional arguments to pass to the specific methods.

For the ANY methods, additional arguments to pass to \code{\link{makeSNNGraph}} or \code{\link{makeKNNGraph}}.

For the SummarizedExperiment methods, additional arguments to pass to the corresponding ANY method.

For the SingleCellExperiment methods, additional arguments to pass to the corresponding SummarizedExperiment method.}

\item{d}{An integer scalar specifying the number of dimensions to use for a PCA on the expression matrix prior to the nearest neighbor search.
Ignored for the ANY method if \code{transposed=TRUE} and for the SingleCellExperiment methods if \code{use.dimred} is set.}

\item{transposed}{A logical scalar indicating whether \code{x} is transposed (i.e., rows are cells).}

\item{subset.row}{See \code{?"\link{scran-gene-selection}"}.
Only used when \code{transposed=FALSE}.}

\item{BSPARAM}{A \linkS4class{BiocSingularParam} object specifying the algorithm to use for PCA, if \code{d} is not \code{NA}.}

\item{BPPARAM}{A \linkS4class{BiocParallelParam} object to use for parallel processing.}

\item{assay.type}{A string specifying which assay values to use.}

\item{use.dimred}{A string specifying whether existing values in \code{reducedDims(x)} should be used.}
}
\value{
A \link{graph} where nodes are cells and edges represent connections between nearest neighbors,
see \code{?\link{makeSNNGraph}} for more details.
}
\description{
\linkS4class{SingleCellExperiment}-friendly wrapper around the \code{\link{makeSNNGraph}} and \code{\link{makeKNNGraph}} functions for creating nearest-neighbor graphs.
}
\examples{
library(scuttle)
sce <- mockSCE(ncells=500)
sce <- logNormCounts(sce)

g <- buildSNNGraph(sce)
clusters <- igraph::cluster_fast_greedy(g)$membership
table(clusters)

# Any clustering method from igraph can be used:
clusters <- igraph::cluster_walktrap(g)$membership
table(clusters)

# Smaller 'k' usually yields finer clusters:
g <- buildSNNGraph(sce, k=5)
clusters <- igraph::cluster_walktrap(g)$membership
table(clusters)

# Graph can be built off existing reducedDims results:
sce <- scater::runPCA(sce)
g <- buildSNNGraph(sce, use.dimred="PCA")
clusters <- igraph::cluster_fast_greedy(g)$membership
table(clusters)

}
\seealso{
\code{\link{makeSNNGraph}} and \code{\link{makeKNNGraph}}, for the underlying functions that do the work.

See \code{\link{cluster_walktrap}} and related functions in \pkg{igraph} for clustering based on the produced graph.

\code{\link{clusterCells}}, for a more succinct way of performing graph-based clustering.
}
\author{
Aaron Lun
}
